// java wrapper for vtkMath object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMath.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMath_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMath",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMath_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMath_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_DYNAMIC_1VECTOR_1SIZE_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DYNAMIC_VECTOR_SIZE();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Pi_15(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pi();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_RadiansFromDegrees_16(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  float   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RadiansFromDegrees(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_RadiansFromDegrees_17(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  double   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RadiansFromDegrees(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_DegreesFromRadians_18(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  float   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DegreesFromRadians(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_DegreesFromRadians_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  double   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DegreesFromRadians(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_Round_110(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  int   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Round(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_Round_111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  int   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Round(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_Floor_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  int   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Floor(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_Ceil_113(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  int   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Ceil(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_CeilLog2_114(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CeilLog2(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMath_IsPowerOfTwo_115(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPowerOfTwo(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_NearestPowerOfTwo_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NearestPowerOfTwo(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMath_Factorial_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Factorial(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMath_Binomial_118(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Binomial(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RandomSeed_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RandomSeed(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_GetSeed_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSeed();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Random_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Random();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Random_122(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Random(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Gaussian_123(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Gaussian();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Gaussian_124(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Gaussian(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_Assign_125(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Assign(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_Add_126(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[3];
  float temp1[3];
  float temp2[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Add(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_Add_127(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Add(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_Subtract_128(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[3];
  float temp1[3];
  float temp2[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Subtract(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_Subtract_129(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Subtract(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_MultiplyScalar_130(JNIEnv* env, jobject obj,jfloatArray id0,jfloat id1)
{
  float temp0[3];
  float   temp1;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyScalar(temp0,temp1);
  env->SetFloatArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_MultiplyScalar2D_131(JNIEnv* env, jobject obj,jfloatArray id0,jfloat id1)
{
  float temp0[2];
  float   temp1;
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyScalar2D(temp0,temp1);
  env->SetFloatArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_MultiplyScalar_132(JNIEnv* env, jobject obj,jdoubleArray id0,jdouble id1)
{
  double temp0[3];
  double   temp1;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyScalar(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_MultiplyScalar2D_133(JNIEnv* env, jobject obj,jdoubleArray id0,jdouble id1)
{
  double temp0[2];
  double   temp1;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyScalar2D(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_Dot_134(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  float   temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Dot(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Dot_135(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Dot(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_Cross_136(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[3];
  float temp1[3];
  float temp2[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Cross(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_Cross_137(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Cross(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_Norm_138(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  float   temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Norm(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Norm_139(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Norm(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_Normalize_140(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[3];
  float   temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Normalize(temp0);
  env->SetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Normalize_141(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Normalize(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_Perpendiculars_142(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdouble id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double   temp3;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  temp3 = id3;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Perpendiculars(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_Perpendiculars_143(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2,jdouble id3)
{
  float temp0[3];
  float temp1[3];
  float temp2[3];
  double   temp3;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);
  temp3 = id3;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->Perpendiculars(temp0,temp1,temp2,temp3);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMath_ProjectVector_144(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[3];
  float temp1[3];
  float temp2[3];
  bool   temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ProjectVector(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMath_ProjectVector_145(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ProjectVector(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMath_ProjectVector2D_146(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[2];
  float temp1[2];
  float temp2[2];
  bool   temp20;
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 2, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ProjectVector2D(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 2, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMath_ProjectVector2D_147(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[2];
  double temp1[2];
  double temp2[2];
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 2, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ProjectVector2D(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 2, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_Distance2BetweenPoints_148(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  float   temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Distance2BetweenPoints(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Distance2BetweenPoints_149(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Distance2BetweenPoints(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_AngleBetweenVectors_150(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AngleBetweenVectors(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_SignedAngleBetweenVectors_151(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SignedAngleBetweenVectors(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_GaussianAmplitude_152(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GaussianAmplitude(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_GaussianAmplitude_153(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GaussianAmplitude(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_GaussianWeight_154(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GaussianWeight(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_GaussianWeight_155(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GaussianWeight(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_Dot2D_156(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[2];
  float temp1[2];
  float   temp20;
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Dot2D(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Dot2D_157(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[2];
  double temp1[2];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Dot2D(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_Norm2D_158(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  float   temp20;
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Norm2D(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Norm2D_159(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Norm2D(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_Normalize2D_160(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  float   temp20;
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Normalize2D(temp0);
  env->SetFloatArrayRegion(id0, 0, 2, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Normalize2D_161(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Normalize2D(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_Determinant2x2_162(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[2];
  float temp1[2];
  float   temp20;
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant2x2(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Determinant2x2_163(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant2x2(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Determinant2x2_164(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[2];
  double temp1[2];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant2x2(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkMath_Determinant3x3_165(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[3];
  float temp1[3];
  float temp2[3];
  float   temp20;
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant3x3(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Determinant3x3_166(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant3x3(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Determinant3x3_167(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6,jdouble id7,jdouble id8)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  double   temp7;
  double   temp8;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;
  temp8 = id8;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Determinant3x3(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_MultiplyQuaternion_168(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[4];
  float temp1[4];
  float temp2[4];
  env->GetFloatArrayRegion(id0, 0, 4, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 4, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyQuaternion(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 4, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_MultiplyQuaternion_169(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[4];
  double temp1[4];
  double temp2[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 4, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->MultiplyQuaternion(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 4, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RotateVectorByNormalizedQuaternion_170(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[3];
  float temp1[4];
  float temp2[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateVectorByNormalizedQuaternion(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RotateVectorByNormalizedQuaternion_171(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[4];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateVectorByNormalizedQuaternion(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RotateVectorByWXYZ_172(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1,jfloatArray id2)
{
  float temp0[3];
  float temp1[4];
  float temp2[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);
  env->GetFloatArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateVectorByWXYZ(temp0,temp1,temp2);
  env->SetFloatArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RotateVectorByWXYZ_173(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[4];
  double temp2[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RotateVectorByWXYZ(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RGBToHSV_174(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RGBToHSV(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RGBToHSV_175(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RGBToHSV(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_HSVToRGB_176(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->HSVToRGB(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_HSVToRGB_177(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->HSVToRGB(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_ProLabToXYZ_178(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProLabToXYZ(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_XYZToProLab_179(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->XYZToProLab(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_LabToXYZ_180(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->LabToXYZ(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_XYZToLab_181(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->XYZToLab(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_XYZToRGB_182(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->XYZToRGB(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RGBToXYZ_183(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RGBToXYZ(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RGBToLab_184(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RGBToLab(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_ProLabToRGB_185(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->ProLabToRGB(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_RGBToProLab_186(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->RGBToProLab(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_LabToRGB_187(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->LabToRGB(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_UninitializeBounds_188(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->UninitializeBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_AreBoundsInitialized_189(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AreBoundsInitialized(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_ClampAndNormalizeValue_190(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1)
{
  double   temp0;
  double temp1[2];
  double   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ClampAndNormalizeValue(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_GetScalarTypeFittingRange_191(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarTypeFittingRange(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_GetAdjustedScalarRange_192(JNIEnv* env, jobject obj,jobject id0,jint id1,jdoubleArray id2)
{
  vtkDataArray * temp0;
  int   temp1;
  double temp2[2];
  int   temp20;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  env->GetDoubleArrayRegion(id2, 0, 2, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustedScalarRange(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 2, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_ExtentIsWithinOtherExtent_193(JNIEnv* env, jobject obj,jintArray id0,jintArray id1)
{
  int temp0[6];
  int temp1[6];
  int   temp20;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  env->GetIntArrayRegion(id1, 0, 6, reinterpret_cast<jint*>(&temp1[0]));

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtentIsWithinOtherExtent(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_BoundsIsWithinOtherBounds_194(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[6];
  double temp1[6];
  double temp2[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->BoundsIsWithinOtherBounds(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_PointIsWithinBounds_195(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[3];
  double temp1[6];
  double temp2[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PointIsWithinBounds(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_PlaneIntersectsAABB_196(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2)
{
  double temp0[6];
  double temp1[3];
  double temp2[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->PlaneIntersectsAABB(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Solve3PointCircle_197(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Solve3PointCircle(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Inf_198(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Inf();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_NegInf_199(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NegInf();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMath_Nan_1100(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Nan();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_IsInf_1101(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  int   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsInf(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMath_IsNan_1102(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  int   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsNan(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMath_IsFinite_1103(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  bool   temp20;
  temp0 = id0;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsFinite(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMath_ComputeGCD_1104(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeGCD(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMath_GetPointAlongLine_1105(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdoubleArray id2,jdouble id3)
{
  double temp0[3];
  double temp1[3];
  double temp2[3];
  double   temp3;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  temp3 = id3;

  vtkMath* op = static_cast<vtkMath*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointAlongLine(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMath_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMath::New());
}
