// java wrapper for vtkDataArraySelection object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataArraySelection.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataArraySelection_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataArraySelection",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArraySelection_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataArraySelection_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_EnableArray_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableArray(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_DisableArray_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableArray(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_ArrayIsEnabled_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ArrayIsEnabled(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_ArrayExists_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ArrayExists(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_EnableAllArrays_18(JNIEnv* env, jobject obj)
{

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_DisableAllArrays_19(JNIEnv* env, jobject obj)
{

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllArrays();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_GetNumberOfArrays_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_GetNumberOfArraysEnabled_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfArraysEnabled();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDataArraySelection_GetArrayName_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_GetArrayIndex_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayIndex(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_GetEnabledArrayIndex_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnabledArrayIndex(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_GetArraySetting_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArraySetting(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_GetArraySetting_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArraySetting(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_SetArraySetting_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArraySetting(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_RemoveAllArrays_118(JNIEnv* env, jobject obj)
{

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllArrays();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_AddArray_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jboolean id1)
{
  char * temp0;
  bool   temp1;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = (id1 != 0) ? true : false;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddArray(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_RemoveArrayByIndex_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveArrayByIndex(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_RemoveArrayByName_121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveArrayByName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_CopySelections_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArraySelection * temp0;
  temp0 = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopySelections(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_Union_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArraySelection * temp0;
  temp0 = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->Union(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_Union_124(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkDataArraySelection * temp0;
  bool   temp1;
  temp0 = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->Union(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_SetUnknownArraySetting_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUnknownArraySetting(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataArraySelection_GetUnknownArraySetting_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUnknownArraySetting();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataArraySelection_DeepCopy_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArraySelection * temp0;
  temp0 = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDataArraySelection_IsEqual_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArraySelection * temp0;
  bool   temp20;
  temp0 = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataArraySelection* op = static_cast<vtkDataArraySelection*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsEqual(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDataArraySelection_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDataArraySelection::New());
}
