// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

#ifndef vtkRenderingParallelLICObjectFactory_h
#define vtkRenderingParallelLICObjectFactory_h

#include "vtkRenderingParallelLICModule.h" // For export macro
#include "vtkObjectFactory.h"

VTK_ABI_NAMESPACE_BEGIN

class VTKRENDERINGPARALLELLIC_EXPORT vtkRenderingParallelLICObjectFactory : public vtkObjectFactory
{
public:
  static vtkRenderingParallelLICObjectFactory * New();
  vtkTypeMacro(vtkRenderingParallelLICObjectFactory, vtkObjectFactory);

  const char * GetDescription() VTK_FUTURE_CONST override { return "vtkRenderingParallelLIC factory overrides."; }

  const char * GetVTKSourceVersion() VTK_FUTURE_CONST override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  vtkRenderingParallelLICObjectFactory();

private:
  vtkRenderingParallelLICObjectFactory(const vtkRenderingParallelLICObjectFactory&) = delete;
  void operator=(const vtkRenderingParallelLICObjectFactory&) = delete;
};

VTK_ABI_NAMESPACE_END

#endif // vtkRenderingParallelLICObjectFactory_h
