// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkOutlineGlowUpscalePassFS.h"

const char *vtkOutlineGlowUpscalePassFS =
"//VTK::System::Dec\n"
"\n"
"\n"
"// Fragment shader used by outline glow pass to combine the original scene and the blurred image to form an outline\n"
"\n"
"in vec2 tcoordVC;\n"
"uniform sampler2D scene;\n"
"uniform sampler2D source;\n"
"\n"
"uniform float outlineIntensity;\n"
"\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"void main(void)\n"
"{\n"
"  vec4 color = texture2D(scene, tcoordVC);\n"
"  if( length(color.rgb) > 0.0)\n"
"  {\n"
"    // If the pixel was filled in the original scene it not part of the outline\n"
"    gl_FragData[0] = vec4(0.0, 0.0, 0.0, 0.0);\n"
"  }\n"
"  else\n"
"  {\n"
"    vec4 blurredColor = texture2D(source,tcoordVC);\n"
"    float brightness = max(blurredColor.r, max(blurredColor.g, blurredColor.b));\n"
"      gl_FragData[0].rgb = blurredColor.rgb * outlineIntensity;\n"
"      gl_FragData[0].a = brightness * outlineIntensity;\n"
"    }\n"
"}\n"
"";
