// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkFluidMapperSurfaceNormalFS.h"

const char *vtkFluidMapperSurfaceNormalFS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"uniform mat4 DCVCMatrix;\n"
"uniform mat4 VCDCMatrix;\n"
"\n"
"uniform sampler2D fluidZTexture;\n"
"uniform int       viewportWidth;\n"
"uniform int       viewportHeight;\n"
"\n"
"in vec2 texCoord;\n"
"// the output of this shader\n"
"//VTK::Output::Dec\n"
"\n"
"vec3 uvToEye(vec2 texCoordVal, float vcDepth)\n"
"{\n"
"  // need to convert depth back to DC, to use\n"
"  vec4 tmp = vec4(0.0, 0.0, vcDepth, 1.0);\n"
"  tmp = VCDCMatrix*tmp;\n"
"  tmp.x = texCoordVal.x * 2.0 - 1.0;\n"
"  tmp.y = texCoordVal.y * 2.0 - 1.0;\n"
"  tmp.z = tmp.z/tmp.w;\n"
"  tmp.w = 1.0;\n"
"  vec4 viewPos = DCVCMatrix * tmp;\n"
"  return viewPos.xyz / viewPos.w;\n"
"}\n"
"\n"
"void main()\n"
"{\n"
"  float x     = texCoord.x;\n"
"  float y     = texCoord.y;\n"
"  float depth = texture(fluidZTexture, vec2(x, y)).r;\n"
"\n"
"  float pixelWidth  = 1.0 / float(viewportWidth);\n"
"  float pixelHeight = 1.0 / float(viewportHeight);\n"
"  float xp          = texCoord.x + pixelWidth;\n"
"  float xn          = texCoord.x - pixelWidth;\n"
"  float yp          = texCoord.y + pixelHeight;\n"
"  float yn          = texCoord.y - pixelHeight;\n"
"\n"
"  float depthxp = texture(fluidZTexture, vec2(xp, y)).r;\n"
"  float depthxn = texture(fluidZTexture, vec2(xn, y)).r;\n"
"  float depthyp = texture(fluidZTexture, vec2(x, yp)).r;\n"
"  float depthyn = texture(fluidZTexture, vec2(x, yn)).r;\n"
"\n"
"  vec3 position   = uvToEye(vec2(x, y), depth);\n"
"  vec3 positionxp = uvToEye(vec2(xp, y), depthxp);\n"
"  vec3 positionxn = uvToEye(vec2(xn, y), depthxn);\n"
"  vec3 dxl        = position - positionxn;\n"
"  vec3 dxr        = positionxp - position;\n"
"\n"
"  vec3 dx = (abs(dxr.z) < abs(dxl.z)) ? dxr : dxl;\n"
"\n"
"  vec3 positionyp = uvToEye(vec2(x, yp), depthyp);\n"
"  vec3 positionyn = uvToEye(vec2(x, yn), depthyn);\n"
"  vec3 dyb        = position - positionyn;\n"
"  vec3 dyt        = positionyp - position;\n"
"\n"
"  vec3 dy = (abs(dyt.z) < abs(dyb.z)) ? dyt : dyb;\n"
"\n"
"  vec3 N = normalize(cross(dx, dy));\n"
"  if(isnan(N.x) || isnan(N.y) || isnan(N.y) ||\n"
"      isinf(N.x) || isinf(N.y) || isinf(N.z))\n"
"  {\n"
"    N = vec3(0, 0, 1);\n"
"  }\n"
"\n"
"  gl_FragData[0] = vec4(N, 1);\n"
"}\n"
"";
