// python wrapper for vtkOSPRayPass
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkOSPRayPass.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOSPRayPass(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOSPRayPass_ClassNew(); }


static PyObject *
PyvtkOSPRayPass_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOSPRayPass::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayPass *op = static_cast<vtkOSPRayPass *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOSPRayPass::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOSPRayPass *tempr = vtkOSPRayPass::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayPass *op = static_cast<vtkOSPRayPass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOSPRayPass *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOSPRayPass::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOSPRayPass::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayPass *op = static_cast<vtkOSPRayPass *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOSPRayPass::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_SetSceneGraph(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSceneGraph");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayPass *op = static_cast<vtkOSPRayPass *>(vp);

  vtkOSPRayRendererNode *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkOSPRayRendererNode"))
  {
    if (ap.IsBound())
    {
      op->SetSceneGraph(temp0);
    }
    else
    {
      op->vtkOSPRayPass::SetSceneGraph(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_GetSceneGraph(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSceneGraph");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOSPRayPass *op = static_cast<vtkOSPRayPass *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOSPRayRendererNode *tempr = (ap.IsBound() ?
      op->GetSceneGraph() :
      op->vtkOSPRayPass::GetSceneGraph());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_RTInit(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RTInit");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkOSPRayPass::RTInit();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_RTShutdown(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "RTShutdown");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkOSPRayPass::RTShutdown();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_IsSupported(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsSupported");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkOSPRayPass::IsSupported();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOSPRayPass_IsBackendAvailable(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsBackendAvailable");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = vtkOSPRayPass::IsBackendAvailable(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkOSPRayPass_Methods[] = {
  {"IsTypeOf", PyvtkOSPRayPass_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOSPRayPass_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOSPRayPass_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOSPRayPass\nC++: static vtkOSPRayPass *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOSPRayPass_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOSPRayPass\nC++: vtkOSPRayPass *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOSPRayPass_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOSPRayPass_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSceneGraph", PyvtkOSPRayPass_SetSceneGraph, METH_VARARGS,
   "SetSceneGraph(self, __a:vtkOSPRayRendererNode) -> None\nC++: void SetSceneGraph(vtkOSPRayRendererNode *)\n\nTells the pass what it will render.\n"},
  {"GetSceneGraph", PyvtkOSPRayPass_GetSceneGraph, METH_VARARGS,
   "GetSceneGraph(self) -> vtkOSPRayRendererNode\nC++: virtual vtkOSPRayRendererNode *GetSceneGraph()\n\n"},
  {"RTInit", PyvtkOSPRayPass_RTInit, METH_VARARGS,
   "RTInit() -> None\nC++: static void RTInit()\n\n"},
  {"RTShutdown", PyvtkOSPRayPass_RTShutdown, METH_VARARGS,
   "RTShutdown() -> None\nC++: static void RTShutdown()\n\n"},
  {"IsSupported", PyvtkOSPRayPass_IsSupported, METH_VARARGS,
   "IsSupported() -> bool\nC++: static bool IsSupported()\n\nA run time query to see if OSPRay can possibly work.\n"},
  {"IsBackendAvailable", PyvtkOSPRayPass_IsBackendAvailable, METH_VARARGS,
   "IsBackendAvailable(name:str) -> bool\nC++: static bool IsBackendAvailable(const char *name)\n\nA run time query to see if a particular backend is available. Eg.\n\"OSPRay raycaster\", \"OSPRay pathtracer\" or \"OptiX pathtracer\".\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOSPRayPass_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("scene_graph"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOSPRayPass_GetSceneGraph(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOSPRayPass_SetSceneGraph(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOSPRayPass_SetSceneGraph(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSceneGraph/SetSceneGraph\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOSPRayPass_Doc =
  "vtkOSPRayPass - a render pass that uses OSPRay instead of GL\n\n"
  "Superclass: vtkRenderPass\n\n"
  "This is a render pass that can be put into a vtkRenderWindow which\n"
  "makes it use OSPRay instead of OpenGL to render. Adding/Removing the\n"
  "pass will swap back and forth between the two.\n\n\n"
  " OSPRay MPI - OSPRay can use its own internal MPI layer to replicate\n"
  "   the scene data across mpi processes and composite the image.\n"
  "   This results in linear performance scaling and supports secondary\n"
  "   rays.  To run in this mode, a special environment variable is\n"
  "supplied\n"
  "   called VTKOSPRAY_ARGS where commandline flags can be inserted for\n"
  "   OSPRay's init call.  As an example of this, below is a commandline\n"
  "   for running paraview on localhost, but having OSPRay's rendering\n"
  "   occur on 2 remote nodes.  ospray_mpi_worker is a separate\n"
  "application\n"
  "   supplied with OSPRay binary packages or when built with MPI\n"
  "support\n"
  "   from source.\n"
  "   'mpirun -ppn 1 -hosts localhost VTKOSPRAY_ARGS=\"-osp:mpi\"\n"
  "     ./paraview : -hosts n1, n2 ./ospray_mpi_worker -osp:mpi'\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOSPRayPass_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingRayTracing.vtkOSPRayPass", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOSPRayPass_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOSPRayPass_StaticNew()
{
  return vtkOSPRayPass::New();
}

PyObject *PyvtkOSPRayPass_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOSPRayPass_Type, PyvtkOSPRayPass_Methods,
    "vtkOSPRayPass",
 &PyvtkOSPRayPass_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkRenderPass");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOSPRayPass_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOSPRayPass(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOSPRayPass_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOSPRayPass", o) != 0)
  {
    Py_DECREF(o);
  }

}

