// python wrapper for vtkGDALRasterReprojection
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkGDALRasterReprojection.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkGDALRasterReprojection(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGDALRasterReprojection_ClassNew(); }


static PyObject *
PyvtkGDALRasterReprojection_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGDALRasterReprojection::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReprojection *op = static_cast<vtkGDALRasterReprojection *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGDALRasterReprojection::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGDALRasterReprojection *tempr = vtkGDALRasterReprojection::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReprojection *op = static_cast<vtkGDALRasterReprojection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGDALRasterReprojection *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGDALRasterReprojection::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGDALRasterReprojection::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReprojection *op = static_cast<vtkGDALRasterReprojection *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGDALRasterReprojection::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_SetMaxError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReprojection *op = static_cast<vtkGDALRasterReprojection *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxError(temp0);
    }
    else
    {
      op->vtkGDALRasterReprojection::SetMaxError(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_GetMaxErrorMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxErrorMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReprojection *op = static_cast<vtkGDALRasterReprojection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxErrorMinValue() :
      op->vtkGDALRasterReprojection::GetMaxErrorMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_GetMaxErrorMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxErrorMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReprojection *op = static_cast<vtkGDALRasterReprojection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxErrorMaxValue() :
      op->vtkGDALRasterReprojection::GetMaxErrorMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_SetResamplingAlgorithm(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetResamplingAlgorithm");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReprojection *op = static_cast<vtkGDALRasterReprojection *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetResamplingAlgorithm(temp0);
    }
    else
    {
      op->vtkGDALRasterReprojection::SetResamplingAlgorithm(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_GetResamplingAlgorithmMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetResamplingAlgorithmMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReprojection *op = static_cast<vtkGDALRasterReprojection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetResamplingAlgorithmMinValue() :
      op->vtkGDALRasterReprojection::GetResamplingAlgorithmMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReprojection_GetResamplingAlgorithmMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetResamplingAlgorithmMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReprojection *op = static_cast<vtkGDALRasterReprojection *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetResamplingAlgorithmMaxValue() :
      op->vtkGDALRasterReprojection::GetResamplingAlgorithmMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkGDALRasterReprojection_Methods[] = {
  {"IsTypeOf", PyvtkGDALRasterReprojection_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGDALRasterReprojection_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGDALRasterReprojection_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkGDALRasterReprojection\nC++: static vtkGDALRasterReprojection *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGDALRasterReprojection_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkGDALRasterReprojection\nC++: vtkGDALRasterReprojection *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGDALRasterReprojection_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGDALRasterReprojection_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetMaxError", PyvtkGDALRasterReprojection_SetMaxError, METH_VARARGS,
   "SetMaxError(self, _arg:float) -> None\nC++: virtual void SetMaxError(double _arg)\n\nThe maximum error measured in input pixels that is allowed in\napproximating the reprojection transformation (0.0 for exact\ncalculations).\n"},
  {"GetMaxErrorMinValue", PyvtkGDALRasterReprojection_GetMaxErrorMinValue, METH_VARARGS,
   "GetMaxErrorMinValue(self) -> float\nC++: virtual double GetMaxErrorMinValue()\n\n"},
  {"GetMaxErrorMaxValue", PyvtkGDALRasterReprojection_GetMaxErrorMaxValue, METH_VARARGS,
   "GetMaxErrorMaxValue(self) -> float\nC++: virtual double GetMaxErrorMaxValue()\n\n"},
  {"SetResamplingAlgorithm", PyvtkGDALRasterReprojection_SetResamplingAlgorithm, METH_VARARGS,
   "SetResamplingAlgorithm(self, _arg:int) -> None\nC++: virtual void SetResamplingAlgorithm(int _arg)\n\nPixel resampling algorithm, between 0 and 6 0 = Nearest Neighbor\n(default) 1 = Bilinear 2 = Cubic 3 = CubicSpline 4 = Lanczos 5 =\nAverage (GDAL 1.10) 6 = Mode    (GDAL 1.10)\n"},
  {"GetResamplingAlgorithmMinValue", PyvtkGDALRasterReprojection_GetResamplingAlgorithmMinValue, METH_VARARGS,
   "GetResamplingAlgorithmMinValue(self) -> int\nC++: virtual int GetResamplingAlgorithmMinValue()\n\n"},
  {"GetResamplingAlgorithmMaxValue", PyvtkGDALRasterReprojection_GetResamplingAlgorithmMaxValue, METH_VARARGS,
   "GetResamplingAlgorithmMaxValue(self) -> int\nC++: virtual int GetResamplingAlgorithmMaxValue()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGDALRasterReprojection_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("max_error"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGDALRasterReprojection_SetMaxError(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGDALRasterReprojection_SetMaxError(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaxError\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("resampling_algorithm"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGDALRasterReprojection_SetResamplingAlgorithm(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGDALRasterReprojection_SetResamplingAlgorithm(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetResamplingAlgorithm\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGDALRasterReprojection_Doc =
  "vtkGDALRasterReprojection - \n\n"
  "Superclass: vtkObject\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGDALRasterReprojection_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkGeovisGDAL.vtkGDALRasterReprojection", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGDALRasterReprojection_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkGDALRasterReprojection_StaticNew()
{
  return vtkGDALRasterReprojection::New();
}

PyObject *PyvtkGDALRasterReprojection_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGDALRasterReprojection_Type, PyvtkGDALRasterReprojection_Methods,
    "vtkGDALRasterReprojection",
 &PyvtkGDALRasterReprojection_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGDALRasterReprojection_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkGDALRasterReprojection(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkGDALRasterReprojection_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkGDALRasterReprojection", o) != 0)
  {
    Py_DECREF(o);
  }

}

