// python wrapper for ttkDataSetToTable
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkDataSetToTable.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkDataSetToTable(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkDataSetToTable_ClassNew(); }


static PyObject *
PyttkDataSetToTable_SetDataAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDataSetToTable *op = static_cast<ttkDataSetToTable *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDataAssociation(temp0);
    }
    else
    {
      op->ttkDataSetToTable::SetDataAssociation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkDataSetToTable_GetDataAssociation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataAssociation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDataSetToTable *op = static_cast<ttkDataSetToTable *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDataAssociation() :
      op->ttkDataSetToTable::GetDataAssociation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDataSetToTable_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkDataSetToTable::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDataSetToTable_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDataSetToTable *op = static_cast<ttkDataSetToTable *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkDataSetToTable::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDataSetToTable_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkDataSetToTable *tempr = ttkDataSetToTable::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDataSetToTable_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDataSetToTable *op = static_cast<ttkDataSetToTable *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkDataSetToTable *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkDataSetToTable::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDataSetToTable_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkDataSetToTable::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkDataSetToTable_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkDataSetToTable *op = static_cast<ttkDataSetToTable *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkDataSetToTable::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkDataSetToTable_Methods[] = {
  {"SetDataAssociation", PyttkDataSetToTable_SetDataAssociation, METH_VARARGS,
   "SetDataAssociation(self, _arg:int) -> None\nC++: virtual void SetDataAssociation(int _arg)\n\n"},
  {"GetDataAssociation", PyttkDataSetToTable_GetDataAssociation, METH_VARARGS,
   "GetDataAssociation(self) -> int\nC++: virtual int GetDataAssociation()\n\n"},
  {"IsTypeOf", PyttkDataSetToTable_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkDataSetToTable_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkDataSetToTable_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkDataSetToTable\nC++: static ttkDataSetToTable *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkDataSetToTable_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkDataSetToTable\nC++: ttkDataSetToTable *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkDataSetToTable_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkDataSetToTable_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkDataSetToTable_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("data_association"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkDataSetToTable_GetDataAssociation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkDataSetToTable_SetDataAssociation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkDataSetToTable_SetDataAssociation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDataAssociation/SetDataAssociation\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkDataSetToTable_Doc =
  "ttkDataSetToTable - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Guillaume Favelier <guillaume.favelier@lip6.fr>\\date\n"
  "September 2018\n\n"
  "TTK VTK-filter that creates a vtkTable from a vtkDataSet.\n\n"
  "\\param Input vtkDataSet and scalar fields\n"
  "\\param Output vtkTable and fields as columns\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreePGA/\">Me\n"
  "  rge Tree Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/mergeTreeWAE/\">Me\n"
  "  rge tree Wasserstein Auto-Encoder example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramPGA/\"\n"
  "  >Persistence Diagram Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramWAE/\"\n"
  "  >Persistence Diagram Wasserstein Auto-Encoder example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_periodicPicture/\"\n"
  "  > Persistent Generators Periodic Picture example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkDataSetToTable_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkDataSetToTable.ttkDataSetToTable", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkDataSetToTable_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkDataSetToTable_StaticNew()
{
  return ttkDataSetToTable::New();
}

PyObject *PyttkDataSetToTable_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkDataSetToTable_Type, PyttkDataSetToTable_Methods,
    "ttkDataSetToTable",
 &PyttkDataSetToTable_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkDataSetToTable_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkDataSetToTable(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkDataSetToTable_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkDataSetToTable", o) != 0)
  {
    Py_DECREF(o);
  }

}

