/* ShortcutsList.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ShortcutsList.vala, do not modify */

/*
* Copyright (c) 2017-2018 elementary, LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "keyboard.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define KEYBOARD_SHORTCUTS_TYPE_GROUP (keyboard_shortcuts_group_get_type ())
typedef struct _KeyboardShortcutsGroup KeyboardShortcutsGroup;
typedef enum  {
	KEYBOARD_SHORTCUTS_SCHEMA_WM,
	KEYBOARD_SHORTCUTS_SCHEMA_MUTTER,
	KEYBOARD_SHORTCUTS_SCHEMA_GALA,
	KEYBOARD_SHORTCUTS_SCHEMA_MEDIA,
	KEYBOARD_SHORTCUTS_SCHEMA_SOUND_INDICATOR,
	KEYBOARD_SHORTCUTS_SCHEMA_IBUS,
	KEYBOARD_SHORTCUTS_SCHEMA_DOCK,
	KEYBOARD_SHORTCUTS_SCHEMA_COUNT
} KeyboardShortcutsSchema;

#define KEYBOARD_SHORTCUTS_TYPE_SCHEMA (keyboard_shortcuts_schema_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST (keyboard_shortcuts_shortcuts_list_get_type ())
#define KEYBOARD_SHORTCUTS_SHORTCUTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST, KeyboardShortcutsShortcutsList))
#define KEYBOARD_SHORTCUTS_SHORTCUTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST, KeyboardShortcutsShortcutsListClass))
#define KEYBOARD_SHORTCUTS_IS_SHORTCUTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST))
#define KEYBOARD_SHORTCUTS_IS_SHORTCUTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST))
#define KEYBOARD_SHORTCUTS_SHORTCUTS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST, KeyboardShortcutsShortcutsListClass))

typedef struct _KeyboardShortcutsShortcutsList KeyboardShortcutsShortcutsList;
typedef struct _KeyboardShortcutsShortcutsListClass KeyboardShortcutsShortcutsListClass;
typedef struct _KeyboardShortcutsShortcutsListPrivate KeyboardShortcutsShortcutsListPrivate;
enum  {
	KEYBOARD_SHORTCUTS_SHORTCUTS_LIST_0_PROPERTY,
	KEYBOARD_SHORTCUTS_SHORTCUTS_LIST_NUM_PROPERTIES
};
static GParamSpec* keyboard_shortcuts_shortcuts_list_properties[KEYBOARD_SHORTCUTS_SHORTCUTS_LIST_NUM_PROPERTIES];

struct _KeyboardShortcutsGroup {
	gchar* icon_name;
	gchar* label;
	gchar** actions;
	gint actions_length1;
	gint _actions_size_;
	KeyboardShortcutsSchema* schemas;
	gint schemas_length1;
	gint _schemas_size_;
	gchar** keys;
	gint keys_length1;
	gint _keys_size_;
};

struct _KeyboardShortcutsShortcutsList {
	GObject parent_instance;
	KeyboardShortcutsShortcutsListPrivate * priv;
	KeyboardShortcutsGroup* groups;
	gint groups_length1;
	gint _groups_size_;
	KeyboardShortcutsGroup windows_group;
	KeyboardShortcutsGroup workspaces_group;
	KeyboardShortcutsGroup screenshot_group;
	KeyboardShortcutsGroup launchers_group;
	KeyboardShortcutsGroup media_group;
	KeyboardShortcutsGroup a11y_group;
	KeyboardShortcutsGroup system_group;
	KeyboardShortcutsGroup keyboard_layouts_group;
	KeyboardShortcutsGroup custom_group;
};

struct _KeyboardShortcutsShortcutsListClass {
	GObjectClass parent_class;
};

static gpointer keyboard_shortcuts_shortcuts_list_parent_class = NULL;
static GOnce keyboard_shortcuts_shortcuts_list_instance;
static GOnce keyboard_shortcuts_shortcuts_list_instance = G_ONCE_INIT;

VALA_EXTERN GType keyboard_shortcuts_group_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType keyboard_shortcuts_schema_get_type (void) G_GNUC_CONST ;
VALA_EXTERN KeyboardShortcutsGroup* keyboard_shortcuts_group_dup (const KeyboardShortcutsGroup* self);
VALA_EXTERN void keyboard_shortcuts_group_free (KeyboardShortcutsGroup* self);
VALA_EXTERN void keyboard_shortcuts_group_copy (const KeyboardShortcutsGroup* self,
                                    KeyboardShortcutsGroup* dest);
VALA_EXTERN void keyboard_shortcuts_group_destroy (KeyboardShortcutsGroup* self);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static KeyboardShortcutsSchema* _vala_array_dup7 (KeyboardShortcutsSchema* self,
                                           gssize length);
static gchar** _vala_array_dup8 (gchar** self,
                          gssize length);
VALA_EXTERN GType keyboard_shortcuts_shortcuts_list_get_type (void) G_GNUC_CONST ;
static void _vala_KeyboardShortcutsGroup_array_free (KeyboardShortcutsGroup * array,
                                              gssize array_length);
VALA_EXTERN KeyboardShortcutsShortcutsList* keyboard_shortcuts_shortcuts_list_get_default (void);
static KeyboardShortcutsShortcutsList* __lambda57_ (void);
static KeyboardShortcutsShortcutsList* keyboard_shortcuts_shortcuts_list_new (void);
static KeyboardShortcutsShortcutsList* keyboard_shortcuts_shortcuts_list_construct (GType object_type);
static gpointer ___lambda57__gthread_func (gpointer self);
VALA_EXTERN void keyboard_shortcuts_shortcuts_list_get_group (KeyboardShortcutsShortcutsList* self,
                                                  KeyboardShortcutsSectionID group,
                                                  gchar*** a,
                                                  gint* a_length1,
                                                  KeyboardShortcutsSchema** s,
                                                  gint* s_length1,
                                                  gchar*** k,
                                                  gint* k_length1);
static gchar** _vala_array_dup9 (gchar** self,
                          gssize length);
static KeyboardShortcutsSchema* _vala_array_dup10 (KeyboardShortcutsSchema* self,
                                            gssize length);
static gchar** _vala_array_dup11 (gchar** self,
                           gssize length);
VALA_EXTERN void keyboard_shortcuts_shortcuts_list_add_action (KeyboardShortcutsShortcutsList* self,
                                                   KeyboardShortcutsGroup* group,
                                                   KeyboardShortcutsSchema schema,
                                                   const gchar* action,
                                                   const gchar* key);
static void _vala_array_add16 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add17 (KeyboardShortcutsSchema* * array,
                        gint* length,
                        gint* size,
                        KeyboardShortcutsSchema value);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static GObject * keyboard_shortcuts_shortcuts_list_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void keyboard_shortcuts_shortcuts_list_finalize (GObject * obj);
static GType keyboard_shortcuts_shortcuts_list_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static KeyboardShortcutsSchema*
_vala_array_dup7 (KeyboardShortcutsSchema* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (KeyboardShortcutsSchema));
	}
	return NULL;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
keyboard_shortcuts_group_copy (const KeyboardShortcutsGroup* self,
                               KeyboardShortcutsGroup* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	KeyboardShortcutsSchema* _tmp6_;
	gint _tmp6__length1;
	KeyboardShortcutsSchema* _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	_tmp0_ = (*self).icon_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).icon_name);
	(*dest).icon_name = _tmp1_;
	_tmp2_ = (*self).label;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp3_;
	_tmp4_ = (*self).actions;
	_tmp4__length1 = (*self).actions_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup6 (_tmp4_, _tmp4__length1) : _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	(*dest).actions = (_vala_array_free ((*dest).actions, (*dest).actions_length1, (GDestroyNotify) g_free), NULL);
	(*dest).actions = _tmp5_;
	(*dest).actions_length1 = _tmp5__length1;
	(*dest)._actions_size_ = (*dest).actions_length1;
	_tmp6_ = (*self).schemas;
	_tmp6__length1 = (*self).schemas_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup7 (_tmp6_, _tmp6__length1) : _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	(*dest).schemas = (g_free ((*dest).schemas), NULL);
	(*dest).schemas = _tmp7_;
	(*dest).schemas_length1 = _tmp7__length1;
	(*dest)._schemas_size_ = (*dest).schemas_length1;
	_tmp8_ = (*self).keys;
	_tmp8__length1 = (*self).keys_length1;
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup8 (_tmp8_, _tmp8__length1) : _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	(*dest).keys = (_vala_array_free ((*dest).keys, (*dest).keys_length1, (GDestroyNotify) g_free), NULL);
	(*dest).keys = _tmp9_;
	(*dest).keys_length1 = _tmp9__length1;
	(*dest)._keys_size_ = (*dest).keys_length1;
}

void
keyboard_shortcuts_group_destroy (KeyboardShortcutsGroup* self)
{
	_g_free0 ((*self).icon_name);
	_g_free0 ((*self).label);
	(*self).actions = (_vala_array_free ((*self).actions, (*self).actions_length1, (GDestroyNotify) g_free), NULL);
	(*self).schemas = (g_free ((*self).schemas), NULL);
	(*self).keys = (_vala_array_free ((*self).keys, (*self).keys_length1, (GDestroyNotify) g_free), NULL);
}

KeyboardShortcutsGroup*
keyboard_shortcuts_group_dup (const KeyboardShortcutsGroup* self)
{
	KeyboardShortcutsGroup* dup;
	dup = g_new0 (KeyboardShortcutsGroup, 1);
	keyboard_shortcuts_group_copy (self, dup);
	return dup;
}

void
keyboard_shortcuts_group_free (KeyboardShortcutsGroup* self)
{
	keyboard_shortcuts_group_destroy (self);
	g_free (self);
}

static GType
keyboard_shortcuts_group_get_type_once (void)
{
	GType keyboard_shortcuts_group_type_id;
	keyboard_shortcuts_group_type_id = g_boxed_type_register_static ("KeyboardShortcutsGroup", (GBoxedCopyFunc) keyboard_shortcuts_group_dup, (GBoxedFreeFunc) keyboard_shortcuts_group_free);
	return keyboard_shortcuts_group_type_id;
}

GType
keyboard_shortcuts_group_get_type (void)
{
	static volatile gsize keyboard_shortcuts_group_type_id__once = 0;
	if (g_once_init_enter (&keyboard_shortcuts_group_type_id__once)) {
		GType keyboard_shortcuts_group_type_id;
		keyboard_shortcuts_group_type_id = keyboard_shortcuts_group_get_type_once ();
		g_once_init_leave (&keyboard_shortcuts_group_type_id__once, keyboard_shortcuts_group_type_id);
	}
	return keyboard_shortcuts_group_type_id__once;
}

static void
_vala_KeyboardShortcutsGroup_array_free (KeyboardShortcutsGroup * array,
                                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			keyboard_shortcuts_group_destroy (&array[i]);
		}
	}
	g_free (array);
}

static KeyboardShortcutsShortcutsList*
__lambda57_ (void)
{
	KeyboardShortcutsShortcutsList* _tmp0_;
	KeyboardShortcutsShortcutsList* result;
	_tmp0_ = keyboard_shortcuts_shortcuts_list_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda57__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda57_ ();
	return result;
}

KeyboardShortcutsShortcutsList*
keyboard_shortcuts_shortcuts_list_get_default (void)
{
	gconstpointer _tmp0_;
	KeyboardShortcutsShortcutsList* result;
	_tmp0_ = g_once (&keyboard_shortcuts_shortcuts_list_instance, ___lambda57__gthread_func, NULL);
	result = (KeyboardShortcutsShortcutsList*) _tmp0_;
	return result;
}

static KeyboardShortcutsShortcutsList*
keyboard_shortcuts_shortcuts_list_construct (GType object_type)
{
	KeyboardShortcutsShortcutsList * self = NULL;
	self = (KeyboardShortcutsShortcutsList*) g_object_new (object_type, NULL);
	return self;
}

static KeyboardShortcutsShortcutsList*
keyboard_shortcuts_shortcuts_list_new (void)
{
	return keyboard_shortcuts_shortcuts_list_construct (KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST);
}

static gchar**
_vala_array_dup9 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static KeyboardShortcutsSchema*
_vala_array_dup10 (KeyboardShortcutsSchema* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (KeyboardShortcutsSchema));
	}
	return NULL;
}

static gchar**
_vala_array_dup11 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
keyboard_shortcuts_shortcuts_list_get_group (KeyboardShortcutsShortcutsList* self,
                                             KeyboardShortcutsSectionID group,
                                             gchar*** a,
                                             gint* a_length1,
                                             KeyboardShortcutsSchema** s,
                                             gint* s_length1,
                                             gchar*** k,
                                             gint* k_length1)
{
	gchar** _vala_a = NULL;
	gint _vala_a_length1 = 0;
	KeyboardShortcutsSchema* _vala_s = NULL;
	gint _vala_s_length1 = 0;
	gchar** _vala_k = NULL;
	gint _vala_k_length1 = 0;
	KeyboardShortcutsGroup* _tmp0_;
	gint _tmp0__length1;
	KeyboardShortcutsGroup _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	KeyboardShortcutsGroup* _tmp4_;
	gint _tmp4__length1;
	KeyboardShortcutsGroup _tmp5_;
	KeyboardShortcutsSchema* _tmp6_;
	gint _tmp6__length1;
	KeyboardShortcutsSchema* _tmp7_;
	gint _tmp7__length1;
	KeyboardShortcutsGroup* _tmp8_;
	gint _tmp8__length1;
	KeyboardShortcutsGroup _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->groups;
	_tmp0__length1 = self->groups_length1;
	_tmp1_ = _tmp0_[group];
	_tmp2_ = _tmp1_.actions;
	_tmp2__length1 = _tmp1_.actions_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup9 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	_vala_a = (_vala_array_free (_vala_a, _vala_a_length1, (GDestroyNotify) g_free), NULL);
	_vala_a = _tmp3_;
	_vala_a_length1 = _tmp3__length1;
	_tmp4_ = self->groups;
	_tmp4__length1 = self->groups_length1;
	_tmp5_ = _tmp4_[group];
	_tmp6_ = _tmp5_.schemas;
	_tmp6__length1 = _tmp5_.schemas_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup10 (_tmp6_, _tmp6__length1) : _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	_vala_s = (g_free (_vala_s), NULL);
	_vala_s = _tmp7_;
	_vala_s_length1 = _tmp7__length1;
	_tmp8_ = self->groups;
	_tmp8__length1 = self->groups_length1;
	_tmp9_ = _tmp8_[group];
	_tmp10_ = _tmp9_.keys;
	_tmp10__length1 = _tmp9_.keys_length1;
	_tmp11_ = (_tmp10_ != NULL) ? _vala_array_dup11 (_tmp10_, _tmp10__length1) : _tmp10_;
	_tmp11__length1 = _tmp10__length1;
	_vala_k = (_vala_array_free (_vala_k, _vala_k_length1, (GDestroyNotify) g_free), NULL);
	_vala_k = _tmp11_;
	_vala_k_length1 = _tmp11__length1;
	if (a) {
		*a = _vala_a;
	} else {
		_vala_a = (_vala_array_free (_vala_a, _vala_a_length1, (GDestroyNotify) g_free), NULL);
	}
	if (a_length1) {
		*a_length1 = _vala_a_length1;
	}
	if (s) {
		*s = _vala_s;
	} else {
		_vala_s = (g_free (_vala_s), NULL);
	}
	if (s_length1) {
		*s_length1 = _vala_s_length1;
	}
	if (k) {
		*k = _vala_k;
	} else {
		_vala_k = (_vala_array_free (_vala_k, _vala_k_length1, (GDestroyNotify) g_free), NULL);
	}
	if (k_length1) {
		*k_length1 = _vala_k_length1;
	}
	return;
}

static void
_vala_array_add16 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add17 (KeyboardShortcutsSchema* * array,
                   gint* length,
                   gint* size,
                   KeyboardShortcutsSchema value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (KeyboardShortcutsSchema, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
keyboard_shortcuts_shortcuts_list_add_action (KeyboardShortcutsShortcutsList* self,
                                              KeyboardShortcutsGroup* group,
                                              KeyboardShortcutsSchema schema,
                                              const gchar* action,
                                              const gchar* key)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = g_strdup (key);
	_vala_array_add16 (&(*group).keys, &(*group).keys_length1, &(*group)._keys_size_, _tmp0_);
	_vala_array_add17 (&(*group).schemas, &(*group).schemas_length1, &(*group)._schemas_size_, schema);
	_tmp1_ = g_strdup (action);
	_vala_array_add18 (&(*group).actions, &(*group).actions_length1, &(*group)._actions_size_, _tmp1_);
}

static GObject *
keyboard_shortcuts_shortcuts_list_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KeyboardShortcutsShortcutsList * self;
	KeyboardShortcutsGroup _tmp0_ = {0};
	gchar* _tmp1_;
	gchar* _tmp2_;
	KeyboardShortcutsGroup _tmp3_ = {0};
	gchar* _tmp4_;
	gchar* _tmp5_;
	KeyboardShortcutsGroup _tmp6_ = {0};
	gchar* _tmp7_;
	gchar* _tmp8_;
	KeyboardShortcutsGroup _tmp9_ = {0};
	gchar* _tmp10_;
	gchar* _tmp11_;
	KeyboardShortcutsGroup _tmp12_ = {0};
	gchar* _tmp13_;
	gchar* _tmp14_;
	KeyboardShortcutsGroup _tmp15_ = {0};
	gchar* _tmp16_;
	gchar* _tmp17_;
	KeyboardShortcutsGroup _tmp18_ = {0};
	gchar* _tmp19_;
	gchar* _tmp20_;
	KeyboardShortcutsGroup _tmp21_ = {0};
	gchar* _tmp22_;
	gchar* _tmp23_;
	KeyboardShortcutsGroup _tmp24_ = {0};
	gchar* _tmp25_;
	gchar* _tmp26_;
	KeyboardShortcutsGroup _tmp27_;
	KeyboardShortcutsGroup _tmp28_;
	KeyboardShortcutsGroup _tmp29_ = {0};
	KeyboardShortcutsGroup _tmp30_;
	KeyboardShortcutsGroup _tmp31_;
	KeyboardShortcutsGroup _tmp32_ = {0};
	KeyboardShortcutsGroup _tmp33_;
	KeyboardShortcutsGroup _tmp34_;
	KeyboardShortcutsGroup _tmp35_ = {0};
	KeyboardShortcutsGroup _tmp36_;
	KeyboardShortcutsGroup _tmp37_;
	KeyboardShortcutsGroup _tmp38_ = {0};
	KeyboardShortcutsGroup _tmp39_;
	KeyboardShortcutsGroup _tmp40_;
	KeyboardShortcutsGroup _tmp41_ = {0};
	KeyboardShortcutsGroup _tmp42_;
	KeyboardShortcutsGroup _tmp43_;
	KeyboardShortcutsGroup _tmp44_ = {0};
	KeyboardShortcutsGroup _tmp45_;
	KeyboardShortcutsGroup _tmp46_;
	KeyboardShortcutsGroup _tmp47_ = {0};
	KeyboardShortcutsGroup _tmp48_;
	KeyboardShortcutsGroup _tmp49_;
	KeyboardShortcutsGroup _tmp50_ = {0};
	KeyboardShortcutsGroup* _tmp51_;
	parent_class = G_OBJECT_CLASS (keyboard_shortcuts_shortcuts_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST, KeyboardShortcutsShortcutsList);
	keyboard_shortcuts_group_destroy (&self->windows_group);
	self->windows_group = _tmp0_;
	_tmp1_ = g_strdup ("io.elementary.settings.keyboard.windows");
	_g_free0 (self->windows_group.icon_name);
	self->windows_group.icon_name = _tmp1_;
	_tmp2_ = g_strdup (_ ("Windows"));
	_g_free0 (self->windows_group.label);
	self->windows_group.label = _tmp2_;
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Close"), "close");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Lower"), "lower");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Maximize"), "maximize");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Unmaximize"), "unmaximize");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Toggle Maximized"), "toggle-maximized");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Hide"), "minimize");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Toggle Fullscreen"), "toggle-fullscreen");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Toggle on all Workspaces"), "toggle-on-all-workspaces");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Toggle always on Top"), "toggle-above");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Cycle Windows"), "switch-windows");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Cycle Windows backwards"), "switch-windows-backward");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Cycle Windows of application"), "switch-group");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Cycle Windows of application backwards"), "switch-group-backward");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_MUTTER, _ ("Tile Left"), "toggle-tiled-left");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_MUTTER, _ ("Tile Right"), "toggle-tiled-right");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Window Overview"), "expose-windows");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Show All Windows"), "expose-all-windows");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Picture in Picture Mode"), "pip");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to display above"), "move-to-monitor-up");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to display below"), "move-to-monitor-down");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to right display"), "move-to-monitor-right");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->windows_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to left display"), "move-to-monitor-left");
	keyboard_shortcuts_group_destroy (&self->workspaces_group);
	self->workspaces_group = _tmp3_;
	_tmp4_ = g_strdup ("preferences-desktop-workspaces");
	_g_free0 (self->workspaces_group.icon_name);
	self->workspaces_group.icon_name = _tmp4_;
	_tmp5_ = g_strdup (_ ("Workspaces"));
	_g_free0 (self->workspaces_group.label);
	self->workspaces_group.label = _tmp5_;
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Multitasking View"), "toggle-multitasking-view");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch left"), "switch-to-workspace-left");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch right"), "switch-to-workspace-right");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Switch to first"), "switch-to-workspace-first");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Switch to new"), "switch-to-workspace-last");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch to workspace 1"), "switch-to-workspace-1");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch to workspace 2"), "switch-to-workspace-2");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch to workspace 3"), "switch-to-workspace-3");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch to workspace 4"), "switch-to-workspace-4");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch to workspace 5"), "switch-to-workspace-5");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch to workspace 6"), "switch-to-workspace-6");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch to workspace 7"), "switch-to-workspace-7");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch to workspace 8"), "switch-to-workspace-8");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Switch to workspace 9"), "switch-to-workspace-9");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Cycle workspaces"), "cycle-workspaces-next");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Cycle workspaces backwards"), "cycle-workspaces-previous");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to workspace 1"), "move-to-workspace-1");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to workspace 2"), "move-to-workspace-2");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to workspace 3"), "move-to-workspace-3");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to workspace 4"), "move-to-workspace-4");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to workspace 5"), "move-to-workspace-5");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to workspace 6"), "move-to-workspace-6");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to workspace 7"), "move-to-workspace-7");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to workspace 8"), "move-to-workspace-8");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to workspace 9"), "move-to-workspace-9");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to left workspace"), "move-to-workspace-left");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->workspaces_group, KEYBOARD_SHORTCUTS_SCHEMA_WM, _ ("Move to right workspace"), "move-to-workspace-right");
	keyboard_shortcuts_group_destroy (&self->screenshot_group);
	self->screenshot_group = _tmp6_;
	_tmp7_ = g_strdup ("accessories-screenshot-tool");
	_g_free0 (self->screenshot_group.icon_name);
	self->screenshot_group.icon_name = _tmp7_;
	_tmp8_ = g_strdup (_ ("Screenshots"));
	_g_free0 (self->screenshot_group.label);
	self->screenshot_group.label = _tmp8_;
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->screenshot_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Grab the whole screen"), "screenshot");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->screenshot_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Copy the whole screen to clipboard"), "screenshot-clip");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->screenshot_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Grab the current window"), "window-screenshot");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->screenshot_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Copy the current window to clipboard"), "window-screenshot-clip");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->screenshot_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Select an area to grab"), "area-screenshot");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->screenshot_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Copy an area to clipboard"), "area-screenshot-clip");
	keyboard_shortcuts_group_destroy (&self->launchers_group);
	self->launchers_group = _tmp9_;
	_tmp10_ = g_strdup ("io.elementary.settings.keyboard.applications");
	_g_free0 (self->launchers_group.icon_name);
	self->launchers_group.icon_name = _tmp10_;
	_tmp11_ = g_strdup (_ ("Applications"));
	_g_free0 (self->launchers_group.label);
	self->launchers_group.label = _tmp11_;
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Email"), "email");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Home Folder"), "home");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Music"), "media");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Terminal"), "terminal");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Internet Browser"), "www");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_DOCK, _ ("Launch first dock item"), "launch-dock-1");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_DOCK, _ ("Launch second dock item"), "launch-dock-2");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_DOCK, _ ("Launch third dock item"), "launch-dock-3");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_DOCK, _ ("Launch fourth dock item"), "launch-dock-4");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_DOCK, _ ("Launch fifth dock item"), "launch-dock-5");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_DOCK, _ ("Launch sixth dock item"), "launch-dock-6");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_DOCK, _ ("Launch seventh dock item"), "launch-dock-7");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_DOCK, _ ("Launch eighth dock item"), "launch-dock-8");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->launchers_group, KEYBOARD_SHORTCUTS_SCHEMA_DOCK, _ ("Launch ninth dock item"), "launch-dock-9");
	keyboard_shortcuts_group_destroy (&self->media_group);
	self->media_group = _tmp12_;
	_tmp13_ = g_strdup ("applications-multimedia");
	_g_free0 (self->media_group.icon_name);
	self->media_group.icon_name = _tmp13_;
	_tmp14_ = g_strdup (_ ("Media"));
	_g_free0 (self->media_group.label);
	self->media_group.label = _tmp14_;
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->media_group, KEYBOARD_SHORTCUTS_SCHEMA_SOUND_INDICATOR, _ ("Volume Up"), "volume-up");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->media_group, KEYBOARD_SHORTCUTS_SCHEMA_SOUND_INDICATOR, _ ("Volume Down"), "volume-down");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->media_group, KEYBOARD_SHORTCUTS_SCHEMA_SOUND_INDICATOR, _ ("Mute"), "volume-mute");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->media_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Play/Pause"), "play");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->media_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Pause"), "pause");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->media_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Stop"), "stop");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->media_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Previous Track"), "previous");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->media_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Next Track"), "next");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->media_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Eject"), "eject");
	keyboard_shortcuts_group_destroy (&self->a11y_group);
	self->a11y_group = _tmp15_;
	_tmp16_ = g_strdup ("preferences-desktop-accessibility");
	_g_free0 (self->a11y_group.icon_name);
	self->a11y_group.icon_name = _tmp16_;
	_tmp17_ = g_strdup (_ ("Universal Access"));
	_g_free0 (self->a11y_group.label);
	self->a11y_group.label = _tmp17_;
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->a11y_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Decrease Text Size"), "decrease-text-size");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->a11y_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Increase Text Size"), "increase-text-size");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->a11y_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Magnifier Zoom in"), "zoom-in");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->a11y_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Magnifier Zoom out"), "zoom-out");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->a11y_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Toggle On Screen Keyboard"), "on-screen-keyboard");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->a11y_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Toggle Screenreader"), "screenreader");
	keyboard_shortcuts_group_destroy (&self->system_group);
	self->system_group = _tmp18_;
	_tmp19_ = g_strdup ("preferences-system");
	_g_free0 (self->system_group.icon_name);
	self->system_group.icon_name = _tmp19_;
	_tmp20_ = g_strdup (_ ("System"));
	_g_free0 (self->system_group.label);
	self->system_group.label = _tmp20_;
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->system_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Applications Menu"), "panel-main-menu");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->system_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Lock"), "screensaver");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->system_group, KEYBOARD_SHORTCUTS_SCHEMA_MEDIA, _ ("Log Out"), "logout");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->system_group, KEYBOARD_SHORTCUTS_SCHEMA_MUTTER, _ ("Cycle display mode"), "switch-monitor");
	keyboard_shortcuts_group_destroy (&self->keyboard_layouts_group);
	self->keyboard_layouts_group = _tmp21_;
	_tmp22_ = g_strdup ("preferences-desktop-locale");
	_g_free0 (self->keyboard_layouts_group.icon_name);
	self->keyboard_layouts_group.icon_name = _tmp22_;
	_tmp23_ = g_strdup (_ ("Keyboard Layouts"));
	_g_free0 (self->keyboard_layouts_group.label);
	self->keyboard_layouts_group.label = _tmp23_;
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->keyboard_layouts_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Switch Keyboard Layout"), "switch-input-source");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->keyboard_layouts_group, KEYBOARD_SHORTCUTS_SCHEMA_GALA, _ ("Switch Keyboard Layout Backwards"), "switch-input-source-backward");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->keyboard_layouts_group, KEYBOARD_SHORTCUTS_SCHEMA_IBUS, _ ("Enable Emoji Typing"), "hotkey");
	keyboard_shortcuts_shortcuts_list_add_action (self, &self->keyboard_layouts_group, KEYBOARD_SHORTCUTS_SCHEMA_IBUS, _ ("Enable Unicode Typing"), "unicode-hotkey");
	keyboard_shortcuts_group_destroy (&self->custom_group);
	self->custom_group = _tmp24_;
	_tmp25_ = g_strdup ("applications-other");
	_g_free0 (self->custom_group.icon_name);
	self->custom_group.icon_name = _tmp25_;
	_tmp26_ = g_strdup (_ ("Custom"));
	_g_free0 (self->custom_group.label);
	self->custom_group.label = _tmp26_;
	_tmp27_ = self->windows_group;
	_tmp28_ = _tmp27_;
	keyboard_shortcuts_group_copy (&_tmp28_, &_tmp29_);
	_tmp30_ = self->workspaces_group;
	_tmp31_ = _tmp30_;
	keyboard_shortcuts_group_copy (&_tmp31_, &_tmp32_);
	_tmp33_ = self->screenshot_group;
	_tmp34_ = _tmp33_;
	keyboard_shortcuts_group_copy (&_tmp34_, &_tmp35_);
	_tmp36_ = self->launchers_group;
	_tmp37_ = _tmp36_;
	keyboard_shortcuts_group_copy (&_tmp37_, &_tmp38_);
	_tmp39_ = self->media_group;
	_tmp40_ = _tmp39_;
	keyboard_shortcuts_group_copy (&_tmp40_, &_tmp41_);
	_tmp42_ = self->a11y_group;
	_tmp43_ = _tmp42_;
	keyboard_shortcuts_group_copy (&_tmp43_, &_tmp44_);
	_tmp45_ = self->system_group;
	_tmp46_ = _tmp45_;
	keyboard_shortcuts_group_copy (&_tmp46_, &_tmp47_);
	_tmp48_ = self->keyboard_layouts_group;
	_tmp49_ = _tmp48_;
	keyboard_shortcuts_group_copy (&_tmp49_, &_tmp50_);
	_tmp51_ = g_new0 (KeyboardShortcutsGroup, 8);
	_tmp51_[0] = _tmp29_;
	_tmp51_[1] = _tmp32_;
	_tmp51_[2] = _tmp35_;
	_tmp51_[3] = _tmp38_;
	_tmp51_[4] = _tmp41_;
	_tmp51_[5] = _tmp44_;
	_tmp51_[6] = _tmp47_;
	_tmp51_[7] = _tmp50_;
	self->groups = (_vala_KeyboardShortcutsGroup_array_free (self->groups, self->groups_length1), NULL);
	self->groups = _tmp51_;
	self->groups_length1 = 8;
	self->_groups_size_ = self->groups_length1;
	return obj;
}

static void
keyboard_shortcuts_shortcuts_list_class_init (KeyboardShortcutsShortcutsListClass * klass,
                                              gpointer klass_data)
{
	keyboard_shortcuts_shortcuts_list_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = keyboard_shortcuts_shortcuts_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = keyboard_shortcuts_shortcuts_list_finalize;
}

static void
keyboard_shortcuts_shortcuts_list_instance_init (KeyboardShortcutsShortcutsList * self,
                                                 gpointer klass)
{
}

static void
keyboard_shortcuts_shortcuts_list_finalize (GObject * obj)
{
	KeyboardShortcutsShortcutsList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_SHORTCUTS_TYPE_SHORTCUTS_LIST, KeyboardShortcutsShortcutsList);
	self->groups = (_vala_KeyboardShortcutsGroup_array_free (self->groups, self->groups_length1), NULL);
	keyboard_shortcuts_group_destroy (&self->windows_group);
	keyboard_shortcuts_group_destroy (&self->workspaces_group);
	keyboard_shortcuts_group_destroy (&self->screenshot_group);
	keyboard_shortcuts_group_destroy (&self->launchers_group);
	keyboard_shortcuts_group_destroy (&self->media_group);
	keyboard_shortcuts_group_destroy (&self->a11y_group);
	keyboard_shortcuts_group_destroy (&self->system_group);
	keyboard_shortcuts_group_destroy (&self->keyboard_layouts_group);
	keyboard_shortcuts_group_destroy (&self->custom_group);
	G_OBJECT_CLASS (keyboard_shortcuts_shortcuts_list_parent_class)->finalize (obj);
}

static GType
keyboard_shortcuts_shortcuts_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardShortcutsShortcutsListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_shortcuts_shortcuts_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardShortcutsShortcutsList), 0, (GInstanceInitFunc) keyboard_shortcuts_shortcuts_list_instance_init, NULL };
	GType keyboard_shortcuts_shortcuts_list_type_id;
	keyboard_shortcuts_shortcuts_list_type_id = g_type_register_static (G_TYPE_OBJECT, "KeyboardShortcutsShortcutsList", &g_define_type_info, 0);
	return keyboard_shortcuts_shortcuts_list_type_id;
}

GType
keyboard_shortcuts_shortcuts_list_get_type (void)
{
	static volatile gsize keyboard_shortcuts_shortcuts_list_type_id__once = 0;
	if (g_once_init_enter (&keyboard_shortcuts_shortcuts_list_type_id__once)) {
		GType keyboard_shortcuts_shortcuts_list_type_id;
		keyboard_shortcuts_shortcuts_list_type_id = keyboard_shortcuts_shortcuts_list_get_type_once ();
		g_once_init_leave (&keyboard_shortcuts_shortcuts_list_type_id__once, keyboard_shortcuts_shortcuts_list_type_id);
	}
	return keyboard_shortcuts_shortcuts_list_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

