/* Agent.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Agent.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include <gio/gio.h>
#include "bluetooth.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#define BLUETOOTH_SERVICES_AGENT_PATH "/org/bluez/agent/elementary"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BLUETOOTH_SERVICES_AGENT_0_PROPERTY,
	BLUETOOTH_SERVICES_AGENT_READY_PROPERTY,
	BLUETOOTH_SERVICES_AGENT_NUM_PROPERTIES
};
static GParamSpec* bluetooth_services_agent_properties[BLUETOOTH_SERVICES_AGENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BluetoothServicesAgentRequestPinCodeData BluetoothServicesAgentRequestPinCodeData;
typedef struct _BluetoothServicesAgentDisplayPinCodeData BluetoothServicesAgentDisplayPinCodeData;
typedef struct _BluetoothServicesAgentRequestPasskeyData BluetoothServicesAgentRequestPasskeyData;
typedef struct _BluetoothServicesAgentDisplayPasskeyData BluetoothServicesAgentDisplayPasskeyData;
typedef struct _BluetoothServicesAgentRequestConfirmationData BluetoothServicesAgentRequestConfirmationData;
typedef struct _BluetoothServicesAgentRequestAuthorizationData BluetoothServicesAgentRequestAuthorizationData;
typedef struct _Block3Data Block3Data;
typedef struct _BluetoothServicesAgentCheckPairingResponseData BluetoothServicesAgentCheckPairingResponseData;
enum  {
	BLUETOOTH_SERVICES_AGENT_UNREGISTERED_SIGNAL,
	BLUETOOTH_SERVICES_AGENT_NUM_SIGNALS
};
static guint bluetooth_services_agent_signals[BLUETOOTH_SERVICES_AGENT_NUM_SIGNALS] = {0};
typedef struct _BluetoothServicesAgentRequestPinCodeReadyData BluetoothServicesAgentRequestPinCodeReadyData;
typedef struct _BluetoothServicesAgentDisplayPinCodeReadyData BluetoothServicesAgentDisplayPinCodeReadyData;
typedef struct _BluetoothServicesAgentRequestPasskeyReadyData BluetoothServicesAgentRequestPasskeyReadyData;
typedef struct _BluetoothServicesAgentDisplayPasskeyReadyData BluetoothServicesAgentDisplayPasskeyReadyData;
typedef struct _BluetoothServicesAgentRequestConfirmationReadyData BluetoothServicesAgentRequestConfirmationReadyData;
typedef struct _BluetoothServicesAgentRequestAuthorizationReadyData BluetoothServicesAgentRequestAuthorizationReadyData;

struct _BluetoothServicesAgentPrivate {
	GtkWindow* main_window;
	PairDialog* pair_dialog;
	gboolean _ready;
};

struct _BluetoothServicesAgentRequestPinCodeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesAgent* self;
	char* device;
	gchar* result;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _BluetoothServicesAgentDisplayPinCodeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesAgent* self;
	char* device;
	gchar* pincode;
	GtkWindow* _tmp0_;
	PairDialog* _tmp1_;
	PairDialog* _tmp2_;
	GError* _inner_error0_;
};

struct _BluetoothServicesAgentRequestPasskeyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesAgent* self;
	char* device;
	guint32 result;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _BluetoothServicesAgentDisplayPasskeyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesAgent* self;
	char* device;
	guint32 passkey;
	guint16 entered;
	GtkWindow* _tmp0_;
	PairDialog* _tmp1_;
	PairDialog* _tmp2_;
	GError* _inner_error0_;
};

struct _BluetoothServicesAgentRequestConfirmationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesAgent* self;
	char* device;
	guint32 passkey;
	GtkWindow* _tmp0_;
	PairDialog* _tmp1_;
	PairDialog* _tmp2_;
	GError* _inner_error0_;
};

struct _BluetoothServicesAgentRequestAuthorizationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesAgent* self;
	char* device;
	GtkWindow* _tmp0_;
	PairDialog* _tmp1_;
	PairDialog* _tmp2_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	BluetoothServicesAgent* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GError* _error_;
	PairDialog* dialog;
	gpointer _async_data_;
};

struct _BluetoothServicesAgentCheckPairingResponseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesAgent* self;
	PairDialog* dialog;
	Block3Data* _data3_;
	GError* _tmp0_;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _inner_error0_;
};

struct _BluetoothServicesAgentRequestPinCodeReadyData {
	GDBusMethodInvocation* _invocation_;
	char* device;
};

struct _BluetoothServicesAgentDisplayPinCodeReadyData {
	GDBusMethodInvocation* _invocation_;
	char* device;
	gchar* pincode;
};

struct _BluetoothServicesAgentRequestPasskeyReadyData {
	GDBusMethodInvocation* _invocation_;
	char* device;
};

struct _BluetoothServicesAgentDisplayPasskeyReadyData {
	GDBusMethodInvocation* _invocation_;
	char* device;
	guint32 passkey;
	guint16 entered;
};

struct _BluetoothServicesAgentRequestConfirmationReadyData {
	GDBusMethodInvocation* _invocation_;
	char* device;
	guint32 passkey;
};

struct _BluetoothServicesAgentRequestAuthorizationReadyData {
	GDBusMethodInvocation* _invocation_;
	char* device;
};

static gint BluetoothServicesAgent_private_offset;
static gpointer bluetooth_services_agent_parent_class = NULL;

static void __lambda5_ (BluetoothServicesAgent* self,
                 GDBusConnection* connection,
                 const gchar* name);
static void bluetooth_services_agent_set_ready (BluetoothServicesAgent* self,
                                         gboolean value);
static void ___lambda5__gbus_acquired_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         gpointer self);
static void __lambda6_ (BluetoothServicesAgent* self,
                 GDBusConnection* connection,
                 const gchar* name);
static void ___lambda6__gbus_name_acquired_callback (GDBusConnection* connection,
                                              const gchar* name,
                                              gpointer self);
static void __lambda7_ (BluetoothServicesAgent* self,
                 GDBusConnection* connection,
                 const gchar* name);
static void ___lambda7__gbus_name_lost_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self);
static void bluetooth_services_agent_request_pin_code_data_free (gpointer _data);
static gboolean bluetooth_services_agent_request_pin_code_co (BluetoothServicesAgentRequestPinCodeData* _data_);
static void bluetooth_services_agent_display_pin_code_data_free (gpointer _data);
static gboolean bluetooth_services_agent_display_pin_code_co (BluetoothServicesAgentDisplayPinCodeData* _data_);
static void bluetooth_services_agent_check_pairing_response (BluetoothServicesAgent* self,
                                                      PairDialog* dialog,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void bluetooth_services_agent_check_pairing_response_finish (BluetoothServicesAgent* self,
                                                             GAsyncResult* _res_,
                                                             GError** error);
static void bluetooth_services_agent_display_pin_code_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void bluetooth_services_agent_request_passkey_data_free (gpointer _data);
static gboolean bluetooth_services_agent_request_passkey_co (BluetoothServicesAgentRequestPasskeyData* _data_);
static void bluetooth_services_agent_display_passkey_data_free (gpointer _data);
static gboolean bluetooth_services_agent_display_passkey_co (BluetoothServicesAgentDisplayPasskeyData* _data_);
static void bluetooth_services_agent_display_passkey_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void bluetooth_services_agent_request_confirmation_data_free (gpointer _data);
static gboolean bluetooth_services_agent_request_confirmation_co (BluetoothServicesAgentRequestConfirmationData* _data_);
static void bluetooth_services_agent_request_confirmation_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void bluetooth_services_agent_request_authorization_data_free (gpointer _data);
static gboolean bluetooth_services_agent_request_authorization_co (BluetoothServicesAgentRequestAuthorizationData* _data_);
static void bluetooth_services_agent_request_authorization_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static BluetoothServicesDevice* bluetooth_services_agent_get_device_from_object_path (BluetoothServicesAgent* self,
                                                                               const char* object_path,
                                                                               GError** error);
static void bluetooth_services_agent_check_pairing_response_data_free (gpointer _data);
static gboolean bluetooth_services_agent_check_pairing_response_co (BluetoothServicesAgentCheckPairingResponseData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean _bluetooth_services_agent_check_pairing_response_co_gsource_func (gpointer self);
static void __lambda8_ (Block3Data* _data3_,
                 gint response);
static void ___lambda8__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
static void bluetooth_services_agent_finalize (GObject * obj);
static GType bluetooth_services_agent_get_type_once (void);
static void _vala_bluetooth_services_agent_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_bluetooth_services_agent_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _dbus_bluetooth_services_agent_release (BluetoothServicesAgent* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_request_pin_code (BluetoothServicesAgent* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_request_pin_code_ready (GObject * source_object,
                                                            GAsyncResult * _res_,
                                                            gpointer _user_data_);
static void _dbus_bluetooth_services_agent_display_pin_code (BluetoothServicesAgent* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_display_pin_code_ready (GObject * source_object,
                                                            GAsyncResult * _res_,
                                                            gpointer _user_data_);
static void _dbus_bluetooth_services_agent_request_passkey (BluetoothServicesAgent* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_request_passkey_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_);
static void _dbus_bluetooth_services_agent_display_passkey (BluetoothServicesAgent* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_display_passkey_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_);
static void _dbus_bluetooth_services_agent_request_confirmation (BluetoothServicesAgent* self,
                                                          GVariant* _parameters_,
                                                          GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_request_confirmation_ready (GObject * source_object,
                                                                GAsyncResult * _res_,
                                                                gpointer _user_data_);
static void _dbus_bluetooth_services_agent_request_authorization (BluetoothServicesAgent* self,
                                                           GVariant* _parameters_,
                                                           GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_request_authorization_ready (GObject * source_object,
                                                                 GAsyncResult * _res_,
                                                                 gpointer _user_data_);
static void _dbus_bluetooth_services_agent_authorize_service (BluetoothServicesAgent* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_cancel (BluetoothServicesAgent* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void bluetooth_services_agent_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data);
static GVariant* bluetooth_services_agent_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data);
static gboolean bluetooth_services_agent_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data);
static void _bluetooth_services_agent_unregister_object (gpointer user_data);

static const GDBusErrorEntry bluez_error_entries[] = {{BLUEZ_ERROR_REJECTED, "org.bluez.Error.Rejected"}, {BLUEZ_ERROR_CANCELED, "org.bluez.Error.Canceled"}};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_release_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_release_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_dbus_method_info_release = {-1, "Release", (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_release_in), (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_release_out), NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_request_pin_code_device = {-1, "device", "o", NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_request_pin_code_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_request_pin_code_in[] = {&_bluetooth_services_agent_dbus_arg_info_request_pin_code_device, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_request_pin_code_out[] = {&_bluetooth_services_agent_dbus_arg_info_request_pin_code_result, NULL};
static const GDBusMethodInfo _bluetooth_services_agent_dbus_method_info_request_pin_code = {-1, "RequestPinCode", (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_request_pin_code_in), (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_request_pin_code_out), NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_display_pin_code_device = {-1, "device", "o", NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_display_pin_code_pincode = {-1, "pincode", "s", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_display_pin_code_in[] = {&_bluetooth_services_agent_dbus_arg_info_display_pin_code_device, &_bluetooth_services_agent_dbus_arg_info_display_pin_code_pincode, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_display_pin_code_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_dbus_method_info_display_pin_code = {-1, "DisplayPinCode", (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_display_pin_code_in), (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_display_pin_code_out), NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_request_passkey_device = {-1, "device", "o", NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_request_passkey_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_request_passkey_in[] = {&_bluetooth_services_agent_dbus_arg_info_request_passkey_device, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_request_passkey_out[] = {&_bluetooth_services_agent_dbus_arg_info_request_passkey_result, NULL};
static const GDBusMethodInfo _bluetooth_services_agent_dbus_method_info_request_passkey = {-1, "RequestPasskey", (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_request_passkey_in), (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_request_passkey_out), NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_display_passkey_device = {-1, "device", "o", NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_display_passkey_passkey = {-1, "passkey", "u", NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_display_passkey_entered = {-1, "entered", "q", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_display_passkey_in[] = {&_bluetooth_services_agent_dbus_arg_info_display_passkey_device, &_bluetooth_services_agent_dbus_arg_info_display_passkey_passkey, &_bluetooth_services_agent_dbus_arg_info_display_passkey_entered, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_display_passkey_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_dbus_method_info_display_passkey = {-1, "DisplayPasskey", (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_display_passkey_in), (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_display_passkey_out), NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_request_confirmation_device = {-1, "device", "o", NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_request_confirmation_passkey = {-1, "passkey", "u", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_request_confirmation_in[] = {&_bluetooth_services_agent_dbus_arg_info_request_confirmation_device, &_bluetooth_services_agent_dbus_arg_info_request_confirmation_passkey, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_request_confirmation_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_dbus_method_info_request_confirmation = {-1, "RequestConfirmation", (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_request_confirmation_in), (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_request_confirmation_out), NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_request_authorization_device = {-1, "device", "o", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_request_authorization_in[] = {&_bluetooth_services_agent_dbus_arg_info_request_authorization_device, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_request_authorization_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_dbus_method_info_request_authorization = {-1, "RequestAuthorization", (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_request_authorization_in), (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_request_authorization_out), NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_authorize_service_device_path = {-1, "device_path", "o", NULL};
static const GDBusArgInfo _bluetooth_services_agent_dbus_arg_info_authorize_service_uuid = {-1, "uuid", "s", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_authorize_service_in[] = {&_bluetooth_services_agent_dbus_arg_info_authorize_service_device_path, &_bluetooth_services_agent_dbus_arg_info_authorize_service_uuid, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_authorize_service_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_dbus_method_info_authorize_service = {-1, "AuthorizeService", (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_authorize_service_in), (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_authorize_service_out), NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_cancel_in[] = {NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_dbus_arg_info_cancel_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_dbus_method_info_cancel = {-1, "Cancel", (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_cancel_in), (GDBusArgInfo **) (&_bluetooth_services_agent_dbus_arg_info_cancel_out), NULL};
static const GDBusMethodInfo * const _bluetooth_services_agent_dbus_method_info[] = {&_bluetooth_services_agent_dbus_method_info_release, &_bluetooth_services_agent_dbus_method_info_request_pin_code, &_bluetooth_services_agent_dbus_method_info_display_pin_code, &_bluetooth_services_agent_dbus_method_info_request_passkey, &_bluetooth_services_agent_dbus_method_info_display_passkey, &_bluetooth_services_agent_dbus_method_info_request_confirmation, &_bluetooth_services_agent_dbus_method_info_request_authorization, &_bluetooth_services_agent_dbus_method_info_authorize_service, &_bluetooth_services_agent_dbus_method_info_cancel, NULL};
static const GDBusSignalInfo * const _bluetooth_services_agent_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _bluetooth_services_agent_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _bluetooth_services_agent_dbus_interface_info = {-1, "org.bluez.Agent1", (GDBusMethodInfo **) (&_bluetooth_services_agent_dbus_method_info), (GDBusSignalInfo **) (&_bluetooth_services_agent_dbus_signal_info), (GDBusPropertyInfo **) (&_bluetooth_services_agent_dbus_property_info), NULL};
static const GDBusInterfaceVTable _bluetooth_services_agent_dbus_interface_vtable = {bluetooth_services_agent_dbus_interface_method_call, bluetooth_services_agent_dbus_interface_get_property, bluetooth_services_agent_dbus_interface_set_property};

GQuark
bluez_error_quark (void)
{
	static volatile gsize bluez_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("bluez-error-quark", &bluez_error_quark_volatile, bluez_error_entries, G_N_ELEMENTS (bluez_error_entries));
	return (GQuark) bluez_error_quark_volatile;
}

static inline gpointer
bluetooth_services_agent_get_instance_private (BluetoothServicesAgent* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothServicesAgent_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda5_ (BluetoothServicesAgent* self,
            GDBusConnection* connection,
            const gchar* name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	{
		bluetooth_services_agent_register_object (self, connection, BLUETOOTH_SERVICES_AGENT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		bluetooth_services_agent_set_ready (self, TRUE);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_critical ("Agent.vala:42: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda5__gbus_acquired_callback (GDBusConnection* connection,
                                    const gchar* name,
                                    gpointer self)
{
	__lambda5_ ((BluetoothServicesAgent*) self, connection, name);
}

static void
__lambda6_ (BluetoothServicesAgent* self,
            GDBusConnection* connection,
            const gchar* name)
{
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
}

static void
___lambda6__gbus_name_acquired_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         gpointer self)
{
	__lambda6_ ((BluetoothServicesAgent*) self, connection, name);
}

static void
__lambda7_ (BluetoothServicesAgent* self,
            GDBusConnection* connection,
            const gchar* name)
{
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
}

static void
___lambda7__gbus_name_lost_callback (GDBusConnection* connection,
                                     const gchar* name,
                                     gpointer self)
{
	__lambda7_ ((BluetoothServicesAgent*) self, connection, name);
}

BluetoothServicesAgent*
bluetooth_services_agent_construct (GType object_type,
                                    GtkWindow* main_window)
{
	BluetoothServicesAgent * self = NULL;
	GtkWindow* _tmp0_;
	self = (BluetoothServicesAgent*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (main_window);
	_g_object_unref0 (self->priv->main_window);
	self->priv->main_window = _tmp0_;
	g_bus_own_name_with_closures (G_BUS_TYPE_SYSTEM, "org.bluez.AgentManager1", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((___lambda5__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda5__gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda6__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda6__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda7__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda7__gbus_name_lost_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	return self;
}

BluetoothServicesAgent*
bluetooth_services_agent_new (GtkWindow* main_window)
{
	return bluetooth_services_agent_construct (BLUETOOTH_SERVICES_TYPE_AGENT, main_window);
}

char*
bluetooth_services_agent_get_path (BluetoothServicesAgent* self)
{
	char* _tmp0_;
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (BLUETOOTH_SERVICES_AGENT_PATH);
	result = _tmp0_;
	return result;
}

void
bluetooth_services_agent_release (BluetoothServicesAgent* self,
                                  GError** error)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, bluetooth_services_agent_signals[BLUETOOTH_SERVICES_AGENT_UNREGISTERED_SIGNAL], 0);
}

static void
bluetooth_services_agent_request_pin_code_data_free (gpointer _data)
{
	BluetoothServicesAgentRequestPinCodeData* _data_;
	_data_ = _data;
	_g_free0 (_data_->device);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesAgentRequestPinCodeData, _data_);
}

void
bluetooth_services_agent_request_pin_code (BluetoothServicesAgent* self,
                                           const char* device,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	BluetoothServicesAgentRequestPinCodeData* _data_;
	BluetoothServicesAgent* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data_ = g_slice_new0 (BluetoothServicesAgentRequestPinCodeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_agent_request_pin_code_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (device);
	_g_free0 (_data_->device);
	_data_->device = _tmp1_;
	bluetooth_services_agent_request_pin_code_co (_data_);
}

gchar*
bluetooth_services_agent_request_pin_code_finish (BluetoothServicesAgent* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	gchar* result;
	BluetoothServicesAgentRequestPinCodeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
bluetooth_services_agent_request_pin_code_co (BluetoothServicesAgentRequestPinCodeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (BLUEZ_ERROR, BLUEZ_ERROR_REJECTED, "Pairing method not supported");
	_data_->_inner_error0_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_services_agent_display_pin_code_data_free (gpointer _data)
{
	BluetoothServicesAgentDisplayPinCodeData* _data_;
	_data_ = _data;
	_g_free0 (_data_->device);
	_g_free0 (_data_->pincode);
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesAgentDisplayPinCodeData, _data_);
}

void
bluetooth_services_agent_display_pin_code (BluetoothServicesAgent* self,
                                           const char* device,
                                           const gchar* pincode,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	BluetoothServicesAgentDisplayPinCodeData* _data_;
	BluetoothServicesAgent* _tmp0_;
	char* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (pincode != NULL);
	_data_ = g_slice_new0 (BluetoothServicesAgentDisplayPinCodeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_agent_display_pin_code_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (device);
	_g_free0 (_data_->device);
	_data_->device = _tmp1_;
	_tmp2_ = g_strdup (pincode);
	_g_free0 (_data_->pincode);
	_data_->pincode = _tmp2_;
	bluetooth_services_agent_display_pin_code_co (_data_);
}

void
bluetooth_services_agent_display_pin_code_finish (BluetoothServicesAgent* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	BluetoothServicesAgentDisplayPinCodeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
bluetooth_services_agent_display_pin_code_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	BluetoothServicesAgentDisplayPinCodeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_services_agent_display_pin_code_co (_data_);
}

static gboolean
bluetooth_services_agent_display_pin_code_co (BluetoothServicesAgentDisplayPinCodeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->main_window;
	_data_->_tmp1_ = pair_dialog_new_display_pin_code (_data_->device, _data_->pincode, _data_->_tmp0_);
	g_object_ref_sink (_data_->_tmp1_);
	_g_object_unref0 (_data_->self->priv->pair_dialog);
	_data_->self->priv->pair_dialog = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->pair_dialog;
	_data_->_state_ = 1;
	bluetooth_services_agent_check_pairing_response (_data_->self, _data_->_tmp2_, bluetooth_services_agent_display_pin_code_ready, _data_);
	return FALSE;
	_state_1:
	bluetooth_services_agent_check_pairing_response_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_services_agent_request_passkey_data_free (gpointer _data)
{
	BluetoothServicesAgentRequestPasskeyData* _data_;
	_data_ = _data;
	_g_free0 (_data_->device);
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesAgentRequestPasskeyData, _data_);
}

void
bluetooth_services_agent_request_passkey (BluetoothServicesAgent* self,
                                          const char* device,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	BluetoothServicesAgentRequestPasskeyData* _data_;
	BluetoothServicesAgent* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data_ = g_slice_new0 (BluetoothServicesAgentRequestPasskeyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_agent_request_passkey_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (device);
	_g_free0 (_data_->device);
	_data_->device = _tmp1_;
	bluetooth_services_agent_request_passkey_co (_data_);
}

guint32
bluetooth_services_agent_request_passkey_finish (BluetoothServicesAgent* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	guint32 result;
	BluetoothServicesAgentRequestPasskeyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		guint32 _tmp0_ = 0U;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
bluetooth_services_agent_request_passkey_co (BluetoothServicesAgentRequestPasskeyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (BLUEZ_ERROR, BLUEZ_ERROR_REJECTED, "Pairing method not supported");
	_data_->_inner_error0_ = _data_->_tmp0_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_services_agent_display_passkey_data_free (gpointer _data)
{
	BluetoothServicesAgentDisplayPasskeyData* _data_;
	_data_ = _data;
	_g_free0 (_data_->device);
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesAgentDisplayPasskeyData, _data_);
}

void
bluetooth_services_agent_display_passkey (BluetoothServicesAgent* self,
                                          const char* device,
                                          guint32 passkey,
                                          guint16 entered,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	BluetoothServicesAgentDisplayPasskeyData* _data_;
	BluetoothServicesAgent* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data_ = g_slice_new0 (BluetoothServicesAgentDisplayPasskeyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_agent_display_passkey_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (device);
	_g_free0 (_data_->device);
	_data_->device = _tmp1_;
	_data_->passkey = passkey;
	_data_->entered = entered;
	bluetooth_services_agent_display_passkey_co (_data_);
}

void
bluetooth_services_agent_display_passkey_finish (BluetoothServicesAgent* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	BluetoothServicesAgentDisplayPasskeyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
bluetooth_services_agent_display_passkey_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	BluetoothServicesAgentDisplayPasskeyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_services_agent_display_passkey_co (_data_);
}

static gboolean
bluetooth_services_agent_display_passkey_co (BluetoothServicesAgentDisplayPasskeyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->main_window;
	_data_->_tmp1_ = pair_dialog_new_display_passkey (_data_->device, _data_->passkey, _data_->entered, _data_->_tmp0_);
	g_object_ref_sink (_data_->_tmp1_);
	_g_object_unref0 (_data_->self->priv->pair_dialog);
	_data_->self->priv->pair_dialog = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->pair_dialog;
	_data_->_state_ = 1;
	bluetooth_services_agent_check_pairing_response (_data_->self, _data_->_tmp2_, bluetooth_services_agent_display_passkey_ready, _data_);
	return FALSE;
	_state_1:
	bluetooth_services_agent_check_pairing_response_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_services_agent_request_confirmation_data_free (gpointer _data)
{
	BluetoothServicesAgentRequestConfirmationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->device);
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesAgentRequestConfirmationData, _data_);
}

void
bluetooth_services_agent_request_confirmation (BluetoothServicesAgent* self,
                                               const char* device,
                                               guint32 passkey,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	BluetoothServicesAgentRequestConfirmationData* _data_;
	BluetoothServicesAgent* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data_ = g_slice_new0 (BluetoothServicesAgentRequestConfirmationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_agent_request_confirmation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (device);
	_g_free0 (_data_->device);
	_data_->device = _tmp1_;
	_data_->passkey = passkey;
	bluetooth_services_agent_request_confirmation_co (_data_);
}

void
bluetooth_services_agent_request_confirmation_finish (BluetoothServicesAgent* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	BluetoothServicesAgentRequestConfirmationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
bluetooth_services_agent_request_confirmation_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	BluetoothServicesAgentRequestConfirmationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_services_agent_request_confirmation_co (_data_);
}

static gboolean
bluetooth_services_agent_request_confirmation_co (BluetoothServicesAgentRequestConfirmationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->main_window;
	_data_->_tmp1_ = pair_dialog_new_request_confirmation (_data_->device, _data_->passkey, _data_->_tmp0_);
	g_object_ref_sink (_data_->_tmp1_);
	_g_object_unref0 (_data_->self->priv->pair_dialog);
	_data_->self->priv->pair_dialog = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->pair_dialog;
	_data_->_state_ = 1;
	bluetooth_services_agent_check_pairing_response (_data_->self, _data_->_tmp2_, bluetooth_services_agent_request_confirmation_ready, _data_);
	return FALSE;
	_state_1:
	bluetooth_services_agent_check_pairing_response_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_services_agent_request_authorization_data_free (gpointer _data)
{
	BluetoothServicesAgentRequestAuthorizationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->device);
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesAgentRequestAuthorizationData, _data_);
}

void
bluetooth_services_agent_request_authorization (BluetoothServicesAgent* self,
                                                const char* device,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	BluetoothServicesAgentRequestAuthorizationData* _data_;
	BluetoothServicesAgent* _tmp0_;
	char* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data_ = g_slice_new0 (BluetoothServicesAgentRequestAuthorizationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_agent_request_authorization_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (device);
	_g_free0 (_data_->device);
	_data_->device = _tmp1_;
	bluetooth_services_agent_request_authorization_co (_data_);
}

void
bluetooth_services_agent_request_authorization_finish (BluetoothServicesAgent* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	BluetoothServicesAgentRequestAuthorizationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
bluetooth_services_agent_request_authorization_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	BluetoothServicesAgentRequestAuthorizationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_services_agent_request_authorization_co (_data_);
}

static gboolean
bluetooth_services_agent_request_authorization_co (BluetoothServicesAgentRequestAuthorizationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->main_window;
	_data_->_tmp1_ = pair_dialog_new_request_authorization (_data_->device, _data_->_tmp0_);
	g_object_ref_sink (_data_->_tmp1_);
	_g_object_unref0 (_data_->self->priv->pair_dialog);
	_data_->self->priv->pair_dialog = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->pair_dialog;
	_data_->_state_ = 1;
	bluetooth_services_agent_check_pairing_response (_data_->self, _data_->_tmp2_, bluetooth_services_agent_request_authorization_ready, _data_);
	return FALSE;
	_state_1:
	bluetooth_services_agent_check_pairing_response_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
bluetooth_services_agent_authorize_service (BluetoothServicesAgent* self,
                                            const char* device_path,
                                            const gchar* uuid,
                                            GError** error)
{
	BluetoothServicesDevice* device = NULL;
	BluetoothServicesDevice* _tmp0_;
	gboolean paired = FALSE;
	BluetoothServicesDevice* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean trusted = FALSE;
	BluetoothServicesDevice* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GError* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_path != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = bluetooth_services_agent_get_device_from_object_path (self, device_path, &_inner_error0_);
	device = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = device;
	_tmp2_ = bluetooth_services_device_get_paired (_tmp1_);
	_tmp3_ = _tmp2_;
	paired = _tmp3_;
	_tmp4_ = device;
	_tmp5_ = bluetooth_services_device_get_trusted (_tmp4_);
	_tmp6_ = _tmp5_;
	trusted = _tmp6_;
	if (paired) {
		_tmp7_ = trusted;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_g_object_unref0 (device);
		return;
	}
	if (paired) {
		_tmp8_ = !trusted;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		BluetoothServicesDevice* _tmp9_;
		_tmp9_ = device;
		bluetooth_services_device_set_trusted (_tmp9_, TRUE);
		_g_object_unref0 (device);
		return;
	}
	_tmp10_ = g_error_new_literal (BLUEZ_ERROR, BLUEZ_ERROR_REJECTED, "Rejecting service auth, not paired or trusted");
	_inner_error0_ = _tmp10_;
	g_propagate_error (error, _inner_error0_);
	_g_object_unref0 (device);
	return;
}

void
bluetooth_services_agent_cancel (BluetoothServicesAgent* self,
                                 GError** error)
{
	PairDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pair_dialog;
	if (_tmp0_ != NULL) {
		PairDialog* _tmp1_;
		PairDialog* _tmp2_;
		_tmp1_ = self->priv->pair_dialog;
		pair_dialog_set_cancelled (_tmp1_, TRUE);
		_tmp2_ = self->priv->pair_dialog;
		gtk_window_destroy ((GtkWindow*) _tmp2_);
	}
}

static void
bluetooth_services_agent_check_pairing_response_data_free (gpointer _data)
{
	BluetoothServicesAgentCheckPairingResponseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesAgentCheckPairingResponseData, _data_);
}

static void
bluetooth_services_agent_check_pairing_response (BluetoothServicesAgent* self,
                                                 PairDialog* dialog,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	BluetoothServicesAgentCheckPairingResponseData* _data_;
	BluetoothServicesAgent* _tmp0_;
	PairDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_data_ = g_slice_new0 (BluetoothServicesAgentCheckPairingResponseData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_agent_check_pairing_response_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (dialog);
	_g_object_unref0 (_data_->dialog);
	_data_->dialog = _tmp1_;
	bluetooth_services_agent_check_pairing_response_co (_data_);
}

static void
bluetooth_services_agent_check_pairing_response_finish (BluetoothServicesAgent* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	BluetoothServicesAgentCheckPairingResponseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BluetoothServicesAgent* self;
		self = _data3_->self;
		_g_error_free0 (_data3_->_error_);
		(_data3_->callback_target_destroy_notify == NULL) ? NULL : (_data3_->callback_target_destroy_notify (_data3_->callback_target), NULL);
		_data3_->callback = NULL;
		_data3_->callback_target = NULL;
		_data3_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
_bluetooth_services_agent_check_pairing_response_co_gsource_func (gpointer self)
{
	gboolean result;
	result = bluetooth_services_agent_check_pairing_response_co (self);
	return result;
}

static void
__lambda8_ (Block3Data* _data3_,
            gint response)
{
	BluetoothServicesAgent* self;
	gboolean _tmp0_ = FALSE;
	GSourceFunc _tmp7_;
	gpointer _tmp7__target;
	GDestroyNotify _tmp7__target_destroy_notify;
	self = _data3_->self;
	if (response != ((gint) GTK_RESPONSE_ACCEPT)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = pair_dialog_get_cancelled (_data3_->dialog);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = pair_dialog_get_cancelled (_data3_->dialog);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			GError* _tmp5_;
			_tmp5_ = g_error_new_literal (BLUEZ_ERROR, BLUEZ_ERROR_CANCELED, "Pairing cancelled");
			_g_error_free0 (_data3_->_error_);
			_data3_->_error_ = _tmp5_;
		} else {
			GError* _tmp6_;
			_tmp6_ = g_error_new_literal (BLUEZ_ERROR, BLUEZ_ERROR_REJECTED, "Pairing rejected");
			_g_error_free0 (_data3_->_error_);
			_data3_->_error_ = _tmp6_;
		}
	}
	_tmp7_ = _data3_->callback;
	_tmp7__target = _data3_->callback_target;
	_tmp7__target_destroy_notify = _data3_->callback_target_destroy_notify;
	_data3_->callback = NULL;
	_data3_->callback_target = NULL;
	_data3_->callback_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp7_, _tmp7__target, _tmp7__target_destroy_notify);
	gtk_window_destroy ((GtkWindow*) _data3_->dialog);
}

static void
___lambda8__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda8_ (self, response_id);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
bluetooth_services_agent_check_pairing_response_co (BluetoothServicesAgentCheckPairingResponseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data3_->dialog);
	_data_->_data3_->dialog = _data_->dialog;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_data3_->callback = _bluetooth_services_agent_check_pairing_response_co_gsource_func;
	_data_->_data3_->callback_target = _data_;
	_data_->_data3_->callback_target_destroy_notify = NULL;
	_data_->_data3_->_error_ = NULL;
	g_signal_connect_data ((GtkDialog*) _data_->_data3_->dialog, "response", (GCallback) ___lambda8__gtk_dialog_response, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data_->_data3_->dialog);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = _data_->_data3_->_error_;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = _data_->_data3_->_error_;
		_data_->_tmp2_ = _g_error_copy0 (_data_->_tmp1_);
		_data_->_inner_error0_ = _data_->_tmp2_;
		if (_data_->_inner_error0_->domain == BLUEZ_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static BluetoothServicesDevice*
bluetooth_services_agent_get_device_from_object_path (BluetoothServicesAgent* self,
                                                      const char* object_path,
                                                      GError** error)
{
	BluetoothServicesDevice* _tmp0_ = NULL;
	BluetoothServicesDevice* _tmp1_;
	BluetoothServicesDevice* _tmp2_;
	GError* _inner_error0_ = NULL;
	BluetoothServicesDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	_tmp1_ = (BluetoothServicesDevice*) g_initable_new (BLUETOOTH_SERVICES_TYPE_DEVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.bluez", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", (const gchar*) object_path, "g-interface-name", "org.bluez.Device1", NULL);
	_tmp0_ = (BluetoothServicesDevice*) _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

gboolean
bluetooth_services_agent_get_ready (BluetoothServicesAgent* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ready;
	return result;
}

static void
bluetooth_services_agent_set_ready (BluetoothServicesAgent* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_services_agent_get_ready (self);
	if (old_value != value) {
		self->priv->_ready = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_services_agent_properties[BLUETOOTH_SERVICES_AGENT_READY_PROPERTY]);
	}
}

static void
bluetooth_services_agent_class_init (BluetoothServicesAgentClass * klass,
                                     gpointer klass_data)
{
	bluetooth_services_agent_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothServicesAgent_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bluetooth_services_agent_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bluetooth_services_agent_set_property;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_services_agent_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_SERVICES_AGENT_READY_PROPERTY, bluetooth_services_agent_properties[BLUETOOTH_SERVICES_AGENT_READY_PROPERTY] = g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	bluetooth_services_agent_signals[BLUETOOTH_SERVICES_AGENT_UNREGISTERED_SIGNAL] = g_signal_new ("unregistered", BLUETOOTH_SERVICES_TYPE_AGENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bluetooth_services_agent_instance_init (BluetoothServicesAgent * self,
                                        gpointer klass)
{
	self->priv = bluetooth_services_agent_get_instance_private (self);
}

static void
bluetooth_services_agent_finalize (GObject * obj)
{
	BluetoothServicesAgent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_SERVICES_TYPE_AGENT, BluetoothServicesAgent);
	_g_object_unref0 (self->priv->main_window);
	_g_object_unref0 (self->priv->pair_dialog);
	G_OBJECT_CLASS (bluetooth_services_agent_parent_class)->finalize (obj);
}

static GType
bluetooth_services_agent_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothServicesAgentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_services_agent_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothServicesAgent), 0, (GInstanceInitFunc) bluetooth_services_agent_instance_init, NULL };
	GType bluetooth_services_agent_type_id;
	bluetooth_services_agent_type_id = g_type_register_static (G_TYPE_OBJECT, "BluetoothServicesAgent", &g_define_type_info, 0);
	g_type_set_qdata (bluetooth_services_agent_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) bluetooth_services_agent_register_object);
	BluetoothServicesAgent_private_offset = g_type_add_instance_private (bluetooth_services_agent_type_id, sizeof (BluetoothServicesAgentPrivate));
	return bluetooth_services_agent_type_id;
}

GType
bluetooth_services_agent_get_type (void)
{
	static volatile gsize bluetooth_services_agent_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_services_agent_type_id__once)) {
		GType bluetooth_services_agent_type_id;
		bluetooth_services_agent_type_id = bluetooth_services_agent_get_type_once ();
		g_once_init_leave (&bluetooth_services_agent_type_id__once, bluetooth_services_agent_type_id);
	}
	return bluetooth_services_agent_type_id__once;
}

static void
_vala_bluetooth_services_agent_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	BluetoothServicesAgent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_SERVICES_TYPE_AGENT, BluetoothServicesAgent);
	switch (property_id) {
		case BLUETOOTH_SERVICES_AGENT_READY_PROPERTY:
		g_value_set_boolean (value, bluetooth_services_agent_get_ready (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bluetooth_services_agent_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	BluetoothServicesAgent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_SERVICES_TYPE_AGENT, BluetoothServicesAgent);
	switch (property_id) {
		case BLUETOOTH_SERVICES_AGENT_READY_PROPERTY:
		bluetooth_services_agent_set_ready (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_bluetooth_services_agent_release (BluetoothServicesAgent* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	bluetooth_services_agent_release (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_bluetooth_services_agent_request_pin_code (BluetoothServicesAgent* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothServicesAgentRequestPinCodeReadyData* _ready_data;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothServicesAgentRequestPinCodeReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->device = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	bluetooth_services_agent_request_pin_code (self, _ready_data->device, (GAsyncReadyCallback) _dbus_bluetooth_services_agent_request_pin_code_ready, _ready_data);
	_error:
	;
}

static void
_dbus_bluetooth_services_agent_request_pin_code_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_)
{
	BluetoothServicesAgentRequestPinCodeReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = bluetooth_services_agent_request_pin_code_finish ((BluetoothServicesAgent*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->device);
	g_slice_free (BluetoothServicesAgentRequestPinCodeReadyData, _ready_data);
}

static void
_dbus_bluetooth_services_agent_display_pin_code (BluetoothServicesAgent* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothServicesAgentDisplayPinCodeReadyData* _ready_data;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothServicesAgentDisplayPinCodeReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->device = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->pincode = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	bluetooth_services_agent_display_pin_code (self, _ready_data->device, _ready_data->pincode, (GAsyncReadyCallback) _dbus_bluetooth_services_agent_display_pin_code_ready, _ready_data);
	_error:
	;
}

static void
_dbus_bluetooth_services_agent_display_pin_code_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_)
{
	BluetoothServicesAgentDisplayPinCodeReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	bluetooth_services_agent_display_pin_code_finish ((BluetoothServicesAgent*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->device);
	_g_free0 (_ready_data->pincode);
	g_slice_free (BluetoothServicesAgentDisplayPinCodeReadyData, _ready_data);
}

static void
_dbus_bluetooth_services_agent_request_passkey (BluetoothServicesAgent* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothServicesAgentRequestPasskeyReadyData* _ready_data;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothServicesAgentRequestPasskeyReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->device = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	bluetooth_services_agent_request_passkey (self, _ready_data->device, (GAsyncReadyCallback) _dbus_bluetooth_services_agent_request_passkey_ready, _ready_data);
	_error:
	;
}

static void
_dbus_bluetooth_services_agent_request_passkey_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_)
{
	BluetoothServicesAgentRequestPasskeyReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = bluetooth_services_agent_request_passkey_finish ((BluetoothServicesAgent*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->device);
	g_slice_free (BluetoothServicesAgentRequestPasskeyReadyData, _ready_data);
}

static void
_dbus_bluetooth_services_agent_display_passkey (BluetoothServicesAgent* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothServicesAgentDisplayPasskeyReadyData* _ready_data;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothServicesAgentDisplayPasskeyReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->device = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->passkey = g_variant_get_uint32 (_tmp5_);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->entered = g_variant_get_uint16 (_tmp6_);
	g_variant_unref (_tmp6_);
	bluetooth_services_agent_display_passkey (self, _ready_data->device, _ready_data->passkey, _ready_data->entered, (GAsyncReadyCallback) _dbus_bluetooth_services_agent_display_passkey_ready, _ready_data);
	_error:
	;
}

static void
_dbus_bluetooth_services_agent_display_passkey_ready (GObject * source_object,
                                                      GAsyncResult * _res_,
                                                      gpointer _user_data_)
{
	BluetoothServicesAgentDisplayPasskeyReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	bluetooth_services_agent_display_passkey_finish ((BluetoothServicesAgent*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->device);
	g_slice_free (BluetoothServicesAgentDisplayPasskeyReadyData, _ready_data);
}

static void
_dbus_bluetooth_services_agent_request_confirmation (BluetoothServicesAgent* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothServicesAgentRequestConfirmationReadyData* _ready_data;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothServicesAgentRequestConfirmationReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->device = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->passkey = g_variant_get_uint32 (_tmp8_);
	g_variant_unref (_tmp8_);
	bluetooth_services_agent_request_confirmation (self, _ready_data->device, _ready_data->passkey, (GAsyncReadyCallback) _dbus_bluetooth_services_agent_request_confirmation_ready, _ready_data);
	_error:
	;
}

static void
_dbus_bluetooth_services_agent_request_confirmation_ready (GObject * source_object,
                                                           GAsyncResult * _res_,
                                                           gpointer _user_data_)
{
	BluetoothServicesAgentRequestConfirmationReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	bluetooth_services_agent_request_confirmation_finish ((BluetoothServicesAgent*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->device);
	g_slice_free (BluetoothServicesAgentRequestConfirmationReadyData, _ready_data);
}

static void
_dbus_bluetooth_services_agent_request_authorization (BluetoothServicesAgent* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BluetoothServicesAgentRequestAuthorizationReadyData* _ready_data;
	GVariant* _tmp9_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BluetoothServicesAgentRequestAuthorizationReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->device = g_variant_dup_string (_tmp9_, NULL);
	g_variant_unref (_tmp9_);
	bluetooth_services_agent_request_authorization (self, _ready_data->device, (GAsyncReadyCallback) _dbus_bluetooth_services_agent_request_authorization_ready, _ready_data);
	_error:
	;
}

static void
_dbus_bluetooth_services_agent_request_authorization_ready (GObject * source_object,
                                                            GAsyncResult * _res_,
                                                            gpointer _user_data_)
{
	BluetoothServicesAgentRequestAuthorizationReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	bluetooth_services_agent_request_authorization_finish ((BluetoothServicesAgent*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->device);
	g_slice_free (BluetoothServicesAgentRequestAuthorizationReadyData, _ready_data);
}

static void
_dbus_bluetooth_services_agent_authorize_service (BluetoothServicesAgent* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	char* device_path = NULL;
	GVariant* _tmp10_;
	gchar* uuid = NULL;
	GVariant* _tmp11_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	device_path = g_variant_dup_string (_tmp10_, NULL);
	g_variant_unref (_tmp10_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	uuid = g_variant_dup_string (_tmp11_, NULL);
	g_variant_unref (_tmp11_);
	bluetooth_services_agent_authorize_service (self, device_path, uuid, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (device_path);
	_g_free0 (uuid);
	;
}

static void
_dbus_bluetooth_services_agent_cancel (BluetoothServicesAgent* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	bluetooth_services_agent_cancel (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
bluetooth_services_agent_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Release") == 0) {
		_dbus_bluetooth_services_agent_release (object, parameters, invocation);
	} else if (strcmp (method_name, "RequestPinCode") == 0) {
		_dbus_bluetooth_services_agent_request_pin_code (object, parameters, invocation);
	} else if (strcmp (method_name, "DisplayPinCode") == 0) {
		_dbus_bluetooth_services_agent_display_pin_code (object, parameters, invocation);
	} else if (strcmp (method_name, "RequestPasskey") == 0) {
		_dbus_bluetooth_services_agent_request_passkey (object, parameters, invocation);
	} else if (strcmp (method_name, "DisplayPasskey") == 0) {
		_dbus_bluetooth_services_agent_display_passkey (object, parameters, invocation);
	} else if (strcmp (method_name, "RequestConfirmation") == 0) {
		_dbus_bluetooth_services_agent_request_confirmation (object, parameters, invocation);
	} else if (strcmp (method_name, "RequestAuthorization") == 0) {
		_dbus_bluetooth_services_agent_request_authorization (object, parameters, invocation);
	} else if (strcmp (method_name, "AuthorizeService") == 0) {
		_dbus_bluetooth_services_agent_authorize_service (object, parameters, invocation);
	} else if (strcmp (method_name, "Cancel") == 0) {
		_dbus_bluetooth_services_agent_cancel (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
bluetooth_services_agent_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
bluetooth_services_agent_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
bluetooth_services_agent_register_object (gpointer object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_bluetooth_services_agent_dbus_interface_info), &_bluetooth_services_agent_dbus_interface_vtable, data, _bluetooth_services_agent_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_bluetooth_services_agent_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

