/* This is a generated file! */
/* Generated by `utils/build_lexers.py` via `utils/rustify.py` */
/* This process can be run via tox: `tox -e generate-rs` */
#![cfg_attr(rustfmt, rustfmt_skip)]
use once_cell::sync::Lazy;
use sqlfluffrs_types::LexMatcher;
use sqlfluffrs_types::{Token, RegexModeGroup};
use sqlfluffrs_types::token::CaseFold;

pub static TERADATA_KEYWORDS: Lazy<Vec<String>> = Lazy::new(|| { vec![
    "CASE".to_string(),
    "CROSS".to_string(),
    "FULL".to_string(),
    "IGNORE".to_string(),
    "INNER".to_string(),
    "INTERVAL".to_string(),
    "JOIN".to_string(),
    "LEFT".to_string(),
    "LOCKING".to_string(),
    "NATURAL".to_string(),
    "NOT".to_string(),
    "NULL".to_string(),
    "ON".to_string(),
    "ORDER".to_string(),
    "OUTER".to_string(),
    "PARTITION".to_string(),
    "REPLACE".to_string(),
    "RESPECT".to_string(),
    "RIGHT".to_string(),
    "ROWS".to_string(),
    "SELECT".to_string(),
    "SET".to_string(),
    "TIMESTAMP".to_string(),
    "UNION".to_string(),
    "USING".to_string(),
]});

pub static TERADATA_LEXERS: Lazy<Vec<LexMatcher>> = Lazy::new(|| { vec![

    LexMatcher::regex_lexer(
        "whitespace",
        r#"[^\S\r\n]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::whitespace_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "inline_comment",
        r#"(--|#)[^\n]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        Some(vec![String::from("--"), String::from("#")]),
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| input.starts_with(['#','-','/']),
        None,
    ),

    LexMatcher::regex_lexer(
        "block_comment",
        r#"\/\*([^\*]|\*(?!\/))*\*\/"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        Some(Box::new(
    LexMatcher::regex_subdivider(
        "newline",
        r#"\r\n|\n"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::newline_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ))),
        Some(Box::new(
    LexMatcher::regex_subdivider(
        "whitespace",
        r#"[^\S\r\n]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::whitespace_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ))),
        None,
        None,
        None,
        None,
        CaseFold::None,
        Some(extract_nested_block_comment),
        |input| input.starts_with("/"),
        None,
    ),

    LexMatcher::regex_lexer(
        "single_quote",
        r#"'([^'\\]|\\.|'')*'"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"'((?:[^'\\]|\\.|'')*)'"#.to_string(), RegexModeGroup::Index(1))),
        Some((r#"\\'|''"#.to_string(), r#"'"#.to_string())),
        CaseFold::None,
        None,
        |input| match input.as_bytes() {
        [b'\'', ..] => true,                     // Single quote case
        [b'R' | b'r', b'\'', ..] => true,        // r' or R'
        [b'B' | b'b', b'\'', ..] => true,        // b' or B'
        [b'R' | b'r', b'B' | b'b', b'\'', ..] => true, // rb', RB', etc.
        [b'B' | b'b', b'R' | b'r', b'\'', ..] => true, // br', Br', etc.
        _ => false,
    },
        None,
    ),

    LexMatcher::regex_lexer(
        "double_quote",
        r#""(""|[^"\\]|\\.)*""#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#""((?:[^"\\]|\\.)*)""#.to_string(), RegexModeGroup::Index(1))),
        Some((r#"\\"|"""#.to_string(), r#"""#.to_string())),
        CaseFold::None,
        None,
        |input| match input.as_bytes() {
        [b'"', ..] => true,                     // Just a double quote
        [b'R' | b'r', b'"', ..] => true,        // r" or R"
        [b'B' | b'b', b'"', ..] => true,        // b" or B"
        [b'R' | b'r', b'B' | b'b', b'"', ..] => true, // rb", RB", etc.
        [b'B' | b'b', b'R' | b'r', b'"', ..] => true, // br", Br", etc.
        _ => false,
    },
        None,
    ),

    LexMatcher::regex_lexer(
        "back_quote",
        r#"`(?:[^`\\]|\\.)*`"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"`((?:[^`\\]|\\.)*)`"#.to_string(), RegexModeGroup::Index(1))),
        Some((r#"\\`"#.to_string(), r#"`"#.to_string())),
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "dollar_quote",
        r#"\$(\w*)\$(.*?)\$\1\$"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        Some((r#"\$(\w*)\$(.*?)\$\1\$"#.to_string(), RegexModeGroup::Index(2))),
        None,
        CaseFold::None,
        None,
        |input| input.starts_with("$"),
        None,
    ),

    LexMatcher::regex_lexer(
        "numeric_literal",
        r#"([0-9]+(\.[0-9]*)?)"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |input| input.starts_with(['x','X','.','0','1','2','3','4','5','6','7','8','9']),
        None,
    ),

    LexMatcher::regex_lexer(
        "obevo_annotation",
        r#"////\s*(CHANGE|BODY|METADATA)[^\n]*"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comment_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::string_lexer(
        "glob_operator",
        "~~~",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comparison_operator_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::regex_lexer(
        "like_operator",
        r#"!?~~?\*?"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::comparison_operator_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::regex_lexer(
        "newline",
        r#"\r\n|\n"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::newline_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),

    LexMatcher::string_lexer(
        "casting_operator",
        "::",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "equals",
        "=",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "greater_than",
        ">",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "less_than",
        "<",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "not",
        "!",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "dot",
        ".",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "comma",
        ",",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "plus",
        "+",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "minus",
        "-",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "divide",
        "/",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "percent",
        "%",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "question",
        "?",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "ampersand",
        "&",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "vertical_bar",
        "|",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "caret",
        "^",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "star",
        "*",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_bracket",
        "(",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_bracket",
        ")",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_square_bracket",
        "[",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_square_bracket",
        "]",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "start_curly_bracket",
        "{",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "end_curly_bracket",
        "}",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "colon",
        ":",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::string_lexer(
        "semicolon",
        ";",
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::code_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
    ),

    LexMatcher::regex_lexer(
        "word",
        r#"[0-9a-zA-Z_]+"#,
        |raw, pos_marker, class_types, instance_types, trim_start, trim_chars,
         quoted_value, escape_replacement, casefold| {
            Token::word_token_compat(raw, pos_marker, class_types,
                instance_types, trim_start, trim_chars,
                quoted_value, escape_replacement, casefold)
        },
        None,
        None,
        None,
        None,
        None,
        None,
        CaseFold::None,
        None,
        |_| true,
        None,
    ),
]});


// Wrapper function that passes the dialect name to the shared implementation
fn extract_nested_block_comment(input: &str) -> Option<&str> {
    crate::extract_nested_block_comment(input, "teradata")
}
