/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkSimpleContourExtractorImageFilter.h"
#include "itkSimpleContourExtractorImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
SimpleContourExtractorImageFilter::SimpleContourExtractorImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
SimpleContourExtractorImageFilter::~SimpleContourExtractorImageFilter() = default;



//
// ToString
//
std::string SimpleContourExtractorImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::SimpleContourExtractorImageFilter\n";
  out << "  InputForegroundValue: ";
  this->ToStringHelper(out, this->m_InputForegroundValue);
  out << std::endl;
  out << "  InputBackgroundValue: ";
  this->ToStringHelper(out, this->m_InputBackgroundValue);
  out << std::endl;
  out << "  Radius: ";
  this->ToStringHelper(out, this->m_Radius);
  out << std::endl;
  out << "  OutputForegroundValue: ";
  this->ToStringHelper(out, this->m_OutputForegroundValue);
  out << std::endl;
  out << "  OutputBackgroundValue: ";
  this->ToStringHelper(out, this->m_OutputBackgroundValue);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image SimpleContourExtractorImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image SimpleContourExtractorImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< uint8_t, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::SimpleContourExtractorImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  filter->SetInputForegroundValue ( static_cast< typename InputImageType::PixelType> ( this->m_InputForegroundValue ) );
  filter->SetInputBackgroundValue ( static_cast< typename InputImageType::PixelType> ( this->m_InputBackgroundValue ) );
  typename FilterType::RadiusType itkVecRadius = sitkSTLVectorToITK<typename FilterType::RadiusType>( this->GetRadius() );
  filter->SetRadius( itkVecRadius );
  filter->SetOutputForegroundValue ( static_cast< typename OutputImageType::PixelType> ( this->m_OutputForegroundValue ) );
  filter->SetOutputBackgroundValue ( static_cast< typename OutputImageType::PixelType> ( this->m_OutputBackgroundValue ) );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image SimpleContourExtractor ( const Image& image1, double inputForegroundValue, double inputBackgroundValue, std::vector<unsigned int> radius, double outputForegroundValue, double outputBackgroundValue )
{
  SimpleContourExtractorImageFilter filter;
  filter.SetInputForegroundValue( inputForegroundValue );  filter.SetInputBackgroundValue( inputBackgroundValue );  filter.SetRadius( radius );  filter.SetOutputForegroundValue( outputForegroundValue );  filter.SetOutputBackgroundValue( outputBackgroundValue );
  return filter.Execute ( image1 );
}


}
