/* Generated by wayland-scanner 1.24.0 */

#ifndef PANTHEON_SHELL_V1_CLIENT_PROTOCOL_H
#define PANTHEON_SHELL_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_pantheon_shell_v1 The pantheon_shell_v1 protocol
 * @section page_ifaces_pantheon_shell_v1 Interfaces
 * - @subpage page_iface_io_elementary_pantheon_shell_v1 - create panel, widget and get more control
 * - @subpage page_iface_io_elementary_pantheon_panel_v1 - 
 * - @subpage page_iface_io_elementary_pantheon_widget_v1 - 
 * - @subpage page_iface_io_elementary_pantheon_extended_behavior_v1 - 
 * @section page_copyright_pantheon_shell_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2023 Corentin Noël <tintou@noel.tf>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct io_elementary_pantheon_extended_behavior_v1;
struct io_elementary_pantheon_panel_v1;
struct io_elementary_pantheon_shell_v1;
struct io_elementary_pantheon_widget_v1;
struct wl_surface;

#ifndef IO_ELEMENTARY_PANTHEON_SHELL_V1_INTERFACE
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_INTERFACE
/**
 * @page page_iface_io_elementary_pantheon_shell_v1 io_elementary_pantheon_shell_v1
 * @section page_iface_io_elementary_pantheon_shell_v1_desc Description
 *
 * This interface is used by the Pantheon Wayland shell to communicate with
 * the compositor.
 * @section page_iface_io_elementary_pantheon_shell_v1_api API
 * See @ref iface_io_elementary_pantheon_shell_v1.
 */
/**
 * @defgroup iface_io_elementary_pantheon_shell_v1 The io_elementary_pantheon_shell_v1 interface
 *
 * This interface is used by the Pantheon Wayland shell to communicate with
 * the compositor.
 */
extern const struct wl_interface io_elementary_pantheon_shell_v1_interface;
#endif
#ifndef IO_ELEMENTARY_PANTHEON_PANEL_V1_INTERFACE
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_INTERFACE
/**
 * @page page_iface_io_elementary_pantheon_panel_v1 io_elementary_pantheon_panel_v1
 * @section page_iface_io_elementary_pantheon_panel_v1_api API
 * See @ref iface_io_elementary_pantheon_panel_v1.
 */
/**
 * @defgroup iface_io_elementary_pantheon_panel_v1 The io_elementary_pantheon_panel_v1 interface
 */
extern const struct wl_interface io_elementary_pantheon_panel_v1_interface;
#endif
#ifndef IO_ELEMENTARY_PANTHEON_WIDGET_V1_INTERFACE
#define IO_ELEMENTARY_PANTHEON_WIDGET_V1_INTERFACE
/**
 * @page page_iface_io_elementary_pantheon_widget_v1 io_elementary_pantheon_widget_v1
 * @section page_iface_io_elementary_pantheon_widget_v1_api API
 * See @ref iface_io_elementary_pantheon_widget_v1.
 */
/**
 * @defgroup iface_io_elementary_pantheon_widget_v1 The io_elementary_pantheon_widget_v1 interface
 */
extern const struct wl_interface io_elementary_pantheon_widget_v1_interface;
#endif
#ifndef IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_INTERFACE
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_INTERFACE
/**
 * @page page_iface_io_elementary_pantheon_extended_behavior_v1 io_elementary_pantheon_extended_behavior_v1
 * @section page_iface_io_elementary_pantheon_extended_behavior_v1_api API
 * See @ref iface_io_elementary_pantheon_extended_behavior_v1.
 */
/**
 * @defgroup iface_io_elementary_pantheon_extended_behavior_v1 The io_elementary_pantheon_extended_behavior_v1 interface
 */
extern const struct wl_interface io_elementary_pantheon_extended_behavior_v1_interface;
#endif

#define IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_PANEL 0
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_WIDGET 1
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_EXTENDED_BEHAVIOR 2


/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 */
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_PANEL_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 */
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_WIDGET_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 */
#define IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_EXTENDED_BEHAVIOR_SINCE_VERSION 1

/** @ingroup iface_io_elementary_pantheon_shell_v1 */
static inline void
io_elementary_pantheon_shell_v1_set_user_data(struct io_elementary_pantheon_shell_v1 *io_elementary_pantheon_shell_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) io_elementary_pantheon_shell_v1, user_data);
}

/** @ingroup iface_io_elementary_pantheon_shell_v1 */
static inline void *
io_elementary_pantheon_shell_v1_get_user_data(struct io_elementary_pantheon_shell_v1 *io_elementary_pantheon_shell_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) io_elementary_pantheon_shell_v1);
}

static inline uint32_t
io_elementary_pantheon_shell_v1_get_version(struct io_elementary_pantheon_shell_v1 *io_elementary_pantheon_shell_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_shell_v1);
}

/** @ingroup iface_io_elementary_pantheon_shell_v1 */
static inline void
io_elementary_pantheon_shell_v1_destroy(struct io_elementary_pantheon_shell_v1 *io_elementary_pantheon_shell_v1)
{
	wl_proxy_destroy((struct wl_proxy *) io_elementary_pantheon_shell_v1);
}

/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 *
 * Create a panel surface from an existing surface.
 */
static inline struct io_elementary_pantheon_panel_v1 *
io_elementary_pantheon_shell_v1_get_panel(struct io_elementary_pantheon_shell_v1 *io_elementary_pantheon_shell_v1, struct wl_surface *surface)
{
	struct wl_proxy *output;

	output = wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_shell_v1,
			 IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_PANEL, &io_elementary_pantheon_panel_v1_interface, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_shell_v1), 0, NULL, surface);

	return (struct io_elementary_pantheon_panel_v1 *) output;
}

/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 *
 * Create a desktop widget surface from an existing surface.
 */
static inline struct io_elementary_pantheon_widget_v1 *
io_elementary_pantheon_shell_v1_get_widget(struct io_elementary_pantheon_shell_v1 *io_elementary_pantheon_shell_v1, struct wl_surface *surface)
{
	struct wl_proxy *output;

	output = wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_shell_v1,
			 IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_WIDGET, &io_elementary_pantheon_widget_v1_interface, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_shell_v1), 0, NULL, surface);

	return (struct io_elementary_pantheon_widget_v1 *) output;
}

/**
 * @ingroup iface_io_elementary_pantheon_shell_v1
 *
 * Create a desktop-specific surface from an existing surface.
 */
static inline struct io_elementary_pantheon_extended_behavior_v1 *
io_elementary_pantheon_shell_v1_get_extended_behavior(struct io_elementary_pantheon_shell_v1 *io_elementary_pantheon_shell_v1, struct wl_surface *surface)
{
	struct wl_proxy *output;

	output = wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_shell_v1,
			 IO_ELEMENTARY_PANTHEON_SHELL_V1_GET_EXTENDED_BEHAVIOR, &io_elementary_pantheon_extended_behavior_v1_interface, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_shell_v1), 0, NULL, surface);

	return (struct io_elementary_pantheon_extended_behavior_v1 *) output;
}

#ifndef IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_ENUM
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_ENUM
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 * anchor
 *
 * The anchor is a placement hint to the compositor.
 */
enum io_elementary_pantheon_panel_v1_anchor {
	/**
	 * the top edge of the screen
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_TOP = 0,
	/**
	 * the bottom edge of the screen
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_BOTTOM = 1,
	/**
	 * the left edge of the screen
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_LEFT = 2,
	/**
	 * the right edge of the screen
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_RIGHT = 3,
};
#endif /* IO_ELEMENTARY_PANTHEON_PANEL_V1_ANCHOR_ENUM */

#ifndef IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ENUM
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ENUM
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 * hide mode
 *
 * How the shell should handle the window.
 */
enum io_elementary_pantheon_panel_v1_hide_mode {
	/**
	 * make the surface exclusive
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_NEVER = 0,
	/**
	 * hide when the focused window is maximized
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_MAXIMIZED_FOCUS_WINDOW = 1,
	/**
	 * hide when the focused window overlaps the surface
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_FOCUS_WINDOW = 2,
	/**
	 * hide when any window overlaps the surface
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_OVERLAPPING_WINDOW = 3,
	/**
	 * always hide and only show if requested by the user
	 */
	IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ALWAYS = 4,
};
#endif /* IO_ELEMENTARY_PANTHEON_PANEL_V1_HIDE_MODE_ENUM */

#define IO_ELEMENTARY_PANTHEON_PANEL_V1_DESTROY 0
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_ANCHOR 1
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_FOCUS 2
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_SIZE 3
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_HIDE_MODE 4
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_REQUEST_VISIBLE_IN_MULTITASKING_VIEW 5
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_ADD_BLUR 6
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_REMOVE_BLUR 7


/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_ANCHOR_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_FOCUS_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_HIDE_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_REQUEST_VISIBLE_IN_MULTITASKING_VIEW_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_ADD_BLUR_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
#define IO_ELEMENTARY_PANTHEON_PANEL_V1_REMOVE_BLUR_SINCE_VERSION 1

/** @ingroup iface_io_elementary_pantheon_panel_v1 */
static inline void
io_elementary_pantheon_panel_v1_set_user_data(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) io_elementary_pantheon_panel_v1, user_data);
}

/** @ingroup iface_io_elementary_pantheon_panel_v1 */
static inline void *
io_elementary_pantheon_panel_v1_get_user_data(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) io_elementary_pantheon_panel_v1);
}

static inline uint32_t
io_elementary_pantheon_panel_v1_get_version(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_panel_v1);
}

/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 */
static inline void
io_elementary_pantheon_panel_v1_destroy(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_panel_v1,
			 IO_ELEMENTARY_PANTHEON_PANEL_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_panel_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 *
 * Tell the shell which side of the screen the panel is
 * located. This is so that new windows do not overlap the panel
 * and maximized windows maximize properly.
 */
static inline void
io_elementary_pantheon_panel_v1_set_anchor(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1, uint32_t anchor)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_panel_v1,
			 IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_ANCHOR, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_panel_v1), 0, anchor);
}

/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 *
 * Request keyboard focus, taking it away from any other window.
 * Keyboard focus must always be manually be requested and is
 * - in contrast to normal windows - never automatically granted
 * by the compositor.
 */
static inline void
io_elementary_pantheon_panel_v1_focus(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_panel_v1,
			 IO_ELEMENTARY_PANTHEON_PANEL_V1_FOCUS, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_panel_v1), 0);
}

/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 *
 * The given size is only used for exclusive zones and
 * collision tracking for auto hide. By default and if set
 * to -1 the size of the surface is used.
 */
static inline void
io_elementary_pantheon_panel_v1_set_size(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_panel_v1,
			 IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_panel_v1), 0, width, height);
}

/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 *
 * Tell the shell when to hide the panel.
 */
static inline void
io_elementary_pantheon_panel_v1_set_hide_mode(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1, uint32_t hide_mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_panel_v1,
			 IO_ELEMENTARY_PANTHEON_PANEL_V1_SET_HIDE_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_panel_v1), 0, hide_mode);
}

/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 *
 * Tell the shell that the panel would like to be visible in the multitasking view.
 */
static inline void
io_elementary_pantheon_panel_v1_request_visible_in_multitasking_view(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_panel_v1,
			 IO_ELEMENTARY_PANTHEON_PANEL_V1_REQUEST_VISIBLE_IN_MULTITASKING_VIEW, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_panel_v1), 0);
}

/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 *
 * Tell the window manager to add background blur.
 */
static inline void
io_elementary_pantheon_panel_v1_add_blur(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1, uint32_t left, uint32_t right, uint32_t top, uint32_t bottom, uint32_t clip_radius)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_panel_v1,
			 IO_ELEMENTARY_PANTHEON_PANEL_V1_ADD_BLUR, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_panel_v1), 0, left, right, top, bottom, clip_radius);
}

/**
 * @ingroup iface_io_elementary_pantheon_panel_v1
 *
 * Tell the window manager to remove blur that was set in set_blur_region.
 */
static inline void
io_elementary_pantheon_panel_v1_remove_blur(struct io_elementary_pantheon_panel_v1 *io_elementary_pantheon_panel_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_panel_v1,
			 IO_ELEMENTARY_PANTHEON_PANEL_V1_REMOVE_BLUR, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_panel_v1), 0);
}

#define IO_ELEMENTARY_PANTHEON_WIDGET_V1_DESTROY 0


/**
 * @ingroup iface_io_elementary_pantheon_widget_v1
 */
#define IO_ELEMENTARY_PANTHEON_WIDGET_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_io_elementary_pantheon_widget_v1 */
static inline void
io_elementary_pantheon_widget_v1_set_user_data(struct io_elementary_pantheon_widget_v1 *io_elementary_pantheon_widget_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) io_elementary_pantheon_widget_v1, user_data);
}

/** @ingroup iface_io_elementary_pantheon_widget_v1 */
static inline void *
io_elementary_pantheon_widget_v1_get_user_data(struct io_elementary_pantheon_widget_v1 *io_elementary_pantheon_widget_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) io_elementary_pantheon_widget_v1);
}

static inline uint32_t
io_elementary_pantheon_widget_v1_get_version(struct io_elementary_pantheon_widget_v1 *io_elementary_pantheon_widget_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_widget_v1);
}

/**
 * @ingroup iface_io_elementary_pantheon_widget_v1
 */
static inline void
io_elementary_pantheon_widget_v1_destroy(struct io_elementary_pantheon_widget_v1 *io_elementary_pantheon_widget_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_widget_v1,
			 IO_ELEMENTARY_PANTHEON_WIDGET_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_widget_v1), WL_MARSHAL_FLAG_DESTROY);
}

#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_DESTROY 0
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_SET_KEEP_ABOVE 1
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_MAKE_CENTERED 2
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_FOCUS 3


/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 */
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 */
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_SET_KEEP_ABOVE_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 */
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_MAKE_CENTERED_SINCE_VERSION 1
/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 */
#define IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_FOCUS_SINCE_VERSION 1

/** @ingroup iface_io_elementary_pantheon_extended_behavior_v1 */
static inline void
io_elementary_pantheon_extended_behavior_v1_set_user_data(struct io_elementary_pantheon_extended_behavior_v1 *io_elementary_pantheon_extended_behavior_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1, user_data);
}

/** @ingroup iface_io_elementary_pantheon_extended_behavior_v1 */
static inline void *
io_elementary_pantheon_extended_behavior_v1_get_user_data(struct io_elementary_pantheon_extended_behavior_v1 *io_elementary_pantheon_extended_behavior_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1);
}

static inline uint32_t
io_elementary_pantheon_extended_behavior_v1_get_version(struct io_elementary_pantheon_extended_behavior_v1 *io_elementary_pantheon_extended_behavior_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1);
}

/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 */
static inline void
io_elementary_pantheon_extended_behavior_v1_destroy(struct io_elementary_pantheon_extended_behavior_v1 *io_elementary_pantheon_extended_behavior_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1,
			 IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 *
 * Tell the shell to keep the surface above on all workspaces
 */
static inline void
io_elementary_pantheon_extended_behavior_v1_set_keep_above(struct io_elementary_pantheon_extended_behavior_v1 *io_elementary_pantheon_extended_behavior_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1,
			 IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_SET_KEEP_ABOVE, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1), 0);
}

/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 *
 * Request to keep the surface centered. This will cause keyboard focus
 * to not be granted automatically but having to be requested via focus.
 */
static inline void
io_elementary_pantheon_extended_behavior_v1_make_centered(struct io_elementary_pantheon_extended_behavior_v1 *io_elementary_pantheon_extended_behavior_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1,
			 IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_MAKE_CENTERED, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1), 0);
}

/**
 * @ingroup iface_io_elementary_pantheon_extended_behavior_v1
 *
 * Request keyboard focus, taking it away from any other window.
 * Keyboard focus must always be manually be requested and is
 * - in contrast to normal windows - never automatically granted
 * by the compositor.
 */
static inline void
io_elementary_pantheon_extended_behavior_v1_focus(struct io_elementary_pantheon_extended_behavior_v1 *io_elementary_pantheon_extended_behavior_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1,
			 IO_ELEMENTARY_PANTHEON_EXTENDED_BEHAVIOR_V1_FOCUS, NULL, wl_proxy_get_version((struct wl_proxy *) io_elementary_pantheon_extended_behavior_v1), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
