/* AbstractBubble.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AbstractBubble.vala, do not modify */

/*
* Copyright 2020-2025 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "pantheon-desktop-shell-client-protocol.h"
#include <gio/gio.h>
#include <wayland-client.h>
#include <adwaita.h>
#include <gdk/gdk.h>
#include <gdk/x11/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/wayland/gdkwayland.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	NOTIFICATIONS_CLOSE_REASON_EXPIRED = 1,
	NOTIFICATIONS_CLOSE_REASON_DISMISSED = 2,
	NOTIFICATIONS_CLOSE_REASON_CLOSE_NOTIFICATION_CALL = 3,
	NOTIFICATIONS_CLOSE_REASON_UNDEFINED = 4
} NotificationsCloseReason;

#define NOTIFICATIONS_TYPE_CLOSE_REASON (notifications_close_reason_get_type ())

#define NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE (notifications_abstract_bubble_get_type ())
#define NOTIFICATIONS_ABSTRACT_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubble))
#define NOTIFICATIONS_ABSTRACT_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubbleClass))
#define NOTIFICATIONS_IS_ABSTRACT_BUBBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE))
#define NOTIFICATIONS_IS_ABSTRACT_BUBBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE))
#define NOTIFICATIONS_ABSTRACT_BUBBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubbleClass))

typedef struct _NotificationsAbstractBubble NotificationsAbstractBubble;
typedef struct _NotificationsAbstractBubbleClass NotificationsAbstractBubbleClass;
typedef struct _NotificationsAbstractBubblePrivate NotificationsAbstractBubblePrivate;
enum  {
	NOTIFICATIONS_ABSTRACT_BUBBLE_0_PROPERTY,
	NOTIFICATIONS_ABSTRACT_BUBBLE_TIMEOUT_PROPERTY,
	NOTIFICATIONS_ABSTRACT_BUBBLE_NUM_PROPERTIES
};
static GParamSpec* notifications_abstract_bubble_properties[NOTIFICATIONS_ABSTRACT_BUBBLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _wl_proxy_destroy0(var) ((var == NULL) ? NULL : (var = (wl_proxy_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef void (*wl_RegistryListenerGlobal) (void* data, struct wl_registry* wl_registry, guint32 name, const gchar* interface, guint32 version);
#define _wl_registry_destroy0(var) ((var == NULL) ? NULL : (var = (wl_registry_destroy (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
enum  {
	NOTIFICATIONS_ABSTRACT_BUBBLE_CLOSED_SIGNAL,
	NOTIFICATIONS_ABSTRACT_BUBBLE_NUM_SIGNALS
};
static guint notifications_abstract_bubble_signals[NOTIFICATIONS_ABSTRACT_BUBBLE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NotificationsAbstractBubble {
	GtkWindow parent_instance;
	NotificationsAbstractBubblePrivate * priv;
	GtkStack* content_area;
};

struct _NotificationsAbstractBubbleClass {
	GtkWindowClass parent_class;
};

struct _NotificationsAbstractBubblePrivate {
	guint32 _timeout;
	GtkRevealer* close_revealer;
	GtkBox* draw_area;
	GtkOverlay* overlay;
	guint timeout_id;
	gdouble current_swipe_progress;
	struct io_elementary_pantheon_shell_v1* desktop_shell;
	struct io_elementary_pantheon_panel_v1* desktop_panel;
};

static gint NotificationsAbstractBubble_private_offset;
static gpointer notifications_abstract_bubble_parent_class = NULL;
static GSettings* notifications_abstract_bubble_transparency_settings;
static GSettings* notifications_abstract_bubble_transparency_settings = NULL;
static struct wl_registry_listener notifications_abstract_bubble_registry_listener;
static struct wl_registry_listener notifications_abstract_bubble_registry_listener = {0};

VALA_EXTERN GType notifications_close_reason_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType notifications_abstract_bubble_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NotificationsAbstractBubble, g_object_unref)
static void notifications_abstract_bubble_closed (NotificationsAbstractBubble* self,
                                           NotificationsCloseReason reason);
static void notifications_abstract_bubble_update_transparency (NotificationsAbstractBubble* self);
static void notifications_abstract_bubble_on_page_changed (NotificationsAbstractBubble* self,
                                                    AdwCarousel* carousel,
                                                    guint index);
static void notifications_abstract_bubble_update_swipe_progress (NotificationsAbstractBubble* self,
                                                          GObject* obj,
                                                          GParamSpec* pspec);
static void notifications_abstract_bubble_get_blur_margins (NotificationsAbstractBubble* self,
                                                     gint* left,
                                                     gint* right);
static void notifications_abstract_bubble_x11_update_mutter_hints (NotificationsAbstractBubble* self);
VALA_EXTERN void notifications_abstract_bubble_present (NotificationsAbstractBubble* self);
VALA_EXTERN guint32 notifications_abstract_bubble_get_timeout (NotificationsAbstractBubble* self);
static gboolean notifications_abstract_bubble_timeout_expired (NotificationsAbstractBubble* self);
static gboolean _notifications_abstract_bubble_timeout_expired_gsource_func (gpointer self);
static void notifications_abstract_bubble_pointer_enter (NotificationsAbstractBubble* self);
static void notifications_abstract_bubble_pointer_leave (NotificationsAbstractBubble* self);
static void notifications_abstract_bubble_x11_make_notification (NotificationsAbstractBubble* self);
static void notifications_abstract_bubble_init_wl (NotificationsAbstractBubble* self);
VALA_EXTERN void notifications_abstract_bubble_registry_handle_global (NotificationsAbstractBubble* self,
                                                           struct wl_registry* wl_registry,
                                                           guint32 name,
                                                           const gchar* interface,
                                                           guint32 version);
static void _notifications_abstract_bubble_registry_handle_global_wl_registrylistenerglobal (void* data,
                                                                                      struct wl_registry* wl_registry,
                                                                                      guint32 name,
                                                                                      const gchar* interface,
                                                                                      guint32 version);
VALA_EXTERN NotificationsAbstractBubble* notifications_abstract_bubble_new (void);
VALA_EXTERN NotificationsAbstractBubble* notifications_abstract_bubble_construct (GType object_type);
VALA_EXTERN void notifications_abstract_bubble_set_timeout (NotificationsAbstractBubble* self,
                                                guint32 value);
static GObject * notifications_abstract_bubble_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _notifications_abstract_bubble_on_page_changed_adw_carousel_page_changed (AdwCarousel* _sender,
                                                                               guint index,
                                                                               gpointer self);
static void _notifications_abstract_bubble___lambda4_ (NotificationsAbstractBubble* self);
static void __notifications_abstract_bubble___lambda4__gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self);
static void _notifications_abstract_bubble_pointer_enter_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                                     gdouble x,
                                                                                     gdouble y,
                                                                                     gpointer self);
static void _notifications_abstract_bubble_pointer_leave_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                                     gpointer self);
static void _notifications_abstract_bubble___lambda5_ (NotificationsAbstractBubble* self);
static void _notifications_abstract_bubble_init_wl_gsource_once_func (gpointer self);
static void __notifications_abstract_bubble___lambda5__gtk_widget_realize (GtkWidget* _sender,
                                                                    gpointer self);
static void _notifications_abstract_bubble_update_swipe_progress_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self);
static void _notifications_abstract_bubble_update_transparency_g_settings_changed (GSettings* _sender,
                                                                            const gchar* key,
                                                                            gpointer self);
static void notifications_abstract_bubble_finalize (GObject * obj);
static GType notifications_abstract_bubble_get_type_once (void);
static void _vala_notifications_abstract_bubble_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_notifications_abstract_bubble_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static GType
notifications_close_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{NOTIFICATIONS_CLOSE_REASON_EXPIRED, "NOTIFICATIONS_CLOSE_REASON_EXPIRED", "expired"}, {NOTIFICATIONS_CLOSE_REASON_DISMISSED, "NOTIFICATIONS_CLOSE_REASON_DISMISSED", "dismissed"}, {NOTIFICATIONS_CLOSE_REASON_CLOSE_NOTIFICATION_CALL, "NOTIFICATIONS_CLOSE_REASON_CLOSE_NOTIFICATION_CALL", "close-notification-call"}, {NOTIFICATIONS_CLOSE_REASON_UNDEFINED, "NOTIFICATIONS_CLOSE_REASON_UNDEFINED", "undefined"}, {0, NULL, NULL}};
	GType notifications_close_reason_type_id;
	notifications_close_reason_type_id = g_enum_register_static ("NotificationsCloseReason", values);
	return notifications_close_reason_type_id;
}

GType
notifications_close_reason_get_type (void)
{
	static volatile gsize notifications_close_reason_type_id__once = 0;
	if (g_once_init_enter (&notifications_close_reason_type_id__once)) {
		GType notifications_close_reason_type_id;
		notifications_close_reason_type_id = notifications_close_reason_get_type_once ();
		g_once_init_leave (&notifications_close_reason_type_id__once, notifications_close_reason_type_id);
	}
	return notifications_close_reason_type_id__once;
}

static inline gpointer
notifications_abstract_bubble_get_instance_private (NotificationsAbstractBubble* self)
{
	return G_STRUCT_MEMBER_P (self, NotificationsAbstractBubble_private_offset);
}

static void
notifications_abstract_bubble_update_transparency (NotificationsAbstractBubble* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = notifications_abstract_bubble_transparency_settings;
	_vala_return_if_fail (_tmp0_ != NULL, "transparency_settings != null");
	_tmp1_ = notifications_abstract_bubble_transparency_settings;
	if (g_settings_get_boolean (_tmp1_, "use-transparency")) {
		gtk_widget_remove_css_class ((GtkWidget*) self, "reduce-transparency");
	} else {
		gtk_widget_add_css_class ((GtkWidget*) self, "reduce-transparency");
	}
}

static void
notifications_abstract_bubble_on_page_changed (NotificationsAbstractBubble* self,
                                               AdwCarousel* carousel,
                                               guint index)
{
	GtkWidget* _tmp0_;
	GtkOverlay* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (carousel != NULL);
	_tmp0_ = adw_carousel_get_nth_page (carousel, index);
	_tmp1_ = self->priv->overlay;
	if (_tmp0_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget)) {
		g_signal_emit (self, notifications_abstract_bubble_signals[NOTIFICATIONS_ABSTRACT_BUBBLE_CLOSED_SIGNAL], 0, NOTIFICATIONS_CLOSE_REASON_DISMISSED);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
notifications_abstract_bubble_update_swipe_progress (NotificationsAbstractBubble* self,
                                                     GObject* obj,
                                                     GParamSpec* pspec)
{
	AdwCarousel* carousel = NULL;
	AdwCarousel* _tmp0_;
	AdwCarousel* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	struct io_elementary_pantheon_panel_v1* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, adw_carousel_get_type (), AdwCarousel));
	carousel = _tmp0_;
	_tmp1_ = carousel;
	_tmp2_ = adw_carousel_get_position (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->current_swipe_progress = _tmp3_;
	_tmp4_ = self->priv->desktop_panel;
	if (_tmp4_ != NULL) {
		gint left = 0;
		gint right = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		struct io_elementary_pantheon_panel_v1* _tmp7_;
		notifications_abstract_bubble_get_blur_margins (self, &_tmp5_, &_tmp6_);
		left = _tmp5_;
		right = _tmp6_;
		_tmp7_ = self->priv->desktop_panel;
		io_elementary_pantheon_panel_v1_add_blur (_tmp7_, (guint) left, (guint) right, (guint) 16, (guint) 16, (guint) 9);
	} else {
		GdkDisplay* _tmp8_;
		_tmp8_ = gdk_display_get_default ();
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gdk_x11_display_get_type ())) {
			notifications_abstract_bubble_x11_update_mutter_hints (self);
		}
	}
	_g_object_unref0 (carousel);
}

static gboolean
_notifications_abstract_bubble_timeout_expired_gsource_func (gpointer self)
{
	gboolean result;
	result = notifications_abstract_bubble_timeout_expired ((NotificationsAbstractBubble*) self);
	return result;
}

void
notifications_abstract_bubble_present (NotificationsAbstractBubble* self)
{
	GdkDisplay* _tmp0_;
	guint32 _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp0_ = gdk_display_get_default ();
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gdk_x11_display_get_type ())) {
		GTK_WIDGET_CLASS (notifications_abstract_bubble_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	} else {
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	}
	_tmp1_ = self->priv->_timeout;
	if (_tmp1_ != ((guint32) 0)) {
		guint32 _tmp2_;
		_tmp2_ = self->priv->_timeout;
		self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp2_, _notifications_abstract_bubble_timeout_expired_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
notifications_abstract_bubble_pointer_enter (NotificationsAbstractBubble* self)
{
	GtkRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->close_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
}

static void
notifications_abstract_bubble_pointer_leave (NotificationsAbstractBubble* self)
{
	GtkRevealer* _tmp0_;
	guint32 _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->close_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = self->priv->_timeout;
	if (_tmp1_ != ((guint32) 0)) {
		guint32 _tmp2_;
		_tmp2_ = self->priv->_timeout;
		self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp2_, _notifications_abstract_bubble_timeout_expired_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gboolean
notifications_abstract_bubble_timeout_expired (NotificationsAbstractBubble* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit (self, notifications_abstract_bubble_signals[NOTIFICATIONS_ABSTRACT_BUBBLE_CLOSED_SIGNAL], 0, NOTIFICATIONS_CLOSE_REASON_EXPIRED);
	result = G_SOURCE_REMOVE;
	return result;
}

static void
notifications_abstract_bubble_get_blur_margins (NotificationsAbstractBubble* self,
                                                gint* left,
                                                gint* right)
{
	gint _vala_left = 0;
	gint _vala_right = 0;
	gint width = 0;
	gdouble distance = 0.0;
	g_return_if_fail (self != NULL);
	width = gtk_widget_get_width ((GtkWidget*) self);
	distance = (1 - self->priv->current_swipe_progress) * width;
	_vala_left = (gint) CLAMP (16 + distance, (gdouble) 0, (gdouble) width);
	_vala_right = (gint) CLAMP (16 - distance, (gdouble) 0, (gdouble) width);
	if (left) {
		*left = _vala_left;
	}
	if (right) {
		*right = _vala_right;
	}
}

static void
notifications_abstract_bubble_x11_update_mutter_hints (NotificationsAbstractBubble* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_x11_display_get_type ())) {
		Display* xdisplay = NULL;
		GdkDisplay* _tmp3_;
		Display* _tmp4_;
		Window window = 0;
		GdkSurface* _tmp5_;
		Atom prop = {0};
		Display* _tmp6_;
		gint left = 0;
		gint right = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gchar* value = NULL;
		gchar* _tmp9_;
		Display* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp3_ = display;
		_tmp4_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_x11_display_get_type (), GdkX11Display));
		xdisplay = _tmp4_;
		_tmp5_ = gtk_native_get_surface ((GtkNative*) self);
		window = gdk_x11_surface_get_xid (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_x11_surface_get_type (), GdkX11Surface));
		_tmp6_ = xdisplay;
		prop = XInternAtom (_tmp6_, "_MUTTER_HINTS", FALSE);
		notifications_abstract_bubble_get_blur_margins (self, &_tmp7_, &_tmp8_);
		left = _tmp7_;
		right = _tmp8_;
		_tmp9_ = g_strdup_printf ("blur=%d,%d,16,16,9", left, right);
		value = _tmp9_;
		_tmp10_ = xdisplay;
		_tmp11_ = value;
		_tmp12_ = value;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		XChangeProperty (_tmp10_, window, prop, XA_STRING, 8, 0, (guchar*) _tmp11_, _tmp14_);
		_g_free0 (value);
	}
	_g_object_unref0 (display);
}

static void
notifications_abstract_bubble_x11_make_notification (NotificationsAbstractBubble* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	display = _tmp0_;
	_tmp1_ = display;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gdk_x11_display_get_type ())) {
		GdkX11Surface* x11_surface = NULL;
		GdkSurface* _tmp2_;
		Window window = 0;
		GdkX11Surface* _tmp3_;
		GdkX11Surface* _tmp4_;
		GdkX11Surface* _tmp5_;
		Display* xdisplay = NULL;
		GdkDisplay* _tmp6_;
		Display* _tmp7_;
		Atom atom = {0};
		Display* _tmp8_;
		Atom notification_atom = {0};
		Display* _tmp9_;
		Display* _tmp10_;
		_tmp2_ = gtk_native_get_surface ((GtkNative*) self);
		x11_surface = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gdk_x11_surface_get_type (), GdkX11Surface);
		_tmp3_ = x11_surface;
		window = gdk_x11_surface_get_xid (_tmp3_);
		_tmp4_ = x11_surface;
		gdk_x11_surface_set_skip_pager_hint (_tmp4_, TRUE);
		_tmp5_ = x11_surface;
		gdk_x11_surface_set_skip_taskbar_hint (_tmp5_, TRUE);
		_tmp6_ = display;
		_tmp7_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gdk_x11_display_get_type (), GdkX11Display));
		xdisplay = _tmp7_;
		_tmp8_ = xdisplay;
		atom = XInternAtom (_tmp8_, "_NET_WM_WINDOW_TYPE", FALSE);
		_tmp9_ = xdisplay;
		notification_atom = XInternAtom (_tmp9_, "_NET_WM_WINDOW_TYPE_NOTIFICATION", FALSE);
		_tmp10_ = xdisplay;
		XChangeProperty (_tmp10_, window, atom, (Atom) 4, 32, 0, (guchar*) (&notification_atom), 1);
	}
}

static void
_notifications_abstract_bubble_registry_handle_global_wl_registrylistenerglobal (void* data,
                                                                                 struct wl_registry* wl_registry,
                                                                                 guint32 name,
                                                                                 const gchar* interface,
                                                                                 guint32 version)
{
	notifications_abstract_bubble_registry_handle_global (data, wl_registry, name, interface, version);
}

static void
notifications_abstract_bubble_init_wl (NotificationsAbstractBubble* self)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	g_return_if_fail (self != NULL);
	notifications_abstract_bubble_registry_listener.global = _notifications_abstract_bubble_registry_handle_global_wl_registrylistenerglobal;
	_tmp0_ = gdk_display_get_default ();
	display = _tmp0_;
	_tmp1_ = display;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gdk_wayland_display_get_type ())) {
		struct wl_display* wl_display = NULL;
		GdkDisplay* _tmp2_;
		struct wl_display* _tmp3_;
		struct wl_registry* wl_registry = NULL;
		struct wl_display* _tmp4_;
		struct wl_registry* _tmp5_;
		struct wl_registry* _tmp6_;
		struct wl_registry_listener _tmp7_;
		struct wl_display* _tmp8_;
		_tmp2_ = display;
		_tmp3_ = gdk_wayland_display_get_wl_display (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gdk_wayland_display_get_type (), GdkWaylandDisplay));
		wl_display = _tmp3_;
		_tmp4_ = wl_display;
		_tmp5_ = wl_display_get_registry (_tmp4_);
		wl_registry = _tmp5_;
		_tmp6_ = wl_registry;
		_tmp7_ = notifications_abstract_bubble_registry_listener;
		wl_registry_add_listener (_tmp6_, &_tmp7_, self);
		_tmp8_ = wl_display;
		if (wl_display_roundtrip (_tmp8_) < 0) {
			_wl_registry_destroy0 (wl_registry);
			return;
		}
		_wl_registry_destroy0 (wl_registry);
	}
}

void
notifications_abstract_bubble_registry_handle_global (NotificationsAbstractBubble* self,
                                                      struct wl_registry* wl_registry,
                                                      guint32 name,
                                                      const gchar* interface,
                                                      guint32 version)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (wl_registry != NULL);
	g_return_if_fail (interface != NULL);
	if (g_strcmp0 (interface, "io_elementary_pantheon_shell_v1") == 0) {
		gpointer _tmp0_;
		GdkSurface* surface = NULL;
		GdkSurface* _tmp1_;
		GdkSurface* _tmp2_;
		_tmp0_ = wl_registry_bind (wl_registry, name, &io_elementary_pantheon_shell_v1_interface, MIN (version, (guint32) 1));
		_wl_proxy_destroy0 (self->priv->desktop_shell);
		self->priv->desktop_shell = (struct io_elementary_pantheon_shell_v1*) _tmp0_;
		_tmp1_ = gtk_native_get_surface ((GtkNative*) self);
		surface = _tmp1_;
		_tmp2_ = surface;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_wayland_surface_get_type ())) {
			struct wl_surface* wl_surface = NULL;
			GdkSurface* _tmp3_;
			struct wl_surface* _tmp4_;
			struct io_elementary_pantheon_shell_v1* _tmp5_;
			struct wl_surface* _tmp6_;
			struct io_elementary_pantheon_panel_v1* _tmp7_;
			struct io_elementary_pantheon_panel_v1* _tmp8_;
			_tmp3_ = surface;
			_tmp4_ = gdk_wayland_surface_get_wl_surface (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gdk_wayland_surface_get_type (), GdkWaylandSurface));
			wl_surface = _tmp4_;
			_tmp5_ = self->priv->desktop_shell;
			_tmp6_ = wl_surface;
			_tmp7_ = io_elementary_pantheon_shell_v1_get_panel (_tmp5_, _tmp6_);
			_wl_proxy_destroy0 (self->priv->desktop_panel);
			self->priv->desktop_panel = _tmp7_;
			_tmp8_ = self->priv->desktop_panel;
			io_elementary_pantheon_panel_v1_add_blur (_tmp8_, (guint) 16, (guint) 16, (guint) 16, (guint) 16, (guint) 9);
		}
	}
}

NotificationsAbstractBubble*
notifications_abstract_bubble_construct (GType object_type)
{
	NotificationsAbstractBubble * self = NULL;
	self = (NotificationsAbstractBubble*) g_object_new (object_type, NULL);
	return self;
}

NotificationsAbstractBubble*
notifications_abstract_bubble_new (void)
{
	return notifications_abstract_bubble_construct (NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE);
}

guint32
notifications_abstract_bubble_get_timeout (NotificationsAbstractBubble* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_timeout;
	return result;
}

void
notifications_abstract_bubble_set_timeout (NotificationsAbstractBubble* self,
                                           guint32 value)
{
	guint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = notifications_abstract_bubble_get_timeout (self);
	if (old_value != value) {
		self->priv->_timeout = value;
		g_object_notify_by_pspec ((GObject *) self, notifications_abstract_bubble_properties[NOTIFICATIONS_ABSTRACT_BUBBLE_TIMEOUT_PROPERTY]);
	}
}

static void
notifications_abstract_bubble_real_closed (NotificationsAbstractBubble* self,
                                           NotificationsCloseReason reason)
{
	g_return_if_fail (self != NULL);
	gtk_window_close ((GtkWindow*) self);
}

static void
_notifications_abstract_bubble_on_page_changed_adw_carousel_page_changed (AdwCarousel* _sender,
                                                                          guint index,
                                                                          gpointer self)
{
	notifications_abstract_bubble_on_page_changed ((NotificationsAbstractBubble*) self, _sender, index);
}

static void
_notifications_abstract_bubble___lambda4_ (NotificationsAbstractBubble* self)
{
	g_signal_emit (self, notifications_abstract_bubble_signals[NOTIFICATIONS_ABSTRACT_BUBBLE_CLOSED_SIGNAL], 0, NOTIFICATIONS_CLOSE_REASON_DISMISSED);
}

static void
__notifications_abstract_bubble___lambda4__gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self)
{
	_notifications_abstract_bubble___lambda4_ ((NotificationsAbstractBubble*) self);
}

static void
_notifications_abstract_bubble_pointer_enter_gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                                gdouble x,
                                                                                gdouble y,
                                                                                gpointer self)
{
	notifications_abstract_bubble_pointer_enter ((NotificationsAbstractBubble*) self);
}

static void
_notifications_abstract_bubble_pointer_leave_gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                                gpointer self)
{
	notifications_abstract_bubble_pointer_leave ((NotificationsAbstractBubble*) self);
}

static void
_notifications_abstract_bubble_init_wl_gsource_once_func (gpointer self)
{
	notifications_abstract_bubble_init_wl ((NotificationsAbstractBubble*) self);
}

static void
_notifications_abstract_bubble___lambda5_ (NotificationsAbstractBubble* self)
{
	GdkDisplay* _tmp0_;
	_tmp0_ = gdk_display_get_default ();
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gdk_wayland_display_get_type ())) {
		g_idle_add_once (_notifications_abstract_bubble_init_wl_gsource_once_func, self);
	} else {
		notifications_abstract_bubble_x11_make_notification (self);
		notifications_abstract_bubble_x11_update_mutter_hints (self);
	}
}

static void
__notifications_abstract_bubble___lambda5__gtk_widget_realize (GtkWidget* _sender,
                                                               gpointer self)
{
	_notifications_abstract_bubble___lambda5_ ((NotificationsAbstractBubble*) self);
}

static void
_notifications_abstract_bubble_update_swipe_progress_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self)
{
	notifications_abstract_bubble_update_swipe_progress ((NotificationsAbstractBubble*) self, _sender, pspec);
}

static void
_notifications_abstract_bubble_update_transparency_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self)
{
	notifications_abstract_bubble_update_transparency ((NotificationsAbstractBubble*) self);
}

static GObject *
notifications_abstract_bubble_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NotificationsAbstractBubble * self;
	GtkStack* _tmp0_ = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkStack* _tmp4_;
	GtkButton* close_button = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkWidget* _tmp8_;
	GtkRevealer* _tmp9_ = NULL;
	GtkBox* _tmp10_;
	GtkWidget* _tmp11_;
	GtkOverlay* _tmp12_ = NULL;
	GtkOverlay* _tmp13_;
	GtkRevealer* _tmp14_;
	AdwCarousel* carousel = NULL;
	AdwCarousel* _tmp15_ = NULL;
	AdwCarousel* _tmp16_;
	GtkGrid* _tmp17_;
	GtkGrid* _tmp18_;
	AdwCarousel* _tmp19_;
	GtkOverlay* _tmp20_;
	AdwCarousel* _tmp21_;
	GtkOverlay* _tmp22_;
	AdwCarousel* _tmp23_;
	GtkGrid* _tmp24_;
	GtkGrid* _tmp25_;
	AdwCarousel* _tmp26_;
	GtkButton* _tmp27_;
	GtkEventControllerMotion* motion_controller = NULL;
	GtkEventControllerMotion* _tmp28_;
	GtkEventControllerMotion* _tmp29_;
	GtkEventControllerMotion* _tmp30_;
	AdwCarousel* _tmp31_;
	GtkEventControllerMotion* _tmp32_;
	GtkEventController* _tmp33_;
	GtkWidget* _tmp34_;
	GtkWidget* _tmp35_;
	AdwCarousel* _tmp36_;
	GSettings* _tmp37_;
	parent_class = G_OBJECT_CLASS (notifications_abstract_bubble_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubble);
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
	gtk_stack_set_vhomogeneous (_tmp0_, FALSE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->content_area);
	self->content_area = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->draw_area);
	self->priv->draw_area = _tmp1_;
	_tmp2_ = self->priv->draw_area;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "draw-area");
	_tmp3_ = self->priv->draw_area;
	_tmp4_ = self->content_area;
	gtk_box_append (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic");
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp5_);
	close_button = _tmp5_;
	_tmp6_ = close_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, "close");
	_tmp7_ = close_button;
	_tmp8_ = _g_object_ref0 ((GtkWidget*) _tmp7_);
	_tmp9_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp9_, FALSE);
	gtk_revealer_set_transition_type (_tmp9_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
	gtk_revealer_set_child (_tmp9_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	gtk_widget_set_overflow ((GtkWidget*) _tmp9_, GTK_OVERFLOW_VISIBLE);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->close_revealer);
	self->priv->close_revealer = _tmp9_;
	_tmp10_ = self->priv->draw_area;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	_tmp12_ = (GtkOverlay*) gtk_overlay_new ();
	gtk_overlay_set_child (_tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp12_;
	_tmp13_ = self->priv->overlay;
	_tmp14_ = self->priv->close_revealer;
	gtk_overlay_add_overlay (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = (AdwCarousel*) adw_carousel_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, TRUE);
	g_object_ref_sink (_tmp15_);
	carousel = _tmp15_;
	_tmp16_ = carousel;
	_tmp17_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	adw_carousel_append (_tmp16_, (GtkWidget*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = carousel;
	_tmp20_ = self->priv->overlay;
	adw_carousel_append (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = carousel;
	_tmp22_ = self->priv->overlay;
	adw_carousel_scroll_to (_tmp21_, (GtkWidget*) _tmp22_, FALSE);
	_tmp23_ = carousel;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp23_);
	g_object_set ((GtkWindow*) self, "default-width", 332, NULL);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_widget_add_css_class ((GtkWidget*) self, "notification");
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	gtk_widget_set_focusable ((GtkWidget*) self, FALSE);
	_tmp24_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp24_);
	_tmp25_ = _tmp24_;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = carousel;
	g_signal_connect_object (_tmp26_, "page-changed", (GCallback) _notifications_abstract_bubble_on_page_changed_adw_carousel_page_changed, self, 0);
	_tmp27_ = close_button;
	g_signal_connect_object (_tmp27_, "clicked", (GCallback) __notifications_abstract_bubble___lambda4__gtk_button_clicked, self, 0);
	_tmp28_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	motion_controller = _tmp28_;
	_tmp29_ = motion_controller;
	g_signal_connect_object (_tmp29_, "enter", (GCallback) _notifications_abstract_bubble_pointer_enter_gtk_event_controller_motion_enter, self, 0);
	_tmp30_ = motion_controller;
	g_signal_connect_object (_tmp30_, "leave", (GCallback) _notifications_abstract_bubble_pointer_leave_gtk_event_controller_motion_leave, self, 0);
	_tmp31_ = carousel;
	_tmp32_ = motion_controller;
	_tmp33_ = _g_object_ref0 ((GtkEventController*) _tmp32_);
	gtk_widget_add_controller ((GtkWidget*) _tmp31_, _tmp33_);
	g_object_set ((GtkAccessible*) self, "accessible-role", GTK_ACCESSIBLE_ROLE_ALERT, NULL);
	_tmp34_ = gtk_window_get_child ((GtkWindow*) self);
	_tmp35_ = _tmp34_;
	g_signal_connect_object (_tmp35_, "realize", (GCallback) __notifications_abstract_bubble___lambda5__gtk_widget_realize, self, 0);
	_tmp36_ = carousel;
	g_signal_connect_object ((GObject*) _tmp36_, "notify::position", (GCallback) _notifications_abstract_bubble_update_swipe_progress_g_object_notify, self, 0);
	_tmp37_ = notifications_abstract_bubble_transparency_settings;
	g_signal_connect_object (_tmp37_, "changed::use-transparency", (GCallback) _notifications_abstract_bubble_update_transparency_g_settings_changed, self, 0);
	notifications_abstract_bubble_update_transparency (self);
	_g_object_unref0 (motion_controller);
	_g_object_unref0 (carousel);
	_g_object_unref0 (close_button);
	return obj;
}

static void
notifications_abstract_bubble_class_init (NotificationsAbstractBubbleClass * klass,
                                          gpointer klass_data)
{
	GSettingsSchema* transparency_schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GSettingsSchema* _tmp3_;
	notifications_abstract_bubble_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NotificationsAbstractBubble_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_notifications_abstract_bubble_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_notifications_abstract_bubble_set_property;
	G_OBJECT_CLASS (klass)->constructor = notifications_abstract_bubble_constructor;
	G_OBJECT_CLASS (klass)->finalize = notifications_abstract_bubble_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NOTIFICATIONS_ABSTRACT_BUBBLE_TIMEOUT_PROPERTY, notifications_abstract_bubble_properties[NOTIFICATIONS_ABSTRACT_BUBBLE_TIMEOUT_PROPERTY] = g_param_spec_uint ("timeout", "timeout", "timeout", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	notifications_abstract_bubble_signals[NOTIFICATIONS_ABSTRACT_BUBBLE_CLOSED_SIGNAL] = g_signal_new_class_handler ("closed", NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, G_SIGNAL_RUN_LAST, (GCallback) notifications_abstract_bubble_real_closed, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, NOTIFICATIONS_TYPE_CLOSE_REASON);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "io.elementary.desktop.wingpanel", TRUE);
	transparency_schema = _tmp1_;
	_tmp3_ = transparency_schema;
	if (_tmp3_ != NULL) {
		GSettingsSchema* _tmp4_;
		_tmp4_ = transparency_schema;
		_tmp2_ = g_settings_schema_has_key (_tmp4_, "use-transparency");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GSettings* _tmp5_;
		_tmp5_ = g_settings_new ("io.elementary.desktop.wingpanel");
		_g_object_unref0 (notifications_abstract_bubble_transparency_settings);
		notifications_abstract_bubble_transparency_settings = _tmp5_;
	}
	_g_settings_schema_unref0 (transparency_schema);
}

static void
notifications_abstract_bubble_instance_init (NotificationsAbstractBubble * self,
                                             gpointer klass)
{
	self->priv = notifications_abstract_bubble_get_instance_private (self);
	self->priv->current_swipe_progress = 1.0;
}

static void
notifications_abstract_bubble_finalize (GObject * obj)
{
	NotificationsAbstractBubble * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubble);
	_g_object_unref0 (self->content_area);
	_g_object_unref0 (self->priv->close_revealer);
	_g_object_unref0 (self->priv->draw_area);
	_g_object_unref0 (self->priv->overlay);
	_wl_proxy_destroy0 (self->priv->desktop_shell);
	_wl_proxy_destroy0 (self->priv->desktop_panel);
	G_OBJECT_CLASS (notifications_abstract_bubble_parent_class)->finalize (obj);
}

static GType
notifications_abstract_bubble_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsAbstractBubbleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_abstract_bubble_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsAbstractBubble), 0, (GInstanceInitFunc) notifications_abstract_bubble_instance_init, NULL };
	GType notifications_abstract_bubble_type_id;
	notifications_abstract_bubble_type_id = g_type_register_static (gtk_window_get_type (), "NotificationsAbstractBubble", &g_define_type_info, 0);
	NotificationsAbstractBubble_private_offset = g_type_add_instance_private (notifications_abstract_bubble_type_id, sizeof (NotificationsAbstractBubblePrivate));
	return notifications_abstract_bubble_type_id;
}

GType
notifications_abstract_bubble_get_type (void)
{
	static volatile gsize notifications_abstract_bubble_type_id__once = 0;
	if (g_once_init_enter (&notifications_abstract_bubble_type_id__once)) {
		GType notifications_abstract_bubble_type_id;
		notifications_abstract_bubble_type_id = notifications_abstract_bubble_get_type_once ();
		g_once_init_leave (&notifications_abstract_bubble_type_id__once, notifications_abstract_bubble_type_id);
	}
	return notifications_abstract_bubble_type_id__once;
}

static void
_vala_notifications_abstract_bubble_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	NotificationsAbstractBubble * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubble);
	switch (property_id) {
		case NOTIFICATIONS_ABSTRACT_BUBBLE_TIMEOUT_PROPERTY:
		g_value_set_uint (value, notifications_abstract_bubble_get_timeout (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_notifications_abstract_bubble_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	NotificationsAbstractBubble * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NOTIFICATIONS_TYPE_ABSTRACT_BUBBLE, NotificationsAbstractBubble);
	switch (property_id) {
		case NOTIFICATIONS_ABSTRACT_BUBBLE_TIMEOUT_PROPERTY:
		notifications_abstract_bubble_set_timeout (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

