/* converter-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from converter-plugin.vala, do not modify */

/*
* Copyright (c) 2022 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Jeremy Wootten <jeremywootten@gmail.com>
*/

#include "slingshot.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_CONVERTER_PLUGIN_0_PROPERTY,
	SYNAPSE_CONVERTER_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_CONVERTER_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_converter_plugin_properties[SYNAPSE_CONVERTER_PLUGIN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT (synapse_converter_plugin_result_get_type ())
#define SYNAPSE_CONVERTER_PLUGIN_RESULT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT, SynapseConverterPluginResult))
#define SYNAPSE_CONVERTER_PLUGIN_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT, SynapseConverterPluginResultClass))
#define SYNAPSE_CONVERTER_PLUGIN_IS_RESULT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CONVERTER_PLUGIN_IS_RESULT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT))
#define SYNAPSE_CONVERTER_PLUGIN_RESULT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT, SynapseConverterPluginResultClass))

typedef struct _SynapseConverterPluginResult SynapseConverterPluginResult;
typedef struct _SynapseConverterPluginResultClass SynapseConverterPluginResultClass;
typedef struct _SynapseConverterPluginSearchData SynapseConverterPluginSearchData;
typedef struct _SynapseConverterPluginResultPrivate SynapseConverterPluginResultPrivate;
enum  {
	SYNAPSE_CONVERTER_PLUGIN_RESULT_0_PROPERTY,
	SYNAPSE_CONVERTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY,
	SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_PROPERTY,
	SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY,
	SYNAPSE_CONVERTER_PLUGIN_RESULT_NUM_PROPERTIES
};
static GParamSpec* synapse_converter_plugin_result_properties[SYNAPSE_CONVERTER_PLUGIN_RESULT_NUM_PROPERTIES];

struct _SynapseConverterPluginPrivate {
	gboolean _enabled;
};

struct _SynapseConverterPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseConverterPlugin* self;
	SynapseQuery query;
	SynapseResultSet* result;
	SynapseResultSet* results;
	SynapseResultData* result_data;
	SynapseConverterPluginBackend* _tmp0_;
	SynapseConverterPluginBackend* _tmp1_;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	SynapseResultData* _tmp5_;
	SynapseResultData* _tmp6_;
	gint _tmp6__length1;
	gint result_data_length1;
	gint _result_data_size_;
	SynapseResultData* _tmp7_;
	gint _tmp7__length1;
	SynapseResultSet* _tmp8_;
	SynapseResultData* _tmp9_;
	gint _tmp9__length1;
	SynapseResultData* rd_collection;
	gint rd_collection_length1;
	gint _rd_collection_size_;
	gint rd_it;
	SynapseResultData _tmp10_;
	SynapseResultData _tmp11_;
	SynapseResultData rd;
	SynapseConverterPluginResult* _result_;
	SynapseResultData _tmp12_;
	SynapseResultData _tmp13_;
	SynapseResultData _tmp14_;
	const gchar* _tmp15_;
	SynapseResultData _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	SynapseConverterPluginResult* _tmp20_;
	SynapseConverterPluginResult* _tmp21_;
	SynapseConverterPluginResult* _tmp22_;
	SynapseResultData _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	SynapseResultSet* _tmp28_;
	SynapseConverterPluginResult* _tmp29_;
	GError* _inner_error0_;
};

struct _SynapseConverterPluginResult {
	SynapseMatch parent_instance;
	SynapseConverterPluginResultPrivate * priv;
};

struct _SynapseConverterPluginResultClass {
	SynapseMatchClass parent_class;
};

struct _SynapseConverterPluginResultPrivate {
	gint _default_relevancy;
	gchar* _text;
	SynapseTextOrigin _text_origin;
};

static gint SynapseConverterPlugin_private_offset;
static gpointer synapse_converter_plugin_parent_class = NULL;
static gint SynapseConverterPluginResult_private_offset;
static gpointer synapse_converter_plugin_result_parent_class = NULL;
static SynapseTextMatchIface * synapse_converter_plugin_result_synapse_text_match_parent_iface = NULL;
static SynapseActivatableIface * synapse_converter_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_converter_plugin_synapse_item_provider_parent_iface = NULL;

static void synapse_converter_plugin_real_activate (SynapseActivatable* base);
static void synapse_converter_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_converter_plugin_register_plugin (void);
static void _synapse_converter_plugin_register_plugin_synapse_plugin_register_func (void);
static gboolean synapse_converter_plugin_real_handles_query (SynapseItemProvider* base,
                                                      SynapseQuery* query);
static void synapse_converter_plugin_real_search_data_free (gpointer _data);
static void synapse_converter_plugin_real_search (SynapseItemProvider* base,
                                           SynapseQuery* query,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean synapse_converter_plugin_real_search_co (SynapseConverterPluginSearchData* _data_);
static GType synapse_converter_plugin_result_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseConverterPluginResult* synapse_converter_plugin_result_new (gdouble _result_,
                                                                   const gchar* title);
static SynapseConverterPluginResult* synapse_converter_plugin_result_construct (GType object_type,
                                                                         gdouble _result_,
                                                                         const gchar* title);
static void _vala_SynapseResultData_array_free (SynapseResultData * array,
                                         gssize array_length);
static gint synapse_converter_plugin_result_get_default_relevancy (SynapseConverterPluginResult* self);
static void synapse_converter_plugin_result_set_default_relevancy (SynapseConverterPluginResult* self,
                                                            gint value);
static void synapse_converter_plugin_result_finalize (GObject * obj);
static GType synapse_converter_plugin_result_get_type_once (void);
static void _vala_synapse_converter_plugin_result_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec);
static void _vala_synapse_converter_plugin_result_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec);
static void synapse_converter_plugin_finalize (GObject * obj);
static GType synapse_converter_plugin_get_type_once (void);
static void _vala_synapse_converter_plugin_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_synapse_converter_plugin_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
synapse_converter_plugin_get_instance_private (SynapseConverterPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseConverterPlugin_private_offset);
}

static void
synapse_converter_plugin_real_activate (SynapseActivatable* base)
{
	SynapseConverterPlugin * self;
	self = (SynapseConverterPlugin*) base;
}

static void
synapse_converter_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseConverterPlugin * self;
	self = (SynapseConverterPlugin*) base;
}

static void
_synapse_converter_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_converter_plugin_register_plugin ();
}

static void
synapse_converter_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_find_program_in_path ("bc");
	_tmp3_ = _tmp2_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_CONVERTER_PLUGIN, "accessories-converter", _synapse_converter_plugin_register_plugin_synapse_plugin_register_func, _tmp3_ != NULL);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}

static gboolean
synapse_converter_plugin_real_handles_query (SynapseItemProvider* base,
                                             SynapseQuery* query)
{
	SynapseConverterPlugin * self;
	SynapseQuery _tmp0_;
	gboolean result;
	self = (SynapseConverterPlugin*) base;
	g_return_val_if_fail (query != NULL, FALSE);
	_tmp0_ = *query;
	result = (_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_ACTIONS) == SYNAPSE_QUERY_FLAGS_ACTIONS;
	return result;
}

static void
synapse_converter_plugin_real_search_data_free (gpointer _data)
{
	SynapseConverterPluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->query);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseConverterPluginSearchData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
synapse_converter_plugin_real_search (SynapseItemProvider* base,
                                      SynapseQuery* query,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	SynapseConverterPlugin * self;
	SynapseConverterPluginSearchData* _data_;
	SynapseConverterPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
	g_return_if_fail (query != NULL);
	self = (SynapseConverterPlugin*) base;
	_data_ = g_slice_new0 (SynapseConverterPluginSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_converter_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *query;
	_tmp2_ = _tmp1_;
	synapse_query_copy (&_tmp2_, &_tmp3_);
	synapse_query_destroy (&_data_->query);
	_data_->query = _tmp3_;
	synapse_converter_plugin_real_search_co (_data_);
}

static SynapseResultSet*
synapse_converter_plugin_search_finish (SynapseItemProvider* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	SynapseResultSet* result;
	SynapseConverterPluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
_vala_SynapseResultData_array_free (SynapseResultData * array,
                                    gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			synapse_result_data_destroy (&array[i]);
		}
	}
	g_free (array);
}

static gboolean
synapse_converter_plugin_real_search_co (SynapseConverterPluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->results = NULL;
	_data_->_tmp0_ = synapse_converter_plugin_backend_get_instance ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->query;
	_data_->_tmp3_ = _data_->_tmp2_.query_string;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = synapse_converter_plugin_backend_get_conversion_data (_data_->_tmp1_, _data_->_tmp3_, &_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->result_data = _data_->_tmp6_;
	_data_->result_data_length1 = _data_->_tmp6__length1;
	_data_->_result_data_size_ = _data_->result_data_length1;
	_data_->_tmp7_ = _data_->result_data;
	_data_->_tmp7__length1 = _data_->result_data_length1;
	if (_data_->_tmp7__length1 > 0) {
		_data_->_tmp8_ = synapse_result_set_new ();
		_g_object_unref0 (_data_->results);
		_data_->results = _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->result_data;
	_data_->_tmp9__length1 = _data_->result_data_length1;
	{
		_data_->rd_collection_length1 = 0;
		_data_->_rd_collection_size_ = 0;
		_data_->rd_collection = _data_->_tmp9_;
		_data_->rd_collection_length1 = _data_->_tmp9__length1;
		for (_data_->rd_it = 0; _data_->rd_it < _data_->rd_collection_length1; _data_->rd_it = _data_->rd_it + 1) {
			_data_->_tmp10_ = _data_->rd_collection[_data_->rd_it];
			memset (&_data_->_tmp11_, 0, sizeof (SynapseResultData));
			synapse_result_data_copy (&_data_->_tmp10_, &_data_->_tmp11_);
			_data_->rd = _data_->_tmp11_;
			{
				_data_->_tmp12_ = _data_->rd;
				_data_->_tmp13_ = _data_->rd;
				_data_->_tmp14_ = _data_->rd;
				_data_->_tmp15_ = _data_->_tmp14_.from_description;
				_data_->_tmp16_ = _data_->rd;
				_data_->_tmp17_ = _data_->_tmp16_.to_description;
				_data_->_tmp18_ = g_strdup_printf (_ ("%g (%s to %s)"), _data_->_tmp13_.factor, _data_->_tmp15_, _data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->_tmp20_ = synapse_converter_plugin_result_new (_data_->_tmp12_.factor, _data_->_tmp19_);
				_data_->_tmp21_ = _data_->_tmp20_;
				_g_free0 (_data_->_tmp19_);
				_data_->_result_ = _data_->_tmp21_;
				_data_->_tmp22_ = _data_->_result_;
				_data_->_tmp23_ = _data_->rd;
				_data_->_tmp24_ = g_strdup_printf (_ ("Click to copy %g to clipboard"), _data_->_tmp23_.factor);
				_data_->_tmp25_ = _data_->_tmp24_;
				_data_->_tmp26_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _data_->_tmp25_);
				_data_->_tmp27_ = _data_->_tmp26_;
				synapse_match_set_description ((SynapseMatch*) _data_->_tmp22_, _data_->_tmp27_);
				_g_free0 (_data_->_tmp27_);
				_g_free0 (_data_->_tmp25_);
				_data_->_tmp28_ = _data_->results;
				_data_->_tmp29_ = _data_->_result_;
				synapse_result_set_add (_data_->_tmp28_, (SynapseMatch*) _data_->_tmp29_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
				_g_object_unref0 (_data_->_result_);
				synapse_result_data_destroy (&_data_->rd);
			}
		}
	}
	synapse_query_check_cancellable (&_data_->query, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_data_->result_data = (_vala_SynapseResultData_array_free (_data_->result_data, _data_->result_data_length1), NULL);
			_g_object_unref0 (_data_->results);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->result_data = (_vala_SynapseResultData_array_free (_data_->result_data, _data_->result_data_length1), NULL);
			_g_object_unref0 (_data_->results);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->results;
	_data_->result_data = (_vala_SynapseResultData_array_free (_data_->result_data, _data_->result_data_length1), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SynapseConverterPlugin*
synapse_converter_plugin_construct (GType object_type)
{
	SynapseConverterPlugin * self = NULL;
	self = (SynapseConverterPlugin*) g_object_new (object_type, NULL);
	return self;
}

SynapseConverterPlugin*
synapse_converter_plugin_new (void)
{
	return synapse_converter_plugin_construct (SYNAPSE_TYPE_CONVERTER_PLUGIN);
}

static gboolean
synapse_converter_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseConverterPlugin* self;
	self = (SynapseConverterPlugin*) base;
	result = self->priv->_enabled;
	return result;
}

static void
synapse_converter_plugin_real_set_enabled (SynapseActivatable* base,
                                           gboolean value)
{
	SynapseConverterPlugin* self;
	gboolean old_value;
	self = (SynapseConverterPlugin*) base;
	old_value = synapse_converter_plugin_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_converter_plugin_properties[SYNAPSE_CONVERTER_PLUGIN_ENABLED_PROPERTY]);
	}
}

static inline gpointer
synapse_converter_plugin_result_get_instance_private (SynapseConverterPluginResult* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseConverterPluginResult_private_offset);
}

static SynapseConverterPluginResult*
synapse_converter_plugin_result_construct (GType object_type,
                                           gdouble _result_,
                                           const gchar* title)
{
	SynapseConverterPluginResult * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (title != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%g", _result_);
	_tmp1_ = _tmp0_;
	self = (SynapseConverterPluginResult*) g_object_new (object_type, "match-type", SYNAPSE_MATCH_TYPE_TEXT, "text", _tmp1_, "title", title, "icon-name", "accessories-calculator", "text-origin", SYNAPSE_TEXT_ORIGIN_UNKNOWN, NULL);
	_g_free0 (_tmp1_);
	return self;
}

static SynapseConverterPluginResult*
synapse_converter_plugin_result_new (gdouble _result_,
                                     const gchar* title)
{
	return synapse_converter_plugin_result_construct (SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT, _result_, title);
}

static gint
synapse_converter_plugin_result_get_default_relevancy (SynapseConverterPluginResult* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_default_relevancy;
	return result;
}

static void
synapse_converter_plugin_result_set_default_relevancy (SynapseConverterPluginResult* self,
                                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_converter_plugin_result_get_default_relevancy (self);
	if (old_value != value) {
		self->priv->_default_relevancy = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_converter_plugin_result_properties[SYNAPSE_CONVERTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY]);
	}
}

static const gchar*
synapse_converter_plugin_result_real_get_text (SynapseTextMatch* base)
{
	const gchar* result;
	SynapseConverterPluginResult* self;
	const gchar* _tmp0_;
	self = (SynapseConverterPluginResult*) base;
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

static void
synapse_converter_plugin_result_real_set_text (SynapseTextMatch* base,
                                               const gchar* value)
{
	SynapseConverterPluginResult* self;
	gchar* old_value;
	self = (SynapseConverterPluginResult*) base;
	old_value = synapse_converter_plugin_result_real_get_text (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_text);
		self->priv->_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_converter_plugin_result_properties[SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_PROPERTY]);
	}
}

static SynapseTextOrigin
synapse_converter_plugin_result_real_get_text_origin (SynapseTextMatch* base)
{
	SynapseTextOrigin result;
	SynapseConverterPluginResult* self;
	self = (SynapseConverterPluginResult*) base;
	result = self->priv->_text_origin;
	return result;
}

static void
synapse_converter_plugin_result_real_set_text_origin (SynapseTextMatch* base,
                                                      SynapseTextOrigin value)
{
	SynapseConverterPluginResult* self;
	SynapseTextOrigin old_value;
	self = (SynapseConverterPluginResult*) base;
	old_value = synapse_converter_plugin_result_real_get_text_origin (base);
	if (old_value != value) {
		self->priv->_text_origin = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_converter_plugin_result_properties[SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY]);
	}
}

static void
synapse_converter_plugin_result_class_init (SynapseConverterPluginResultClass * klass,
                                            gpointer klass_data)
{
	synapse_converter_plugin_result_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseConverterPluginResult_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_converter_plugin_result_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_converter_plugin_result_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_converter_plugin_result_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CONVERTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY, synapse_converter_plugin_result_properties[SYNAPSE_CONVERTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY] = g_param_spec_int ("default-relevancy", "default-relevancy", "default-relevancy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_PROPERTY, synapse_converter_plugin_result_properties[SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY, synapse_converter_plugin_result_properties[SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY] = g_param_spec_enum ("text-origin", "text-origin", "text-origin", SYNAPSE_TYPE_TEXT_ORIGIN, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
synapse_converter_plugin_result_synapse_text_match_interface_init (SynapseTextMatchIface * iface,
                                                                   gpointer iface_data)
{
	synapse_converter_plugin_result_synapse_text_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_text = synapse_converter_plugin_result_real_get_text;
	iface->set_text = synapse_converter_plugin_result_real_set_text;
	iface->get_text_origin = synapse_converter_plugin_result_real_get_text_origin;
	iface->set_text_origin = synapse_converter_plugin_result_real_set_text_origin;
}

static void
synapse_converter_plugin_result_instance_init (SynapseConverterPluginResult * self,
                                               gpointer klass)
{
	gchar* _tmp0_;
	self->priv = synapse_converter_plugin_result_get_instance_private (self);
	self->priv->_default_relevancy = 0;
	_tmp0_ = g_strdup ("");
	self->priv->_text = _tmp0_;
}

static void
synapse_converter_plugin_result_finalize (GObject * obj)
{
	SynapseConverterPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT, SynapseConverterPluginResult);
	_g_free0 (self->priv->_text);
	G_OBJECT_CLASS (synapse_converter_plugin_result_parent_class)->finalize (obj);
}

static GType
synapse_converter_plugin_result_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseConverterPluginResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_converter_plugin_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseConverterPluginResult), 0, (GInstanceInitFunc) synapse_converter_plugin_result_instance_init, NULL };
	static const GInterfaceInfo synapse_text_match_info = { (GInterfaceInitFunc) synapse_converter_plugin_result_synapse_text_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_converter_plugin_result_type_id;
	synapse_converter_plugin_result_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseConverterPluginResult", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_converter_plugin_result_type_id, SYNAPSE_TYPE_TEXT_MATCH, &synapse_text_match_info);
	SynapseConverterPluginResult_private_offset = g_type_add_instance_private (synapse_converter_plugin_result_type_id, sizeof (SynapseConverterPluginResultPrivate));
	return synapse_converter_plugin_result_type_id;
}

static GType
synapse_converter_plugin_result_get_type (void)
{
	static volatile gsize synapse_converter_plugin_result_type_id__once = 0;
	if (g_once_init_enter (&synapse_converter_plugin_result_type_id__once)) {
		GType synapse_converter_plugin_result_type_id;
		synapse_converter_plugin_result_type_id = synapse_converter_plugin_result_get_type_once ();
		g_once_init_leave (&synapse_converter_plugin_result_type_id__once, synapse_converter_plugin_result_type_id);
	}
	return synapse_converter_plugin_result_type_id__once;
}

static void
_vala_synapse_converter_plugin_result_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec)
{
	SynapseConverterPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT, SynapseConverterPluginResult);
	switch (property_id) {
		case SYNAPSE_CONVERTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		g_value_set_int (value, synapse_converter_plugin_result_get_default_relevancy (self));
		break;
		case SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_PROPERTY:
		g_value_set_string (value, synapse_text_match_get_text ((SynapseTextMatch*) self));
		break;
		case SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY:
		g_value_set_enum (value, synapse_text_match_get_text_origin ((SynapseTextMatch*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_converter_plugin_result_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec)
{
	SynapseConverterPluginResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_CONVERTER_PLUGIN_TYPE_RESULT, SynapseConverterPluginResult);
	switch (property_id) {
		case SYNAPSE_CONVERTER_PLUGIN_RESULT_DEFAULT_RELEVANCY_PROPERTY:
		synapse_converter_plugin_result_set_default_relevancy (self, g_value_get_int (value));
		break;
		case SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_PROPERTY:
		synapse_text_match_set_text ((SynapseTextMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_CONVERTER_PLUGIN_RESULT_TEXT_ORIGIN_PROPERTY:
		synapse_text_match_set_text_origin ((SynapseTextMatch*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
synapse_converter_plugin_class_init (SynapseConverterPluginClass * klass,
                                     gpointer klass_data)
{
	synapse_converter_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseConverterPlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_converter_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_converter_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_converter_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_CONVERTER_PLUGIN_ENABLED_PROPERTY, synapse_converter_plugin_properties[SYNAPSE_CONVERTER_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_converter_plugin_register_plugin ();
}

static void
synapse_converter_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                             gpointer iface_data)
{
	synapse_converter_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_converter_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_converter_plugin_real_deactivate;
	iface->get_enabled = synapse_converter_plugin_real_get_enabled;
	iface->set_enabled = synapse_converter_plugin_real_set_enabled;
}

static void
synapse_converter_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                               gpointer iface_data)
{
	synapse_converter_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->handles_query = (gboolean (*) (SynapseItemProvider*, SynapseQuery*)) synapse_converter_plugin_real_handles_query;
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_converter_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_converter_plugin_search_finish;
}

static void
synapse_converter_plugin_instance_init (SynapseConverterPlugin * self,
                                        gpointer klass)
{
	self->priv = synapse_converter_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
}

static void
synapse_converter_plugin_finalize (GObject * obj)
{
	SynapseConverterPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CONVERTER_PLUGIN, SynapseConverterPlugin);
	G_OBJECT_CLASS (synapse_converter_plugin_parent_class)->finalize (obj);
}

static GType
synapse_converter_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseConverterPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_converter_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseConverterPlugin), 0, (GInstanceInitFunc) synapse_converter_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_converter_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_converter_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_converter_plugin_type_id;
	synapse_converter_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseConverterPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_converter_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_converter_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseConverterPlugin_private_offset = g_type_add_instance_private (synapse_converter_plugin_type_id, sizeof (SynapseConverterPluginPrivate));
	return synapse_converter_plugin_type_id;
}

GType
synapse_converter_plugin_get_type (void)
{
	static volatile gsize synapse_converter_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_converter_plugin_type_id__once)) {
		GType synapse_converter_plugin_type_id;
		synapse_converter_plugin_type_id = synapse_converter_plugin_get_type_once ();
		g_once_init_leave (&synapse_converter_plugin_type_id__once, synapse_converter_plugin_type_id);
	}
	return synapse_converter_plugin_type_id__once;
}

static void
_vala_synapse_converter_plugin_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SynapseConverterPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CONVERTER_PLUGIN, SynapseConverterPlugin);
	switch (property_id) {
		case SYNAPSE_CONVERTER_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_converter_plugin_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SynapseConverterPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_CONVERTER_PLUGIN, SynapseConverterPlugin);
	switch (property_id) {
		case SYNAPSE_CONVERTER_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

