use crate::settings::Keybindings;
use gtk4::Builder;
use libadwaita::ShortcutsDialog;
use std::str;

pub const XML_DATA: &str = r#"
<?xml version="1.0" encoding="UTF-8"?>
<interface>
  <requires lib="gtk" version="4.0"/>
  <object class="AdwShortcutsDialog" id="shortcuts-dialog">
    <child>
        <object class="AdwShortcutsSection">
        <property name="title" translatable="yes">Global</property>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Shortcut Window</property>
            <property name="accelerator">F1</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Refresh Feeds</property>
            <property name="accelerator">$REFRESH</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Search</property>
            <property name="accelerator">$SEARCH</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Quit</property>
            <property name="accelerator">&lt;ctrl&gt;q</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">All Articles</property>
            <property name="accelerator">$ALLARTICLES</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Only Unread Articles</property>
            <property name="accelerator">$ONLYUNREAD</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Only Starred Articles</property>
            <property name="accelerator">$ONLYSTARRED</property>
            </object>
        </child>
        </object>
    </child>
    <child>
        <object class="AdwShortcutsSection">
        <property name="title" translatable="yes">Article List</property>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Next Article</property>
            <property name="accelerator">$NEXTART</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Previous Article</property>
            <property name="accelerator">$PREVART</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Toggle Read</property>
            <property name="accelerator">$TOGGLEREAD</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Toggle Starred</property>
            <property name="accelerator">$TOGGLEMARKED</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Open In Browser</property>
            <property name="accelerator">$OPENBROWSER</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Copy URL</property>
            <property name="accelerator">$COPYURL</property>
            </object>
        </child>
        </object>
    </child>
    <child>
        <object class="AdwShortcutsSection">
        <property name="title" translatable="yes">Article View</property>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Scroll Up</property>
            <property name="accelerator">$SCROLLUP</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Scroll Down</property>
            <property name="accelerator">$SCROLLDOWN</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Scrape content</property>
            <property name="accelerator">$SCRAPCONTENT</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Tag Article</property>
            <property name="accelerator">$TAGARTICLE</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Fullscreen Article</property>
            <property name="accelerator">$FULLSCREENARTICLE</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Close Article</property>
            <property name="accelerator">$CLOSEARTICLE</property>
            </object>
        </child>
        </object>
    </child>
    <child>
        <object class="AdwShortcutsSection">
        <property name="title" translatable="yes">Feed List</property>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Next Item</property>
            <property name="accelerator">$NEXTFEED</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Previous Item</property>
            <property name="accelerator">$PREVFEED</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Expand/Collapse Category</property>
            <property name="accelerator">$TOGGLEEXPAND</property>
            </object>
        </child>
        <child>
            <object class="AdwShortcutsItem">
            <property name="title" translatable="yes">Mark Item Read</property>
            <property name="accelerator">$ITEMREAD</property>
            </object>
        </child>
        </object>
    </child>
  </object>
</interface>
"#;

pub struct ShortcutsDialogBuilder;

impl ShortcutsDialogBuilder {
    pub fn build(settings: &Keybindings) -> ShortcutsDialog {
        let mut ui_xml = XML_DATA.to_owned();
        ui_xml = Self::shortcut(&ui_xml, "$REFRESH", settings.general().refresh());
        ui_xml = Self::shortcut(&ui_xml, "$SEARCH", settings.general().search());
        ui_xml = Self::shortcut(&ui_xml, "$ALLARTICLES", settings.general().all_articles());
        ui_xml = Self::shortcut(&ui_xml, "$ONLYUNREAD", settings.general().only_unread());
        ui_xml = Self::shortcut(&ui_xml, "$ONLYSTARRED", settings.general().only_starred());
        ui_xml = Self::shortcut(&ui_xml, "$NEXTART", settings.article_list().next());
        ui_xml = Self::shortcut(&ui_xml, "$PREVART", settings.article_list().prev());
        ui_xml = Self::shortcut(&ui_xml, "$TOGGLEREAD", settings.article_list().read());
        ui_xml = Self::shortcut(&ui_xml, "$TOGGLEMARKED", settings.article_list().mark());
        ui_xml = Self::shortcut(&ui_xml, "$OPENBROWSER", settings.article_list().open());
        ui_xml = Self::shortcut(&ui_xml, "$COPYURL", settings.article_list().copy_url());
        ui_xml = Self::shortcut(&ui_xml, "$SCROLLUP", settings.article_view().scroll_up());
        ui_xml = Self::shortcut(&ui_xml, "$SCROLLDOWN", settings.article_view().scroll_down());
        ui_xml = Self::shortcut(&ui_xml, "$SCRAPCONTENT", settings.article_view().scrap_content());
        ui_xml = Self::shortcut(&ui_xml, "$TAGARTICLE", settings.article_view().tag());
        ui_xml = Self::shortcut(&ui_xml, "$FULLSCREENARTICLE", settings.article_view().fullscreen());
        ui_xml = Self::shortcut(&ui_xml, "$NEXTFEED", settings.feed_list().next());
        ui_xml = Self::shortcut(&ui_xml, "$PREVFEED", settings.feed_list().prev());
        ui_xml = Self::shortcut(&ui_xml, "$CLOSEARTICLE", settings.article_view().close());
        ui_xml = Self::shortcut(&ui_xml, "$TOGGLEEXPAND", settings.feed_list().toggle_expanded());
        ui_xml = Self::shortcut(&ui_xml, "$ITEMREAD", settings.feed_list().read());

        let builder = Builder::from_string(&ui_xml);
        let widget: ShortcutsDialog = builder
            .object("shortcuts-dialog")
            .expect("Failed to create ShortcutsDialog");

        widget
    }

    fn shortcut(xml: &str, needle: &str, shortcut: Option<String>) -> String {
        match shortcut {
            Some(shortcut) => {
                let shortcut = shortcut.replace('&', "&amp;");
                let shortcut = shortcut.replace('<', "&lt;");
                let shortcut = shortcut.replace('>', "&gt;");
                xml.replacen(needle, &shortcut, 1)
            }
            None => xml.replacen(needle, "", 1),
        }
    }
}
