use glib::{Enum, prelude::*, translate::*};
use news_flash::models::Read;

#[derive(Debug, Default, Eq, PartialEq, Clone, Copy, Enum)]
#[repr(u32)]
#[enum_type(name = "NewsFlashGRead")]
pub enum GRead {
    #[default]
    Read,
    Unread,
}

impl From<Read> for GRead {
    fn from(read: Read) -> Self {
        match read {
            Read::Read => Self::Read,
            Read::Unread => Self::Unread,
        }
    }
}

impl From<GRead> for Read {
    fn from(read: GRead) -> Self {
        match read {
            GRead::Read => Read::Read,
            GRead::Unread => Read::Unread,
        }
    }
}

impl ToVariant for GRead {
    fn to_variant(&self) -> glib::Variant {
        self.into_glib().to_variant()
    }
}

impl FromVariant for GRead {
    fn from_variant(variant: &glib::Variant) -> Option<Self> {
        variant.get::<i32>().map(|int| unsafe { GRead::from_glib(int) })
    }
}

impl StaticVariantType for GRead {
    fn static_variant_type() -> std::borrow::Cow<'static, glib::VariantTy> {
        std::borrow::Cow::Borrowed(glib::VariantTy::INT32)
    }
}

impl GRead {
    pub fn invert(&self) -> Self {
        match self {
            Self::Read => Self::Unread,
            Self::Unread => Self::Read,
        }
    }
}
