/* UrlParser.c generated by valac 0.56.18, the Vala compiler
 * generated from UrlParser.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TEXT_PARSER (text_parser_get_type ())
#define TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_PARSER, TextParser))
#define TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_PARSER, TextParserClass))
#define IS_TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_PARSER))
#define IS_TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_PARSER))
#define TEXT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_PARSER, TextParserClass))

typedef struct _TextParser TextParser;
typedef struct _TextParserClass TextParserClass;
typedef struct _TextParserPrivate TextParserPrivate;
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_TEXT_BUFFER (undo_text_buffer_get_type ())
#define UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer))
#define UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))
#define IS_UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_BUFFER))
#define IS_UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_BUFFER))
#define UNDO_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))

typedef struct _UndoTextBuffer UndoTextBuffer;
typedef struct _UndoTextBufferClass UndoTextBufferClass;

#define TYPE_URL_PARSER (url_parser_get_type ())
#define URL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_URL_PARSER, UrlParser))
#define URL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_URL_PARSER, UrlParserClass))
#define IS_URL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_URL_PARSER))
#define IS_URL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_URL_PARSER))
#define URL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_URL_PARSER, UrlParserClass))

typedef struct _UrlParser UrlParser;
typedef struct _UrlParserClass UrlParserClass;
typedef struct _UrlParserPrivate UrlParserPrivate;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
typedef void (*TextParserTextMatchCallback) (FormattedText* text, GMatchInfo* match_info, gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TextParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextParserPrivate * priv;
};

struct _TextParserClass {
	GTypeClass parent_class;
	void (*finalize) (TextParser *self);
	gboolean (*tag_handled) (TextParser* self, FormatTag tag);
	void (*insert_tag) (TextParser* self, CanvasText* ct, FormatTag tag, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer, const gchar* extra);
	void (*remove_all_tags) (TextParser* self, CanvasText* ct, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer);
};

struct _UrlParser {
	TextParser parent_instance;
	UrlParserPrivate * priv;
};

struct _UrlParserClass {
	TextParserClass parent_class;
};

static gpointer url_parser_parent_class = NULL;

VALA_EXTERN gpointer text_parser_ref (gpointer instance);
VALA_EXTERN void text_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_parser (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_text_parser (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_text_parser (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_text_parser (const GValue* value);
VALA_EXTERN GType text_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextParser, text_parser_unref)
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType undo_text_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextBuffer, g_object_unref)
VALA_EXTERN GType url_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UrlParser, text_parser_unref)
VALA_EXTERN UrlParser* url_parser_new (void);
VALA_EXTERN UrlParser* url_parser_construct (GType object_type);
VALA_EXTERN TextParser* text_parser_new (const gchar* name);
VALA_EXTERN TextParser* text_parser_construct (GType object_type,
                                   const gchar* name);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN void text_parser_add_regex (TextParser* self,
                            const gchar* re,
                            TextParserTextMatchCallback func,
                            gpointer func_target);
static void url_parser_highlight_url (UrlParser* self,
                               FormattedText* text,
                               GMatchInfo* match);
static void _url_parser_highlight_url_text_parser_text_match_callback (FormattedText* text,
                                                                GMatchInfo* match_info,
                                                                gpointer self);
static void url_parser_highlight_filepath (UrlParser* self,
                                    FormattedText* text,
                                    GMatchInfo* match);
static void _url_parser_highlight_filepath_text_parser_text_match_callback (FormattedText* text,
                                                                     GMatchInfo* match_info,
                                                                     gpointer self);
VALA_EXTERN void text_parser_add_tag (TextParser* self,
                          FormattedText* text,
                          GMatchInfo* matches,
                          gint paren,
                          FormatTag tag,
                          const gchar* extra);
VALA_EXTERN gchar* text_parser_get_text (TextParser* self,
                             GMatchInfo* matches,
                             gint paren);
static GType url_parser_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
_url_parser_highlight_url_text_parser_text_match_callback (FormattedText* text,
                                                           GMatchInfo* match_info,
                                                           gpointer self)
{
	url_parser_highlight_url ((UrlParser*) self, text, match_info);
}

static void
_url_parser_highlight_filepath_text_parser_text_match_callback (FormattedText* text,
                                                                GMatchInfo* match_info,
                                                                gpointer self)
{
	url_parser_highlight_filepath ((UrlParser*) self, text, match_info);
}

UrlParser*
url_parser_construct (GType object_type)
{
	UrlParser* self = NULL;
	self = (UrlParser*) text_parser_construct (object_type, "URL");
	text_parser_add_regex ((TextParser*) self, "((mailto:)?[a-z0-9.-]+@[-a-z0-9]+(\\.[-a-z0-9]+)*\\.[a-z]+)", _url_parser_highlight_url_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "((https?|ftp):[^'\">\\s]+)", _url_parser_highlight_url_text_parser_text_match_callback, self);
	text_parser_add_regex ((TextParser*) self, "((file:///|/)(([^,/:*\\?\\<>\"\\|\\s](\\\\\\s)?)+(/|\\\\){0,1})+)", _url_parser_highlight_filepath_text_parser_text_match_callback, self);
	return self;
}

UrlParser*
url_parser_new (void)
{
	return url_parser_construct (TYPE_URL_PARSER);
}

static void
url_parser_highlight_url (UrlParser* self,
                          FormattedText* text,
                          GMatchInfo* match)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = text_parser_get_text ((TextParser*) self, match, 0);
	_tmp1_ = _tmp0_;
	text_parser_add_tag ((TextParser*) self, text, match, 0, FORMAT_TAG_URL, _tmp1_);
	_g_free0 (_tmp1_);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
url_parser_highlight_filepath (UrlParser* self,
                               FormattedText* text,
                               GMatchInfo* match)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = g_match_info_fetch (match, 0);
	str = _tmp0_;
	_tmp2_ = str;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ >= 7) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = str;
		_tmp6_ = string_substring (_tmp5_, (glong) 0, (glong) 7);
		_tmp7_ = _tmp6_;
		_tmp1_ = g_strcmp0 (_tmp7_, "file://") == 0;
		_g_free0 (_tmp7_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = str;
		_tmp9_ = string_substring (_tmp8_, (glong) 7, (glong) -1);
		_g_free0 (str);
		str = _tmp9_;
	}
	_tmp10_ = str;
	if (g_file_test (_tmp10_, G_FILE_TEST_EXISTS)) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = text_parser_get_text ((TextParser*) self, match, 0);
		_tmp12_ = _tmp11_;
		text_parser_add_tag ((TextParser*) self, text, match, 0, FORMAT_TAG_URL, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_g_free0 (str);
}

static void
url_parser_class_init (UrlParserClass * klass,
                       gpointer klass_data)
{
	url_parser_parent_class = g_type_class_peek_parent (klass);
}

static void
url_parser_instance_init (UrlParser * self,
                          gpointer klass)
{
}

static GType
url_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UrlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) url_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UrlParser), 0, (GInstanceInitFunc) url_parser_instance_init, NULL };
	GType url_parser_type_id;
	url_parser_type_id = g_type_register_static (TYPE_TEXT_PARSER, "UrlParser", &g_define_type_info, 0);
	return url_parser_type_id;
}

GType
url_parser_get_type (void)
{
	static volatile gsize url_parser_type_id__once = 0;
	if (g_once_init_enter (&url_parser_type_id__once)) {
		GType url_parser_type_id;
		url_parser_type_id = url_parser_get_type_once ();
		g_once_init_leave (&url_parser_type_id__once, url_parser_type_id);
	}
	return url_parser_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

