/* ExportYed.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportYed.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <libxml/parser.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_YED (export_yed_get_type ())
#define EXPORT_YED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_YED, ExportYed))
#define EXPORT_YED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_YED, ExportYedClass))
#define IS_EXPORT_YED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_YED))
#define IS_EXPORT_YED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_YED))
#define EXPORT_YED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_YED, ExportYedClass))

typedef struct _ExportYed ExportYed;
typedef struct _ExportYedClass ExportYedClass;
typedef struct _ExportYedPrivate ExportYedPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _xmlFreeDoc0(var) ((var == NULL) ? NULL : (var = (xmlFreeDoc (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_CONNECTIONS (connections_get_type ())
#define CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTIONS, Connections))
#define CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTIONS, ConnectionsClass))
#define IS_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTIONS))
#define IS_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTIONS))
#define CONNECTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTIONS, ConnectionsClass))

typedef struct _Connections Connections;
typedef struct _ConnectionsClass ConnectionsClass;
#define _connections_unref0(var) ((var == NULL) ? NULL : (var = (connections_unref (var), NULL)))

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_NODE_BORDER (node_border_get_type ())
#define NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_BORDER, NodeBorder))
#define IS_NODE_BORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_BORDER))
#define NODE_BORDER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_NODE_BORDER, NodeBorderIface))

typedef struct _NodeBorder NodeBorder;
typedef struct _NodeBorderIface NodeBorderIface;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())

#define TYPE_LINK_DASH (link_dash_get_type ())
#define LINK_DASH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINK_DASH, LinkDash))
#define LINK_DASH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINK_DASH, LinkDashClass))
#define IS_LINK_DASH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINK_DASH))
#define IS_LINK_DASH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINK_DASH))
#define LINK_DASH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINK_DASH, LinkDashClass))

typedef struct _LinkDash LinkDash;
typedef struct _LinkDashClass LinkDashClass;
typedef struct _LinkDashPrivate LinkDashPrivate;

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportYed {
	Export parent_instance;
	ExportYedPrivate * priv;
};

struct _ExportYedClass {
	ExportClass parent_class;
};

struct _NodeBorderIface {
	GTypeInterface parent_iface;
	gchar* (*name) (NodeBorder* self);
	gchar* (*display_name) (NodeBorder* self);
	gchar* (*icon_name) (NodeBorder* self);
	gboolean (*is_fillable) (NodeBorder* self);
	void (*draw_border) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
	void (*draw_fill) (NodeBorder* self, cairo_t* ctx, gdouble x, gdouble y, gdouble w, gdouble h, NodeSide s, gint padding);
};

struct _LinkDash {
	GObject parent_instance;
	LinkDashPrivate * priv;
	gchar* name;
	gchar* display_name;
	gdouble* pattern;
	gint pattern_length1;
};

struct _LinkDashClass {
	GObjectClass parent_class;
};

static gpointer export_yed_parent_class = NULL;
VALA_EXTERN gchar* minder_version;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_yed_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportYed, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportYed* export_yed_new (void);
VALA_EXTERN ExportYed* export_yed_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_yed_real_export (Export* base,
                                 const gchar* fname,
                                 DrawArea* da);
static void export_yed_export_keys (ExportYed* self,
                             xmlNode* root);
static void export_yed_export_graphs (ExportYed* self,
                               xmlNode* root,
                               xmlNs* yns,
                               DrawArea* da);
static xmlNode* export_yed_export_key_attr (ExportYed* self,
                                     const gchar* id,
                                     const gchar* for_item,
                                     const gchar* attr_name,
                                     const gchar* attr_type);
static xmlNode* export_yed_export_key_yfiles (ExportYed* self,
                                       const gchar* id,
                                       const gchar* for_item,
                                       const gchar* yfiles_type);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
static void export_yed_export_node_edge (ExportYed* self,
                                  xmlNode* graph,
                                  xmlNs* yns,
                                  Node* node,
                                  Theme* theme);
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN GType connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connection, g_object_unref)
static void export_yed_export_connections (ExportYed* self,
                                    xmlNode* graph,
                                    xmlNs* yns,
                                    GArray* conns,
                                    Theme* theme);
VALA_EXTERN gpointer connections_ref (gpointer instance);
VALA_EXTERN void connections_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_connections (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_connections (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_connections (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_connections (const GValue* value);
VALA_EXTERN GType connections_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connections, connections_unref)
VALA_EXTERN Connections* draw_area_get_connections (DrawArea* self);
VALA_EXTERN GArray* connections_get_connections (Connections* self);
static xmlNode* export_yed_export_node_shape (ExportYed* self,
                                       Node* node,
                                       Theme* theme,
                                       xmlNs* yns);
VALA_EXTERN gdouble node_get_height (Node* self);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN gint* style_get_node_margin (Style* self);
VALA_EXTERN gdouble node_get_width (Node* self);
VALA_EXTERN gdouble node_get_posx (Node* self);
VALA_EXTERN gdouble node_get_posy (Node* self);
VALA_EXTERN gboolean node_is_root (Node* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN gboolean* style_get_node_fill (Style* self);
VALA_EXTERN GdkRGBA* node_get_link_color (Node* self);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
VALA_EXTERN gchar* utils_color_from_rgba (GdkRGBA* rgba);
VALA_EXTERN gint* style_get_node_borderwidth (Style* self);
VALA_EXTERN PangoFontDescription* style_get_node_font (Style* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gdouble canvas_text_get_height (CanvasText* self);
VALA_EXTERN gboolean node_get_folded (Node* self);
VALA_EXTERN gdouble canvas_text_get_width (CanvasText* self);
VALA_EXTERN gint* style_get_node_padding (Style* self);
VALA_EXTERN gchar* canvas_text_get_wrapped_text (CanvasText* self);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType node_border_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeBorder, g_object_unref)
VALA_EXTERN NodeBorder* style_get_node_border (Style* self);
VALA_EXTERN gchar* node_border_name (NodeBorder* self);
static xmlNode* export_yed_export_node (ExportYed* self,
                                 Node* node,
                                 Theme* theme,
                                 xmlNs* yns);
VALA_EXTERN gint node_id (Node* self);
VALA_EXTERN const gchar* node_get_note (Node* self);
static xmlNode* export_yed_export_node_bezieredge (ExportYed* self,
                                            Node* node,
                                            xmlNs* yns);
VALA_EXTERN gint* style_get_link_width (Style* self);
static xmlNode* export_yed_export_link (ExportYed* self,
                                 Node* node,
                                 xmlNs* yns);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN Node* connection_get_from_node (Connection* self);
VALA_EXTERN Node* connection_get_to_node (Connection* self);
VALA_EXTERN Style* connection_get_style (Connection* self);
VALA_EXTERN GType link_dash_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinkDash, g_object_unref)
VALA_EXTERN LinkDash* style_get_connection_dash (Style* self);
VALA_EXTERN gint* style_get_connection_line_width (Style* self);
VALA_EXTERN const gchar* style_get_connection_arrow (Style* self);
VALA_EXTERN CanvasText* connection_get_title (Connection* self);
VALA_EXTERN PangoFontDescription* style_get_connection_font (Style* self);
VALA_EXTERN gdouble canvas_text_get_posx (CanvasText* self);
VALA_EXTERN gdouble canvas_text_get_posy (CanvasText* self);
static GType export_yed_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportYed*
export_yed_construct (GType object_type)
{
	ExportYed* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".graphml");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportYed*) export_construct (object_type, "yed", _ ("Yed"), _tmp2_, (gint) 1, TRUE, FALSE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportYed*
export_yed_new (void)
{
	return export_yed_construct (TYPE_EXPORT_YED);
}

static gboolean
export_yed_real_export (Export* base,
                        const gchar* fname,
                        DrawArea* da)
{
	ExportYed * self;
	xmlDoc* doc = NULL;
	xmlDoc* _tmp0_;
	xmlNode* root = NULL;
	xmlNode* _tmp1_;
	xmlNs* yns = NULL;
	xmlNs* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	xmlNode* _tmp8_;
	gboolean result;
	self = (ExportYed*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = xmlNewDoc ((xmlChar*) "1.0");
	doc = _tmp0_;
	_tmp1_ = xmlNewNode (NULL, (xmlChar*) "graphml");
	root = _tmp1_;
	xmlNewProp (root, (xmlChar*) "xmlns", (xmlChar*) "http://graphml.graphdrawing.org/xmlns");
	xmlNewNs (root, (xmlChar*) "http://www.yworks.com/xml/yfiles-common/1.0/java", (xmlChar*) "java");
	xmlNewNs (root, (xmlChar*) "http://www.yworks.com/xml/yfiles-common/markup/primitives/2.0", (xmlChar*) "sys");
	xmlNewNs (root, (xmlChar*) "http://www.yworks.com/xml/yfiles-common/markup/2.0", (xmlChar*) "x");
	xmlNewNs (root, (xmlChar*) "http://www.w3.org/2001/XMLSchema-instance", (xmlChar*) "xsi");
	xmlNewNs (root, (xmlChar*) "http://www.yworks.com/xml/yed/3", (xmlChar*) "yed");
	_tmp2_ = xmlNewNs (root, (xmlChar*) "http://www.yworks.com/xml/graphml", (xmlChar*) "y");
	yns = _tmp2_;
	_tmp3_ = g_strconcat (_ ("Generated by Minder"), " ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = minder_version;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = xmlNewComment ((xmlChar*) _tmp7_);
	xmlAddChild (root, _tmp8_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	export_yed_export_keys (self, root);
	export_yed_export_graphs (self, root, yns, da);
	xmlDocSetRootElement (doc, root);
	xmlSaveFormatFile (fname, doc, 1);
	_xmlFreeDoc0 (doc);
	result = TRUE;
	return result;
}

static xmlNode*
export_yed_export_key_attr (ExportYed* self,
                            const gchar* id,
                            const gchar* for_item,
                            const gchar* attr_name,
                            const gchar* attr_type)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (for_item != NULL, NULL);
	g_return_val_if_fail (attr_name != NULL, NULL);
	g_return_val_if_fail (attr_type != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "key");
	n = _tmp0_;
	xmlNewProp (n, (xmlChar*) "id", (xmlChar*) id);
	xmlNewProp (n, (xmlChar*) "for", (xmlChar*) for_item);
	xmlNewProp (n, (xmlChar*) "attr.name", (xmlChar*) attr_name);
	xmlNewProp (n, (xmlChar*) "attr.type", (xmlChar*) attr_type);
	result = n;
	return result;
}

static xmlNode*
export_yed_export_key_yfiles (ExportYed* self,
                              const gchar* id,
                              const gchar* for_item,
                              const gchar* yfiles_type)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (for_item != NULL, NULL);
	g_return_val_if_fail (yfiles_type != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "key");
	n = _tmp0_;
	xmlNewProp (n, (xmlChar*) "id", (xmlChar*) id);
	xmlNewProp (n, (xmlChar*) "for", (xmlChar*) for_item);
	xmlNewProp (n, (xmlChar*) "yfiles.type", (xmlChar*) yfiles_type);
	result = n;
	return result;
}

static void
export_yed_export_keys (ExportYed* self,
                        xmlNode* root)
{
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	xmlNode* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = export_yed_export_key_attr (self, "d5", "node", "description", "string");
	xmlAddChild (root, _tmp0_);
	_tmp1_ = export_yed_export_key_yfiles (self, "d6", "node", "nodegraphics");
	xmlAddChild (root, _tmp1_);
	_tmp2_ = export_yed_export_key_yfiles (self, "d7", "graphml", "resources");
	xmlAddChild (root, _tmp2_);
	_tmp3_ = export_yed_export_key_attr (self, "d9", "edge", "description", "string");
	xmlAddChild (root, _tmp3_);
	_tmp4_ = export_yed_export_key_yfiles (self, "d10", "edge", "edgegraphics");
	xmlAddChild (root, _tmp4_);
}

static void
export_yed_export_graphs (ExportYed* self,
                          xmlNode* root,
                          xmlNs* yns,
                          DrawArea* da)
{
	xmlNode* graph = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	xmlNode* _tmp15_;
	Connections* _tmp16_;
	Connections* _tmp17_;
	GArray* _tmp18_;
	GArray* _tmp19_;
	Theme* _tmp20_;
	Theme* _tmp21_;
	xmlNode* d7 = NULL;
	xmlNode* _tmp22_;
	xmlNode* res = NULL;
	xmlNode* _tmp23_;
	xmlNode* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "graph");
	graph = _tmp0_;
	_tmp1_ = graph;
	xmlNewProp (_tmp1_, (xmlChar*) "edgedefault", (xmlChar*) "directed");
	_tmp2_ = graph;
	xmlNewProp (_tmp2_, (xmlChar*) "id", (xmlChar*) "G0");
	_tmp3_ = graph;
	xmlAddChild (root, _tmp3_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GArray* _tmp6_;
				GArray* _tmp7_;
				gboolean _tmp8_;
				xmlNode* _tmp9_;
				GArray* _tmp10_;
				GArray* _tmp11_;
				Node* _tmp12_;
				Theme* _tmp13_;
				Theme* _tmp14_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = draw_area_get_nodes (da);
				_tmp7_ = _tmp6_;
				_tmp8_ = !(((guint) i) < _tmp7_->len);
				_g_array_unref0 (_tmp7_);
				if (_tmp8_) {
					break;
				}
				_tmp9_ = graph;
				_tmp10_ = draw_area_get_nodes (da);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_array_index (_tmp11_, Node*, (guint) i);
				_tmp13_ = draw_area_get_theme (da);
				_tmp14_ = _tmp13_;
				export_yed_export_node_edge (self, _tmp9_, yns, _tmp12_, _tmp14_);
				_g_object_unref0 (_tmp14_);
				_g_array_unref0 (_tmp11_);
			}
		}
	}
	_tmp15_ = graph;
	_tmp16_ = draw_area_get_connections (da);
	_tmp17_ = _tmp16_;
	_tmp18_ = connections_get_connections (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = draw_area_get_theme (da);
	_tmp21_ = _tmp20_;
	export_yed_export_connections (self, _tmp15_, yns, _tmp19_, _tmp21_);
	_g_object_unref0 (_tmp21_);
	_connections_unref0 (_tmp17_);
	_tmp22_ = xmlNewNode (NULL, (xmlChar*) "data");
	d7 = _tmp22_;
	xmlNewProp (d7, (xmlChar*) "key", (xmlChar*) "d7");
	_tmp23_ = xmlNewNode (yns, (xmlChar*) "Resources");
	res = _tmp23_;
	xmlAddChild (d7, res);
	_tmp24_ = graph;
	xmlAddChild (_tmp24_, d7);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static xmlNode*
export_yed_export_node_shape (ExportYed* self,
                              Node* node,
                              Theme* theme,
                              xmlNs* yns)
{
	xmlNode* shape = NULL;
	xmlNode* _tmp0_;
	xmlNode* geometry = NULL;
	xmlNode* _tmp1_;
	xmlNode* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	Style* _tmp5_;
	Style* _tmp6_;
	gint* _tmp7_;
	gint* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	xmlNode* _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	Style* _tmp14_;
	Style* _tmp15_;
	gint* _tmp16_;
	gint* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	xmlNode* _tmp20_;
	gdouble _tmp21_;
	gdouble _tmp22_;
	Style* _tmp23_;
	Style* _tmp24_;
	gint* _tmp25_;
	gint* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	xmlNode* _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	Style* _tmp32_;
	Style* _tmp33_;
	gint* _tmp34_;
	gint* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	xmlNode* _tmp38_;
	xmlNode* _tmp39_;
	xmlNode* fill = NULL;
	xmlNode* _tmp40_;
	GdkRGBA* _tmp41_ = NULL;
	xmlNode* _tmp53_;
	GdkRGBA _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	xmlNode* _tmp57_;
	xmlNode* _tmp58_;
	xmlNode* _tmp59_;
	xmlNode* bs = NULL;
	xmlNode* _tmp60_;
	GdkRGBA* _tmp61_;
	GdkRGBA* _tmp62_;
	xmlNode* _tmp69_;
	xmlNode* _tmp70_;
	Style* _tmp71_;
	Style* _tmp72_;
	gint* _tmp73_;
	gint* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	xmlNode* _tmp77_;
	xmlNode* _tmp78_;
	xmlNode* lbl = NULL;
	xmlNode* _tmp79_;
	xmlNode* _tmp80_;
	xmlNode* _tmp81_;
	xmlNode* _tmp82_;
	Style* _tmp83_;
	Style* _tmp84_;
	PangoFontDescription* _tmp85_;
	PangoFontDescription* _tmp86_;
	const gchar* _tmp87_;
	xmlNode* _tmp88_;
	Style* _tmp89_;
	Style* _tmp90_;
	PangoFontDescription* _tmp91_;
	PangoFontDescription* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	xmlNode* _tmp95_;
	xmlNode* _tmp96_;
	xmlNode* _tmp97_;
	xmlNode* _tmp98_;
	CanvasText* _tmp99_;
	CanvasText* _tmp100_;
	gdouble _tmp101_;
	gdouble _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	xmlNode* _tmp105_;
	xmlNode* _tmp106_;
	xmlNode* _tmp107_;
	GdkRGBA* _tmp108_ = NULL;
	xmlNode* _tmp118_;
	GdkRGBA _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	xmlNode* _tmp122_;
	const gchar* _tmp123_ = NULL;
	gboolean _tmp124_;
	gboolean _tmp125_;
	xmlNode* _tmp126_;
	xmlNode* _tmp127_;
	CanvasText* _tmp128_;
	CanvasText* _tmp129_;
	gdouble _tmp130_;
	gdouble _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	xmlNode* _tmp134_;
	Style* _tmp135_;
	Style* _tmp136_;
	gint* _tmp137_;
	gint* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	xmlNode* _tmp141_;
	xmlNode* _tmp142_;
	Style* _tmp143_;
	Style* _tmp144_;
	gint* _tmp145_;
	gint* _tmp146_;
	gchar* _tmp147_;
	gchar* _tmp148_;
	xmlNode* _tmp149_;
	CanvasText* _tmp150_;
	CanvasText* _tmp151_;
	gchar* _tmp152_;
	gchar* _tmp153_;
	xmlNode* _tmp154_;
	xmlNode* _tmp155_;
	xmlNode* model = NULL;
	xmlNode* _tmp156_;
	xmlNode* smodel = NULL;
	xmlNode* _tmp157_;
	xmlNode* _tmp158_;
	xmlNode* _tmp159_;
	xmlNode* _tmp160_;
	xmlNode* _tmp161_;
	xmlNode* _tmp162_;
	xmlNode* param = NULL;
	xmlNode* _tmp163_;
	xmlNode* sparam = NULL;
	xmlNode* _tmp164_;
	xmlNode* _tmp165_;
	xmlNode* _tmp166_;
	xmlNode* _tmp167_;
	xmlNode* _tmp168_;
	xmlNode* _tmp169_;
	xmlNode* _tmp170_;
	xmlNode* _tmp171_;
	xmlNode* _tmp172_;
	xmlNode* _tmp173_;
	xmlNode* _tmp174_;
	xmlNode* _tmp175_;
	xmlNode* _tmp176_;
	xmlNode* s = NULL;
	xmlNode* _tmp177_;
	Style* _tmp178_;
	Style* _tmp179_;
	NodeBorder* _tmp180_;
	NodeBorder* _tmp181_;
	gchar* _tmp182_;
	gchar* _tmp183_;
	GQuark _tmp185_ = 0U;
	static GQuark _tmp184_label0 = 0;
	static GQuark _tmp184_label1 = 0;
	xmlNode* _tmp189_;
	xmlNode* _tmp190_;
	xmlNode* _tmp191_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (theme != NULL, NULL);
	_tmp0_ = xmlNewNode (yns, (xmlChar*) "ShapeNode");
	shape = _tmp0_;
	_tmp1_ = xmlNewNode (yns, (xmlChar*) "Geometry");
	geometry = _tmp1_;
	_tmp2_ = geometry;
	_tmp3_ = node_get_height (node);
	_tmp4_ = _tmp3_;
	_tmp5_ = node_get_style (node);
	_tmp6_ = _tmp5_;
	_tmp7_ = style_get_node_margin (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = double_to_string (_tmp4_ - ((*_tmp8_) * 2));
	_tmp10_ = _tmp9_;
	xmlNewProp (_tmp2_, (xmlChar*) "height", (xmlChar*) _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = geometry;
	_tmp12_ = node_get_width (node);
	_tmp13_ = _tmp12_;
	_tmp14_ = node_get_style (node);
	_tmp15_ = _tmp14_;
	_tmp16_ = style_get_node_margin (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = double_to_string (_tmp13_ - ((*_tmp17_) * 2));
	_tmp19_ = _tmp18_;
	xmlNewProp (_tmp11_, (xmlChar*) "width", (xmlChar*) _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = geometry;
	_tmp21_ = node_get_posx (node);
	_tmp22_ = _tmp21_;
	_tmp23_ = node_get_style (node);
	_tmp24_ = _tmp23_;
	_tmp25_ = style_get_node_margin (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = double_to_string (_tmp22_ + (*_tmp26_));
	_tmp28_ = _tmp27_;
	xmlNewProp (_tmp20_, (xmlChar*) "x", (xmlChar*) _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = geometry;
	_tmp30_ = node_get_posy (node);
	_tmp31_ = _tmp30_;
	_tmp32_ = node_get_style (node);
	_tmp33_ = _tmp32_;
	_tmp34_ = style_get_node_margin (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = double_to_string (_tmp31_ + (*_tmp35_));
	_tmp37_ = _tmp36_;
	xmlNewProp (_tmp29_, (xmlChar*) "y", (xmlChar*) _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = shape;
	_tmp39_ = geometry;
	xmlAddChild (_tmp38_, _tmp39_);
	_tmp40_ = xmlNewNode (yns, (xmlChar*) "Fill");
	fill = _tmp40_;
	if (node_is_root (node)) {
		GdkRGBA* _tmp42_;
		_tmp42_ = theme_get_color (theme, "root_background");
		__vala_GdkRGBA_free0 (_tmp41_);
		_tmp41_ = _tmp42_;
	} else {
		GdkRGBA* _tmp43_ = NULL;
		Style* _tmp44_;
		Style* _tmp45_;
		gboolean* _tmp46_;
		gboolean* _tmp47_;
		GdkRGBA* _tmp52_;
		_tmp44_ = node_get_style (node);
		_tmp45_ = _tmp44_;
		_tmp46_ = style_get_node_fill (_tmp45_);
		_tmp47_ = _tmp46_;
		if (*_tmp47_) {
			GdkRGBA* _tmp48_;
			GdkRGBA* _tmp49_;
			GdkRGBA* _tmp50_;
			_tmp48_ = node_get_link_color (node);
			_tmp49_ = _tmp48_;
			_tmp50_ = __vala_GdkRGBA_copy0 (_tmp49_);
			__vala_GdkRGBA_free0 (_tmp43_);
			_tmp43_ = _tmp50_;
		} else {
			GdkRGBA* _tmp51_;
			_tmp51_ = theme_get_color (theme, "background");
			__vala_GdkRGBA_free0 (_tmp43_);
			_tmp43_ = _tmp51_;
		}
		_tmp52_ = __vala_GdkRGBA_copy0 (_tmp43_);
		__vala_GdkRGBA_free0 (_tmp41_);
		_tmp41_ = _tmp52_;
		__vala_GdkRGBA_free0 (_tmp43_);
	}
	_tmp53_ = fill;
	_tmp54_ = *_tmp41_;
	_tmp55_ = utils_color_from_rgba (&_tmp54_);
	_tmp56_ = _tmp55_;
	xmlNewProp (_tmp53_, (xmlChar*) "color", (xmlChar*) _tmp56_);
	_g_free0 (_tmp56_);
	_tmp57_ = fill;
	xmlNewProp (_tmp57_, (xmlChar*) "transparent", (xmlChar*) "false");
	_tmp58_ = shape;
	_tmp59_ = fill;
	xmlAddChild (_tmp58_, _tmp59_);
	_tmp60_ = xmlNewNode (yns, (xmlChar*) "BorderStyle");
	bs = _tmp60_;
	_tmp61_ = node_get_link_color (node);
	_tmp62_ = _tmp61_;
	if (_tmp62_ != NULL) {
		xmlNode* _tmp63_;
		GdkRGBA* _tmp64_;
		GdkRGBA* _tmp65_;
		GdkRGBA _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		_tmp63_ = bs;
		_tmp64_ = node_get_link_color (node);
		_tmp65_ = _tmp64_;
		_tmp66_ = *_tmp65_;
		_tmp67_ = utils_color_from_rgba (&_tmp66_);
		_tmp68_ = _tmp67_;
		xmlNewProp (_tmp63_, (xmlChar*) "color", (xmlChar*) _tmp68_);
		_g_free0 (_tmp68_);
	}
	_tmp69_ = bs;
	xmlNewProp (_tmp69_, (xmlChar*) "type", (xmlChar*) "line");
	_tmp70_ = bs;
	_tmp71_ = node_get_style (node);
	_tmp72_ = _tmp71_;
	_tmp73_ = style_get_node_borderwidth (_tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_strdup_printf ("%i", *_tmp74_);
	_tmp76_ = _tmp75_;
	xmlNewProp (_tmp70_, (xmlChar*) "width", (xmlChar*) _tmp76_);
	_g_free0 (_tmp76_);
	_tmp77_ = shape;
	_tmp78_ = bs;
	xmlAddChild (_tmp77_, _tmp78_);
	_tmp79_ = xmlNewNode (yns, (xmlChar*) "NodeLabel");
	lbl = _tmp79_;
	_tmp80_ = lbl;
	xmlNewProp (_tmp80_, (xmlChar*) "alignment", (xmlChar*) "left");
	_tmp81_ = lbl;
	xmlNewProp (_tmp81_, (xmlChar*) "autoSizePolicy", (xmlChar*) "content");
	_tmp82_ = lbl;
	_tmp83_ = node_get_style (node);
	_tmp84_ = _tmp83_;
	_tmp85_ = style_get_node_font (_tmp84_);
	_tmp86_ = _tmp85_;
	_tmp87_ = pango_font_description_get_family (_tmp86_);
	xmlNewProp (_tmp82_, (xmlChar*) "fontFamily", (xmlChar*) _tmp87_);
	_tmp88_ = lbl;
	_tmp89_ = node_get_style (node);
	_tmp90_ = _tmp89_;
	_tmp91_ = style_get_node_font (_tmp90_);
	_tmp92_ = _tmp91_;
	_tmp93_ = g_strdup_printf ("%i", pango_font_description_get_size (_tmp92_) / PANGO_SCALE);
	_tmp94_ = _tmp93_;
	xmlNewProp (_tmp88_, (xmlChar*) "fontSize", (xmlChar*) _tmp94_);
	_g_free0 (_tmp94_);
	_tmp95_ = lbl;
	xmlNewProp (_tmp95_, (xmlChar*) "fontStyle", (xmlChar*) "plain");
	_tmp96_ = lbl;
	xmlNewProp (_tmp96_, (xmlChar*) "hasBackgroundColor", (xmlChar*) "false");
	_tmp97_ = lbl;
	xmlNewProp (_tmp97_, (xmlChar*) "hasLineColor", (xmlChar*) "false");
	_tmp98_ = lbl;
	_tmp99_ = node_get_name (node);
	_tmp100_ = _tmp99_;
	_tmp101_ = canvas_text_get_height (_tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = double_to_string (_tmp102_);
	_tmp104_ = _tmp103_;
	xmlNewProp (_tmp98_, (xmlChar*) "height", (xmlChar*) _tmp104_);
	_g_free0 (_tmp104_);
	_tmp105_ = lbl;
	xmlNewProp (_tmp105_, (xmlChar*) "horizontalTextPosition", (xmlChar*) "left");
	_tmp106_ = lbl;
	xmlNewProp (_tmp106_, (xmlChar*) "iconTextGap", (xmlChar*) "4");
	_tmp107_ = lbl;
	xmlNewProp (_tmp107_, (xmlChar*) "modelName", (xmlChar*) "custom");
	if (node_is_root (node)) {
		GdkRGBA* _tmp109_;
		_tmp109_ = theme_get_color (theme, "root_foreground");
		__vala_GdkRGBA_free0 (_tmp108_);
		_tmp108_ = _tmp109_;
	} else {
		GdkRGBA* _tmp110_ = NULL;
		Style* _tmp111_;
		Style* _tmp112_;
		gboolean* _tmp113_;
		gboolean* _tmp114_;
		GdkRGBA* _tmp117_;
		_tmp111_ = node_get_style (node);
		_tmp112_ = _tmp111_;
		_tmp113_ = style_get_node_fill (_tmp112_);
		_tmp114_ = _tmp113_;
		if (*_tmp114_) {
			GdkRGBA* _tmp115_;
			_tmp115_ = theme_get_color (theme, "background");
			__vala_GdkRGBA_free0 (_tmp110_);
			_tmp110_ = _tmp115_;
		} else {
			GdkRGBA* _tmp116_;
			_tmp116_ = theme_get_color (theme, "foreground");
			__vala_GdkRGBA_free0 (_tmp110_);
			_tmp110_ = _tmp116_;
		}
		_tmp117_ = __vala_GdkRGBA_copy0 (_tmp110_);
		__vala_GdkRGBA_free0 (_tmp108_);
		_tmp108_ = _tmp117_;
		__vala_GdkRGBA_free0 (_tmp110_);
	}
	_tmp118_ = lbl;
	_tmp119_ = *_tmp108_;
	_tmp120_ = utils_color_from_rgba (&_tmp119_);
	_tmp121_ = _tmp120_;
	xmlNewProp (_tmp118_, (xmlChar*) "textColor", (xmlChar*) _tmp121_);
	_g_free0 (_tmp121_);
	_tmp122_ = lbl;
	xmlNewProp (_tmp122_, (xmlChar*) "verticalTextPosition", (xmlChar*) "top");
	_tmp124_ = node_get_folded (node);
	_tmp125_ = _tmp124_;
	if (_tmp125_) {
		_tmp123_ = "false";
	} else {
		_tmp123_ = "true";
	}
	_tmp126_ = lbl;
	xmlNewProp (_tmp126_, (xmlChar*) "visible", (xmlChar*) _tmp123_);
	_tmp127_ = lbl;
	_tmp128_ = node_get_name (node);
	_tmp129_ = _tmp128_;
	_tmp130_ = canvas_text_get_width (_tmp129_);
	_tmp131_ = _tmp130_;
	_tmp132_ = double_to_string (_tmp131_);
	_tmp133_ = _tmp132_;
	xmlNewProp (_tmp127_, (xmlChar*) "width", (xmlChar*) _tmp133_);
	_g_free0 (_tmp133_);
	_tmp134_ = lbl;
	_tmp135_ = node_get_style (node);
	_tmp136_ = _tmp135_;
	_tmp137_ = style_get_node_padding (_tmp136_);
	_tmp138_ = _tmp137_;
	_tmp139_ = g_strdup_printf ("%i", *_tmp138_);
	_tmp140_ = _tmp139_;
	xmlNewProp (_tmp134_, (xmlChar*) "x", (xmlChar*) _tmp140_);
	_g_free0 (_tmp140_);
	_tmp141_ = lbl;
	xmlNewProp (_tmp141_, (xmlChar*) "xml:space", (xmlChar*) "preserve");
	_tmp142_ = lbl;
	_tmp143_ = node_get_style (node);
	_tmp144_ = _tmp143_;
	_tmp145_ = style_get_node_padding (_tmp144_);
	_tmp146_ = _tmp145_;
	_tmp147_ = g_strdup_printf ("%i", *_tmp146_);
	_tmp148_ = _tmp147_;
	xmlNewProp (_tmp142_, (xmlChar*) "y", (xmlChar*) _tmp148_);
	_g_free0 (_tmp148_);
	_tmp149_ = lbl;
	_tmp150_ = node_get_name (node);
	_tmp151_ = _tmp150_;
	_tmp152_ = canvas_text_get_wrapped_text (_tmp151_);
	_tmp153_ = _tmp152_;
	xmlNodeAddContent (_tmp149_, (xmlChar*) _tmp153_);
	_g_free0 (_tmp153_);
	_tmp154_ = shape;
	_tmp155_ = lbl;
	xmlAddChild (_tmp154_, _tmp155_);
	_tmp156_ = xmlNewNode (yns, (xmlChar*) "LabelModel");
	model = _tmp156_;
	_tmp157_ = xmlNewNode (yns, (xmlChar*) "SmartNodeLabelModel");
	smodel = _tmp157_;
	_tmp158_ = smodel;
	xmlNewProp (_tmp158_, (xmlChar*) "distance", (xmlChar*) "4.0");
	_tmp159_ = model;
	_tmp160_ = smodel;
	xmlAddChild (_tmp159_, _tmp160_);
	_tmp161_ = lbl;
	_tmp162_ = model;
	xmlAddChild (_tmp161_, _tmp162_);
	_tmp163_ = xmlNewNode (yns, (xmlChar*) "ModelParameter");
	param = _tmp163_;
	_tmp164_ = xmlNewNode (yns, (xmlChar*) "SmartNodeLabelModelParameter");
	sparam = _tmp164_;
	_tmp165_ = sparam;
	xmlNewProp (_tmp165_, (xmlChar*) "labelRatioX", (xmlChar*) "0.0");
	_tmp166_ = sparam;
	xmlNewProp (_tmp166_, (xmlChar*) "labelRatioY", (xmlChar*) "0.0");
	_tmp167_ = sparam;
	xmlNewProp (_tmp167_, (xmlChar*) "nodeRatioX", (xmlChar*) "0.0");
	_tmp168_ = sparam;
	xmlNewProp (_tmp168_, (xmlChar*) "nodeRatioY", (xmlChar*) "0.0");
	_tmp169_ = sparam;
	xmlNewProp (_tmp169_, (xmlChar*) "offsetX", (xmlChar*) "0.0");
	_tmp170_ = sparam;
	xmlNewProp (_tmp170_, (xmlChar*) "offsetY", (xmlChar*) "0.0");
	_tmp171_ = sparam;
	xmlNewProp (_tmp171_, (xmlChar*) "upX", (xmlChar*) "0.0");
	_tmp172_ = sparam;
	xmlNewProp (_tmp172_, (xmlChar*) "upY", (xmlChar*) "-1.0");
	_tmp173_ = param;
	_tmp174_ = sparam;
	xmlAddChild (_tmp173_, _tmp174_);
	_tmp175_ = lbl;
	_tmp176_ = param;
	xmlAddChild (_tmp175_, _tmp176_);
	_tmp177_ = xmlNewNode (yns, (xmlChar*) "Shape");
	s = _tmp177_;
	_tmp178_ = node_get_style (node);
	_tmp179_ = _tmp178_;
	_tmp180_ = style_get_node_border (_tmp179_);
	_tmp181_ = _tmp180_;
	_tmp182_ = node_border_name (_tmp181_);
	_tmp183_ = _tmp182_;
	_tmp185_ = (NULL == _tmp183_) ? 0 : g_quark_from_string (_tmp183_);
	g_free (_tmp183_);
	if (_tmp185_ == ((0 != _tmp184_label0) ? _tmp184_label0 : (_tmp184_label0 = g_quark_from_static_string ("rounded")))) {
		switch (0) {
			default:
			{
				xmlNode* _tmp186_;
				_tmp186_ = s;
				xmlNewProp (_tmp186_, (xmlChar*) "type", (xmlChar*) "roundrectangle");
				break;
			}
		}
	} else if (_tmp185_ == ((0 != _tmp184_label1) ? _tmp184_label1 : (_tmp184_label1 = g_quark_from_static_string ("squared")))) {
		switch (0) {
			default:
			{
				xmlNode* _tmp187_;
				_tmp187_ = s;
				xmlNewProp (_tmp187_, (xmlChar*) "type", (xmlChar*) "rectangle");
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				xmlNode* _tmp188_;
				_tmp188_ = s;
				xmlNewProp (_tmp188_, (xmlChar*) "type", (xmlChar*) "rectangle");
				break;
			}
		}
	}
	_tmp189_ = shape;
	_tmp190_ = s;
	xmlAddChild (_tmp189_, _tmp190_);
	_tmp191_ = shape;
	result = _tmp191_;
	__vala_GdkRGBA_free0 (_tmp108_);
	__vala_GdkRGBA_free0 (_tmp41_);
	return result;
}

static xmlNode*
export_yed_export_node (ExportYed* self,
                        Node* node,
                        Theme* theme,
                        xmlNs* yns)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* d5 = NULL;
	xmlNode* _tmp1_;
	xmlNode* d6 = NULL;
	xmlNode* _tmp2_;
	xmlNode* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	xmlNode* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	xmlNode* _tmp15_;
	xmlNode* _tmp16_;
	xmlNode* _tmp17_;
	xmlNode* _tmp18_;
	xmlNode* _tmp19_;
	xmlNode* _tmp20_;
	xmlNode* _tmp21_;
	xmlNode* _tmp22_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (theme != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "node");
	n = _tmp0_;
	_tmp1_ = xmlNewNode (NULL, (xmlChar*) "data");
	d5 = _tmp1_;
	_tmp2_ = xmlNewNode (NULL, (xmlChar*) "data");
	d6 = _tmp2_;
	_tmp3_ = n;
	_tmp4_ = g_strdup_printf ("%i", node_id (node));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("n", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	xmlNewProp (_tmp3_, (xmlChar*) "id", (xmlChar*) _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = d5;
	xmlNewProp (_tmp8_, (xmlChar*) "key", (xmlChar*) "d5");
	_tmp9_ = node_get_note (node);
	_tmp10_ = _tmp9_;
	if (g_strcmp0 (_tmp10_, "") != 0) {
		xmlNode* _tmp11_;
		xmlNode* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = d5;
		xmlNewProp (_tmp11_, (xmlChar*) "xml:space", (xmlChar*) "preserve");
		_tmp12_ = d5;
		_tmp13_ = node_get_note (node);
		_tmp14_ = _tmp13_;
		xmlNodeAddContent (_tmp12_, (xmlChar*) _tmp14_);
	}
	_tmp15_ = n;
	_tmp16_ = d5;
	xmlAddChild (_tmp15_, _tmp16_);
	_tmp17_ = d6;
	xmlNewProp (_tmp17_, (xmlChar*) "key", (xmlChar*) "d6");
	_tmp18_ = d6;
	_tmp19_ = export_yed_export_node_shape (self, node, theme, yns);
	xmlAddChild (_tmp18_, _tmp19_);
	_tmp20_ = n;
	_tmp21_ = d6;
	xmlAddChild (_tmp20_, _tmp21_);
	_tmp22_ = n;
	result = _tmp22_;
	return result;
}

static xmlNode*
export_yed_export_node_bezieredge (ExportYed* self,
                                   Node* node,
                                   xmlNs* yns)
{
	xmlNode* be = NULL;
	xmlNode* _tmp0_;
	xmlNode* path = NULL;
	xmlNode* _tmp1_;
	xmlNode* ls = NULL;
	xmlNode* _tmp2_;
	GdkRGBA* _tmp3_;
	GdkRGBA* _tmp4_;
	GdkRGBA _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	Style* _tmp8_;
	Style* _tmp9_;
	gint* _tmp10_;
	gint* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	xmlNode* arrow = NULL;
	xmlNode* _tmp14_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = xmlNewNode (yns, (xmlChar*) "BezierEdge");
	be = _tmp0_;
	_tmp1_ = xmlNewNode (yns, (xmlChar*) "Path");
	path = _tmp1_;
	xmlNewProp (path, (xmlChar*) "sx", (xmlChar*) "0.0");
	xmlNewProp (path, (xmlChar*) "sy", (xmlChar*) "0.0");
	xmlNewProp (path, (xmlChar*) "tx", (xmlChar*) "0.0");
	xmlNewProp (path, (xmlChar*) "ty", (xmlChar*) "0.0");
	xmlAddChild (be, path);
	_tmp2_ = xmlNewNode (yns, (xmlChar*) "LineStyle");
	ls = _tmp2_;
	_tmp3_ = node_get_link_color (node);
	_tmp4_ = _tmp3_;
	_tmp5_ = *_tmp4_;
	_tmp6_ = utils_color_from_rgba (&_tmp5_);
	_tmp7_ = _tmp6_;
	xmlNewProp (ls, (xmlChar*) "color", (xmlChar*) _tmp7_);
	_g_free0 (_tmp7_);
	xmlNewProp (ls, (xmlChar*) "type", (xmlChar*) "line");
	_tmp8_ = node_get_style (node);
	_tmp9_ = _tmp8_;
	_tmp10_ = style_get_link_width (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%i", *_tmp11_);
	_tmp13_ = _tmp12_;
	xmlNewProp (ls, (xmlChar*) "width", (xmlChar*) _tmp13_);
	_g_free0 (_tmp13_);
	xmlAddChild (be, ls);
	_tmp14_ = xmlNewNode (yns, (xmlChar*) "Arrows");
	arrow = _tmp14_;
	xmlNewProp (arrow, (xmlChar*) "source", (xmlChar*) "none");
	xmlNewProp (arrow, (xmlChar*) "target", (xmlChar*) "none");
	xmlAddChild (be, arrow);
	result = be;
	return result;
}

static xmlNode*
export_yed_export_link (ExportYed* self,
                        Node* node,
                        xmlNs* yns)
{
	xmlNode* e = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	xmlNode* _tmp6_;
	Node* _tmp7_;
	Node* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	xmlNode* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	xmlNode* d9 = NULL;
	xmlNode* _tmp18_;
	xmlNode* _tmp19_;
	xmlNode* _tmp20_;
	xmlNode* _tmp21_;
	xmlNode* d10 = NULL;
	xmlNode* _tmp22_;
	xmlNode* _tmp23_;
	xmlNode* _tmp24_;
	xmlNode* _tmp25_;
	xmlNode* _tmp26_;
	xmlNode* _tmp27_;
	xmlNode* _tmp28_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (node_is_root (node)) {
		result = NULL;
		return result;
	}
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "edge");
	e = _tmp0_;
	_tmp1_ = e;
	_tmp2_ = g_strdup_printf ("%i", node_id (node));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("e", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	xmlNewProp (_tmp1_, (xmlChar*) "id", (xmlChar*) _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = e;
	_tmp7_ = node_get_parent (node);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%i", node_id (_tmp8_));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("n", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	xmlNewProp (_tmp6_, (xmlChar*) "source", (xmlChar*) _tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = e;
	_tmp14_ = g_strdup_printf ("%i", node_id (node));
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat ("n", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	xmlNewProp (_tmp13_, (xmlChar*) "target", (xmlChar*) _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_tmp18_ = xmlNewNode (NULL, (xmlChar*) "data");
	d9 = _tmp18_;
	_tmp19_ = d9;
	xmlNewProp (_tmp19_, (xmlChar*) "key", (xmlChar*) "d9");
	_tmp20_ = e;
	_tmp21_ = d9;
	xmlAddChild (_tmp20_, _tmp21_);
	_tmp22_ = xmlNewNode (NULL, (xmlChar*) "data");
	d10 = _tmp22_;
	_tmp23_ = d10;
	xmlNewProp (_tmp23_, (xmlChar*) "key", (xmlChar*) "d10");
	_tmp24_ = d10;
	_tmp25_ = export_yed_export_node_bezieredge (self, node, yns);
	xmlAddChild (_tmp24_, _tmp25_);
	_tmp26_ = e;
	_tmp27_ = d10;
	xmlAddChild (_tmp26_, _tmp27_);
	_tmp28_ = e;
	result = _tmp28_;
	return result;
}

static void
export_yed_export_node_edge (ExportYed* self,
                             xmlNode* graph,
                             xmlNs* yns,
                             Node* node,
                             Theme* theme)
{
	xmlNode* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = export_yed_export_node (self, node, theme, yns);
	xmlAddChild (graph, _tmp0_);
	if (!node_is_root (node)) {
		xmlNode* _tmp1_;
		_tmp1_ = export_yed_export_link (self, node, yns);
		xmlAddChild (graph, _tmp1_);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				GArray* _tmp5_;
				gboolean _tmp6_;
				GArray* _tmp7_;
				GArray* _tmp8_;
				Node* _tmp9_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = node_children (node);
				_tmp5_ = _tmp4_;
				_tmp6_ = !(((guint) i) < _tmp5_->len);
				_g_array_unref0 (_tmp5_);
				if (_tmp6_) {
					break;
				}
				_tmp7_ = node_children (node);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_array_index (_tmp8_, Node*, (guint) i);
				export_yed_export_node_edge (self, graph, yns, _tmp9_, theme);
				_g_array_unref0 (_tmp8_);
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
export_yed_export_connections (ExportYed* self,
                               xmlNode* graph,
                               xmlNs* yns,
                               GArray* conns,
                               Theme* theme)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (conns != NULL);
	g_return_if_fail (theme != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Connection* conn = NULL;
				Connection* _tmp2_;
				Connection* _tmp3_;
				xmlNode* e = NULL;
				xmlNode* _tmp4_;
				xmlNode* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				xmlNode* _tmp10_;
				Connection* _tmp11_;
				Node* _tmp12_;
				Node* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				xmlNode* _tmp18_;
				Connection* _tmp19_;
				Node* _tmp20_;
				Node* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				xmlNode* d9 = NULL;
				xmlNode* _tmp26_;
				xmlNode* _tmp27_;
				xmlNode* _tmp28_;
				xmlNode* _tmp29_;
				xmlNode* d10 = NULL;
				xmlNode* _tmp30_;
				xmlNode* _tmp31_;
				xmlNode* be = NULL;
				xmlNode* _tmp32_;
				xmlNode* path = NULL;
				xmlNode* _tmp33_;
				xmlNode* _tmp34_;
				xmlNode* _tmp35_;
				xmlNode* _tmp36_;
				xmlNode* _tmp37_;
				xmlNode* _tmp38_;
				xmlNode* _tmp39_;
				xmlNode* ls = NULL;
				xmlNode* _tmp40_;
				xmlNode* _tmp41_;
				GdkRGBA* _tmp42_;
				GdkRGBA* _tmp43_;
				GdkRGBA _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				const gchar* _tmp47_ = NULL;
				Connection* _tmp48_;
				Style* _tmp49_;
				Style* _tmp50_;
				LinkDash* _tmp51_;
				LinkDash* _tmp52_;
				const gchar* _tmp53_;
				xmlNode* _tmp54_;
				xmlNode* _tmp55_;
				Connection* _tmp56_;
				Style* _tmp57_;
				Style* _tmp58_;
				gint* _tmp59_;
				gint* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				xmlNode* _tmp63_;
				xmlNode* _tmp64_;
				xmlNode* arrow = NULL;
				xmlNode* _tmp65_;
				gchar* atype = NULL;
				Connection* _tmp66_;
				Style* _tmp67_;
				Style* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				gchar* _tmp71_;
				const gchar* _tmp72_ = NULL;
				gboolean _tmp73_ = FALSE;
				const gchar* _tmp74_;
				xmlNode* _tmp76_;
				const gchar* _tmp77_ = NULL;
				gboolean _tmp78_ = FALSE;
				const gchar* _tmp79_;
				xmlNode* _tmp81_;
				xmlNode* _tmp82_;
				xmlNode* _tmp83_;
				Connection* _tmp84_;
				CanvasText* _tmp85_;
				CanvasText* _tmp86_;
				xmlNode* _tmp192_;
				xmlNode* _tmp193_;
				xmlNode* _tmp194_;
				xmlNode* _tmp195_;
				xmlNode* _tmp196_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < conns->len)) {
					break;
				}
				_tmp2_ = g_array_index (conns, Connection*, (guint) i);
				_tmp3_ = _g_object_ref0 (_tmp2_);
				conn = _tmp3_;
				_tmp4_ = xmlNewNode (NULL, (xmlChar*) "edge");
				e = _tmp4_;
				_tmp5_ = e;
				_tmp6_ = g_strdup_printf ("%i", i);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strconcat ("c", _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				xmlNewProp (_tmp5_, (xmlChar*) "id", (xmlChar*) _tmp9_);
				_g_free0 (_tmp9_);
				_g_free0 (_tmp7_);
				_tmp10_ = e;
				_tmp11_ = conn;
				_tmp12_ = connection_get_from_node (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup_printf ("%i", node_id (_tmp13_));
				_tmp15_ = _tmp14_;
				_tmp16_ = g_strconcat ("n", _tmp15_, NULL);
				_tmp17_ = _tmp16_;
				xmlNewProp (_tmp10_, (xmlChar*) "source", (xmlChar*) _tmp17_);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
				_tmp18_ = e;
				_tmp19_ = conn;
				_tmp20_ = connection_get_to_node (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf ("%i", node_id (_tmp21_));
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat ("n", _tmp23_, NULL);
				_tmp25_ = _tmp24_;
				xmlNewProp (_tmp18_, (xmlChar*) "target", (xmlChar*) _tmp25_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp23_);
				_tmp26_ = xmlNewNode (NULL, (xmlChar*) "data");
				d9 = _tmp26_;
				_tmp27_ = d9;
				xmlNewProp (_tmp27_, (xmlChar*) "key", (xmlChar*) "d9");
				_tmp28_ = e;
				_tmp29_ = d9;
				xmlAddChild (_tmp28_, _tmp29_);
				_tmp30_ = xmlNewNode (NULL, (xmlChar*) "data");
				d10 = _tmp30_;
				_tmp31_ = d10;
				xmlNewProp (_tmp31_, (xmlChar*) "key", (xmlChar*) "d10");
				_tmp32_ = xmlNewNode (yns, (xmlChar*) "BezierEdge");
				be = _tmp32_;
				_tmp33_ = xmlNewNode (yns, (xmlChar*) "Path");
				path = _tmp33_;
				_tmp34_ = path;
				xmlNewProp (_tmp34_, (xmlChar*) "sx", (xmlChar*) "0.0");
				_tmp35_ = path;
				xmlNewProp (_tmp35_, (xmlChar*) "sy", (xmlChar*) "0.0");
				_tmp36_ = path;
				xmlNewProp (_tmp36_, (xmlChar*) "tx", (xmlChar*) "0.0");
				_tmp37_ = path;
				xmlNewProp (_tmp37_, (xmlChar*) "ty", (xmlChar*) "0.0");
				_tmp38_ = be;
				_tmp39_ = path;
				xmlAddChild (_tmp38_, _tmp39_);
				_tmp40_ = xmlNewNode (yns, (xmlChar*) "LineStyle");
				ls = _tmp40_;
				_tmp41_ = ls;
				_tmp42_ = theme_get_color (theme, "connection_foreground");
				_tmp43_ = _tmp42_;
				_tmp44_ = *_tmp43_;
				_tmp45_ = utils_color_from_rgba (&_tmp44_);
				_tmp46_ = _tmp45_;
				xmlNewProp (_tmp41_, (xmlChar*) "color", (xmlChar*) _tmp46_);
				_g_free0 (_tmp46_);
				__vala_GdkRGBA_free0 (_tmp43_);
				_tmp48_ = conn;
				_tmp49_ = connection_get_style (_tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = style_get_connection_dash (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = _tmp52_->name;
				if (g_strcmp0 (_tmp53_, "solid") == 0) {
					_tmp47_ = "line";
				} else {
					_tmp47_ = "dashed";
				}
				_tmp54_ = ls;
				xmlNewProp (_tmp54_, (xmlChar*) "type", (xmlChar*) _tmp47_);
				_tmp55_ = ls;
				_tmp56_ = conn;
				_tmp57_ = connection_get_style (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = style_get_connection_line_width (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strdup_printf ("%i", *_tmp60_);
				_tmp62_ = _tmp61_;
				xmlNewProp (_tmp55_, (xmlChar*) "width", (xmlChar*) _tmp62_);
				_g_free0 (_tmp62_);
				_tmp63_ = be;
				_tmp64_ = ls;
				xmlAddChild (_tmp63_, _tmp64_);
				_tmp65_ = xmlNewNode (yns, (xmlChar*) "Arrows");
				arrow = _tmp65_;
				_tmp66_ = conn;
				_tmp67_ = connection_get_style (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = style_get_connection_arrow (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = g_strdup (_tmp70_);
				atype = _tmp71_;
				_tmp74_ = atype;
				if (g_strcmp0 (_tmp74_, "tofrom") == 0) {
					_tmp73_ = TRUE;
				} else {
					const gchar* _tmp75_;
					_tmp75_ = atype;
					_tmp73_ = g_strcmp0 (_tmp75_, "both") == 0;
				}
				if (_tmp73_) {
					_tmp72_ = "standard";
				} else {
					_tmp72_ = "none";
				}
				_tmp76_ = arrow;
				xmlNewProp (_tmp76_, (xmlChar*) "source", (xmlChar*) _tmp72_);
				_tmp79_ = atype;
				if (g_strcmp0 (_tmp79_, "fromto") == 0) {
					_tmp78_ = TRUE;
				} else {
					const gchar* _tmp80_;
					_tmp80_ = atype;
					_tmp78_ = g_strcmp0 (_tmp80_, "both") == 0;
				}
				if (_tmp78_) {
					_tmp77_ = "standard";
				} else {
					_tmp77_ = "none";
				}
				_tmp81_ = arrow;
				xmlNewProp (_tmp81_, (xmlChar*) "target", (xmlChar*) _tmp77_);
				_tmp82_ = be;
				_tmp83_ = arrow;
				xmlAddChild (_tmp82_, _tmp83_);
				_tmp84_ = conn;
				_tmp85_ = connection_get_title (_tmp84_);
				_tmp86_ = _tmp85_;
				if (_tmp86_ != NULL) {
					xmlNode* el = NULL;
					xmlNode* _tmp87_;
					xmlNode* _tmp88_;
					xmlNode* _tmp89_;
					Connection* _tmp90_;
					Style* _tmp91_;
					Style* _tmp92_;
					PangoFontDescription* _tmp93_;
					PangoFontDescription* _tmp94_;
					const gchar* _tmp95_;
					xmlNode* _tmp96_;
					Connection* _tmp97_;
					Style* _tmp98_;
					Style* _tmp99_;
					PangoFontDescription* _tmp100_;
					PangoFontDescription* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					xmlNode* _tmp104_;
					xmlNode* _tmp105_;
					xmlNode* _tmp106_;
					Connection* _tmp107_;
					CanvasText* _tmp108_;
					CanvasText* _tmp109_;
					gdouble _tmp110_;
					gdouble _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					xmlNode* _tmp114_;
					xmlNode* _tmp115_;
					xmlNode* _tmp116_;
					xmlNode* _tmp117_;
					xmlNode* _tmp118_;
					GdkRGBA* _tmp119_;
					GdkRGBA* _tmp120_;
					GdkRGBA _tmp121_;
					gchar* _tmp122_;
					gchar* _tmp123_;
					xmlNode* _tmp124_;
					xmlNode* _tmp125_;
					xmlNode* _tmp126_;
					Connection* _tmp127_;
					CanvasText* _tmp128_;
					CanvasText* _tmp129_;
					gdouble _tmp130_;
					gdouble _tmp131_;
					gchar* _tmp132_;
					gchar* _tmp133_;
					xmlNode* _tmp134_;
					Connection* _tmp135_;
					CanvasText* _tmp136_;
					CanvasText* _tmp137_;
					gdouble _tmp138_;
					gdouble _tmp139_;
					gchar* _tmp140_;
					gchar* _tmp141_;
					xmlNode* _tmp142_;
					xmlNode* _tmp143_;
					Connection* _tmp144_;
					CanvasText* _tmp145_;
					CanvasText* _tmp146_;
					gdouble _tmp147_;
					gdouble _tmp148_;
					gchar* _tmp149_;
					gchar* _tmp150_;
					xmlNode* _tmp151_;
					Connection* _tmp152_;
					CanvasText* _tmp153_;
					CanvasText* _tmp154_;
					gchar* _tmp155_;
					gchar* _tmp156_;
					xmlNode* lm = NULL;
					xmlNode* _tmp157_;
					xmlNode* slm = NULL;
					xmlNode* _tmp158_;
					xmlNode* _tmp159_;
					xmlNode* _tmp160_;
					xmlNode* _tmp161_;
					xmlNode* _tmp162_;
					xmlNode* _tmp163_;
					xmlNode* _tmp164_;
					xmlNode* _tmp165_;
					xmlNode* mp = NULL;
					xmlNode* _tmp166_;
					xmlNode* smp = NULL;
					xmlNode* _tmp167_;
					xmlNode* _tmp168_;
					xmlNode* _tmp169_;
					xmlNode* _tmp170_;
					xmlNode* _tmp171_;
					xmlNode* _tmp172_;
					xmlNode* _tmp173_;
					xmlNode* _tmp174_;
					xmlNode* _tmp175_;
					xmlNode* _tmp176_;
					xmlNode* _tmp177_;
					xmlNode* ppd = NULL;
					xmlNode* _tmp178_;
					xmlNode* _tmp179_;
					xmlNode* _tmp180_;
					xmlNode* _tmp181_;
					xmlNode* _tmp182_;
					xmlNode* _tmp183_;
					xmlNode* _tmp184_;
					xmlNode* _tmp185_;
					xmlNode* _tmp186_;
					xmlNode* _tmp187_;
					xmlNode* _tmp188_;
					xmlNode* _tmp189_;
					xmlNode* _tmp190_;
					xmlNode* _tmp191_;
					_tmp87_ = xmlNewNode (yns, (xmlChar*) "EdgeLabel");
					el = _tmp87_;
					_tmp88_ = el;
					xmlNewProp (_tmp88_, (xmlChar*) "alignment", (xmlChar*) "center");
					_tmp89_ = el;
					_tmp90_ = conn;
					_tmp91_ = connection_get_style (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = style_get_connection_font (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = pango_font_description_get_family (_tmp94_);
					xmlNewProp (_tmp89_, (xmlChar*) "fontFamily", (xmlChar*) _tmp95_);
					_tmp96_ = el;
					_tmp97_ = conn;
					_tmp98_ = connection_get_style (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = style_get_connection_font (_tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = g_strdup_printf ("%i", pango_font_description_get_size (_tmp101_) / PANGO_SCALE);
					_tmp103_ = _tmp102_;
					xmlNewProp (_tmp96_, (xmlChar*) "fontSize", (xmlChar*) _tmp103_);
					_g_free0 (_tmp103_);
					_tmp104_ = el;
					xmlNewProp (_tmp104_, (xmlChar*) "hasBackgroundColor", (xmlChar*) "false");
					_tmp105_ = el;
					xmlNewProp (_tmp105_, (xmlChar*) "hasLineColor", (xmlChar*) "true");
					_tmp106_ = el;
					_tmp107_ = conn;
					_tmp108_ = connection_get_title (_tmp107_);
					_tmp109_ = _tmp108_;
					_tmp110_ = canvas_text_get_height (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = double_to_string (_tmp111_);
					_tmp113_ = _tmp112_;
					xmlNewProp (_tmp106_, (xmlChar*) "height", (xmlChar*) _tmp113_);
					_g_free0 (_tmp113_);
					_tmp114_ = el;
					xmlNewProp (_tmp114_, (xmlChar*) "horizontalTextPosition", (xmlChar*) "center");
					_tmp115_ = el;
					xmlNewProp (_tmp115_, (xmlChar*) "modelName", (xmlChar*) "custom");
					_tmp116_ = el;
					xmlNewProp (_tmp116_, (xmlChar*) "preferredPlacement", (xmlChar*) "anywhere");
					_tmp117_ = el;
					xmlNewProp (_tmp117_, (xmlChar*) "ratio", (xmlChar*) "0.5");
					_tmp118_ = el;
					_tmp119_ = theme_get_color (theme, "foreground");
					_tmp120_ = _tmp119_;
					_tmp121_ = *_tmp120_;
					_tmp122_ = utils_color_from_rgba (&_tmp121_);
					_tmp123_ = _tmp122_;
					xmlNewProp (_tmp118_, (xmlChar*) "textColor", (xmlChar*) _tmp123_);
					_g_free0 (_tmp123_);
					__vala_GdkRGBA_free0 (_tmp120_);
					_tmp124_ = el;
					xmlNewProp (_tmp124_, (xmlChar*) "verticalTextPosition", (xmlChar*) "top");
					_tmp125_ = el;
					xmlNewProp (_tmp125_, (xmlChar*) "visible", (xmlChar*) "true");
					_tmp126_ = el;
					_tmp127_ = conn;
					_tmp128_ = connection_get_title (_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = canvas_text_get_width (_tmp129_);
					_tmp131_ = _tmp130_;
					_tmp132_ = double_to_string (_tmp131_);
					_tmp133_ = _tmp132_;
					xmlNewProp (_tmp126_, (xmlChar*) "width", (xmlChar*) _tmp133_);
					_g_free0 (_tmp133_);
					_tmp134_ = el;
					_tmp135_ = conn;
					_tmp136_ = connection_get_title (_tmp135_);
					_tmp137_ = _tmp136_;
					_tmp138_ = canvas_text_get_posx (_tmp137_);
					_tmp139_ = _tmp138_;
					_tmp140_ = double_to_string (_tmp139_);
					_tmp141_ = _tmp140_;
					xmlNewProp (_tmp134_, (xmlChar*) "x", (xmlChar*) _tmp141_);
					_g_free0 (_tmp141_);
					_tmp142_ = el;
					xmlNewProp (_tmp142_, (xmlChar*) "xml:space", (xmlChar*) "preserve");
					_tmp143_ = el;
					_tmp144_ = conn;
					_tmp145_ = connection_get_title (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = canvas_text_get_posy (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp149_ = double_to_string (_tmp148_);
					_tmp150_ = _tmp149_;
					xmlNewProp (_tmp143_, (xmlChar*) "y", (xmlChar*) _tmp150_);
					_g_free0 (_tmp150_);
					_tmp151_ = el;
					_tmp152_ = conn;
					_tmp153_ = connection_get_title (_tmp152_);
					_tmp154_ = _tmp153_;
					_tmp155_ = canvas_text_get_wrapped_text (_tmp154_);
					_tmp156_ = _tmp155_;
					xmlNodeAddContent (_tmp151_, (xmlChar*) _tmp156_);
					_g_free0 (_tmp156_);
					_tmp157_ = xmlNewNode (yns, (xmlChar*) "LabelModel");
					lm = _tmp157_;
					_tmp158_ = xmlNewNode (yns, (xmlChar*) "SmartEdgeLabelModel");
					slm = _tmp158_;
					_tmp159_ = slm;
					xmlNewProp (_tmp159_, (xmlChar*) "autoRotationEnabled", (xmlChar*) "false");
					_tmp160_ = slm;
					xmlNewProp (_tmp160_, (xmlChar*) "defaultAngle", (xmlChar*) "0.0");
					_tmp161_ = slm;
					xmlNewProp (_tmp161_, (xmlChar*) "defaultDistance", (xmlChar*) "10.0");
					_tmp162_ = lm;
					_tmp163_ = slm;
					xmlAddChild (_tmp162_, _tmp163_);
					_tmp164_ = el;
					_tmp165_ = lm;
					xmlAddChild (_tmp164_, _tmp165_);
					_tmp166_ = xmlNewNode (yns, (xmlChar*) "ModelParameter");
					mp = _tmp166_;
					_tmp167_ = xmlNewNode (yns, (xmlChar*) "SmartEdgeLabelModelParameter");
					smp = _tmp167_;
					_tmp168_ = smp;
					xmlNewProp (_tmp168_, (xmlChar*) "angle", (xmlChar*) "0.0");
					_tmp169_ = smp;
					xmlNewProp (_tmp169_, (xmlChar*) "distance", (xmlChar*) "30.0");
					_tmp170_ = smp;
					xmlNewProp (_tmp170_, (xmlChar*) "distanceToCenter", (xmlChar*) "true");
					_tmp171_ = smp;
					xmlNewProp (_tmp171_, (xmlChar*) "position", (xmlChar*) "left");
					_tmp172_ = smp;
					xmlNewProp (_tmp172_, (xmlChar*) "ratio", (xmlChar*) "0.5");
					_tmp173_ = smp;
					xmlNewProp (_tmp173_, (xmlChar*) "segment", (xmlChar*) "1");
					_tmp174_ = mp;
					_tmp175_ = smp;
					xmlAddChild (_tmp174_, _tmp175_);
					_tmp176_ = el;
					_tmp177_ = mp;
					xmlAddChild (_tmp176_, _tmp177_);
					_tmp178_ = xmlNewNode (yns, (xmlChar*) "PreferredPlacementDescriptor");
					ppd = _tmp178_;
					_tmp179_ = ppd;
					xmlNewProp (_tmp179_, (xmlChar*) "angle", (xmlChar*) "0.0");
					_tmp180_ = ppd;
					xmlNewProp (_tmp180_, (xmlChar*) "angleOffsetOnRightSide", (xmlChar*) "0");
					_tmp181_ = ppd;
					xmlNewProp (_tmp181_, (xmlChar*) "angleReference", (xmlChar*) "absolute");
					_tmp182_ = ppd;
					xmlNewProp (_tmp182_, (xmlChar*) "angleRotationOnRightSide", (xmlChar*) "co");
					_tmp183_ = ppd;
					xmlNewProp (_tmp183_, (xmlChar*) "distance", (xmlChar*) "-1.0");
					_tmp184_ = ppd;
					xmlNewProp (_tmp184_, (xmlChar*) "frozen", (xmlChar*) "true");
					_tmp185_ = ppd;
					xmlNewProp (_tmp185_, (xmlChar*) "placement", (xmlChar*) "anywhere");
					_tmp186_ = ppd;
					xmlNewProp (_tmp186_, (xmlChar*) "side", (xmlChar*) "anywhere");
					_tmp187_ = ppd;
					xmlNewProp (_tmp187_, (xmlChar*) "sideReference", (xmlChar*) "relative_to_edge_flow");
					_tmp188_ = el;
					_tmp189_ = ppd;
					xmlAddChild (_tmp188_, _tmp189_);
					_tmp190_ = be;
					_tmp191_ = el;
					xmlAddChild (_tmp190_, _tmp191_);
				}
				_tmp192_ = d10;
				_tmp193_ = be;
				xmlAddChild (_tmp192_, _tmp193_);
				_tmp194_ = e;
				_tmp195_ = d10;
				xmlAddChild (_tmp194_, _tmp195_);
				_tmp196_ = e;
				xmlAddChild (graph, _tmp196_);
				_g_free0 (atype);
				_g_object_unref0 (conn);
			}
		}
	}
}

static void
export_yed_class_init (ExportYedClass * klass,
                       gpointer klass_data)
{
	export_yed_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_yed_real_export;
}

static void
export_yed_instance_init (ExportYed * self,
                          gpointer klass)
{
}

static GType
export_yed_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportYedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_yed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportYed), 0, (GInstanceInitFunc) export_yed_instance_init, NULL };
	GType export_yed_type_id;
	export_yed_type_id = g_type_register_static (TYPE_EXPORT, "ExportYed", &g_define_type_info, 0);
	return export_yed_type_id;
}

GType
export_yed_get_type (void)
{
	static volatile gsize export_yed_type_id__once = 0;
	if (g_once_init_enter (&export_yed_type_id__once)) {
		GType export_yed_type_id;
		export_yed_type_id = export_yed_get_type_once ();
		g_once_init_leave (&export_yed_type_id__once, export_yed_type_id);
	}
	return export_yed_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

