/* TextParser.c generated by valac 0.56.18, the Vala compiler
 * generated from TextParser.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TEXT_PARSER (text_parser_get_type ())
#define TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_PARSER, TextParser))
#define TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_PARSER, TextParserClass))
#define IS_TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_PARSER))
#define IS_TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_PARSER))
#define TEXT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_PARSER, TextParserClass))

typedef struct _TextParser TextParser;
typedef struct _TextParserClass TextParserClass;
typedef struct _TextParserPrivate TextParserPrivate;
typedef enum  {
	FORMAT_TAG_BOLD = 0,
	FORMAT_TAG_ITALICS,
	FORMAT_TAG_UNDERLINE,
	FORMAT_TAG_STRIKETHRU,
	FORMAT_TAG_CODE,
	FORMAT_TAG_SUB,
	FORMAT_TAG_SUPER,
	FORMAT_TAG_HEADER,
	FORMAT_TAG_COLOR,
	FORMAT_TAG_HILITE,
	FORMAT_TAG_URL,
	FORMAT_TAG_SYNTAX,
	FORMAT_TAG_TAG,
	FORMAT_TAG_MATCH,
	FORMAT_TAG_SELECT,
	FORMAT_TAG_LENGTH
} FormatTag;

#define TYPE_FORMAT_TAG (format_tag_get_type ())

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_TEXT_BUFFER (undo_text_buffer_get_type ())
#define UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer))
#define UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))
#define IS_UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_BUFFER))
#define IS_UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_BUFFER))
#define UNDO_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))

typedef struct _UndoTextBuffer UndoTextBuffer;
typedef struct _UndoTextBufferClass UndoTextBufferClass;

#define TEXT_PARSER_TYPE_RE_CALLBACK (text_parser_re_callback_get_type ())
typedef struct _TextParserReCallback TextParserReCallback;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;
typedef void (*TextParserTextMatchCallback) (FormattedText* text, GMatchInfo* match_info, gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _ParamSpecTextParser ParamSpecTextParser;
enum  {
	TEXT_PARSER_ENABLE_CHANGED_SIGNAL,
	TEXT_PARSER_NUM_SIGNALS
};
static guint text_parser_signals[TEXT_PARSER_NUM_SIGNALS] = {0};

struct _TextParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextParserPrivate * priv;
};

struct _TextParserClass {
	GTypeClass parent_class;
	void (*finalize) (TextParser *self);
	gboolean (*tag_handled) (TextParser* self, FormatTag tag);
	void (*insert_tag) (TextParser* self, CanvasText* ct, FormatTag tag, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer, const gchar* extra);
	void (*remove_all_tags) (TextParser* self, CanvasText* ct, gint start_pos, gint end_pos, UndoTextBuffer* undo_buffer);
};

struct _TextParserReCallback {
	GRegex* re;
	TextParserTextMatchCallback func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _TextParserPrivate {
	gchar* _name;
	GArray* _res;
	gboolean _enable;
};

struct _ParamSpecTextParser {
	GParamSpec parent_instance;
};

static gint TextParser_private_offset;
static gpointer text_parser_parent_class = NULL;

VALA_EXTERN gpointer text_parser_ref (gpointer instance);
VALA_EXTERN void text_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_parser (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_text_parser (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_text_parser (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_text_parser (const GValue* value);
VALA_EXTERN GType text_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextParser, text_parser_unref)
VALA_EXTERN GType format_tag_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType undo_text_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextBuffer, g_object_unref)
static GType text_parser_re_callback_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
static TextParserReCallback* text_parser_re_callback_dup (const TextParserReCallback* self);
static void text_parser_re_callback_free (TextParserReCallback* self);
static void text_parser_re_callback_copy (const TextParserReCallback* self,
                                   TextParserReCallback* dest);
static void text_parser_re_callback_destroy (TextParserReCallback* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TextParserReCallback, text_parser_re_callback_destroy)
VALA_EXTERN gboolean text_parser_tag_handled (TextParser* self,
                                  FormatTag tag);
VALA_EXTERN void text_parser_insert_tag (TextParser* self,
                             CanvasText* ct,
                             FormatTag tag,
                             gint start_pos,
                             gint end_pos,
                             UndoTextBuffer* undo_buffer,
                             const gchar* extra);
VALA_EXTERN void text_parser_remove_all_tags (TextParser* self,
                                  CanvasText* ct,
                                  gint start_pos,
                                  gint end_pos,
                                  UndoTextBuffer* undo_buffer);
VALA_EXTERN TextParser* text_parser_new (const gchar* name);
VALA_EXTERN TextParser* text_parser_construct (GType object_type,
                                   const gchar* name);
static void _text_parser_re_callback_free0_ (gpointer var);
static void _vala_TextParserReCallback_free_function_content_of (gpointer data);
VALA_EXTERN void text_parser_add_regex (TextParser* self,
                            const gchar* re,
                            TextParserTextMatchCallback func,
                            gpointer func_target);
VALA_EXTERN void text_parser_add_tag (TextParser* self,
                          FormattedText* text,
                          GMatchInfo* matches,
                          gint paren,
                          FormatTag tag,
                          const gchar* extra);
VALA_EXTERN void formatted_text_add_tag (FormattedText* self,
                             FormatTag tag,
                             gint start,
                             gint end,
                             gboolean parsed,
                             const gchar* extra);
VALA_EXTERN gchar* text_parser_get_text (TextParser* self,
                             GMatchInfo* matches,
                             gint paren);
VALA_EXTERN void text_parser_parse (TextParser* self,
                        FormattedText* text);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
static gboolean text_parser_real_tag_handled (TextParser* self,
                                       FormatTag tag);
static void text_parser_real_insert_tag (TextParser* self,
                                  CanvasText* ct,
                                  FormatTag tag,
                                  gint start_pos,
                                  gint end_pos,
                                  UndoTextBuffer* undo_buffer,
                                  const gchar* extra);
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
static void text_parser_real_remove_all_tags (TextParser* self,
                                       CanvasText* ct,
                                       gint start_pos,
                                       gint end_pos,
                                       UndoTextBuffer* undo_buffer);
VALA_EXTERN void formatted_text_remove_all_tags (FormattedText* self,
                                     gint start,
                                     gint end);
VALA_EXTERN const gchar* text_parser_get_name (TextParser* self);
VALA_EXTERN gboolean text_parser_get_enable (TextParser* self);
VALA_EXTERN void text_parser_set_enable (TextParser* self,
                             gboolean value);
static void text_parser_finalize (TextParser * obj);
static GType text_parser_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
text_parser_get_instance_private (TextParser* self)
{
	return G_STRUCT_MEMBER_P (self, TextParser_private_offset);
}

static void
_text_parser_re_callback_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (text_parser_re_callback_free (var), NULL));
}

static void
_vala_TextParserReCallback_free_function_content_of (gpointer data)
{
	TextParserReCallback* self;
	self = *((TextParserReCallback**) data);
	_text_parser_re_callback_free0_ (self);
}

TextParser*
text_parser_construct (GType object_type,
                       const gchar* name)
{
	TextParser* self = NULL;
	gchar* _tmp0_;
	GArray* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (TextParser*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (TextParserReCallback*));
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_TextParserReCallback_free_function_content_of);
	_g_array_unref0 (self->priv->_res);
	self->priv->_res = _tmp1_;
	self->priv->_enable = TRUE;
	return self;
}

TextParser*
text_parser_new (const gchar* name)
{
	return text_parser_construct (TYPE_TEXT_PARSER, name);
}

static gpointer
_text_parser_re_callback_dup0 (gpointer self)
{
	return self ? text_parser_re_callback_dup (self) : NULL;
}

void
text_parser_add_regex (TextParser* self,
                       const gchar* re,
                       TextParserTextMatchCallback func,
                       gpointer func_target)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (re != NULL);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GArray* _tmp2_;
		GRegex* _tmp3_;
		TextParserReCallback _tmp4_ = {0};
		TextParserReCallback _tmp5_;
		TextParserReCallback* _tmp6_;
		_tmp1_ = g_regex_new (re, G_REGEX_MULTILINE, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = self->priv->_res;
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (_tmp4_.re);
		_tmp4_.re = _tmp3_;
		(_tmp4_.func_target_destroy_notify == NULL) ? NULL : (_tmp4_.func_target_destroy_notify (_tmp4_.func_target), NULL);
		_tmp4_.func = NULL;
		_tmp4_.func_target = NULL;
		_tmp4_.func_target_destroy_notify = NULL;
		_tmp4_.func = func;
		_tmp4_.func_target = func_target;
		_tmp4_.func_target_destroy_notify = NULL;
		_tmp5_ = _tmp4_;
		_tmp6_ = _text_parser_re_callback_dup0 (&_tmp5_);
		g_array_append_val (_tmp2_, _tmp6_);
		text_parser_re_callback_destroy (&_tmp5_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stdout;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		fprintf (_tmp7_, _ ("Parser regex error (re: %s, error: %s)\n"), re, _tmp9_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
text_parser_add_tag (TextParser* self,
                     FormattedText* text,
                     GMatchInfo* matches,
                     gint paren,
                     FormatTag tag,
                     const gchar* extra)
{
	gint start = 0;
	gint end = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (matches != NULL);
	g_match_info_fetch_pos (matches, paren, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	formatted_text_add_tag (text, tag, start, end, TRUE, extra);
}

gchar*
text_parser_get_text (TextParser* self,
                      GMatchInfo* matches,
                      gint paren)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (matches != NULL, NULL);
	_tmp0_ = g_match_info_fetch (matches, paren);
	result = _tmp0_;
	return result;
}

void
text_parser_parse (TextParser* self,
                   FormattedText* text)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (!self->priv->_enable) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GMatchInfo* matches = NULL;
				gint start = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_res;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				start = 0;
				{
					while (TRUE) {
						gboolean _tmp3_ = FALSE;
						GArray* _tmp4_;
						GRegex* _tmp5_;
						const gchar* _tmp6_;
						const gchar* _tmp7_;
						GMatchInfo* _tmp8_ = NULL;
						gboolean _tmp9_;
						gint start_pos = 0;
						gint end_pos = 0;
						GMatchInfo* _tmp10_;
						gint _tmp11_ = 0;
						gint _tmp12_ = 0;
						GArray* _tmp13_;
						TextParserTextMatchCallback _tmp14_;
						gpointer _tmp14__target;
						GMatchInfo* _tmp15_;
						_tmp4_ = self->priv->_res;
						_tmp5_ = (*g_array_index (_tmp4_, TextParserReCallback*, (guint) i)).re;
						_tmp6_ = formatted_text_get_text (text);
						_tmp7_ = _tmp6_;
						_tmp9_ = g_regex_match_full (_tmp5_, _tmp7_, (gssize) -1, start, 0, &_tmp8_, &_inner_error0_);
						_g_match_info_unref0 (matches);
						matches = _tmp8_;
						_tmp3_ = _tmp9_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == G_REGEX_ERROR) {
								goto __catch0_g_regex_error;
							}
							_g_match_info_unref0 (matches);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						if (!_tmp3_) {
							break;
						}
						_tmp10_ = matches;
						g_match_info_fetch_pos (_tmp10_, 0, &_tmp11_, &_tmp12_);
						start_pos = _tmp11_;
						end_pos = _tmp12_;
						start = end_pos;
						_tmp13_ = self->priv->_res;
						_tmp14_ = (*g_array_index (_tmp13_, TextParserReCallback*, (guint) i)).func;
						_tmp14__target = (*g_array_index (_tmp13_, TextParserReCallback*, (guint) i)).func_target;
						_tmp15_ = matches;
						_tmp14_ (text, _tmp15_, _tmp14__target);
					}
				}
				goto __finally0;
				__catch0_g_regex_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_match_info_unref0 (matches);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_match_info_unref0 (matches);
			}
		}
	}
}

static gboolean
text_parser_real_tag_handled (TextParser* self,
                              FormatTag tag)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
text_parser_tag_handled (TextParser* self,
                         FormatTag tag)
{
	TextParserClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = TEXT_PARSER_GET_CLASS (self);
	if (_klass_->tag_handled) {
		return _klass_->tag_handled (self, tag);
	}
	return FALSE;
}

static void
text_parser_real_insert_tag (TextParser* self,
                             CanvasText* ct,
                             FormatTag tag,
                             gint start_pos,
                             gint end_pos,
                             UndoTextBuffer* undo_buffer,
                             const gchar* extra)
{
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	g_return_if_fail (ct != NULL);
	g_return_if_fail (undo_buffer != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	formatted_text_add_tag (_tmp1_, tag, start_pos, end_pos, FALSE, extra);
}

void
text_parser_insert_tag (TextParser* self,
                        CanvasText* ct,
                        FormatTag tag,
                        gint start_pos,
                        gint end_pos,
                        UndoTextBuffer* undo_buffer,
                        const gchar* extra)
{
	TextParserClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = TEXT_PARSER_GET_CLASS (self);
	if (_klass_->insert_tag) {
		_klass_->insert_tag (self, ct, tag, start_pos, end_pos, undo_buffer, extra);
	}
}

static void
text_parser_real_remove_all_tags (TextParser* self,
                                  CanvasText* ct,
                                  gint start_pos,
                                  gint end_pos,
                                  UndoTextBuffer* undo_buffer)
{
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	g_return_if_fail (ct != NULL);
	g_return_if_fail (undo_buffer != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	formatted_text_remove_all_tags (_tmp1_, start_pos, end_pos);
}

void
text_parser_remove_all_tags (TextParser* self,
                             CanvasText* ct,
                             gint start_pos,
                             gint end_pos,
                             UndoTextBuffer* undo_buffer)
{
	TextParserClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = TEXT_PARSER_GET_CLASS (self);
	if (_klass_->remove_all_tags) {
		_klass_->remove_all_tags (self, ct, start_pos, end_pos, undo_buffer);
	}
}

const gchar*
text_parser_get_name (TextParser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

gboolean
text_parser_get_enable (TextParser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable;
	return result;
}

void
text_parser_set_enable (TextParser* self,
                        gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_enable != value) {
		self->priv->_enable = value;
		g_signal_emit (self, text_parser_signals[TEXT_PARSER_ENABLE_CHANGED_SIGNAL], 0);
	}
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static void
text_parser_re_callback_copy (const TextParserReCallback* self,
                              TextParserReCallback* dest)
{
	GRegex* _tmp0_;
	GRegex* _tmp1_;
	TextParserTextMatchCallback _tmp2_;
	gpointer _tmp2__target;
	_tmp0_ = (*self).re;
	_tmp1_ = _g_regex_ref0 (_tmp0_);
	_g_regex_unref0 ((*dest).re);
	(*dest).re = _tmp1_;
	_tmp2_ = (*self).func;
	_tmp2__target = (*self).func_target;
	((*dest).func_target_destroy_notify == NULL) ? NULL : ((*dest).func_target_destroy_notify ((*dest).func_target), NULL);
	(*dest).func = NULL;
	(*dest).func_target = NULL;
	(*dest).func_target_destroy_notify = NULL;
	(*dest).func = _tmp2_;
	(*dest).func_target = _tmp2__target;
	(*dest).func_target_destroy_notify = NULL;
}

static void
text_parser_re_callback_destroy (TextParserReCallback* self)
{
	_g_regex_unref0 ((*self).re);
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
}

static TextParserReCallback*
text_parser_re_callback_dup (const TextParserReCallback* self)
{
	TextParserReCallback* dup;
	dup = g_new0 (TextParserReCallback, 1);
	text_parser_re_callback_copy (self, dup);
	return dup;
}

static void
text_parser_re_callback_free (TextParserReCallback* self)
{
	text_parser_re_callback_destroy (self);
	g_free (self);
}

static GType
text_parser_re_callback_get_type_once (void)
{
	GType text_parser_re_callback_type_id;
	text_parser_re_callback_type_id = g_boxed_type_register_static ("TextParserReCallback", (GBoxedCopyFunc) text_parser_re_callback_dup, (GBoxedFreeFunc) text_parser_re_callback_free);
	return text_parser_re_callback_type_id;
}

static GType
text_parser_re_callback_get_type (void)
{
	static volatile gsize text_parser_re_callback_type_id__once = 0;
	if (g_once_init_enter (&text_parser_re_callback_type_id__once)) {
		GType text_parser_re_callback_type_id;
		text_parser_re_callback_type_id = text_parser_re_callback_get_type_once ();
		g_once_init_leave (&text_parser_re_callback_type_id__once, text_parser_re_callback_type_id);
	}
	return text_parser_re_callback_type_id__once;
}

static void
value_text_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_text_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		text_parser_unref (value->data[0].v_pointer);
	}
}

static void
value_text_parser_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = text_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_text_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_text_parser_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TextParser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = text_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_text_parser_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	TextParser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = text_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_text_parser (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecTextParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEXT_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_text_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_PARSER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_text_parser (GValue* value,
                       gpointer v_object)
{
	TextParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		text_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_parser_unref (old);
	}
}

void
value_take_text_parser (GValue* value,
                        gpointer v_object)
{
	TextParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_parser_unref (old);
	}
}

static void
text_parser_class_init (TextParserClass * klass,
                        gpointer klass_data)
{
	text_parser_parent_class = g_type_class_peek_parent (klass);
	((TextParserClass *) klass)->finalize = text_parser_finalize;
	g_type_class_adjust_private_offset (klass, &TextParser_private_offset);
	((TextParserClass *) klass)->tag_handled = (gboolean (*) (TextParser*, FormatTag)) text_parser_real_tag_handled;
	((TextParserClass *) klass)->insert_tag = (void (*) (TextParser*, CanvasText*, FormatTag, gint, gint, UndoTextBuffer*, const gchar*)) text_parser_real_insert_tag;
	((TextParserClass *) klass)->remove_all_tags = (void (*) (TextParser*, CanvasText*, gint, gint, UndoTextBuffer*)) text_parser_real_remove_all_tags;
	text_parser_signals[TEXT_PARSER_ENABLE_CHANGED_SIGNAL] = g_signal_new ("enable-changed", TYPE_TEXT_PARSER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
text_parser_instance_init (TextParser * self,
                           gpointer klass)
{
	self->priv = text_parser_get_instance_private (self);
	self->ref_count = 1;
}

static void
text_parser_finalize (TextParser * obj)
{
	TextParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_PARSER, TextParser);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_name);
	_g_array_unref0 (self->priv->_res);
}

static GType
text_parser_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_text_parser_init, value_text_parser_free_value, value_text_parser_copy_value, value_text_parser_peek_pointer, "p", value_text_parser_collect_value, "p", value_text_parser_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TextParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextParser), 0, (GInstanceInitFunc) text_parser_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType text_parser_type_id;
	text_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TextParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
	TextParser_private_offset = g_type_add_instance_private (text_parser_type_id, sizeof (TextParserPrivate));
	return text_parser_type_id;
}

GType
text_parser_get_type (void)
{
	static volatile gsize text_parser_type_id__once = 0;
	if (g_once_init_enter (&text_parser_type_id__once)) {
		GType text_parser_type_id;
		text_parser_type_id = text_parser_get_type_once ();
		g_once_init_leave (&text_parser_type_id__once, text_parser_type_id);
	}
	return text_parser_type_id__once;
}

gpointer
text_parser_ref (gpointer instance)
{
	TextParser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
text_parser_unref (gpointer instance)
{
	TextParser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEXT_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

