/* Connections.c generated by valac 0.56.18, the Vala compiler
 * generated from Connections.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CONNECTIONS (connections_get_type ())
#define CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTIONS, Connections))
#define CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTIONS, ConnectionsClass))
#define IS_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTIONS))
#define IS_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTIONS))
#define CONNECTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTIONS, ConnectionsClass))

typedef struct _Connections Connections;
typedef struct _ConnectionsClass ConnectionsClass;
typedef struct _ConnectionsPrivate ConnectionsPrivate;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_NODE_LINKS (node_links_get_type ())
#define NODE_LINKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LINKS, NodeLinks))
#define NODE_LINKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_LINKS, NodeLinksClass))
#define IS_NODE_LINKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LINKS))
#define IS_NODE_LINKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_LINKS))
#define NODE_LINKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_LINKS, NodeLinksClass))

typedef struct _NodeLinks NodeLinks;
typedef struct _NodeLinksClass NodeLinksClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ParamSpecConnections ParamSpecConnections;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Connections {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ConnectionsPrivate * priv;
};

struct _ConnectionsClass {
	GTypeClass parent_class;
	void (*finalize) (Connections *self);
};

struct _ConnectionsPrivate {
	GArray* _connections;
	gboolean _hide;
};

struct _ParamSpecConnections {
	GParamSpec parent_instance;
};

static gint Connections_private_offset;
static gpointer connections_parent_class = NULL;

VALA_EXTERN gpointer connections_ref (gpointer instance);
VALA_EXTERN void connections_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_connections (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_connections (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_connections (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_connections (const GValue* value);
VALA_EXTERN GType connections_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connections, connections_unref)
VALA_EXTERN GType connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connection, g_object_unref)
VALA_EXTERN Connections* connections_new (void);
VALA_EXTERN Connections* connections_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static void _vala_Connection_free_function_content_of (gpointer data);
VALA_EXTERN void connections_clear_all_connections (Connections* self);
VALA_EXTERN void connections_add_connection (Connections* self,
                                 Connection* conn);
VALA_EXTERN gboolean connections_remove_connection (Connections* self,
                                        Connection* conn,
                                        gboolean disconnect);
VALA_EXTERN void connection_disconnect_from_node (Connection* self,
                                      gboolean from);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN void connections_complete_connection (Connections* self,
                                      gint index,
                                      Node* to_node);
VALA_EXTERN void connection_connect_to (Connection* self,
                            Node* node);
VALA_EXTERN Connection* connections_get_connection (Connections* self,
                                        Connection* conn,
                                        gint dir);
VALA_EXTERN Connection* connections_get_attached_connection (Connections* self,
                                                 Node* node,
                                                 gint index);
VALA_EXTERN gboolean connection_attached_to_node (Connection* self,
                                      Node* node);
VALA_EXTERN Connection* connections_on_curve (Connections* self,
                                  gdouble x,
                                  gdouble y);
VALA_EXTERN gboolean connections_get_hide (Connections* self);
VALA_EXTERN gboolean connection_on_curve (Connection* self,
                              gdouble x,
                              gdouble y);
VALA_EXTERN Connection* connections_within_title_box (Connections* self,
                                          gdouble x,
                                          gdouble y);
VALA_EXTERN gboolean connection_within_title_box (Connection* self,
                                      gdouble x,
                                      gdouble y);
VALA_EXTERN Connection* connections_within_title (Connections* self,
                                      gdouble x,
                                      gdouble y);
VALA_EXTERN gboolean connection_within_title (Connection* self,
                                  gdouble x,
                                  gdouble y);
VALA_EXTERN Connection* connections_within_note (Connections* self,
                                     gdouble x,
                                     gdouble y);
VALA_EXTERN gboolean connection_within_note (Connection* self,
                                 gdouble x,
                                 gdouble y);
VALA_EXTERN Connection* connections_within_drag_handle (Connections* self,
                                            gdouble x,
                                            gdouble y);
VALA_EXTERN gboolean connection_within_drag_handle (Connection* self,
                                        gdouble x,
                                        gdouble y);
VALA_EXTERN void connections_node_deleted (Connections* self,
                               Node* node,
                               GArray* conns);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN void connections_node_only_deleted (Connections* self,
                                    Node* node,
                                    GArray* conns);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN void connections_load (Connections* self,
                       DrawArea* da,
                       xmlNode* node,
                       GArray* conns,
                       GArray* nodes);
VALA_EXTERN Connection* connection_new_from_xml (DrawArea* da,
                                     xmlNode* n,
                                     GArray* nodes);
VALA_EXTERN Connection* connection_construct_from_xml (GType object_type,
                                           DrawArea* da,
                                           xmlNode* n,
                                           GArray* nodes);
VALA_EXTERN void connections_save (Connections* self,
                       xmlNode* parent);
VALA_EXTERN void connection_save (Connection* self,
                      xmlNode* parent);
VALA_EXTERN gpointer node_links_ref (gpointer instance);
VALA_EXTERN void node_links_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_links (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_links (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_links (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_links (const GValue* value);
VALA_EXTERN GType node_links_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeLinks, node_links_unref)
VALA_EXTERN void connections_save_if_in_node (Connections* self,
                                  xmlNode* parent,
                                  Node* node,
                                  NodeLinks* save_links,
                                  NodeLinks* doc_links);
VALA_EXTERN Node* connection_get_from_node (Connection* self);
VALA_EXTERN gboolean node_is_descendant_of (Node* self,
                                Node* node);
VALA_EXTERN Node* connection_get_to_node (Connection* self);
VALA_EXTERN void node_links_get_links_from_connection (NodeLinks* self,
                                           Connection* conn,
                                           NodeLinks* doc_links);
VALA_EXTERN void connections_set_links_in_notes (Connections* self,
                                     Node* node,
                                     NodeLinks* links,
                                     NodeLinks* doc_links);
VALA_EXTERN void node_links_set_links_in_connection (NodeLinks* self,
                                         Connection* conn,
                                         NodeLinks* doc_links);
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN void connections_set_all_connections_to_style (Connections* self,
                                               Style* style);
VALA_EXTERN void connection_set_style (Connection* self,
                           Style* value);
VALA_EXTERN void connections_get_match_items (Connections* self,
                                  const gchar* tabname,
                                  const gchar* pattern,
                                  gboolean* search_opts,
                                  gint search_opts_length1,
                                  GtkListStore** matches);
VALA_EXTERN void connection_get_match_items (Connection* self,
                                 const gchar* tabname,
                                 const gchar* pattern,
                                 gboolean* search_opts,
                                 gint search_opts_length1,
                                 GtkListStore** matches);
VALA_EXTERN void connections_update_alpha (Connections* self);
VALA_EXTERN gdouble node_get_alpha (Node* self);
VALA_EXTERN void connection_set_alpha (Connection* self,
                           gdouble value);
VALA_EXTERN void connections_add_extents (Connections* self,
                              gdouble* x1,
                              gdouble* y1,
                              gdouble* x2,
                              gdouble* y2);
VALA_EXTERN gdouble connection_get_extent_x1 (Connection* self);
VALA_EXTERN gdouble connection_get_extent_y1 (Connection* self);
VALA_EXTERN gdouble connection_get_extent_x2 (Connection* self);
VALA_EXTERN gdouble connection_get_extent_y2 (Connection* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void connections_draw_all (Connections* self,
                           cairo_t* ctx,
                           Theme* theme,
                           gboolean exporting);
VALA_EXTERN void connection_draw (Connection* self,
                      cairo_t* ctx,
                      Theme* theme,
                      gboolean exporting);
VALA_EXTERN GArray* connections_get_connections (Connections* self);
VALA_EXTERN void connections_set_hide (Connections* self,
                           gboolean value);
static void connections_finalize (Connections * obj);
static GType connections_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
connections_get_instance_private (Connections* self)
{
	return G_STRUCT_MEMBER_P (self, Connections_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_Connection_free_function_content_of (gpointer data)
{
	Connection* self;
	self = *((Connection**) data);
	_g_object_unref0_ (self);
}

Connections*
connections_construct (GType object_type)
{
	Connections* self = NULL;
	GArray* _tmp0_;
	self = (Connections*) g_type_create_instance (object_type);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Connection*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Connection_free_function_content_of);
	_g_array_unref0 (self->priv->_connections);
	self->priv->_connections = _tmp0_;
	return self;
}

Connections*
connections_new (void)
{
	return connections_construct (TYPE_CONNECTIONS);
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

void
connections_clear_all_connections (Connections* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	Connection** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_connections;
	_tmp1_ = self->priv->_connections;
	_tmp3_ = vala_g_array_remove_range (_tmp0_, (guint) 0, _tmp1_->len, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
connections_add_connection (Connections* self,
                            Connection* conn)
{
	GArray* _tmp5_;
	Connection* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Connection* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_connections;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_connections;
				_tmp4_ = g_array_index (_tmp3_, Connection*, (guint) i);
				if (_tmp4_ == conn) {
					return;
				}
			}
		}
	}
	_tmp5_ = self->priv->_connections;
	_tmp6_ = _g_object_ref0 (conn);
	g_array_append_val (_tmp5_, _tmp6_);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

gboolean
connections_remove_connection (Connections* self,
                               Connection* conn,
                               gboolean disconnect)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (conn != NULL, FALSE);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Connection* _tmp4_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_connections;
				if (!(i < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_connections;
				_tmp4_ = g_array_index (_tmp3_, Connection*, i);
				if (_tmp4_ == conn) {
					GArray* _tmp9_;
					Connection* _tmp10_;
					Connection* _tmp11_;
					if (disconnect) {
						GArray* _tmp5_;
						Connection* _tmp6_;
						GArray* _tmp7_;
						Connection* _tmp8_;
						_tmp5_ = self->priv->_connections;
						_tmp6_ = g_array_index (_tmp5_, Connection*, i);
						connection_disconnect_from_node (_tmp6_, TRUE);
						_tmp7_ = self->priv->_connections;
						_tmp8_ = g_array_index (_tmp7_, Connection*, i);
						connection_disconnect_from_node (_tmp8_, FALSE);
					}
					_tmp9_ = self->priv->_connections;
					_tmp10_ = vala_g_array_remove_index (_tmp9_, i);
					_tmp11_ = _tmp10_;
					_g_object_unref0 (_tmp11_);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

void
connections_complete_connection (Connections* self,
                                 gint index,
                                 Node* to_node)
{
	GArray* _tmp0_;
	Connection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (to_node != NULL);
	_tmp0_ = self->priv->_connections;
	_tmp1_ = g_array_index (_tmp0_, Connection*, (guint) index);
	connection_connect_to (_tmp1_, to_node);
}

Connection*
connections_get_connection (Connections* self,
                            Connection* conn,
                            gint dir)
{
	GArray* _tmp0_;
	Connection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (conn != NULL, NULL);
	_tmp0_ = self->priv->_connections;
	if (_tmp0_->len == ((guint) 1)) {
		result = NULL;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				Connection* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_connections;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = self->priv->_connections;
				_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
				if (_tmp5_ == conn) {
					gint _tmp6_ = 0;
					gint index = 0;
					GArray* _tmp9_;
					Connection* _tmp10_;
					Connection* _tmp11_;
					if ((i + dir) < 0) {
						GArray* _tmp7_;
						_tmp7_ = self->priv->_connections;
						_tmp6_ = (gint) (_tmp7_->len - 1);
					} else {
						GArray* _tmp8_;
						_tmp8_ = self->priv->_connections;
						_tmp6_ = (gint) ((i + dir) % _tmp8_->len);
					}
					index = _tmp6_;
					_tmp9_ = self->priv->_connections;
					_tmp10_ = g_array_index (_tmp9_, Connection*, (guint) index);
					_tmp11_ = _g_object_ref0 (_tmp10_);
					result = _tmp11_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

Connection*
connections_get_attached_connection (Connections* self,
                                     Node* node,
                                     gint index)
{
	gint matches = 0;
	Connection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	matches = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				gboolean _tmp3_ = FALSE;
				GArray* _tmp4_;
				Connection* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_connections;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp4_ = self->priv->_connections;
				_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
				if (connection_attached_to_node (_tmp5_, node)) {
					gint _tmp6_;
					gint _tmp7_;
					_tmp6_ = index;
					_tmp7_ = matches;
					matches = _tmp7_ + 1;
					_tmp3_ = _tmp6_ == _tmp7_;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					GArray* _tmp8_;
					Connection* _tmp9_;
					Connection* _tmp10_;
					_tmp8_ = self->priv->_connections;
					_tmp9_ = g_array_index (_tmp8_, Connection*, (guint) i);
					_tmp10_ = _g_object_ref0 (_tmp9_);
					result = _tmp10_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

Connection*
connections_on_curve (Connections* self,
                      gdouble x,
                      gdouble y)
{
	gboolean _tmp0_;
	Connection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hide;
	if (!_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Connection* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->_connections;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = self->priv->_connections;
					_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
					if (connection_on_curve (_tmp5_, x, y)) {
						GArray* _tmp6_;
						Connection* _tmp7_;
						Connection* _tmp8_;
						_tmp6_ = self->priv->_connections;
						_tmp7_ = g_array_index (_tmp6_, Connection*, (guint) i);
						_tmp8_ = _g_object_ref0 (_tmp7_);
						result = _tmp8_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

Connection*
connections_within_title_box (Connections* self,
                              gdouble x,
                              gdouble y)
{
	gboolean _tmp0_;
	Connection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hide;
	if (!_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Connection* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->_connections;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = self->priv->_connections;
					_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
					if (connection_within_title_box (_tmp5_, x, y)) {
						GArray* _tmp6_;
						Connection* _tmp7_;
						Connection* _tmp8_;
						_tmp6_ = self->priv->_connections;
						_tmp7_ = g_array_index (_tmp6_, Connection*, (guint) i);
						_tmp8_ = _g_object_ref0 (_tmp7_);
						result = _tmp8_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

Connection*
connections_within_title (Connections* self,
                          gdouble x,
                          gdouble y)
{
	gboolean _tmp0_;
	Connection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hide;
	if (!_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Connection* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->_connections;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = self->priv->_connections;
					_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
					if (connection_within_title (_tmp5_, x, y)) {
						GArray* _tmp6_;
						Connection* _tmp7_;
						Connection* _tmp8_;
						_tmp6_ = self->priv->_connections;
						_tmp7_ = g_array_index (_tmp6_, Connection*, (guint) i);
						_tmp8_ = _g_object_ref0 (_tmp7_);
						result = _tmp8_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

Connection*
connections_within_note (Connections* self,
                         gdouble x,
                         gdouble y)
{
	gboolean _tmp0_;
	Connection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hide;
	if (!_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Connection* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->_connections;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = self->priv->_connections;
					_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
					if (connection_within_note (_tmp5_, x, y)) {
						GArray* _tmp6_;
						Connection* _tmp7_;
						Connection* _tmp8_;
						_tmp6_ = self->priv->_connections;
						_tmp7_ = g_array_index (_tmp6_, Connection*, (guint) i);
						_tmp8_ = _g_object_ref0 (_tmp7_);
						result = _tmp8_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

Connection*
connections_within_drag_handle (Connections* self,
                                gdouble x,
                                gdouble y)
{
	gboolean _tmp0_;
	Connection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hide;
	if (!_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Connection* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->_connections;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = self->priv->_connections;
					_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
					if (connection_within_drag_handle (_tmp5_, x, y)) {
						GArray* _tmp6_;
						Connection* _tmp7_;
						Connection* _tmp8_;
						_tmp6_ = self->priv->_connections;
						_tmp7_ = g_array_index (_tmp6_, Connection*, (guint) i);
						_tmp8_ = _g_object_ref0 (_tmp7_);
						result = _tmp8_;
						return result;
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
connections_node_deleted (Connections* self,
                          Node* node,
                          GArray* conns)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (conns != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				gboolean _tmp4_;
				GArray* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = node_children (node);
				_tmp3_ = _tmp2_;
				_tmp4_ = !(((guint) i) < _tmp3_->len);
				_g_array_unref0 (_tmp3_);
				if (_tmp4_) {
					break;
				}
				_tmp5_ = node_children (node);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				connections_node_deleted (self, _tmp7_, conns);
				_g_array_unref0 (_tmp6_);
			}
		}
	}
	{
		gint i = 0;
		GArray* _tmp8_;
		_tmp8_ = self->priv->_connections;
		i = ((gint) _tmp8_->len) - 1;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				GArray* _tmp11_;
				Connection* _tmp12_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ - 1;
				}
				_tmp9_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp11_ = self->priv->_connections;
				_tmp12_ = g_array_index (_tmp11_, Connection*, (guint) i);
				if (connection_attached_to_node (_tmp12_, node)) {
					GArray* _tmp13_;
					Connection* _tmp14_;
					Connection* _tmp15_;
					GArray* _tmp16_;
					Connection* _tmp17_;
					Connection* _tmp18_;
					_tmp13_ = self->priv->_connections;
					_tmp14_ = g_array_index (_tmp13_, Connection*, (guint) i);
					_tmp15_ = _g_object_ref0 (_tmp14_);
					g_array_append_val (conns, _tmp15_);
					_tmp16_ = self->priv->_connections;
					_tmp17_ = vala_g_array_remove_index (_tmp16_, (guint) i);
					_tmp18_ = _tmp17_;
					_g_object_unref0 (_tmp18_);
				}
			}
		}
	}
}

void
connections_node_only_deleted (Connections* self,
                               Node* node,
                               GArray* conns)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (conns != NULL);
	{
		gint i = 0;
		GArray* _tmp0_;
		_tmp0_ = self->priv->_connections;
		i = ((gint) _tmp0_->len) - 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				Connection* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp3_ = self->priv->_connections;
				_tmp4_ = g_array_index (_tmp3_, Connection*, (guint) i);
				if (connection_attached_to_node (_tmp4_, node)) {
					GArray* _tmp5_;
					Connection* _tmp6_;
					Connection* _tmp7_;
					GArray* _tmp8_;
					Connection* _tmp9_;
					Connection* _tmp10_;
					_tmp5_ = self->priv->_connections;
					_tmp6_ = g_array_index (_tmp5_, Connection*, (guint) i);
					_tmp7_ = _g_object_ref0 (_tmp6_);
					g_array_append_val (conns, _tmp7_);
					_tmp8_ = self->priv->_connections;
					_tmp9_ = vala_g_array_remove_index (_tmp8_, (guint) i);
					_tmp10_ = _tmp9_;
					_g_object_unref0 (_tmp10_);
				}
			}
		}
	}
}

void
connections_load (Connections* self,
                  DrawArea* da,
                  xmlNode* node,
                  GArray* conns,
                  GArray* nodes)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	g_return_if_fail (nodes != NULL);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = node->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				xmlNode* _tmp5_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = it;
				if (_tmp5_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp6_;
					const gchar* _tmp7_;
					_tmp6_ = it;
					_tmp7_ = _tmp6_->name;
					if (g_strcmp0 (_tmp7_, "connection") == 0) {
						Connection* conn = NULL;
						xmlNode* _tmp8_;
						Connection* _tmp9_;
						GArray* _tmp12_;
						Connection* _tmp13_;
						Connection* _tmp14_;
						_tmp8_ = it;
						_tmp9_ = connection_new_from_xml (da, _tmp8_, nodes);
						conn = _tmp9_;
						if (conns != NULL) {
							Connection* _tmp10_;
							Connection* _tmp11_;
							_tmp10_ = conn;
							_tmp11_ = _g_object_ref0 (_tmp10_);
							g_array_append_val (conns, _tmp11_);
						}
						_tmp12_ = self->priv->_connections;
						_tmp13_ = conn;
						_tmp14_ = _g_object_ref0 (_tmp13_);
						g_array_append_val (_tmp12_, _tmp14_);
						_g_object_unref0 (conn);
					}
				}
			}
		}
	}
}

void
connections_save (Connections* self,
                  xmlNode* parent)
{
	GArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_connections;
	if (_tmp0_->len > ((guint) 0)) {
		xmlNode* n = NULL;
		xmlNode* _tmp1_;
		xmlNode* _tmp8_;
		_tmp1_ = xmlNewNode (NULL, (xmlChar*) "connections");
		n = _tmp1_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					GArray* _tmp4_;
					GArray* _tmp5_;
					Connection* _tmp6_;
					xmlNode* _tmp7_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = i;
						i = _tmp3_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp4_ = self->priv->_connections;
					if (!(((guint) i) < _tmp4_->len)) {
						break;
					}
					_tmp5_ = self->priv->_connections;
					_tmp6_ = g_array_index (_tmp5_, Connection*, (guint) i);
					_tmp7_ = n;
					connection_save (_tmp6_, _tmp7_);
				}
			}
		}
		_tmp8_ = n;
		xmlAddChild (parent, _tmp8_);
	}
}

void
connections_save_if_in_node (Connections* self,
                             xmlNode* parent,
                             Node* node,
                             NodeLinks* save_links,
                             NodeLinks* doc_links)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (save_links != NULL);
	g_return_if_fail (doc_links != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				gboolean _tmp3_ = FALSE;
				GArray* _tmp4_;
				Connection* _tmp5_;
				Node* _tmp6_;
				Node* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_connections;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp4_ = self->priv->_connections;
				_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
				_tmp6_ = connection_get_from_node (_tmp5_);
				_tmp7_ = _tmp6_;
				if (node_is_descendant_of (_tmp7_, node)) {
					GArray* _tmp8_;
					Connection* _tmp9_;
					Node* _tmp10_;
					Node* _tmp11_;
					_tmp8_ = self->priv->_connections;
					_tmp9_ = g_array_index (_tmp8_, Connection*, (guint) i);
					_tmp10_ = connection_get_to_node (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp3_ = node_is_descendant_of (_tmp11_, node);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					GArray* _tmp12_;
					Connection* _tmp13_;
					GArray* _tmp14_;
					Connection* _tmp15_;
					_tmp12_ = self->priv->_connections;
					_tmp13_ = g_array_index (_tmp12_, Connection*, (guint) i);
					connection_save (_tmp13_, parent);
					_tmp14_ = self->priv->_connections;
					_tmp15_ = g_array_index (_tmp14_, Connection*, (guint) i);
					node_links_get_links_from_connection (save_links, _tmp15_, doc_links);
				}
			}
		}
	}
}

void
connections_set_links_in_notes (Connections* self,
                                Node* node,
                                NodeLinks* links,
                                NodeLinks* doc_links)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (links != NULL);
	g_return_if_fail (doc_links != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				gboolean _tmp3_ = FALSE;
				GArray* _tmp4_;
				Connection* _tmp5_;
				Node* _tmp6_;
				Node* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_connections;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp4_ = self->priv->_connections;
				_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
				_tmp6_ = connection_get_from_node (_tmp5_);
				_tmp7_ = _tmp6_;
				if (node_is_descendant_of (_tmp7_, node)) {
					GArray* _tmp8_;
					Connection* _tmp9_;
					Node* _tmp10_;
					Node* _tmp11_;
					_tmp8_ = self->priv->_connections;
					_tmp9_ = g_array_index (_tmp8_, Connection*, (guint) i);
					_tmp10_ = connection_get_to_node (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp3_ = node_is_descendant_of (_tmp11_, node);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					GArray* _tmp12_;
					Connection* _tmp13_;
					_tmp12_ = self->priv->_connections;
					_tmp13_ = g_array_index (_tmp12_, Connection*, (guint) i);
					node_links_set_links_in_connection (links, _tmp13_, doc_links);
				}
			}
		}
	}
}

void
connections_set_all_connections_to_style (Connections* self,
                                          Style* style)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (style != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Connection* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_connections;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_connections;
				_tmp4_ = g_array_index (_tmp3_, Connection*, (guint) i);
				connection_set_style (_tmp4_, style);
			}
		}
	}
}

void
connections_get_match_items (Connections* self,
                             const gchar* tabname,
                             const gchar* pattern,
                             gboolean* search_opts,
                             gint search_opts_length1,
                             GtkListStore** matches)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tabname != NULL);
	g_return_if_fail (pattern != NULL);
	g_return_if_fail (*matches != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Connection* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_connections;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_connections;
				_tmp4_ = g_array_index (_tmp3_, Connection*, (guint) i);
				connection_get_match_items (_tmp4_, tabname, pattern, search_opts, (gint) search_opts_length1, matches);
			}
		}
	}
}

void
connections_update_alpha (Connections* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				gdouble from_alpha = 0.0;
				GArray* _tmp3_;
				Connection* _tmp4_;
				Node* _tmp5_;
				Node* _tmp6_;
				gdouble _tmp7_;
				gdouble _tmp8_;
				gdouble to_alpha = 0.0;
				GArray* _tmp9_;
				Connection* _tmp10_;
				Node* _tmp11_;
				Node* _tmp12_;
				gdouble _tmp13_;
				gdouble _tmp14_;
				gdouble _tmp15_ = 0.0;
				GArray* _tmp16_;
				Connection* _tmp17_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_connections;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_connections;
				_tmp4_ = g_array_index (_tmp3_, Connection*, (guint) i);
				_tmp5_ = connection_get_from_node (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = node_get_alpha (_tmp6_);
				_tmp8_ = _tmp7_;
				from_alpha = _tmp8_;
				_tmp9_ = self->priv->_connections;
				_tmp10_ = g_array_index (_tmp9_, Connection*, (guint) i);
				_tmp11_ = connection_get_to_node (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = node_get_alpha (_tmp12_);
				_tmp14_ = _tmp13_;
				to_alpha = _tmp14_;
				if (from_alpha < to_alpha) {
					_tmp15_ = from_alpha;
				} else {
					_tmp15_ = to_alpha;
				}
				_tmp16_ = self->priv->_connections;
				_tmp17_ = g_array_index (_tmp16_, Connection*, (guint) i);
				connection_set_alpha (_tmp17_, _tmp15_);
			}
		}
	}
}

void
connections_add_extents (Connections* self,
                         gdouble* x1,
                         gdouble* y1,
                         gdouble* x2,
                         gdouble* y2)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				Connection* conn = NULL;
				GArray* _tmp3_;
				Connection* _tmp4_;
				Connection* _tmp5_;
				gdouble _tmp6_ = 0.0;
				Connection* _tmp7_;
				gdouble _tmp8_;
				gdouble _tmp9_;
				gdouble _tmp13_ = 0.0;
				Connection* _tmp14_;
				gdouble _tmp15_;
				gdouble _tmp16_;
				gdouble _tmp20_ = 0.0;
				Connection* _tmp21_;
				gdouble _tmp22_;
				gdouble _tmp23_;
				gdouble _tmp27_ = 0.0;
				Connection* _tmp28_;
				gdouble _tmp29_;
				gdouble _tmp30_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_connections;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_connections;
				_tmp4_ = g_array_index (_tmp3_, Connection*, (guint) i);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				conn = _tmp5_;
				_tmp7_ = conn;
				_tmp8_ = connection_get_extent_x1 (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_ < (*x1)) {
					Connection* _tmp10_;
					gdouble _tmp11_;
					gdouble _tmp12_;
					_tmp10_ = conn;
					_tmp11_ = connection_get_extent_x1 (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = _tmp12_;
				} else {
					_tmp6_ = *x1;
				}
				*x1 = _tmp6_;
				_tmp14_ = conn;
				_tmp15_ = connection_get_extent_y1 (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ < (*y1)) {
					Connection* _tmp17_;
					gdouble _tmp18_;
					gdouble _tmp19_;
					_tmp17_ = conn;
					_tmp18_ = connection_get_extent_y1 (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp13_ = _tmp19_;
				} else {
					_tmp13_ = *y1;
				}
				*y1 = _tmp13_;
				_tmp21_ = conn;
				_tmp22_ = connection_get_extent_x2 (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_ > (*x2)) {
					Connection* _tmp24_;
					gdouble _tmp25_;
					gdouble _tmp26_;
					_tmp24_ = conn;
					_tmp25_ = connection_get_extent_x2 (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp20_ = _tmp26_;
				} else {
					_tmp20_ = *x2;
				}
				*x2 = _tmp20_;
				_tmp28_ = conn;
				_tmp29_ = connection_get_extent_y2 (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ > (*y2)) {
					Connection* _tmp31_;
					gdouble _tmp32_;
					gdouble _tmp33_;
					_tmp31_ = conn;
					_tmp32_ = connection_get_extent_y2 (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp27_ = _tmp33_;
				} else {
					_tmp27_ = *y2;
				}
				*y2 = _tmp27_;
				_g_object_unref0 (conn);
			}
		}
	}
}

void
connections_draw_all (Connections* self,
                      cairo_t* ctx,
                      Theme* theme,
                      gboolean exporting)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = self->priv->_hide;
	if (_tmp0_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				Connection* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_connections;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = self->priv->_connections;
				_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
				connection_draw (_tmp5_, ctx, theme, exporting);
			}
		}
	}
}

GArray*
connections_get_connections (Connections* self)
{
	GArray* result;
	GArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connections;
	result = _tmp0_;
	return result;
}

gboolean
connections_get_hide (Connections* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hide;
	return result;
}

void
connections_set_hide (Connections* self,
                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_hide = value;
}

static void
value_connections_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_connections_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		connections_unref (value->data[0].v_pointer);
	}
}

static void
value_connections_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = connections_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_connections_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_connections_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Connections * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = connections_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_connections_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	Connections ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = connections_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_connections (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecConnections* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CONNECTIONS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_connections (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CONNECTIONS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_connections (GValue* value,
                       gpointer v_object)
{
	Connections * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CONNECTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CONNECTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		connections_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		connections_unref (old);
	}
}

void
value_take_connections (GValue* value,
                        gpointer v_object)
{
	Connections * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CONNECTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CONNECTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		connections_unref (old);
	}
}

static void
connections_class_init (ConnectionsClass * klass,
                        gpointer klass_data)
{
	connections_parent_class = g_type_class_peek_parent (klass);
	((ConnectionsClass *) klass)->finalize = connections_finalize;
	g_type_class_adjust_private_offset (klass, &Connections_private_offset);
}

static void
connections_instance_init (Connections * self,
                           gpointer klass)
{
	self->priv = connections_get_instance_private (self);
	self->priv->_hide = FALSE;
	self->ref_count = 1;
}

static void
connections_finalize (Connections * obj)
{
	Connections * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONNECTIONS, Connections);
	g_signal_handlers_destroy (self);
	_g_array_unref0 (self->priv->_connections);
}

static GType
connections_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_connections_init, value_connections_free_value, value_connections_copy_value, value_connections_peek_pointer, "p", value_connections_collect_value, "p", value_connections_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ConnectionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) connections_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Connections), 0, (GInstanceInitFunc) connections_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType connections_type_id;
	connections_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Connections", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Connections_private_offset = g_type_add_instance_private (connections_type_id, sizeof (ConnectionsPrivate));
	return connections_type_id;
}

GType
connections_get_type (void)
{
	static volatile gsize connections_type_id__once = 0;
	if (g_once_init_enter (&connections_type_id__once)) {
		GType connections_type_id;
		connections_type_id = connections_get_type_once ();
		g_once_init_leave (&connections_type_id__once, connections_type_id);
	}
	return connections_type_id__once;
}

gpointer
connections_ref (gpointer instance)
{
	Connections * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
connections_unref (gpointer instance)
{
	Connections * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CONNECTIONS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

