/*
  SPDX-FileCopyrightText: 2025-2026 Laurent Montel <montel@kde.org>

  SPDX-License-Identifier: GPL-2.0-or-later
*/

#pragma once
#include "textautogenerateollama_export.h"
#include <QObject>
class OllamaManager;
class TEXTAUTOGENERATEOLLAMA_EXPORT OllamaStartProcessJob : public QObject
{
    Q_OBJECT
public:
    explicit OllamaStartProcessJob(OllamaManager *manager, QObject *parent = nullptr);
    ~OllamaStartProcessJob() override;

    void start();

Q_SIGNALS:
    void ollamaStarted();
    void ollamaFailed(const QString &errorStr);

private:
    OllamaManager *const mOllamaManager;
};
