
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kjobwidgets_python.h"

// main header
#include "kuiserverjobtracker_wrapper.h"

// Wrappers providing overrides
#include "knotificationjobuidelegate_wrapper.h"
#include "kuiserverv2jobtracker_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <utility>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KUiServerJobTracker_Type = nullptr;
static PyTypeObject *Sbk_KUiServerJobTracker_TypeF(void)
{
    return _Sbk_KUiServerJobTracker_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KUiServerJobTrackerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KUiServerJobTrackerWrapper::KUiServerJobTrackerWrapper(::QObject * parent) : KUiServerJobTracker(parent)
{
}

void KUiServerJobTrackerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_childEvent("KUiServerJobTracker", funcName, gil, pyOverride, event);
}

void KUiServerJobTrackerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KUiServerJobTracker", funcName, gil, pyOverride, signal);
}

void KUiServerJobTrackerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_customEvent("KUiServerJobTracker", funcName, gil, pyOverride, event);
}

void KUiServerJobTrackerWrapper::description(::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2)
{
    static const char *funcName = "description";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::description(job, title, field1, field2);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_description("KUiServerJobTracker", funcName, gil, pyOverride, job, title, field1, field2);
}

void KUiServerJobTrackerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KUiServerJobTracker", funcName, gil, pyOverride, signal);
}

bool KUiServerJobTrackerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_event("KUiServerJobTracker", funcName, gil, pyOverride, event);
}

bool KUiServerJobTrackerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KNotificationJobUiDelegateWrapper::sbk_o_eventFilter("KUiServerJobTracker", funcName, gil, pyOverride, watched, event);
}

void KUiServerJobTrackerWrapper::finished(::KJob * job)
{
    static const char *funcName = "finished";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::finished(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KUiServerJobTracker", funcName, gil, pyOverride, job);
}

void KUiServerJobTrackerWrapper::infoMessage(::KJob * job, const ::QString & message)
{
    static const char *funcName = "infoMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::infoMessage(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KUiServerJobTracker", funcName, gil, pyOverride, job, message);
}

void KUiServerJobTrackerWrapper::percent(::KJob * job, unsigned long percent)
{
    static const char *funcName = "percent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::percent(job, percent);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_percent("KUiServerJobTracker", funcName, gil, pyOverride, job, percent);
}

void KUiServerJobTrackerWrapper::processedAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "processedAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::processedAmount(job, unit, amount);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_processedAmount("KUiServerJobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KUiServerJobTrackerWrapper::registerJob(::KJob * job)
{
    static const char *funcName = "registerJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::registerJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KUiServerJobTracker", funcName, gil, pyOverride, job);
}

void KUiServerJobTrackerWrapper::resumed(::KJob * job)
{
    static const char *funcName = "resumed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::resumed(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KUiServerJobTracker", funcName, gil, pyOverride, job);
}

void KUiServerJobTrackerWrapper::speed(::KJob * job, unsigned long value)
{
    static const char *funcName = "speed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::speed(job, value);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_percent("KUiServerJobTracker", funcName, gil, pyOverride, job, value);
}

void KUiServerJobTrackerWrapper::suspended(::KJob * job)
{
    static const char *funcName = "suspended";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::suspended(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KUiServerJobTracker", funcName, gil, pyOverride, job);
}

void KUiServerJobTrackerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_timerEvent("KUiServerJobTracker", funcName, gil, pyOverride, event);
}

void KUiServerJobTrackerWrapper::totalAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "totalAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::totalAmount(job, unit, amount);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_processedAmount("KUiServerJobTracker", funcName, gil, pyOverride, job, unit, amount);
}

void KUiServerJobTrackerWrapper::unregisterJob(::KJob * job)
{
    static const char *funcName = "unregisterJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::KUiServerJobTracker::unregisterJob(job);
    }
    KUiServerV2JobTrackerWrapper::sbk_o_finished("KUiServerJobTracker", funcName, gil, pyOverride, job);
}

void KUiServerJobTrackerWrapper::warning(::KJob * job, const ::QString & message)
{
    static const char *funcName = "warning";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KUiServerJobTracker_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::warning(job, message);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_slotWarning("KUiServerJobTracker", funcName, gil, pyOverride, job, message);
}

const QMetaObject *KUiServerJobTrackerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KUiServerJobTracker::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KUiServerJobTrackerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KUiServerJobTracker::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KUiServerJobTrackerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KUiServerJobTrackerWrapper *>(this));
    }
    return KUiServerJobTracker::qt_metacast(_clname);
}

KUiServerJobTrackerWrapper::~KUiServerJobTrackerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KUiServerJobTracker_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUiServerJobTracker_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUiServerJobTracker >()))
        return -1;

    KUiServerJobTrackerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KUiServerJobTracker", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KUiServerJobTracker::KUiServerJobTracker(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KUiServerJobTracker(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KUiServerJobTracker(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KUiServerJobTracker(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KUiServerJobTrackerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KUiServerJobTrackerWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KUiServerJobTracker >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KUiServerJobTrackerFunc_description(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "description", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkKJobWidgetsTypeConverters[SBK_KJobWidgets_std_pair_QString_QString_IDX], (pyArgs[3])))) {
        overloadId = 0; // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "description", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        std::pair<QString,QString> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        std::pair<QString,QString> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::description(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->description(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_finished(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::finished(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // finished(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "finished", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // finished(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::finished(cppArg0)
                : cppSelf->finished(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_infoMessage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "infoMessage", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::infoMessage(KJob*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // infoMessage(KJob*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "infoMessage", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // infoMessage(KJob*,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::infoMessage(cppArg0, cppArg1)
                : cppSelf->infoMessage(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_percent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "percent", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::percent(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // percent(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "percent", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // percent(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::percent(cppArg0, cppArg1)
                : cppSelf->percent(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_processedAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processedAmount", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::processedAmount(KJob*,KJob::Unit,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[2])))) {
        overloadId = 0; // processedAmount(KJob*,KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processedAmount", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KJob::Unit cppArg1{KJob::Bytes};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qulonglong cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processedAmount(KJob*,KJob::Unit,qulonglong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::processedAmount(cppArg0, cppArg1, cppArg2)
                : cppSelf->processedAmount(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_registerJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::registerJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // registerJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "registerJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::registerJob(cppArg0)
                : cppSelf->registerJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_resumed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::resumed(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // resumed(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resumed", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resumed(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::resumed(cppArg0)
                : cppSelf->resumed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_speed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "speed", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::speed(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // speed(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "speed", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // speed(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::speed(cppArg0, cppArg1)
                : cppSelf->speed(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_suspended(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::suspended(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // suspended(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "suspended", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // suspended(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::suspended(cppArg0)
                : cppSelf->suspended(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_totalAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "totalAmount", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::totalAmount(KJob*,KJob::Unit,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[2])))) {
        overloadId = 0; // totalAmount(KJob*,KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "totalAmount", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KJob::Unit cppArg1{KJob::Bytes};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qulonglong cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // totalAmount(KJob*,KJob::Unit,qulonglong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::totalAmount(cppArg0, cppArg1, cppArg2)
                : cppSelf->totalAmount(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KUiServerJobTrackerFunc_unregisterJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::unregisterJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KUiServerJobTracker::unregisterJob(cppArg0)
                : cppSelf->unregisterJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KUiServerJobTracker_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUiServerJobTracker_methods[] = {
    {"description", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_description), METH_VARARGS, nullptr},
    {"finished", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_finished), METH_O, nullptr},
    {"infoMessage", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_infoMessage), METH_VARARGS, nullptr},
    {"percent", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_percent), METH_VARARGS, nullptr},
    {"processedAmount", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_processedAmount), METH_VARARGS, nullptr},
    {"registerJob", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_registerJob), METH_O, nullptr},
    {"resumed", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_resumed), METH_O, nullptr},
    {"speed", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_speed), METH_VARARGS, nullptr},
    {"suspended", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_suspended), METH_O, nullptr},
    {"totalAmount", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_totalAmount), METH_VARARGS, nullptr},
    {"unregisterJob", reinterpret_cast<PyCFunction>(Sbk_KUiServerJobTrackerFunc_unregisterJob), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KUiServerJobTracker_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KUiServerJobTracker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KUiServerJobTrackerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KUiServerJobTracker_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUiServerJobTracker_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUiServerJobTracker_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KUiServerJobTracker_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUiServerJobTracker_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUiServerJobTracker_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUiServerJobTracker_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUiServerJobTracker_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUiServerJobTracker_spec = {
    "1:KJobWidgets.KUiServerJobTracker",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUiServerJobTracker_slots
};

} //extern "C"

static void *Sbk_KUiServerJobTracker_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KUiServerJobTracker *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KUiServerJobTracker_PythonToCpp_KUiServerJobTracker_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUiServerJobTracker_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KUiServerJobTracker_PythonToCpp_KUiServerJobTracker_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUiServerJobTracker_TypeF()))
        return KUiServerJobTracker_PythonToCpp_KUiServerJobTracker_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KUiServerJobTracker_PTR_CppToPython_KUiServerJobTracker(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KUiServerJobTracker *>(const_cast<void *>(cppIn)), Sbk_KUiServerJobTracker_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUiServerJobTracker_SignatureStrings[] = {
    "KJobWidgets.KUiServerJobTracker(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KJobWidgets.KUiServerJobTracker.description(self,job:KCoreAddons.KJob,title:QString,field1:std.pair[QString, QString],field2:std.pair[QString, QString])",
    "KJobWidgets.KUiServerJobTracker.finished(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KUiServerJobTracker.infoMessage(self,job:KCoreAddons.KJob,message:QString)",
    "KJobWidgets.KUiServerJobTracker.percent(self,job:KCoreAddons.KJob,percent:unsigned long)",
    "KJobWidgets.KUiServerJobTracker.processedAmount(self,job:KCoreAddons.KJob,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KJobWidgets.KUiServerJobTracker.registerJob(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KUiServerJobTracker.resumed(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KUiServerJobTracker.speed(self,job:KCoreAddons.KJob,value:unsigned long)",
    "KJobWidgets.KUiServerJobTracker.suspended(self,job:KCoreAddons.KJob)",
    "KJobWidgets.KUiServerJobTracker.totalAmount(self,job:KCoreAddons.KJob,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KJobWidgets.KUiServerJobTracker.unregisterJob(self,job:KCoreAddons.KJob)",
    nullptr}; // Sentinel
#else
static constexpr size_t KUiServerJobTracker_SignatureByteSize = 274;
static constexpr uint8_t KUiServerJobTracker_SignatureBytes[274] = {
    0x78, 0xda, 0xbd, 0x91, 0x41, 0x4b, 0xc4, 0x30, 0x10, 0x85, 0xef, 0xfe, 0x8a, 0x3d, 0x2a, 0x94,
    0x80, 0x1e, 0x3c, 0x04, 0x3c, 0x2c, 0xde, 0x2c, 0xa2, 0xa5, 0x2e, 0x1e, 0xc4, 0x43, 0xda, 0x4c,
    0xbb, 0xb3, 0xa6, 0x49, 0x9c, 0x4c, 0x16, 0xfc, 0xf7, 0x66, 0xb7, 0xbb, 0x27, 0x31, 0xad, 0x14,
    0xbc, 0x0d, 0x8f, 0x37, 0xdf, 0xbc, 0x99, 0x29, 0x1f, 0x5c, 0xf3, 0x8a, 0xba, 0x07, 0x0e, 0xa2,
    0xdc, 0x60, 0x0d, 0xb4, 0x07, 0x4a, 0xda, 0x0b, 0xa9, 0xf6, 0x03, 0xe8, 0x32, 0x80, 0xe9, 0x0a,
    0xaf, 0x08, 0x2c, 0xcb, 0xe7, 0xaf, 0x1a, 0x35, 0xdc, 0x8a, 0x8a, 0xef, 0x1d, 0x81, 0xa8, 0x9e,
    0x9a, 0x1d, 0xb4, 0x7c, 0x67, 0xa3, 0x31, 0x9e, 0xe9, 0xea, 0xa2, 0xcc, 0xb3, 0x84, 0x86, 0xd0,
    0x12, 0x7a, 0x46, 0x67, 0x47, 0xee, 0xce, 0x35, 0xb2, 0x3c, 0xb0, 0xd6, 0x5a, 0x3b, 0x9b, 0x9a,
    0x92, 0xb9, 0x60, 0x64, 0x03, 0xb2, 0xaa, 0x99, 0xd0, 0xf6, 0x45, 0x87, 0x60, 0xf4, 0xb5, 0x0c,
    0xac, 0x85, 0x57, 0x48, 0x6f, 0x67, 0x7d, 0x75, 0x2a, 0xde, 0x47, 0xc7, 0x4d, 0xc6, 0x31, 0x1d,
    0xac, 0x43, 0x8b, 0x61, 0x0b, 0xfa, 0xf7, 0x54, 0xd3, 0x0c, 0xb4, 0x9d, 0x7b, 0x84, 0x10, 0x54,
    0x0f, 0x99, 0xe5, 0x86, 0xd1, 0x71, 0x5e, 0x6f, 0x1a, 0xeb, 0x81, 0xda, 0x74, 0xfb, 0x0c, 0xf2,
    0xe4, 0x90, 0xd1, 0x06, 0xec, 0x2d, 0xe8, 0x95, 0x71, 0xb3, 0xc0, 0xe4, 0xda, 0x14, 0x06, 0xf4,
    0x7a, 0x70, 0x31, 0x3b, 0x20, 0x5a, 0xe4, 0x1f, 0xaa, 0xd8, 0x24, 0xb5, 0x50, 0xc7, 0x5e, 0xf9,
    0x19, 0x0f, 0x33, 0xe7, 0xcd, 0x25, 0xe8, 0x31, 0xf0, 0x51, 0x5a, 0x72, 0x6e, 0x82, 0x10, 0x87,
    0x65, 0x1f, 0x0b, 0x1e, 0x72, 0x80, 0x62, 0xaf, 0x4c, 0x84, 0xbf, 0x9e, 0x35, 0xc4, 0x84, 0xb5,
    0x7a, 0x59, 0x32, 0x76, 0xac, 0xcc, 0x3f, 0xff, 0x25, 0xda, 0x99, 0x9f, 0xf9, 0x06, 0xea, 0x29,
    0x8a, 0x6a
};
#endif

PyTypeObject *init_KUiServerJobTracker(PyObject *module)
{
    if (SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX].type != nullptr)
        return SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX].type;

    Shiboken::AutoDecRef Sbk_KUiServerJobTracker_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]))));

    _Sbk_KUiServerJobTracker_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KUiServerJobTracker",
        "KUiServerJobTracker*",
        &Sbk_KUiServerJobTracker_spec,
        &Shiboken::callCppDestructor< KUiServerJobTracker >,
        Sbk_KUiServerJobTracker_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KUiServerJobTracker_Type; // references _Sbk_KUiServerJobTracker_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUiServerJobTracker_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUiServerJobTracker_SignatureBytes, KUiServerJobTracker_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUiServerJobTracker_PropertyStrings);
    SbkKJobWidgetsTypeStructs[SBK_KUiServerJobTracker_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KUiServerJobTracker_PythonToCpp_KUiServerJobTracker_PTR,
        is_KUiServerJobTracker_PythonToCpp_KUiServerJobTracker_PTR_Convertible,
        KUiServerJobTracker_PTR_CppToPython_KUiServerJobTracker);

    Shiboken::Conversions::registerConverterName(converter, "KUiServerJobTracker");
    Shiboken::Conversions::registerConverterName(converter, "KUiServerJobTracker*");
    Shiboken::Conversions::registerConverterName(converter, "KUiServerJobTracker&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUiServerJobTracker).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KUiServerJobTrackerWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KUiServerJobTracker_TypeF(), &Sbk_KUiServerJobTracker_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KUiServerJobTracker::staticMetaObject, sizeof(KUiServerJobTrackerWrapper));

    return pyType;
}
