{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A Broadway based renderer.
-- 
-- See t'GI.Gsk.Objects.Renderer.Renderer'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.BroadwayRenderer
    ( 

-- * Exported types
    BroadwayRenderer(..)                    ,
    IsBroadwayRenderer                      ,
    toBroadwayRenderer                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isRealized]("GI.Gsk.Objects.Renderer#g:method:isRealized"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [realize]("GI.Gsk.Objects.Renderer#g:method:realize"), [realizeForDisplay]("GI.Gsk.Objects.Renderer#g:method:realizeForDisplay"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [render]("GI.Gsk.Objects.Renderer#g:method:render"), [renderTexture]("GI.Gsk.Objects.Renderer#g:method:renderTexture"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unrealize]("GI.Gsk.Objects.Renderer#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gsk.Objects.Renderer#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveBroadwayRendererMethod           ,
#endif

-- ** new #method:new#

    broadwayRendererNew                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#endif

-- | Memory-managed wrapper type.
newtype BroadwayRenderer = BroadwayRenderer (SP.ManagedPtr BroadwayRenderer)
    deriving (Eq)

instance SP.ManagedPtrNewtype BroadwayRenderer where
    toManagedPtr (BroadwayRenderer p) = p

foreign import ccall "gsk_broadway_renderer_get_type"
    c_gsk_broadway_renderer_get_type :: IO B.Types.GType

instance B.Types.TypedObject BroadwayRenderer where
    glibType = c_gsk_broadway_renderer_get_type

instance B.Types.GObject BroadwayRenderer

-- | Type class for types which can be safely cast to t'BroadwayRenderer', for instance with `toBroadwayRenderer`.
class (SP.GObject o, O.IsDescendantOf BroadwayRenderer o) => IsBroadwayRenderer o
instance (SP.GObject o, O.IsDescendantOf BroadwayRenderer o) => IsBroadwayRenderer o

instance O.HasParentTypes BroadwayRenderer
type instance O.ParentTypes BroadwayRenderer = '[Gsk.Renderer.Renderer, GObject.Object.Object]

-- | Cast to t'BroadwayRenderer', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toBroadwayRenderer :: (MIO.MonadIO m, IsBroadwayRenderer o) => o -> m BroadwayRenderer
toBroadwayRenderer = MIO.liftIO . B.ManagedPtr.unsafeCastTo BroadwayRenderer

-- | Convert t'BroadwayRenderer' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe BroadwayRenderer) where
    gvalueGType_ = c_gsk_broadway_renderer_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr BroadwayRenderer)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr BroadwayRenderer)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject BroadwayRenderer ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveBroadwayRendererMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBroadwayRendererMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveBroadwayRendererMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveBroadwayRendererMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveBroadwayRendererMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveBroadwayRendererMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveBroadwayRendererMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveBroadwayRendererMethod "isRealized" o = Gsk.Renderer.RendererIsRealizedMethodInfo
    ResolveBroadwayRendererMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveBroadwayRendererMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveBroadwayRendererMethod "realize" o = Gsk.Renderer.RendererRealizeMethodInfo
    ResolveBroadwayRendererMethod "realizeForDisplay" o = Gsk.Renderer.RendererRealizeForDisplayMethodInfo
    ResolveBroadwayRendererMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveBroadwayRendererMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveBroadwayRendererMethod "render" o = Gsk.Renderer.RendererRenderMethodInfo
    ResolveBroadwayRendererMethod "renderTexture" o = Gsk.Renderer.RendererRenderTextureMethodInfo
    ResolveBroadwayRendererMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveBroadwayRendererMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveBroadwayRendererMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveBroadwayRendererMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveBroadwayRendererMethod "unrealize" o = Gsk.Renderer.RendererUnrealizeMethodInfo
    ResolveBroadwayRendererMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveBroadwayRendererMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveBroadwayRendererMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveBroadwayRendererMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveBroadwayRendererMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveBroadwayRendererMethod "getSurface" o = Gsk.Renderer.RendererGetSurfaceMethodInfo
    ResolveBroadwayRendererMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveBroadwayRendererMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveBroadwayRendererMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveBroadwayRendererMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBroadwayRendererMethod t BroadwayRenderer, O.OverloadedMethod info BroadwayRenderer p) => OL.IsLabel t (BroadwayRenderer -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBroadwayRendererMethod t BroadwayRenderer, O.OverloadedMethod info BroadwayRenderer p, R.HasField t BroadwayRenderer p) => R.HasField t BroadwayRenderer p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBroadwayRendererMethod t BroadwayRenderer, O.OverloadedMethodInfo info BroadwayRenderer) => OL.IsLabel t (O.MethodProxy info BroadwayRenderer) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BroadwayRenderer
type instance O.AttributeList BroadwayRenderer = BroadwayRendererAttributeList
type BroadwayRendererAttributeList = ('[ '("realized", Gsk.Renderer.RendererRealizedPropertyInfo), '("surface", Gsk.Renderer.RendererSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList BroadwayRenderer = BroadwayRendererSignalList
type BroadwayRendererSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method BroadwayRenderer::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gsk" , name = "BroadwayRenderer" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_broadway_renderer_new" gsk_broadway_renderer_new :: 
    IO (Ptr BroadwayRenderer)

{-# DEPRECATED broadwayRendererNew ["(Since version 4.20)","Broadway will be retired in GTK 5"] #-}
-- | Creates a new Broadway renderer.
-- 
-- The Broadway renderer is the default renderer for the broadway backend.
-- It will only work with broadway surfaces, otherwise it will fail the
-- call to 'GI.Gsk.Objects.Renderer.rendererRealize'.
-- 
-- This function is only available when GTK was compiled with Broadway
-- support.
broadwayRendererNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m BroadwayRenderer
    -- ^ __Returns:__ a new Broadway renderer.
broadwayRendererNew  = liftIO $ do
    result <- gsk_broadway_renderer_new
    checkUnexpectedReturnNULL "broadwayRendererNew" result
    result' <- (wrapObject BroadwayRenderer) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


