{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.Gdk.Objects.Device.Device' object represents a single input device, such
-- as a keyboard, a mouse, a touchpad, etc.
-- 
-- See the t'GI.Gdk.Objects.DeviceManager.DeviceManager' documentation for more information
-- about the various kinds of master and slave devices, and their
-- relationships.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Device
    ( 

-- * Exported types
    Device(..)                              ,
    IsDevice                                ,
    toDevice                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grab]("GI.Gdk.Objects.Device#g:method:grab"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listAxes]("GI.Gdk.Objects.Device#g:method:listAxes"), [listSlaveDevices]("GI.Gdk.Objects.Device#g:method:listSlaveDevices"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [ungrab]("GI.Gdk.Objects.Device#g:method:ungrab"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [warp]("GI.Gdk.Objects.Device#g:method:warp"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAssociatedDevice]("GI.Gdk.Objects.Device#g:method:getAssociatedDevice"), [getAxes]("GI.Gdk.Objects.Device#g:method:getAxes"), [getAxisUse]("GI.Gdk.Objects.Device#g:method:getAxisUse"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDeviceType]("GI.Gdk.Objects.Device#g:method:getDeviceType"), [getDisplay]("GI.Gdk.Objects.Device#g:method:getDisplay"), [getHasCursor]("GI.Gdk.Objects.Device#g:method:getHasCursor"), [getKey]("GI.Gdk.Objects.Device#g:method:getKey"), [getLastEventWindow]("GI.Gdk.Objects.Device#g:method:getLastEventWindow"), [getMode]("GI.Gdk.Objects.Device#g:method:getMode"), [getNAxes]("GI.Gdk.Objects.Device#g:method:getNAxes"), [getNKeys]("GI.Gdk.Objects.Device#g:method:getNKeys"), [getName]("GI.Gdk.Objects.Device#g:method:getName"), [getPosition]("GI.Gdk.Objects.Device#g:method:getPosition"), [getPositionDouble]("GI.Gdk.Objects.Device#g:method:getPositionDouble"), [getProductId]("GI.Gdk.Objects.Device#g:method:getProductId"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSeat]("GI.Gdk.Objects.Device#g:method:getSeat"), [getSource]("GI.Gdk.Objects.Device#g:method:getSource"), [getVendorId]("GI.Gdk.Objects.Device#g:method:getVendorId"), [getWindowAtPosition]("GI.Gdk.Objects.Device#g:method:getWindowAtPosition"), [getWindowAtPositionDouble]("GI.Gdk.Objects.Device#g:method:getWindowAtPositionDouble").
-- 
-- ==== Setters
-- [setAxisUse]("GI.Gdk.Objects.Device#g:method:setAxisUse"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setKey]("GI.Gdk.Objects.Device#g:method:setKey"), [setMode]("GI.Gdk.Objects.Device#g:method:setMode"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDeviceMethod                     ,
#endif

-- ** getAssociatedDevice #method:getAssociatedDevice#

#if defined(ENABLE_OVERLOADING)
    DeviceGetAssociatedDeviceMethodInfo     ,
#endif
    deviceGetAssociatedDevice               ,


-- ** getAxes #method:getAxes#

#if defined(ENABLE_OVERLOADING)
    DeviceGetAxesMethodInfo                 ,
#endif
    deviceGetAxes                           ,


-- ** getAxisUse #method:getAxisUse#

#if defined(ENABLE_OVERLOADING)
    DeviceGetAxisUseMethodInfo              ,
#endif
    deviceGetAxisUse                        ,


-- ** getDeviceType #method:getDeviceType#

#if defined(ENABLE_OVERLOADING)
    DeviceGetDeviceTypeMethodInfo           ,
#endif
    deviceGetDeviceType                     ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    DeviceGetDisplayMethodInfo              ,
#endif
    deviceGetDisplay                        ,


-- ** getHasCursor #method:getHasCursor#

#if defined(ENABLE_OVERLOADING)
    DeviceGetHasCursorMethodInfo            ,
#endif
    deviceGetHasCursor                      ,


-- ** getKey #method:getKey#

#if defined(ENABLE_OVERLOADING)
    DeviceGetKeyMethodInfo                  ,
#endif
    deviceGetKey                            ,


-- ** getLastEventWindow #method:getLastEventWindow#

#if defined(ENABLE_OVERLOADING)
    DeviceGetLastEventWindowMethodInfo      ,
#endif
    deviceGetLastEventWindow                ,


-- ** getMode #method:getMode#

#if defined(ENABLE_OVERLOADING)
    DeviceGetModeMethodInfo                 ,
#endif
    deviceGetMode                           ,


-- ** getNAxes #method:getNAxes#

#if defined(ENABLE_OVERLOADING)
    DeviceGetNAxesMethodInfo                ,
#endif
    deviceGetNAxes                          ,


-- ** getNKeys #method:getNKeys#

#if defined(ENABLE_OVERLOADING)
    DeviceGetNKeysMethodInfo                ,
#endif
    deviceGetNKeys                          ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    DeviceGetNameMethodInfo                 ,
#endif
    deviceGetName                           ,


-- ** getPosition #method:getPosition#

#if defined(ENABLE_OVERLOADING)
    DeviceGetPositionMethodInfo             ,
#endif
    deviceGetPosition                       ,


-- ** getPositionDouble #method:getPositionDouble#

#if defined(ENABLE_OVERLOADING)
    DeviceGetPositionDoubleMethodInfo       ,
#endif
    deviceGetPositionDouble                 ,


-- ** getProductId #method:getProductId#

#if defined(ENABLE_OVERLOADING)
    DeviceGetProductIdMethodInfo            ,
#endif
    deviceGetProductId                      ,


-- ** getSeat #method:getSeat#

#if defined(ENABLE_OVERLOADING)
    DeviceGetSeatMethodInfo                 ,
#endif
    deviceGetSeat                           ,


-- ** getSource #method:getSource#

#if defined(ENABLE_OVERLOADING)
    DeviceGetSourceMethodInfo               ,
#endif
    deviceGetSource                         ,


-- ** getVendorId #method:getVendorId#

#if defined(ENABLE_OVERLOADING)
    DeviceGetVendorIdMethodInfo             ,
#endif
    deviceGetVendorId                       ,


-- ** getWindowAtPosition #method:getWindowAtPosition#

#if defined(ENABLE_OVERLOADING)
    DeviceGetWindowAtPositionMethodInfo     ,
#endif
    deviceGetWindowAtPosition               ,


-- ** getWindowAtPositionDouble #method:getWindowAtPositionDouble#

#if defined(ENABLE_OVERLOADING)
    DeviceGetWindowAtPositionDoubleMethodInfo,
#endif
    deviceGetWindowAtPositionDouble         ,


-- ** grab #method:grab#

#if defined(ENABLE_OVERLOADING)
    DeviceGrabMethodInfo                    ,
#endif
    deviceGrab                              ,


-- ** grabInfoLibgtkOnly #method:grabInfoLibgtkOnly#

    deviceGrabInfoLibgtkOnly                ,


-- ** listAxes #method:listAxes#

#if defined(ENABLE_OVERLOADING)
    DeviceListAxesMethodInfo                ,
#endif
    deviceListAxes                          ,


-- ** listSlaveDevices #method:listSlaveDevices#

#if defined(ENABLE_OVERLOADING)
    DeviceListSlaveDevicesMethodInfo        ,
#endif
    deviceListSlaveDevices                  ,


-- ** setAxisUse #method:setAxisUse#

#if defined(ENABLE_OVERLOADING)
    DeviceSetAxisUseMethodInfo              ,
#endif
    deviceSetAxisUse                        ,


-- ** setKey #method:setKey#

#if defined(ENABLE_OVERLOADING)
    DeviceSetKeyMethodInfo                  ,
#endif
    deviceSetKey                            ,


-- ** setMode #method:setMode#

#if defined(ENABLE_OVERLOADING)
    DeviceSetModeMethodInfo                 ,
#endif
    deviceSetMode                           ,


-- ** ungrab #method:ungrab#

#if defined(ENABLE_OVERLOADING)
    DeviceUngrabMethodInfo                  ,
#endif
    deviceUngrab                            ,


-- ** warp #method:warp#

#if defined(ENABLE_OVERLOADING)
    DeviceWarpMethodInfo                    ,
#endif
    deviceWarp                              ,




 -- * Properties


-- ** associatedDevice #attr:associatedDevice#
-- | Associated pointer or keyboard with this device, if any. Devices of type @/GDK_DEVICE_TYPE_MASTER/@
-- always come in keyboard\/pointer pairs. Other device types will have a 'P.Nothing' associated device.
-- 
-- /Since: 3.0/

#if defined(ENABLE_OVERLOADING)
    DeviceAssociatedDevicePropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceAssociatedDevice                  ,
#endif
    getDeviceAssociatedDevice               ,


-- ** axes #attr:axes#
-- | The axes currently available for this device.
-- 
-- /Since: 3.22/

#if defined(ENABLE_OVERLOADING)
    DeviceAxesPropertyInfo                  ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceAxes                              ,
#endif
    getDeviceAxes                           ,


-- ** deviceManager #attr:deviceManager#
-- | The t'GI.Gdk.Objects.DeviceManager.DeviceManager' the t'GI.Gdk.Objects.Device.Device' pertains to.
-- 
-- /Since: 3.0/

#if defined(ENABLE_OVERLOADING)
    DeviceDeviceManagerPropertyInfo         ,
#endif
    constructDeviceDeviceManager            ,
#if defined(ENABLE_OVERLOADING)
    deviceDeviceManager                     ,
#endif
    getDeviceDeviceManager                  ,


-- ** display #attr:display#
-- | The t'GI.Gdk.Objects.Display.Display' the t'GI.Gdk.Objects.Device.Device' pertains to.
-- 
-- /Since: 3.0/

#if defined(ENABLE_OVERLOADING)
    DeviceDisplayPropertyInfo               ,
#endif
    constructDeviceDisplay                  ,
#if defined(ENABLE_OVERLOADING)
    deviceDisplay                           ,
#endif
    getDeviceDisplay                        ,


-- ** hasCursor #attr:hasCursor#
-- | Whether the device is represented by a cursor on the screen. Devices of type
-- 'GI.Gdk.Enums.DeviceTypeMaster' will have 'P.True' here.
-- 
-- /Since: 3.0/

#if defined(ENABLE_OVERLOADING)
    DeviceHasCursorPropertyInfo             ,
#endif
    constructDeviceHasCursor                ,
#if defined(ENABLE_OVERLOADING)
    deviceHasCursor                         ,
#endif
    getDeviceHasCursor                      ,


-- ** inputMode #attr:inputMode#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    DeviceInputModePropertyInfo             ,
#endif
    constructDeviceInputMode                ,
#if defined(ENABLE_OVERLOADING)
    deviceInputMode                         ,
#endif
    getDeviceInputMode                      ,
    setDeviceInputMode                      ,


-- ** inputSource #attr:inputSource#
-- | Source type for the device.
-- 
-- /Since: 3.0/

#if defined(ENABLE_OVERLOADING)
    DeviceInputSourcePropertyInfo           ,
#endif
    constructDeviceInputSource              ,
#if defined(ENABLE_OVERLOADING)
    deviceInputSource                       ,
#endif
    getDeviceInputSource                    ,


-- ** nAxes #attr:nAxes#
-- | Number of axes in the device.
-- 
-- /Since: 3.0/

#if defined(ENABLE_OVERLOADING)
    DeviceNAxesPropertyInfo                 ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceNAxes                             ,
#endif
    getDeviceNAxes                          ,


-- ** name #attr:name#
-- | The device name.
-- 
-- /Since: 3.0/

#if defined(ENABLE_OVERLOADING)
    DeviceNamePropertyInfo                  ,
#endif
    constructDeviceName                     ,
#if defined(ENABLE_OVERLOADING)
    deviceName                              ,
#endif
    getDeviceName                           ,


-- ** numTouches #attr:numTouches#
-- | The maximal number of concurrent touches on a touch device.
-- Will be 0 if the device is not a touch device or if the number
-- of touches is unknown.
-- 
-- /Since: 3.20/

#if defined(ENABLE_OVERLOADING)
    DeviceNumTouchesPropertyInfo            ,
#endif
    constructDeviceNumTouches               ,
#if defined(ENABLE_OVERLOADING)
    deviceNumTouches                        ,
#endif
    getDeviceNumTouches                     ,


-- ** productId #attr:productId#
-- | Product ID of this device, see 'GI.Gdk.Objects.Device.deviceGetProductId'.
-- 
-- /Since: 3.16/

#if defined(ENABLE_OVERLOADING)
    DeviceProductIdPropertyInfo             ,
#endif
    constructDeviceProductId                ,
#if defined(ENABLE_OVERLOADING)
    deviceProductId                         ,
#endif
    getDeviceProductId                      ,


-- ** seat #attr:seat#
-- | t'GI.Gdk.Objects.Seat.Seat' of this device.
-- 
-- /Since: 3.20/

#if defined(ENABLE_OVERLOADING)
    DeviceSeatPropertyInfo                  ,
#endif
    clearDeviceSeat                         ,
    constructDeviceSeat                     ,
#if defined(ENABLE_OVERLOADING)
    deviceSeat                              ,
#endif
    getDeviceSeat                           ,
    setDeviceSeat                           ,


-- ** tool #attr:tool#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    DeviceToolPropertyInfo                  ,
#endif
#if defined(ENABLE_OVERLOADING)
    deviceTool                              ,
#endif
    getDeviceTool                           ,


-- ** type #attr:type#
-- | Device role in the device manager.
-- 
-- /Since: 3.0/

#if defined(ENABLE_OVERLOADING)
    DeviceTypePropertyInfo                  ,
#endif
    constructDeviceType                     ,
#if defined(ENABLE_OVERLOADING)
    deviceType                              ,
#endif
    getDeviceType                           ,


-- ** vendorId #attr:vendorId#
-- | Vendor ID of this device, see 'GI.Gdk.Objects.Device.deviceGetVendorId'.
-- 
-- /Since: 3.16/

#if defined(ENABLE_OVERLOADING)
    DeviceVendorIdPropertyInfo              ,
#endif
    constructDeviceVendorId                 ,
#if defined(ENABLE_OVERLOADING)
    deviceVendorId                          ,
#endif
    getDeviceVendorId                       ,




 -- * Signals


-- ** changed #signal:changed#

    DeviceChangedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    DeviceChangedSignalInfo                 ,
#endif
    afterDeviceChanged                      ,
    onDeviceChanged                         ,


-- ** toolChanged #signal:toolChanged#

    DeviceToolChangedCallback               ,
#if defined(ENABLE_OVERLOADING)
    DeviceToolChangedSignalInfo             ,
#endif
    afterDeviceToolChanged                  ,
    onDeviceToolChanged                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom

#endif

-- | Memory-managed wrapper type.
newtype Device = Device (SP.ManagedPtr Device)
    deriving (Eq)

instance SP.ManagedPtrNewtype Device where
    toManagedPtr (Device p) = p

foreign import ccall "gdk_device_get_type"
    c_gdk_device_get_type :: IO B.Types.GType

instance B.Types.TypedObject Device where
    glibType = c_gdk_device_get_type

instance B.Types.GObject Device

-- | Type class for types which can be safely cast to t'Device', for instance with `toDevice`.
class (SP.GObject o, O.IsDescendantOf Device o) => IsDevice o
instance (SP.GObject o, O.IsDescendantOf Device o) => IsDevice o

instance O.HasParentTypes Device
type instance O.ParentTypes Device = '[GObject.Object.Object]

-- | Cast to t'Device', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDevice :: (MIO.MonadIO m, IsDevice o) => o -> m Device
toDevice = MIO.liftIO . B.ManagedPtr.unsafeCastTo Device

-- | Convert t'Device' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Device) where
    gvalueGType_ = c_gdk_device_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Device)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Device)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Device ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDeviceMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDeviceMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDeviceMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDeviceMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDeviceMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDeviceMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDeviceMethod "grab" o = DeviceGrabMethodInfo
    ResolveDeviceMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDeviceMethod "listAxes" o = DeviceListAxesMethodInfo
    ResolveDeviceMethod "listSlaveDevices" o = DeviceListSlaveDevicesMethodInfo
    ResolveDeviceMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDeviceMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDeviceMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDeviceMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDeviceMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDeviceMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDeviceMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDeviceMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDeviceMethod "ungrab" o = DeviceUngrabMethodInfo
    ResolveDeviceMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDeviceMethod "warp" o = DeviceWarpMethodInfo
    ResolveDeviceMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDeviceMethod "getAssociatedDevice" o = DeviceGetAssociatedDeviceMethodInfo
    ResolveDeviceMethod "getAxes" o = DeviceGetAxesMethodInfo
    ResolveDeviceMethod "getAxisUse" o = DeviceGetAxisUseMethodInfo
    ResolveDeviceMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDeviceMethod "getDeviceType" o = DeviceGetDeviceTypeMethodInfo
    ResolveDeviceMethod "getDisplay" o = DeviceGetDisplayMethodInfo
    ResolveDeviceMethod "getHasCursor" o = DeviceGetHasCursorMethodInfo
    ResolveDeviceMethod "getKey" o = DeviceGetKeyMethodInfo
    ResolveDeviceMethod "getLastEventWindow" o = DeviceGetLastEventWindowMethodInfo
    ResolveDeviceMethod "getMode" o = DeviceGetModeMethodInfo
    ResolveDeviceMethod "getNAxes" o = DeviceGetNAxesMethodInfo
    ResolveDeviceMethod "getNKeys" o = DeviceGetNKeysMethodInfo
    ResolveDeviceMethod "getName" o = DeviceGetNameMethodInfo
    ResolveDeviceMethod "getPosition" o = DeviceGetPositionMethodInfo
    ResolveDeviceMethod "getPositionDouble" o = DeviceGetPositionDoubleMethodInfo
    ResolveDeviceMethod "getProductId" o = DeviceGetProductIdMethodInfo
    ResolveDeviceMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDeviceMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDeviceMethod "getSeat" o = DeviceGetSeatMethodInfo
    ResolveDeviceMethod "getSource" o = DeviceGetSourceMethodInfo
    ResolveDeviceMethod "getVendorId" o = DeviceGetVendorIdMethodInfo
    ResolveDeviceMethod "getWindowAtPosition" o = DeviceGetWindowAtPositionMethodInfo
    ResolveDeviceMethod "getWindowAtPositionDouble" o = DeviceGetWindowAtPositionDoubleMethodInfo
    ResolveDeviceMethod "setAxisUse" o = DeviceSetAxisUseMethodInfo
    ResolveDeviceMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDeviceMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDeviceMethod "setKey" o = DeviceSetKeyMethodInfo
    ResolveDeviceMethod "setMode" o = DeviceSetModeMethodInfo
    ResolveDeviceMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDeviceMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDeviceMethod t Device, O.OverloadedMethod info Device p) => OL.IsLabel t (Device -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDeviceMethod t Device, O.OverloadedMethod info Device p, R.HasField t Device p) => R.HasField t Device p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDeviceMethod t Device, O.OverloadedMethodInfo info Device) => OL.IsLabel t (O.MethodProxy info Device) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Device::changed
-- | The [changed](#g:signal:changed) signal is emitted either when the t'GI.Gdk.Objects.Device.Device'
-- has changed the number of either axes or keys. For example
-- In X this will normally happen when the slave device routing
-- events through the master device changes (for example, user
-- switches from the USB mouse to a tablet), in that case the
-- master device will change to reflect the new slave device
-- axes and keys.
type DeviceChangedCallback =
    IO ()

type C_DeviceChangedCallback =
    Ptr Device ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DeviceChangedCallback`.
foreign import ccall "wrapper"
    mk_DeviceChangedCallback :: C_DeviceChangedCallback -> IO (FunPtr C_DeviceChangedCallback)

wrap_DeviceChangedCallback :: 
    GObject a => (a -> DeviceChangedCallback) ->
    C_DeviceChangedCallback
wrap_DeviceChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' device #changed callback
-- @
-- 
-- 
onDeviceChanged :: (IsDevice a, MonadIO m) => a -> ((?self :: a) => DeviceChangedCallback) -> m SignalHandlerId
onDeviceChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DeviceChangedCallback wrapped
    wrapped'' <- mk_DeviceChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' device #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDeviceChanged :: (IsDevice a, MonadIO m) => a -> ((?self :: a) => DeviceChangedCallback) -> m SignalHandlerId
afterDeviceChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DeviceChangedCallback wrapped
    wrapped'' <- mk_DeviceChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DeviceChangedSignalInfo
instance SignalInfo DeviceChangedSignalInfo where
    type HaskellCallbackType DeviceChangedSignalInfo = DeviceChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DeviceChangedCallback cb
        cb'' <- mk_DeviceChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:signal:changed"})

#endif

-- signal Device::tool-changed
-- | The [toolChanged](#g:signal:toolChanged) signal is emitted on pen\/eraser
-- @/GdkDevices/@ whenever tools enter or leave proximity.
-- 
-- /Since: 3.22/
type DeviceToolChangedCallback =
    Gdk.DeviceTool.DeviceTool
    -- ^ /@tool@/: The new current tool
    -> IO ()

type C_DeviceToolChangedCallback =
    Ptr Device ->                           -- object
    Ptr Gdk.DeviceTool.DeviceTool ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DeviceToolChangedCallback`.
foreign import ccall "wrapper"
    mk_DeviceToolChangedCallback :: C_DeviceToolChangedCallback -> IO (FunPtr C_DeviceToolChangedCallback)

wrap_DeviceToolChangedCallback :: 
    GObject a => (a -> DeviceToolChangedCallback) ->
    C_DeviceToolChangedCallback
wrap_DeviceToolChangedCallback gi'cb gi'selfPtr tool _ = do
    tool' <- (newObject Gdk.DeviceTool.DeviceTool) tool
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  tool'


-- | Connect a signal handler for the [toolChanged](#signal:toolChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' device #toolChanged callback
-- @
-- 
-- 
onDeviceToolChanged :: (IsDevice a, MonadIO m) => a -> ((?self :: a) => DeviceToolChangedCallback) -> m SignalHandlerId
onDeviceToolChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DeviceToolChangedCallback wrapped
    wrapped'' <- mk_DeviceToolChangedCallback wrapped'
    connectSignalFunPtr obj "tool-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toolChanged](#signal:toolChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' device #toolChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDeviceToolChanged :: (IsDevice a, MonadIO m) => a -> ((?self :: a) => DeviceToolChangedCallback) -> m SignalHandlerId
afterDeviceToolChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DeviceToolChangedCallback wrapped
    wrapped'' <- mk_DeviceToolChangedCallback wrapped'
    connectSignalFunPtr obj "tool-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DeviceToolChangedSignalInfo
instance SignalInfo DeviceToolChangedSignalInfo where
    type HaskellCallbackType DeviceToolChangedSignalInfo = DeviceToolChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DeviceToolChangedCallback cb
        cb'' <- mk_DeviceToolChangedCallback cb'
        connectSignalFunPtr obj "tool-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device::tool-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:signal:toolChanged"})

#endif

-- VVV Prop "associated-device"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Device"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@associated-device@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #associatedDevice
-- @
getDeviceAssociatedDevice :: (MonadIO m, IsDevice o) => o -> m (Maybe Device)
getDeviceAssociatedDevice obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "associated-device" Device

#if defined(ENABLE_OVERLOADING)
data DeviceAssociatedDevicePropertyInfo
instance AttrInfo DeviceAssociatedDevicePropertyInfo where
    type AttrAllowedOps DeviceAssociatedDevicePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceAssociatedDevicePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceAssociatedDevicePropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceAssociatedDevicePropertyInfo = (~) ()
    type AttrTransferType DeviceAssociatedDevicePropertyInfo = ()
    type AttrGetType DeviceAssociatedDevicePropertyInfo = (Maybe Device)
    type AttrLabel DeviceAssociatedDevicePropertyInfo = "associated-device"
    type AttrOrigin DeviceAssociatedDevicePropertyInfo = Device
    attrGet = getDeviceAssociatedDevice
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.associatedDevice"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:associatedDevice"
        })
#endif

-- VVV Prop "axes"
   -- Type: TInterface (Name {namespace = "Gdk", name = "AxisFlags"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@axes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #axes
-- @
getDeviceAxes :: (MonadIO m, IsDevice o) => o -> m [Gdk.Flags.AxisFlags]
getDeviceAxes obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "axes"

#if defined(ENABLE_OVERLOADING)
data DeviceAxesPropertyInfo
instance AttrInfo DeviceAxesPropertyInfo where
    type AttrAllowedOps DeviceAxesPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceAxesPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceAxesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceAxesPropertyInfo = (~) ()
    type AttrTransferType DeviceAxesPropertyInfo = ()
    type AttrGetType DeviceAxesPropertyInfo = [Gdk.Flags.AxisFlags]
    type AttrLabel DeviceAxesPropertyInfo = "axes"
    type AttrOrigin DeviceAxesPropertyInfo = Device
    attrGet = getDeviceAxes
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.axes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:axes"
        })
#endif

-- VVV Prop "device-manager"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DeviceManager"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@device-manager@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #deviceManager
-- @
getDeviceDeviceManager :: (MonadIO m, IsDevice o) => o -> m (Maybe Gdk.DeviceManager.DeviceManager)
getDeviceDeviceManager obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "device-manager" Gdk.DeviceManager.DeviceManager

-- | Construct a t'GValueConstruct' with valid value for the “@device-manager@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceDeviceManager :: (IsDevice o, MIO.MonadIO m, Gdk.DeviceManager.IsDeviceManager a) => a -> m (GValueConstruct o)
constructDeviceDeviceManager val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "device-manager" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DeviceDeviceManagerPropertyInfo
instance AttrInfo DeviceDeviceManagerPropertyInfo where
    type AttrAllowedOps DeviceDeviceManagerPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceDeviceManagerPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceDeviceManagerPropertyInfo = Gdk.DeviceManager.IsDeviceManager
    type AttrTransferTypeConstraint DeviceDeviceManagerPropertyInfo = Gdk.DeviceManager.IsDeviceManager
    type AttrTransferType DeviceDeviceManagerPropertyInfo = Gdk.DeviceManager.DeviceManager
    type AttrGetType DeviceDeviceManagerPropertyInfo = (Maybe Gdk.DeviceManager.DeviceManager)
    type AttrLabel DeviceDeviceManagerPropertyInfo = "device-manager"
    type AttrOrigin DeviceDeviceManagerPropertyInfo = Device
    attrGet = getDeviceDeviceManager
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.DeviceManager.DeviceManager v
    attrConstruct = constructDeviceDeviceManager
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceManager"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:deviceManager"
        })
#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #display
-- @
getDeviceDisplay :: (MonadIO m, IsDevice o) => o -> m Gdk.Display.Display
getDeviceDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getDeviceDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

-- | Construct a t'GValueConstruct' with valid value for the “@display@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceDisplay :: (IsDevice o, MIO.MonadIO m, Gdk.Display.IsDisplay a) => a -> m (GValueConstruct o)
constructDeviceDisplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "display" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DeviceDisplayPropertyInfo
instance AttrInfo DeviceDisplayPropertyInfo where
    type AttrAllowedOps DeviceDisplayPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceDisplayPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferTypeConstraint DeviceDisplayPropertyInfo = Gdk.Display.IsDisplay
    type AttrTransferType DeviceDisplayPropertyInfo = Gdk.Display.Display
    type AttrGetType DeviceDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel DeviceDisplayPropertyInfo = "display"
    type AttrOrigin DeviceDisplayPropertyInfo = Device
    attrGet = getDeviceDisplay
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Display.Display v
    attrConstruct = constructDeviceDisplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:display"
        })
#endif

-- VVV Prop "has-cursor"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@has-cursor@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #hasCursor
-- @
getDeviceHasCursor :: (MonadIO m, IsDevice o) => o -> m Bool
getDeviceHasCursor obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-cursor"

-- | Construct a t'GValueConstruct' with valid value for the “@has-cursor@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceHasCursor :: (IsDevice o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructDeviceHasCursor val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-cursor" val

#if defined(ENABLE_OVERLOADING)
data DeviceHasCursorPropertyInfo
instance AttrInfo DeviceHasCursorPropertyInfo where
    type AttrAllowedOps DeviceHasCursorPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceHasCursorPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceHasCursorPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint DeviceHasCursorPropertyInfo = (~) Bool
    type AttrTransferType DeviceHasCursorPropertyInfo = Bool
    type AttrGetType DeviceHasCursorPropertyInfo = Bool
    type AttrLabel DeviceHasCursorPropertyInfo = "has-cursor"
    type AttrOrigin DeviceHasCursorPropertyInfo = Device
    attrGet = getDeviceHasCursor
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceHasCursor
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.hasCursor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:hasCursor"
        })
#endif

-- VVV Prop "input-mode"
   -- Type: TInterface (Name {namespace = "Gdk", name = "InputMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@input-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #inputMode
-- @
getDeviceInputMode :: (MonadIO m, IsDevice o) => o -> m Gdk.Enums.InputMode
getDeviceInputMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "input-mode"

-- | Set the value of the “@input-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' device [ #inputMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setDeviceInputMode :: (MonadIO m, IsDevice o) => o -> Gdk.Enums.InputMode -> m ()
setDeviceInputMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "input-mode" val

-- | Construct a t'GValueConstruct' with valid value for the “@input-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceInputMode :: (IsDevice o, MIO.MonadIO m) => Gdk.Enums.InputMode -> m (GValueConstruct o)
constructDeviceInputMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "input-mode" val

#if defined(ENABLE_OVERLOADING)
data DeviceInputModePropertyInfo
instance AttrInfo DeviceInputModePropertyInfo where
    type AttrAllowedOps DeviceInputModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint DeviceInputModePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceInputModePropertyInfo = (~) Gdk.Enums.InputMode
    type AttrTransferTypeConstraint DeviceInputModePropertyInfo = (~) Gdk.Enums.InputMode
    type AttrTransferType DeviceInputModePropertyInfo = Gdk.Enums.InputMode
    type AttrGetType DeviceInputModePropertyInfo = Gdk.Enums.InputMode
    type AttrLabel DeviceInputModePropertyInfo = "input-mode"
    type AttrOrigin DeviceInputModePropertyInfo = Device
    attrGet = getDeviceInputMode
    attrSet = setDeviceInputMode
    attrPut = setDeviceInputMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceInputMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.inputMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:inputMode"
        })
#endif

-- VVV Prop "input-source"
   -- Type: TInterface (Name {namespace = "Gdk", name = "InputSource"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@input-source@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #inputSource
-- @
getDeviceInputSource :: (MonadIO m, IsDevice o) => o -> m Gdk.Enums.InputSource
getDeviceInputSource obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "input-source"

-- | Construct a t'GValueConstruct' with valid value for the “@input-source@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceInputSource :: (IsDevice o, MIO.MonadIO m) => Gdk.Enums.InputSource -> m (GValueConstruct o)
constructDeviceInputSource val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "input-source" val

#if defined(ENABLE_OVERLOADING)
data DeviceInputSourcePropertyInfo
instance AttrInfo DeviceInputSourcePropertyInfo where
    type AttrAllowedOps DeviceInputSourcePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceInputSourcePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceInputSourcePropertyInfo = (~) Gdk.Enums.InputSource
    type AttrTransferTypeConstraint DeviceInputSourcePropertyInfo = (~) Gdk.Enums.InputSource
    type AttrTransferType DeviceInputSourcePropertyInfo = Gdk.Enums.InputSource
    type AttrGetType DeviceInputSourcePropertyInfo = Gdk.Enums.InputSource
    type AttrLabel DeviceInputSourcePropertyInfo = "input-source"
    type AttrOrigin DeviceInputSourcePropertyInfo = Device
    attrGet = getDeviceInputSource
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceInputSource
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.inputSource"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:inputSource"
        })
#endif

-- VVV Prop "n-axes"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-axes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #nAxes
-- @
getDeviceNAxes :: (MonadIO m, IsDevice o) => o -> m Word32
getDeviceNAxes obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-axes"

#if defined(ENABLE_OVERLOADING)
data DeviceNAxesPropertyInfo
instance AttrInfo DeviceNAxesPropertyInfo where
    type AttrAllowedOps DeviceNAxesPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DeviceNAxesPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceNAxesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceNAxesPropertyInfo = (~) ()
    type AttrTransferType DeviceNAxesPropertyInfo = ()
    type AttrGetType DeviceNAxesPropertyInfo = Word32
    type AttrLabel DeviceNAxesPropertyInfo = "n-axes"
    type AttrOrigin DeviceNAxesPropertyInfo = Device
    attrGet = getDeviceNAxes
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.nAxes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:nAxes"
        })
#endif

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #name
-- @
getDeviceName :: (MonadIO m, IsDevice o) => o -> m T.Text
getDeviceName obj = MIO.liftIO $ checkUnexpectedNothing "getDeviceName" $ B.Properties.getObjectPropertyString obj "name"

-- | Construct a t'GValueConstruct' with valid value for the “@name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceName :: (IsDevice o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructDeviceName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DeviceNamePropertyInfo
instance AttrInfo DeviceNamePropertyInfo where
    type AttrAllowedOps DeviceNamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceNamePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint DeviceNamePropertyInfo = (~) T.Text
    type AttrTransferType DeviceNamePropertyInfo = T.Text
    type AttrGetType DeviceNamePropertyInfo = T.Text
    type AttrLabel DeviceNamePropertyInfo = "name"
    type AttrOrigin DeviceNamePropertyInfo = Device
    attrGet = getDeviceName
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:name"
        })
#endif

-- VVV Prop "num-touches"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@num-touches@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #numTouches
-- @
getDeviceNumTouches :: (MonadIO m, IsDevice o) => o -> m Word32
getDeviceNumTouches obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "num-touches"

-- | Construct a t'GValueConstruct' with valid value for the “@num-touches@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceNumTouches :: (IsDevice o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructDeviceNumTouches val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "num-touches" val

#if defined(ENABLE_OVERLOADING)
data DeviceNumTouchesPropertyInfo
instance AttrInfo DeviceNumTouchesPropertyInfo where
    type AttrAllowedOps DeviceNumTouchesPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceNumTouchesPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceNumTouchesPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint DeviceNumTouchesPropertyInfo = (~) Word32
    type AttrTransferType DeviceNumTouchesPropertyInfo = Word32
    type AttrGetType DeviceNumTouchesPropertyInfo = Word32
    type AttrLabel DeviceNumTouchesPropertyInfo = "num-touches"
    type AttrOrigin DeviceNumTouchesPropertyInfo = Device
    attrGet = getDeviceNumTouches
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceNumTouches
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.numTouches"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:numTouches"
        })
#endif

-- VVV Prop "product-id"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@product-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #productId
-- @
getDeviceProductId :: (MonadIO m, IsDevice o) => o -> m (Maybe T.Text)
getDeviceProductId obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "product-id"

-- | Construct a t'GValueConstruct' with valid value for the “@product-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceProductId :: (IsDevice o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructDeviceProductId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "product-id" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DeviceProductIdPropertyInfo
instance AttrInfo DeviceProductIdPropertyInfo where
    type AttrAllowedOps DeviceProductIdPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceProductIdPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceProductIdPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint DeviceProductIdPropertyInfo = (~) T.Text
    type AttrTransferType DeviceProductIdPropertyInfo = T.Text
    type AttrGetType DeviceProductIdPropertyInfo = (Maybe T.Text)
    type AttrLabel DeviceProductIdPropertyInfo = "product-id"
    type AttrOrigin DeviceProductIdPropertyInfo = Device
    attrGet = getDeviceProductId
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceProductId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.productId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:productId"
        })
#endif

-- VVV Prop "seat"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Seat"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@seat@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #seat
-- @
getDeviceSeat :: (MonadIO m, IsDevice o) => o -> m Gdk.Seat.Seat
getDeviceSeat obj = MIO.liftIO $ checkUnexpectedNothing "getDeviceSeat" $ B.Properties.getObjectPropertyObject obj "seat" Gdk.Seat.Seat

-- | Set the value of the “@seat@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' device [ #seat 'Data.GI.Base.Attributes.:=' value ]
-- @
setDeviceSeat :: (MonadIO m, IsDevice o, Gdk.Seat.IsSeat a) => o -> a -> m ()
setDeviceSeat obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "seat" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@seat@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceSeat :: (IsDevice o, MIO.MonadIO m, Gdk.Seat.IsSeat a) => a -> m (GValueConstruct o)
constructDeviceSeat val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "seat" (P.Just val)

-- | Set the value of the “@seat@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #seat
-- @
clearDeviceSeat :: (MonadIO m, IsDevice o) => o -> m ()
clearDeviceSeat obj = liftIO $ B.Properties.setObjectPropertyObject obj "seat" (Nothing :: Maybe Gdk.Seat.Seat)

#if defined(ENABLE_OVERLOADING)
data DeviceSeatPropertyInfo
instance AttrInfo DeviceSeatPropertyInfo where
    type AttrAllowedOps DeviceSeatPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceSeatPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceSeatPropertyInfo = Gdk.Seat.IsSeat
    type AttrTransferTypeConstraint DeviceSeatPropertyInfo = Gdk.Seat.IsSeat
    type AttrTransferType DeviceSeatPropertyInfo = Gdk.Seat.Seat
    type AttrGetType DeviceSeatPropertyInfo = Gdk.Seat.Seat
    type AttrLabel DeviceSeatPropertyInfo = "seat"
    type AttrOrigin DeviceSeatPropertyInfo = Device
    attrGet = getDeviceSeat
    attrSet = setDeviceSeat
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Seat.Seat v
    attrConstruct = constructDeviceSeat
    attrClear = clearDeviceSeat
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.seat"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:seat"
        })
#endif

-- VVV Prop "tool"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DeviceTool"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@tool@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #tool
-- @
getDeviceTool :: (MonadIO m, IsDevice o) => o -> m (Maybe Gdk.DeviceTool.DeviceTool)
getDeviceTool obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "tool" Gdk.DeviceTool.DeviceTool

#if defined(ENABLE_OVERLOADING)
data DeviceToolPropertyInfo
instance AttrInfo DeviceToolPropertyInfo where
    type AttrAllowedOps DeviceToolPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceToolPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceToolPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DeviceToolPropertyInfo = (~) ()
    type AttrTransferType DeviceToolPropertyInfo = ()
    type AttrGetType DeviceToolPropertyInfo = (Maybe Gdk.DeviceTool.DeviceTool)
    type AttrLabel DeviceToolPropertyInfo = "tool"
    type AttrOrigin DeviceToolPropertyInfo = Device
    attrGet = getDeviceTool
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.tool"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:tool"
        })
#endif

-- VVV Prop "type"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DeviceType"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #type
-- @
getDeviceType :: (MonadIO m, IsDevice o) => o -> m Gdk.Enums.DeviceType
getDeviceType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "type"

-- | Construct a t'GValueConstruct' with valid value for the “@type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceType :: (IsDevice o, MIO.MonadIO m) => Gdk.Enums.DeviceType -> m (GValueConstruct o)
constructDeviceType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "type" val

#if defined(ENABLE_OVERLOADING)
data DeviceTypePropertyInfo
instance AttrInfo DeviceTypePropertyInfo where
    type AttrAllowedOps DeviceTypePropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DeviceTypePropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceTypePropertyInfo = (~) Gdk.Enums.DeviceType
    type AttrTransferTypeConstraint DeviceTypePropertyInfo = (~) Gdk.Enums.DeviceType
    type AttrTransferType DeviceTypePropertyInfo = Gdk.Enums.DeviceType
    type AttrGetType DeviceTypePropertyInfo = Gdk.Enums.DeviceType
    type AttrLabel DeviceTypePropertyInfo = "type"
    type AttrOrigin DeviceTypePropertyInfo = Device
    attrGet = getDeviceType
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:type"
        })
#endif

-- VVV Prop "vendor-id"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@vendor-id@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' device #vendorId
-- @
getDeviceVendorId :: (MonadIO m, IsDevice o) => o -> m (Maybe T.Text)
getDeviceVendorId obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "vendor-id"

-- | Construct a t'GValueConstruct' with valid value for the “@vendor-id@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDeviceVendorId :: (IsDevice o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructDeviceVendorId val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "vendor-id" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DeviceVendorIdPropertyInfo
instance AttrInfo DeviceVendorIdPropertyInfo where
    type AttrAllowedOps DeviceVendorIdPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DeviceVendorIdPropertyInfo = IsDevice
    type AttrSetTypeConstraint DeviceVendorIdPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint DeviceVendorIdPropertyInfo = (~) T.Text
    type AttrTransferType DeviceVendorIdPropertyInfo = T.Text
    type AttrGetType DeviceVendorIdPropertyInfo = (Maybe T.Text)
    type AttrLabel DeviceVendorIdPropertyInfo = "vendor-id"
    type AttrOrigin DeviceVendorIdPropertyInfo = Device
    attrGet = getDeviceVendorId
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDeviceVendorId
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.vendorId"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#g:attr:vendorId"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Device
type instance O.AttributeList Device = DeviceAttributeList
type DeviceAttributeList = ('[ '("associatedDevice", DeviceAssociatedDevicePropertyInfo), '("axes", DeviceAxesPropertyInfo), '("deviceManager", DeviceDeviceManagerPropertyInfo), '("display", DeviceDisplayPropertyInfo), '("hasCursor", DeviceHasCursorPropertyInfo), '("inputMode", DeviceInputModePropertyInfo), '("inputSource", DeviceInputSourcePropertyInfo), '("nAxes", DeviceNAxesPropertyInfo), '("name", DeviceNamePropertyInfo), '("numTouches", DeviceNumTouchesPropertyInfo), '("productId", DeviceProductIdPropertyInfo), '("seat", DeviceSeatPropertyInfo), '("tool", DeviceToolPropertyInfo), '("type", DeviceTypePropertyInfo), '("vendorId", DeviceVendorIdPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
deviceAssociatedDevice :: AttrLabelProxy "associatedDevice"
deviceAssociatedDevice = AttrLabelProxy

deviceAxes :: AttrLabelProxy "axes"
deviceAxes = AttrLabelProxy

deviceDeviceManager :: AttrLabelProxy "deviceManager"
deviceDeviceManager = AttrLabelProxy

deviceDisplay :: AttrLabelProxy "display"
deviceDisplay = AttrLabelProxy

deviceHasCursor :: AttrLabelProxy "hasCursor"
deviceHasCursor = AttrLabelProxy

deviceInputMode :: AttrLabelProxy "inputMode"
deviceInputMode = AttrLabelProxy

deviceInputSource :: AttrLabelProxy "inputSource"
deviceInputSource = AttrLabelProxy

deviceNAxes :: AttrLabelProxy "nAxes"
deviceNAxes = AttrLabelProxy

deviceName :: AttrLabelProxy "name"
deviceName = AttrLabelProxy

deviceNumTouches :: AttrLabelProxy "numTouches"
deviceNumTouches = AttrLabelProxy

deviceProductId :: AttrLabelProxy "productId"
deviceProductId = AttrLabelProxy

deviceSeat :: AttrLabelProxy "seat"
deviceSeat = AttrLabelProxy

deviceTool :: AttrLabelProxy "tool"
deviceTool = AttrLabelProxy

deviceType :: AttrLabelProxy "type"
deviceType = AttrLabelProxy

deviceVendorId :: AttrLabelProxy "vendorId"
deviceVendorId = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Device = DeviceSignalList
type DeviceSignalList = ('[ '("changed", DeviceChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("toolChanged", DeviceToolChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Device::get_associated_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Device" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_associated_device" gdk_device_get_associated_device :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr Device)

-- | Returns the associated device to /@device@/, if /@device@/ is of type
-- 'GI.Gdk.Enums.DeviceTypeMaster', it will return the paired pointer or
-- keyboard.
-- 
-- If /@device@/ is of type 'GI.Gdk.Enums.DeviceTypeSlave', it will return
-- the master device to which /@device@/ is attached to.
-- 
-- If /@device@/ is of type 'GI.Gdk.Enums.DeviceTypeFloating', 'P.Nothing' will be
-- returned, as there is no associated device.
-- 
-- /Since: 3.0/
deviceGetAssociatedDevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m (Maybe Device)
    -- ^ __Returns:__ The associated device, or
    --   'P.Nothing'
deviceGetAssociatedDevice device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_associated_device device'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Device) result'
        return result''
    touchManagedPtr device
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DeviceGetAssociatedDeviceMethodInfo
instance (signature ~ (m (Maybe Device)), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetAssociatedDeviceMethodInfo a signature where
    overloadedMethod = deviceGetAssociatedDevice

instance O.OverloadedMethodInfo DeviceGetAssociatedDeviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetAssociatedDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetAssociatedDevice"
        })


#endif

-- method Device::get_axes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "AxisFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_axes" gdk_device_get_axes :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CUInt

-- | Returns the axes currently available on the device.
-- 
-- /Since: 3.22/
deviceGetAxes ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m [Gdk.Flags.AxisFlags]
deviceGetAxes device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_axes device'
    let result' = wordToGFlags result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetAxesMethodInfo
instance (signature ~ (m [Gdk.Flags.AxisFlags]), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetAxesMethodInfo a signature where
    overloadedMethod = deviceGetAxes

instance O.OverloadedMethodInfo DeviceGetAxesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetAxes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetAxes"
        })


#endif

-- method Device::get_axis_use
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer #GdkDevice."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index of the axis."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "AxisUse" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_axis_use" gdk_device_get_axis_use :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Word32 ->                               -- index_ : TBasicType TUInt
    IO CUInt

-- | Returns the axis use for /@index_@/.
-- 
-- /Since: 2.20/
deviceGetAxisUse ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a pointer t'GI.Gdk.Objects.Device.Device'.
    -> Word32
    -- ^ /@index_@/: the index of the axis.
    -> m Gdk.Enums.AxisUse
    -- ^ __Returns:__ a t'GI.Gdk.Enums.AxisUse' specifying how the axis is used.
deviceGetAxisUse device index_ = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_axis_use device' index_
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetAxisUseMethodInfo
instance (signature ~ (Word32 -> m Gdk.Enums.AxisUse), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetAxisUseMethodInfo a signature where
    overloadedMethod = deviceGetAxisUse

instance O.OverloadedMethodInfo DeviceGetAxisUseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetAxisUse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetAxisUse"
        })


#endif

-- method Device::get_device_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DeviceType" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_device_type" gdk_device_get_device_type :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CUInt

-- | Returns the device type for /@device@/.
-- 
-- /Since: 3.0/
deviceGetDeviceType ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m Gdk.Enums.DeviceType
    -- ^ __Returns:__ the t'GI.Gdk.Enums.DeviceType' for /@device@/.
deviceGetDeviceType device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_device_type device'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetDeviceTypeMethodInfo
instance (signature ~ (m Gdk.Enums.DeviceType), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetDeviceTypeMethodInfo a signature where
    overloadedMethod = deviceGetDeviceType

instance O.OverloadedMethodInfo DeviceGetDeviceTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetDeviceType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetDeviceType"
        })


#endif

-- method Device::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_display" gdk_device_get_display :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr Gdk.Display.Display)

-- | Returns the t'GI.Gdk.Objects.Display.Display' to which /@device@/ pertains.
-- 
-- /Since: 3.0/
deviceGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m Gdk.Display.Display
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Display.Display'. This memory is owned
    --          by GTK+, and must not be freed or unreffed.
deviceGetDisplay device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_display device'
    checkUnexpectedReturnNULL "deviceGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetDisplayMethodInfo a signature where
    overloadedMethod = deviceGetDisplay

instance O.OverloadedMethodInfo DeviceGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetDisplay"
        })


#endif

-- method Device::get_has_cursor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_has_cursor" gdk_device_get_has_cursor :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CInt

-- | Determines whether the pointer follows device motion.
-- This is not meaningful for keyboard devices, which don\'t have a pointer.
-- 
-- /Since: 2.20/
deviceGetHasCursor ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the pointer follows device motion
deviceGetHasCursor device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_has_cursor device'
    let result' = (/= 0) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetHasCursorMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetHasCursorMethodInfo a signature where
    overloadedMethod = deviceGetHasCursor

instance O.OverloadedMethodInfo DeviceGetHasCursorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetHasCursor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetHasCursor"
        })


#endif

-- method Device::get_key
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index of the macro button to get."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return value for the keyval."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "modifiers"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return value for modifiers."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_key" gdk_device_get_key :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Word32 ->                               -- index_ : TBasicType TUInt
    Ptr Word32 ->                           -- keyval : TBasicType TUInt
    Ptr CUInt ->                            -- modifiers : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | If /@index_@/ has a valid keyval, this function will return 'P.True'
-- and fill in /@keyval@/ and /@modifiers@/ with the keyval settings.
-- 
-- /Since: 2.20/
deviceGetKey ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'.
    -> Word32
    -- ^ /@index_@/: the index of the macro button to get.
    -> m ((Bool, Word32, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ 'P.True' if keyval is set for /@index@/.
deviceGetKey device index_ = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    keyval <- allocMem :: IO (Ptr Word32)
    modifiers <- allocMem :: IO (Ptr CUInt)
    result <- gdk_device_get_key device' index_ keyval modifiers
    let result' = (/= 0) result
    keyval' <- peek keyval
    modifiers' <- peek modifiers
    let modifiers'' = wordToGFlags modifiers'
    touchManagedPtr device
    freeMem keyval
    freeMem modifiers
    return (result', keyval', modifiers'')

#if defined(ENABLE_OVERLOADING)
data DeviceGetKeyMethodInfo
instance (signature ~ (Word32 -> m ((Bool, Word32, [Gdk.Flags.ModifierType]))), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetKeyMethodInfo a signature where
    overloadedMethod = deviceGetKey

instance O.OverloadedMethodInfo DeviceGetKeyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetKey",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetKey"
        })


#endif

-- method Device::get_last_event_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a #GdkDevice, with a source other than %GDK_SOURCE_KEYBOARD"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_last_event_window" gdk_device_get_last_event_window :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr Gdk.Window.Window)

-- | Gets information about which window the given pointer device is in, based on events
-- that have been received so far from the display server. If another application
-- has a pointer grab, or this application has a grab with owner_events = 'P.False',
-- 'P.Nothing' may be returned even if the pointer is physically over one of this
-- application\'s windows.
-- 
-- /Since: 3.12/
deviceGetLastEventWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device', with a source other than 'GI.Gdk.Enums.InputSourceKeyboard'
    -> m (Maybe Gdk.Window.Window)
    -- ^ __Returns:__ the last window the device
deviceGetLastEventWindow device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_last_event_window device'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Window.Window) result'
        return result''
    touchManagedPtr device
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DeviceGetLastEventWindowMethodInfo
instance (signature ~ (m (Maybe Gdk.Window.Window)), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetLastEventWindowMethodInfo a signature where
    overloadedMethod = deviceGetLastEventWindow

instance O.OverloadedMethodInfo DeviceGetLastEventWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetLastEventWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetLastEventWindow"
        })


#endif

-- method Device::get_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "InputMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_mode" gdk_device_get_mode :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CUInt

-- | Determines the mode of the device.
-- 
-- /Since: 2.20/
deviceGetMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m Gdk.Enums.InputMode
    -- ^ __Returns:__ a t'GI.Gdk.Enums.InputSource'
deviceGetMode device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_mode device'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetModeMethodInfo
instance (signature ~ (m Gdk.Enums.InputMode), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetModeMethodInfo a signature where
    overloadedMethod = deviceGetMode

instance O.OverloadedMethodInfo DeviceGetModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetMode"
        })


#endif

-- method Device::get_n_axes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer #GdkDevice"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_n_axes" gdk_device_get_n_axes :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO Int32

-- | Returns the number of axes the device currently has.
-- 
-- /Since: 3.0/
deviceGetNAxes ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a pointer t'GI.Gdk.Objects.Device.Device'
    -> m Int32
    -- ^ __Returns:__ the number of axes.
deviceGetNAxes device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_n_axes device'
    touchManagedPtr device
    return result

#if defined(ENABLE_OVERLOADING)
data DeviceGetNAxesMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetNAxesMethodInfo a signature where
    overloadedMethod = deviceGetNAxes

instance O.OverloadedMethodInfo DeviceGetNAxesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetNAxes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetNAxes"
        })


#endif

-- method Device::get_n_keys
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_n_keys" gdk_device_get_n_keys :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO Int32

-- | Returns the number of keys the device currently has.
-- 
-- /Since: 2.24/
deviceGetNKeys ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m Int32
    -- ^ __Returns:__ the number of keys.
deviceGetNKeys device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_n_keys device'
    touchManagedPtr device
    return result

#if defined(ENABLE_OVERLOADING)
data DeviceGetNKeysMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetNKeysMethodInfo a signature where
    overloadedMethod = deviceGetNKeys

instance O.OverloadedMethodInfo DeviceGetNKeysMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetNKeys",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetNKeys"
        })


#endif

-- method Device::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_name" gdk_device_get_name :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CString

-- | Determines the name of the device.
-- 
-- /Since: 2.20/
deviceGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m T.Text
    -- ^ __Returns:__ a name
deviceGetName device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_name device'
    checkUnexpectedReturnNULL "deviceGetName" result
    result' <- cstringToText result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetNameMethodInfo a signature where
    overloadedMethod = deviceGetName

instance O.OverloadedMethodInfo DeviceGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetName"
        })


#endif

-- method Device::get_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer device to query status about."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the #GdkScreen\n         the @device is on, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store root window X coordinate of @device, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store root window Y coordinate of @device, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_position" gdk_device_get_position :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr (Ptr Gdk.Screen.Screen) ->          -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Ptr Int32 ->                            -- x : TBasicType TInt
    Ptr Int32 ->                            -- y : TBasicType TInt
    IO ()

-- | Gets the current location of /@device@/. As a slave device
-- coordinates are those of its master pointer, This function
-- may not be called on devices of type 'GI.Gdk.Enums.DeviceTypeSlave',
-- unless there is an ongoing grab on them, see 'GI.Gdk.Objects.Device.deviceGrab'.
-- 
-- /Since: 3.0/
deviceGetPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: pointer device to query status about.
    -> m ((Gdk.Screen.Screen, Int32, Int32))
deviceGetPosition device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    screen <- callocMem :: IO (Ptr (Ptr Gdk.Screen.Screen))
    x <- allocMem :: IO (Ptr Int32)
    y <- allocMem :: IO (Ptr Int32)
    gdk_device_get_position device' screen x y
    screen' <- peek screen
    screen'' <- (newObject Gdk.Screen.Screen) screen'
    x' <- peek x
    y' <- peek y
    touchManagedPtr device
    freeMem screen
    freeMem x
    freeMem y
    return (screen'', x', y')

#if defined(ENABLE_OVERLOADING)
data DeviceGetPositionMethodInfo
instance (signature ~ (m ((Gdk.Screen.Screen, Int32, Int32))), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetPositionMethodInfo a signature where
    overloadedMethod = deviceGetPosition

instance O.OverloadedMethodInfo DeviceGetPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetPosition"
        })


#endif

-- method Device::get_position_double
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer device to query status about."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the #GdkScreen\n         the @device is on, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store root window X coordinate of @device, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store root window Y coordinate of @device, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_position_double" gdk_device_get_position_double :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr (Ptr Gdk.Screen.Screen) ->          -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Ptr CDouble ->                          -- x : TBasicType TDouble
    Ptr CDouble ->                          -- y : TBasicType TDouble
    IO ()

-- | Gets the current location of /@device@/ in double precision. As a slave device\'s
-- coordinates are those of its master pointer, this function
-- may not be called on devices of type 'GI.Gdk.Enums.DeviceTypeSlave',
-- unless there is an ongoing grab on them. See 'GI.Gdk.Objects.Device.deviceGrab'.
-- 
-- /Since: 3.10/
deviceGetPositionDouble ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: pointer device to query status about.
    -> m ((Gdk.Screen.Screen, Double, Double))
deviceGetPositionDouble device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    screen <- callocMem :: IO (Ptr (Ptr Gdk.Screen.Screen))
    x <- allocMem :: IO (Ptr CDouble)
    y <- allocMem :: IO (Ptr CDouble)
    gdk_device_get_position_double device' screen x y
    screen' <- peek screen
    screen'' <- (newObject Gdk.Screen.Screen) screen'
    x' <- peek x
    let x'' = realToFrac x'
    y' <- peek y
    let y'' = realToFrac y'
    touchManagedPtr device
    freeMem screen
    freeMem x
    freeMem y
    return (screen'', x'', y'')

#if defined(ENABLE_OVERLOADING)
data DeviceGetPositionDoubleMethodInfo
instance (signature ~ (m ((Gdk.Screen.Screen, Double, Double))), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetPositionDoubleMethodInfo a signature where
    overloadedMethod = deviceGetPositionDouble

instance O.OverloadedMethodInfo DeviceGetPositionDoubleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetPositionDouble",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetPositionDouble"
        })


#endif

-- method Device::get_product_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a slave #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_product_id" gdk_device_get_product_id :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CString

-- | Returns the product ID of this device, or 'P.Nothing' if this information couldn\'t
-- be obtained. This ID is retrieved from the device, and is thus constant for
-- it. See 'GI.Gdk.Objects.Device.deviceGetVendorId' for more information.
-- 
-- /Since: 3.16/
deviceGetProductId ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a slave t'GI.Gdk.Objects.Device.Device'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the product ID, or 'P.Nothing'
deviceGetProductId device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_product_id device'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr device
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DeviceGetProductIdMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetProductIdMethodInfo a signature where
    overloadedMethod = deviceGetProductId

instance O.OverloadedMethodInfo DeviceGetProductIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetProductId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetProductId"
        })


#endif

-- method Device::get_seat
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Seat" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_seat" gdk_device_get_seat :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr Gdk.Seat.Seat)

-- | Returns the t'GI.Gdk.Objects.Seat.Seat' the device belongs to.
-- 
-- /Since: 3.20/
deviceGetSeat ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: A t'GI.Gdk.Objects.Device.Device'
    -> m Gdk.Seat.Seat
    -- ^ __Returns:__ A t'GI.Gdk.Objects.Seat.Seat'. This memory is owned by GTK+ and
    --          must not be freed.
deviceGetSeat device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_seat device'
    checkUnexpectedReturnNULL "deviceGetSeat" result
    result' <- (newObject Gdk.Seat.Seat) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetSeatMethodInfo
instance (signature ~ (m Gdk.Seat.Seat), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetSeatMethodInfo a signature where
    overloadedMethod = deviceGetSeat

instance O.OverloadedMethodInfo DeviceGetSeatMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetSeat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetSeat"
        })


#endif

-- method Device::get_source
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "InputSource" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_source" gdk_device_get_source :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CUInt

-- | Determines the type of the device.
-- 
-- /Since: 2.20/
deviceGetSource ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m Gdk.Enums.InputSource
    -- ^ __Returns:__ a t'GI.Gdk.Enums.InputSource'
deviceGetSource device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_source device'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGetSourceMethodInfo
instance (signature ~ (m Gdk.Enums.InputSource), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetSourceMethodInfo a signature where
    overloadedMethod = deviceGetSource

instance O.OverloadedMethodInfo DeviceGetSourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetSource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetSource"
        })


#endif

-- method Device::get_vendor_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a slave #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_vendor_id" gdk_device_get_vendor_id :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CString

-- | Returns the vendor ID of this device, or 'P.Nothing' if this information couldn\'t
-- be obtained. This ID is retrieved from the device, and is thus constant for
-- it.
-- 
-- This function, together with 'GI.Gdk.Objects.Device.deviceGetProductId', can be used to eg.
-- compose t'GI.Gio.Objects.Settings.Settings' paths to store settings for this device.
-- 
-- 
-- === /C code/
-- >
-- > static GSettings *
-- > get_device_settings (GdkDevice *device)
-- > {
-- >   const gchar *vendor, *product;
-- >   GSettings *settings;
-- >   GdkDevice *device;
-- >   gchar *path;
-- >
-- >   vendor = gdk_device_get_vendor_id (device);
-- >   product = gdk_device_get_product_id (device);
-- >
-- >   path = g_strdup_printf ("/org/example/app/devices/%s:%s/", vendor, product);
-- >   settings = g_settings_new_with_path (DEVICE_SCHEMA, path);
-- >   g_free (path);
-- >
-- >   return settings;
-- > }
-- 
-- 
-- /Since: 3.16/
deviceGetVendorId ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a slave t'GI.Gdk.Objects.Device.Device'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the vendor ID, or 'P.Nothing'
deviceGetVendorId device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_get_vendor_id device'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr device
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DeviceGetVendorIdMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetVendorIdMethodInfo a signature where
    overloadedMethod = deviceGetVendorId

instance O.OverloadedMethodInfo DeviceGetVendorIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetVendorId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetVendorId"
        })


#endif

-- method Device::get_window_at_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer #GdkDevice to query info to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "win_x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the X coordinate of the device location,\n        relative to the window origin, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "win_y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the Y coordinate of the device location,\n        relative to the window origin, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_window_at_position" gdk_device_get_window_at_position :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr Int32 ->                            -- win_x : TBasicType TInt
    Ptr Int32 ->                            -- win_y : TBasicType TInt
    IO (Ptr Gdk.Window.Window)

-- | Obtains the window underneath /@device@/, returning the location of the device in /@winX@/ and /@winY@/. Returns
-- 'P.Nothing' if the window tree under /@device@/ is not known to GDK (for example, belongs to another application).
-- 
-- As a slave device coordinates are those of its master pointer, This
-- function may not be called on devices of type 'GI.Gdk.Enums.DeviceTypeSlave',
-- unless there is an ongoing grab on them, see 'GI.Gdk.Objects.Device.deviceGrab'.
-- 
-- /Since: 3.0/
deviceGetWindowAtPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: pointer t'GI.Gdk.Objects.Device.Device' to query info to.
    -> m ((Maybe Gdk.Window.Window, Int32, Int32))
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Window.Window' under the
    -- device position, or 'P.Nothing'.
deviceGetWindowAtPosition device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    winX <- allocMem :: IO (Ptr Int32)
    winY <- allocMem :: IO (Ptr Int32)
    result <- gdk_device_get_window_at_position device' winX winY
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Window.Window) result'
        return result''
    winX' <- peek winX
    winY' <- peek winY
    touchManagedPtr device
    freeMem winX
    freeMem winY
    return (maybeResult, winX', winY')

#if defined(ENABLE_OVERLOADING)
data DeviceGetWindowAtPositionMethodInfo
instance (signature ~ (m ((Maybe Gdk.Window.Window, Int32, Int32))), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetWindowAtPositionMethodInfo a signature where
    overloadedMethod = deviceGetWindowAtPosition

instance O.OverloadedMethodInfo DeviceGetWindowAtPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetWindowAtPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetWindowAtPosition"
        })


#endif

-- method Device::get_window_at_position_double
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer #GdkDevice to query info to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "win_x"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the X coordinate of the device location,\n        relative to the window origin, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "win_y"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the Y coordinate of the device location,\n        relative to the window origin, or %NULL."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_get_window_at_position_double" gdk_device_get_window_at_position_double :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr CDouble ->                          -- win_x : TBasicType TDouble
    Ptr CDouble ->                          -- win_y : TBasicType TDouble
    IO (Ptr Gdk.Window.Window)

-- | Obtains the window underneath /@device@/, returning the location of the device in /@winX@/ and /@winY@/ in
-- double precision. Returns 'P.Nothing' if the window tree under /@device@/ is not known to GDK (for example,
-- belongs to another application).
-- 
-- As a slave device coordinates are those of its master pointer, This
-- function may not be called on devices of type 'GI.Gdk.Enums.DeviceTypeSlave',
-- unless there is an ongoing grab on them, see 'GI.Gdk.Objects.Device.deviceGrab'.
-- 
-- /Since: 3.0/
deviceGetWindowAtPositionDouble ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: pointer t'GI.Gdk.Objects.Device.Device' to query info to.
    -> m ((Maybe Gdk.Window.Window, Double, Double))
    -- ^ __Returns:__ the t'GI.Gdk.Objects.Window.Window' under the
    --   device position, or 'P.Nothing'.
deviceGetWindowAtPositionDouble device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    winX <- allocMem :: IO (Ptr CDouble)
    winY <- allocMem :: IO (Ptr CDouble)
    result <- gdk_device_get_window_at_position_double device' winX winY
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Window.Window) result'
        return result''
    winX' <- peek winX
    let winX'' = realToFrac winX'
    winY' <- peek winY
    let winY'' = realToFrac winY'
    touchManagedPtr device
    freeMem winX
    freeMem winY
    return (maybeResult, winX'', winY'')

#if defined(ENABLE_OVERLOADING)
data DeviceGetWindowAtPositionDoubleMethodInfo
instance (signature ~ (m ((Maybe Gdk.Window.Window, Double, Double))), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceGetWindowAtPositionDoubleMethodInfo a signature where
    overloadedMethod = deviceGetWindowAtPositionDouble

instance O.OverloadedMethodInfo DeviceGetWindowAtPositionDoubleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGetWindowAtPositionDouble",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGetWindowAtPositionDouble"
        })


#endif

-- method Device::grab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a #GdkDevice. To get the device you can use gtk_get_current_event_device()\n  or gdk_event_get_device() if the grab is in reaction to an event. Also, you can use\n  gdk_device_manager_get_client_pointer() but only in code that isn\8217t triggered by a\n  #GdkEvent and there aren\8217t other means to get a meaningful #GdkDevice to operate on."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GdkWindow which will own the grab (the grab window)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "grab_ownership"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "GrabOwnership" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "specifies the grab ownership."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "owner_events"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if %FALSE then all device events are reported with respect to\n               @window and are only reported if selected by @event_mask. If\n               %TRUE then pointer events for this application are reported\n               as normal, but pointer events outside this application are\n               reported with respect to @window and only if selected by\n               @event_mask. In either mode, unreported events are discarded."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event_mask"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventMask" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "specifies the event mask, which is used in accordance with\n             @owner_events."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cursor"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Cursor" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the cursor to display while the grab is active if the device is\n         a pointer. If this is %NULL then the normal cursors are used for\n         @window and its descendants, and the cursor for @window is used\n         elsewhere."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the timestamp of the event which led to this pointer grab. This\n        usually comes from the #GdkEvent struct, though %GDK_CURRENT_TIME\n        can be used if the time isn\8217t known."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GrabStatus" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_grab" gdk_device_grab :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    CUInt ->                                -- grab_ownership : TInterface (Name {namespace = "Gdk", name = "GrabOwnership"})
    CInt ->                                 -- owner_events : TBasicType TBoolean
    CUInt ->                                -- event_mask : TInterface (Name {namespace = "Gdk", name = "EventMask"})
    Ptr Gdk.Cursor.Cursor ->                -- cursor : TInterface (Name {namespace = "Gdk", name = "Cursor"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO CUInt

{-# DEPRECATED deviceGrab ["(Since version 3.20.)","Use 'GI.Gdk.Objects.Seat.seatGrab' instead."] #-}
-- | Grabs the device so that all events coming from this device are passed to
-- this application until the device is ungrabbed with 'GI.Gdk.Objects.Device.deviceUngrab',
-- or the window becomes unviewable. This overrides any previous grab on the device
-- by this client.
-- 
-- Note that /@device@/ and /@window@/ need to be on the same display.
-- 
-- Device grabs are used for operations which need complete control over the
-- given device events (either pointer or keyboard). For example in GTK+ this
-- is used for Drag and Drop operations, popup menus and such.
-- 
-- Note that if the event mask of an X window has selected both button press
-- and button release events, then a button press event will cause an automatic
-- pointer grab until the button is released. X does this automatically since
-- most applications expect to receive button press and release events in pairs.
-- It is equivalent to a pointer grab on the window with /@ownerEvents@/ set to
-- 'P.True'.
-- 
-- If you set up anything at the time you take the grab that needs to be
-- cleaned up when the grab ends, you should handle the t'GI.Gdk.Structs.EventGrabBroken.EventGrabBroken'
-- events that are emitted when the grab ends unvoluntarily.
-- 
-- /Since: 3.0/
deviceGrab ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a, Gdk.Window.IsWindow b, Gdk.Cursor.IsCursor c) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'. To get the device you can use @/gtk_get_current_event_device()/@
    --   or 'GI.Gdk.Unions.Event.eventGetDevice' if the grab is in reaction to an event. Also, you can use
    --   'GI.Gdk.Objects.DeviceManager.deviceManagerGetClientPointer' but only in code that isn’t triggered by a
    --   t'GI.Gdk.Unions.Event.Event' and there aren’t other means to get a meaningful t'GI.Gdk.Objects.Device.Device' to operate on.
    -> b
    -- ^ /@window@/: the t'GI.Gdk.Objects.Window.Window' which will own the grab (the grab window)
    -> Gdk.Enums.GrabOwnership
    -- ^ /@grabOwnership@/: specifies the grab ownership.
    -> Bool
    -- ^ /@ownerEvents@/: if 'P.False' then all device events are reported with respect to
    --                /@window@/ and are only reported if selected by /@eventMask@/. If
    --                'P.True' then pointer events for this application are reported
    --                as normal, but pointer events outside this application are
    --                reported with respect to /@window@/ and only if selected by
    --                /@eventMask@/. In either mode, unreported events are discarded.
    -> [Gdk.Flags.EventMask]
    -- ^ /@eventMask@/: specifies the event mask, which is used in accordance with
    --              /@ownerEvents@/.
    -> Maybe (c)
    -- ^ /@cursor@/: the cursor to display while the grab is active if the device is
    --          a pointer. If this is 'P.Nothing' then the normal cursors are used for
    --          /@window@/ and its descendants, and the cursor for /@window@/ is used
    --          elsewhere.
    -> Word32
    -- ^ /@time_@/: the timestamp of the event which led to this pointer grab. This
    --         usually comes from the t'GI.Gdk.Unions.Event.Event' struct, though 'GI.Gdk.Constants.CURRENT_TIME'
    --         can be used if the time isn’t known.
    -> m Gdk.Enums.GrabStatus
    -- ^ __Returns:__ 'GI.Gdk.Enums.GrabStatusSuccess' if the grab was successful.
deviceGrab device window grabOwnership ownerEvents eventMask cursor time_ = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    window' <- unsafeManagedPtrCastPtr window
    let grabOwnership' = (fromIntegral . fromEnum) grabOwnership
    let ownerEvents' = (P.fromIntegral . P.fromEnum) ownerEvents
    let eventMask' = gflagsToWord eventMask
    maybeCursor <- case cursor of
        Nothing -> return FP.nullPtr
        Just jCursor -> do
            jCursor' <- unsafeManagedPtrCastPtr jCursor
            return jCursor'
    result <- gdk_device_grab device' window' grabOwnership' ownerEvents' eventMask' maybeCursor time_
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr device
    touchManagedPtr window
    whenJust cursor touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceGrabMethodInfo
instance (signature ~ (b -> Gdk.Enums.GrabOwnership -> Bool -> [Gdk.Flags.EventMask] -> Maybe (c) -> Word32 -> m Gdk.Enums.GrabStatus), MonadIO m, IsDevice a, Gdk.Window.IsWindow b, Gdk.Cursor.IsCursor c) => O.OverloadedMethod DeviceGrabMethodInfo a signature where
    overloadedMethod = deviceGrab

instance O.OverloadedMethodInfo DeviceGrabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceGrab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceGrab"
        })


#endif

-- method Device::list_axes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer #GdkDevice"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Atom" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_list_axes" gdk_device_list_axes :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr (GList (Ptr Gdk.Atom.Atom)))

-- | Returns a t'GI.GLib.Structs.List.List' of @/GdkAtoms/@, containing the labels for
-- the axes that /@device@/ currently has.
-- 
-- /Since: 3.0/
deviceListAxes ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a pointer t'GI.Gdk.Objects.Device.Device'
    -> m [Gdk.Atom.Atom]
    -- ^ __Returns:__ 
    --     A t'GI.GLib.Structs.List.List' of @/GdkAtoms/@, free with @/g_list_free()/@.
deviceListAxes device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_list_axes device'
    result' <- unpackGList result
    result'' <- mapM (newPtr Gdk.Atom.Atom) result'
    g_list_free result
    touchManagedPtr device
    return result''

#if defined(ENABLE_OVERLOADING)
data DeviceListAxesMethodInfo
instance (signature ~ (m [Gdk.Atom.Atom]), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceListAxesMethodInfo a signature where
    overloadedMethod = deviceListAxes

instance O.OverloadedMethodInfo DeviceListAxesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceListAxes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceListAxes"
        })


#endif

-- method Device::list_slave_devices
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Device" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_list_slave_devices" gdk_device_list_slave_devices :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO (Ptr (GList (Ptr Device)))

-- | If the device if of type 'GI.Gdk.Enums.DeviceTypeMaster', it will return
-- the list of slave devices attached to it, otherwise it will return
-- 'P.Nothing'
deviceListSlaveDevices ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> m [Device]
    -- ^ __Returns:__ 
    --          the list of slave devices, or 'P.Nothing'. The list must be
    --          freed with @/g_list_free()/@, the contents of the list are
    --          owned by GTK+ and should not be freed.
deviceListSlaveDevices device = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_device_list_slave_devices device'
    result' <- unpackGList result
    result'' <- mapM (newObject Device) result'
    g_list_free result
    touchManagedPtr device
    return result''

#if defined(ENABLE_OVERLOADING)
data DeviceListSlaveDevicesMethodInfo
instance (signature ~ (m [Device]), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceListSlaveDevicesMethodInfo a signature where
    overloadedMethod = deviceListSlaveDevices

instance O.OverloadedMethodInfo DeviceListSlaveDevicesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceListSlaveDevices",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceListSlaveDevices"
        })


#endif

-- method Device::set_axis_use
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a pointer #GdkDevice"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index of the axis"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "AxisUse" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "specifies how the axis is used"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_set_axis_use" gdk_device_set_axis_use :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Word32 ->                               -- index_ : TBasicType TUInt
    CUInt ->                                -- use : TInterface (Name {namespace = "Gdk", name = "AxisUse"})
    IO ()

-- | Specifies how an axis of a device is used.
deviceSetAxisUse ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a pointer t'GI.Gdk.Objects.Device.Device'
    -> Word32
    -- ^ /@index_@/: the index of the axis
    -> Gdk.Enums.AxisUse
    -- ^ /@use@/: specifies how the axis is used
    -> m ()
deviceSetAxisUse device index_ use = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    let use' = (fromIntegral . fromEnum) use
    gdk_device_set_axis_use device' index_ use'
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data DeviceSetAxisUseMethodInfo
instance (signature ~ (Word32 -> Gdk.Enums.AxisUse -> m ()), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceSetAxisUseMethodInfo a signature where
    overloadedMethod = deviceSetAxisUse

instance O.OverloadedMethodInfo DeviceSetAxisUseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceSetAxisUse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceSetAxisUse"
        })


#endif

-- method Device::set_key
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index of the macro button to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the keyval to generate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modifiers"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the modifiers to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_set_key" gdk_device_set_key :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Word32 ->                               -- index_ : TBasicType TUInt
    Word32 ->                               -- keyval : TBasicType TUInt
    CUInt ->                                -- modifiers : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO ()

-- | Specifies the X key event to generate when a macro button of a device
-- is pressed.
deviceSetKey ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> Word32
    -- ^ /@index_@/: the index of the macro button to set
    -> Word32
    -- ^ /@keyval@/: the keyval to generate
    -> [Gdk.Flags.ModifierType]
    -- ^ /@modifiers@/: the modifiers to set
    -> m ()
deviceSetKey device index_ keyval modifiers = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    let modifiers' = gflagsToWord modifiers
    gdk_device_set_key device' index_ keyval modifiers'
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data DeviceSetKeyMethodInfo
instance (signature ~ (Word32 -> Word32 -> [Gdk.Flags.ModifierType] -> m ()), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceSetKeyMethodInfo a signature where
    overloadedMethod = deviceSetKey

instance O.OverloadedMethodInfo DeviceSetKeyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceSetKey",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceSetKey"
        })


#endif

-- method Device::set_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "InputMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the input mode." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_set_mode" gdk_device_set_mode :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    CUInt ->                                -- mode : TInterface (Name {namespace = "Gdk", name = "InputMode"})
    IO CInt

-- | Sets a the mode of an input device. The mode controls if the
-- device is active and whether the device’s range is mapped to the
-- entire screen or to a single window.
-- 
-- Note: This is only meaningful for floating devices, master devices (and
-- slaves connected to these) drive the pointer cursor, which is not limited
-- by the input mode.
deviceSetMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'.
    -> Gdk.Enums.InputMode
    -- ^ /@mode@/: the input mode.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the mode was successfully changed.
deviceSetMode device mode = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    let mode' = (fromIntegral . fromEnum) mode
    result <- gdk_device_set_mode device' mode'
    let result' = (/= 0) result
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DeviceSetModeMethodInfo
instance (signature ~ (Gdk.Enums.InputMode -> m Bool), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceSetModeMethodInfo a signature where
    overloadedMethod = deviceSetMode

instance O.OverloadedMethodInfo DeviceSetModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceSetMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceSetMode"
        })


#endif

-- method Device::ungrab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDevice" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "time_"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a timestap (e.g. %GDK_CURRENT_TIME)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_ungrab" gdk_device_ungrab :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Word32 ->                               -- time_ : TBasicType TUInt32
    IO ()

{-# DEPRECATED deviceUngrab ["(Since version 3.20.)","Use 'GI.Gdk.Objects.Seat.seatUngrab' instead."] #-}
-- | Release any grab on /@device@/.
-- 
-- /Since: 3.0/
deviceUngrab ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a) =>
    a
    -- ^ /@device@/: a t'GI.Gdk.Objects.Device.Device'
    -> Word32
    -- ^ /@time_@/: a timestap (e.g. 'GI.Gdk.Constants.CURRENT_TIME').
    -> m ()
deviceUngrab device time_ = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    gdk_device_ungrab device' time_
    touchManagedPtr device
    return ()

#if defined(ENABLE_OVERLOADING)
data DeviceUngrabMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsDevice a) => O.OverloadedMethod DeviceUngrabMethodInfo a signature where
    overloadedMethod = deviceUngrab

instance O.OverloadedMethodInfo DeviceUngrabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceUngrab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceUngrab"
        })


#endif

-- method Device::warp
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the device to warp."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "screen"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Screen" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the screen to warp @device to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the X coordinate of the destination."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the Y coordinate of the destination."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_warp" gdk_device_warp :: 
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr Gdk.Screen.Screen ->                -- screen : TInterface (Name {namespace = "Gdk", name = "Screen"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO ()

-- | Warps /@device@/ in /@display@/ to the point /@x@/,/@y@/ on
-- the screen /@screen@/, unless the device is confined
-- to a window by a grab, in which case it will be moved
-- as far as allowed by the grab. Warping the pointer
-- creates events as if the user had moved the mouse
-- instantaneously to the destination.
-- 
-- Note that the pointer should normally be under the
-- control of the user. This function was added to cover
-- some rare use cases like keyboard navigation support
-- for the color picker in the @/GtkColorSelectionDialog/@.
-- 
-- /Since: 3.0/
deviceWarp ::
    (B.CallStack.HasCallStack, MonadIO m, IsDevice a, Gdk.Screen.IsScreen b) =>
    a
    -- ^ /@device@/: the device to warp.
    -> b
    -- ^ /@screen@/: the screen to warp /@device@/ to.
    -> Int32
    -- ^ /@x@/: the X coordinate of the destination.
    -> Int32
    -- ^ /@y@/: the Y coordinate of the destination.
    -> m ()
deviceWarp device screen x y = liftIO $ do
    device' <- unsafeManagedPtrCastPtr device
    screen' <- unsafeManagedPtrCastPtr screen
    gdk_device_warp device' screen' x y
    touchManagedPtr device
    touchManagedPtr screen
    return ()

#if defined(ENABLE_OVERLOADING)
data DeviceWarpMethodInfo
instance (signature ~ (b -> Int32 -> Int32 -> m ()), MonadIO m, IsDevice a, Gdk.Screen.IsScreen b) => O.OverloadedMethod DeviceWarpMethodInfo a signature where
    overloadedMethod = deviceWarp

instance O.OverloadedMethodInfo DeviceWarpMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Device.deviceWarp",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-Device.html#v:deviceWarp"
        })


#endif

-- method Device::grab_info_libgtk_only
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the display for which to get the grab information"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "device to get the grab information from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "grab_window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store current grab window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "owner_events"
--           , argType = TBasicType TBoolean
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store boolean indicating whether\n  the @owner_events flag to gdk_keyboard_grab() or\n  gdk_pointer_grab() was %TRUE."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_device_grab_info_libgtk_only" gdk_device_grab_info_libgtk_only :: 
    Ptr Gdk.Display.Display ->              -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Device ->                           -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    Ptr (Ptr Gdk.Window.Window) ->          -- grab_window : TInterface (Name {namespace = "Gdk", name = "Window"})
    Ptr CInt ->                             -- owner_events : TBasicType TBoolean
    IO CInt

{-# DEPRECATED deviceGrabInfoLibgtkOnly ["(Since version 3.16)","The symbol was never meant to be used outside","  of GTK+"] #-}
-- | Determines information about the current keyboard grab.
-- This is not public API and must not be used by applications.
deviceGrabInfoLibgtkOnly ::
    (B.CallStack.HasCallStack, MonadIO m, Gdk.Display.IsDisplay a, IsDevice b) =>
    a
    -- ^ /@display@/: the display for which to get the grab information
    -> b
    -- ^ /@device@/: device to get the grab information from
    -> m ((Bool, Gdk.Window.Window, Bool))
    -- ^ __Returns:__ 'P.True' if this application currently has the
    --  keyboard grabbed.
deviceGrabInfoLibgtkOnly display device = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    device' <- unsafeManagedPtrCastPtr device
    grabWindow <- callocMem :: IO (Ptr (Ptr Gdk.Window.Window))
    ownerEvents <- allocMem :: IO (Ptr CInt)
    result <- gdk_device_grab_info_libgtk_only display' device' grabWindow ownerEvents
    let result' = (/= 0) result
    grabWindow' <- peek grabWindow
    grabWindow'' <- (newObject Gdk.Window.Window) grabWindow'
    ownerEvents' <- peek ownerEvents
    let ownerEvents'' = (/= 0) ownerEvents'
    touchManagedPtr display
    touchManagedPtr device
    freeMem grabWindow
    freeMem ownerEvents
    return (result', grabWindow'', ownerEvents'')

#if defined(ENABLE_OVERLOADING)
#endif


