/* MessageDialog.c generated by valac 0.56.17, the Vala compiler
 * generated from MessageDialog.vala, do not modify */

/*
 * Copyright 2017–2019 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "granite.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_MESSAGE_DIALOG_0_PROPERTY,
	GRANITE_MESSAGE_DIALOG_PRIMARY_TEXT_PROPERTY,
	GRANITE_MESSAGE_DIALOG_SECONDARY_TEXT_PROPERTY,
	GRANITE_MESSAGE_DIALOG_IMAGE_ICON_PROPERTY,
	GRANITE_MESSAGE_DIALOG_BADGE_ICON_PROPERTY,
	GRANITE_MESSAGE_DIALOG_PRIMARY_LABEL_PROPERTY,
	GRANITE_MESSAGE_DIALOG_SECONDARY_LABEL_PROPERTY,
	GRANITE_MESSAGE_DIALOG_BUTTONS_PROPERTY,
	GRANITE_MESSAGE_DIALOG_CUSTOM_BIN_PROPERTY,
	GRANITE_MESSAGE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GRANITE_MESSAGE_DIALOG_TYPE_SINGLE_WIDGET_BIN (granite_message_dialog_single_widget_bin_get_type ())
#define GRANITE_MESSAGE_DIALOG_SINGLE_WIDGET_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_MESSAGE_DIALOG_TYPE_SINGLE_WIDGET_BIN, GraniteMessageDialogSingleWidgetBin))
#define GRANITE_MESSAGE_DIALOG_SINGLE_WIDGET_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GRANITE_MESSAGE_DIALOG_TYPE_SINGLE_WIDGET_BIN, GraniteMessageDialogSingleWidgetBinClass))
#define GRANITE_MESSAGE_DIALOG_IS_SINGLE_WIDGET_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_MESSAGE_DIALOG_TYPE_SINGLE_WIDGET_BIN))
#define GRANITE_MESSAGE_DIALOG_IS_SINGLE_WIDGET_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GRANITE_MESSAGE_DIALOG_TYPE_SINGLE_WIDGET_BIN))
#define GRANITE_MESSAGE_DIALOG_SINGLE_WIDGET_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GRANITE_MESSAGE_DIALOG_TYPE_SINGLE_WIDGET_BIN, GraniteMessageDialogSingleWidgetBinClass))

typedef struct _GraniteMessageDialogSingleWidgetBin GraniteMessageDialogSingleWidgetBin;
typedef struct _GraniteMessageDialogSingleWidgetBinClass GraniteMessageDialogSingleWidgetBinClass;
typedef struct _GraniteMessageDialogSingleWidgetBinPrivate GraniteMessageDialogSingleWidgetBinPrivate;
enum  {
	GRANITE_MESSAGE_DIALOG_SINGLE_WIDGET_BIN_0_PROPERTY,
	GRANITE_MESSAGE_DIALOG_SINGLE_WIDGET_BIN_NUM_PROPERTIES
};
static GParamSpec* granite_message_dialog_single_widget_bin_properties[GRANITE_MESSAGE_DIALOG_SINGLE_WIDGET_BIN_NUM_PROPERTIES];

struct _GraniteMessageDialogPrivate {
	GtkLabel* _primary_label;
	GtkLabel* _secondary_label;
	GtkBin* _custom_bin;
	GtkImage* image;
	GtkImage* badge;
	GtkGrid* message_grid;
	GtkTextView* details_view;
	GtkExpander* expander;
};

struct _GraniteMessageDialogSingleWidgetBin {
	GtkBin parent_instance;
	GraniteMessageDialogSingleWidgetBinPrivate * priv;
};

struct _GraniteMessageDialogSingleWidgetBinClass {
	GtkBinClass parent_class;
};

static gint GraniteMessageDialog_private_offset;
static gpointer granite_message_dialog_parent_class = NULL;
static gpointer granite_message_dialog_single_widget_bin_parent_class = NULL;

static GType granite_message_dialog_single_widget_bin_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GraniteMessageDialogSingleWidgetBin* granite_message_dialog_single_widget_bin_new (void);
static GraniteMessageDialogSingleWidgetBin* granite_message_dialog_single_widget_bin_construct (GType object_type);
static GType granite_message_dialog_single_widget_bin_get_type_once (void);
static GObject * granite_message_dialog_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _granite_message_dialog___lambda59_ (GraniteMessageDialog* self);
static void __granite_message_dialog___lambda59__gtk_container_add (GtkContainer* _sender,
                                                             GtkWidget* widget,
                                                             gpointer self);
static void _granite_message_dialog___lambda60_ (GraniteMessageDialog* self);
static void __granite_message_dialog___lambda60__gtk_container_remove (GtkContainer* _sender,
                                                                GtkWidget* widget,
                                                                gpointer self);
 G_GNUC_INTERNAL void granite_init (void);
static void granite_message_dialog_finalize (GObject * obj);
static GType granite_message_dialog_get_type_once (void);
static void _vala_granite_message_dialog_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_granite_message_dialog_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
granite_message_dialog_get_instance_private (GraniteMessageDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteMessageDialog_private_offset);
}

const gchar*
granite_message_dialog_get_primary_text (GraniteMessageDialog* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_primary_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_message_dialog_set_primary_text (GraniteMessageDialog* self,
                                         const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_primary_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_PRIMARY_TEXT_PROPERTY]);
}

const gchar*
granite_message_dialog_get_secondary_text (GraniteMessageDialog* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_secondary_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_message_dialog_set_secondary_text (GraniteMessageDialog* self,
                                           const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_secondary_label;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_SECONDARY_TEXT_PROPERTY]);
}

GIcon*
granite_message_dialog_get_image_icon (GraniteMessageDialog* self)
{
	GIcon* result;
	GtkImage* _tmp0_;
	GIcon* _tmp1_;
	GIcon* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->image;
	g_object_get (_tmp0_, "gicon", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_message_dialog_set_image_icon (GraniteMessageDialog* self,
                                       GIcon* value)
{
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->image;
	gtk_image_set_from_gicon (_tmp0_, value, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_notify_by_pspec ((GObject *) self, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_IMAGE_ICON_PROPERTY]);
}

GIcon*
granite_message_dialog_get_badge_icon (GraniteMessageDialog* self)
{
	GIcon* result;
	GtkImage* _tmp0_;
	GIcon* _tmp1_;
	GIcon* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->badge;
	g_object_get (_tmp0_, "gicon", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
granite_message_dialog_set_badge_icon (GraniteMessageDialog* self,
                                       GIcon* value)
{
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->badge;
	gtk_image_set_from_gicon (_tmp0_, value, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_notify_by_pspec ((GObject *) self, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_BADGE_ICON_PROPERTY]);
}

GtkLabel*
granite_message_dialog_get_primary_label (GraniteMessageDialog* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_primary_label;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
granite_message_dialog_set_primary_label (GraniteMessageDialog* self,
                                          GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_message_dialog_get_primary_label (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_primary_label);
		self->priv->_primary_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_PRIMARY_LABEL_PROPERTY]);
	}
}

GtkLabel*
granite_message_dialog_get_secondary_label (GraniteMessageDialog* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_secondary_label;
	result = _tmp0_;
	return result;
}

static void
granite_message_dialog_set_secondary_label (GraniteMessageDialog* self,
                                            GtkLabel* value)
{
	GtkLabel* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_message_dialog_get_secondary_label (self);
	if (old_value != value) {
		GtkLabel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_secondary_label);
		self->priv->_secondary_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_SECONDARY_LABEL_PROPERTY]);
	}
}

static void
granite_message_dialog_set_buttons (GraniteMessageDialog* self,
                                    GtkButtonsType value)
{
	g_return_if_fail (self != NULL);
	switch (value) {
		case GTK_BUTTONS_NONE:
		{
			break;
		}
		case GTK_BUTTONS_CLOSE:
		{
			gtk_dialog_add_button ((GtkDialog*) self, _ ("_Close"), (gint) GTK_RESPONSE_CLOSE);
			break;
		}
		case GTK_BUTTONS_CANCEL:
		{
			gtk_dialog_add_button ((GtkDialog*) self, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
			break;
		}
		case GTK_BUTTONS_OK:
		case GTK_BUTTONS_YES_NO:
		case GTK_BUTTONS_OK_CANCEL:
		{
			g_warning ("MessageDialog.vala:133: Unsupported GtkButtonsType value");
			break;
		}
		default:
		{
			g_warning ("MessageDialog.vala:136: Unknown GtkButtonsType value");
			break;
		}
	}
	g_object_notify_by_pspec ((GObject *) self, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_BUTTONS_PROPERTY]);
}

GtkBin*
granite_message_dialog_get_custom_bin (GraniteMessageDialog* self)
{
	GtkBin* result;
	GtkBin* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_custom_bin;
	result = _tmp0_;
	return result;
}

static void
granite_message_dialog_set_custom_bin (GraniteMessageDialog* self,
                                       GtkBin* value)
{
	GtkBin* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_message_dialog_get_custom_bin (self);
	if (old_value != value) {
		GtkBin* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_custom_bin);
		self->priv->_custom_bin = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_CUSTOM_BIN_PROPERTY]);
	}
}

/**
     * Constructs a new {@link Granite.MessageDialog}.
     * See {@link Granite.Dialog} for more details.
     *
     * @param primary_text the title of the dialog
     * @param secondary_text the body of the dialog
     * @param image_icon the {@link GLib.Icon} that is displayed on the left side of the dialog
     * @param buttons the {@link Gtk.ButtonsType} value that decides what buttons to use, defaults to {@link Gtk.ButtonsType.CLOSE},
     *        see {@link Granite.MessageDialog.buttons} on details and what values are accepted
     */
GraniteMessageDialog*
granite_message_dialog_construct (GType object_type,
                                  const gchar* primary_text,
                                  const gchar* secondary_text,
                                  GIcon* image_icon,
                                  GtkButtonsType buttons)
{
	GraniteMessageDialog * self = NULL;
	g_return_val_if_fail (primary_text != NULL, NULL);
	g_return_val_if_fail (secondary_text != NULL, NULL);
	g_return_val_if_fail (image_icon != NULL, NULL);
	self = (GraniteMessageDialog*) g_object_new (object_type, "primary-text", primary_text, "secondary-text", secondary_text, "image-icon", image_icon, "buttons", buttons, NULL);
	return self;
}

GraniteMessageDialog*
granite_message_dialog_new (const gchar* primary_text,
                            const gchar* secondary_text,
                            GIcon* image_icon,
                            GtkButtonsType buttons)
{
	return granite_message_dialog_construct (GRANITE_TYPE_MESSAGE_DIALOG, primary_text, secondary_text, image_icon, buttons);
}

/**
     * Constructs a new {@link Granite.MessageDialog} with an icon name as it's icon displayed in the image.
     * This constructor is same as the main one but with a difference that
     * you can pass an icon name string instead of manually creating the {@link GLib.Icon}.
     *
     * The {@link Granite.MessageDialog.image_icon} will store the created icon
     * so you can retrieve it later with {@link GLib.Icon.to_string}.
     *
     * See {@link Gtk.Dialog} for more details.
     *
     * @param primary_text the title of the dialog
     * @param secondary_text the body of the dialog
     * @param image_icon_name the icon name to create the dialog image with
     * @param buttons the {@link Gtk.ButtonsType} value that decides what buttons to use, defaults to {@link Gtk.ButtonsType.CLOSE},
     *        see {@link Granite.MessageDialog.buttons} on details and what values are accepted
     */
GraniteMessageDialog*
granite_message_dialog_construct_with_image_from_icon_name (GType object_type,
                                                            const gchar* primary_text,
                                                            const gchar* secondary_text,
                                                            const gchar* image_icon_name,
                                                            GtkButtonsType buttons)
{
	GraniteMessageDialog * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	g_return_val_if_fail (primary_text != NULL, NULL);
	g_return_val_if_fail (secondary_text != NULL, NULL);
	g_return_val_if_fail (image_icon_name != NULL, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (image_icon_name);
	_tmp1_ = _tmp0_;
	self = (GraniteMessageDialog*) g_object_new (object_type, "primary-text", primary_text, "secondary-text", secondary_text, "image-icon", _tmp1_, "buttons", buttons, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

GraniteMessageDialog*
granite_message_dialog_new_with_image_from_icon_name (const gchar* primary_text,
                                                      const gchar* secondary_text,
                                                      const gchar* image_icon_name,
                                                      GtkButtonsType buttons)
{
	return granite_message_dialog_construct_with_image_from_icon_name (GRANITE_TYPE_MESSAGE_DIALOG, primary_text, secondary_text, image_icon_name, buttons);
}

/**
     * Shows a terminal-like widget for error details that can be expanded by the user.
     *
     * This method can be useful to provide the user extended error details in a
     * terminal-like text view. Calling this method will not add any widgets to the
     * {@link Granite.MessageDialog.custom_bin}.
     *
     * Subsequent calls to this method will change the error message to a new one.
     *
     * @param error_message the detailed error message to display
     */
void
granite_message_dialog_show_error_details (GraniteMessageDialog* self,
                                           const gchar* error_message)
{
	GtkTextView* _tmp0_;
	GtkTextView* _tmp23_;
	GtkTextBuffer* _tmp24_;
	GtkTextBuffer* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_message != NULL);
	_tmp0_ = self->priv->details_view;
	if (_tmp0_ == NULL) {
		GtkLabel* _tmp1_;
		GtkTextView* _tmp2_;
		GtkTextView* _tmp3_;
		GtkTextView* _tmp4_;
		GtkTextView* _tmp5_;
		GtkTextView* _tmp6_;
		GtkTextView* _tmp7_;
		GtkStyleContext* _tmp8_;
		GtkScrolledWindow* scroll_box = NULL;
		GtkScrolledWindow* _tmp9_;
		GtkScrolledWindow* _tmp10_;
		GtkScrolledWindow* _tmp11_;
		GtkScrolledWindow* _tmp12_;
		GtkTextView* _tmp13_;
		GtkExpander* _tmp14_;
		GtkExpander* _tmp15_;
		GtkScrolledWindow* _tmp16_;
		GtkGrid* _tmp17_;
		GtkExpander* _tmp18_;
		GtkGrid* _tmp19_;
		GtkBin* _tmp20_;
		GtkWidget* _tmp21_;
		_tmp1_ = self->priv->_secondary_label;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp1_, 18);
		_tmp2_ = (GtkTextView*) gtk_text_view_new ();
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->details_view);
		self->priv->details_view = _tmp2_;
		_tmp3_ = self->priv->details_view;
		gtk_container_set_border_width ((GtkContainer*) _tmp3_, (guint) 6);
		_tmp4_ = self->priv->details_view;
		gtk_text_view_set_editable (_tmp4_, FALSE);
		_tmp5_ = self->priv->details_view;
		gtk_text_view_set_pixels_below_lines (_tmp5_, 3);
		_tmp6_ = self->priv->details_view;
		gtk_text_view_set_wrap_mode (_tmp6_, GTK_WRAP_WORD);
		_tmp7_ = self->priv->details_view;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
		gtk_style_context_add_class (_tmp8_, GRANITE_STYLE_CLASS_TERMINAL);
		_tmp9_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
		g_object_ref_sink (_tmp9_);
		scroll_box = _tmp9_;
		_tmp10_ = scroll_box;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 12);
		_tmp11_ = scroll_box;
		gtk_scrolled_window_set_min_content_height (_tmp11_, 70);
		_tmp12_ = scroll_box;
		_tmp13_ = self->priv->details_view;
		gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
		_tmp14_ = (GtkExpander*) gtk_expander_new (_ ("Details"));
		g_object_ref_sink (_tmp14_);
		_g_object_unref0 (self->priv->expander);
		self->priv->expander = _tmp14_;
		_tmp15_ = self->priv->expander;
		_tmp16_ = scroll_box;
		gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
		_tmp17_ = self->priv->message_grid;
		_tmp18_ = self->priv->expander;
		gtk_grid_attach (_tmp17_, (GtkWidget*) _tmp18_, 1, 2, 1, 1);
		_tmp19_ = self->priv->message_grid;
		gtk_widget_show_all ((GtkWidget*) _tmp19_);
		_tmp20_ = self->priv->_custom_bin;
		_tmp21_ = gtk_bin_get_child (_tmp20_);
		if (_tmp21_ != NULL) {
			GtkBin* _tmp22_;
			_tmp22_ = self->priv->_custom_bin;
			gtk_widget_set_margin_top ((GtkWidget*) _tmp22_, 12);
		}
		_g_object_unref0 (scroll_box);
	}
	_tmp23_ = self->priv->details_view;
	_tmp24_ = gtk_text_view_get_buffer (_tmp23_);
	_tmp25_ = _tmp24_;
	g_object_set (_tmp25_, "text", error_message, NULL);
}

static GraniteMessageDialogSingleWidgetBin*
granite_message_dialog_single_widget_bin_construct (GType object_type)
{
	GraniteMessageDialogSingleWidgetBin * self = NULL;
	self = (GraniteMessageDialogSingleWidgetBin*) g_object_new (object_type, NULL);
	return self;
}

static GraniteMessageDialogSingleWidgetBin*
granite_message_dialog_single_widget_bin_new (void)
{
	return granite_message_dialog_single_widget_bin_construct (GRANITE_MESSAGE_DIALOG_TYPE_SINGLE_WIDGET_BIN);
}

static void
granite_message_dialog_single_widget_bin_class_init (GraniteMessageDialogSingleWidgetBinClass * klass,
                                                     gpointer klass_data)
{
	granite_message_dialog_single_widget_bin_parent_class = g_type_class_peek_parent (klass);
}

static void
granite_message_dialog_single_widget_bin_instance_init (GraniteMessageDialogSingleWidgetBin * self,
                                                        gpointer klass)
{
}

/**
     * SingleWidgetBin is only used within this class for creating a Bin that
     * holds only one widget.
     */
static GType
granite_message_dialog_single_widget_bin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteMessageDialogSingleWidgetBinClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_message_dialog_single_widget_bin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteMessageDialogSingleWidgetBin), 0, (GInstanceInitFunc) granite_message_dialog_single_widget_bin_instance_init, NULL };
	GType granite_message_dialog_single_widget_bin_type_id;
	granite_message_dialog_single_widget_bin_type_id = g_type_register_static (gtk_bin_get_type (), "GraniteMessageDialogSingleWidgetBin", &g_define_type_info, 0);
	return granite_message_dialog_single_widget_bin_type_id;
}

static GType
granite_message_dialog_single_widget_bin_get_type (void)
{
	static volatile gsize granite_message_dialog_single_widget_bin_type_id__once = 0;
	if (g_once_init_enter (&granite_message_dialog_single_widget_bin_type_id__once)) {
		GType granite_message_dialog_single_widget_bin_type_id;
		granite_message_dialog_single_widget_bin_type_id = granite_message_dialog_single_widget_bin_get_type_once ();
		g_once_init_leave (&granite_message_dialog_single_widget_bin_type_id__once, granite_message_dialog_single_widget_bin_type_id);
	}
	return granite_message_dialog_single_widget_bin_type_id__once;
}

static void
_granite_message_dialog___lambda59_ (GraniteMessageDialog* self)
{
	GtkLabel* _tmp0_;
	GtkExpander* _tmp1_;
	_tmp0_ = self->priv->_secondary_label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 18);
	_tmp1_ = self->priv->expander;
	if (_tmp1_ != NULL) {
		GtkBin* _tmp2_;
		_tmp2_ = self->priv->_custom_bin;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp2_, 6);
	}
}

static void
__granite_message_dialog___lambda59__gtk_container_add (GtkContainer* _sender,
                                                        GtkWidget* widget,
                                                        gpointer self)
{
	_granite_message_dialog___lambda59_ ((GraniteMessageDialog*) self);
}

static void
_granite_message_dialog___lambda60_ (GraniteMessageDialog* self)
{
	GtkLabel* _tmp0_;
	GtkExpander* _tmp1_;
	_tmp0_ = self->priv->_secondary_label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 0);
	_tmp1_ = self->priv->expander;
	if (_tmp1_ != NULL) {
		GtkBin* _tmp2_;
		_tmp2_ = self->priv->_custom_bin;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp2_, 0);
	}
}

static void
__granite_message_dialog___lambda60__gtk_container_remove (GtkContainer* _sender,
                                                           GtkWidget* widget,
                                                           gpointer self)
{
	_granite_message_dialog___lambda60_ ((GraniteMessageDialog*) self);
}

static GObject *
granite_message_dialog_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteMessageDialog * self;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp5_;
	GtkOverlay* _tmp6_;
	GtkOverlay* _tmp7_;
	GtkImage* _tmp8_;
	GtkOverlay* _tmp9_;
	GtkImage* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GraniteMessageDialogSingleWidgetBin* _tmp26_;
	GraniteMessageDialogSingleWidgetBin* _tmp27_;
	GtkBin* _tmp28_;
	GtkBin* _tmp29_;
	GtkGrid* _tmp30_;
	GtkGrid* _tmp31_;
	GtkGrid* _tmp32_;
	GtkGrid* _tmp33_;
	GtkGrid* _tmp34_;
	GtkGrid* _tmp35_;
	GtkOverlay* _tmp36_;
	GtkGrid* _tmp37_;
	GtkLabel* _tmp38_;
	GtkGrid* _tmp39_;
	GtkLabel* _tmp40_;
	GtkGrid* _tmp41_;
	GtkBin* _tmp42_;
	GtkGrid* _tmp43_;
	GtkBox* _tmp44_;
	GtkGrid* _tmp45_;
	parent_class = G_OBJECT_CLASS (granite_message_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_MESSAGE_DIALOG, GraniteMessageDialog);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->badge);
	self->priv->badge = _tmp1_;
	_tmp2_ = self->priv->badge;
	_tmp3_ = self->priv->badge;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_END);
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_END);
	_tmp4_ = self->priv->badge;
	gtk_image_set_pixel_size (_tmp4_, 24);
	_tmp5_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp5_);
	overlay = _tmp5_;
	_tmp6_ = overlay;
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_START);
	_tmp7_ = overlay;
	_tmp8_ = self->priv->image;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = overlay;
	_tmp10_ = self->priv->badge;
	gtk_overlay_add_overlay (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	granite_message_dialog_set_primary_label (self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->_primary_label;
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
	gtk_style_context_add_class (_tmp14_, GRANITE_STYLE_CLASS_PRIMARY_LABEL);
	_tmp15_ = self->priv->_primary_label;
	gtk_label_set_selectable (_tmp15_, TRUE);
	_tmp16_ = self->priv->_primary_label;
	gtk_label_set_max_width_chars (_tmp16_, 50);
	_tmp17_ = self->priv->_primary_label;
	g_object_set (_tmp17_, "wrap", TRUE, NULL);
	_tmp18_ = self->priv->_primary_label;
	gtk_label_set_xalign (_tmp18_, (gfloat) 0);
	_tmp19_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	granite_message_dialog_set_secondary_label (self, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = self->priv->_secondary_label;
	gtk_label_set_use_markup (_tmp21_, TRUE);
	_tmp22_ = self->priv->_secondary_label;
	gtk_label_set_selectable (_tmp22_, TRUE);
	_tmp23_ = self->priv->_secondary_label;
	gtk_label_set_max_width_chars (_tmp23_, 50);
	_tmp24_ = self->priv->_secondary_label;
	g_object_set (_tmp24_, "wrap", TRUE, NULL);
	_tmp25_ = self->priv->_secondary_label;
	gtk_label_set_xalign (_tmp25_, (gfloat) 0);
	_tmp26_ = granite_message_dialog_single_widget_bin_new ();
	g_object_ref_sink (_tmp26_);
	_tmp27_ = _tmp26_;
	granite_message_dialog_set_custom_bin (self, (GtkBin*) _tmp27_);
	_g_object_unref0 (_tmp27_);
	_tmp28_ = self->priv->_custom_bin;
	g_signal_connect_object ((GtkContainer*) _tmp28_, "add", (GCallback) __granite_message_dialog___lambda59__gtk_container_add, self, 0);
	_tmp29_ = self->priv->_custom_bin;
	g_signal_connect_object ((GtkContainer*) _tmp29_, "remove", (GCallback) __granite_message_dialog___lambda60__gtk_container_remove, self, 0);
	_tmp30_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->message_grid);
	self->priv->message_grid = _tmp30_;
	_tmp31_ = self->priv->message_grid;
	gtk_grid_set_column_spacing (_tmp31_, 12);
	_tmp32_ = self->priv->message_grid;
	gtk_grid_set_row_spacing (_tmp32_, 6);
	_tmp33_ = self->priv->message_grid;
	_tmp34_ = self->priv->message_grid;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp34_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp33_, 12);
	_tmp35_ = self->priv->message_grid;
	_tmp36_ = overlay;
	gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp36_, 0, 0, 1, 2);
	_tmp37_ = self->priv->message_grid;
	_tmp38_ = self->priv->_primary_label;
	gtk_grid_attach (_tmp37_, (GtkWidget*) _tmp38_, 1, 0, 1, 1);
	_tmp39_ = self->priv->message_grid;
	_tmp40_ = self->priv->_secondary_label;
	gtk_grid_attach (_tmp39_, (GtkWidget*) _tmp40_, 1, 1, 1, 1);
	_tmp41_ = self->priv->message_grid;
	_tmp42_ = self->priv->_custom_bin;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 1, 3, 1, 1);
	_tmp43_ = self->priv->message_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp43_);
	_tmp44_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp45_ = self->priv->message_grid;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_g_object_unref0 (overlay);
	return obj;
}

static void
granite_message_dialog_base_init (GraniteMessageDialogClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), GTK_STYLE_CLASS_MESSAGE_DIALOG);
}

static void
granite_message_dialog_class_init (GraniteMessageDialogClass * klass,
                                   gpointer klass_data)
{
	granite_message_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteMessageDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_message_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_message_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_message_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_message_dialog_finalize;
	/**
	     * The primary text, title of the dialog.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MESSAGE_DIALOG_PRIMARY_TEXT_PROPERTY, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_PRIMARY_TEXT_PROPERTY] = g_param_spec_string ("primary-text", "primary-text", "primary-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The secondary text, body of the dialog.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MESSAGE_DIALOG_SECONDARY_TEXT_PROPERTY, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_SECONDARY_TEXT_PROPERTY] = g_param_spec_string ("secondary-text", "secondary-text", "secondary-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The {@link GLib.Icon} that is used to display the image
	     * on the left side of the dialog.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MESSAGE_DIALOG_IMAGE_ICON_PROPERTY, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_IMAGE_ICON_PROPERTY] = g_param_spec_object ("image-icon", "image-icon", "image-icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The {@link GLib.Icon} that is used to display a badge, bottom-end aligned,
	     * over the image on the left side of the dialog.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MESSAGE_DIALOG_BADGE_ICON_PROPERTY, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_BADGE_ICON_PROPERTY] = g_param_spec_object ("badge-icon", "badge-icon", "badge-icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The {@link Gtk.Label} that displays the {@link Granite.MessageDialog.primary_text}.
	     *
	     * Most of the times, you will only want to modify the {@link Granite.MessageDialog.primary_text} string,
	     * this is available to set additional properites like {@link Gtk.Label.use_markup} if you wish to do so.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MESSAGE_DIALOG_PRIMARY_LABEL_PROPERTY, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_PRIMARY_LABEL_PROPERTY] = g_param_spec_object ("primary-label", "primary-label", "primary-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The {@link Gtk.Label} that displays the {@link Granite.MessageDialog.secondary_text}.
	     *
	     * Most of the times, you will only want to modify the {@link Granite.MessageDialog.secondary_text} string,
	     * this is available to set additional properites like {@link Gtk.Label.use_markup} if you wish to do so.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MESSAGE_DIALOG_SECONDARY_LABEL_PROPERTY, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_SECONDARY_LABEL_PROPERTY] = g_param_spec_object ("secondary-label", "secondary-label", "secondary-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The {@link Gtk.ButtonsType} value to display a set of buttons
	     * in the dialog.
	     *
	     * By design, some actions are not acceptable and such action values will not be added to the dialog, these include:
	     *
	     *  * {@link Gtk.ButtonsType.OK}
	     *  * {@link Gtk.ButtonsType.YES_NO}
	     *  * {@link Gtk.ButtonsType.OK_CANCEL}
	     *
	     * If you wish to provide more specific actions for your dialog
	     * pass a {@link Gtk.ButtonsType.NONE} to {@link Granite.MessageDialog.MessageDialog} and manually
	     * add those actions with {@link Gtk.Dialog.add_buttons} or {@link Gtk.Dialog.add_action_widget}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MESSAGE_DIALOG_BUTTONS_PROPERTY, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_BUTTONS_PROPERTY] = g_param_spec_enum ("buttons", "buttons", "buttons", gtk_buttons_type_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The custom area to add custom widgets.
	     *
	     * This bin can be used to add any custom widget to the message area such as a {@link Gtk.ComboBox} or {@link Gtk.CheckButton}.
	     * Note that after adding such widget you will need to call {@link Gtk.Widget.show} or {@link Gtk.Widget.show_all} on the widget itself for it to appear in the dialog.
	     *
	     * If you want to add multiple widgets to this area, create a new container such as {@link Gtk.Grid} or {@link Gtk.Box} and then add it to the custom bin.
	     *
	     * When adding a custom widget to the custom bin, the {@link Granite.MessageDialog.secondary_label}'s bottom margin will be expanded automatically
	     * to compensate for the additional widget in the dialog.
	     * Removing the previously added widget will remove the bottom margin.
	     *
	     * If you don't want to have any margin between your custom widget and the {@link Granite.MessageDialog.secondary_label}, simply add your custom widget
	     * and then set the {@link Gtk.Label.margin_bottom} of {@link Granite.MessageDialog.secondary_label} to 0.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MESSAGE_DIALOG_CUSTOM_BIN_PROPERTY, granite_message_dialog_properties[GRANITE_MESSAGE_DIALOG_CUSTOM_BIN_PROPERTY] = g_param_spec_object ("custom-bin", "custom-bin", "custom-bin", gtk_bin_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	granite_init ();
}

static void
granite_message_dialog_instance_init (GraniteMessageDialog * self,
                                      gpointer klass)
{
	self->priv = granite_message_dialog_get_instance_private (self);
}

static void
granite_message_dialog_finalize (GObject * obj)
{
	GraniteMessageDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_MESSAGE_DIALOG, GraniteMessageDialog);
	_g_object_unref0 (self->priv->_primary_label);
	_g_object_unref0 (self->priv->_secondary_label);
	_g_object_unref0 (self->priv->_custom_bin);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->badge);
	_g_object_unref0 (self->priv->message_grid);
	_g_object_unref0 (self->priv->details_view);
	_g_object_unref0 (self->priv->expander);
	G_OBJECT_CLASS (granite_message_dialog_parent_class)->finalize (obj);
}

/**
 * MessageDialog is an elementary OS styled dialog used to display a message to the user.
 *
 * The class itself is similar to it's Gtk equivalent {@link Gtk.MessageDialog}
 * but follows elementary OS design conventions.
 *
 * See [[https://elementary.io/docs/human-interface-guidelines#dialogs|The Human Interface Guidelines for dialogs]]
 * for more detailed disscussion on the dialog wording and design.
 *
 * ''Example''<<BR>>
 * {{{
 *   var message_dialog = new Granite.MessageDialog.with_image_from_icon_name (
 *      "This is a primary text",
 *      "This is a secondary, multiline, long text. This text usually extends the primary text and prints e.g: the details of an error.",
 *      "applications-development",
 *      Gtk.ButtonsType.CLOSE
 *   );
 *
 *   var custom_widget = new Gtk.CheckButton.with_label ("Custom widget");
 *   custom_widget.show ();
 *
 *   message_dialog.custom_bin.add (custom_widget);
 *   message_dialog.run ();
 *   message_dialog.destroy ();
 * }}}
 *
 * {{../doc/images/MessageDialog.png}}
 */
static GType
granite_message_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteMessageDialogClass), (GBaseInitFunc) granite_message_dialog_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_message_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteMessageDialog), 0, (GInstanceInitFunc) granite_message_dialog_instance_init, NULL };
	GType granite_message_dialog_type_id;
	granite_message_dialog_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "GraniteMessageDialog", &g_define_type_info, 0);
	GraniteMessageDialog_private_offset = g_type_add_instance_private (granite_message_dialog_type_id, sizeof (GraniteMessageDialogPrivate));
	return granite_message_dialog_type_id;
}

GType
granite_message_dialog_get_type (void)
{
	static volatile gsize granite_message_dialog_type_id__once = 0;
	if (g_once_init_enter (&granite_message_dialog_type_id__once)) {
		GType granite_message_dialog_type_id;
		granite_message_dialog_type_id = granite_message_dialog_get_type_once ();
		g_once_init_leave (&granite_message_dialog_type_id__once, granite_message_dialog_type_id);
	}
	return granite_message_dialog_type_id__once;
}

static void
_vala_granite_message_dialog_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GraniteMessageDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_MESSAGE_DIALOG, GraniteMessageDialog);
	switch (property_id) {
		case GRANITE_MESSAGE_DIALOG_PRIMARY_TEXT_PROPERTY:
		g_value_set_string (value, granite_message_dialog_get_primary_text (self));
		break;
		case GRANITE_MESSAGE_DIALOG_SECONDARY_TEXT_PROPERTY:
		g_value_set_string (value, granite_message_dialog_get_secondary_text (self));
		break;
		case GRANITE_MESSAGE_DIALOG_IMAGE_ICON_PROPERTY:
		g_value_take_object (value, granite_message_dialog_get_image_icon (self));
		break;
		case GRANITE_MESSAGE_DIALOG_BADGE_ICON_PROPERTY:
		g_value_take_object (value, granite_message_dialog_get_badge_icon (self));
		break;
		case GRANITE_MESSAGE_DIALOG_PRIMARY_LABEL_PROPERTY:
		g_value_set_object (value, granite_message_dialog_get_primary_label (self));
		break;
		case GRANITE_MESSAGE_DIALOG_SECONDARY_LABEL_PROPERTY:
		g_value_set_object (value, granite_message_dialog_get_secondary_label (self));
		break;
		case GRANITE_MESSAGE_DIALOG_CUSTOM_BIN_PROPERTY:
		g_value_set_object (value, granite_message_dialog_get_custom_bin (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_message_dialog_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GraniteMessageDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_MESSAGE_DIALOG, GraniteMessageDialog);
	switch (property_id) {
		case GRANITE_MESSAGE_DIALOG_PRIMARY_TEXT_PROPERTY:
		granite_message_dialog_set_primary_text (self, g_value_get_string (value));
		break;
		case GRANITE_MESSAGE_DIALOG_SECONDARY_TEXT_PROPERTY:
		granite_message_dialog_set_secondary_text (self, g_value_get_string (value));
		break;
		case GRANITE_MESSAGE_DIALOG_IMAGE_ICON_PROPERTY:
		granite_message_dialog_set_image_icon (self, g_value_get_object (value));
		break;
		case GRANITE_MESSAGE_DIALOG_BADGE_ICON_PROPERTY:
		granite_message_dialog_set_badge_icon (self, g_value_get_object (value));
		break;
		case GRANITE_MESSAGE_DIALOG_PRIMARY_LABEL_PROPERTY:
		granite_message_dialog_set_primary_label (self, g_value_get_object (value));
		break;
		case GRANITE_MESSAGE_DIALOG_SECONDARY_LABEL_PROPERTY:
		granite_message_dialog_set_secondary_label (self, g_value_get_object (value));
		break;
		case GRANITE_MESSAGE_DIALOG_BUTTONS_PROPERTY:
		granite_message_dialog_set_buttons (self, g_value_get_enum (value));
		break;
		case GRANITE_MESSAGE_DIALOG_CUSTOM_BIN_PROPERTY:
		granite_message_dialog_set_custom_bin (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

