// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Sum represents the type of a numeric metric that is calculated as a sum of all reported measurements over a time interval.
type Sum struct {
	DataPoints             []*NumberDataPoint
	AggregationTemporality AggregationTemporality
	IsMonotonic            bool
}

var (
	protoPoolSum = sync.Pool{
		New: func() any {
			return &Sum{}
		},
	}
)

func NewSum() *Sum {
	if !UseProtoPooling.IsEnabled() {
		return &Sum{}
	}
	return protoPoolSum.Get().(*Sum)
}

func DeleteSum(orig *Sum, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.DataPoints {
		DeleteNumberDataPoint(orig.DataPoints[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolSum.Put(orig)
	}
}

func CopySum(dest, src *Sum) *Sum {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewSum()
	}
	dest.DataPoints = CopyNumberDataPointPtrSlice(dest.DataPoints, src.DataPoints)

	dest.AggregationTemporality = src.AggregationTemporality
	dest.IsMonotonic = src.IsMonotonic

	return dest
}

func CopySumSlice(dest, src []Sum) []Sum {
	var newDest []Sum
	if cap(dest) < len(src) {
		newDest = make([]Sum, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSum(&dest[i], false)
		}
	}
	for i := range src {
		CopySum(&newDest[i], &src[i])
	}
	return newDest
}

func CopySumPtrSlice(dest, src []*Sum) []*Sum {
	var newDest []*Sum
	if cap(dest) < len(src) {
		newDest = make([]*Sum, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSum()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSum(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSum()
		}
	}
	for i := range src {
		CopySum(newDest[i], src[i])
	}
	return newDest
}

func (orig *Sum) Reset() {
	*orig = Sum{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Sum) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.DataPoints) > 0 {
		dest.WriteObjectField("dataPoints")
		dest.WriteArrayStart()
		orig.DataPoints[0].MarshalJSON(dest)
		for i := 1; i < len(orig.DataPoints); i++ {
			dest.WriteMore()
			orig.DataPoints[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}

	if int32(orig.AggregationTemporality) != 0 {
		dest.WriteObjectField("aggregationTemporality")
		dest.WriteInt32(int32(orig.AggregationTemporality))
	}
	if orig.IsMonotonic != false {
		dest.WriteObjectField("isMonotonic")
		dest.WriteBool(orig.IsMonotonic)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Sum) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "dataPoints", "data_points":
			for iter.ReadArray() {
				orig.DataPoints = append(orig.DataPoints, NewNumberDataPoint())
				orig.DataPoints[len(orig.DataPoints)-1].UnmarshalJSON(iter)
			}

		case "aggregationTemporality", "aggregation_temporality":
			orig.AggregationTemporality = AggregationTemporality(iter.ReadEnumValue(AggregationTemporality_value))
		case "isMonotonic", "is_monotonic":
			orig.IsMonotonic = iter.ReadBool()
		default:
			iter.Skip()
		}
	}
}

func (orig *Sum) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.DataPoints {
		l = orig.DataPoints[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.AggregationTemporality != AggregationTemporality(0) {
		n += 1 + proto.Sov(uint64(orig.AggregationTemporality))
	}
	if orig.IsMonotonic != false {
		n += 2
	}
	return n
}

func (orig *Sum) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.DataPoints) - 1; i >= 0; i-- {
		l = orig.DataPoints[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.AggregationTemporality != AggregationTemporality(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.AggregationTemporality))
		pos--
		buf[pos] = 0x10
	}
	if orig.IsMonotonic != false {
		pos--
		if orig.IsMonotonic {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x18
	}
	return len(buf) - pos
}

func (orig *Sum) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field DataPoints", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.DataPoints = append(orig.DataPoints, NewNumberDataPoint())
			err = orig.DataPoints[len(orig.DataPoints)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field AggregationTemporality", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.AggregationTemporality = AggregationTemporality(num)

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field IsMonotonic", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.IsMonotonic = num != 0
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestSum() *Sum {
	orig := NewSum()
	orig.DataPoints = []*NumberDataPoint{{}, GenTestNumberDataPoint()}
	orig.AggregationTemporality = AggregationTemporality(13)
	orig.IsMonotonic = true
	return orig
}

func GenTestSumPtrSlice() []*Sum {
	orig := make([]*Sum, 5)
	orig[0] = NewSum()
	orig[1] = GenTestSum()
	orig[2] = NewSum()
	orig[3] = GenTestSum()
	orig[4] = NewSum()
	return orig
}

func GenTestSumSlice() []Sum {
	orig := make([]Sum, 5)
	orig[1] = *GenTestSum()
	orig[3] = *GenTestSum()
	return orig
}
