// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package generictracer

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfTPDebugCallProtocolArgsT struct {
	_               structs.HostLayout
	PidConn         BpfTPDebugPidConnectionInfoT
	ProtocolType    BpfTPDebugProtocolType
	Ssl             uint8
	Direction       uint8
	PacketType      uint8
	SmallBuf        [24]uint8
	Pad             [4]uint8
	BytesLen        int32
	OrigDport       uint16
	Pad2            uint16
	U_buf           uint64
	SelfRefParentId uint64
}

type BpfTPDebugConnectionInfoPartT struct {
	_    structs.HostLayout
	Addr [16]uint8
	Pid  uint32
	Port uint16
	Type uint8
	Pad  uint8
}

type BpfTPDebugConnectionInfoT struct {
	_      structs.HostLayout
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type BpfTPDebugCpSupportDataT struct {
	_           structs.HostLayout
	T_key       BpfTPDebugTraceKeyT
	Ts          uint64
	RealClient  uint8
	Established uint8
	Failed      uint8
	Pad         [5]uint8
}

type BpfTPDebugEgressKeyT struct {
	_      structs.HostLayout
	S_port uint16
	D_port uint16
}

type BpfTPDebugFdInfoT struct {
	_    structs.HostLayout
	Pid  BpfTPDebugPidKeyT
	Fd   int32
	Type uint32
}

type BpfTPDebugFdKey struct {
	_       structs.HostLayout
	PidTgid uint64
	Fd      int32
	Pad     [4]uint8
}

type BpfTPDebugGrpcFramesCtxT struct {
	_               structs.HostLayout
	PrevInfo        BpfTPDebugHttp2GrpcRequestT
	HasPrevInfo     uint8
	FoundDataFrame  uint8
	Iterations      uint8
	TerminateSearch uint8
	Pos             int32
	SavedBufPos     int32
	SavedStreamId   uint32
	Args            BpfTPDebugCallProtocolArgsT
	Stream          BpfTPDebugHttp2ConnStreamT
	Pad             [4]uint8
}

type BpfTPDebugHttp2ConnInfoDataT struct {
	_     structs.HostLayout
	Id    uint64
	Flags uint8
	Pad   [7]uint8
}

type BpfTPDebugHttp2ConnStreamT struct {
	_        structs.HostLayout
	PidConn  BpfTPDebugPidConnectionInfoT
	StreamId uint32
}

type BpfTPDebugHttp2GrpcRequestT struct {
	_               structs.HostLayout
	Flags           uint8
	Ssl             uint8
	Type            uint8
	Pad0            [1]uint8
	ConnInfo        BpfTPDebugConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Data            [256]uint8
	RetData         [64]uint8
	Len             int32
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	NewConnId uint64
	Tp        struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type BpfTPDebugHttpConnectionMetadataT struct {
	_   structs.HostLayout
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Type uint8
	Pad  [3]uint8
}

type BpfTPDebugHttpInfoT struct {
	_               structs.HostLayout
	Flags           uint8
	Type            uint8
	Ssl             uint8
	Delayed         uint8
	ConnInfo        BpfTPDebugConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ReqMonotimeNs   uint64
	ExtraId         uint64
	Tp              struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Len             uint32
	RespLen         uint32
	TaskTid         uint32
	Status          uint16
	Buf             [256]uint8
	HasLargeBuffers uint8
	Direction       uint8
	Submitted       uint8
	Pad             [3]uint8
}

type BpfTPDebugMsgBufferT struct {
	_           structs.HostLayout
	FallbackBuf [256]uint8
	Pos         uint16
	RealSize    uint16
	CpuId       uint32
}

type BpfTPDebugMysqlStateData struct {
	_             structs.HostLayout
	PayloadLength [3]uint8
	SequenceId    uint8
}

type BpfTPDebugPartialConnectionInfoT struct {
	_      structs.HostLayout
	S_addr [16]uint8
	S_port uint16
	D_port uint16
	TcpSeq uint32
}

type BpfTPDebugPidConnectionInfoT struct {
	_    structs.HostLayout
	Conn BpfTPDebugConnectionInfoT
	Pid  uint32
}

type BpfTPDebugPidKeyT struct {
	_   structs.HostLayout
	Tid uint32
	Pid uint32
	Ns  uint32
}

type BpfTPDebugProtocolType uint8

const (
	BpfTPDebugProtocolTypeK_protocolTypeUnknown  BpfTPDebugProtocolType = 0
	BpfTPDebugProtocolTypeK_protocolTypeMysql    BpfTPDebugProtocolType = 1
	BpfTPDebugProtocolTypeK_protocolTypePostgres BpfTPDebugProtocolType = 2
	BpfTPDebugProtocolTypeK_protocolTypeHttp     BpfTPDebugProtocolType = 3
)

type BpfTPDebugRecvArgsT struct {
	_        structs.HostLayout
	SockPtr  uint64
	IovecCtx [40]uint8
}

type BpfTPDebugSendArgsT struct {
	_         structs.HostLayout
	P_conn    BpfTPDebugPidConnectionInfoT
	Size      uint64
	SockPtr   uint64
	OrigDport uint16
	Pad       [6]uint8
}

type BpfTPDebugSockArgsT struct {
	_      structs.HostLayout
	Addr   uint64
	Ts     uint64
	Fd     int32
	Failed uint8
	Pad    [3]uint8
}

type BpfTPDebugSockPortNs struct {
	_     structs.HostLayout
	Netns uint32
	Port  uint16
	Pad   [2]uint8
}

type BpfTPDebugSslArgsT struct {
	_      structs.HostLayout
	Ssl    uint64
	Buf    uint64
	LenPtr uint64
	Flags  uint64
}

type BpfTPDebugSslPidConnectionInfoT struct {
	_         structs.HostLayout
	P_conn    BpfTPDebugPidConnectionInfoT
	OrigDport uint16
	Pad       [6]uint8
}

type BpfTPDebugTcpReqT struct {
	_               structs.HostLayout
	Flags           uint8
	Ssl             uint8
	Direction       uint8
	HasLargeBuffers uint8
	ProtocolType    BpfTPDebugProtocolType
	Pad1            [3]uint8
	ConnInfo        BpfTPDebugConnectionInfoT
	Len             uint32
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ExtraId         uint64
	ReqLen          uint32
	RespLen         uint32
	Pad2            [4]uint8
	Buf             [256]uint8
	Rbuf            [128]uint8
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Tp struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type BpfTPDebugTpInfoPidT struct {
	_  structs.HostLayout
	Tp struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type BpfTPDebugTraceKeyT struct {
	_       structs.HostLayout
	ExtraId uint64
	P_key   BpfTPDebugPidKeyT
	Pad     [4]uint8
}

type BpfTPDebugTraceMapKeyT struct {
	_    structs.HostLayout
	Conn BpfTPDebugConnectionInfoT
	Type uint32
}

// LoadBpfTPDebug returns the embedded CollectionSpec for BpfTPDebug.
func LoadBpfTPDebug() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfTPDebugBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load BpfTPDebug: %w", err)
	}

	return spec, err
}

// LoadBpfTPDebugObjects loads BpfTPDebug and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfTPDebugObjects
//	*BpfTPDebugPrograms
//	*BpfTPDebugMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfTPDebugObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpfTPDebug()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfTPDebugSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfTPDebugSpecs struct {
	BpfTPDebugProgramSpecs
	BpfTPDebugMapSpecs
	BpfTPDebugVariableSpecs
}

// BpfTPDebugProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfTPDebugProgramSpecs struct {
	ObiContinue2ProtocolHttp             *ebpf.ProgramSpec `ebpf:"obi_continue2_protocol_http"`
	ObiContinueProtocolHttp              *ebpf.ProgramSpec `ebpf:"obi_continue_protocol_http"`
	ObiHandleBufWithArgs                 *ebpf.ProgramSpec `ebpf:"obi_handle_buf_with_args"`
	ObiIterTcp                           *ebpf.ProgramSpec `ebpf:"obi_iter_tcp"`
	ObiKprobeDoVfsIoctl                  *ebpf.ProgramSpec `ebpf:"obi_kprobe_do_vfs_ioctl"`
	ObiKprobeInetCskListenStop           *ebpf.ProgramSpec `ebpf:"obi_kprobe_inet_csk_listen_stop"`
	ObiKprobeSecuritySocketAccept        *ebpf.ProgramSpec `ebpf:"obi_kprobe_security_socket_accept"`
	ObiKprobeSockDefErrorReport          *ebpf.ProgramSpec `ebpf:"obi_kprobe_sock_def_error_report"`
	ObiKprobeSockRecvmsg                 *ebpf.ProgramSpec `ebpf:"obi_kprobe_sock_recvmsg"`
	ObiKprobeSysConnect                  *ebpf.ProgramSpec `ebpf:"obi_kprobe_sys_connect"`
	ObiKprobeSysExit                     *ebpf.ProgramSpec `ebpf:"obi_kprobe_sys_exit"`
	ObiKprobeTcpCleanupRbuf              *ebpf.ProgramSpec `ebpf:"obi_kprobe_tcp_cleanup_rbuf"`
	ObiKprobeTcpClose                    *ebpf.ProgramSpec `ebpf:"obi_kprobe_tcp_close"`
	ObiKprobeTcpConnect                  *ebpf.ProgramSpec `ebpf:"obi_kprobe_tcp_connect"`
	ObiKprobeTcpRateCheckAppLimited      *ebpf.ProgramSpec `ebpf:"obi_kprobe_tcp_rate_check_app_limited"`
	ObiKprobeTcpRecvmsg                  *ebpf.ProgramSpec `ebpf:"obi_kprobe_tcp_recvmsg"`
	ObiKprobeTcpSendmsg                  *ebpf.ProgramSpec `ebpf:"obi_kprobe_tcp_sendmsg"`
	ObiKprobeUdpSendmsg                  *ebpf.ProgramSpec `ebpf:"obi_kprobe_udp_sendmsg"`
	ObiKprobeUnixStreamRecvmsg           *ebpf.ProgramSpec `ebpf:"obi_kprobe_unix_stream_recvmsg"`
	ObiKprobeUnixStreamSendmsg           *ebpf.ProgramSpec `ebpf:"obi_kprobe_unix_stream_sendmsg"`
	ObiKretprobeSockRecvmsg              *ebpf.ProgramSpec `ebpf:"obi_kretprobe_sock_recvmsg"`
	ObiKretprobeSysAccept4               *ebpf.ProgramSpec `ebpf:"obi_kretprobe_sys_accept4"`
	ObiKretprobeSysClone                 *ebpf.ProgramSpec `ebpf:"obi_kretprobe_sys_clone"`
	ObiKretprobeSysConnect               *ebpf.ProgramSpec `ebpf:"obi_kretprobe_sys_connect"`
	ObiKretprobeTcpRecvmsg               *ebpf.ProgramSpec `ebpf:"obi_kretprobe_tcp_recvmsg"`
	ObiKretprobeTcpSendmsg               *ebpf.ProgramSpec `ebpf:"obi_kretprobe_tcp_sendmsg"`
	ObiKretprobeUnixStreamRecvmsg        *ebpf.ProgramSpec `ebpf:"obi_kretprobe_unix_stream_recvmsg"`
	ObiKretprobeUnixStreamSendmsg        *ebpf.ProgramSpec `ebpf:"obi_kretprobe_unix_stream_sendmsg"`
	ObiNgxEventConnectPeerRet            *ebpf.ProgramSpec `ebpf:"obi_ngx_event_connect_peer_ret"`
	ObiNgxHttpUpstreamInit               *ebpf.ProgramSpec `ebpf:"obi_ngx_http_upstream_init"`
	ObiProtocolHttp                      *ebpf.ProgramSpec `ebpf:"obi_protocol_http"`
	ObiProtocolHttp2                     *ebpf.ProgramSpec `ebpf:"obi_protocol_http2"`
	ObiProtocolHttp2GrpcFrames           *ebpf.ProgramSpec `ebpf:"obi_protocol_http2_grpc_frames"`
	ObiProtocolHttp2GrpcHandleEndFrame   *ebpf.ProgramSpec `ebpf:"obi_protocol_http2_grpc_handle_end_frame"`
	ObiProtocolHttp2GrpcHandleStartFrame *ebpf.ProgramSpec `ebpf:"obi_protocol_http2_grpc_handle_start_frame"`
	ObiProtocolHttpLegacy                *ebpf.ProgramSpec `ebpf:"obi_protocol_http_legacy"`
	ObiProtocolTcp                       *ebpf.ProgramSpec `ebpf:"obi_protocol_tcp"`
	ObiSocketHttpFilter                  *ebpf.ProgramSpec `ebpf:"obi_socket__http_filter"`
	ObiUprobeSslRead                     *ebpf.ProgramSpec `ebpf:"obi_uprobe_ssl_read"`
	ObiUprobeSslReadEx                   *ebpf.ProgramSpec `ebpf:"obi_uprobe_ssl_read_ex"`
	ObiUprobeSslShutdown                 *ebpf.ProgramSpec `ebpf:"obi_uprobe_ssl_shutdown"`
	ObiUprobeSslWrite                    *ebpf.ProgramSpec `ebpf:"obi_uprobe_ssl_write"`
	ObiUprobeSslWriteEx                  *ebpf.ProgramSpec `ebpf:"obi_uprobe_ssl_write_ex"`
	ObiUretprobeSslRead                  *ebpf.ProgramSpec `ebpf:"obi_uretprobe_ssl_read"`
	ObiUretprobeSslReadEx                *ebpf.ProgramSpec `ebpf:"obi_uretprobe_ssl_read_ex"`
	ObiUretprobeSslWrite                 *ebpf.ProgramSpec `ebpf:"obi_uretprobe_ssl_write"`
	ObiUretprobeSslWriteEx               *ebpf.ProgramSpec `ebpf:"obi_uretprobe_ssl_write_ex"`
	ObiUvFsAccess                        *ebpf.ProgramSpec `ebpf:"obi_uv_fs_access"`
}

// BpfTPDebugMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfTPDebugMapSpecs struct {
	AcceptedConnections         *ebpf.MapSpec `ebpf:"accepted_connections"`
	ActiveAcceptArgs            *ebpf.MapSpec `ebpf:"active_accept_args"`
	ActiveConnectArgs           *ebpf.MapSpec `ebpf:"active_connect_args"`
	ActiveRecvArgs              *ebpf.MapSpec `ebpf:"active_recv_args"`
	ActiveSendArgs              *ebpf.MapSpec `ebpf:"active_send_args"`
	ActiveSendSockArgs          *ebpf.MapSpec `ebpf:"active_send_sock_args"`
	ActiveSslConnections        *ebpf.MapSpec `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs           *ebpf.MapSpec `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs          *ebpf.MapSpec `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks             *ebpf.MapSpec `ebpf:"active_unix_socks"`
	CloneMap                    *ebpf.MapSpec `ebpf:"clone_map"`
	ConnectionMetaMem           *ebpf.MapSpec `ebpf:"connection_meta_mem"`
	CpSupportConnectInfo        *ebpf.MapSpec `ebpf:"cp_support_connect_info"`
	DebugEvents                 *ebpf.MapSpec `ebpf:"debug_events"`
	Events                      *ebpf.MapSpec `ebpf:"events"`
	FdMap                       *ebpf.MapSpec `ebpf:"fd_map"`
	FdToConnection              *ebpf.MapSpec `ebpf:"fd_to_connection"`
	GrpcFramesCtxMem            *ebpf.MapSpec `ebpf:"grpc_frames_ctx_mem"`
	Http2InfoMem                *ebpf.MapSpec `ebpf:"http2_info_mem"`
	HttpInfoMem                 *ebpf.MapSpec `ebpf:"http_info_mem"`
	HttpLargeBuffersStorage     *ebpf.MapSpec `ebpf:"http_large_buffers_storage"`
	IncomingTraceMap            *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	IovecMem                    *ebpf.MapSpec `ebpf:"iovec_mem"`
	JumpTable                   *ebpf.MapSpec `ebpf:"jump_table"`
	ListeningPorts              *ebpf.MapSpec `ebpf:"listening_ports"`
	MsgBufferMem                *ebpf.MapSpec `ebpf:"msg_buffer_mem"`
	MsgBuffers                  *ebpf.MapSpec `ebpf:"msg_buffers"`
	MysqlLargeBuffersStorage    *ebpf.MapSpec `ebpf:"mysql_large_buffers_storage"`
	MysqlState                  *ebpf.MapSpec `ebpf:"mysql_state"`
	NginxUpstream               *ebpf.MapSpec `ebpf:"nginx_upstream"`
	NodejsFdMap                 *ebpf.MapSpec `ebpf:"nodejs_fd_map"`
	OngoingHttp                 *ebpf.MapSpec `ebpf:"ongoing_http"`
	OngoingHttp2Connections     *ebpf.MapSpec `ebpf:"ongoing_http2_connections"`
	OngoingHttp2Grpc            *ebpf.MapSpec `ebpf:"ongoing_http2_grpc"`
	OngoingTcpReq               *ebpf.MapSpec `ebpf:"ongoing_tcp_req"`
	OutgoingTraceMap            *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	PidCache                    *ebpf.MapSpec `ebpf:"pid_cache"`
	PidTidToConn                *ebpf.MapSpec `ebpf:"pid_tid_to_conn"`
	PostgresLargeBuffersStorage *ebpf.MapSpec `ebpf:"postgres_large_buffers_storage"`
	ProtocolArgsMem             *ebpf.MapSpec `ebpf:"protocol_args_mem"`
	ProtocolCache               *ebpf.MapSpec `ebpf:"protocol_cache"`
	ServerTraces                *ebpf.MapSpec `ebpf:"server_traces"`
	ServerTracesAux             *ebpf.MapSpec `ebpf:"server_traces_aux"`
	SockPids                    *ebpf.MapSpec `ebpf:"sock_pids"`
	SslToConn                   *ebpf.MapSpec `ebpf:"ssl_to_conn"`
	SslToPidTid                 *ebpf.MapSpec `ebpf:"ssl_to_pid_tid"`
	TcpConnectionMap            *ebpf.MapSpec `ebpf:"tcp_connection_map"`
	TcpReqMem                   *ebpf.MapSpec `ebpf:"tcp_req_mem"`
	TpCharBufMem                *ebpf.MapSpec `ebpf:"tp_char_buf_mem"`
	TpInfoMem                   *ebpf.MapSpec `ebpf:"tp_info_mem"`
	TraceMap                    *ebpf.MapSpec `ebpf:"trace_map"`
	UpstreamInitArgs            *ebpf.MapSpec `ebpf:"upstream_init_args"`
	ValidPids                   *ebpf.MapSpec `ebpf:"valid_pids"`
}

// BpfTPDebugVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfTPDebugVariableSpecs struct {
	EXTEND_SIZE              *ebpf.VariableSpec `ebpf:"EXTEND_SIZE"`
	INVALID_POS              *ebpf.VariableSpec `ebpf:"INVALID_POS"`
	TP                       *ebpf.VariableSpec `ebpf:"TP"`
	TP_PREFIX                *ebpf.VariableSpec `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE           *ebpf.VariableSpec `ebpf:"TP_PREFIX_SIZE"`
	PnUnused                 *ebpf.VariableSpec `ebpf:"__pn_unused"`
	CaptureHeaderBuffer      *ebpf.VariableSpec `ebpf:"capture_header_buffer"`
	DisableBlackBoxCp        *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	FilterPids               *ebpf.VariableSpec `ebpf:"filter_pids"`
	HighRequestVolume        *ebpf.VariableSpec `ebpf:"high_request_volume"`
	HttpBufferSize           *ebpf.VariableSpec `ebpf:"http_buffer_size"`
	Ip4ip6Prefix             *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	MaxTransactionTime       *ebpf.VariableSpec `ebpf:"max_transaction_time"`
	MysqlBufferSize          *ebpf.VariableSpec `ebpf:"mysql_buffer_size"`
	NgxConnectionS_fd        *ebpf.VariableSpec `ebpf:"ngx_connection_s_fd"`
	NgxConnectionS_sockaddr  *ebpf.VariableSpec `ebpf:"ngx_connection_s_sockaddr"`
	NgxHttpRequestS_conn     *ebpf.VariableSpec `ebpf:"ngx_http_request_s_conn"`
	NgxHttpRequestS_upstream *ebpf.VariableSpec `ebpf:"ngx_http_request_s_upstream"`
	NgxHttpRevS_conn         *ebpf.VariableSpec `ebpf:"ngx_http_rev_s_conn"`
	NgxHttpUpstreamS_conn    *ebpf.VariableSpec `ebpf:"ngx_http_upstream_s_conn"`
	PostgresBufferSize       *ebpf.VariableSpec `ebpf:"postgres_buffer_size"`
	Unused                   *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2              *ebpf.VariableSpec `ebpf:"unused_http2"`
	WakeupDataBytes          *ebpf.VariableSpec `ebpf:"wakeup_data_bytes"`
}

// BpfTPDebugObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfTPDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfTPDebugObjects struct {
	BpfTPDebugPrograms
	BpfTPDebugMaps
	BpfTPDebugVariables
}

func (o *BpfTPDebugObjects) Close() error {
	return _BpfTPDebugClose(
		&o.BpfTPDebugPrograms,
		&o.BpfTPDebugMaps,
	)
}

// BpfTPDebugMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfTPDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfTPDebugMaps struct {
	AcceptedConnections         *ebpf.Map `ebpf:"accepted_connections"`
	ActiveAcceptArgs            *ebpf.Map `ebpf:"active_accept_args"`
	ActiveConnectArgs           *ebpf.Map `ebpf:"active_connect_args"`
	ActiveRecvArgs              *ebpf.Map `ebpf:"active_recv_args"`
	ActiveSendArgs              *ebpf.Map `ebpf:"active_send_args"`
	ActiveSendSockArgs          *ebpf.Map `ebpf:"active_send_sock_args"`
	ActiveSslConnections        *ebpf.Map `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs           *ebpf.Map `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs          *ebpf.Map `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks             *ebpf.Map `ebpf:"active_unix_socks"`
	CloneMap                    *ebpf.Map `ebpf:"clone_map"`
	ConnectionMetaMem           *ebpf.Map `ebpf:"connection_meta_mem"`
	CpSupportConnectInfo        *ebpf.Map `ebpf:"cp_support_connect_info"`
	DebugEvents                 *ebpf.Map `ebpf:"debug_events"`
	Events                      *ebpf.Map `ebpf:"events"`
	FdMap                       *ebpf.Map `ebpf:"fd_map"`
	FdToConnection              *ebpf.Map `ebpf:"fd_to_connection"`
	GrpcFramesCtxMem            *ebpf.Map `ebpf:"grpc_frames_ctx_mem"`
	Http2InfoMem                *ebpf.Map `ebpf:"http2_info_mem"`
	HttpInfoMem                 *ebpf.Map `ebpf:"http_info_mem"`
	HttpLargeBuffersStorage     *ebpf.Map `ebpf:"http_large_buffers_storage"`
	IncomingTraceMap            *ebpf.Map `ebpf:"incoming_trace_map"`
	IovecMem                    *ebpf.Map `ebpf:"iovec_mem"`
	JumpTable                   *ebpf.Map `ebpf:"jump_table"`
	ListeningPorts              *ebpf.Map `ebpf:"listening_ports"`
	MsgBufferMem                *ebpf.Map `ebpf:"msg_buffer_mem"`
	MsgBuffers                  *ebpf.Map `ebpf:"msg_buffers"`
	MysqlLargeBuffersStorage    *ebpf.Map `ebpf:"mysql_large_buffers_storage"`
	MysqlState                  *ebpf.Map `ebpf:"mysql_state"`
	NginxUpstream               *ebpf.Map `ebpf:"nginx_upstream"`
	NodejsFdMap                 *ebpf.Map `ebpf:"nodejs_fd_map"`
	OngoingHttp                 *ebpf.Map `ebpf:"ongoing_http"`
	OngoingHttp2Connections     *ebpf.Map `ebpf:"ongoing_http2_connections"`
	OngoingHttp2Grpc            *ebpf.Map `ebpf:"ongoing_http2_grpc"`
	OngoingTcpReq               *ebpf.Map `ebpf:"ongoing_tcp_req"`
	OutgoingTraceMap            *ebpf.Map `ebpf:"outgoing_trace_map"`
	PidCache                    *ebpf.Map `ebpf:"pid_cache"`
	PidTidToConn                *ebpf.Map `ebpf:"pid_tid_to_conn"`
	PostgresLargeBuffersStorage *ebpf.Map `ebpf:"postgres_large_buffers_storage"`
	ProtocolArgsMem             *ebpf.Map `ebpf:"protocol_args_mem"`
	ProtocolCache               *ebpf.Map `ebpf:"protocol_cache"`
	ServerTraces                *ebpf.Map `ebpf:"server_traces"`
	ServerTracesAux             *ebpf.Map `ebpf:"server_traces_aux"`
	SockPids                    *ebpf.Map `ebpf:"sock_pids"`
	SslToConn                   *ebpf.Map `ebpf:"ssl_to_conn"`
	SslToPidTid                 *ebpf.Map `ebpf:"ssl_to_pid_tid"`
	TcpConnectionMap            *ebpf.Map `ebpf:"tcp_connection_map"`
	TcpReqMem                   *ebpf.Map `ebpf:"tcp_req_mem"`
	TpCharBufMem                *ebpf.Map `ebpf:"tp_char_buf_mem"`
	TpInfoMem                   *ebpf.Map `ebpf:"tp_info_mem"`
	TraceMap                    *ebpf.Map `ebpf:"trace_map"`
	UpstreamInitArgs            *ebpf.Map `ebpf:"upstream_init_args"`
	ValidPids                   *ebpf.Map `ebpf:"valid_pids"`
}

func (m *BpfTPDebugMaps) Close() error {
	return _BpfTPDebugClose(
		m.AcceptedConnections,
		m.ActiveAcceptArgs,
		m.ActiveConnectArgs,
		m.ActiveRecvArgs,
		m.ActiveSendArgs,
		m.ActiveSendSockArgs,
		m.ActiveSslConnections,
		m.ActiveSslReadArgs,
		m.ActiveSslWriteArgs,
		m.ActiveUnixSocks,
		m.CloneMap,
		m.ConnectionMetaMem,
		m.CpSupportConnectInfo,
		m.DebugEvents,
		m.Events,
		m.FdMap,
		m.FdToConnection,
		m.GrpcFramesCtxMem,
		m.Http2InfoMem,
		m.HttpInfoMem,
		m.HttpLargeBuffersStorage,
		m.IncomingTraceMap,
		m.IovecMem,
		m.JumpTable,
		m.ListeningPorts,
		m.MsgBufferMem,
		m.MsgBuffers,
		m.MysqlLargeBuffersStorage,
		m.MysqlState,
		m.NginxUpstream,
		m.NodejsFdMap,
		m.OngoingHttp,
		m.OngoingHttp2Connections,
		m.OngoingHttp2Grpc,
		m.OngoingTcpReq,
		m.OutgoingTraceMap,
		m.PidCache,
		m.PidTidToConn,
		m.PostgresLargeBuffersStorage,
		m.ProtocolArgsMem,
		m.ProtocolCache,
		m.ServerTraces,
		m.ServerTracesAux,
		m.SockPids,
		m.SslToConn,
		m.SslToPidTid,
		m.TcpConnectionMap,
		m.TcpReqMem,
		m.TpCharBufMem,
		m.TpInfoMem,
		m.TraceMap,
		m.UpstreamInitArgs,
		m.ValidPids,
	)
}

// BpfTPDebugVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfTPDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfTPDebugVariables struct {
	EXTEND_SIZE              *ebpf.Variable `ebpf:"EXTEND_SIZE"`
	INVALID_POS              *ebpf.Variable `ebpf:"INVALID_POS"`
	TP                       *ebpf.Variable `ebpf:"TP"`
	TP_PREFIX                *ebpf.Variable `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE           *ebpf.Variable `ebpf:"TP_PREFIX_SIZE"`
	PnUnused                 *ebpf.Variable `ebpf:"__pn_unused"`
	CaptureHeaderBuffer      *ebpf.Variable `ebpf:"capture_header_buffer"`
	DisableBlackBoxCp        *ebpf.Variable `ebpf:"disable_black_box_cp"`
	FilterPids               *ebpf.Variable `ebpf:"filter_pids"`
	HighRequestVolume        *ebpf.Variable `ebpf:"high_request_volume"`
	HttpBufferSize           *ebpf.Variable `ebpf:"http_buffer_size"`
	Ip4ip6Prefix             *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	MaxTransactionTime       *ebpf.Variable `ebpf:"max_transaction_time"`
	MysqlBufferSize          *ebpf.Variable `ebpf:"mysql_buffer_size"`
	NgxConnectionS_fd        *ebpf.Variable `ebpf:"ngx_connection_s_fd"`
	NgxConnectionS_sockaddr  *ebpf.Variable `ebpf:"ngx_connection_s_sockaddr"`
	NgxHttpRequestS_conn     *ebpf.Variable `ebpf:"ngx_http_request_s_conn"`
	NgxHttpRequestS_upstream *ebpf.Variable `ebpf:"ngx_http_request_s_upstream"`
	NgxHttpRevS_conn         *ebpf.Variable `ebpf:"ngx_http_rev_s_conn"`
	NgxHttpUpstreamS_conn    *ebpf.Variable `ebpf:"ngx_http_upstream_s_conn"`
	PostgresBufferSize       *ebpf.Variable `ebpf:"postgres_buffer_size"`
	Unused                   *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2              *ebpf.Variable `ebpf:"unused_http2"`
	WakeupDataBytes          *ebpf.Variable `ebpf:"wakeup_data_bytes"`
}

// BpfTPDebugPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfTPDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfTPDebugPrograms struct {
	ObiContinue2ProtocolHttp             *ebpf.Program `ebpf:"obi_continue2_protocol_http"`
	ObiContinueProtocolHttp              *ebpf.Program `ebpf:"obi_continue_protocol_http"`
	ObiHandleBufWithArgs                 *ebpf.Program `ebpf:"obi_handle_buf_with_args"`
	ObiIterTcp                           *ebpf.Program `ebpf:"obi_iter_tcp"`
	ObiKprobeDoVfsIoctl                  *ebpf.Program `ebpf:"obi_kprobe_do_vfs_ioctl"`
	ObiKprobeInetCskListenStop           *ebpf.Program `ebpf:"obi_kprobe_inet_csk_listen_stop"`
	ObiKprobeSecuritySocketAccept        *ebpf.Program `ebpf:"obi_kprobe_security_socket_accept"`
	ObiKprobeSockDefErrorReport          *ebpf.Program `ebpf:"obi_kprobe_sock_def_error_report"`
	ObiKprobeSockRecvmsg                 *ebpf.Program `ebpf:"obi_kprobe_sock_recvmsg"`
	ObiKprobeSysConnect                  *ebpf.Program `ebpf:"obi_kprobe_sys_connect"`
	ObiKprobeSysExit                     *ebpf.Program `ebpf:"obi_kprobe_sys_exit"`
	ObiKprobeTcpCleanupRbuf              *ebpf.Program `ebpf:"obi_kprobe_tcp_cleanup_rbuf"`
	ObiKprobeTcpClose                    *ebpf.Program `ebpf:"obi_kprobe_tcp_close"`
	ObiKprobeTcpConnect                  *ebpf.Program `ebpf:"obi_kprobe_tcp_connect"`
	ObiKprobeTcpRateCheckAppLimited      *ebpf.Program `ebpf:"obi_kprobe_tcp_rate_check_app_limited"`
	ObiKprobeTcpRecvmsg                  *ebpf.Program `ebpf:"obi_kprobe_tcp_recvmsg"`
	ObiKprobeTcpSendmsg                  *ebpf.Program `ebpf:"obi_kprobe_tcp_sendmsg"`
	ObiKprobeUdpSendmsg                  *ebpf.Program `ebpf:"obi_kprobe_udp_sendmsg"`
	ObiKprobeUnixStreamRecvmsg           *ebpf.Program `ebpf:"obi_kprobe_unix_stream_recvmsg"`
	ObiKprobeUnixStreamSendmsg           *ebpf.Program `ebpf:"obi_kprobe_unix_stream_sendmsg"`
	ObiKretprobeSockRecvmsg              *ebpf.Program `ebpf:"obi_kretprobe_sock_recvmsg"`
	ObiKretprobeSysAccept4               *ebpf.Program `ebpf:"obi_kretprobe_sys_accept4"`
	ObiKretprobeSysClone                 *ebpf.Program `ebpf:"obi_kretprobe_sys_clone"`
	ObiKretprobeSysConnect               *ebpf.Program `ebpf:"obi_kretprobe_sys_connect"`
	ObiKretprobeTcpRecvmsg               *ebpf.Program `ebpf:"obi_kretprobe_tcp_recvmsg"`
	ObiKretprobeTcpSendmsg               *ebpf.Program `ebpf:"obi_kretprobe_tcp_sendmsg"`
	ObiKretprobeUnixStreamRecvmsg        *ebpf.Program `ebpf:"obi_kretprobe_unix_stream_recvmsg"`
	ObiKretprobeUnixStreamSendmsg        *ebpf.Program `ebpf:"obi_kretprobe_unix_stream_sendmsg"`
	ObiNgxEventConnectPeerRet            *ebpf.Program `ebpf:"obi_ngx_event_connect_peer_ret"`
	ObiNgxHttpUpstreamInit               *ebpf.Program `ebpf:"obi_ngx_http_upstream_init"`
	ObiProtocolHttp                      *ebpf.Program `ebpf:"obi_protocol_http"`
	ObiProtocolHttp2                     *ebpf.Program `ebpf:"obi_protocol_http2"`
	ObiProtocolHttp2GrpcFrames           *ebpf.Program `ebpf:"obi_protocol_http2_grpc_frames"`
	ObiProtocolHttp2GrpcHandleEndFrame   *ebpf.Program `ebpf:"obi_protocol_http2_grpc_handle_end_frame"`
	ObiProtocolHttp2GrpcHandleStartFrame *ebpf.Program `ebpf:"obi_protocol_http2_grpc_handle_start_frame"`
	ObiProtocolHttpLegacy                *ebpf.Program `ebpf:"obi_protocol_http_legacy"`
	ObiProtocolTcp                       *ebpf.Program `ebpf:"obi_protocol_tcp"`
	ObiSocketHttpFilter                  *ebpf.Program `ebpf:"obi_socket__http_filter"`
	ObiUprobeSslRead                     *ebpf.Program `ebpf:"obi_uprobe_ssl_read"`
	ObiUprobeSslReadEx                   *ebpf.Program `ebpf:"obi_uprobe_ssl_read_ex"`
	ObiUprobeSslShutdown                 *ebpf.Program `ebpf:"obi_uprobe_ssl_shutdown"`
	ObiUprobeSslWrite                    *ebpf.Program `ebpf:"obi_uprobe_ssl_write"`
	ObiUprobeSslWriteEx                  *ebpf.Program `ebpf:"obi_uprobe_ssl_write_ex"`
	ObiUretprobeSslRead                  *ebpf.Program `ebpf:"obi_uretprobe_ssl_read"`
	ObiUretprobeSslReadEx                *ebpf.Program `ebpf:"obi_uretprobe_ssl_read_ex"`
	ObiUretprobeSslWrite                 *ebpf.Program `ebpf:"obi_uretprobe_ssl_write"`
	ObiUretprobeSslWriteEx               *ebpf.Program `ebpf:"obi_uretprobe_ssl_write_ex"`
	ObiUvFsAccess                        *ebpf.Program `ebpf:"obi_uv_fs_access"`
}

func (p *BpfTPDebugPrograms) Close() error {
	return _BpfTPDebugClose(
		p.ObiContinue2ProtocolHttp,
		p.ObiContinueProtocolHttp,
		p.ObiHandleBufWithArgs,
		p.ObiIterTcp,
		p.ObiKprobeDoVfsIoctl,
		p.ObiKprobeInetCskListenStop,
		p.ObiKprobeSecuritySocketAccept,
		p.ObiKprobeSockDefErrorReport,
		p.ObiKprobeSockRecvmsg,
		p.ObiKprobeSysConnect,
		p.ObiKprobeSysExit,
		p.ObiKprobeTcpCleanupRbuf,
		p.ObiKprobeTcpClose,
		p.ObiKprobeTcpConnect,
		p.ObiKprobeTcpRateCheckAppLimited,
		p.ObiKprobeTcpRecvmsg,
		p.ObiKprobeTcpSendmsg,
		p.ObiKprobeUdpSendmsg,
		p.ObiKprobeUnixStreamRecvmsg,
		p.ObiKprobeUnixStreamSendmsg,
		p.ObiKretprobeSockRecvmsg,
		p.ObiKretprobeSysAccept4,
		p.ObiKretprobeSysClone,
		p.ObiKretprobeSysConnect,
		p.ObiKretprobeTcpRecvmsg,
		p.ObiKretprobeTcpSendmsg,
		p.ObiKretprobeUnixStreamRecvmsg,
		p.ObiKretprobeUnixStreamSendmsg,
		p.ObiNgxEventConnectPeerRet,
		p.ObiNgxHttpUpstreamInit,
		p.ObiProtocolHttp,
		p.ObiProtocolHttp2,
		p.ObiProtocolHttp2GrpcFrames,
		p.ObiProtocolHttp2GrpcHandleEndFrame,
		p.ObiProtocolHttp2GrpcHandleStartFrame,
		p.ObiProtocolHttpLegacy,
		p.ObiProtocolTcp,
		p.ObiSocketHttpFilter,
		p.ObiUprobeSslRead,
		p.ObiUprobeSslReadEx,
		p.ObiUprobeSslShutdown,
		p.ObiUprobeSslWrite,
		p.ObiUprobeSslWriteEx,
		p.ObiUretprobeSslRead,
		p.ObiUretprobeSslReadEx,
		p.ObiUretprobeSslWrite,
		p.ObiUretprobeSslWriteEx,
		p.ObiUvFsAccess,
	)
}

func _BpfTPDebugClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpftpdebug_x86_bpfel.o
var _BpfTPDebugBytes []byte
