// Unless explicitly stated otherwise all files in this repository are licensed under the Apache-2.0 License.
// This product includes software developed at Datadog (https://www.datadoghq.com/).
// Copyright 2019-Present Datadog, Inc.

package datadogV2

import (
	"fmt"

	"github.com/DataDog/datadog-api-client-go/v2/api/datadog"
)

// EntityV3Metadata The definition of Entity V3 Metadata object.
type EntityV3Metadata struct {
	// The additional owners of the entity, usually a team.
	AdditionalOwners []EntityV3MetadataAdditionalOwnersItems `json:"additionalOwners,omitempty"`
	// A list of contacts for the entity.
	Contacts []EntityV3MetadataContactsItems `json:"contacts,omitempty"`
	// Short description of the entity. The UI can leverage the description for display.
	Description *string `json:"description,omitempty"`
	// User friendly name of the entity. The UI can leverage the display name for display.
	DisplayName *string `json:"displayName,omitempty"`
	// A read-only globally unique identifier for the entity generated by Datadog.  User supplied values are ignored.
	Id *string `json:"id,omitempty"`
	// The entity reference from which to inherit metadata
	InheritFrom *string `json:"inheritFrom,omitempty"`
	// A list of links for the entity.
	Links []EntityV3MetadataLinksItems `json:"links,omitempty"`
	// A read-only set of Datadog managed attributes generated by Datadog.  User supplied values are ignored.
	Managed map[string]interface{} `json:"managed,omitempty"`
	// Unique name given to an entity under the kind/namespace.
	Name string `json:"name"`
	// Namespace is a part of unique identifier. It has a default value of 'default'.
	Namespace *string `json:"namespace,omitempty"`
	// The owner of the entity, usually a team.
	Owner *string `json:"owner,omitempty"`
	// A set of custom tags.
	Tags []string `json:"tags,omitempty"`
	// UnparsedObject contains the raw value of the object if there was an error when deserializing into the struct
	UnparsedObject map[string]interface{} `json:"-"`
}

// NewEntityV3Metadata instantiates a new EntityV3Metadata object.
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed.
func NewEntityV3Metadata(name string) *EntityV3Metadata {
	this := EntityV3Metadata{}
	this.Name = name
	return &this
}

// NewEntityV3MetadataWithDefaults instantiates a new EntityV3Metadata object.
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set.
func NewEntityV3MetadataWithDefaults() *EntityV3Metadata {
	this := EntityV3Metadata{}
	return &this
}

// GetAdditionalOwners returns the AdditionalOwners field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetAdditionalOwners() []EntityV3MetadataAdditionalOwnersItems {
	if o == nil || o.AdditionalOwners == nil {
		var ret []EntityV3MetadataAdditionalOwnersItems
		return ret
	}
	return o.AdditionalOwners
}

// GetAdditionalOwnersOk returns a tuple with the AdditionalOwners field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetAdditionalOwnersOk() (*[]EntityV3MetadataAdditionalOwnersItems, bool) {
	if o == nil || o.AdditionalOwners == nil {
		return nil, false
	}
	return &o.AdditionalOwners, true
}

// HasAdditionalOwners returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasAdditionalOwners() bool {
	return o != nil && o.AdditionalOwners != nil
}

// SetAdditionalOwners gets a reference to the given []EntityV3MetadataAdditionalOwnersItems and assigns it to the AdditionalOwners field.
func (o *EntityV3Metadata) SetAdditionalOwners(v []EntityV3MetadataAdditionalOwnersItems) {
	o.AdditionalOwners = v
}

// GetContacts returns the Contacts field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetContacts() []EntityV3MetadataContactsItems {
	if o == nil || o.Contacts == nil {
		var ret []EntityV3MetadataContactsItems
		return ret
	}
	return o.Contacts
}

// GetContactsOk returns a tuple with the Contacts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetContactsOk() (*[]EntityV3MetadataContactsItems, bool) {
	if o == nil || o.Contacts == nil {
		return nil, false
	}
	return &o.Contacts, true
}

// HasContacts returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasContacts() bool {
	return o != nil && o.Contacts != nil
}

// SetContacts gets a reference to the given []EntityV3MetadataContactsItems and assigns it to the Contacts field.
func (o *EntityV3Metadata) SetContacts(v []EntityV3MetadataContactsItems) {
	o.Contacts = v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasDescription() bool {
	return o != nil && o.Description != nil
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *EntityV3Metadata) SetDescription(v string) {
	o.Description = &v
}

// GetDisplayName returns the DisplayName field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetDisplayName() string {
	if o == nil || o.DisplayName == nil {
		var ret string
		return ret
	}
	return *o.DisplayName
}

// GetDisplayNameOk returns a tuple with the DisplayName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetDisplayNameOk() (*string, bool) {
	if o == nil || o.DisplayName == nil {
		return nil, false
	}
	return o.DisplayName, true
}

// HasDisplayName returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasDisplayName() bool {
	return o != nil && o.DisplayName != nil
}

// SetDisplayName gets a reference to the given string and assigns it to the DisplayName field.
func (o *EntityV3Metadata) SetDisplayName(v string) {
	o.DisplayName = &v
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetId() string {
	if o == nil || o.Id == nil {
		var ret string
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetIdOk() (*string, bool) {
	if o == nil || o.Id == nil {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasId() bool {
	return o != nil && o.Id != nil
}

// SetId gets a reference to the given string and assigns it to the Id field.
func (o *EntityV3Metadata) SetId(v string) {
	o.Id = &v
}

// GetInheritFrom returns the InheritFrom field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetInheritFrom() string {
	if o == nil || o.InheritFrom == nil {
		var ret string
		return ret
	}
	return *o.InheritFrom
}

// GetInheritFromOk returns a tuple with the InheritFrom field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetInheritFromOk() (*string, bool) {
	if o == nil || o.InheritFrom == nil {
		return nil, false
	}
	return o.InheritFrom, true
}

// HasInheritFrom returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasInheritFrom() bool {
	return o != nil && o.InheritFrom != nil
}

// SetInheritFrom gets a reference to the given string and assigns it to the InheritFrom field.
func (o *EntityV3Metadata) SetInheritFrom(v string) {
	o.InheritFrom = &v
}

// GetLinks returns the Links field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetLinks() []EntityV3MetadataLinksItems {
	if o == nil || o.Links == nil {
		var ret []EntityV3MetadataLinksItems
		return ret
	}
	return o.Links
}

// GetLinksOk returns a tuple with the Links field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetLinksOk() (*[]EntityV3MetadataLinksItems, bool) {
	if o == nil || o.Links == nil {
		return nil, false
	}
	return &o.Links, true
}

// HasLinks returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasLinks() bool {
	return o != nil && o.Links != nil
}

// SetLinks gets a reference to the given []EntityV3MetadataLinksItems and assigns it to the Links field.
func (o *EntityV3Metadata) SetLinks(v []EntityV3MetadataLinksItems) {
	o.Links = v
}

// GetManaged returns the Managed field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetManaged() map[string]interface{} {
	if o == nil || o.Managed == nil {
		var ret map[string]interface{}
		return ret
	}
	return o.Managed
}

// GetManagedOk returns a tuple with the Managed field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetManagedOk() (*map[string]interface{}, bool) {
	if o == nil || o.Managed == nil {
		return nil, false
	}
	return &o.Managed, true
}

// HasManaged returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasManaged() bool {
	return o != nil && o.Managed != nil
}

// SetManaged gets a reference to the given map[string]interface{} and assigns it to the Managed field.
func (o *EntityV3Metadata) SetManaged(v map[string]interface{}) {
	o.Managed = v
}

// GetName returns the Name field value.
func (o *EntityV3Metadata) GetName() string {
	if o == nil {
		var ret string
		return ret
	}
	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value.
func (o *EntityV3Metadata) SetName(v string) {
	o.Name = v
}

// GetNamespace returns the Namespace field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetNamespace() string {
	if o == nil || o.Namespace == nil {
		var ret string
		return ret
	}
	return *o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetNamespaceOk() (*string, bool) {
	if o == nil || o.Namespace == nil {
		return nil, false
	}
	return o.Namespace, true
}

// HasNamespace returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasNamespace() bool {
	return o != nil && o.Namespace != nil
}

// SetNamespace gets a reference to the given string and assigns it to the Namespace field.
func (o *EntityV3Metadata) SetNamespace(v string) {
	o.Namespace = &v
}

// GetOwner returns the Owner field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetOwner() string {
	if o == nil || o.Owner == nil {
		var ret string
		return ret
	}
	return *o.Owner
}

// GetOwnerOk returns a tuple with the Owner field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetOwnerOk() (*string, bool) {
	if o == nil || o.Owner == nil {
		return nil, false
	}
	return o.Owner, true
}

// HasOwner returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasOwner() bool {
	return o != nil && o.Owner != nil
}

// SetOwner gets a reference to the given string and assigns it to the Owner field.
func (o *EntityV3Metadata) SetOwner(v string) {
	o.Owner = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *EntityV3Metadata) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EntityV3Metadata) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return &o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *EntityV3Metadata) HasTags() bool {
	return o != nil && o.Tags != nil
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *EntityV3Metadata) SetTags(v []string) {
	o.Tags = v
}

// MarshalJSON serializes the struct using spec logic.
func (o EntityV3Metadata) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.UnparsedObject != nil {
		return datadog.Marshal(o.UnparsedObject)
	}
	if o.AdditionalOwners != nil {
		toSerialize["additionalOwners"] = o.AdditionalOwners
	}
	if o.Contacts != nil {
		toSerialize["contacts"] = o.Contacts
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.DisplayName != nil {
		toSerialize["displayName"] = o.DisplayName
	}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	if o.InheritFrom != nil {
		toSerialize["inheritFrom"] = o.InheritFrom
	}
	if o.Links != nil {
		toSerialize["links"] = o.Links
	}
	if o.Managed != nil {
		toSerialize["managed"] = o.Managed
	}
	toSerialize["name"] = o.Name
	if o.Namespace != nil {
		toSerialize["namespace"] = o.Namespace
	}
	if o.Owner != nil {
		toSerialize["owner"] = o.Owner
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	return datadog.Marshal(toSerialize)
}

// UnmarshalJSON deserializes the given payload.
func (o *EntityV3Metadata) UnmarshalJSON(bytes []byte) (err error) {
	all := struct {
		AdditionalOwners []EntityV3MetadataAdditionalOwnersItems `json:"additionalOwners,omitempty"`
		Contacts         []EntityV3MetadataContactsItems         `json:"contacts,omitempty"`
		Description      *string                                 `json:"description,omitempty"`
		DisplayName      *string                                 `json:"displayName,omitempty"`
		Id               *string                                 `json:"id,omitempty"`
		InheritFrom      *string                                 `json:"inheritFrom,omitempty"`
		Links            []EntityV3MetadataLinksItems            `json:"links,omitempty"`
		Managed          map[string]interface{}                  `json:"managed,omitempty"`
		Name             *string                                 `json:"name"`
		Namespace        *string                                 `json:"namespace,omitempty"`
		Owner            *string                                 `json:"owner,omitempty"`
		Tags             []string                                `json:"tags,omitempty"`
	}{}
	if err = datadog.Unmarshal(bytes, &all); err != nil {
		return datadog.Unmarshal(bytes, &o.UnparsedObject)
	}
	if all.Name == nil {
		return fmt.Errorf("required field name missing")
	}
	o.AdditionalOwners = all.AdditionalOwners
	o.Contacts = all.Contacts
	o.Description = all.Description
	o.DisplayName = all.DisplayName
	o.Id = all.Id
	o.InheritFrom = all.InheritFrom
	o.Links = all.Links
	o.Managed = all.Managed
	o.Name = *all.Name
	o.Namespace = all.Namespace
	o.Owner = all.Owner
	o.Tags = all.Tags

	return nil
}
