/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, iio, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_iio_dds_control = R"doc(Control block for DDSs which are available in controlling FPGAs of certain IIO drivers.

This block allow for control of multiple direct digital synthesizers (DDS) to create transmit tones. The are available in the generic AXI DAC driver from Analog Devices.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::dds_control.

Args:
    uri : String of the context uri
    enabled : Vector of integers where individual indexes represent specific DDSs and when not zero the are enabled
    frequencies : Vector of long integers where individual indexes represent specific DDS frequencies in Hz
    phases : Vector of floats where individual indexes represent specific DDS phase in degrees
    scales : Vector of floats where individual indexes represent specific DDS scale from 0 to 1)doc";

static const char* __doc_gr_iio_dds_control_make = R"doc(Control block for DDSs which are available in controlling FPGAs of certain IIO drivers.

This block allow for control of multiple direct digital synthesizers (DDS) to create transmit tones. The are available in the generic AXI DAC driver from Analog Devices.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::dds_control.

Args:
    uri : String of the context uri
    enabled : Vector of integers where individual indexes represent specific DDSs and when not zero the are enabled
    frequencies : Vector of long integers where individual indexes represent specific DDS frequencies in Hz
    phases : Vector of floats where individual indexes represent specific DDS phase in degrees
    scales : Vector of floats where individual indexes represent specific DDS scale from 0 to 1)doc";

static const char* __doc_gr_iio_dds_control_set_dds_confg = R"doc()doc";
