/* plugin-email-extension.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from plugin-email-extension.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

static GType plugin_email_extension_get_type_once (void);
static GType plugin_email_context_get_type_once (void);

PluginEmailContext*
plugin_email_extension_get_email (PluginEmailExtension* self)
{
	PluginEmailExtensionIface* _iface_;
	g_return_val_if_fail (PLUGIN_IS_EMAIL_EXTENSION (self), NULL);
	_iface_ = PLUGIN_EMAIL_EXTENSION_GET_INTERFACE (self);
	if (_iface_->get_email) {
		return _iface_->get_email (self);
	}
	return NULL;
}

void
plugin_email_extension_set_email (PluginEmailExtension* self,
                                  PluginEmailContext* value)
{
	PluginEmailExtensionIface* _iface_;
	g_return_if_fail (PLUGIN_IS_EMAIL_EXTENSION (self));
	_iface_ = PLUGIN_EMAIL_EXTENSION_GET_INTERFACE (self);
	if (_iface_->set_email) {
		_iface_->set_email (self, value);
	}
}

static void
plugin_email_extension_default_init (PluginEmailExtensionIface * iface,
                                     gpointer iface_data)
{
	/**
	     * Context object for accessing email.
	     *
	     * This will be set during (or just after) plugin construction,
	     * before {@link PluginBase.activate} is called.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("email", "email", "email", PLUGIN_TYPE_EMAIL_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

/**
 * A plugin extension point for working with email messages.
 */
static GType
plugin_email_extension_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginEmailExtensionIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_email_extension_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_email_extension_type_id;
	plugin_email_extension_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginEmailExtension", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_email_extension_type_id, PLUGIN_TYPE_PLUGIN_BASE);
	return plugin_email_extension_type_id;
}

GType
plugin_email_extension_get_type (void)
{
	static volatile gsize plugin_email_extension_type_id__once = 0;
	if (g_once_init_enter (&plugin_email_extension_type_id__once)) {
		GType plugin_email_extension_type_id;
		plugin_email_extension_type_id = plugin_email_extension_get_type_once ();
		g_once_init_leave (&plugin_email_extension_type_id__once, plugin_email_extension_type_id);
	}
	return plugin_email_extension_type_id__once;
}

void
plugin_email_context_get_email_store (PluginEmailContext* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	PluginEmailContextIface* _iface_;
	_iface_ = PLUGIN_EMAIL_CONTEXT_GET_INTERFACE (self);
	if (_iface_->get_email_store) {
		_iface_->get_email_store (self, _callback_, _user_data_);
	}
}

PluginEmailStore*
plugin_email_context_get_email_store_finish (PluginEmailContext* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	PluginEmailContextIface* _iface_;
	_iface_ = PLUGIN_EMAIL_CONTEXT_GET_INTERFACE (self);
	if (_iface_->get_email_store_finish) {
		return _iface_->get_email_store_finish (self, _res_, error);
	}
	return NULL;
}

/**
     * Adds an info bar to an email, if displayed.
     *
     * The info bar will be shown for the given email if it is
     * currently displayed in any main window, which can be determined
     * by connecting to the {@link EmailStore.email_displayed}
     * signal. Further, if multiple info bars are added for the same
     * email, only the one with a higher priority will be shown. If
     * that is closed or removed, the second highest will be shown,
     * and so on. Once the email is no longer shown, the info bars
     * will be automatically removed.
     */
void
plugin_email_context_add_email_info_bar (PluginEmailContext* self,
                                         PluginEmailIdentifier* displayed,
                                         PluginInfoBar* info_bar,
                                         guint priority)
{
	PluginEmailContextIface* _iface_;
	g_return_if_fail (PLUGIN_IS_EMAIL_CONTEXT (self));
	_iface_ = PLUGIN_EMAIL_CONTEXT_GET_INTERFACE (self);
	if (_iface_->add_email_info_bar) {
		_iface_->add_email_info_bar (self, displayed, info_bar, priority);
	}
}

/**
     * Removes an info bar from a email, if displayed.
     *
     * Removes the info bar from the given email if it is currently
     * displayed in any main window.
     */
void
plugin_email_context_remove_email_info_bar (PluginEmailContext* self,
                                            PluginEmailIdentifier* displayed,
                                            PluginInfoBar* info_bar)
{
	PluginEmailContextIface* _iface_;
	g_return_if_fail (PLUGIN_IS_EMAIL_CONTEXT (self));
	_iface_ = PLUGIN_EMAIL_CONTEXT_GET_INTERFACE (self);
	if (_iface_->remove_email_info_bar) {
		_iface_->remove_email_info_bar (self, displayed, info_bar);
	}
}

static void
plugin_email_context_default_init (PluginEmailContextIface * iface,
                                   gpointer iface_data)
{
}

/**
 * Provides a context for email plugins.
 *
 * The context provides an interface for email plugins to interface
 * with the Geary client application. Plugins that implement the
 * {@link EmailExtension} interface will be given an instance of this
 * class.
 *
 * @see Plugin.EmailExtension.email
 */
static GType
plugin_email_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginEmailContextIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_email_context_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType plugin_email_context_type_id;
	plugin_email_context_type_id = g_type_register_static (G_TYPE_INTERFACE, "PluginEmailContext", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (plugin_email_context_type_id, GEARY_TYPE_BASE_OBJECT);
	return plugin_email_context_type_id;
}

GType
plugin_email_context_get_type (void)
{
	static volatile gsize plugin_email_context_type_id__once = 0;
	if (g_once_init_enter (&plugin_email_context_type_id__once)) {
		GType plugin_email_context_type_id;
		plugin_email_context_type_id = plugin_email_context_get_type_once ();
		g_once_init_leave (&plugin_email_context_type_id__once, plugin_email_context_type_id);
	}
	return plugin_email_context_type_id__once;
}

