/* AppSystem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppSystem.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. <https://elementary.io>
 * Copyright 2021 Corentin Noël <tintou@noel.tf>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <gio/gdesktopappinfo.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_APP_SYSTEM_0_PROPERTY,
	GALA_APP_SYSTEM_NUM_PROPERTIES
};
static GParamSpec* gala_app_system_properties[GALA_APP_SYSTEM_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GalaAppSystemPrivate {
	GHashTable* running_apps;
	GHashTable* id_to_app;
	GHashTable* startup_wm_class_to_id;
	GalaAppCache* app_cache;
	gchar** all_desktop_files;
	gint all_desktop_files_length1;
	gint _all_desktop_files_size_;
	GFileMonitor** directory_monitors;
	gint directory_monitors_length1;
	gint _directory_monitors_size_;
};

static gint GalaAppSystem_private_offset;
static gpointer gala_app_system_parent_class = NULL;
static GOnce gala_app_system_instance;
static GOnce gala_app_system_instance = G_ONCE_INIT;

static GalaAppSystem* __lambda7_ (void);
static gpointer ___lambda7__gthread_func (gpointer self);
static void gala_app_system_update_desktop_files (GalaAppSystem* self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar** gala_app_system_enumerate_children (GalaAppSystem* self,
                                            const gchar* dir,
                                            gint* result_length1,
                                            GError** error);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ______lambda8_ (GalaAppSystem* self,
                     GFile* file,
                     GFile* other_file,
                     GFileMonitorEvent event_type);
static void _______lambda8__g_file_monitor_changed (GFileMonitor* _sender,
                                             GFile* file,
                                             GFile* other_file,
                                             GFileMonitorEvent event_type,
                                             gpointer self);
static void _vala_array_add3 (GFileMonitor** * array,
                       gint* length,
                       gint* size,
                       GFileMonitor* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static GalaApp* gala_app_system_lookup_heuristic_basename (GalaAppSystem* self,
                                                    const gchar* name);
static GObject * gala_app_system_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static void gala_app_system_finalize (GObject * obj);
static GType gala_app_system_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
gala_app_system_get_instance_private (GalaAppSystem* self)
{
	return G_STRUCT_MEMBER_P (self, GalaAppSystem_private_offset);
}

static GalaAppSystem*
__lambda7_ (void)
{
	GalaAppSystem* _tmp0_;
	GalaAppSystem* result;
	_tmp0_ = gala_app_system_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda7__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda7_ ();
	return result;
}

GalaAppSystem*
gala_app_system_get_default (void)
{
	gconstpointer _tmp0_;
	GalaAppSystem* result;
	_tmp0_ = g_once (&gala_app_system_instance, ___lambda7__gthread_func, NULL);
	result = (GalaAppSystem*) _tmp0_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
______lambda8_ (GalaAppSystem* self,
                GFile* file,
                GFile* other_file,
                GFileMonitorEvent event_type)
{
	g_return_if_fail (file != NULL);
	if (event_type == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
		gala_app_system_update_desktop_files (self);
	}
}

static void
_______lambda8__g_file_monitor_changed (GFileMonitor* _sender,
                                        GFile* file,
                                        GFile* other_file,
                                        GFileMonitorEvent event_type,
                                        gpointer self)
{
	______lambda8_ ((GalaAppSystem*) self, file, other_file, event_type);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add3 (GFileMonitor** * array,
                  gint* length,
                  gint* size,
                  GFileMonitor* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFileMonitor*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
gala_app_system_update_desktop_files (GalaAppSystem* self)
{
	gchar** data_dirs = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean create_monitors = FALSE;
	GFileMonitor** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = _tmp0_ = g_get_system_data_dirs ();
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	data_dirs = _tmp2_;
	data_dirs_length1 = _tmp2__length1;
	_data_dirs_size_ = data_dirs_length1;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_strdup (_tmp3_);
	_vala_array_add1 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp4_);
	_tmp5_ = self->priv->directory_monitors;
	_tmp5__length1 = self->priv->directory_monitors_length1;
	create_monitors = _tmp5_ == NULL;
	if (create_monitors) {
		GFileMonitor** _tmp6_;
		_tmp6_ = g_new0 (GFileMonitor*, 0 + 1);
		self->priv->directory_monitors = (_vala_array_free (self->priv->directory_monitors, self->priv->directory_monitors_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->directory_monitors = _tmp6_;
		self->priv->directory_monitors_length1 = 0;
		self->priv->_directory_monitors_size_ = self->priv->directory_monitors_length1;
	}
	_tmp7_ = data_dirs;
	_tmp7__length1 = data_dirs_length1;
	{
		gchar** data_dir_collection = NULL;
		gint data_dir_collection_length1 = 0;
		gint _data_dir_collection_size_ = 0;
		gint data_dir_it = 0;
		data_dir_collection = _tmp7_;
		data_dir_collection_length1 = _tmp7__length1;
		for (data_dir_it = 0; data_dir_it < data_dir_collection_length1; data_dir_it = data_dir_it + 1) {
			const gchar* data_dir = NULL;
			data_dir = data_dir_collection[data_dir_it];
			{
				gchar* app_dir = NULL;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				const gchar* _tmp10_;
				_tmp8_ = data_dir;
				_tmp9_ = g_build_filename (_tmp8_, "applications", NULL);
				app_dir = _tmp9_;
				_tmp10_ = app_dir;
				if (g_file_test (_tmp10_, G_FILE_TEST_EXISTS)) {
					{
						gchar** _tmp11_ = NULL;
						const gchar* _tmp12_;
						gint _tmp13_ = 0;
						gchar** _tmp14_;
						gint _tmp11__length1;
						gint __tmp11__size_;
						GFileMonitor* monitor = NULL;
						const gchar* _tmp21_;
						GFile* _tmp22_;
						GFile* _tmp23_;
						GFileMonitor* _tmp24_;
						GFileMonitor* _tmp25_;
						GFileMonitor* _tmp26_;
						GFileMonitor* _tmp27_;
						GFileMonitor* _tmp28_;
						_tmp12_ = app_dir;
						_tmp14_ = gala_app_system_enumerate_children (self, _tmp12_, &_tmp13_, &_inner_error0_);
						_tmp11_ = _tmp14_;
						_tmp11__length1 = _tmp13_;
						__tmp11__size_ = _tmp11__length1;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						{
							gchar** name_collection = NULL;
							gint name_collection_length1 = 0;
							gint _name_collection_size_ = 0;
							gint name_it = 0;
							name_collection = _tmp11_;
							name_collection_length1 = _tmp11__length1;
							for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
								gchar* _tmp15_;
								gchar* name = NULL;
								_tmp15_ = g_strdup (name_collection[name_it]);
								name = _tmp15_;
								{
									gboolean _tmp16_ = FALSE;
									const gchar* _tmp17_;
									_tmp17_ = name;
									if (!string_contains (_tmp17_, "~")) {
										const gchar* _tmp18_;
										_tmp18_ = name;
										_tmp16_ = g_str_has_suffix (_tmp18_, ".desktop");
									} else {
										_tmp16_ = FALSE;
									}
									if (_tmp16_) {
										const gchar* _tmp19_;
										gchar* _tmp20_;
										_tmp19_ = name;
										_tmp20_ = g_strdup (_tmp19_);
										_vala_array_add2 (&self->priv->all_desktop_files, &self->priv->all_desktop_files_length1, &self->priv->_all_desktop_files_size_, _tmp20_);
									}
									_g_free0 (name);
								}
							}
						}
						if (!create_monitors) {
							_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (app_dir);
							continue;
						}
						_tmp21_ = app_dir;
						_tmp22_ = g_file_new_for_path (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = g_file_monitor (_tmp23_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
						_tmp25_ = _tmp24_;
						_g_object_unref0 (_tmp23_);
						monitor = _tmp25_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
							goto __catch0_g_error;
						}
						_tmp26_ = monitor;
						g_signal_connect_object (_tmp26_, "changed", (GCallback) _______lambda8__g_file_monitor_changed, self, 0);
						_tmp27_ = monitor;
						_tmp28_ = _g_object_ref0 (_tmp27_);
						_vala_array_add3 (&self->priv->directory_monitors, &self->priv->directory_monitors_length1, &self->priv->_directory_monitors_size_, _tmp28_);
						_g_object_unref0 (monitor);
						_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp29_;
						GError* _tmp30_;
						const gchar* _tmp31_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp29_ = app_dir;
						_tmp30_ = e;
						_tmp31_ = _tmp30_->message;
						g_debug ("AppSystem.vala:60: Error inside %s: %s", _tmp29_, _tmp31_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (app_dir);
						data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_g_free0 (app_dir);
			}
		}
	}
	data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
gala_app_system_enumerate_children (GalaAppSystem* self,
                                    const gchar* dir,
                                    gint* result_length1,
                                    GError** error)
{
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	GFileInfo* file_info = NULL;
	GFileEnumerator* enumerator = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileEnumerator* _tmp3_;
	GFileEnumerator* _tmp4_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dir != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	_tmp1_ = g_file_new_for_path (dir);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_enumerate_children (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	enumerator = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file_info);
		_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	while (TRUE) {
		GFileInfo* _tmp5_ = NULL;
		GFileEnumerator* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		GFileInfo* _tmp9_;
		GFileInfo* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp6_ = enumerator;
		_tmp7_ = g_file_enumerator_next_file (_tmp6_, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (enumerator);
			_g_object_unref0 (file_info);
			_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (file_info);
		file_info = _tmp8_;
		_tmp9_ = file_info;
		if (!(_tmp9_ != NULL)) {
			_g_object_unref0 (_tmp5_);
			break;
		}
		_tmp10_ = file_info;
		_tmp11_ = g_file_info_get_name (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		_vala_array_add4 (&_result_, &_result__length1, &__result__size_, _tmp12_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp13_ = _result_;
	_tmp13__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	_g_object_unref0 (enumerator);
	_g_object_unref0 (file_info);
	return result;
}

GalaApp*
gala_app_system_lookup_app (GalaAppSystem* self,
                            const gchar* id)
{
	GalaApp* app = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GalaApp* _tmp2_;
	GDesktopAppInfo* info = NULL;
	GalaAppCache* _tmp4_;
	GDesktopAppInfo* _tmp5_;
	GDesktopAppInfo* _tmp6_;
	GDesktopAppInfo* _tmp7_;
	GalaApp* owned_app = NULL;
	GDesktopAppInfo* _tmp8_;
	GalaApp* _tmp9_;
	GalaApp* _tmp10_;
	GHashTable* _tmp11_;
	GalaApp* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GalaApp* _tmp15_;
	GalaApp* _tmp16_;
	GalaApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->id_to_app;
	_tmp1_ = g_hash_table_lookup (_tmp0_, id);
	app = (GalaApp*) _tmp1_;
	_tmp2_ = app;
	if (_tmp2_ != NULL) {
		GalaApp* _tmp3_;
		_tmp3_ = app;
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->app_cache;
	_tmp5_ = gala_app_cache_lookup_id (_tmp4_, id);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	info = _tmp6_;
	_tmp7_ = info;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_object_unref0 (info);
		return result;
	}
	_tmp8_ = info;
	_tmp9_ = gala_app_new (_tmp8_);
	owned_app = _tmp9_;
	_tmp10_ = owned_app;
	app = _tmp10_;
	_tmp11_ = self->priv->id_to_app;
	_tmp12_ = owned_app;
	_tmp13_ = gala_app_get_id (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = owned_app;
	owned_app = NULL;
	g_hash_table_insert (_tmp11_, _tmp14_, _tmp15_);
	_tmp16_ = app;
	result = _tmp16_;
	_g_object_unref0 (owned_app);
	_g_object_unref0 (info);
	return result;
}

GalaApp*
gala_app_system_lookup_startup_wmclass (GalaAppSystem* self,
                                        const gchar* wmclass)
{
	GDesktopAppInfo* info = NULL;
	GalaAppCache* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	const gchar* _tmp4_;
	GalaApp* _tmp5_;
	GalaApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (wmclass == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->app_cache;
	_tmp1_ = gala_app_cache_lookup_startup_wmclass (_tmp0_, wmclass);
	info = _tmp1_;
	_tmp2_ = info;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (info);
		return result;
	}
	_tmp3_ = info;
	_tmp4_ = g_app_info_get_id ((GAppInfo*) _tmp3_);
	_tmp5_ = gala_app_system_lookup_app (self, _tmp4_);
	result = _tmp5_;
	_g_object_unref0 (info);
	return result;
}

static GalaApp*
gala_app_system_lookup_heuristic_basename (GalaAppSystem* self,
                                           const gchar* name)
{
	static const gchar* VENDOR_PREFIXES[4] = {"gnome-", "fedora-", "mozilla-", "debian-"};
	GalaApp* _result_ = NULL;
	GalaApp* _tmp0_;
	GalaApp* _tmp1_;
	GalaApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gala_app_system_lookup_app (self, name);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		GalaApp* _tmp2_;
		_tmp2_ = _result_;
		result = _tmp2_;
		return result;
	}
	{
		const gchar** prefix_collection = NULL;
		gint prefix_collection_length1 = 0;
		gint _prefix_collection_size_ = 0;
		gint prefix_it = 0;
		prefix_collection = VENDOR_PREFIXES;
		prefix_collection_length1 = G_N_ELEMENTS (VENDOR_PREFIXES);
		for (prefix_it = 0; prefix_it < prefix_collection_length1; prefix_it = prefix_it + 1) {
			const gchar* prefix = NULL;
			prefix = prefix_collection[prefix_it];
			{
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GalaApp* _tmp6_;
				GalaApp* _tmp7_;
				_tmp3_ = prefix;
				_tmp4_ = g_strconcat (_tmp3_, name, NULL);
				_tmp5_ = _tmp4_;
				_tmp6_ = gala_app_system_lookup_app (self, _tmp5_);
				_result_ = _tmp6_;
				_g_free0 (_tmp5_);
				_tmp7_ = _result_;
				if (_tmp7_ != NULL) {
					GalaApp* _tmp8_;
					_tmp8_ = _result_;
					result = _tmp8_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

GalaApp*
gala_app_system_lookup_desktop_wmclass (GalaAppSystem* self,
                                        const gchar* wmclass)
{
	gchar* desktop_file = NULL;
	gchar* _tmp0_;
	GalaApp* app = NULL;
	const gchar* _tmp1_;
	GalaApp* _tmp2_;
	GalaApp* _tmp3_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GalaApp* _tmp11_;
	GalaApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (wmclass == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_strconcat (wmclass, ".desktop", NULL);
	desktop_file = _tmp0_;
	_tmp1_ = desktop_file;
	_tmp2_ = gala_app_system_lookup_heuristic_basename (self, _tmp1_);
	app = _tmp2_;
	_tmp3_ = app;
	if (_tmp3_ != NULL) {
		GalaApp* _tmp4_;
		_tmp4_ = app;
		result = _tmp4_;
		_g_free0 (desktop_file);
		return result;
	}
	_tmp5_ = desktop_file;
	g_strdelimit (_tmp5_, " ", '-');
	_tmp6_ = desktop_file;
	_tmp7_ = g_ascii_strdown (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, ".desktop", NULL);
	_g_free0 (desktop_file);
	desktop_file = _tmp9_;
	_g_free0 (_tmp8_);
	_tmp10_ = desktop_file;
	_tmp11_ = gala_app_system_lookup_heuristic_basename (self, _tmp10_);
	result = _tmp11_;
	_g_free0 (desktop_file);
	return result;
}

GalaApp*
gala_app_system_guess_app_by_id (GalaAppSystem* self,
                                 const gchar* _id)
{
	gchar* id = NULL;
	gchar* _tmp0_;
	GalaApp* _result_ = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GalaApp* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (_id != NULL, NULL);
	_tmp0_ = g_ascii_strdown (_id, (gssize) -1);
	id = _tmp0_;
	_result_ = NULL;
	_tmp1_ = self->priv->all_desktop_files;
	_tmp1__length1 = self->priv->all_desktop_files_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp1_;
		name_collection_length1 = _tmp1__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp2_;
			gchar* name = NULL;
			_tmp2_ = g_strdup (name_collection[name_it]);
			name = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = name;
				_tmp5_ = id;
				if (string_contains (_tmp4_, _tmp5_)) {
					const gchar* _tmp6_;
					GalaApp* _tmp7_;
					GalaApp* _tmp8_;
					_tmp6_ = name;
					_tmp7_ = gala_app_system_lookup_app (self, _tmp6_);
					_result_ = _tmp7_;
					_tmp8_ = _result_;
					_tmp3_ = _tmp8_ != NULL;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					GalaApp* _tmp9_;
					_tmp9_ = _result_;
					result = _tmp9_;
					_g_free0 (name);
					_g_free0 (id);
					return result;
				}
				_g_free0 (name);
			}
		}
	}
	result = NULL;
	_g_free0 (id);
	return result;
}

void
gala_app_system_notify_app_state_changed (GalaAppSystem* self,
                                          GalaApp* app)
{
	GalaAppState _tmp0_;
	GalaAppState _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = gala_app_get_state (app);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == GALA_APP_STATE_RUNNING) {
		GHashTable* _tmp2_;
		GalaApp* _tmp3_;
		_tmp2_ = self->priv->running_apps;
		_tmp3_ = _g_object_ref0 (app);
		g_hash_table_insert (_tmp2_, _tmp3_, app);
	} else {
		GalaAppState _tmp4_;
		GalaAppState _tmp5_;
		_tmp4_ = gala_app_get_state (app);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == GALA_APP_STATE_STOPPED) {
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->running_apps;
			g_hash_table_remove (_tmp6_, app);
		}
	}
}

GList*
gala_app_system_get_running_apps (GalaAppSystem* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->running_apps;
	_tmp1_ = g_hash_table_get_keys (_tmp0_);
	result = _tmp1_;
	return result;
}

GalaAppSystem*
gala_app_system_construct (GType object_type)
{
	GalaAppSystem * self = NULL;
	self = (GalaAppSystem*) g_object_new (object_type, NULL);
	return self;
}

GalaAppSystem*
gala_app_system_new (void)
{
	return gala_app_system_construct (GALA_TYPE_APP_SYSTEM);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GObject *
gala_app_system_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaAppSystem * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GalaAppCache* _tmp7_;
	parent_class = G_OBJECT_CLASS (gala_app_system_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_APP_SYSTEM, GalaAppSystem);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->id_to_app);
	self->priv->id_to_app = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->priv->startup_wm_class_to_id);
	self->priv->startup_wm_class_to_id = _tmp5_;
	_tmp6_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, NULL);
	_g_hash_table_unref0 (self->priv->running_apps);
	self->priv->running_apps = _tmp6_;
	_tmp7_ = gala_app_cache_new ();
	_g_object_unref0 (self->priv->app_cache);
	self->priv->app_cache = _tmp7_;
	gala_app_system_update_desktop_files (self);
	return obj;
}

static void
gala_app_system_class_init (GalaAppSystemClass * klass,
                            gpointer klass_data)
{
	gala_app_system_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaAppSystem_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gala_app_system_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_app_system_finalize;
}

static void
gala_app_system_instance_init (GalaAppSystem * self,
                               gpointer klass)
{
	gchar** _tmp0_;
	self->priv = gala_app_system_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->all_desktop_files = _tmp0_;
	self->priv->all_desktop_files_length1 = 0;
	self->priv->_all_desktop_files_size_ = self->priv->all_desktop_files_length1;
}

static void
gala_app_system_finalize (GObject * obj)
{
	GalaAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_APP_SYSTEM, GalaAppSystem);
	_g_hash_table_unref0 (self->priv->running_apps);
	_g_hash_table_unref0 (self->priv->id_to_app);
	_g_hash_table_unref0 (self->priv->startup_wm_class_to_id);
	_g_object_unref0 (self->priv->app_cache);
	self->priv->all_desktop_files = (_vala_array_free (self->priv->all_desktop_files, self->priv->all_desktop_files_length1, (GDestroyNotify) g_free), NULL);
	self->priv->directory_monitors = (_vala_array_free (self->priv->directory_monitors, self->priv->directory_monitors_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (gala_app_system_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_app_system_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaAppSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_app_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaAppSystem), 0, (GInstanceInitFunc) gala_app_system_instance_init, NULL };
	GType gala_app_system_type_id;
	gala_app_system_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaAppSystem", &g_define_type_info, 0);
	GalaAppSystem_private_offset = g_type_add_instance_private (gala_app_system_type_id, sizeof (GalaAppSystemPrivate));
	return gala_app_system_type_id;
}

GType
gala_app_system_get_type (void)
{
	static gsize gala_app_system_type_id__once = 0;
	if (g_once_init_enter (&gala_app_system_type_id__once)) {
		GType gala_app_system_type_id;
		gala_app_system_type_id = gala_app_system_get_type_once ();
		g_once_init_leave (&gala_app_system_type_id__once, gala_app_system_type_id);
	}
	return gala_app_system_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

