/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-amd-gpu-psp-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_struct_efs_ref: (skip):
 **/
FuStructEfs *
fu_struct_efs_ref(FuStructEfs *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_efs_unref: (skip):
 **/
void
fu_struct_efs_unref(FuStructEfs *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEfs refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_efs_new_internal: (skip):
 **/
static FuStructEfs *
fu_struct_efs_new_internal(void)
{
    FuStructEfs *st = g_new0(FuStructEfs, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_efs_get_signature: (skip):
 **/
guint32
fu_struct_efs_get_signature(const FuStructEfs *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efs_get_psp_dir_loc: (skip):
 **/
guint32
fu_struct_efs_get_psp_dir_loc(const FuStructEfs *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efs_to_string: (skip):
 **/
static gchar *
fu_struct_efs_to_string(const FuStructEfs *st)
{
    g_autoptr(GString) str = g_string_new("FuStructEfs:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  signature: 0x%x\n",
                           (guint) fu_struct_efs_get_signature(st));
    g_string_append_printf(str, "  psp_dir_loc: 0x%x\n",
                           (guint) fu_struct_efs_get_psp_dir_loc(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_efs_validate_internal(FuStructEfs *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_efs_parse_internal(FuStructEfs *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_efs_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_efs_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_efs_parse_stream: (skip):
 **/
FuStructEfs *
fu_struct_efs_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEfs) st = fu_struct_efs_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 84, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEfs failed read of 0x%x: ", (guint) 84);
        return NULL;
    }
    if (st->buf->len != 84) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEfs requested 0x%x and got 0x%x",
                    (guint) 84,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_efs_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_psp_dir_ref: (skip):
 **/
FuStructPspDir *
fu_struct_psp_dir_ref(FuStructPspDir *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_psp_dir_unref: (skip):
 **/
void
fu_struct_psp_dir_unref(FuStructPspDir *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPspDir refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_psp_dir_new_internal: (skip):
 **/
static FuStructPspDir *
fu_struct_psp_dir_new_internal(void)
{
    FuStructPspDir *st = g_new0(FuStructPspDir, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_psp_dir_get_cookie: (skip):
 **/
static gchar *
fu_struct_psp_dir_get_cookie(const FuStructPspDir *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}
/**
 * fu_struct_psp_dir_get_checksum: (skip):
 **/
guint32
fu_struct_psp_dir_get_checksum(const FuStructPspDir *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_psp_dir_get_total_entries: (skip):
 **/
guint32
fu_struct_psp_dir_get_total_entries(const FuStructPspDir *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_psp_dir_to_string: (skip):
 **/
static gchar *
fu_struct_psp_dir_to_string(const FuStructPspDir *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPspDir:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_psp_dir_get_checksum(st));
    g_string_append_printf(str, "  total_entries: 0x%x\n",
                           (guint) fu_struct_psp_dir_get_total_entries(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_psp_dir_validate_internal(FuStructPspDir *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "$PSP", 4) != 0) {
        g_autofree gchar *str = fu_struct_psp_dir_get_cookie(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructPspDir.cookie was not valid, "
                    "expected '$PSP' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_psp_dir_validate_stream: (skip):
 **/
gboolean
fu_struct_psp_dir_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPspDir) st = fu_struct_psp_dir_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPspDir failed read of 0x%x: ", (guint) 16);
        return FALSE;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPspDir requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_psp_dir_validate_internal(st, error);
}
static gboolean
fu_struct_psp_dir_parse_internal(FuStructPspDir *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_psp_dir_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_psp_dir_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_psp_dir_parse_stream: (skip):
 **/
FuStructPspDir *
fu_struct_psp_dir_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPspDir) st = fu_struct_psp_dir_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPspDir failed read of 0x%x: ", (guint) 16);
        return NULL;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPspDir requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_psp_dir_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_psp_dir_table_ref: (skip):
 **/
FuStructPspDirTable *
fu_struct_psp_dir_table_ref(FuStructPspDirTable *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_psp_dir_table_unref: (skip):
 **/
void
fu_struct_psp_dir_table_unref(FuStructPspDirTable *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructPspDirTable refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_psp_dir_table_new_internal: (skip):
 **/
static FuStructPspDirTable *
fu_struct_psp_dir_table_new_internal(void)
{
    FuStructPspDirTable *st = g_new0(FuStructPspDirTable, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_psp_dir_table_get_fw_id: (skip):
 **/
guint32
fu_struct_psp_dir_table_get_fw_id(const FuStructPspDirTable *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_psp_dir_table_get_size: (skip):
 **/
guint32
fu_struct_psp_dir_table_get_size(const FuStructPspDirTable *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_psp_dir_table_get_loc: (skip):
 **/
guint64
fu_struct_psp_dir_table_get_loc(const FuStructPspDirTable *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_psp_dir_table_to_string: (skip):
 **/
static gchar *
fu_struct_psp_dir_table_to_string(const FuStructPspDirTable *st)
{
    g_autoptr(GString) str = g_string_new("FuStructPspDirTable:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  fw_id: 0x%x\n",
                           (guint) fu_struct_psp_dir_table_get_fw_id(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_psp_dir_table_get_size(st));
    g_string_append_printf(str, "  loc: 0x%x\n",
                           (guint) fu_struct_psp_dir_table_get_loc(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_psp_dir_table_validate_internal(FuStructPspDirTable *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_psp_dir_table_parse_internal(FuStructPspDirTable *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_psp_dir_table_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_psp_dir_table_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_psp_dir_table_parse_stream: (skip):
 **/
FuStructPspDirTable *
fu_struct_psp_dir_table_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructPspDirTable) st = fu_struct_psp_dir_table_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructPspDirTable failed read of 0x%x: ", (guint) 16);
        return NULL;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructPspDirTable requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_psp_dir_table_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_image_slot_header_ref: (skip):
 **/
FuStructImageSlotHeader *
fu_struct_image_slot_header_ref(FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_image_slot_header_unref: (skip):
 **/
void
fu_struct_image_slot_header_unref(FuStructImageSlotHeader *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructImageSlotHeader refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_image_slot_header_new_internal: (skip):
 **/
static FuStructImageSlotHeader *
fu_struct_image_slot_header_new_internal(void)
{
    FuStructImageSlotHeader *st = g_new0(FuStructImageSlotHeader, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_image_slot_header_get_checksum: (skip):
 **/
guint32
fu_struct_image_slot_header_get_checksum(const FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_image_slot_header_get_boot_priority: (skip):
 **/
guint32
fu_struct_image_slot_header_get_boot_priority(const FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_image_slot_header_get_update_retries: (skip):
 **/
guint32
fu_struct_image_slot_header_get_update_retries(const FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_image_slot_header_get_glitch_retries: (skip):
 **/
guint8
fu_struct_image_slot_header_get_glitch_retries(const FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[12];
}
/**
 * fu_struct_image_slot_header_get_fw_id: (skip):
 **/
guint16
fu_struct_image_slot_header_get_fw_id(const FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 13, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_image_slot_header_get_loc: (skip):
 **/
guint32
fu_struct_image_slot_header_get_loc(const FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_image_slot_header_get_psp_id: (skip):
 **/
guint32
fu_struct_image_slot_header_get_psp_id(const FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_image_slot_header_get_slot_max_size: (skip):
 **/
guint32
fu_struct_image_slot_header_get_slot_max_size(const FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_image_slot_header_get_loc_csm: (skip):
 **/
guint32
fu_struct_image_slot_header_get_loc_csm(const FuStructImageSlotHeader *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_image_slot_header_to_string: (skip):
 **/
static gchar *
fu_struct_image_slot_header_to_string(const FuStructImageSlotHeader *st)
{
    g_autoptr(GString) str = g_string_new("FuStructImageSlotHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_image_slot_header_get_checksum(st));
    g_string_append_printf(str, "  boot_priority: 0x%x\n",
                           (guint) fu_struct_image_slot_header_get_boot_priority(st));
    g_string_append_printf(str, "  update_retries: 0x%x\n",
                           (guint) fu_struct_image_slot_header_get_update_retries(st));
    g_string_append_printf(str, "  glitch_retries: 0x%x\n",
                           (guint) fu_struct_image_slot_header_get_glitch_retries(st));
    g_string_append_printf(str, "  fw_id: 0x%x\n",
                           (guint) fu_struct_image_slot_header_get_fw_id(st));
    g_string_append_printf(str, "  loc: 0x%x\n",
                           (guint) fu_struct_image_slot_header_get_loc(st));
    g_string_append_printf(str, "  psp_id: 0x%x\n",
                           (guint) fu_struct_image_slot_header_get_psp_id(st));
    g_string_append_printf(str, "  slot_max_size: 0x%x\n",
                           (guint) fu_struct_image_slot_header_get_slot_max_size(st));
    g_string_append_printf(str, "  loc_csm: 0x%x\n",
                           (guint) fu_struct_image_slot_header_get_loc_csm(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_image_slot_header_validate_internal(FuStructImageSlotHeader *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_image_slot_header_parse_internal(FuStructImageSlotHeader *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_image_slot_header_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_image_slot_header_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_image_slot_header_parse_stream: (skip):
 **/
FuStructImageSlotHeader *
fu_struct_image_slot_header_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructImageSlotHeader) st = fu_struct_image_slot_header_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructImageSlotHeader failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructImageSlotHeader requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_image_slot_header_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
