//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gmp/PGMPVideoEncoderParent.h"
#include "GMPMessageUtils.h"
#include "GMPVideoEncoderChild.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/gmp/PGMPContentParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gmp {


MOZ_IMPLICIT PGMPVideoEncoderParent::PGMPVideoEncoderParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PGMPVideoEncoderParent);
}

PGMPVideoEncoderParent::~PGMPVideoEncoderParent()
{
    MOZ_COUNT_DTOR(PGMPVideoEncoderParent);
}

auto PGMPVideoEncoderParent::ActorAlloc() -> void
{
    AddRef();
}

auto PGMPVideoEncoderParent::ActorDealloc() -> void
{
    Release();
}

auto PGMPVideoEncoderParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PGMPVideoEncoderParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PGMPVideoEncoderParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PGMPVideoEncoderParent::Manager() const -> PGMPContentParent*
{
    return static_cast<PGMPContentParent*>(IProtocol::Manager());
}

auto PGMPVideoEncoderParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PGMPVideoEncoderParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PGMPVideoEncoderParent::SendInitEncode(
        const GMPVideoCodec& aCodecSettings,
        mozilla::Span<uint8_t const> aCodecSpecific,
        const int32_t& aNumberOfCores,
        const uint32_t& aMaxPayloadSize) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMPVideoEncoder::Msg_InitEncode(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aCodecSettings);
    // Sentinel = 'aCodecSettings'
    ((&(writer__)))->WriteSentinel(674629009);
    IPC::WriteParam((&(writer__)), aCodecSpecific);
    // Sentinel = 'aCodecSpecific'
    ((&(writer__)))->WriteSentinel(665847142);
    IPC::WriteParam((&(writer__)), aNumberOfCores);
    // Sentinel = 'aNumberOfCores'
    ((&(writer__)))->WriteSentinel(681117052);
    IPC::WriteParam((&(writer__)), aMaxPayloadSize);
    // Sentinel = 'aMaxPayloadSize'
    ((&(writer__)))->WriteSentinel(780076525);


    if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPVideoEncoderParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_InitEncode", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPVideoEncoderParent::SendGiveShmem(Shmem&& aOutputShmem) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMPVideoEncoder::Msg_GiveShmem(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(aOutputShmem));
    // Sentinel = 'aOutputShmem'
    ((&(writer__)))->WriteSentinel(533398765);


    if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPVideoEncoderParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_GiveShmem", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPVideoEncoderParent::SendEncode(
        const GMPVideoi420FrameData& aInputFrame,
        Shmem&& aInputShmem,
        mozilla::Span<uint8_t const> aCodecSpecificInfo,
        mozilla::Span<GMPVideoFrameType const> aFrameTypes) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMPVideoEncoder::Msg_Encode(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aInputFrame);
    // Sentinel = 'aInputFrame'
    ((&(writer__)))->WriteSentinel(434177117);
    IPC::WriteParam((&(writer__)), std::move(aInputShmem));
    // Sentinel = 'aInputShmem'
    ((&(writer__)))->WriteSentinel(437650540);
    IPC::WriteParam((&(writer__)), aCodecSpecificInfo);
    // Sentinel = 'aCodecSpecificInfo'
    ((&(writer__)))->WriteSentinel(1089537778);
    IPC::WriteParam((&(writer__)), aFrameTypes);
    // Sentinel = 'aFrameTypes'
    ((&(writer__)))->WriteSentinel(426378338);


    if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPVideoEncoderParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_Encode", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPVideoEncoderParent::SendSetChannelParameters(
        const uint32_t& aPacketLoss,
        const uint32_t& aRTT) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMPVideoEncoder::Msg_SetChannelParameters(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aPacketLoss);
    // Sentinel = 'aPacketLoss'
    ((&(writer__)))->WriteSentinel(423363675);
    IPC::WriteParam((&(writer__)), aRTT);
    // Sentinel = 'aRTT'
    ((&(writer__)))->WriteSentinel(58327388);


    if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPVideoEncoderParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_SetChannelParameters", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPVideoEncoderParent::SendSetRates(
        const uint32_t& aNewBitRate,
        const uint32_t& aFrameRate) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMPVideoEncoder::Msg_SetRates(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aNewBitRate);
    // Sentinel = 'aNewBitRate'
    ((&(writer__)))->WriteSentinel(415695927);
    IPC::WriteParam((&(writer__)), aFrameRate);
    // Sentinel = 'aFrameRate'
    ((&(writer__)))->WriteSentinel(348128217);


    if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPVideoEncoderParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_SetRates", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPVideoEncoderParent::SendSetPeriodicKeyFrames(const bool& aEnable) -> bool
{
    UniquePtr<IPC::Message> msg__ = PGMPVideoEncoder::Msg_SetPeriodicKeyFrames(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aEnable);
    // Sentinel = 'aEnable'
    ((&(writer__)))->WriteSentinel(173605545);


    if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPVideoEncoderParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_SetPeriodicKeyFrames", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PGMPVideoEncoderParent::Send__delete__(PGMPVideoEncoderParent* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PGMPVideoEncoder::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PGMPVideoEncoderParent",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PGMPVideoEncoderParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PGMPVideoEncoderParent::OnMessageReceived(const Message& msg__) -> PGMPVideoEncoderParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PGMPVideoEncoder::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PGMPVideoEncoder::Msg_ReturnShmem__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPVideoEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_ReturnShmem", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aInputShmem = IPC::ReadParam<Shmem>((&(reader__)));
            if (!maybe__aInputShmem) {
                FatalError("Error deserializing 'Shmem'");
                return MsgValueError;

            }
            auto& aInputShmem = *maybe__aInputShmem;
            // Sentinel = 'aInputShmem'
            if ((!(((&(reader__)))->ReadSentinel(437650540)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Shmem'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvReturnShmem(std::move(aInputShmem));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMPVideoEncoder::Msg_EncodedShmem__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPVideoEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_EncodedShmem", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aEncodedFrame = IPC::ReadParam<GMPVideoEncodedFrameData>((&(reader__)));
            if (!maybe__aEncodedFrame) {
                FatalError("Error deserializing 'GMPVideoEncodedFrameData'");
                return MsgValueError;

            }
            auto& aEncodedFrame = *maybe__aEncodedFrame;
            // Sentinel = 'aEncodedFrame'
            if ((!(((&(reader__)))->ReadSentinel(578290943)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GMPVideoEncodedFrameData'");
                return MsgValueError;
            }
            auto maybe__aEncodedShmem = IPC::ReadParam<Shmem>((&(reader__)));
            if (!maybe__aEncodedShmem) {
                FatalError("Error deserializing 'Shmem'");
                return MsgValueError;

            }
            auto& aEncodedShmem = *maybe__aEncodedShmem;
            // Sentinel = 'aEncodedShmem'
            if ((!(((&(reader__)))->ReadSentinel(581764366)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'Shmem'");
                return MsgValueError;
            }
            auto maybe__aCodecSpecificInfo = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__aCodecSpecificInfo) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& aCodecSpecificInfo = *maybe__aCodecSpecificInfo;
            // Sentinel = 'aCodecSpecificInfo'
            if ((!(((&(reader__)))->ReadSentinel(1089537778)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvEncodedShmem(std::move(aEncodedFrame), std::move(aEncodedShmem), std::move(aCodecSpecificInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMPVideoEncoder::Msg_EncodedData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPVideoEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_EncodedData", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aEncodedFrame = IPC::ReadParam<GMPVideoEncodedFrameData>((&(reader__)));
            if (!maybe__aEncodedFrame) {
                FatalError("Error deserializing 'GMPVideoEncodedFrameData'");
                return MsgValueError;

            }
            auto& aEncodedFrame = *maybe__aEncodedFrame;
            // Sentinel = 'aEncodedFrame'
            if ((!(((&(reader__)))->ReadSentinel(578290943)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GMPVideoEncodedFrameData'");
                return MsgValueError;
            }
            auto maybe__aEncodedData = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__aEncodedData) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& aEncodedData = *maybe__aEncodedData;
            // Sentinel = 'aEncodedData'
            if ((!(((&(reader__)))->ReadSentinel(492307598)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            auto maybe__aCodecSpecificInfo = IPC::ReadParam<nsTArray<uint8_t>>((&(reader__)));
            if (!maybe__aCodecSpecificInfo) {
                FatalError("Error deserializing 'uint8_t[]'");
                return MsgValueError;

            }
            auto& aCodecSpecificInfo = *maybe__aCodecSpecificInfo;
            // Sentinel = 'aCodecSpecificInfo'
            if ((!(((&(reader__)))->ReadSentinel(1089537778)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint8_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvEncodedData(std::move(aEncodedFrame), std::move(aEncodedData), std::move(aCodecSpecificInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMPVideoEncoder::Msg_DroppedFrame__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPVideoEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_DroppedFrame", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aTimestamp = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aTimestamp) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aTimestamp = *maybe__aTimestamp;
            // Sentinel = 'aTimestamp'
            if ((!(((&(reader__)))->ReadSentinel(367330326)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDroppedFrame(std::move(aTimestamp));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMPVideoEncoder::Msg_Error__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPVideoEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_Error", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aErr = IPC::ReadParam<GMPErr>((&(reader__)));
            if (!maybe__aErr) {
                FatalError("Error deserializing 'GMPErr'");
                return MsgValueError;

            }
            auto& aErr = *maybe__aErr;
            // Sentinel = 'aErr'
            if ((!(((&(reader__)))->ReadSentinel(61669771)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GMPErr'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvError(std::move(aErr));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PGMPVideoEncoder::Msg_Shutdown__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PGMPVideoEncoder", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PGMPVideoEncoderParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PGMPVideoEncoder::Msg_Shutdown", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvShutdown();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PGMPVideoEncoderParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PGMPVideoEncoderParent::Result
{
    return MsgNotKnown;
}



} // namespace gmp
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gmp::PGMPVideoEncoderParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PGMPVideoEncoder'
    (aWriter)->WriteSentinel(796984812);
}

auto ParamTraits<::mozilla::gmp::PGMPVideoEncoderParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PGMPVideoEncoder actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PGMPVideoEncoder'
    if ((!((aReader)->ReadSentinel(796984812)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PGMPVideoEncoder actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PGMPVideoEncoderMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PGMPVideoEncoder)");

        return {};
    }
    return static_cast<::mozilla::gmp::PGMPVideoEncoderParent*>(actor);
}

} // namespace IPC
