// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomMediaMetrics_h
#define mozilla_GleanDomMediaMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace gmp {
  /**
   * generated from gmp.update_xml_fetch_result
   */
  enum class UpdateXmlFetchResultLabel: uint16_t {
    eCertPinSuccess = 0,
    eCertPinNetRequestError = 1,
    eCertPinNetTimeout = 2,
    eCertPinAbort = 3,
    eCertPinMissingData = 4,
    eCertPinFailed = 5,
    eCertPinInvalid = 6,
    eCertPinXmlParseError = 7,
    eCertPinUnknownError = 8,
    eContentSigSuccess = 9,
    eContentSigNetRequestError = 10,
    eContentSigNetTimeout = 11,
    eContentSigAbort = 12,
    eContentSigMissingData = 13,
    eContentSigFailed = 14,
    eContentSigInvalid = 15,
    eContentSigXmlParseError = 16,
    eContentSigUnknownError = 17,
    e__Other__,
  };
  /**
   * The result of Gecko fetching an update.xml from Balrog. This captures 3 different data points: success or failure of the request, if cert pinning or content signatures were used to verify the result, and the reason for failure, if the request failed.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, UpdateXmlFetchResultLabel> update_xml_fetch_result(3755);
}

namespace media {
  /**
   * generated from media.audible_play_time_percent
   * Percentage of time spent playing media with an audible audio track, regardless of the volume. Keyed by audio-only or video presence.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram AUDIBLE_PLAY_TIME_PERCENT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> audible_play_time_percent(3756);

  /**
   * generated from media.codec_used
   * Count of use of audio/video codecs in HTMLMediaElements and WebAudio. Those with 'resource' prefix are approximate; report based on HTTP ContentType or sniffing. Those with 'webaudio' prefix are for WebAudio.
   * This metric was generated to correspond to the Legacy Telemetry count histogram MEDIA_CODEC_USED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> codec_used(3757);

  /**
   * generated from media.element_in_page_count
   * The number of times a document hierarchy contained at least one HTMLMediaElement. In addition, the telemetry probe 'MIXED_CONTENT_UNBLOCK_COUNTER' records the total number of loaded top level content documents, which can help us calculate the result of the percentage of documents using media. This metric was generated to correspond to the Legacy Telemetry scalar media.element_in_page_count.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> element_in_page_count(3758);

  /**
   * generated from media.error
   */
  struct ErrorExtra {
    mozilla::Maybe<nsCString> errorName;
    mozilla::Maybe<nsCString> errorType;
    mozilla::Maybe<nsCString> keySystem;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (errorName) {
        extraKeys.AppendElement()->AssignASCII("error_name");
        extraValues.EmplaceBack(errorName.value());
      }
      if (errorType) {
        extraKeys.AppendElement()->AssignASCII("error_type");
        extraValues.EmplaceBack(errorType.value());
      }
      if (keySystem) {
        extraKeys.AppendElement()->AssignASCII("key_system");
        extraValues.EmplaceBack(keySystem.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record the error details happened on a media element.
   */
  constexpr impl::EventMetric<ErrorExtra> error(3759);

  /**
   * generated from media.media_play_time
   * Total time spent playing media in milliseconds, keyed by its content (Audio and video, audio only, video only, audio and video but audio inaudible, audio and video but audio muted).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MEDIA_PLAY_TIME_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> media_play_time(3760);

  /**
   * generated from media.mkv_codec_type
   */
  enum class MkvCodecTypeLabel: uint16_t {
    eVideoav1 = 0,
    eVideoavc = 1,
    eVideohevc = 2,
    eVideovp8 = 3,
    eVideovp9 = 4,
    eAudioaac = 5,
    eAudiomp3 = 6,
    eAudioopus = 7,
    eAudiovorbis = 8,
    eAudioflac = 9,
    eAudiopcm = 10,
    eNocodecspecified = 11,
    e__Other__,
  };
  /**
   * Count the amount of the real world codec usage inside Matroska.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, MkvCodecTypeLabel> mkv_codec_type(3761);

  /**
   * generated from media.mkv_content_count
   * The number of times MKV content is detected as a source for media playback. This metric does not determine whether the MKV file is valid; it is simply a count based on the sniffed MIME type.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mkv_content_count(3762);

  /**
   * generated from media.mse_source_buffer_type
   */
  enum class MseSourceBufferTypeLabel: uint16_t {
    eVideohevc = 0,
    eVideowebm = 1,
    eAudiowebm = 2,
    eVideomp4 = 3,
    eAudiomp4 = 4,
    eVideomp2t = 5,
    eAudiomp2t = 6,
    eAudiompeg = 7,
    eAudioaac = 8,
    e__Other__,
  };
  /**
   * Count the actual or possible (because we don't support some of them for now) usage amount for each media mime type used in MSE. We collect this data in MediaSource's `AddSourceBuffer()` and `IsTypeSupported()`.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram MSE_SOURCE_BUFFER_TYPE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, MseSourceBufferTypeLabel> mse_source_buffer_type(3763);

  /**
   * generated from media.muted_play_time_percent
   * Percentage of time spent playing media that has an audio track, with the audio muted. Keyed by audio-only or video presence.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram MUTED_PLAY_TIME_PERCENT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> muted_play_time_percent(3764);

  /**
   * generated from media.video_clearkey_play_time
   * Total time spent playing Clearkey encrypted video in milliseconds.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_CLEARKEY_PLAY_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric video_clearkey_play_time(3765);

  /**
   * generated from media.video_dropped_compositor_frames_proportion_exponential
   * Ratio of compositor dropped frames per total decoded frames scaled by 10,000 between starting and stopping a video
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_DROPPED_COMPOSITOR_FRAMES_PROPORTION_EXPONENTIAL.
   */
  constexpr impl::CustomDistributionMetric video_dropped_compositor_frames_proportion_exponential(3766);

  /**
   * generated from media.video_dropped_decoded_frames_proportion_exponential
   * Ratio of decoder dropped frames per total decoded frames scaled by 10,000 between starting and stopping a video
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_DROPPED_DECODED_FRAMES_PROPORTION_EXPONENTIAL.
   */
  constexpr impl::CustomDistributionMetric video_dropped_decoded_frames_proportion_exponential(3767);

  /**
   * generated from media.video_dropped_frames_proportion
   * Percentage of frames decoded frames dropped between starting and stopping a video
   * This metric was generated to correspond to the Legacy Telemetry linear histogram VIDEO_DROPPED_FRAMES_PROPORTION.
   */
  constexpr impl::CustomDistributionMetric video_dropped_frames_proportion(3768);

  /**
   * generated from media.video_dropped_frames_proportion_exponential
   * Ratio of dropped frames per total decoded frames scaled by 10,000 between starting and stopping a video
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_DROPPED_FRAMES_PROPORTION_EXPONENTIAL.
   */
  constexpr impl::CustomDistributionMetric video_dropped_frames_proportion_exponential(3769);

  /**
   * generated from media.video_dropped_sink_frames_proportion_exponential
   * Ratio of sink dropped frames per total decoded frames scaled by 10,000 between starting and stopping a video
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_DROPPED_SINK_FRAMES_PROPORTION_EXPONENTIAL.
   */
  constexpr impl::CustomDistributionMetric video_dropped_sink_frames_proportion_exponential(3770);

  /**
   * generated from media.video_encrypted_play_time
   * Total time spent playing encrypted video in milliseconds.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_ENCRYPTED_PLAY_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric video_encrypted_play_time(3771);

  /**
   * generated from media.video_hardware_decoding_support
   * Record whether hardware decoding is supported for the specific video codec. The key is the type of video codec, eg. video/vp9. This metric was generated to correspond to the Legacy Telemetry scalar media.video_hardware_decoding_support.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> video_hardware_decoding_support(3772);

  /**
   * generated from media.video_hd_hardware_decoding_support
   * Record whether hardware decoding is supported for the specific video codec, this only records video in HD (1280*720) or higher resultion. The key is the type of video codec, eg. video/vp9. This metric was generated to correspond to the Legacy Telemetry scalar media.video_hd_hardware_decoding_support.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> video_hd_hardware_decoding_support(3773);

  /**
   * generated from media.video_hdr_play_time
   * Total time spent playing HDR video in milliseconds.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_HDR_PLAY_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric video_hdr_play_time(3774);

  /**
   * generated from media.video_hidden_play_time
   * Total time spent playing video while element is hidden, in milliseconds.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_HIDDEN_PLAY_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric video_hidden_play_time(3775);

  /**
   * generated from media.video_hidden_play_time_percentage
   * Percentage of total time spent playing video while element is hidden. Keyed by audio presence and by height ranges (boundaries: 240. 480, 576, 720, 1080, 2160), e.g.: 'V,0<h<=240', 'AV,h>2160'; and 'All' will accumulate all percentages. This is reported whenever the decoder stops. (eg. pausing media, encountering an error, changing to a new resource, page goes to the bf-cached or page gets discarded)
   * This metric was generated to correspond to the Legacy Telemetry linear histogram VIDEO_HIDDEN_PLAY_TIME_PERCENTAGE.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> video_hidden_play_time_percentage(3776);

  /**
   * generated from media.video_play_time
   * Total time spent playing video in milliseconds.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_PLAY_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric video_play_time(3777);

  /**
   * generated from media.video_visible_play_time
   * Total time spent playing visible video in milliseconds.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_VISIBLE_PLAY_TIME_MS.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> video_visible_play_time(3778);

  /**
   * generated from media.video_widevine_play_time
   * Total time spent playing Widevine encrypted video in milliseconds.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram VIDEO_WIDEVINE_PLAY_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric video_widevine_play_time(3779);
}

namespace media_audio {
  /**
   * generated from media.audio.backend
   */
  enum class BackendLabel: uint16_t {
    eUnknown = 0,
    eAudiounit = 1,
    eAudiounitRust = 2,
    eAaudio = 3,
    eOpensl = 4,
    eWasapi = 5,
    eWinmm = 6,
    eAlsa = 7,
    eJack = 8,
    eOss = 9,
    ePulse = 10,
    ePulseRust = 11,
    eSndio = 12,
    eSunaudio = 13,
    e__Other__,
  };
  /**
   * The operating system audio backend (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, BackendLabel> backend(3781);

  /**
   * generated from media.audio.init_failure
   */
  enum class InitFailureLabel: uint16_t {
    eFirst = 0,
    eOther = 1,
    e__Other__,
  };
  /**
   * Failure occurs when initializing the audio stream. (Migrated from the geckoview metric of the same name).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, InitFailureLabel> init_failure(3782);
}

namespace media_playback {
  /**
   * generated from media.playback.decode_error
   */
  struct DecodeErrorExtra {
    mozilla::Maybe<nsCString> decoderName;
    mozilla::Maybe<nsCString> errorName;
    mozilla::Maybe<bool> isHardwareAccelerated;
    mozilla::Maybe<nsCString> keySystem;
    mozilla::Maybe<nsCString> mimeType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (decoderName) {
        extraKeys.AppendElement()->AssignASCII("decoder_name");
        extraValues.EmplaceBack(decoderName.value());
      }
      if (errorName) {
        extraKeys.AppendElement()->AssignASCII("error_name");
        extraValues.EmplaceBack(errorName.value());
      }
      if (isHardwareAccelerated) {
        extraKeys.AppendElement()->AssignASCII("is_hardware_accelerated");
        extraValues.AppendElement()->AssignASCII(isHardwareAccelerated.value() ? "true" : "false");
      }
      if (keySystem) {
        extraKeys.AppendElement()->AssignASCII("key_system");
        extraValues.EmplaceBack(keySystem.value());
      }
      if (mimeType) {
        extraKeys.AppendElement()->AssignASCII("mime_type");
        extraValues.EmplaceBack(mimeType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record the decode error details.
   */
  constexpr impl::EventMetric<DecodeErrorExtra> decode_error(3783);

  /**
   * generated from media.playback.device_hardware_decoder_support
   */
  enum class DeviceHardwareDecoderSupportLabel: uint16_t {
    eH264 = 0,
    eVp8 = 1,
    eVp9 = 2,
    eAv1 = 3,
    eHevc = 4,
    e__Other__,
  };
  /**
   * The results of hardware decoder support for different video codecs. True means that codec can be decoded by hardware on user's device.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DeviceHardwareDecoderSupportLabel> device_hardware_decoder_support(3784);

  /**
   * generated from media.playback.first_frame_loaded
   */
  struct FirstFrameLoadedExtra {
    mozilla::Maybe<uint32_t> bufferingTime;
    mozilla::Maybe<nsCString> decoderName;
    mozilla::Maybe<uint32_t> firstFrameLoadedTime;
    mozilla::Maybe<bool> hlsDecoder;
    mozilla::Maybe<bool> isHardwareDecoding;
    mozilla::Maybe<bool> isHdr;
    mozilla::Maybe<nsCString> keySystem;
    mozilla::Maybe<uint32_t> metadataLoadedTime;
    mozilla::Maybe<nsCString> playbackType;
    mozilla::Maybe<nsCString> resolution;
    mozilla::Maybe<uint32_t> totalWaitingDataTime;
    mozilla::Maybe<nsCString> videoCodec;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (bufferingTime) {
        extraKeys.AppendElement()->AssignASCII("buffering_time");
        extraValues.AppendElement()->AppendInt(bufferingTime.value());
      }
      if (decoderName) {
        extraKeys.AppendElement()->AssignASCII("decoder_name");
        extraValues.EmplaceBack(decoderName.value());
      }
      if (firstFrameLoadedTime) {
        extraKeys.AppendElement()->AssignASCII("first_frame_loaded_time");
        extraValues.AppendElement()->AppendInt(firstFrameLoadedTime.value());
      }
      if (hlsDecoder) {
        extraKeys.AppendElement()->AssignASCII("hls_decoder");
        extraValues.AppendElement()->AssignASCII(hlsDecoder.value() ? "true" : "false");
      }
      if (isHardwareDecoding) {
        extraKeys.AppendElement()->AssignASCII("is_hardware_decoding");
        extraValues.AppendElement()->AssignASCII(isHardwareDecoding.value() ? "true" : "false");
      }
      if (isHdr) {
        extraKeys.AppendElement()->AssignASCII("is_hdr");
        extraValues.AppendElement()->AssignASCII(isHdr.value() ? "true" : "false");
      }
      if (keySystem) {
        extraKeys.AppendElement()->AssignASCII("key_system");
        extraValues.EmplaceBack(keySystem.value());
      }
      if (metadataLoadedTime) {
        extraKeys.AppendElement()->AssignASCII("metadata_loaded_time");
        extraValues.AppendElement()->AppendInt(metadataLoadedTime.value());
      }
      if (playbackType) {
        extraKeys.AppendElement()->AssignASCII("playback_type");
        extraValues.EmplaceBack(playbackType.value());
      }
      if (resolution) {
        extraKeys.AppendElement()->AssignASCII("resolution");
        extraValues.EmplaceBack(resolution.value());
      }
      if (totalWaitingDataTime) {
        extraKeys.AppendElement()->AssignASCII("total_waiting_data_time");
        extraValues.AppendElement()->AppendInt(totalWaitingDataTime.value());
      }
      if (videoCodec) {
        extraKeys.AppendElement()->AssignASCII("video_codec");
        extraValues.EmplaceBack(videoCodec.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The time that the media pipeline takes to load the first video frame.
   */
  constexpr impl::EventMetric<FirstFrameLoadedExtra> first_frame_loaded(3785);

  /**
   * generated from media.playback.not_supported_video_per_mime_type
   * Count the amount of times where video playback is failed to start due to the mime type is not supported by Firefox. The result is accumulated per mime type, eg. video/hevc.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> not_supported_video_per_mime_type(3786);
}

namespace media_recorder {
  /**
   * generated from media.recorder.mime_type_query
   */
  enum class MimeTypeQueryLabel: uint16_t {
    eMp4Av1 = 0,
    eMp4H264 = 1,
    eMp4H265 = 2,
    eMp4Vp9 = 3,
    eMp4Aac = 4,
    eMp4Flac = 5,
    eMp4Opus = 6,
    eMp4Unspecified = 7,
    eMp4Others = 8,
    eWebmAv1 = 9,
    eWebmVp8 = 10,
    eWebmVp9 = 11,
    eWebmOpus = 12,
    eWebmVorbis = 13,
    eWebmUnspecified = 14,
    eWebmOthers = 15,
    eMkvAv1 = 16,
    eMkvH264 = 17,
    eMkvH265 = 18,
    eMkvVp8 = 19,
    eMkvVp9 = 20,
    eMkvAac = 21,
    eMkvFlac = 22,
    eMkvOpus = 23,
    eMkvPcm = 24,
    eMkvVorbis = 25,
    eMkvUnspecified = 26,
    eMkvOthers = 27,
    eOggVp8 = 28,
    eOggVp9 = 29,
    eOggFlac = 30,
    eOggOpus = 31,
    eOggVorbis = 32,
    eOggUnspecified = 33,
    eOggOthers = 34,
    eEmpty = 35,
    eOthers = 36,
    e__Other__,
  };
  /**
   * Count the amount of times where a mime type is queried via MediaRecorder.isTypeSupported() or passed to the MediaRecorder constructor. The result is accumulated per mime type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, MimeTypeQueryLabel> mime_type_query(3787);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomMediaMetrics_h
