/* dict.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dict.vala, do not modify */

/* libenchant: Dict
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2025 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <sys/types.h>
#include <enchant.h>
#include <gmodule.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ENCHANT_DICT (enchant_dict_get_type ())
#define ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_DICT, EnchantDict))
#define ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_DICT, EnchantDictClass))
#define IS_ENCHANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_DICT))
#define IS_ENCHANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_DICT))
#define ENCHANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_DICT, EnchantDictClass))

typedef struct _EnchantDict EnchantDict;
typedef struct _EnchantDictClass EnchantDictClass;
typedef struct _EnchantDictPrivate EnchantDictPrivate;

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;

#define TYPE_ENCHANT_PROVIDER_DICT (enchant_provider_dict_get_type ())
#define ENCHANT_PROVIDER_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDict))
#define ENCHANT_PROVIDER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDictClass))
#define IS_ENCHANT_PROVIDER_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER_DICT))
#define IS_ENCHANT_PROVIDER_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER_DICT))
#define ENCHANT_PROVIDER_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER_DICT, EnchantProviderDictClass))

typedef struct _EnchantProviderDict EnchantProviderDict;
typedef struct _EnchantProviderDictClass EnchantProviderDictClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _enchant_pwl_unref0(var) ((var == NULL) ? NULL : (var = (enchant_pwl_unref (var), NULL)))
#define _enchant_provider_dict_unref0(var) ((var == NULL) ? NULL : (var = (enchant_provider_dict_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _EnchantProviderDictPrivate EnchantProviderDictPrivate;

#define TYPE_ENCHANT_PROVIDER (enchant_provider_get_type ())
#define ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PROVIDER, EnchantProvider))
#define ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))
#define IS_ENCHANT_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PROVIDER))
#define IS_ENCHANT_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PROVIDER))
#define ENCHANT_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PROVIDER, EnchantProviderClass))

typedef struct _EnchantProvider EnchantProvider;
typedef struct _EnchantProviderClass EnchantProviderClass;
typedef gint (*DictCheck) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef gchar** (*DictSuggest) (EnchantProviderDict* me, const gchar* word, size_t len, size_t* result_length1);
typedef void (*DictAddToSession) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef void (*DictRemoveFromSession) (EnchantProviderDict* me, const gchar* word, size_t len);
typedef const gchar* (*DictGetExtraWordCharacters) (EnchantProviderDict* me);
typedef gint (*DictIsWordCharacter) (EnchantProviderDict* me, guint32 uc_in, size_t n);
#define _g_strv_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_strv_builder_unref (var), NULL)))
typedef struct _EnchantProviderPrivate EnchantProviderPrivate;
typedef struct _EnchantBroker EnchantBroker;
typedef void (*ProviderDispose) (EnchantProvider* me);
typedef EnchantProviderDict* (*ProviderRequestDict) (EnchantProvider* me, const gchar* tag);
typedef void (*ProviderDisposeDict) (EnchantProvider* me, EnchantProviderDict* dict);
typedef gint (*ProviderDictionaryExists) (EnchantProvider* me, const gchar* tag);
typedef const gchar* (*ProviderIdentify) (EnchantProvider* me);
typedef const gchar* (*ProviderDescribe) (EnchantProvider* me);
typedef gchar** (*ProviderListDicts) (EnchantProvider* me, size_t* result_length1);
typedef struct _ParamSpecEnchantDict ParamSpecEnchantDict;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EnchantDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantDictPrivate * priv;
	GHashTable* session_include;
	GHashTable* session_exclude;
	EnchantPWL* pwl;
	EnchantPWL* exclude_pwl;
	gchar* personal_filename;
	gchar* exclude_filename;
};

struct _EnchantDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantDict *self);
};

struct _EnchantDictPrivate {
	EnchantProviderDict* dict;
};

struct _EnchantProviderDict {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderDictPrivate * priv;
	void* user_data;
	EnchantProvider* provider;
	gchar* language_tag;
	gchar* error;
	DictCheck check_method;
	DictSuggest suggest_method;
	DictAddToSession add_to_session_method;
	DictRemoveFromSession remove_from_session_method;
	DictGetExtraWordCharacters get_extra_word_characters_method;
	DictIsWordCharacter is_word_character_method;
};

struct _EnchantProviderDictClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProviderDict *self);
};

struct _EnchantProvider {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantProviderPrivate * priv;
	void* user_data;
	GModule* module;
	EnchantBroker* owner;
	ProviderDispose dispose;
	ProviderRequestDict request_dict;
	ProviderDisposeDict dispose_dict;
	ProviderDictionaryExists dictionary_exists;
	ProviderIdentify identify;
	ProviderDescribe describe;
	ProviderListDicts list_dicts;
};

struct _EnchantProviderClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantProvider *self);
};

struct _ParamSpecEnchantDict {
	GParamSpec parent_instance;
};

static gint EnchantDict_private_offset;
static gpointer enchant_dict_parent_class = NULL;

VALA_EXTERN gpointer enchant_dict_ref (gpointer instance);
VALA_EXTERN void enchant_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_dict (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_enchant_dict (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_enchant_dict (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_dict (const GValue* value);
VALA_EXTERN GType enchant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantDict, enchant_dict_unref)
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
VALA_EXTERN gpointer enchant_provider_dict_ref (gpointer instance);
VALA_EXTERN void enchant_provider_dict_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider_dict (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider_dict (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void value_take_enchant_provider_dict (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider_dict (const GValue* value);
VALA_EXTERN GType enchant_provider_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProviderDict, enchant_provider_dict_unref)
static EnchantDict* enchant_dict_new (void);
static EnchantDict* enchant_dict_construct (GType object_type);
static void _g_free0_ (gpointer var);
VALA_EXTERN EnchantDict* enchant_dict_with_implicit_pwl (EnchantProviderDict* dict,
                                             const gchar* lang,
                                             const gchar* pwl);
VALA_EXTERN EnchantDict* enchant_dict_with_pwl (EnchantProviderDict* dict,
                                    const gchar* pwlname,
                                    const gchar* exclname);
VALA_EXTERN gchar* enchant_get_user_config_dir (void);
VALA_EXTERN EnchantPWL* enchant_pwl_new (const gchar* filename);
VALA_EXTERN EnchantPWL* enchant_pwl_construct (GType object_type,
                                   const gchar* filename);
static gboolean enchant_dict_excluded (EnchantDict* self,
                                const gchar* word);
VALA_EXTERN gint enchant_pwl_check (EnchantPWL* self,
                        const gchar* word_buf,
                        ssize_t len);
static gboolean enchant_dict_contains (EnchantDict* self,
                                const gchar* word);
VALA_EXTERN const gchar* enchant_dict_get_extra_word_characters (EnchantDict* self);
VALA_EXTERN gpointer enchant_provider_ref (gpointer instance);
VALA_EXTERN void enchant_provider_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_provider (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_enchant_provider (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_enchant_provider (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_provider (const GValue* value);
VALA_EXTERN GType enchant_provider_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantProvider, enchant_provider_unref)
VALA_EXTERN gint enchant_dict_is_word_character (EnchantDict* _self_,
                                     guint32 uc_in,
                                     size_t n);
VALA_EXTERN gint enchant_dict_check (EnchantDict* _self_,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN void enchant_dict_clear_error (EnchantDict* self);
static gchar** enchant_dict_filter_suggestions (EnchantDict* self,
                                         gchar** suggs,
                                         gint suggs_length1,
                                         gint* result_length1);
VALA_EXTERN gchar** enchant_dict_suggest (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len,
                              size_t* result_length1);
VALA_EXTERN void enchant_dict_add (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len);
VALA_EXTERN void enchant_dict_add_to_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len);
VALA_EXTERN void enchant_pwl_add (EnchantPWL* self,
                      const gchar* word_buf,
                      ssize_t len);
VALA_EXTERN void enchant_pwl_remove (EnchantPWL* self,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gint enchant_dict_is_added (EnchantDict* self,
                            const gchar* word_buf,
                            ssize_t len);
VALA_EXTERN void enchant_dict_remove (EnchantDict* self,
                          const gchar* word_buf,
                          ssize_t len);
VALA_EXTERN void enchant_dict_remove_from_session (EnchantDict* self,
                                       const gchar* word_buf,
                                       ssize_t len);
VALA_EXTERN gint enchant_dict_is_removed (EnchantDict* self,
                              const gchar* word_buf,
                              ssize_t len);
VALA_EXTERN void enchant_dict_store_replacement (EnchantDict* self,
                                     const gchar* mis,
                                     ssize_t mis_len,
                                     const gchar* cor,
                                     ssize_t cor_len);
VALA_EXTERN void enchant_dict_free_string_list (EnchantDict* self,
                                    gchar** string_list);
VALA_EXTERN void enchant_dict_describe (EnchantDict* self,
                            EnchantDictDescribeFn fn,
                            void* user_data);
VALA_EXTERN void enchant_broker_free (EnchantBroker * self);
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantBroker, enchant_broker_free)
VALA_EXTERN void enchant_dict_set_error (EnchantDict* self,
                             const gchar* err);
VALA_EXTERN void enchant_provider_dict_set_error (EnchantProviderDict* self,
                                      const gchar* err);
VALA_EXTERN const gchar* enchant_dict_get_error (EnchantDict* self);
static void enchant_dict_finalize (EnchantDict * obj);
static GType enchant_dict_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
enchant_dict_get_instance_private (EnchantDict* self)
{
	return G_STRUCT_MEMBER_P (self, EnchantDict_private_offset);
}

static void
_g_free0_ (gpointer var)
{
#line 42 "dict.vala"
	var = (g_free (var), NULL);
#line 355 "dict.c"
}

static EnchantDict*
enchant_dict_construct (GType object_type)
{
	EnchantDict* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
#line 41 "dict.vala"
	self = (EnchantDict*) g_type_create_instance (object_type);
#line 42 "dict.vala"
	_tmp0_ = g_str_hash;
#line 42 "dict.vala"
	_tmp1_ = g_str_equal;
#line 42 "dict.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
#line 42 "dict.vala"
	_g_hash_table_unref0 (self->session_include);
#line 42 "dict.vala"
	self->session_include = _tmp2_;
#line 43 "dict.vala"
	_tmp3_ = g_str_hash;
#line 43 "dict.vala"
	_tmp4_ = g_str_equal;
#line 43 "dict.vala"
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_free0_);
#line 43 "dict.vala"
	_g_hash_table_unref0 (self->session_exclude);
#line 43 "dict.vala"
	self->session_exclude = _tmp5_;
#line 41 "dict.vala"
	return self;
#line 392 "dict.c"
}

static EnchantDict*
enchant_dict_new (void)
{
#line 41 "dict.vala"
	return enchant_dict_construct (TYPE_ENCHANT_DICT);
#line 400 "dict.c"
}

EnchantDict*
enchant_dict_with_implicit_pwl (EnchantProviderDict* dict,
                                const gchar* lang,
                                const gchar* pwl)
{
	gchar* user_config_dir = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	EnchantDict* _tmp13_;
	EnchantDict* _tmp14_;
	EnchantDict* result;
#line 46 "dict.vala"
	g_return_val_if_fail (dict != NULL, NULL);
#line 46 "dict.vala"
	g_return_val_if_fail (lang != NULL, NULL);
#line 47 "dict.vala"
	if (pwl != NULL) {
#line 430 "dict.c"
		EnchantDict* _tmp0_;
#line 48 "dict.vala"
		_tmp0_ = enchant_dict_with_pwl (dict, pwl, NULL);
#line 48 "dict.vala"
		result = _tmp0_;
#line 48 "dict.vala"
		return result;
#line 438 "dict.c"
	}
#line 50 "dict.vala"
	_tmp1_ = enchant_get_user_config_dir ();
#line 50 "dict.vala"
	user_config_dir = _tmp1_;
#line 51 "dict.vala"
	_tmp2_ = user_config_dir;
#line 51 "dict.vala"
	g_mkdir_with_parents (_tmp2_, 0700);
#line 52 "dict.vala"
	_tmp3_ = user_config_dir;
#line 52 "dict.vala"
	_tmp4_ = g_strdup_printf ("%s.dic", lang);
#line 52 "dict.vala"
	_tmp5_ = _tmp4_;
#line 52 "dict.vala"
	_tmp6_ = g_build_filename (_tmp3_, _tmp5_, NULL);
#line 52 "dict.vala"
	_tmp7_ = _tmp6_;
#line 52 "dict.vala"
	_tmp8_ = user_config_dir;
#line 52 "dict.vala"
	_tmp9_ = g_strdup_printf ("%s.exc", lang);
#line 52 "dict.vala"
	_tmp10_ = _tmp9_;
#line 52 "dict.vala"
	_tmp11_ = g_build_filename (_tmp8_, _tmp10_, NULL);
#line 52 "dict.vala"
	_tmp12_ = _tmp11_;
#line 52 "dict.vala"
	_tmp13_ = enchant_dict_with_pwl (dict, _tmp7_, _tmp12_);
#line 52 "dict.vala"
	_tmp14_ = _tmp13_;
#line 52 "dict.vala"
	_g_free0 (_tmp12_);
#line 52 "dict.vala"
	_g_free0 (_tmp10_);
#line 52 "dict.vala"
	_g_free0 (_tmp7_);
#line 52 "dict.vala"
	_g_free0 (_tmp5_);
#line 52 "dict.vala"
	result = _tmp14_;
#line 52 "dict.vala"
	_g_free0 (user_config_dir);
#line 52 "dict.vala"
	return result;
#line 486 "dict.c"
}

static gpointer
_enchant_provider_dict_ref0 (gpointer self)
{
#line 63 "dict.vala"
	return self ? enchant_provider_dict_ref (self) : NULL;
#line 494 "dict.c"
}

EnchantDict*
enchant_dict_with_pwl (EnchantProviderDict* dict,
                       const gchar* pwlname,
                       const gchar* exclname)
{
	EnchantPWL* pwl = NULL;
	EnchantPWL* _tmp0_;
	EnchantPWL* exclude_pwl = NULL;
	EnchantPWL* _tmp1_;
	EnchantDict* session = NULL;
	EnchantDict* _tmp2_;
	EnchantProviderDict* _tmp3_;
	EnchantPWL* _tmp4_;
	EnchantPWL* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	EnchantDict* result;
#line 58 "dict.vala"
	g_return_val_if_fail (dict != NULL, NULL);
#line 58 "dict.vala"
	g_return_val_if_fail (pwlname != NULL, NULL);
#line 59 "dict.vala"
	_tmp0_ = enchant_pwl_new (pwlname);
#line 59 "dict.vala"
	pwl = _tmp0_;
#line 60 "dict.vala"
	_tmp1_ = enchant_pwl_new (exclname);
#line 60 "dict.vala"
	exclude_pwl = _tmp1_;
#line 62 "dict.vala"
	_tmp2_ = enchant_dict_new ();
#line 62 "dict.vala"
	session = _tmp2_;
#line 63 "dict.vala"
	_tmp3_ = _enchant_provider_dict_ref0 (dict);
#line 63 "dict.vala"
	_enchant_provider_dict_unref0 (session->priv->dict);
#line 63 "dict.vala"
	session->priv->dict = _tmp3_;
#line 64 "dict.vala"
	_tmp4_ = pwl;
#line 64 "dict.vala"
	pwl = NULL;
#line 64 "dict.vala"
	_enchant_pwl_unref0 (session->pwl);
#line 64 "dict.vala"
	session->pwl = _tmp4_;
#line 65 "dict.vala"
	_tmp5_ = exclude_pwl;
#line 65 "dict.vala"
	exclude_pwl = NULL;
#line 65 "dict.vala"
	_enchant_pwl_unref0 (session->exclude_pwl);
#line 65 "dict.vala"
	session->exclude_pwl = _tmp5_;
#line 66 "dict.vala"
	_tmp6_ = g_strdup (pwlname);
#line 66 "dict.vala"
	_g_free0 (session->personal_filename);
#line 66 "dict.vala"
	session->personal_filename = _tmp6_;
#line 67 "dict.vala"
	_tmp7_ = g_strdup (exclname);
#line 67 "dict.vala"
	_g_free0 (session->exclude_filename);
#line 67 "dict.vala"
	session->exclude_filename = _tmp7_;
#line 69 "dict.vala"
	result = session;
#line 69 "dict.vala"
	_enchant_pwl_unref0 (exclude_pwl);
#line 69 "dict.vala"
	_enchant_pwl_unref0 (pwl);
#line 69 "dict.vala"
	return result;
#line 572 "dict.c"
}

static gboolean
enchant_dict_excluded (EnchantDict* self,
                       const gchar* word)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
#line 72 "dict.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 72 "dict.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 73 "dict.vala"
	_tmp1_ = self->session_include;
#line 73 "dict.vala"
	if (!g_hash_table_contains (_tmp1_, word)) {
#line 590 "dict.c"
		gboolean _tmp2_ = FALSE;
		GHashTable* _tmp3_;
#line 74 "dict.vala"
		_tmp3_ = self->session_exclude;
#line 74 "dict.vala"
		if (g_hash_table_contains (_tmp3_, word)) {
#line 74 "dict.vala"
			_tmp2_ = TRUE;
#line 599 "dict.c"
		} else {
			EnchantPWL* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
#line 75 "dict.vala"
			_tmp4_ = self->exclude_pwl;
#line 75 "dict.vala"
			_tmp5_ = strlen (word);
#line 75 "dict.vala"
			_tmp6_ = _tmp5_;
#line 75 "dict.vala"
			_tmp2_ = enchant_pwl_check (_tmp4_, word, (ssize_t) _tmp6_) == 0;
#line 612 "dict.c"
		}
#line 74 "dict.vala"
		_tmp0_ = _tmp2_;
#line 616 "dict.c"
	} else {
#line 73 "dict.vala"
		_tmp0_ = FALSE;
#line 620 "dict.c"
	}
#line 73 "dict.vala"
	result = _tmp0_;
#line 73 "dict.vala"
	return result;
#line 626 "dict.c"
}

static gboolean
enchant_dict_contains (EnchantDict* self,
                       const gchar* word)
{
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_;
	gboolean result;
#line 78 "dict.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 78 "dict.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 79 "dict.vala"
	_tmp1_ = self->session_include;
#line 79 "dict.vala"
	if (g_hash_table_contains (_tmp1_, word)) {
#line 79 "dict.vala"
		_tmp0_ = TRUE;
#line 646 "dict.c"
	} else {
		gboolean _tmp2_ = FALSE;
		EnchantPWL* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 80 "dict.vala"
		_tmp3_ = self->pwl;
#line 80 "dict.vala"
		_tmp4_ = strlen (word);
#line 80 "dict.vala"
		_tmp5_ = _tmp4_;
#line 80 "dict.vala"
		if (enchant_pwl_check (_tmp3_, word, (ssize_t) _tmp5_) == 0) {
#line 660 "dict.c"
			EnchantPWL* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
#line 81 "dict.vala"
			_tmp6_ = self->exclude_pwl;
#line 81 "dict.vala"
			_tmp7_ = strlen (word);
#line 81 "dict.vala"
			_tmp8_ = _tmp7_;
#line 81 "dict.vala"
			_tmp2_ = enchant_pwl_check (_tmp6_, word, (ssize_t) _tmp8_) != 0;
#line 672 "dict.c"
		} else {
#line 80 "dict.vala"
			_tmp2_ = FALSE;
#line 676 "dict.c"
		}
#line 80 "dict.vala"
		_tmp0_ = _tmp2_;
#line 680 "dict.c"
	}
#line 79 "dict.vala"
	result = _tmp0_;
#line 79 "dict.vala"
	return result;
#line 686 "dict.c"
}

const gchar*
enchant_dict_get_extra_word_characters (EnchantDict* self)
{
	const gchar* _tmp0_ = NULL;
	EnchantProviderDict* _tmp1_;
	DictGetExtraWordCharacters _tmp2_;
	const gchar* result;
#line 84 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "dict.vala"
	_tmp1_ = self->priv->dict;
#line 85 "dict.vala"
	_tmp2_ = _tmp1_->get_extra_word_characters_method;
#line 85 "dict.vala"
	if (_tmp2_ != NULL) {
#line 704 "dict.c"
		EnchantProviderDict* _tmp3_;
		DictGetExtraWordCharacters _tmp4_;
		EnchantProviderDict* _tmp5_;
		const gchar* _tmp6_;
#line 86 "dict.vala"
		_tmp3_ = self->priv->dict;
#line 86 "dict.vala"
		_tmp4_ = _tmp3_->get_extra_word_characters_method;
#line 86 "dict.vala"
		_tmp5_ = self->priv->dict;
#line 86 "dict.vala"
		_tmp6_ = _tmp4_ (_tmp5_);
#line 86 "dict.vala"
		_tmp0_ = _tmp6_;
#line 719 "dict.c"
	} else {
#line 86 "dict.vala"
		_tmp0_ = "";
#line 723 "dict.c"
	}
#line 85 "dict.vala"
	result = _tmp0_;
#line 85 "dict.vala"
	return result;
#line 729 "dict.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 743 "dict.c"
}

gint
enchant_dict_is_word_character (EnchantDict* _self_,
                                guint32 uc_in,
                                size_t n)
{
	gboolean _tmp0_ = FALSE;
	gunichar uc = 0U;
	gboolean _tmp6_ = FALSE;
	GUnicodeType type = 0;
	gint result;
#line 89 "dict.vala"
	_vala_return_val_if_fail (n <= ((size_t) 2), "n <= 2", 0);
#line 92 "dict.vala"
	if (_self_ != NULL) {
#line 760 "dict.c"
		EnchantProviderDict* _tmp1_;
		DictIsWordCharacter _tmp2_;
#line 92 "dict.vala"
		_tmp1_ = _self_->priv->dict;
#line 92 "dict.vala"
		_tmp2_ = _tmp1_->is_word_character_method;
#line 92 "dict.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 769 "dict.c"
	} else {
#line 92 "dict.vala"
		_tmp0_ = FALSE;
#line 773 "dict.c"
	}
#line 92 "dict.vala"
	if (_tmp0_) {
#line 777 "dict.c"
		EnchantProviderDict* _tmp3_;
		DictIsWordCharacter _tmp4_;
		EnchantProviderDict* _tmp5_;
#line 93 "dict.vala"
		_tmp3_ = _self_->priv->dict;
#line 93 "dict.vala"
		_tmp4_ = _tmp3_->is_word_character_method;
#line 93 "dict.vala"
		_tmp5_ = _self_->priv->dict;
#line 93 "dict.vala"
		result = _tmp4_ (_tmp5_, uc_in, n);
#line 93 "dict.vala"
		return result;
#line 791 "dict.c"
	}
#line 95 "dict.vala"
	uc = (gunichar) uc_in;
#line 98 "dict.vala"
	if (uc == string_get_char ("'", (glong) 0)) {
#line 98 "dict.vala"
		_tmp6_ = TRUE;
#line 799 "dict.c"
	} else {
#line 98 "dict.vala"
		_tmp6_ = uc == string_get_char ("’", (glong) 0);
#line 803 "dict.c"
	}
#line 98 "dict.vala"
	if (_tmp6_) {
#line 807 "dict.c"
		gint _tmp7_ = 0;
#line 99 "dict.vala"
		if (n < ((size_t) 2)) {
#line 99 "dict.vala"
			_tmp7_ = 1;
#line 813 "dict.c"
		} else {
#line 99 "dict.vala"
			_tmp7_ = 0;
#line 817 "dict.c"
		}
#line 99 "dict.vala"
		result = _tmp7_;
#line 99 "dict.vala"
		return result;
#line 823 "dict.c"
	}
#line 101 "dict.vala"
	type = g_unichar_type (uc);
#line 103 "dict.vala"
	switch (type) {
#line 103 "dict.vala"
		case G_UNICODE_MODIFIER_LETTER:
#line 103 "dict.vala"
		case G_UNICODE_LOWERCASE_LETTER:
#line 103 "dict.vala"
		case G_UNICODE_TITLECASE_LETTER:
#line 103 "dict.vala"
		case G_UNICODE_UPPERCASE_LETTER:
#line 103 "dict.vala"
		case G_UNICODE_OTHER_LETTER:
#line 103 "dict.vala"
		case G_UNICODE_SPACING_MARK:
#line 103 "dict.vala"
		case G_UNICODE_ENCLOSING_MARK:
#line 103 "dict.vala"
		case G_UNICODE_NON_SPACING_MARK:
#line 103 "dict.vala"
		case G_UNICODE_DECIMAL_NUMBER:
#line 103 "dict.vala"
		case G_UNICODE_LETTER_NUMBER:
#line 103 "dict.vala"
		case G_UNICODE_OTHER_NUMBER:
#line 103 "dict.vala"
		case G_UNICODE_CONNECT_PUNCTUATION:
#line 853 "dict.c"
		{
#line 116 "dict.vala"
			result = 1;
#line 116 "dict.vala"
			return result;
#line 859 "dict.c"
		}
#line 103 "dict.vala"
		case G_UNICODE_DASH_PUNCTUATION:
#line 863 "dict.c"
		{
			gboolean _tmp8_ = FALSE;
#line 119 "dict.vala"
			if (n == ((size_t) 1)) {
#line 119 "dict.vala"
				_tmp8_ = type == G_UNICODE_DASH_PUNCTUATION;
#line 870 "dict.c"
			} else {
#line 119 "dict.vala"
				_tmp8_ = FALSE;
#line 874 "dict.c"
			}
#line 119 "dict.vala"
			if (_tmp8_) {
#line 120 "dict.vala"
				result = 1;
#line 120 "dict.vala"
				return result;
#line 882 "dict.c"
			}
#line 121 "dict.vala"
			result = 0;
#line 121 "dict.vala"
			return result;
#line 888 "dict.c"
		}
		default:
		{
#line 124 "dict.vala"
			result = 0;
#line 124 "dict.vala"
			return result;
#line 896 "dict.c"
		}
	}
}

gint
enchant_dict_check (EnchantDict* _self_,
                    const gchar* word_buf,
                    ssize_t len)
{
	gboolean _tmp0_ = FALSE;
	gchar* word = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	EnchantProviderDict* _tmp5_;
	DictCheck _tmp6_;
	EnchantProviderDict* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint result;
#line 132 "dict.vala"
	if (_self_ == NULL) {
#line 132 "dict.vala"
		_tmp0_ = TRUE;
#line 924 "dict.c"
	} else {
#line 132 "dict.vala"
		_tmp0_ = word_buf == NULL;
#line 928 "dict.c"
	}
#line 132 "dict.vala"
	if (_tmp0_) {
#line 133 "dict.vala"
		result = -1;
#line 133 "dict.vala"
		return result;
#line 936 "dict.c"
	}
#line 134 "dict.vala"
	_tmp1_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 134 "dict.vala"
	word = _tmp1_;
#line 135 "dict.vala"
	_tmp2_ = word;
#line 135 "dict.vala"
	if (_tmp2_ == NULL) {
#line 136 "dict.vala"
		result = -1;
#line 136 "dict.vala"
		_g_free0 (word);
#line 136 "dict.vala"
		return result;
#line 952 "dict.c"
	}
#line 138 "dict.vala"
	enchant_dict_clear_error (_self_);
#line 141 "dict.vala"
	_tmp3_ = word;
#line 141 "dict.vala"
	if (enchant_dict_excluded (_self_, _tmp3_)) {
#line 142 "dict.vala"
		result = 1;
#line 142 "dict.vala"
		_g_free0 (word);
#line 142 "dict.vala"
		return result;
#line 966 "dict.c"
	}
#line 145 "dict.vala"
	_tmp4_ = word;
#line 145 "dict.vala"
	if (enchant_dict_contains (_self_, _tmp4_)) {
#line 146 "dict.vala"
		result = 0;
#line 146 "dict.vala"
		_g_free0 (word);
#line 146 "dict.vala"
		return result;
#line 978 "dict.c"
	}
#line 148 "dict.vala"
	_tmp5_ = _self_->priv->dict;
#line 148 "dict.vala"
	_tmp6_ = _tmp5_->check_method;
#line 148 "dict.vala"
	_tmp7_ = _self_->priv->dict;
#line 148 "dict.vala"
	_tmp8_ = word;
#line 148 "dict.vala"
	_tmp9_ = word;
#line 148 "dict.vala"
	_tmp10_ = strlen (_tmp9_);
#line 148 "dict.vala"
	_tmp11_ = _tmp10_;
#line 148 "dict.vala"
	result = _tmp6_ (_tmp7_, _tmp8_, (size_t) _tmp11_);
#line 148 "dict.vala"
	_g_free0 (word);
#line 148 "dict.vala"
	return result;
#line 1000 "dict.c"
}

static gchar**
enchant_dict_filter_suggestions (EnchantDict* self,
                                 gchar** suggs,
                                 gint suggs_length1,
                                 gint* result_length1)
{
	GStrvBuilder* sb = NULL;
	GStrvBuilder* _tmp0_;
	GStrvBuilder* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** result;
#line 153 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 154 "dict.vala"
	_tmp0_ = g_strv_builder_new ();
#line 154 "dict.vala"
	sb = _tmp0_;
#line 1023 "dict.c"
	{
		gchar** sugg_collection = NULL;
		gint sugg_collection_length1 = 0;
		gint _sugg_collection_size_ = 0;
		gint sugg_it = 0;
#line 155 "dict.vala"
		sugg_collection = suggs;
#line 155 "dict.vala"
		sugg_collection_length1 = suggs_length1;
#line 155 "dict.vala"
		for (sugg_it = 0; sugg_it < sugg_collection_length1; sugg_it = sugg_it + 1) {
#line 1035 "dict.c"
			gchar* _tmp1_;
			gchar* sugg = NULL;
#line 155 "dict.vala"
			_tmp1_ = g_strdup (sugg_collection[sugg_it]);
#line 155 "dict.vala"
			sugg = _tmp1_;
#line 1042 "dict.c"
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_;
#line 156 "dict.vala"
				_tmp4_ = sugg;
#line 156 "dict.vala"
				if (_tmp4_ != NULL) {
#line 1051 "dict.c"
					const gchar* _tmp5_;
#line 156 "dict.vala"
					_tmp5_ = sugg;
#line 156 "dict.vala"
					_tmp3_ = g_utf8_validate (_tmp5_, (gssize) -1, NULL);
#line 1057 "dict.c"
				} else {
#line 156 "dict.vala"
					_tmp3_ = FALSE;
#line 1061 "dict.c"
				}
#line 156 "dict.vala"
				if (_tmp3_) {
#line 1065 "dict.c"
					const gchar* _tmp6_;
#line 156 "dict.vala"
					_tmp6_ = sugg;
#line 156 "dict.vala"
					_tmp2_ = !enchant_dict_excluded (self, _tmp6_);
#line 1071 "dict.c"
				} else {
#line 156 "dict.vala"
					_tmp2_ = FALSE;
#line 1075 "dict.c"
				}
#line 156 "dict.vala"
				if (_tmp2_) {
#line 1079 "dict.c"
					GStrvBuilder* _tmp7_;
					const gchar* _tmp8_;
#line 157 "dict.vala"
					_tmp7_ = sb;
#line 157 "dict.vala"
					_tmp8_ = sugg;
#line 157 "dict.vala"
					g_strv_builder_add (_tmp7_, _tmp8_);
#line 1088 "dict.c"
				}
#line 155 "dict.vala"
				_g_free0 (sugg);
#line 1092 "dict.c"
			}
		}
	}
#line 158 "dict.vala"
	_tmp9_ = sb;
#line 158 "dict.vala"
	_tmp11_ = _tmp10_ = g_strv_builder_end (_tmp9_);
#line 158 "dict.vala"
	_tmp12_ = _tmp11_;
#line 158 "dict.vala"
	_tmp12__length1 = _vala_array_length (_tmp10_);
#line 158 "dict.vala"
	if (result_length1) {
#line 158 "dict.vala"
		*result_length1 = _tmp12__length1;
#line 1108 "dict.c"
	}
#line 158 "dict.vala"
	result = _tmp12_;
#line 158 "dict.vala"
	_g_strv_builder_unref0 (sb);
#line 158 "dict.vala"
	return result;
#line 1116 "dict.c"
}

gchar**
enchant_dict_suggest (EnchantDict* self,
                      const gchar* word_buf,
                      ssize_t len,
                      size_t* result_length1)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** dict_suggs = NULL;
	EnchantProviderDict* _tmp3_;
	DictSuggest _tmp4_;
	EnchantProviderDict* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	size_t _tmp10_ = 0;
	gchar** _tmp11_;
	gint dict_suggs_length1;
	gint _dict_suggs_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** result;
#line 162 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 162 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, NULL);
#line 163 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 163 "dict.vala"
	word = _tmp0_;
#line 164 "dict.vala"
	_tmp1_ = word;
#line 164 "dict.vala"
	if (_tmp1_ == NULL) {
#line 1157 "dict.c"
		gchar** _tmp2_;
		gint _tmp2__length1;
#line 165 "dict.vala"
		_tmp2_ = NULL;
#line 165 "dict.vala"
		_tmp2__length1 = 0;
#line 165 "dict.vala"
		if (result_length1) {
#line 165 "dict.vala"
			*result_length1 = _tmp2__length1;
#line 1168 "dict.c"
		}
#line 165 "dict.vala"
		result = _tmp2_;
#line 165 "dict.vala"
		_g_free0 (word);
#line 165 "dict.vala"
		return result;
#line 1176 "dict.c"
	}
#line 167 "dict.vala"
	enchant_dict_clear_error (self);
#line 170 "dict.vala"
	_tmp3_ = self->priv->dict;
#line 170 "dict.vala"
	_tmp4_ = _tmp3_->suggest_method;
#line 170 "dict.vala"
	_tmp5_ = self->priv->dict;
#line 170 "dict.vala"
	_tmp6_ = word;
#line 170 "dict.vala"
	_tmp7_ = word;
#line 170 "dict.vala"
	_tmp8_ = strlen (_tmp7_);
#line 170 "dict.vala"
	_tmp9_ = _tmp8_;
#line 170 "dict.vala"
	_tmp11_ = _tmp4_ (_tmp5_, _tmp6_, (size_t) _tmp9_, &_tmp10_);
#line 170 "dict.vala"
	dict_suggs = _tmp11_;
#line 170 "dict.vala"
	dict_suggs_length1 = _tmp10_;
#line 170 "dict.vala"
	_dict_suggs_size_ = dict_suggs_length1;
#line 171 "dict.vala"
	_tmp12_ = dict_suggs;
#line 171 "dict.vala"
	_tmp12__length1 = dict_suggs_length1;
#line 171 "dict.vala"
	if (_tmp12_ != NULL) {
#line 1208 "dict.c"
		gchar** _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_ = 0;
		gchar** _tmp15_;
#line 172 "dict.vala"
		_tmp13_ = dict_suggs;
#line 172 "dict.vala"
		_tmp13__length1 = dict_suggs_length1;
#line 172 "dict.vala"
		_tmp15_ = enchant_dict_filter_suggestions (self, _tmp13_, (gint) _tmp13__length1, &_tmp14_);
#line 172 "dict.vala"
		dict_suggs = (_vala_array_free (dict_suggs, dict_suggs_length1, (GDestroyNotify) g_free), NULL);
#line 172 "dict.vala"
		dict_suggs = _tmp15_;
#line 172 "dict.vala"
		dict_suggs_length1 = _tmp14_;
#line 172 "dict.vala"
		_dict_suggs_size_ = dict_suggs_length1;
#line 1227 "dict.c"
	}
#line 174 "dict.vala"
	_tmp16_ = dict_suggs;
#line 174 "dict.vala"
	_tmp16__length1 = dict_suggs_length1;
#line 174 "dict.vala"
	if (result_length1) {
#line 174 "dict.vala"
		*result_length1 = _tmp16__length1;
#line 1237 "dict.c"
	}
#line 174 "dict.vala"
	result = _tmp16_;
#line 174 "dict.vala"
	_g_free0 (word);
#line 174 "dict.vala"
	return result;
#line 1245 "dict.c"
}

void
enchant_dict_add (EnchantDict* self,
                  const gchar* word_buf,
                  ssize_t len)
{
	EnchantPWL* _tmp0_;
	EnchantPWL* _tmp1_;
#line 177 "dict.vala"
	g_return_if_fail (self != NULL);
#line 177 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 178 "dict.vala"
	enchant_dict_add_to_session (self, word_buf, len);
#line 179 "dict.vala"
	_tmp0_ = self->pwl;
#line 179 "dict.vala"
	enchant_pwl_add (_tmp0_, word_buf, len);
#line 180 "dict.vala"
	_tmp1_ = self->exclude_pwl;
#line 180 "dict.vala"
	enchant_pwl_remove (_tmp1_, word_buf, len);
#line 1269 "dict.c"
}

void
enchant_dict_add_to_session (EnchantDict* self,
                             const gchar* word_buf,
                             ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	EnchantProviderDict* _tmp7_;
	DictAddToSession _tmp8_;
#line 183 "dict.vala"
	g_return_if_fail (self != NULL);
#line 183 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 184 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 184 "dict.vala"
	word = _tmp0_;
#line 185 "dict.vala"
	_tmp1_ = word;
#line 185 "dict.vala"
	if (_tmp1_ == NULL) {
#line 186 "dict.vala"
		_g_free0 (word);
#line 186 "dict.vala"
		return;
#line 1303 "dict.c"
	}
#line 187 "dict.vala"
	enchant_dict_clear_error (self);
#line 188 "dict.vala"
	_tmp2_ = self->session_exclude;
#line 188 "dict.vala"
	_tmp3_ = word;
#line 188 "dict.vala"
	g_hash_table_remove (_tmp2_, _tmp3_);
#line 189 "dict.vala"
	_tmp4_ = self->session_include;
#line 189 "dict.vala"
	_tmp5_ = word;
#line 189 "dict.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 189 "dict.vala"
	g_hash_table_add (_tmp4_, _tmp6_);
#line 190 "dict.vala"
	_tmp7_ = self->priv->dict;
#line 190 "dict.vala"
	_tmp8_ = _tmp7_->add_to_session_method;
#line 190 "dict.vala"
	if (_tmp8_ != NULL) {
#line 1327 "dict.c"
		EnchantProviderDict* _tmp9_;
		DictAddToSession _tmp10_;
		EnchantProviderDict* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
#line 191 "dict.vala"
		_tmp9_ = self->priv->dict;
#line 191 "dict.vala"
		_tmp10_ = _tmp9_->add_to_session_method;
#line 191 "dict.vala"
		_tmp11_ = self->priv->dict;
#line 191 "dict.vala"
		_tmp12_ = word;
#line 191 "dict.vala"
		_tmp13_ = word;
#line 191 "dict.vala"
		_tmp14_ = strlen (_tmp13_);
#line 191 "dict.vala"
		_tmp15_ = _tmp14_;
#line 191 "dict.vala"
		_tmp10_ (_tmp11_, _tmp12_, (size_t) _tmp15_);
#line 1351 "dict.c"
	}
#line 183 "dict.vala"
	_g_free0 (word);
#line 1355 "dict.c"
}

gint
enchant_dict_is_added (EnchantDict* self,
                       const gchar* word_buf,
                       ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	gint result;
#line 194 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 194 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 195 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 195 "dict.vala"
	word = _tmp0_;
#line 196 "dict.vala"
	_tmp1_ = word;
#line 196 "dict.vala"
	if (_tmp1_ == NULL) {
#line 197 "dict.vala"
		result = 0;
#line 197 "dict.vala"
		_g_free0 (word);
#line 197 "dict.vala"
		return result;
#line 1387 "dict.c"
	}
#line 198 "dict.vala"
	enchant_dict_clear_error (self);
#line 199 "dict.vala"
	_tmp3_ = word;
#line 199 "dict.vala"
	if (enchant_dict_contains (self, _tmp3_)) {
#line 199 "dict.vala"
		_tmp2_ = 1;
#line 1397 "dict.c"
	} else {
#line 199 "dict.vala"
		_tmp2_ = 0;
#line 1401 "dict.c"
	}
#line 199 "dict.vala"
	result = _tmp2_;
#line 199 "dict.vala"
	_g_free0 (word);
#line 199 "dict.vala"
	return result;
#line 1409 "dict.c"
}

void
enchant_dict_remove (EnchantDict* self,
                     const gchar* word_buf,
                     ssize_t len)
{
	EnchantPWL* _tmp0_;
	EnchantPWL* _tmp1_;
#line 202 "dict.vala"
	g_return_if_fail (self != NULL);
#line 202 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 203 "dict.vala"
	enchant_dict_remove_from_session (self, word_buf, len);
#line 204 "dict.vala"
	_tmp0_ = self->pwl;
#line 204 "dict.vala"
	enchant_pwl_remove (_tmp0_, word_buf, len);
#line 205 "dict.vala"
	_tmp1_ = self->exclude_pwl;
#line 205 "dict.vala"
	enchant_pwl_add (_tmp1_, word_buf, len);
#line 1433 "dict.c"
}

void
enchant_dict_remove_from_session (EnchantDict* self,
                                  const gchar* word_buf,
                                  ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	EnchantProviderDict* _tmp7_;
	DictRemoveFromSession _tmp8_;
#line 208 "dict.vala"
	g_return_if_fail (self != NULL);
#line 208 "dict.vala"
	g_return_if_fail (word_buf != NULL);
#line 209 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 209 "dict.vala"
	word = _tmp0_;
#line 210 "dict.vala"
	_tmp1_ = word;
#line 210 "dict.vala"
	if (_tmp1_ == NULL) {
#line 211 "dict.vala"
		_g_free0 (word);
#line 211 "dict.vala"
		return;
#line 1467 "dict.c"
	}
#line 212 "dict.vala"
	enchant_dict_clear_error (self);
#line 213 "dict.vala"
	_tmp2_ = self->session_include;
#line 213 "dict.vala"
	_tmp3_ = word;
#line 213 "dict.vala"
	g_hash_table_remove (_tmp2_, _tmp3_);
#line 214 "dict.vala"
	_tmp4_ = self->session_exclude;
#line 214 "dict.vala"
	_tmp5_ = word;
#line 214 "dict.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 214 "dict.vala"
	g_hash_table_add (_tmp4_, _tmp6_);
#line 215 "dict.vala"
	_tmp7_ = self->priv->dict;
#line 215 "dict.vala"
	_tmp8_ = _tmp7_->remove_from_session_method;
#line 215 "dict.vala"
	if (_tmp8_ != NULL) {
#line 1491 "dict.c"
		EnchantProviderDict* _tmp9_;
		DictRemoveFromSession _tmp10_;
		EnchantProviderDict* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
#line 216 "dict.vala"
		_tmp9_ = self->priv->dict;
#line 216 "dict.vala"
		_tmp10_ = _tmp9_->remove_from_session_method;
#line 216 "dict.vala"
		_tmp11_ = self->priv->dict;
#line 216 "dict.vala"
		_tmp12_ = word;
#line 216 "dict.vala"
		_tmp13_ = word;
#line 216 "dict.vala"
		_tmp14_ = strlen (_tmp13_);
#line 216 "dict.vala"
		_tmp15_ = _tmp14_;
#line 216 "dict.vala"
		_tmp10_ (_tmp11_, _tmp12_, (size_t) _tmp15_);
#line 1515 "dict.c"
	}
#line 208 "dict.vala"
	_g_free0 (word);
#line 1519 "dict.c"
}

gint
enchant_dict_is_removed (EnchantDict* self,
                         const gchar* word_buf,
                         ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	const gchar* _tmp3_;
	gint result;
#line 219 "dict.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 219 "dict.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 220 "dict.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 220 "dict.vala"
	word = _tmp0_;
#line 221 "dict.vala"
	_tmp1_ = word;
#line 221 "dict.vala"
	if (_tmp1_ == NULL) {
#line 222 "dict.vala"
		result = 0;
#line 222 "dict.vala"
		_g_free0 (word);
#line 222 "dict.vala"
		return result;
#line 1551 "dict.c"
	}
#line 223 "dict.vala"
	enchant_dict_clear_error (self);
#line 224 "dict.vala"
	_tmp3_ = word;
#line 224 "dict.vala"
	if (enchant_dict_excluded (self, _tmp3_)) {
#line 224 "dict.vala"
		_tmp2_ = 1;
#line 1561 "dict.c"
	} else {
#line 224 "dict.vala"
		_tmp2_ = 0;
#line 1565 "dict.c"
	}
#line 224 "dict.vala"
	result = _tmp2_;
#line 224 "dict.vala"
	_g_free0 (word);
#line 224 "dict.vala"
	return result;
#line 1573 "dict.c"
}

void
enchant_dict_store_replacement (EnchantDict* self,
                                const gchar* mis,
                                ssize_t mis_len,
                                const gchar* cor,
                                ssize_t cor_len)
{
#line 228 "dict.vala"
	g_return_if_fail (self != NULL);
#line 228 "dict.vala"
	g_return_if_fail (mis != NULL);
#line 228 "dict.vala"
	g_return_if_fail (cor != NULL);
#line 1589 "dict.c"
}

void
enchant_dict_free_string_list (EnchantDict* self,
                               gchar** string_list)
{
	gchar** _tmp0_;
#line 231 "dict.vala"
	g_return_if_fail (self != NULL);
#line 232 "dict.vala"
	enchant_dict_clear_error (self);
#line 233 "dict.vala"
	_tmp0_ = string_list;
#line 233 "dict.vala"
	string_list = NULL;
#line 233 "dict.vala"
	g_strfreev ((gchar**) _tmp0_);
#line 1607 "dict.c"
}

void
enchant_dict_describe (EnchantDict* self,
                       EnchantDictDescribeFn fn,
                       void* user_data)
{
	gchar* name = NULL;
	gchar* desc = NULL;
	gchar* file = NULL;
	EnchantProviderDict* _tmp0_;
	EnchantProvider* _tmp1_;
	EnchantProviderDict* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
#line 236 "dict.vala"
	g_return_if_fail (self != NULL);
#line 236 "dict.vala"
	_vala_return_if_fail (fn != NULL, "fn != null");
#line 239 "dict.vala"
	enchant_dict_clear_error (self);
#line 244 "dict.vala"
	_tmp0_ = self->priv->dict;
#line 244 "dict.vala"
	_tmp1_ = _tmp0_->provider;
#line 244 "dict.vala"
	if (_tmp1_ != NULL) {
#line 1637 "dict.c"
		EnchantProviderDict* _tmp2_;
		EnchantProvider* _tmp3_;
		GModule* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		EnchantProviderDict* _tmp7_;
		EnchantProvider* _tmp8_;
		ProviderIdentify _tmp9_;
		EnchantProviderDict* _tmp10_;
		EnchantProvider* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		EnchantProviderDict* _tmp14_;
		EnchantProvider* _tmp15_;
		ProviderDescribe _tmp16_;
		EnchantProviderDict* _tmp17_;
		EnchantProvider* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
#line 245 "dict.vala"
		_tmp2_ = self->priv->dict;
#line 245 "dict.vala"
		_tmp3_ = _tmp2_->provider;
#line 245 "dict.vala"
		_tmp4_ = _tmp3_->module;
#line 245 "dict.vala"
		_tmp5_ = g_module_name (_tmp4_);
#line 245 "dict.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 245 "dict.vala"
		_g_free0 (file);
#line 245 "dict.vala"
		file = _tmp6_;
#line 246 "dict.vala"
		_tmp7_ = self->priv->dict;
#line 246 "dict.vala"
		_tmp8_ = _tmp7_->provider;
#line 246 "dict.vala"
		_tmp9_ = _tmp8_->identify;
#line 246 "dict.vala"
		_tmp10_ = self->priv->dict;
#line 246 "dict.vala"
		_tmp11_ = _tmp10_->provider;
#line 246 "dict.vala"
		_tmp12_ = _tmp9_ (_tmp11_);
#line 246 "dict.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 246 "dict.vala"
		_g_free0 (name);
#line 246 "dict.vala"
		name = _tmp13_;
#line 247 "dict.vala"
		_tmp14_ = self->priv->dict;
#line 247 "dict.vala"
		_tmp15_ = _tmp14_->provider;
#line 247 "dict.vala"
		_tmp16_ = _tmp15_->describe;
#line 247 "dict.vala"
		_tmp17_ = self->priv->dict;
#line 247 "dict.vala"
		_tmp18_ = _tmp17_->provider;
#line 247 "dict.vala"
		_tmp19_ = _tmp16_ (_tmp18_);
#line 247 "dict.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 247 "dict.vala"
		_g_free0 (desc);
#line 247 "dict.vala"
		desc = _tmp20_;
#line 1707 "dict.c"
	} else {
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 249 "dict.vala"
		_tmp21_ = self->personal_filename;
#line 249 "dict.vala"
		_tmp22_ = g_strdup (_tmp21_);
#line 249 "dict.vala"
		_g_free0 (file);
#line 249 "dict.vala"
		file = _tmp22_;
#line 250 "dict.vala"
		_tmp23_ = g_strdup ("Personal Wordlist");
#line 250 "dict.vala"
		_g_free0 (name);
#line 250 "dict.vala"
		name = _tmp23_;
#line 251 "dict.vala"
		_tmp24_ = g_strdup ("Personal Wordlist");
#line 251 "dict.vala"
		_g_free0 (desc);
#line 251 "dict.vala"
		desc = _tmp24_;
#line 1733 "dict.c"
	}
#line 254 "dict.vala"
	_tmp25_ = self->priv->dict;
#line 254 "dict.vala"
	_tmp26_ = _tmp25_->language_tag;
#line 254 "dict.vala"
	_tmp27_ = name;
#line 254 "dict.vala"
	_tmp28_ = desc;
#line 254 "dict.vala"
	_tmp29_ = file;
#line 254 "dict.vala"
	fn (_tmp26_, _tmp27_, _tmp28_, _tmp29_, user_data);
#line 236 "dict.vala"
	_g_free0 (file);
#line 236 "dict.vala"
	_g_free0 (desc);
#line 236 "dict.vala"
	_g_free0 (name);
#line 1753 "dict.c"
}

void
enchant_dict_set_error (EnchantDict* self,
                        const gchar* err)
{
	EnchantProviderDict* _tmp0_;
#line 258 "dict.vala"
	g_return_if_fail (self != NULL);
#line 258 "dict.vala"
	g_return_if_fail (err != NULL);
#line 259 "dict.vala"
	_tmp0_ = self->priv->dict;
#line 259 "dict.vala"
	enchant_provider_dict_set_error (_tmp0_, err);
#line 1769 "dict.c"
}

const gchar*
enchant_dict_get_error (EnchantDict* self)
{
	EnchantProviderDict* _tmp0_;
	const gchar* _tmp1_;
	const gchar* result;
#line 262 "dict.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 263 "dict.vala"
	_tmp0_ = self->priv->dict;
#line 263 "dict.vala"
	_tmp1_ = _tmp0_->error;
#line 263 "dict.vala"
	result = _tmp1_;
#line 263 "dict.vala"
	return result;
#line 1788 "dict.c"
}

void
enchant_dict_clear_error (EnchantDict* self)
{
	EnchantProviderDict* _tmp0_;
#line 266 "dict.vala"
	g_return_if_fail (self != NULL);
#line 267 "dict.vala"
	_tmp0_ = self->priv->dict;
#line 267 "dict.vala"
	if (_tmp0_ != NULL) {
#line 1801 "dict.c"
		EnchantProviderDict* _tmp1_;
#line 268 "dict.vala"
		_tmp1_ = self->priv->dict;
#line 268 "dict.vala"
		_g_free0 (_tmp1_->error);
#line 268 "dict.vala"
		_tmp1_->error = NULL;
#line 1809 "dict.c"
	}
}

static void
value_enchant_dict_init (GValue* value)
{
#line 31 "dict.vala"
	value->data[0].v_pointer = NULL;
#line 1818 "dict.c"
}

static void
value_enchant_dict_free_value (GValue* value)
{
#line 31 "dict.vala"
	if (value->data[0].v_pointer) {
#line 31 "dict.vala"
		enchant_dict_unref (value->data[0].v_pointer);
#line 1828 "dict.c"
	}
}

static void
value_enchant_dict_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
#line 31 "dict.vala"
	if (src_value->data[0].v_pointer) {
#line 31 "dict.vala"
		dest_value->data[0].v_pointer = enchant_dict_ref (src_value->data[0].v_pointer);
#line 1840 "dict.c"
	} else {
#line 31 "dict.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1844 "dict.c"
	}
}

static gpointer
value_enchant_dict_peek_pointer (const GValue* value)
{
#line 31 "dict.vala"
	return value->data[0].v_pointer;
#line 1853 "dict.c"
}

static gchar*
value_enchant_dict_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
#line 31 "dict.vala"
	if (collect_values[0].v_pointer) {
#line 1864 "dict.c"
		EnchantDict * object;
		object = collect_values[0].v_pointer;
#line 31 "dict.vala"
		if (object->parent_instance.g_class == NULL) {
#line 31 "dict.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1871 "dict.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 31 "dict.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1875 "dict.c"
		}
#line 31 "dict.vala"
		value->data[0].v_pointer = enchant_dict_ref (object);
#line 1879 "dict.c"
	} else {
#line 31 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1883 "dict.c"
	}
#line 31 "dict.vala"
	return NULL;
#line 1887 "dict.c"
}

static gchar*
value_enchant_dict_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	EnchantDict ** object_p;
	object_p = collect_values[0].v_pointer;
#line 31 "dict.vala"
	if (!object_p) {
#line 31 "dict.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1902 "dict.c"
	}
#line 31 "dict.vala"
	if (!value->data[0].v_pointer) {
#line 31 "dict.vala"
		*object_p = NULL;
#line 1908 "dict.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 31 "dict.vala"
		*object_p = value->data[0].v_pointer;
#line 1912 "dict.c"
	} else {
#line 31 "dict.vala"
		*object_p = enchant_dict_ref (value->data[0].v_pointer);
#line 1916 "dict.c"
	}
#line 31 "dict.vala"
	return NULL;
#line 1920 "dict.c"
}

GParamSpec*
param_spec_enchant_dict (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecEnchantDict* spec;
#line 31 "dict.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_DICT), NULL);
#line 31 "dict.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 31 "dict.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 31 "dict.vala"
	return G_PARAM_SPEC (spec);
#line 1939 "dict.c"
}

gpointer
value_get_enchant_dict (const GValue* value)
{
#line 31 "dict.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT), NULL);
#line 31 "dict.vala"
	return value->data[0].v_pointer;
#line 1949 "dict.c"
}

void
value_set_enchant_dict (GValue* value,
                        gpointer v_object)
{
	EnchantDict * old;
#line 31 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 31 "dict.vala"
	old = value->data[0].v_pointer;
#line 31 "dict.vala"
	if (v_object) {
#line 31 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 31 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 31 "dict.vala"
		enchant_dict_ref (value->data[0].v_pointer);
#line 1971 "dict.c"
	} else {
#line 31 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 1975 "dict.c"
	}
#line 31 "dict.vala"
	if (old) {
#line 31 "dict.vala"
		enchant_dict_unref (old);
#line 1981 "dict.c"
	}
}

void
value_take_enchant_dict (GValue* value,
                         gpointer v_object)
{
	EnchantDict * old;
#line 31 "dict.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_DICT));
#line 31 "dict.vala"
	old = value->data[0].v_pointer;
#line 31 "dict.vala"
	if (v_object) {
#line 31 "dict.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_DICT));
#line 31 "dict.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 31 "dict.vala"
		value->data[0].v_pointer = v_object;
#line 2002 "dict.c"
	} else {
#line 31 "dict.vala"
		value->data[0].v_pointer = NULL;
#line 2006 "dict.c"
	}
#line 31 "dict.vala"
	if (old) {
#line 31 "dict.vala"
		enchant_dict_unref (old);
#line 2012 "dict.c"
	}
}

static void
enchant_dict_class_init (EnchantDictClass * klass,
                         gpointer klass_data)
{
#line 31 "dict.vala"
	enchant_dict_parent_class = g_type_class_peek_parent (klass);
#line 31 "dict.vala"
	((EnchantDictClass *) klass)->finalize = enchant_dict_finalize;
#line 31 "dict.vala"
	g_type_class_adjust_private_offset (klass, &EnchantDict_private_offset);
#line 2026 "dict.c"
}

static void
enchant_dict_instance_init (EnchantDict * self,
                            gpointer klass)
{
#line 31 "dict.vala"
	self->priv = enchant_dict_get_instance_private (self);
#line 31 "dict.vala"
	self->ref_count = 1;
#line 2037 "dict.c"
}

static void
enchant_dict_finalize (EnchantDict * obj)
{
	EnchantDict * self;
#line 31 "dict.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_DICT, EnchantDict);
#line 31 "dict.vala"
	g_signal_handlers_destroy (self);
#line 32 "dict.vala"
	_g_hash_table_unref0 (self->session_include);
#line 33 "dict.vala"
	_g_hash_table_unref0 (self->session_exclude);
#line 34 "dict.vala"
	_enchant_pwl_unref0 (self->pwl);
#line 35 "dict.vala"
	_enchant_pwl_unref0 (self->exclude_pwl);
#line 36 "dict.vala"
	_enchant_provider_dict_unref0 (self->priv->dict);
#line 38 "dict.vala"
	_g_free0 (self->personal_filename);
#line 39 "dict.vala"
	_g_free0 (self->exclude_filename);
#line 2062 "dict.c"
}

static GType
enchant_dict_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_dict_init, value_enchant_dict_free_value, value_enchant_dict_copy_value, value_enchant_dict_peek_pointer, "p", value_enchant_dict_collect_value, "p", value_enchant_dict_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantDictClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_dict_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantDict), 0, (GInstanceInitFunc) enchant_dict_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_dict_type_id;
	enchant_dict_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantDict", &g_define_type_info, &g_define_type_fundamental_info, 0);
	EnchantDict_private_offset = g_type_add_instance_private (enchant_dict_type_id, sizeof (EnchantDictPrivate));
	return enchant_dict_type_id;
}

GType
enchant_dict_get_type (void)
{
	static volatile gsize enchant_dict_type_id__once = 0;
	if (g_once_init_enter (&enchant_dict_type_id__once)) {
		GType enchant_dict_type_id;
		enchant_dict_type_id = enchant_dict_get_type_once ();
		g_once_init_leave (&enchant_dict_type_id__once, enchant_dict_type_id);
	}
	return enchant_dict_type_id__once;
}

gpointer
enchant_dict_ref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 31 "dict.vala"
	g_atomic_int_inc (&self->ref_count);
#line 31 "dict.vala"
	return instance;
#line 2098 "dict.c"
}

void
enchant_dict_unref (gpointer instance)
{
	EnchantDict * self;
	self = instance;
#line 31 "dict.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 31 "dict.vala"
		ENCHANT_DICT_GET_CLASS (self)->finalize (self);
#line 31 "dict.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2112 "dict.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

