/* OperationLauncher.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from OperationLauncher.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */
/* All the similar Operation* classes can be a little confusing.*/
/* Here's a breakdown.*/
/**/
/* OperationLauncher:*/
/* - singleton, GUI side*/
/* - How new operations get started, makes sure there's only one active*/
/* - Handles some global GUI business like opening a URL, inhibiting, and*/
/*   many desktop notifications (others are handled by DejaDupApp)*/
/**/
/* OperationWrapper:*/
/* - multi-instance, GUI side*/
/* - Consolidates all of an operation's interactions into a few properties*/
/*   and signals that are easier for GUIs to bind to (i.e. a label and button)*/
/* - Used by things like OperationBanner*/
/**/
/* OperationBanner:*/
/* - multi-instance, GUI side*/
/* - Connects to the global OperationWatcher*/
/**/
/* OperationStatusPage:*/
/* - multi-instance, GUI side*/
/* - Connects to a single operation*/
/**/
/* OperationWatcher:*/
/* - singleton, library side*/
/* - Is an abstraction for "the currently running operation" without having*/
/*   to disconnect and reconnect to an operation*/
/* - Only watches "important" operations like backup/restore, not list*/
/*   operations*/
/* - Used by OperationBanner*/
/**/
/* Operation:*/
/* - multi-instance, library side*/
/* - Parent class of the various OperationBackup, OperationRestore, etc*/

#include <glib-object.h>
#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_OPERATION_LAUNCHER (operation_launcher_get_type ())
#define OPERATION_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OPERATION_LAUNCHER, OperationLauncher))
#define OPERATION_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OPERATION_LAUNCHER, OperationLauncherClass))
#define IS_OPERATION_LAUNCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OPERATION_LAUNCHER))
#define IS_OPERATION_LAUNCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OPERATION_LAUNCHER))
#define OPERATION_LAUNCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OPERATION_LAUNCHER, OperationLauncherClass))

typedef struct _OperationLauncher OperationLauncher;
typedef struct _OperationLauncherClass OperationLauncherClass;
typedef struct _OperationLauncherPrivate OperationLauncherPrivate;

#define TYPE_OPERATION_WRAPPER (operation_wrapper_get_type ())
#define OPERATION_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OPERATION_WRAPPER, OperationWrapper))
#define OPERATION_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OPERATION_WRAPPER, OperationWrapperClass))
#define IS_OPERATION_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OPERATION_WRAPPER))
#define IS_OPERATION_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OPERATION_WRAPPER))
#define OPERATION_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OPERATION_WRAPPER, OperationWrapperClass))

typedef struct _OperationWrapper OperationWrapper;
typedef struct _OperationWrapperClass OperationWrapperClass;
enum  {
	OPERATION_LAUNCHER_0_PROPERTY,
	OPERATION_LAUNCHER_NUM_PROPERTIES
};
static GParamSpec* operation_launcher_properties[OPERATION_LAUNCHER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DEJA_DUP_APP (deja_dup_app_get_type ())
#define DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEJA_DUP_APP, DejaDupApp))
#define DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEJA_DUP_APP, DejaDupAppClass))
#define IS_DEJA_DUP_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEJA_DUP_APP))
#define IS_DEJA_DUP_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEJA_DUP_APP))
#define DEJA_DUP_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEJA_DUP_APP, DejaDupAppClass))

typedef struct _DejaDupApp DejaDupApp;
typedef struct _DejaDupAppClass DejaDupAppClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _OperationLauncherHandleOpenUrlAsyncData OperationLauncherHandleOpenUrlAsyncData;

struct _OperationLauncher {
	GObject parent_instance;
	OperationLauncherPrivate * priv;
	DejaDupOperation* operation;
	OperationWrapper* wrapper;
};

struct _OperationLauncherClass {
	GObjectClass parent_class;
};

struct _OperationLauncherPrivate {
	guint inhibit_id;
};

struct _OperationLauncherHandleOpenUrlAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OperationLauncher* self;
	gchar* url;
	GtkUriLauncher* launcher;
	GtkUriLauncher* _tmp0_;
	DejaDupApp* app;
	DejaDupApp* _tmp1_;
	MainWindow* _tmp2_;
	MainWindow* _tmp3_;
	GError* e;
	MainWindow* _tmp4_;
	MainWindow* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

static gint OperationLauncher_private_offset;
static gpointer operation_launcher_parent_class = NULL;
static OperationLauncher* operation_launcher_instance;
static OperationLauncher* operation_launcher_instance = NULL;

VALA_EXTERN GType operation_launcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OperationLauncher, g_object_unref)
VALA_EXTERN GType operation_wrapper_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OperationWrapper, g_object_unref)
VALA_EXTERN OperationLauncher* operation_launcher_get_instance (void);
VALA_EXTERN OperationLauncher* operation_launcher_new (void);
VALA_EXTERN OperationLauncher* operation_launcher_construct (GType object_type);
VALA_EXTERN void operation_launcher_start_backup (OperationLauncher* self,
                                      gboolean automatic);
static gboolean operation_launcher_stop_op_if_dormant (OperationLauncher* self);
VALA_EXTERN GType deja_dup_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DejaDupApp, g_object_unref)
VALA_EXTERN DejaDupApp* deja_dup_app_get_instance (void);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* deja_dup_app_get_app_window (DejaDupApp* self);
VALA_EXTERN void main_window_add_toast (MainWindow* self,
                            const gchar* message);
static void operation_launcher_connect_op (OperationLauncher* self,
                                    gboolean primary_operation);
static void operation_launcher_inhibit (OperationLauncher* self,
                                 gboolean automatic);
VALA_EXTERN void notifications_automatic_backup_started (void);
VALA_EXTERN void operation_launcher_start_restore (OperationLauncher* self,
                                       DejaDupOperationState* state,
                                       const gchar* restore_location,
                                       DejaDupFileTree* tree,
                                       const gchar* tag,
                                       GList* files);
VALA_EXTERN DejaDupOperationStatus* operation_launcher_create_list_snapshots (OperationLauncher* self,
                                                                  DejaDupBackend* backend,
                                                                  GError** error);
VALA_EXTERN DejaDupOperationFiles* operation_launcher_create_list_files (OperationLauncher* self,
                                                             const gchar* tag,
                                                             DejaDupOperationState* state,
                                                             GError** error);
static void operation_launcher_handle_done (OperationLauncher* self,
                                     OperationWrapper* signal_wrapper,
                                     gboolean cancelled);
static void operation_launcher_handle_open_url (OperationLauncher* self,
                                         const gchar* url);
static void _operation_launcher_handle_open_url_deja_dup_operation_open_url (DejaDupOperation* _sender,
                                                                      const gchar* url,
                                                                      gpointer self);
VALA_EXTERN OperationWrapper* operation_wrapper_new (DejaDupOperation* operation,
                                         GtkWidget* parent);
VALA_EXTERN OperationWrapper* operation_wrapper_construct (GType object_type,
                                               DejaDupOperation* operation,
                                               GtkWidget* parent);
VALA_EXTERN void operation_wrapper_set_cancel_stops (OperationWrapper* self,
                                         gboolean value);
static void _operation_launcher_handle_done_operation_wrapper_done (OperationWrapper* _sender,
                                                             gboolean cancelled,
                                                             gpointer self);
static void operation_launcher_handle_attention_needed (OperationLauncher* self,
                                                 gboolean needs_input);
static void _operation_launcher_handle_attention_needed_operation_wrapper_attention_needed (OperationWrapper* _sender,
                                                                                     gboolean needs_input,
                                                                                     gpointer self);
static void operation_launcher_handle_pause_changed (OperationLauncher* self,
                                              gboolean paused);
static void _operation_launcher_handle_pause_changed_operation_wrapper_pause_changed (OperationWrapper* _sender,
                                                                               gboolean paused,
                                                                               gpointer self);
static void operation_launcher_handle_succeeded (OperationLauncher* self,
                                          gboolean incomplete);
static void _operation_launcher_handle_succeeded_operation_wrapper_succeeded (OperationWrapper* _sender,
                                                                       gboolean incomplete,
                                                                       gpointer self);
VALA_EXTERN DejaDupOperation* operation_wrapper_get_operation (OperationWrapper* self);
VALA_EXTERN void notifications_withdraw (void);
static void operation_launcher_uninhibit (OperationLauncher* self);
static void operation_launcher_handle_open_url_async (OperationLauncher* self,
                                               const gchar* url,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void operation_launcher_handle_open_url_finish (OperationLauncher* self,
                                                GAsyncResult* _res_);
static void operation_launcher_handle_open_url_async_data_free (gpointer _data);
static gboolean operation_launcher_handle_open_url_async_co (OperationLauncherHandleOpenUrlAsyncData* _data_);
static void operation_launcher_handle_open_url_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
VALA_EXTERN void deja_dup_run_error_dialog (GtkWidget* parent,
                                const gchar* header,
                                const gchar* message,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN void deja_dup_run_error_dialog_finish (GAsyncResult* _res_);
VALA_EXTERN gboolean deja_dup_app_is_focused (DejaDupApp* self);
VALA_EXTERN void operation_wrapper_auto_click (OperationWrapper* self);
VALA_EXTERN void notifications_attention_needed (GtkWidget* parent,
                                     const gchar* title,
                                     const gchar* body);
VALA_EXTERN const gchar* operation_wrapper_get_summary (OperationWrapper* self);
VALA_EXTERN void notifications_operation_blocked (const gchar* title,
                                      const gchar* body);
VALA_EXTERN void notifications_operation_succeeded (const gchar* title,
                                        const gchar* body,
                                        gboolean important);
static void operation_launcher_finalize (GObject * obj);
static GType operation_launcher_get_type_once (void);

static inline gpointer
operation_launcher_get_instance_private (OperationLauncher* self)
{
	return G_STRUCT_MEMBER_P (self, OperationLauncher_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

OperationLauncher*
operation_launcher_get_instance (void)
{
	OperationLauncher* _tmp0_;
	OperationLauncher* _tmp2_;
	OperationLauncher* _tmp3_;
	OperationLauncher* result;
	_tmp0_ = operation_launcher_instance;
	if (_tmp0_ == NULL) {
		OperationLauncher* _tmp1_;
		_tmp1_ = operation_launcher_new ();
		_g_object_unref0 (operation_launcher_instance);
		operation_launcher_instance = _tmp1_;
	}
	_tmp2_ = operation_launcher_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
operation_launcher_start_backup (OperationLauncher* self,
                                 gboolean automatic)
{
	DejaDupBackend* _tmp6_;
	DejaDupBackend* _tmp7_;
	DejaDupOperationBackup* _tmp8_;
	DejaDupOperation* _tmp9_;
	g_return_if_fail (self != NULL);
	if (!operation_launcher_stop_op_if_dormant (self)) {
		gchar* msg = NULL;
		gchar* _tmp0_;
		DejaDupApp* _tmp1_;
		DejaDupApp* _tmp2_;
		MainWindow* _tmp3_;
		MainWindow* _tmp4_;
		const gchar* _tmp5_;
		_tmp0_ = g_strdup (_ ("Failed to start backup; there's already an ongoing operation"));
		msg = _tmp0_;
		_tmp1_ = deja_dup_app_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = deja_dup_app_get_app_window (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = msg;
		main_window_add_toast (_tmp4_, _tmp5_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
		_g_free0 (msg);
		return;
	}
	_tmp6_ = deja_dup_backend_get_default ();
	_tmp7_ = _tmp6_;
	_tmp8_ = deja_dup_operation_backup_new (_tmp7_, automatic);
	_g_object_unref0 (self->operation);
	self->operation = (DejaDupOperation*) _tmp8_;
	_g_object_unref0 (_tmp7_);
	operation_launcher_connect_op (self, TRUE);
	operation_launcher_inhibit (self, automatic);
	_tmp9_ = self->operation;
	deja_dup_operation_start (_tmp9_, NULL, NULL);
	if (automatic) {
		notifications_automatic_backup_started ();
	}
}

void
operation_launcher_start_restore (OperationLauncher* self,
                                  DejaDupOperationState* state,
                                  const gchar* restore_location,
                                  DejaDupFileTree* tree,
                                  const gchar* tag,
                                  GList* files)
{
	DejaDupBackend* _tmp6_;
	DejaDupOperationRestore* _tmp7_;
	DejaDupOperation* _tmp8_;
	DejaDupOperation* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	g_return_if_fail (restore_location != NULL);
	g_return_if_fail (tree != NULL);
	g_return_if_fail (tag != NULL);
	if (!operation_launcher_stop_op_if_dormant (self)) {
		gchar* msg = NULL;
		gchar* _tmp0_;
		DejaDupApp* _tmp1_;
		DejaDupApp* _tmp2_;
		MainWindow* _tmp3_;
		MainWindow* _tmp4_;
		const gchar* _tmp5_;
		_tmp0_ = g_strdup (_ ("Failed to restore; there's already an ongoing operation"));
		msg = _tmp0_;
		_tmp1_ = deja_dup_app_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = deja_dup_app_get_app_window (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = msg;
		main_window_add_toast (_tmp4_, _tmp5_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
		_g_free0 (msg);
		return;
	}
	_tmp6_ = state->backend;
	_tmp7_ = deja_dup_operation_restore_new (_tmp6_, restore_location, tree, tag, files);
	_g_object_unref0 (self->operation);
	self->operation = (DejaDupOperation*) _tmp7_;
	_tmp8_ = self->operation;
	deja_dup_operation_set_state (_tmp8_, state);
	operation_launcher_connect_op (self, TRUE);
	operation_launcher_inhibit (self, FALSE);
	_tmp9_ = self->operation;
	deja_dup_operation_start (_tmp9_, NULL, NULL);
}

DejaDupOperationStatus*
operation_launcher_create_list_snapshots (OperationLauncher* self,
                                          DejaDupBackend* backend,
                                          GError** error)
{
	DejaDupBackend* op_backend = NULL;
	DejaDupBackend* _tmp1_;
	DejaDupBackend* _tmp2_;
	DejaDupBackend* _tmp4_;
	DejaDupOperationStatus* _tmp5_;
	DejaDupOperation* _tmp6_;
	DejaDupOperationStatus* _tmp7_;
	GError* _inner_error0_ = NULL;
	DejaDupOperationStatus* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (!operation_launcher_stop_op_if_dormant (self)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _ ("There's already an ongoing operation"));
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = _g_object_ref0 (backend);
	op_backend = _tmp1_;
	_tmp2_ = op_backend;
	if (_tmp2_ == NULL) {
		DejaDupBackend* _tmp3_;
		_tmp3_ = deja_dup_backend_get_default ();
		_g_object_unref0 (op_backend);
		op_backend = _tmp3_;
	}
	_tmp4_ = op_backend;
	_tmp5_ = deja_dup_operation_status_new (_tmp4_);
	_g_object_unref0 (self->operation);
	self->operation = (DejaDupOperation*) _tmp5_;
	operation_launcher_connect_op (self, FALSE);
	_tmp6_ = self->operation;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, DEJA_DUP_TYPE_OPERATION_STATUS, DejaDupOperationStatus));
	result = _tmp7_;
	_g_object_unref0 (op_backend);
	return result;
}

DejaDupOperationFiles*
operation_launcher_create_list_files (OperationLauncher* self,
                                      const gchar* tag,
                                      DejaDupOperationState* state,
                                      GError** error)
{
	DejaDupBackend* backend = NULL;
	DejaDupBackend* _tmp4_;
	DejaDupOperationFiles* _tmp5_;
	DejaDupOperation* _tmp7_;
	DejaDupOperationFiles* _tmp8_;
	GError* _inner_error0_ = NULL;
	DejaDupOperationFiles* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	if (!operation_launcher_stop_op_if_dormant (self)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _ ("There's already an ongoing operation"));
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (state != NULL) {
		DejaDupBackend* _tmp1_;
		DejaDupBackend* _tmp2_;
		_tmp1_ = state->backend;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (backend);
		backend = _tmp2_;
	} else {
		DejaDupBackend* _tmp3_;
		_tmp3_ = deja_dup_backend_get_default ();
		_g_object_unref0 (backend);
		backend = _tmp3_;
	}
	_tmp4_ = backend;
	_tmp5_ = deja_dup_operation_files_new (_tmp4_, tag, NULL);
	_g_object_unref0 (self->operation);
	self->operation = (DejaDupOperation*) _tmp5_;
	if (state != NULL) {
		DejaDupOperation* _tmp6_;
		_tmp6_ = self->operation;
		deja_dup_operation_set_state (_tmp6_, state);
	}
	operation_launcher_connect_op (self, FALSE);
	_tmp7_ = self->operation;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, DEJA_DUP_TYPE_OPERATION_FILES, DejaDupOperationFiles));
	result = _tmp8_;
	_g_object_unref0 (backend);
	return result;
}

static gboolean
operation_launcher_stop_op_if_dormant (OperationLauncher* self)
{
	DejaDupOperation* _tmp0_;
	DejaDupOperation* _tmp1_;
	OperationWrapper* _tmp2_;
	DejaDupApp* app = NULL;
	DejaDupApp* _tmp3_;
	MainWindow* window = NULL;
	DejaDupApp* _tmp4_;
	MainWindow* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->operation;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->operation;
	if (!deja_dup_operation_stop_if_dormant (_tmp1_)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->wrapper;
	operation_launcher_handle_done (self, _tmp2_, TRUE);
	_tmp3_ = deja_dup_app_get_instance ();
	app = _tmp3_;
	_tmp4_ = app;
	_tmp5_ = deja_dup_app_get_app_window (_tmp4_);
	window = _tmp5_;
	while (TRUE) {
		MainWindow* _tmp6_;
		AdwDialog* _tmp7_;
		AdwDialog* _tmp8_;
		MainWindow* _tmp9_;
		AdwDialog* _tmp10_;
		AdwDialog* _tmp11_;
		_tmp6_ = window;
		_tmp7_ = adw_application_window_get_visible_dialog ((AdwApplicationWindow*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (!((G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, adw_alert_dialog_get_type ()) ? ((AdwAlertDialog*) _tmp8_) : NULL) != NULL)) {
			break;
		}
		_tmp9_ = window;
		_tmp10_ = adw_application_window_get_visible_dialog ((AdwApplicationWindow*) _tmp9_);
		_tmp11_ = _tmp10_;
		adw_dialog_close (_tmp11_);
	}
	result = TRUE;
	_g_object_unref0 (window);
	_g_object_unref0 (app);
	return result;
}

static void
_operation_launcher_handle_open_url_deja_dup_operation_open_url (DejaDupOperation* _sender,
                                                                 const gchar* url,
                                                                 gpointer self)
{
	operation_launcher_handle_open_url ((OperationLauncher*) self, url);
}

static void
_operation_launcher_handle_done_operation_wrapper_done (OperationWrapper* _sender,
                                                        gboolean cancelled,
                                                        gpointer self)
{
	operation_launcher_handle_done ((OperationLauncher*) self, _sender, cancelled);
}

static void
_operation_launcher_handle_attention_needed_operation_wrapper_attention_needed (OperationWrapper* _sender,
                                                                                gboolean needs_input,
                                                                                gpointer self)
{
	operation_launcher_handle_attention_needed ((OperationLauncher*) self, needs_input);
}

static void
_operation_launcher_handle_pause_changed_operation_wrapper_pause_changed (OperationWrapper* _sender,
                                                                          gboolean paused,
                                                                          gpointer self)
{
	operation_launcher_handle_pause_changed ((OperationLauncher*) self, paused);
}

static void
_operation_launcher_handle_succeeded_operation_wrapper_succeeded (OperationWrapper* _sender,
                                                                  gboolean incomplete,
                                                                  gpointer self)
{
	operation_launcher_handle_succeeded ((OperationLauncher*) self, incomplete);
}

static void
operation_launcher_connect_op (OperationLauncher* self,
                               gboolean primary_operation)
{
	DejaDupOperation* _tmp3_;
	DejaDupOperation* _tmp4_;
	DejaDupApp* _tmp5_;
	DejaDupApp* _tmp6_;
	MainWindow* _tmp7_;
	MainWindow* _tmp8_;
	OperationWrapper* _tmp9_;
	OperationWrapper* _tmp10_;
	OperationWrapper* _tmp11_;
	OperationWrapper* _tmp12_;
	OperationWrapper* _tmp13_;
	OperationWrapper* _tmp14_;
	g_return_if_fail (self != NULL);
	if (primary_operation) {
		DejaDupOperationWatcher* _tmp0_;
		DejaDupOperationWatcher* _tmp1_;
		DejaDupOperation* _tmp2_;
		_tmp0_ = deja_dup_operation_watcher_get_instance ();
		_tmp1_ = _tmp0_;
		_tmp2_ = self->operation;
		deja_dup_operation_watcher_set_current_op (_tmp1_, _tmp2_);
		_g_object_unref0 (_tmp1_);
	}
	_tmp3_ = self->operation;
	g_signal_connect_object (_tmp3_, "open-url", (GCallback) _operation_launcher_handle_open_url_deja_dup_operation_open_url, self, 0);
	_tmp4_ = self->operation;
	_tmp5_ = deja_dup_app_get_instance ();
	_tmp6_ = _tmp5_;
	_tmp7_ = deja_dup_app_get_app_window (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = operation_wrapper_new (_tmp4_, (GtkWidget*) _tmp8_);
	_g_object_unref0 (self->wrapper);
	self->wrapper = _tmp9_;
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp6_);
	_tmp10_ = self->wrapper;
	operation_wrapper_set_cancel_stops (_tmp10_, primary_operation);
	_tmp11_ = self->wrapper;
	g_signal_connect_object (_tmp11_, "done", (GCallback) _operation_launcher_handle_done_operation_wrapper_done, self, 0);
	_tmp12_ = self->wrapper;
	g_signal_connect_object (_tmp12_, "attention-needed", (GCallback) _operation_launcher_handle_attention_needed_operation_wrapper_attention_needed, self, 0);
	_tmp13_ = self->wrapper;
	g_signal_connect_object (_tmp13_, "pause-changed", (GCallback) _operation_launcher_handle_pause_changed_operation_wrapper_pause_changed, self, 0);
	_tmp14_ = self->wrapper;
	g_signal_connect_object (_tmp14_, "succeeded", (GCallback) _operation_launcher_handle_succeeded_operation_wrapper_succeeded, self, 0);
}

static void
operation_launcher_handle_done (OperationLauncher* self,
                                OperationWrapper* signal_wrapper,
                                gboolean cancelled)
{
	DejaDupOperation* _tmp0_;
	DejaDupOperation* _tmp1_;
	DejaDupOperation* _tmp2_;
	DejaDupOperation* _tmp3_;
	OperationWrapper* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (signal_wrapper != NULL);
	_tmp0_ = operation_wrapper_get_operation (signal_wrapper);
	_tmp1_ = _tmp0_;
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	_tmp2_ = operation_wrapper_get_operation (signal_wrapper);
	_tmp3_ = _tmp2_;
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	_tmp4_ = self->wrapper;
	if (signal_wrapper != _tmp4_) {
		return;
	}
	_g_object_unref0 (self->operation);
	self->operation = NULL;
	_g_object_unref0 (self->wrapper);
	self->wrapper = NULL;
	if (cancelled) {
		notifications_withdraw ();
	}
	operation_launcher_uninhibit (self);
}

static void
operation_launcher_handle_open_url (OperationLauncher* self,
                                    const gchar* url)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	operation_launcher_handle_open_url_async (self, url, NULL, NULL);
}

static void
operation_launcher_handle_open_url_async_data_free (gpointer _data)
{
	OperationLauncherHandleOpenUrlAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->url);
	_g_object_unref0 (_data_->self);
	g_slice_free (OperationLauncherHandleOpenUrlAsyncData, _data_);
}

static void
operation_launcher_handle_open_url_async (OperationLauncher* self,
                                          const gchar* url,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	OperationLauncherHandleOpenUrlAsyncData* _data_;
	OperationLauncher* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	_data_ = g_slice_new0 (OperationLauncherHandleOpenUrlAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, operation_launcher_handle_open_url_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (url);
	_g_free0 (_data_->url);
	_data_->url = _tmp1_;
	operation_launcher_handle_open_url_async_co (_data_);
}

static void
operation_launcher_handle_open_url_finish (OperationLauncher* self,
                                           GAsyncResult* _res_)
{
	OperationLauncherHandleOpenUrlAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
operation_launcher_handle_open_url_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	OperationLauncherHandleOpenUrlAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	operation_launcher_handle_open_url_async_co (_data_);
}

static gboolean
operation_launcher_handle_open_url_async_co (OperationLauncherHandleOpenUrlAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gtk_uri_launcher_new (_data_->url);
	_data_->launcher = _data_->_tmp0_;
	_data_->_tmp1_ = deja_dup_app_get_instance ();
	_data_->app = _data_->_tmp1_;
	{
		_data_->_tmp2_ = deja_dup_app_get_app_window (_data_->app);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_state_ = 1;
		gtk_uri_launcher_launch (_data_->launcher, (GtkWindow*) _data_->_tmp3_, NULL, operation_launcher_handle_open_url_async_ready, _data_);
		return FALSE;
		_state_1:
		gtk_uri_launcher_launch_finish (_data_->launcher, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp3_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = deja_dup_app_get_app_window (_data_->app);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		_data_->_state_ = 2;
		deja_dup_run_error_dialog ((GtkWidget*) _data_->_tmp5_, _ ("Failed to Open URL"), _data_->_tmp7_, operation_launcher_handle_open_url_async_ready, _data_);
		return FALSE;
		_state_2:
		deja_dup_run_error_dialog_finish (_data_->_res_);
		_g_object_unref0 (_data_->_tmp5_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->app);
		_g_object_unref0 (_data_->launcher);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->app);
	_g_object_unref0 (_data_->launcher);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
operation_launcher_handle_attention_needed (OperationLauncher* self,
                                            gboolean needs_input)
{
	DejaDupApp* app = NULL;
	DejaDupApp* _tmp0_;
	MainWindow* window = NULL;
	DejaDupApp* _tmp1_;
	MainWindow* _tmp2_;
	DejaDupApp* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_app_get_instance ();
	app = _tmp0_;
	_tmp1_ = app;
	_tmp2_ = deja_dup_app_get_app_window (_tmp1_);
	window = _tmp2_;
	_tmp3_ = app;
	if (deja_dup_app_is_focused (_tmp3_)) {
		MainWindow* _tmp4_;
		AdwDialog* _tmp5_;
		_tmp4_ = window;
		_tmp5_ = adw_application_window_get_visible_dialog ((AdwApplicationWindow*) _tmp4_);
		if (_tmp5_ == NULL) {
			if (needs_input) {
				OperationWrapper* _tmp6_;
				_tmp6_ = self->wrapper;
				operation_wrapper_auto_click (_tmp6_);
			}
		} else {
			MainWindow* _tmp7_;
			OperationWrapper* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp7_ = window;
			_tmp8_ = self->wrapper;
			_tmp9_ = operation_wrapper_get_summary (_tmp8_);
			_tmp10_ = _tmp9_;
			notifications_attention_needed ((GtkWidget*) _tmp7_, _tmp10_, NULL);
		}
	} else {
		OperationWrapper* _tmp11_;
		MainWindow* _tmp12_;
		OperationWrapper* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp11_ = self->wrapper;
		operation_wrapper_auto_click (_tmp11_);
		_tmp12_ = window;
		_tmp13_ = self->wrapper;
		_tmp14_ = operation_wrapper_get_summary (_tmp13_);
		_tmp15_ = _tmp14_;
		notifications_attention_needed ((GtkWidget*) _tmp12_, _tmp15_, NULL);
	}
	_g_object_unref0 (window);
	_g_object_unref0 (app);
}

static void
operation_launcher_handle_pause_changed (OperationLauncher* self,
                                         gboolean paused)
{
	DejaDupApp* app = NULL;
	DejaDupApp* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_app_get_instance ();
	app = _tmp0_;
	if (!paused) {
		notifications_withdraw ();
	} else {
		DejaDupApp* _tmp1_;
		_tmp1_ = app;
		if (!deja_dup_app_is_focused (_tmp1_)) {
			OperationWrapper* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->wrapper;
			_tmp3_ = operation_wrapper_get_summary (_tmp2_);
			_tmp4_ = _tmp3_;
			notifications_operation_blocked (_tmp4_, NULL);
		}
	}
	_g_object_unref0 (app);
}

static void
operation_launcher_handle_succeeded (OperationLauncher* self,
                                     gboolean incomplete)
{
	gboolean _tmp0_ = FALSE;
	DejaDupOperation* _tmp1_;
	DejaDupToolJobMode _tmp2_;
	DejaDupToolJobMode _tmp3_;
	gboolean important = FALSE;
	gchar* header = NULL;
	gchar* body = NULL;
	DejaDupOperation* _tmp4_;
	DejaDupToolJobMode _tmp5_;
	DejaDupToolJobMode _tmp6_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->operation;
	_tmp2_ = deja_dup_operation_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == DEJA_DUP_TOOL_JOB_MODE_RESTORE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = incomplete;
	}
	important = _tmp0_;
	header = NULL;
	body = NULL;
	_tmp4_ = self->operation;
	_tmp5_ = deja_dup_operation_get_mode (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (_ ("Backup completed"));
		_g_free0 (header);
		header = _tmp7_;
		if (incomplete) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("But not all files were successfully backed up"));
			_g_free0 (body);
			body = _tmp8_;
		}
	} else {
		DejaDupOperation* _tmp9_;
		DejaDupToolJobMode _tmp10_;
		DejaDupToolJobMode _tmp11_;
		_tmp9_ = self->operation;
		_tmp10_ = deja_dup_operation_get_mode (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == DEJA_DUP_TOOL_JOB_MODE_RESTORE) {
			gchar* _tmp12_;
			_tmp12_ = g_strdup (_ ("Restore completed"));
			_g_free0 (header);
			header = _tmp12_;
			if (incomplete) {
				gchar* _tmp13_;
				_tmp13_ = g_strdup (_ ("But not all files were successfully restored"));
				_g_free0 (body);
				body = _tmp13_;
			}
		} else {
			_g_free0 (body);
			_g_free0 (header);
			return;
		}
	}
	_tmp14_ = header;
	_tmp15_ = body;
	notifications_operation_succeeded (_tmp14_, _tmp15_, important);
	_g_free0 (body);
	_g_free0 (header);
}

static void
operation_launcher_inhibit (OperationLauncher* self,
                            gboolean automatic)
{
	gchar* message = NULL;
	GtkApplicationInhibitFlags flags = 0U;
	DejaDupOperation* _tmp0_;
	DejaDupToolJobMode _tmp1_;
	DejaDupToolJobMode _tmp2_;
	DejaDupApp* app = NULL;
	DejaDupApp* _tmp8_;
	DejaDupApp* _tmp9_;
	DejaDupApp* _tmp10_;
	DejaDupApp* _tmp11_;
	MainWindow* _tmp12_;
	MainWindow* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	operation_launcher_uninhibit (self);
	_tmp0_ = self->operation;
	_tmp1_ = deja_dup_operation_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (_ ("Backup in progress"));
		_g_free0 (message);
		message = _tmp3_;
		flags = GTK_APPLICATION_INHIBIT_SUSPEND;
		if (!automatic) {
			flags |= GTK_APPLICATION_INHIBIT_LOGOUT;
		}
	} else {
		DejaDupOperation* _tmp4_;
		DejaDupToolJobMode _tmp5_;
		DejaDupToolJobMode _tmp6_;
		_tmp4_ = self->operation;
		_tmp5_ = deja_dup_operation_get_mode (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == DEJA_DUP_TOOL_JOB_MODE_RESTORE) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("Restore in progress"));
			_g_free0 (message);
			message = _tmp7_;
			flags = GTK_APPLICATION_INHIBIT_LOGOUT | GTK_APPLICATION_INHIBIT_SUSPEND;
		} else {
			_g_free0 (message);
			return;
		}
	}
	_tmp8_ = deja_dup_app_get_instance ();
	app = _tmp8_;
	_tmp9_ = app;
	g_application_hold ((GApplication*) _tmp9_);
	_tmp10_ = app;
	_tmp11_ = app;
	_tmp12_ = deja_dup_app_get_app_window (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = message;
	self->priv->inhibit_id = gtk_application_inhibit ((GtkApplication*) _tmp10_, (GtkWindow*) _tmp13_, flags, _tmp14_);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (app);
	_g_free0 (message);
}

static void
operation_launcher_uninhibit (OperationLauncher* self)
{
	DejaDupApp* app = NULL;
	DejaDupApp* _tmp0_;
	DejaDupApp* _tmp1_;
	DejaDupApp* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->inhibit_id == ((guint) 0)) {
		return;
	}
	_tmp0_ = deja_dup_app_get_instance ();
	app = _tmp0_;
	_tmp1_ = app;
	gtk_application_uninhibit ((GtkApplication*) _tmp1_, self->priv->inhibit_id);
	self->priv->inhibit_id = (guint) 0;
	_tmp2_ = app;
	g_application_release ((GApplication*) _tmp2_);
	_g_object_unref0 (app);
}

OperationLauncher*
operation_launcher_construct (GType object_type)
{
	OperationLauncher * self = NULL;
	self = (OperationLauncher*) g_object_new (object_type, NULL);
	return self;
}

OperationLauncher*
operation_launcher_new (void)
{
	return operation_launcher_construct (TYPE_OPERATION_LAUNCHER);
}

static void
operation_launcher_class_init (OperationLauncherClass * klass,
                               gpointer klass_data)
{
	operation_launcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OperationLauncher_private_offset);
	G_OBJECT_CLASS (klass)->finalize = operation_launcher_finalize;
}

static void
operation_launcher_instance_init (OperationLauncher * self,
                                  gpointer klass)
{
	self->priv = operation_launcher_get_instance_private (self);
}

static void
operation_launcher_finalize (GObject * obj)
{
	OperationLauncher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OPERATION_LAUNCHER, OperationLauncher);
	_g_object_unref0 (self->operation);
	_g_object_unref0 (self->wrapper);
	G_OBJECT_CLASS (operation_launcher_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
operation_launcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OperationLauncherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) operation_launcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OperationLauncher), 0, (GInstanceInitFunc) operation_launcher_instance_init, NULL };
	GType operation_launcher_type_id;
	operation_launcher_type_id = g_type_register_static (G_TYPE_OBJECT, "OperationLauncher", &g_define_type_info, 0);
	OperationLauncher_private_offset = g_type_add_instance_private (operation_launcher_type_id, sizeof (OperationLauncherPrivate));
	return operation_launcher_type_id;
}

GType
operation_launcher_get_type (void)
{
	static gsize operation_launcher_type_id__once = 0;
	if (g_once_init_enter (&operation_launcher_type_id__once)) {
		GType operation_launcher_type_id;
		operation_launcher_type_id = operation_launcher_get_type_once ();
		g_once_init_leave (&operation_launcher_type_id__once, operation_launcher_type_id);
	}
	return operation_launcher_type_id__once;
}

