// Copyright 2024-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/plugin/option/v1/option.proto

//go:build !protoopaque

package optionv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An option for a plugin.
//
// Options are key/values that can control the behavior of a plugin.
//
// For example, if you had a check Rule that checked that the suffix of all Services was "API",
// you may want an option with key "service_suffix" that can override the suffix "API" to
// another suffix such as "Service". This would result in the behavior of check changing,
// as well as result in the Purpose string potentially changing to specify that the
// expected suffix is "Service" instead of "API".
type Option struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The option key.
	//
	// This identifies the option.
	//
	// Required.
	//
	// This must have at least three characters.
	// This must start and end with a lowercase letter from a-z, and only consist
	// of lowercase letters from a-z and underscores.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The option value.
	//
	// Required.
	//
	// It is not possible to set a key with a not-present value. Do not add an Option with
	// a given key to denote that the key is not set.
	Value         *Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Option) Reset() {
	*x = Option{}
	mi := &file_buf_plugin_option_v1_option_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Option) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Option) ProtoMessage() {}

func (x *Option) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_option_v1_option_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Option) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Option) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Option) SetKey(v string) {
	x.Key = v
}

func (x *Option) SetValue(v *Value) {
	x.Value = v
}

func (x *Option) HasValue() bool {
	if x == nil {
		return false
	}
	return x.Value != nil
}

func (x *Option) ClearValue() {
	x.Value = nil
}

type Option_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The option key.
	//
	// This identifies the option.
	//
	// Required.
	//
	// This must have at least three characters.
	// This must start and end with a lowercase letter from a-z, and only consist
	// of lowercase letters from a-z and underscores.
	Key string
	// The option value.
	//
	// Required.
	//
	// It is not possible to set a key with a not-present value. Do not add an Option with
	// a given key to denote that the key is not set.
	Value *Value
}

func (b0 Option_builder) Build() *Option {
	m0 := &Option{}
	b, x := &b0, m0
	_, _ = b, x
	x.Key = b.Key
	x.Value = b.Value
	return m0
}

// Value is an option value.
//
// This is similar to google.protobuf.Value but with better typing.
type Value struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The type of value.
	//
	// At least one value must be set.
	//
	// Types that are valid to be assigned to Type:
	//
	//	*Value_BoolValue
	//	*Value_Int64Value
	//	*Value_DoubleValue
	//	*Value_StringValue
	//	*Value_BytesValue
	//	*Value_ListValue
	Type          isValue_Type `protobuf_oneof:"type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Value) Reset() {
	*x = Value{}
	mi := &file_buf_plugin_option_v1_option_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Value) ProtoMessage() {}

func (x *Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_option_v1_option_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Value) GetType() isValue_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Value) GetBoolValue() bool {
	if x != nil {
		if x, ok := x.Type.(*Value_BoolValue); ok {
			return x.BoolValue
		}
	}
	return false
}

func (x *Value) GetInt64Value() int64 {
	if x != nil {
		if x, ok := x.Type.(*Value_Int64Value); ok {
			return x.Int64Value
		}
	}
	return 0
}

func (x *Value) GetDoubleValue() float64 {
	if x != nil {
		if x, ok := x.Type.(*Value_DoubleValue); ok {
			return x.DoubleValue
		}
	}
	return 0
}

func (x *Value) GetStringValue() string {
	if x != nil {
		if x, ok := x.Type.(*Value_StringValue); ok {
			return x.StringValue
		}
	}
	return ""
}

func (x *Value) GetBytesValue() []byte {
	if x != nil {
		if x, ok := x.Type.(*Value_BytesValue); ok {
			return x.BytesValue
		}
	}
	return nil
}

func (x *Value) GetListValue() *ListValue {
	if x != nil {
		if x, ok := x.Type.(*Value_ListValue); ok {
			return x.ListValue
		}
	}
	return nil
}

func (x *Value) SetBoolValue(v bool) {
	x.Type = &Value_BoolValue{v}
}

func (x *Value) SetInt64Value(v int64) {
	x.Type = &Value_Int64Value{v}
}

func (x *Value) SetDoubleValue(v float64) {
	x.Type = &Value_DoubleValue{v}
}

func (x *Value) SetStringValue(v string) {
	x.Type = &Value_StringValue{v}
}

func (x *Value) SetBytesValue(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.Type = &Value_BytesValue{v}
}

func (x *Value) SetListValue(v *ListValue) {
	if v == nil {
		x.Type = nil
		return
	}
	x.Type = &Value_ListValue{v}
}

func (x *Value) HasType() bool {
	if x == nil {
		return false
	}
	return x.Type != nil
}

func (x *Value) HasBoolValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*Value_BoolValue)
	return ok
}

func (x *Value) HasInt64Value() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*Value_Int64Value)
	return ok
}

func (x *Value) HasDoubleValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*Value_DoubleValue)
	return ok
}

func (x *Value) HasStringValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*Value_StringValue)
	return ok
}

func (x *Value) HasBytesValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*Value_BytesValue)
	return ok
}

func (x *Value) HasListValue() bool {
	if x == nil {
		return false
	}
	_, ok := x.Type.(*Value_ListValue)
	return ok
}

func (x *Value) ClearType() {
	x.Type = nil
}

func (x *Value) ClearBoolValue() {
	if _, ok := x.Type.(*Value_BoolValue); ok {
		x.Type = nil
	}
}

func (x *Value) ClearInt64Value() {
	if _, ok := x.Type.(*Value_Int64Value); ok {
		x.Type = nil
	}
}

func (x *Value) ClearDoubleValue() {
	if _, ok := x.Type.(*Value_DoubleValue); ok {
		x.Type = nil
	}
}

func (x *Value) ClearStringValue() {
	if _, ok := x.Type.(*Value_StringValue); ok {
		x.Type = nil
	}
}

func (x *Value) ClearBytesValue() {
	if _, ok := x.Type.(*Value_BytesValue); ok {
		x.Type = nil
	}
}

func (x *Value) ClearListValue() {
	if _, ok := x.Type.(*Value_ListValue); ok {
		x.Type = nil
	}
}

const Value_Type_not_set_case case_Value_Type = 0
const Value_BoolValue_case case_Value_Type = 1
const Value_Int64Value_case case_Value_Type = 2
const Value_DoubleValue_case case_Value_Type = 3
const Value_StringValue_case case_Value_Type = 4
const Value_BytesValue_case case_Value_Type = 5
const Value_ListValue_case case_Value_Type = 6

func (x *Value) WhichType() case_Value_Type {
	if x == nil {
		return Value_Type_not_set_case
	}
	switch x.Type.(type) {
	case *Value_BoolValue:
		return Value_BoolValue_case
	case *Value_Int64Value:
		return Value_Int64Value_case
	case *Value_DoubleValue:
		return Value_DoubleValue_case
	case *Value_StringValue:
		return Value_StringValue_case
	case *Value_BytesValue:
		return Value_BytesValue_case
	case *Value_ListValue:
		return Value_ListValue_case
	default:
		return Value_Type_not_set_case
	}
}

type Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The type of value.
	//
	// At least one value must be set.

	// Fields of oneof Type:
	// A bool value.
	BoolValue *bool
	// An int64 value.
	Int64Value *int64
	// A double value.
	DoubleValue *float64
	// A string value.
	StringValue *string
	// A bytes value.
	BytesValue []byte
	// A list of Values.
	ListValue *ListValue
	// -- end of Type
}

func (b0 Value_builder) Build() *Value {
	m0 := &Value{}
	b, x := &b0, m0
	_, _ = b, x
	if b.BoolValue != nil {
		x.Type = &Value_BoolValue{*b.BoolValue}
	}
	if b.Int64Value != nil {
		x.Type = &Value_Int64Value{*b.Int64Value}
	}
	if b.DoubleValue != nil {
		x.Type = &Value_DoubleValue{*b.DoubleValue}
	}
	if b.StringValue != nil {
		x.Type = &Value_StringValue{*b.StringValue}
	}
	if b.BytesValue != nil {
		x.Type = &Value_BytesValue{b.BytesValue}
	}
	if b.ListValue != nil {
		x.Type = &Value_ListValue{b.ListValue}
	}
	return m0
}

type case_Value_Type protoreflect.FieldNumber

func (x case_Value_Type) String() string {
	md := file_buf_plugin_option_v1_option_proto_msgTypes[1].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isValue_Type interface {
	isValue_Type()
}

type Value_BoolValue struct {
	// A bool value.
	BoolValue bool `protobuf:"varint,1,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type Value_Int64Value struct {
	// An int64 value.
	Int64Value int64 `protobuf:"varint,2,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type Value_DoubleValue struct {
	// A double value.
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type Value_StringValue struct {
	// A string value.
	StringValue string `protobuf:"bytes,4,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Value_BytesValue struct {
	// A bytes value.
	BytesValue []byte `protobuf:"bytes,5,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}

type Value_ListValue struct {
	// A list of Values.
	ListValue *ListValue `protobuf:"bytes,6,opt,name=list_value,json=listValue,proto3,oneof"`
}

func (*Value_BoolValue) isValue_Type() {}

func (*Value_Int64Value) isValue_Type() {}

func (*Value_DoubleValue) isValue_Type() {}

func (*Value_StringValue) isValue_Type() {}

func (*Value_BytesValue) isValue_Type() {}

func (*Value_ListValue) isValue_Type() {}

// ListValue is a list of Values.
//
// This is needed so that it can be part of a oneof in Value.
type ListValue struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The values comprising the list value.
	//
	// All Values must be of the same type.
	Values        []*Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListValue) Reset() {
	*x = ListValue{}
	mi := &file_buf_plugin_option_v1_option_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListValue) ProtoMessage() {}

func (x *ListValue) ProtoReflect() protoreflect.Message {
	mi := &file_buf_plugin_option_v1_option_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListValue) GetValues() []*Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *ListValue) SetValues(v []*Value) {
	x.Values = v
}

type ListValue_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The values comprising the list value.
	//
	// All Values must be of the same type.
	Values []*Value
}

func (b0 ListValue_builder) Build() *ListValue {
	m0 := &ListValue{}
	b, x := &b0, m0
	_, _ = b, x
	x.Values = b.Values
	return m0
}

var File_buf_plugin_option_v1_option_proto protoreflect.FileDescriptor

const file_buf_plugin_option_v1_option_proto_rawDesc = "" +
	"\n" +
	"!buf/plugin/option/v1/option.proto\x12\x14buf.plugin.option.v1\x1a\x1bbuf/validate/validate.proto\"x\n" +
	"\x06Option\x123\n" +
	"\x03key\x18\x01 \x01(\tB!\xbaH\x1e\xc8\x01\x01r\x19\x10\x03\x18@2\x13^[a-z][a-z_]*[a-z]$R\x03key\x129\n" +
	"\x05value\x18\x02 \x01(\v2\x1b.buf.plugin.option.v1.ValueB\x06\xbaH\x03\xc8\x01\x01R\x05value\"\x89\x02\n" +
	"\x05Value\x12\x1f\n" +
	"\n" +
	"bool_value\x18\x01 \x01(\bH\x00R\tboolValue\x12!\n" +
	"\vint64_value\x18\x02 \x01(\x03H\x00R\n" +
	"int64Value\x12#\n" +
	"\fdouble_value\x18\x03 \x01(\x01H\x00R\vdoubleValue\x12#\n" +
	"\fstring_value\x18\x04 \x01(\tH\x00R\vstringValue\x12!\n" +
	"\vbytes_value\x18\x05 \x01(\fH\x00R\n" +
	"bytesValue\x12@\n" +
	"\n" +
	"list_value\x18\x06 \x01(\v2\x1f.buf.plugin.option.v1.ListValueH\x00R\tlistValueB\r\n" +
	"\x04type\x12\x05\xbaH\x02\b\x01\"J\n" +
	"\tListValue\x12=\n" +
	"\x06values\x18\x01 \x03(\v2\x1b.buf.plugin.option.v1.ValueB\b\xbaH\x05\x92\x01\x02\b\x01R\x06valuesBVZTbuf.build/gen/go/bufbuild/bufplugin/protocolbuffers/go/buf/plugin/option/v1;optionv1b\x06proto3"

var file_buf_plugin_option_v1_option_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_buf_plugin_option_v1_option_proto_goTypes = []any{
	(*Option)(nil),    // 0: buf.plugin.option.v1.Option
	(*Value)(nil),     // 1: buf.plugin.option.v1.Value
	(*ListValue)(nil), // 2: buf.plugin.option.v1.ListValue
}
var file_buf_plugin_option_v1_option_proto_depIdxs = []int32{
	1, // 0: buf.plugin.option.v1.Option.value:type_name -> buf.plugin.option.v1.Value
	2, // 1: buf.plugin.option.v1.Value.list_value:type_name -> buf.plugin.option.v1.ListValue
	1, // 2: buf.plugin.option.v1.ListValue.values:type_name -> buf.plugin.option.v1.Value
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_buf_plugin_option_v1_option_proto_init() }
func file_buf_plugin_option_v1_option_proto_init() {
	if File_buf_plugin_option_v1_option_proto != nil {
		return
	}
	file_buf_plugin_option_v1_option_proto_msgTypes[1].OneofWrappers = []any{
		(*Value_BoolValue)(nil),
		(*Value_Int64Value)(nil),
		(*Value_DoubleValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_BytesValue)(nil),
		(*Value_ListValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_plugin_option_v1_option_proto_rawDesc), len(file_buf_plugin_option_v1_option_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_plugin_option_v1_option_proto_goTypes,
		DependencyIndexes: file_buf_plugin_option_v1_option_proto_depIdxs,
		MessageInfos:      file_buf_plugin_option_v1_option_proto_msgTypes,
	}.Build()
	File_buf_plugin_option_v1_option_proto = out.File
	file_buf_plugin_option_v1_option_proto_goTypes = nil
	file_buf_plugin_option_v1_option_proto_depIdxs = nil
}
