/* backgroundTasks.c generated by valac 0.56.18, the Vala compiler
 * generated from backgroundTasks.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and performs background
* related tasks like discovering books, cleaning cached data, etc.
* This code does not require a GUI/Display
* This code should be called from a sheduled job as "bookworm --discover"
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_BACKGROUND_TASKS (bookworm_app_background_tasks_get_type ())
#define BOOKWORM_APP_BACKGROUND_TASKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BACKGROUND_TASKS, BookwormAppBackgroundTasks))
#define BOOKWORM_APP_BACKGROUND_TASKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BACKGROUND_TASKS, BookwormAppBackgroundTasksClass))
#define BOOKWORM_APP_IS_BACKGROUND_TASKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BACKGROUND_TASKS))
#define BOOKWORM_APP_IS_BACKGROUND_TASKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BACKGROUND_TASKS))
#define BOOKWORM_APP_BACKGROUND_TASKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BACKGROUND_TASKS, BookwormAppBackgroundTasksClass))

typedef struct _BookwormAppBackgroundTasks BookwormAppBackgroundTasks;
typedef struct _BookwormAppBackgroundTasksClass BookwormAppBackgroundTasksClass;
typedef struct _BookwormAppBackgroundTasksPrivate BookwormAppBackgroundTasksPrivate;

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _BookwormAppParamSpecBackgroundTasks BookwormAppParamSpecBackgroundTasks;

struct _BookwormAppBackgroundTasks {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppBackgroundTasksPrivate * priv;
};

struct _BookwormAppBackgroundTasksClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppBackgroundTasks *self);
};

struct _BookwormAppParamSpecBackgroundTasks {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_background_tasks_parent_class = NULL;
VALA_EXTERN GeeArrayList* bookworm_app_background_tasks_listOfBooks;
GeeArrayList* bookworm_app_background_tasks_listOfBooks = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_background_tasks_settings;
BookwormAppSettings* bookworm_app_background_tasks_settings = NULL;
VALA_EXTERN gchar* bookworm_app_bookworm_bookworm_config_path;

VALA_EXTERN gpointer bookworm_app_background_tasks_ref (gpointer instance);
VALA_EXTERN void bookworm_app_background_tasks_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_background_tasks (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_background_tasks (GValue* value,
                                              gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_background_tasks (GValue* value,
                                               gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_background_tasks (const GValue* value);
VALA_EXTERN GType bookworm_app_background_tasks_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBackgroundTasks, bookworm_app_background_tasks_unref)
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN void bookworm_app_background_tasks_performTasks (void);
VALA_EXTERN void bookworm_app_background_tasks_initialization (void);
VALA_EXTERN void bookworm_app_background_tasks_discoverBooks (void);
VALA_EXTERN GeeArrayList* bookworm_app_db_getBookIDListFromDB (void);
VALA_EXTERN void bookworm_app_background_tasks_cleanBookCacheContent (void);
VALA_EXTERN void bookworm_app_background_tasks_cleanBookCoverImages (void);
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN gboolean bookworm_app_db_initializeBookWormDB (const gchar* bookworm_config_path);
VALA_EXTERN const gchar* bookworm_app_settings_get_list_of_scan_dirs (BookwormAppSettings* self);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN BookwormAppBook* bookworm_app_book_new (void);
VALA_EXTERN BookwormAppBook* bookworm_app_book_construct (GType object_type);
VALA_EXTERN void bookworm_app_book_setBookLocation (BookwormAppBook* self,
                                        const gchar* aBookLocation);
VALA_EXTERN gint bookworm_app_db_addBookToDataBase (BookwormAppBook* aBook);
VALA_EXTERN void bookworm_app_book_setBookId (BookwormAppBook* self,
                                  gint aBookId);
VALA_EXTERN void bookworm_app_book_setBookLastModificationDate (BookwormAppBook* self,
                                                    const gchar* aBookLastModificationDate);
VALA_EXTERN void bookworm_app_book_setWasBookOpened (BookwormAppBook* self,
                                         gboolean aWasBookOpened);
VALA_EXTERN BookwormAppBook* bookworm_app_bookworm_genericParser (BookwormAppBook* aBook);
VALA_EXTERN gboolean bookworm_app_book_getIsBookParsed (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_db_removeBookFromDB (BookwormAppBook* aBook);
VALA_EXTERN gboolean bookworm_app_db_updateBookToDataBase (BookwormAppBook* aBook);
VALA_EXTERN BookwormAppBackgroundTasks* bookworm_app_background_tasks_new (void);
VALA_EXTERN BookwormAppBackgroundTasks* bookworm_app_background_tasks_construct (GType object_type);
static void bookworm_app_background_tasks_finalize (BookwormAppBackgroundTasks * obj);
static GType bookworm_app_background_tasks_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

void
bookworm_app_background_tasks_performTasks (void)
{
	GeeArrayList* _tmp0_;
#line 27 "../src/backgroundTasks.vala"
	bookworm_app_background_tasks_initialization ();
#line 29 "../src/backgroundTasks.vala"
	bookworm_app_background_tasks_discoverBooks ();
#line 31 "../src/backgroundTasks.vala"
	_tmp0_ = bookworm_app_db_getBookIDListFromDB ();
#line 31 "../src/backgroundTasks.vala"
	_g_object_unref0 (bookworm_app_background_tasks_listOfBooks);
#line 31 "../src/backgroundTasks.vala"
	bookworm_app_background_tasks_listOfBooks = _tmp0_;
#line 33 "../src/backgroundTasks.vala"
	bookworm_app_background_tasks_cleanBookCacheContent ();
#line 34 "../src/backgroundTasks.vala"
	bookworm_app_background_tasks_cleanBookCoverImages ();
#line 198 "backgroundTasks.c"
}

void
bookworm_app_background_tasks_initialization (void)
{
	BookwormAppSettings* _tmp0_;
	const gchar* _tmp1_;
	GeeArrayList* _tmp2_;
#line 38 "../src/backgroundTasks.vala"
	_tmp0_ = bookworm_app_settings_get_instance ();
#line 38 "../src/backgroundTasks.vala"
	_g_object_unref0 (bookworm_app_background_tasks_settings);
#line 38 "../src/backgroundTasks.vala"
	bookworm_app_background_tasks_settings = _tmp0_;
#line 40 "../src/backgroundTasks.vala"
	_tmp1_ = bookworm_app_bookworm_bookworm_config_path;
#line 40 "../src/backgroundTasks.vala"
	bookworm_app_db_initializeBookWormDB (_tmp1_);
#line 41 "../src/backgroundTasks.vala"
	_tmp2_ = bookworm_app_db_getBookIDListFromDB ();
#line 41 "../src/backgroundTasks.vala"
	_g_object_unref0 (bookworm_app_background_tasks_listOfBooks);
#line 41 "../src/backgroundTasks.vala"
	bookworm_app_background_tasks_listOfBooks = _tmp2_;
#line 223 "backgroundTasks.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 242 "backgroundTasks.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 263 "backgroundTasks.c"
}

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 89 "../src/backgroundTasks.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 271 "backgroundTasks.c"
}

void
bookworm_app_background_tasks_discoverBooks (void)
{
	GeeArrayList* scanDirList = NULL;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	BookwormAppSettings* _tmp3_;
#line 45 "../src/backgroundTasks.vala"
	g_print ("\nStarted process for discovery of books....");
#line 46 "../src/backgroundTasks.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 46 "../src/backgroundTasks.vala"
	scanDirList = _tmp0_;
#line 48 "../src/backgroundTasks.vala"
	_tmp3_ = bookworm_app_background_tasks_settings;
#line 48 "../src/backgroundTasks.vala"
	if (_tmp3_ != NULL) {
#line 292 "backgroundTasks.c"
		BookwormAppSettings* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
#line 49 "../src/backgroundTasks.vala"
		_tmp4_ = bookworm_app_background_tasks_settings;
#line 49 "../src/backgroundTasks.vala"
		_tmp5_ = bookworm_app_settings_get_list_of_scan_dirs (_tmp4_);
#line 49 "../src/backgroundTasks.vala"
		_tmp6_ = _tmp5_;
#line 49 "../src/backgroundTasks.vala"
		_tmp2_ = _tmp6_ != NULL;
#line 304 "backgroundTasks.c"
	} else {
#line 48 "../src/backgroundTasks.vala"
		_tmp2_ = FALSE;
#line 308 "backgroundTasks.c"
	}
#line 48 "../src/backgroundTasks.vala"
	if (_tmp2_) {
#line 312 "backgroundTasks.c"
		BookwormAppSettings* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 50 "../src/backgroundTasks.vala"
		_tmp7_ = bookworm_app_background_tasks_settings;
#line 50 "../src/backgroundTasks.vala"
		_tmp8_ = bookworm_app_settings_get_list_of_scan_dirs (_tmp7_);
#line 50 "../src/backgroundTasks.vala"
		_tmp9_ = _tmp8_;
#line 50 "../src/backgroundTasks.vala"
		_tmp10_ = strlen (_tmp9_);
#line 50 "../src/backgroundTasks.vala"
		_tmp11_ = _tmp10_;
#line 50 "../src/backgroundTasks.vala"
		_tmp1_ = _tmp11_ > 1;
#line 330 "backgroundTasks.c"
	} else {
#line 48 "../src/backgroundTasks.vala"
		_tmp1_ = FALSE;
#line 334 "backgroundTasks.c"
	}
#line 48 "../src/backgroundTasks.vala"
	if (_tmp1_) {
#line 338 "backgroundTasks.c"
		BookwormAppSettings* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar** scanDirArray = NULL;
		BookwormAppSettings* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar** _tmp18_;
		gchar** _tmp19_;
		gint scanDirArray_length1;
		gint _scanDirArray_size_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		GeeArrayList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
#line 52 "../src/backgroundTasks.vala"
		_tmp12_ = bookworm_app_background_tasks_settings;
#line 52 "../src/backgroundTasks.vala"
		_tmp13_ = bookworm_app_settings_get_list_of_scan_dirs (_tmp12_);
#line 52 "../src/backgroundTasks.vala"
		_tmp14_ = _tmp13_;
#line 52 "../src/backgroundTasks.vala"
		g_debug ("backgroundTasks.vala:52: %s", _tmp14_);
#line 53 "../src/backgroundTasks.vala"
		_tmp15_ = bookworm_app_background_tasks_settings;
#line 53 "../src/backgroundTasks.vala"
		_tmp16_ = bookworm_app_settings_get_list_of_scan_dirs (_tmp15_);
#line 53 "../src/backgroundTasks.vala"
		_tmp17_ = _tmp16_;
#line 53 "../src/backgroundTasks.vala"
		_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, "~~", 0);
#line 53 "../src/backgroundTasks.vala"
		scanDirArray = _tmp19_;
#line 53 "../src/backgroundTasks.vala"
		scanDirArray_length1 = _vala_array_length (_tmp18_);
#line 53 "../src/backgroundTasks.vala"
		_scanDirArray_size_ = scanDirArray_length1;
#line 54 "../src/backgroundTasks.vala"
		_tmp20_ = scanDirArray;
#line 54 "../src/backgroundTasks.vala"
		_tmp20__length1 = scanDirArray_length1;
#line 381 "backgroundTasks.c"
		{
			gchar** token_collection = NULL;
			gint token_collection_length1 = 0;
			gint _token_collection_size_ = 0;
			gint token_it = 0;
#line 54 "../src/backgroundTasks.vala"
			token_collection = _tmp20_;
#line 54 "../src/backgroundTasks.vala"
			token_collection_length1 = _tmp20__length1;
#line 54 "../src/backgroundTasks.vala"
			for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
#line 393 "backgroundTasks.c"
				gchar* _tmp21_;
				gchar* token = NULL;
#line 54 "../src/backgroundTasks.vala"
				_tmp21_ = g_strdup (token_collection[token_it]);
#line 54 "../src/backgroundTasks.vala"
				token = _tmp21_;
#line 400 "backgroundTasks.c"
				{
					GeeArrayList* _tmp22_;
					const gchar* _tmp23_;
#line 55 "../src/backgroundTasks.vala"
					_tmp22_ = scanDirList;
#line 55 "../src/backgroundTasks.vala"
					_tmp23_ = token;
#line 55 "../src/backgroundTasks.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
#line 54 "../src/backgroundTasks.vala"
					_g_free0 (token);
#line 412 "backgroundTasks.c"
				}
			}
		}
#line 58 "../src/backgroundTasks.vala"
		_tmp24_ = scanDirList;
#line 58 "../src/backgroundTasks.vala"
		_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
#line 58 "../src/backgroundTasks.vala"
		_tmp26_ = _tmp25_;
#line 58 "../src/backgroundTasks.vala"
		if (_tmp26_ > 0) {
#line 424 "backgroundTasks.c"
			GString* findCmd = NULL;
			GString* _tmp27_;
			GString* _tmp46_;
			gchar* findCmdOutput = NULL;
			GString* _tmp47_;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
#line 60 "../src/backgroundTasks.vala"
			_tmp27_ = g_string_new ("find ");
#line 60 "../src/backgroundTasks.vala"
			findCmd = _tmp27_;
#line 437 "backgroundTasks.c"
			{
				GeeArrayList* _scanDir_list = NULL;
				GeeArrayList* _tmp28_;
				gint _scanDir_size = 0;
				GeeArrayList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _scanDir_index = 0;
#line 61 "../src/backgroundTasks.vala"
				_tmp28_ = scanDirList;
#line 61 "../src/backgroundTasks.vala"
				_scanDir_list = _tmp28_;
#line 61 "../src/backgroundTasks.vala"
				_tmp29_ = _scanDir_list;
#line 61 "../src/backgroundTasks.vala"
				_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
#line 61 "../src/backgroundTasks.vala"
				_tmp31_ = _tmp30_;
#line 61 "../src/backgroundTasks.vala"
				_scanDir_size = _tmp31_;
#line 61 "../src/backgroundTasks.vala"
				_scanDir_index = -1;
#line 61 "../src/backgroundTasks.vala"
				while (TRUE) {
#line 462 "backgroundTasks.c"
					gint _tmp32_;
					gint _tmp33_;
					gchar* scanDir = NULL;
					GeeArrayList* _tmp34_;
					gpointer _tmp35_;
					gboolean _tmp36_ = FALSE;
					const gchar* _tmp37_;
#line 61 "../src/backgroundTasks.vala"
					_scanDir_index = _scanDir_index + 1;
#line 61 "../src/backgroundTasks.vala"
					_tmp32_ = _scanDir_index;
#line 61 "../src/backgroundTasks.vala"
					_tmp33_ = _scanDir_size;
#line 61 "../src/backgroundTasks.vala"
					if (!(_tmp32_ < _tmp33_)) {
#line 61 "../src/backgroundTasks.vala"
						break;
#line 480 "backgroundTasks.c"
					}
#line 61 "../src/backgroundTasks.vala"
					_tmp34_ = _scanDir_list;
#line 61 "../src/backgroundTasks.vala"
					_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _scanDir_index);
#line 61 "../src/backgroundTasks.vala"
					scanDir = (gchar*) _tmp35_;
#line 62 "../src/backgroundTasks.vala"
					_tmp37_ = scanDir;
#line 62 "../src/backgroundTasks.vala"
					if (_tmp37_ != NULL) {
#line 492 "backgroundTasks.c"
						const gchar* _tmp38_;
						gint _tmp39_;
						gint _tmp40_;
#line 62 "../src/backgroundTasks.vala"
						_tmp38_ = scanDir;
#line 62 "../src/backgroundTasks.vala"
						_tmp39_ = strlen (_tmp38_);
#line 62 "../src/backgroundTasks.vala"
						_tmp40_ = _tmp39_;
#line 62 "../src/backgroundTasks.vala"
						_tmp36_ = _tmp40_ > 1;
#line 504 "backgroundTasks.c"
					} else {
#line 62 "../src/backgroundTasks.vala"
						_tmp36_ = FALSE;
#line 508 "backgroundTasks.c"
					}
#line 62 "../src/backgroundTasks.vala"
					if (_tmp36_) {
#line 512 "backgroundTasks.c"
						GString* _tmp41_;
						GString* _tmp42_;
						const gchar* _tmp43_;
						GString* _tmp44_;
						GString* _tmp45_;
#line 63 "../src/backgroundTasks.vala"
						_tmp41_ = findCmd;
#line 63 "../src/backgroundTasks.vala"
						_tmp42_ = g_string_append (_tmp41_, "\"");
#line 63 "../src/backgroundTasks.vala"
						_tmp43_ = scanDir;
#line 63 "../src/backgroundTasks.vala"
						_tmp44_ = g_string_append (_tmp42_, _tmp43_);
#line 63 "../src/backgroundTasks.vala"
						_tmp45_ = g_string_append (_tmp44_, "\"");
#line 63 "../src/backgroundTasks.vala"
						g_string_append (_tmp45_, " ");
#line 530 "backgroundTasks.c"
					}
#line 61 "../src/backgroundTasks.vala"
					_g_free0 (scanDir);
#line 534 "backgroundTasks.c"
				}
			}
#line 66 "../src/backgroundTasks.vala"
			_tmp46_ = findCmd;
#line 66 "../src/backgroundTasks.vala"
			g_string_append (_tmp46_, "! -readable -prune -o -type f \\( -iname \\*.mobi -o -iname \\*.pdf -o" \
" -iname \\*.epub -o -iname \\*.cbr -o -iname \\*.cbz \\) -print");
#line 67 "../src/backgroundTasks.vala"
			_tmp47_ = findCmd;
#line 67 "../src/backgroundTasks.vala"
			_tmp48_ = _tmp47_->str;
#line 67 "../src/backgroundTasks.vala"
			_tmp49_ = bookworm_app_utils_execute_sync_command (_tmp48_);
#line 67 "../src/backgroundTasks.vala"
			findCmdOutput = _tmp49_;
#line 68 "../src/backgroundTasks.vala"
			_tmp50_ = findCmdOutput;
#line 68 "../src/backgroundTasks.vala"
			if (string_contains (_tmp50_, "\n")) {
#line 553 "backgroundTasks.c"
				gchar** findCmdOutputResults = NULL;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar** _tmp54_;
				gchar** _tmp55_;
				gchar** _tmp56_;
				gint _tmp56__length1;
				gint findCmdOutputResults_length1;
				gint _findCmdOutputResults_size_;
				gchar** _tmp57_;
				gint _tmp57__length1;
#line 69 "../src/backgroundTasks.vala"
				_tmp51_ = findCmdOutput;
#line 69 "../src/backgroundTasks.vala"
				_tmp52_ = string_strip (_tmp51_);
#line 69 "../src/backgroundTasks.vala"
				_tmp53_ = _tmp52_;
#line 69 "../src/backgroundTasks.vala"
				_tmp55_ = _tmp54_ = g_strsplit (_tmp53_, "\n", -1);
#line 69 "../src/backgroundTasks.vala"
				_tmp56_ = _tmp55_;
#line 69 "../src/backgroundTasks.vala"
				_tmp56__length1 = _vala_array_length (_tmp54_);
#line 69 "../src/backgroundTasks.vala"
				_g_free0 (_tmp53_);
#line 69 "../src/backgroundTasks.vala"
				findCmdOutputResults = _tmp56_;
#line 69 "../src/backgroundTasks.vala"
				findCmdOutputResults_length1 = _tmp56__length1;
#line 69 "../src/backgroundTasks.vala"
				_findCmdOutputResults_size_ = findCmdOutputResults_length1;
#line 70 "../src/backgroundTasks.vala"
				_tmp57_ = findCmdOutputResults;
#line 70 "../src/backgroundTasks.vala"
				_tmp57__length1 = findCmdOutputResults_length1;
#line 590 "backgroundTasks.c"
				{
					gchar** findResult_collection = NULL;
					gint findResult_collection_length1 = 0;
					gint _findResult_collection_size_ = 0;
					gint findResult_it = 0;
#line 70 "../src/backgroundTasks.vala"
					findResult_collection = _tmp57_;
#line 70 "../src/backgroundTasks.vala"
					findResult_collection_length1 = _tmp57__length1;
#line 70 "../src/backgroundTasks.vala"
					for (findResult_it = 0; findResult_it < findResult_collection_length1; findResult_it = findResult_it + 1) {
#line 602 "backgroundTasks.c"
						gchar* _tmp58_;
						gchar* findResult = NULL;
#line 70 "../src/backgroundTasks.vala"
						_tmp58_ = g_strdup (findResult_collection[findResult_it]);
#line 70 "../src/backgroundTasks.vala"
						findResult = _tmp58_;
#line 609 "backgroundTasks.c"
						{
							gboolean noMatchFound = FALSE;
#line 71 "../src/backgroundTasks.vala"
							noMatchFound = TRUE;
#line 614 "backgroundTasks.c"
							{
								GeeArrayList* _book_list = NULL;
								GeeArrayList* _tmp59_;
								gint _book_size = 0;
								GeeArrayList* _tmp60_;
								gint _tmp61_;
								gint _tmp62_;
								gint _book_index = 0;
#line 72 "../src/backgroundTasks.vala"
								_tmp59_ = bookworm_app_background_tasks_listOfBooks;
#line 72 "../src/backgroundTasks.vala"
								_book_list = _tmp59_;
#line 72 "../src/backgroundTasks.vala"
								_tmp60_ = _book_list;
#line 72 "../src/backgroundTasks.vala"
								_tmp61_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp60_);
#line 72 "../src/backgroundTasks.vala"
								_tmp62_ = _tmp61_;
#line 72 "../src/backgroundTasks.vala"
								_book_size = _tmp62_;
#line 72 "../src/backgroundTasks.vala"
								_book_index = -1;
#line 72 "../src/backgroundTasks.vala"
								while (TRUE) {
#line 639 "backgroundTasks.c"
									gint _tmp63_;
									gint _tmp64_;
									gchar* book = NULL;
									GeeArrayList* _tmp65_;
									gpointer _tmp66_;
									const gchar* _tmp67_;
									const gchar* _tmp68_;
#line 72 "../src/backgroundTasks.vala"
									_book_index = _book_index + 1;
#line 72 "../src/backgroundTasks.vala"
									_tmp63_ = _book_index;
#line 72 "../src/backgroundTasks.vala"
									_tmp64_ = _book_size;
#line 72 "../src/backgroundTasks.vala"
									if (!(_tmp63_ < _tmp64_)) {
#line 72 "../src/backgroundTasks.vala"
										break;
#line 657 "backgroundTasks.c"
									}
#line 72 "../src/backgroundTasks.vala"
									_tmp65_ = _book_list;
#line 72 "../src/backgroundTasks.vala"
									_tmp66_ = gee_abstract_list_get ((GeeAbstractList*) _tmp65_, _book_index);
#line 72 "../src/backgroundTasks.vala"
									book = (gchar*) _tmp66_;
#line 73 "../src/backgroundTasks.vala"
									_tmp67_ = book;
#line 73 "../src/backgroundTasks.vala"
									_tmp68_ = findResult;
#line 73 "../src/backgroundTasks.vala"
									if (string_contains (_tmp67_, _tmp68_)) {
#line 74 "../src/backgroundTasks.vala"
										noMatchFound = FALSE;
#line 75 "../src/backgroundTasks.vala"
										_g_free0 (book);
#line 75 "../src/backgroundTasks.vala"
										break;
#line 677 "backgroundTasks.c"
									}
#line 72 "../src/backgroundTasks.vala"
									_g_free0 (book);
#line 681 "backgroundTasks.c"
								}
							}
#line 78 "../src/backgroundTasks.vala"
							if (noMatchFound) {
#line 686 "backgroundTasks.c"
								const gchar* _tmp69_;
								gchar* _tmp70_;
								gchar* _tmp71_;
								BookwormAppBook* aBook = NULL;
								BookwormAppBook* _tmp72_;
								BookwormAppBook* _tmp73_;
								const gchar* _tmp74_;
								GFile* eBookFile = NULL;
								const gchar* _tmp75_;
								GFile* _tmp76_;
								gboolean _tmp77_ = FALSE;
								GFile* _tmp78_;
#line 79 "../src/backgroundTasks.vala"
								_tmp69_ = findResult;
#line 79 "../src/backgroundTasks.vala"
								_tmp70_ = g_strconcat ("\nAttempting to add book located at:", _tmp69_, NULL);
#line 79 "../src/backgroundTasks.vala"
								_tmp71_ = _tmp70_;
#line 79 "../src/backgroundTasks.vala"
								g_print ("%s", _tmp71_);
#line 79 "../src/backgroundTasks.vala"
								_g_free0 (_tmp71_);
#line 80 "../src/backgroundTasks.vala"
								_tmp72_ = bookworm_app_book_new ();
#line 80 "../src/backgroundTasks.vala"
								aBook = _tmp72_;
#line 81 "../src/backgroundTasks.vala"
								_tmp73_ = aBook;
#line 81 "../src/backgroundTasks.vala"
								_tmp74_ = findResult;
#line 81 "../src/backgroundTasks.vala"
								bookworm_app_book_setBookLocation (_tmp73_, _tmp74_);
#line 82 "../src/backgroundTasks.vala"
								_tmp75_ = findResult;
#line 82 "../src/backgroundTasks.vala"
								_tmp76_ = g_file_new_for_path (_tmp75_);
#line 82 "../src/backgroundTasks.vala"
								eBookFile = _tmp76_;
#line 83 "../src/backgroundTasks.vala"
								_tmp78_ = eBookFile;
#line 83 "../src/backgroundTasks.vala"
								if (g_file_query_exists (_tmp78_, NULL)) {
#line 729 "backgroundTasks.c"
									GFile* _tmp79_;
#line 83 "../src/backgroundTasks.vala"
									_tmp79_ = eBookFile;
#line 83 "../src/backgroundTasks.vala"
									_tmp77_ = g_file_query_file_type (_tmp79_, 0, NULL) != G_FILE_TYPE_DIRECTORY;
#line 735 "backgroundTasks.c"
								} else {
#line 83 "../src/backgroundTasks.vala"
									_tmp77_ = FALSE;
#line 739 "backgroundTasks.c"
								}
#line 83 "../src/backgroundTasks.vala"
								if (_tmp77_) {
#line 743 "backgroundTasks.c"
									gint bookID = 0;
									BookwormAppBook* _tmp80_;
									BookwormAppBook* _tmp81_;
									BookwormAppBook* _tmp82_;
									GDateTime* _tmp83_;
									GDateTime* _tmp84_;
									gchar* _tmp85_;
									gchar* _tmp86_;
									BookwormAppBook* _tmp87_;
									BookwormAppBook* _tmp88_;
									BookwormAppBook* _tmp89_;
									BookwormAppBook* _tmp90_;
									BookwormAppBook* _tmp91_;
#line 84 "../src/backgroundTasks.vala"
									_tmp80_ = aBook;
#line 84 "../src/backgroundTasks.vala"
									bookID = bookworm_app_db_addBookToDataBase (_tmp80_);
#line 85 "../src/backgroundTasks.vala"
									_tmp81_ = aBook;
#line 85 "../src/backgroundTasks.vala"
									bookworm_app_book_setBookId (_tmp81_, bookID);
#line 86 "../src/backgroundTasks.vala"
									_tmp82_ = aBook;
#line 86 "../src/backgroundTasks.vala"
									_tmp83_ = g_date_time_new_now_utc ();
#line 86 "../src/backgroundTasks.vala"
									_tmp84_ = _tmp83_;
#line 86 "../src/backgroundTasks.vala"
									_tmp85_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_date_time_to_unix (_tmp84_));
#line 86 "../src/backgroundTasks.vala"
									_tmp86_ = _tmp85_;
#line 86 "../src/backgroundTasks.vala"
									bookworm_app_book_setBookLastModificationDate (_tmp82_, _tmp86_);
#line 86 "../src/backgroundTasks.vala"
									_g_free0 (_tmp86_);
#line 86 "../src/backgroundTasks.vala"
									_g_date_time_unref0 (_tmp84_);
#line 87 "../src/backgroundTasks.vala"
									_tmp87_ = aBook;
#line 87 "../src/backgroundTasks.vala"
									bookworm_app_book_setWasBookOpened (_tmp87_, TRUE);
#line 89 "../src/backgroundTasks.vala"
									_tmp88_ = aBook;
#line 89 "../src/backgroundTasks.vala"
									_tmp89_ = _bookworm_app_book_ref0 (_tmp88_);
#line 89 "../src/backgroundTasks.vala"
									_tmp90_ = bookworm_app_bookworm_genericParser (_tmp89_);
#line 89 "../src/backgroundTasks.vala"
									_bookworm_app_book_unref0 (aBook);
#line 89 "../src/backgroundTasks.vala"
									aBook = _tmp90_;
#line 90 "../src/backgroundTasks.vala"
									_tmp91_ = aBook;
#line 90 "../src/backgroundTasks.vala"
									if (!bookworm_app_book_getIsBookParsed (_tmp91_)) {
#line 799 "backgroundTasks.c"
										BookwormAppBook* _tmp92_;
#line 91 "../src/backgroundTasks.vala"
										_tmp92_ = aBook;
#line 91 "../src/backgroundTasks.vala"
										bookworm_app_db_removeBookFromDB (_tmp92_);
#line 805 "backgroundTasks.c"
									} else {
										BookwormAppBook* _tmp93_;
										const gchar* _tmp94_;
										gchar* _tmp95_;
										gchar* _tmp96_;
#line 93 "../src/backgroundTasks.vala"
										_tmp93_ = aBook;
#line 93 "../src/backgroundTasks.vala"
										bookworm_app_db_updateBookToDataBase (_tmp93_);
#line 94 "../src/backgroundTasks.vala"
										_tmp94_ = findResult;
#line 94 "../src/backgroundTasks.vala"
										_tmp95_ = g_strconcat ("\nSuccessfully added book located at:", _tmp94_, NULL);
#line 94 "../src/backgroundTasks.vala"
										_tmp96_ = _tmp95_;
#line 94 "../src/backgroundTasks.vala"
										g_print ("%s", _tmp96_);
#line 94 "../src/backgroundTasks.vala"
										_g_free0 (_tmp96_);
#line 825 "backgroundTasks.c"
									}
								}
#line 78 "../src/backgroundTasks.vala"
								_g_object_unref0 (eBookFile);
#line 78 "../src/backgroundTasks.vala"
								_bookworm_app_book_unref0 (aBook);
#line 832 "backgroundTasks.c"
							}
#line 70 "../src/backgroundTasks.vala"
							_g_free0 (findResult);
#line 836 "backgroundTasks.c"
						}
					}
				}
#line 68 "../src/backgroundTasks.vala"
				findCmdOutputResults = (_vala_array_free (findCmdOutputResults, findCmdOutputResults_length1, (GDestroyNotify) g_free), NULL);
#line 842 "backgroundTasks.c"
			}
#line 100 "../src/backgroundTasks.vala"
			g_print ("\nCompleted process for discovery of books....\n");
#line 58 "../src/backgroundTasks.vala"
			_g_free0 (findCmdOutput);
#line 58 "../src/backgroundTasks.vala"
			_g_string_free0 (findCmd);
#line 850 "backgroundTasks.c"
		}
#line 48 "../src/backgroundTasks.vala"
		scanDirArray = (_vala_array_free (scanDirArray, scanDirArray_length1, (GDestroyNotify) g_free), NULL);
#line 854 "backgroundTasks.c"
	}
#line 44 "../src/backgroundTasks.vala"
	_g_object_unref0 (scanDirList);
#line 858 "backgroundTasks.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 880 "backgroundTasks.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 884 "backgroundTasks.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 890 "backgroundTasks.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 894 "backgroundTasks.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 898 "backgroundTasks.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 906 "backgroundTasks.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 934 "backgroundTasks.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 943 "backgroundTasks.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 957 "backgroundTasks.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 966 "backgroundTasks.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 980 "backgroundTasks.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 989 "backgroundTasks.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 998 "backgroundTasks.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1022 "backgroundTasks.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1030 "backgroundTasks.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1036 "backgroundTasks.c"
	}
}

void
bookworm_app_background_tasks_cleanBookCacheContent (void)
{
	gchar* cacheFolders = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** cacheFolderList = NULL;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint cacheFolderList_length1;
	gint _cacheFolderList_size_;
	gboolean folderMatched = FALSE;
	gchar** _tmp14_;
	gint _tmp14__length1;
#line 106 "../src/backgroundTasks.vala"
	g_print ("\nStarting to delete un-necessary cache data...");
#line 108 "../src/backgroundTasks.vala"
	_tmp0_ = bookworm_app_bookworm_bookworm_config_path;
#line 108 "../src/backgroundTasks.vala"
	_tmp1_ = g_strconcat ("ls -1 ", _tmp0_, NULL);
#line 108 "../src/backgroundTasks.vala"
	_tmp2_ = _tmp1_;
#line 108 "../src/backgroundTasks.vala"
	_tmp3_ = g_strconcat (_tmp2_, "/books/", NULL);
#line 108 "../src/backgroundTasks.vala"
	_tmp4_ = _tmp3_;
#line 108 "../src/backgroundTasks.vala"
	_tmp5_ = bookworm_app_utils_execute_sync_command (_tmp4_);
#line 108 "../src/backgroundTasks.vala"
	_tmp6_ = _tmp5_;
#line 108 "../src/backgroundTasks.vala"
	_g_free0 (_tmp4_);
#line 108 "../src/backgroundTasks.vala"
	_g_free0 (_tmp2_);
#line 108 "../src/backgroundTasks.vala"
	cacheFolders = _tmp6_;
#line 111 "../src/backgroundTasks.vala"
	_tmp7_ = cacheFolders;
#line 111 "../src/backgroundTasks.vala"
	_tmp8_ = string_replace (_tmp7_, "\r", "^^^");
#line 111 "../src/backgroundTasks.vala"
	_tmp9_ = _tmp8_;
#line 111 "../src/backgroundTasks.vala"
	_tmp10_ = string_replace (_tmp9_, "\n", "^^^");
#line 111 "../src/backgroundTasks.vala"
	_g_free0 (cacheFolders);
#line 111 "../src/backgroundTasks.vala"
	cacheFolders = _tmp10_;
#line 111 "../src/backgroundTasks.vala"
	_g_free0 (_tmp9_);
#line 112 "../src/backgroundTasks.vala"
	_tmp11_ = cacheFolders;
#line 112 "../src/backgroundTasks.vala"
	_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "^^^", 0);
#line 112 "../src/backgroundTasks.vala"
	cacheFolderList = _tmp13_;
#line 112 "../src/backgroundTasks.vala"
	cacheFolderList_length1 = _vala_array_length (_tmp12_);
#line 112 "../src/backgroundTasks.vala"
	_cacheFolderList_size_ = cacheFolderList_length1;
#line 114 "../src/backgroundTasks.vala"
	folderMatched = FALSE;
#line 115 "../src/backgroundTasks.vala"
	_tmp14_ = cacheFolderList;
#line 115 "../src/backgroundTasks.vala"
	_tmp14__length1 = cacheFolderList_length1;
#line 1116 "backgroundTasks.c"
	{
		gchar** cacheFolder_collection = NULL;
		gint cacheFolder_collection_length1 = 0;
		gint _cacheFolder_collection_size_ = 0;
		gint cacheFolder_it = 0;
#line 115 "../src/backgroundTasks.vala"
		cacheFolder_collection = _tmp14_;
#line 115 "../src/backgroundTasks.vala"
		cacheFolder_collection_length1 = _tmp14__length1;
#line 115 "../src/backgroundTasks.vala"
		for (cacheFolder_it = 0; cacheFolder_it < cacheFolder_collection_length1; cacheFolder_it = cacheFolder_it + 1) {
#line 1128 "backgroundTasks.c"
			gchar* _tmp15_;
			gchar* cacheFolder = NULL;
#line 115 "../src/backgroundTasks.vala"
			_tmp15_ = g_strdup (cacheFolder_collection[cacheFolder_it]);
#line 115 "../src/backgroundTasks.vala"
			cacheFolder = _tmp15_;
#line 1135 "backgroundTasks.c"
			{
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_ = FALSE;
				const gchar* _tmp19_;
#line 116 "../src/backgroundTasks.vala"
				folderMatched = FALSE;
#line 117 "../src/backgroundTasks.vala"
				_tmp16_ = cacheFolder;
#line 117 "../src/backgroundTasks.vala"
				_tmp17_ = string_strip (_tmp16_);
#line 117 "../src/backgroundTasks.vala"
				_g_free0 (cacheFolder);
#line 117 "../src/backgroundTasks.vala"
				cacheFolder = _tmp17_;
#line 118 "../src/backgroundTasks.vala"
				_tmp19_ = cacheFolder;
#line 118 "../src/backgroundTasks.vala"
				if (_tmp19_ == NULL) {
#line 118 "../src/backgroundTasks.vala"
					_tmp18_ = TRUE;
#line 1157 "backgroundTasks.c"
				} else {
					const gchar* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
#line 118 "../src/backgroundTasks.vala"
					_tmp20_ = cacheFolder;
#line 118 "../src/backgroundTasks.vala"
					_tmp21_ = strlen (_tmp20_);
#line 118 "../src/backgroundTasks.vala"
					_tmp22_ = _tmp21_;
#line 118 "../src/backgroundTasks.vala"
					_tmp18_ = _tmp22_ < 1;
#line 1170 "backgroundTasks.c"
				}
#line 118 "../src/backgroundTasks.vala"
				if (_tmp18_) {
#line 119 "../src/backgroundTasks.vala"
					folderMatched = TRUE;
#line 1176 "backgroundTasks.c"
				}
				{
					GeeArrayList* _bookData_list = NULL;
					GeeArrayList* _tmp23_;
					gint _bookData_size = 0;
					GeeArrayList* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					gint _bookData_index = 0;
#line 121 "../src/backgroundTasks.vala"
					_tmp23_ = bookworm_app_background_tasks_listOfBooks;
#line 121 "../src/backgroundTasks.vala"
					_bookData_list = _tmp23_;
#line 121 "../src/backgroundTasks.vala"
					_tmp24_ = _bookData_list;
#line 121 "../src/backgroundTasks.vala"
					_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
#line 121 "../src/backgroundTasks.vala"
					_tmp26_ = _tmp25_;
#line 121 "../src/backgroundTasks.vala"
					_bookData_size = _tmp26_;
#line 121 "../src/backgroundTasks.vala"
					_bookData_index = -1;
#line 121 "../src/backgroundTasks.vala"
					while (TRUE) {
#line 1202 "backgroundTasks.c"
						gint _tmp27_;
						gint _tmp28_;
						gchar* bookData = NULL;
						GeeArrayList* _tmp29_;
						gpointer _tmp30_;
						gboolean _tmp31_ = FALSE;
						const gchar* _tmp32_;
#line 121 "../src/backgroundTasks.vala"
						_bookData_index = _bookData_index + 1;
#line 121 "../src/backgroundTasks.vala"
						_tmp27_ = _bookData_index;
#line 121 "../src/backgroundTasks.vala"
						_tmp28_ = _bookData_size;
#line 121 "../src/backgroundTasks.vala"
						if (!(_tmp27_ < _tmp28_)) {
#line 121 "../src/backgroundTasks.vala"
							break;
#line 1220 "backgroundTasks.c"
						}
#line 121 "../src/backgroundTasks.vala"
						_tmp29_ = _bookData_list;
#line 121 "../src/backgroundTasks.vala"
						_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _bookData_index);
#line 121 "../src/backgroundTasks.vala"
						bookData = (gchar*) _tmp30_;
#line 122 "../src/backgroundTasks.vala"
						_tmp32_ = cacheFolder;
#line 122 "../src/backgroundTasks.vala"
						if (_tmp32_ != NULL) {
#line 1232 "backgroundTasks.c"
							const gchar* _tmp33_;
							gint _tmp34_;
							gint _tmp35_;
#line 122 "../src/backgroundTasks.vala"
							_tmp33_ = cacheFolder;
#line 122 "../src/backgroundTasks.vala"
							_tmp34_ = strlen (_tmp33_);
#line 122 "../src/backgroundTasks.vala"
							_tmp35_ = _tmp34_;
#line 122 "../src/backgroundTasks.vala"
							_tmp31_ = _tmp35_ > 0;
#line 1244 "backgroundTasks.c"
						} else {
#line 122 "../src/backgroundTasks.vala"
							_tmp31_ = FALSE;
#line 1248 "backgroundTasks.c"
						}
#line 122 "../src/backgroundTasks.vala"
						if (_tmp31_) {
#line 1252 "backgroundTasks.c"
							const gchar* _tmp36_;
							gchar** _tmp37_;
							gchar** _tmp38_;
							gchar** _tmp39_;
							gint _tmp39__length1;
							const gchar* _tmp40_;
							const gchar* _tmp41_;
							gboolean _tmp42_;
#line 124 "../src/backgroundTasks.vala"
							_tmp36_ = bookData;
#line 124 "../src/backgroundTasks.vala"
							_tmp38_ = _tmp37_ = g_strsplit (_tmp36_, "::", 0);
#line 124 "../src/backgroundTasks.vala"
							_tmp39_ = _tmp38_;
#line 124 "../src/backgroundTasks.vala"
							_tmp39__length1 = _vala_array_length (_tmp37_);
#line 124 "../src/backgroundTasks.vala"
							_tmp40_ = _tmp39_[1];
#line 124 "../src/backgroundTasks.vala"
							_tmp41_ = cacheFolder;
#line 124 "../src/backgroundTasks.vala"
							_tmp42_ = string_index_of (_tmp40_, _tmp41_, 0) != -1;
#line 124 "../src/backgroundTasks.vala"
							_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
#line 124 "../src/backgroundTasks.vala"
							if (_tmp42_) {
#line 125 "../src/backgroundTasks.vala"
								folderMatched = TRUE;
#line 126 "../src/backgroundTasks.vala"
								_g_free0 (bookData);
#line 126 "../src/backgroundTasks.vala"
								break;
#line 1285 "backgroundTasks.c"
							}
						}
#line 121 "../src/backgroundTasks.vala"
						_g_free0 (bookData);
#line 1290 "backgroundTasks.c"
					}
				}
#line 130 "../src/backgroundTasks.vala"
				if (!folderMatched) {
#line 1295 "backgroundTasks.c"
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					const gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
#line 132 "../src/backgroundTasks.vala"
					_tmp43_ = bookworm_app_bookworm_bookworm_config_path;
#line 132 "../src/backgroundTasks.vala"
					_tmp44_ = g_strconcat ("rm -Rf \"", _tmp43_, NULL);
#line 132 "../src/backgroundTasks.vala"
					_tmp45_ = _tmp44_;
#line 132 "../src/backgroundTasks.vala"
					_tmp46_ = g_strconcat (_tmp45_, "/books/", NULL);
#line 132 "../src/backgroundTasks.vala"
					_tmp47_ = _tmp46_;
#line 132 "../src/backgroundTasks.vala"
					_tmp48_ = cacheFolder;
#line 132 "../src/backgroundTasks.vala"
					_tmp49_ = g_strconcat (_tmp47_, _tmp48_, NULL);
#line 132 "../src/backgroundTasks.vala"
					_tmp50_ = _tmp49_;
#line 132 "../src/backgroundTasks.vala"
					_tmp51_ = g_strconcat (_tmp50_, "\"", NULL);
#line 132 "../src/backgroundTasks.vala"
					_tmp52_ = _tmp51_;
#line 132 "../src/backgroundTasks.vala"
					_tmp53_ = bookworm_app_utils_execute_sync_command (_tmp52_);
#line 132 "../src/backgroundTasks.vala"
					_tmp54_ = _tmp53_;
#line 132 "../src/backgroundTasks.vala"
					_g_free0 (_tmp54_);
#line 132 "../src/backgroundTasks.vala"
					_g_free0 (_tmp52_);
#line 132 "../src/backgroundTasks.vala"
					_g_free0 (_tmp50_);
#line 132 "../src/backgroundTasks.vala"
					_g_free0 (_tmp47_);
#line 132 "../src/backgroundTasks.vala"
					_g_free0 (_tmp45_);
#line 135 "../src/backgroundTasks.vala"
					_tmp55_ = cacheFolder;
#line 135 "../src/backgroundTasks.vala"
					_tmp56_ = g_strconcat ("\nCache Folder deleted:", _tmp55_, NULL);
#line 135 "../src/backgroundTasks.vala"
					_tmp57_ = _tmp56_;
#line 135 "../src/backgroundTasks.vala"
					g_print ("%s", _tmp57_);
#line 135 "../src/backgroundTasks.vala"
					_g_free0 (_tmp57_);
#line 1355 "backgroundTasks.c"
				}
#line 115 "../src/backgroundTasks.vala"
				_g_free0 (cacheFolder);
#line 1359 "backgroundTasks.c"
			}
		}
	}
#line 105 "../src/backgroundTasks.vala"
	cacheFolderList = (_vala_array_free (cacheFolderList, cacheFolderList_length1, (GDestroyNotify) g_free), NULL);
#line 105 "../src/backgroundTasks.vala"
	_g_free0 (cacheFolders);
#line 1367 "backgroundTasks.c"
}

void
bookworm_app_background_tasks_cleanBookCoverImages (void)
{
	gchar* cacheImages = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** cacheImageList = NULL;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint cacheImageList_length1;
	gint _cacheImageList_size_;
	gboolean imageMatched = FALSE;
	gchar** _tmp14_;
	gint _tmp14__length1;
#line 141 "../src/backgroundTasks.vala"
	g_print ("\nStarting to delete un-necessary cover image data...");
#line 143 "../src/backgroundTasks.vala"
	_tmp0_ = bookworm_app_bookworm_bookworm_config_path;
#line 143 "../src/backgroundTasks.vala"
	_tmp1_ = g_strconcat ("ls -1 ", _tmp0_, NULL);
#line 143 "../src/backgroundTasks.vala"
	_tmp2_ = _tmp1_;
#line 143 "../src/backgroundTasks.vala"
	_tmp3_ = g_strconcat (_tmp2_, "/covers/", NULL);
#line 143 "../src/backgroundTasks.vala"
	_tmp4_ = _tmp3_;
#line 143 "../src/backgroundTasks.vala"
	_tmp5_ = bookworm_app_utils_execute_sync_command (_tmp4_);
#line 143 "../src/backgroundTasks.vala"
	_tmp6_ = _tmp5_;
#line 143 "../src/backgroundTasks.vala"
	_g_free0 (_tmp4_);
#line 143 "../src/backgroundTasks.vala"
	_g_free0 (_tmp2_);
#line 143 "../src/backgroundTasks.vala"
	cacheImages = _tmp6_;
#line 146 "../src/backgroundTasks.vala"
	_tmp7_ = cacheImages;
#line 146 "../src/backgroundTasks.vala"
	_tmp8_ = string_replace (_tmp7_, "\r", "^^^");
#line 146 "../src/backgroundTasks.vala"
	_tmp9_ = _tmp8_;
#line 146 "../src/backgroundTasks.vala"
	_tmp10_ = string_replace (_tmp9_, "\n", "^^^");
#line 146 "../src/backgroundTasks.vala"
	_g_free0 (cacheImages);
#line 146 "../src/backgroundTasks.vala"
	cacheImages = _tmp10_;
#line 146 "../src/backgroundTasks.vala"
	_g_free0 (_tmp9_);
#line 147 "../src/backgroundTasks.vala"
	_tmp11_ = cacheImages;
#line 147 "../src/backgroundTasks.vala"
	_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "^^^", 0);
#line 147 "../src/backgroundTasks.vala"
	cacheImageList = _tmp13_;
#line 147 "../src/backgroundTasks.vala"
	cacheImageList_length1 = _vala_array_length (_tmp12_);
#line 147 "../src/backgroundTasks.vala"
	_cacheImageList_size_ = cacheImageList_length1;
#line 149 "../src/backgroundTasks.vala"
	imageMatched = FALSE;
#line 150 "../src/backgroundTasks.vala"
	_tmp14_ = cacheImageList;
#line 150 "../src/backgroundTasks.vala"
	_tmp14__length1 = cacheImageList_length1;
#line 1446 "backgroundTasks.c"
	{
		gchar** cacheImage_collection = NULL;
		gint cacheImage_collection_length1 = 0;
		gint _cacheImage_collection_size_ = 0;
		gint cacheImage_it = 0;
#line 150 "../src/backgroundTasks.vala"
		cacheImage_collection = _tmp14_;
#line 150 "../src/backgroundTasks.vala"
		cacheImage_collection_length1 = _tmp14__length1;
#line 150 "../src/backgroundTasks.vala"
		for (cacheImage_it = 0; cacheImage_it < cacheImage_collection_length1; cacheImage_it = cacheImage_it + 1) {
#line 1458 "backgroundTasks.c"
			gchar* _tmp15_;
			gchar* cacheImage = NULL;
#line 150 "../src/backgroundTasks.vala"
			_tmp15_ = g_strdup (cacheImage_collection[cacheImage_it]);
#line 150 "../src/backgroundTasks.vala"
			cacheImage = _tmp15_;
#line 1465 "backgroundTasks.c"
			{
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gboolean _tmp18_ = FALSE;
				const gchar* _tmp19_;
#line 151 "../src/backgroundTasks.vala"
				imageMatched = FALSE;
#line 152 "../src/backgroundTasks.vala"
				_tmp16_ = cacheImage;
#line 152 "../src/backgroundTasks.vala"
				_tmp17_ = string_strip (_tmp16_);
#line 152 "../src/backgroundTasks.vala"
				_g_free0 (cacheImage);
#line 152 "../src/backgroundTasks.vala"
				cacheImage = _tmp17_;
#line 153 "../src/backgroundTasks.vala"
				_tmp19_ = cacheImage;
#line 153 "../src/backgroundTasks.vala"
				if (_tmp19_ == NULL) {
#line 153 "../src/backgroundTasks.vala"
					_tmp18_ = TRUE;
#line 1487 "backgroundTasks.c"
				} else {
					const gchar* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
#line 153 "../src/backgroundTasks.vala"
					_tmp20_ = cacheImage;
#line 153 "../src/backgroundTasks.vala"
					_tmp21_ = strlen (_tmp20_);
#line 153 "../src/backgroundTasks.vala"
					_tmp22_ = _tmp21_;
#line 153 "../src/backgroundTasks.vala"
					_tmp18_ = _tmp22_ < 1;
#line 1500 "backgroundTasks.c"
				}
#line 153 "../src/backgroundTasks.vala"
				if (_tmp18_) {
#line 154 "../src/backgroundTasks.vala"
					imageMatched = TRUE;
#line 1506 "backgroundTasks.c"
				}
				{
					GeeArrayList* _bookData_list = NULL;
					GeeArrayList* _tmp23_;
					gint _bookData_size = 0;
					GeeArrayList* _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					gint _bookData_index = 0;
#line 156 "../src/backgroundTasks.vala"
					_tmp23_ = bookworm_app_background_tasks_listOfBooks;
#line 156 "../src/backgroundTasks.vala"
					_bookData_list = _tmp23_;
#line 156 "../src/backgroundTasks.vala"
					_tmp24_ = _bookData_list;
#line 156 "../src/backgroundTasks.vala"
					_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
#line 156 "../src/backgroundTasks.vala"
					_tmp26_ = _tmp25_;
#line 156 "../src/backgroundTasks.vala"
					_bookData_size = _tmp26_;
#line 156 "../src/backgroundTasks.vala"
					_bookData_index = -1;
#line 156 "../src/backgroundTasks.vala"
					while (TRUE) {
#line 1532 "backgroundTasks.c"
						gint _tmp27_;
						gint _tmp28_;
						gchar* bookData = NULL;
						GeeArrayList* _tmp29_;
						gpointer _tmp30_;
						gboolean _tmp31_ = FALSE;
						const gchar* _tmp32_;
#line 156 "../src/backgroundTasks.vala"
						_bookData_index = _bookData_index + 1;
#line 156 "../src/backgroundTasks.vala"
						_tmp27_ = _bookData_index;
#line 156 "../src/backgroundTasks.vala"
						_tmp28_ = _bookData_size;
#line 156 "../src/backgroundTasks.vala"
						if (!(_tmp27_ < _tmp28_)) {
#line 156 "../src/backgroundTasks.vala"
							break;
#line 1550 "backgroundTasks.c"
						}
#line 156 "../src/backgroundTasks.vala"
						_tmp29_ = _bookData_list;
#line 156 "../src/backgroundTasks.vala"
						_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _bookData_index);
#line 156 "../src/backgroundTasks.vala"
						bookData = (gchar*) _tmp30_;
#line 157 "../src/backgroundTasks.vala"
						_tmp32_ = cacheImage;
#line 157 "../src/backgroundTasks.vala"
						if (_tmp32_ != NULL) {
#line 1562 "backgroundTasks.c"
							const gchar* _tmp33_;
							gint _tmp34_;
							gint _tmp35_;
#line 157 "../src/backgroundTasks.vala"
							_tmp33_ = cacheImage;
#line 157 "../src/backgroundTasks.vala"
							_tmp34_ = strlen (_tmp33_);
#line 157 "../src/backgroundTasks.vala"
							_tmp35_ = _tmp34_;
#line 157 "../src/backgroundTasks.vala"
							_tmp31_ = _tmp35_ > 0;
#line 1574 "backgroundTasks.c"
						} else {
#line 157 "../src/backgroundTasks.vala"
							_tmp31_ = FALSE;
#line 1578 "backgroundTasks.c"
						}
#line 157 "../src/backgroundTasks.vala"
						if (_tmp31_) {
#line 1582 "backgroundTasks.c"
							const gchar* _tmp36_;
							const gchar* _tmp37_;
							gchar** _tmp38_;
							gchar** _tmp39_;
							gchar** _tmp40_;
							gint _tmp40__length1;
							const gchar* _tmp41_;
							gboolean _tmp42_;
#line 159 "../src/backgroundTasks.vala"
							_tmp36_ = cacheImage;
#line 159 "../src/backgroundTasks.vala"
							_tmp37_ = bookData;
#line 159 "../src/backgroundTasks.vala"
							_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, "::", 0);
#line 159 "../src/backgroundTasks.vala"
							_tmp40_ = _tmp39_;
#line 159 "../src/backgroundTasks.vala"
							_tmp40__length1 = _vala_array_length (_tmp38_);
#line 159 "../src/backgroundTasks.vala"
							_tmp41_ = _tmp40_[0];
#line 159 "../src/backgroundTasks.vala"
							_tmp42_ = string_index_of (_tmp36_, _tmp41_, 0) != -1;
#line 159 "../src/backgroundTasks.vala"
							_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
#line 159 "../src/backgroundTasks.vala"
							if (_tmp42_) {
#line 160 "../src/backgroundTasks.vala"
								imageMatched = TRUE;
#line 161 "../src/backgroundTasks.vala"
								_g_free0 (bookData);
#line 161 "../src/backgroundTasks.vala"
								break;
#line 1615 "backgroundTasks.c"
							}
						}
#line 156 "../src/backgroundTasks.vala"
						_g_free0 (bookData);
#line 1620 "backgroundTasks.c"
					}
				}
#line 165 "../src/backgroundTasks.vala"
				if (!imageMatched) {
#line 1625 "backgroundTasks.c"
					const gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					const gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					const gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
#line 167 "../src/backgroundTasks.vala"
					_tmp43_ = bookworm_app_bookworm_bookworm_config_path;
#line 167 "../src/backgroundTasks.vala"
					_tmp44_ = g_strconcat ("rm -f \"", _tmp43_, NULL);
#line 167 "../src/backgroundTasks.vala"
					_tmp45_ = _tmp44_;
#line 167 "../src/backgroundTasks.vala"
					_tmp46_ = g_strconcat (_tmp45_, "/covers/", NULL);
#line 167 "../src/backgroundTasks.vala"
					_tmp47_ = _tmp46_;
#line 167 "../src/backgroundTasks.vala"
					_tmp48_ = cacheImage;
#line 167 "../src/backgroundTasks.vala"
					_tmp49_ = g_strconcat (_tmp47_, _tmp48_, NULL);
#line 167 "../src/backgroundTasks.vala"
					_tmp50_ = _tmp49_;
#line 167 "../src/backgroundTasks.vala"
					_tmp51_ = g_strconcat (_tmp50_, "\"", NULL);
#line 167 "../src/backgroundTasks.vala"
					_tmp52_ = _tmp51_;
#line 167 "../src/backgroundTasks.vala"
					_tmp53_ = bookworm_app_utils_execute_sync_command (_tmp52_);
#line 167 "../src/backgroundTasks.vala"
					_tmp54_ = _tmp53_;
#line 167 "../src/backgroundTasks.vala"
					_g_free0 (_tmp54_);
#line 167 "../src/backgroundTasks.vala"
					_g_free0 (_tmp52_);
#line 167 "../src/backgroundTasks.vala"
					_g_free0 (_tmp50_);
#line 167 "../src/backgroundTasks.vala"
					_g_free0 (_tmp47_);
#line 167 "../src/backgroundTasks.vala"
					_g_free0 (_tmp45_);
#line 170 "../src/backgroundTasks.vala"
					_tmp55_ = cacheImage;
#line 170 "../src/backgroundTasks.vala"
					_tmp56_ = g_strconcat ("\nCache Image deleted:", _tmp55_, NULL);
#line 170 "../src/backgroundTasks.vala"
					_tmp57_ = _tmp56_;
#line 170 "../src/backgroundTasks.vala"
					g_print ("%s", _tmp57_);
#line 170 "../src/backgroundTasks.vala"
					_g_free0 (_tmp57_);
#line 1685 "backgroundTasks.c"
				}
#line 150 "../src/backgroundTasks.vala"
				_g_free0 (cacheImage);
#line 1689 "backgroundTasks.c"
			}
		}
	}
#line 140 "../src/backgroundTasks.vala"
	cacheImageList = (_vala_array_free (cacheImageList, cacheImageList_length1, (GDestroyNotify) g_free), NULL);
#line 140 "../src/backgroundTasks.vala"
	_g_free0 (cacheImages);
#line 1697 "backgroundTasks.c"
}

BookwormAppBackgroundTasks*
bookworm_app_background_tasks_construct (GType object_type)
{
	BookwormAppBackgroundTasks* self = NULL;
#line 22 "../src/backgroundTasks.vala"
	self = (BookwormAppBackgroundTasks*) g_type_create_instance (object_type);
#line 22 "../src/backgroundTasks.vala"
	return self;
#line 1708 "backgroundTasks.c"
}

BookwormAppBackgroundTasks*
bookworm_app_background_tasks_new (void)
{
#line 22 "../src/backgroundTasks.vala"
	return bookworm_app_background_tasks_construct (BOOKWORM_APP_TYPE_BACKGROUND_TASKS);
#line 1716 "backgroundTasks.c"
}

static void
bookworm_app_value_background_tasks_init (GValue* value)
{
#line 22 "../src/backgroundTasks.vala"
	value->data[0].v_pointer = NULL;
#line 1724 "backgroundTasks.c"
}

static void
bookworm_app_value_background_tasks_free_value (GValue* value)
{
#line 22 "../src/backgroundTasks.vala"
	if (value->data[0].v_pointer) {
#line 22 "../src/backgroundTasks.vala"
		bookworm_app_background_tasks_unref (value->data[0].v_pointer);
#line 1734 "backgroundTasks.c"
	}
}

static void
bookworm_app_value_background_tasks_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
#line 22 "../src/backgroundTasks.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../src/backgroundTasks.vala"
		dest_value->data[0].v_pointer = bookworm_app_background_tasks_ref (src_value->data[0].v_pointer);
#line 1746 "backgroundTasks.c"
	} else {
#line 22 "../src/backgroundTasks.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1750 "backgroundTasks.c"
	}
}

static gpointer
bookworm_app_value_background_tasks_peek_pointer (const GValue* value)
{
#line 22 "../src/backgroundTasks.vala"
	return value->data[0].v_pointer;
#line 1759 "backgroundTasks.c"
}

static gchar*
bookworm_app_value_background_tasks_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
#line 22 "../src/backgroundTasks.vala"
	if (collect_values[0].v_pointer) {
#line 1770 "backgroundTasks.c"
		BookwormAppBackgroundTasks * object;
		object = collect_values[0].v_pointer;
#line 22 "../src/backgroundTasks.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../src/backgroundTasks.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1777 "backgroundTasks.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../src/backgroundTasks.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1781 "backgroundTasks.c"
		}
#line 22 "../src/backgroundTasks.vala"
		value->data[0].v_pointer = bookworm_app_background_tasks_ref (object);
#line 1785 "backgroundTasks.c"
	} else {
#line 22 "../src/backgroundTasks.vala"
		value->data[0].v_pointer = NULL;
#line 1789 "backgroundTasks.c"
	}
#line 22 "../src/backgroundTasks.vala"
	return NULL;
#line 1793 "backgroundTasks.c"
}

static gchar*
bookworm_app_value_background_tasks_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	BookwormAppBackgroundTasks ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../src/backgroundTasks.vala"
	if (!object_p) {
#line 22 "../src/backgroundTasks.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1808 "backgroundTasks.c"
	}
#line 22 "../src/backgroundTasks.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../src/backgroundTasks.vala"
		*object_p = NULL;
#line 1814 "backgroundTasks.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../src/backgroundTasks.vala"
		*object_p = value->data[0].v_pointer;
#line 1818 "backgroundTasks.c"
	} else {
#line 22 "../src/backgroundTasks.vala"
		*object_p = bookworm_app_background_tasks_ref (value->data[0].v_pointer);
#line 1822 "backgroundTasks.c"
	}
#line 22 "../src/backgroundTasks.vala"
	return NULL;
#line 1826 "backgroundTasks.c"
}

GParamSpec*
bookworm_app_param_spec_background_tasks (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	BookwormAppParamSpecBackgroundTasks* spec;
#line 22 "../src/backgroundTasks.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_BACKGROUND_TASKS), NULL);
#line 22 "../src/backgroundTasks.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../src/backgroundTasks.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../src/backgroundTasks.vala"
	return G_PARAM_SPEC (spec);
#line 1845 "backgroundTasks.c"
}

gpointer
bookworm_app_value_get_background_tasks (const GValue* value)
{
#line 22 "../src/backgroundTasks.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_BACKGROUND_TASKS), NULL);
#line 22 "../src/backgroundTasks.vala"
	return value->data[0].v_pointer;
#line 1855 "backgroundTasks.c"
}

void
bookworm_app_value_set_background_tasks (GValue* value,
                                         gpointer v_object)
{
	BookwormAppBackgroundTasks * old;
#line 22 "../src/backgroundTasks.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_BACKGROUND_TASKS));
#line 22 "../src/backgroundTasks.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/backgroundTasks.vala"
	if (v_object) {
#line 22 "../src/backgroundTasks.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_BACKGROUND_TASKS));
#line 22 "../src/backgroundTasks.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/backgroundTasks.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../src/backgroundTasks.vala"
		bookworm_app_background_tasks_ref (value->data[0].v_pointer);
#line 1877 "backgroundTasks.c"
	} else {
#line 22 "../src/backgroundTasks.vala"
		value->data[0].v_pointer = NULL;
#line 1881 "backgroundTasks.c"
	}
#line 22 "../src/backgroundTasks.vala"
	if (old) {
#line 22 "../src/backgroundTasks.vala"
		bookworm_app_background_tasks_unref (old);
#line 1887 "backgroundTasks.c"
	}
}

void
bookworm_app_value_take_background_tasks (GValue* value,
                                          gpointer v_object)
{
	BookwormAppBackgroundTasks * old;
#line 22 "../src/backgroundTasks.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_BACKGROUND_TASKS));
#line 22 "../src/backgroundTasks.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/backgroundTasks.vala"
	if (v_object) {
#line 22 "../src/backgroundTasks.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_BACKGROUND_TASKS));
#line 22 "../src/backgroundTasks.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/backgroundTasks.vala"
		value->data[0].v_pointer = v_object;
#line 1908 "backgroundTasks.c"
	} else {
#line 22 "../src/backgroundTasks.vala"
		value->data[0].v_pointer = NULL;
#line 1912 "backgroundTasks.c"
	}
#line 22 "../src/backgroundTasks.vala"
	if (old) {
#line 22 "../src/backgroundTasks.vala"
		bookworm_app_background_tasks_unref (old);
#line 1918 "backgroundTasks.c"
	}
}

static void
bookworm_app_background_tasks_class_init (BookwormAppBackgroundTasksClass * klass,
                                          gpointer klass_data)
{
#line 22 "../src/backgroundTasks.vala"
	bookworm_app_background_tasks_parent_class = g_type_class_peek_parent (klass);
#line 22 "../src/backgroundTasks.vala"
	((BookwormAppBackgroundTasksClass *) klass)->finalize = bookworm_app_background_tasks_finalize;
#line 1930 "backgroundTasks.c"
}

static void
bookworm_app_background_tasks_instance_init (BookwormAppBackgroundTasks * self,
                                             gpointer klass)
{
#line 22 "../src/backgroundTasks.vala"
	self->ref_count = 1;
#line 1939 "backgroundTasks.c"
}

static void
bookworm_app_background_tasks_finalize (BookwormAppBackgroundTasks * obj)
{
	BookwormAppBackgroundTasks * self;
#line 22 "../src/backgroundTasks.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_BACKGROUND_TASKS, BookwormAppBackgroundTasks);
#line 22 "../src/backgroundTasks.vala"
	g_signal_handlers_destroy (self);
#line 1950 "backgroundTasks.c"
}

static GType
bookworm_app_background_tasks_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_background_tasks_init, bookworm_app_value_background_tasks_free_value, bookworm_app_value_background_tasks_copy_value, bookworm_app_value_background_tasks_peek_pointer, "p", bookworm_app_value_background_tasks_collect_value, "p", bookworm_app_value_background_tasks_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppBackgroundTasksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_background_tasks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppBackgroundTasks), 0, (GInstanceInitFunc) bookworm_app_background_tasks_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_background_tasks_type_id;
	bookworm_app_background_tasks_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppBackgroundTasks", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_background_tasks_type_id;
}

GType
bookworm_app_background_tasks_get_type (void)
{
	static volatile gsize bookworm_app_background_tasks_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_background_tasks_type_id__once)) {
		GType bookworm_app_background_tasks_type_id;
		bookworm_app_background_tasks_type_id = bookworm_app_background_tasks_get_type_once ();
		g_once_init_leave (&bookworm_app_background_tasks_type_id__once, bookworm_app_background_tasks_type_id);
	}
	return bookworm_app_background_tasks_type_id__once;
}

gpointer
bookworm_app_background_tasks_ref (gpointer instance)
{
	BookwormAppBackgroundTasks * self;
	self = instance;
#line 22 "../src/backgroundTasks.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../src/backgroundTasks.vala"
	return instance;
#line 1985 "backgroundTasks.c"
}

void
bookworm_app_background_tasks_unref (gpointer instance)
{
	BookwormAppBackgroundTasks * self;
	self = instance;
#line 22 "../src/backgroundTasks.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../src/backgroundTasks.vala"
		BOOKWORM_APP_BACKGROUND_TASKS_GET_CLASS (self)->finalize (self);
#line 22 "../src/backgroundTasks.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1999 "backgroundTasks.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

