/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0004J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/util/DumpInvalidTipsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "dumpInvalidTips", "tips", "", "Lcom/intellij/ide/util/TipAndTrickBean;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.platform.tips"})
@SourceDebugExtension(value={"SMAP\nDumpInvalidTipsActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DumpInvalidTipsActions.kt\ncom/intellij/ide/util/DumpInvalidTipsAction\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n42#2,10:103\n1617#3,9:113\n1869#3:122\n1870#3:124\n1626#3:125\n1#4:123\n*S KotlinDebug\n*F\n+ 1 DumpInvalidTipsActions.kt\ncom/intellij/ide/util/DumpInvalidTipsAction\n*L\n23#1:103,10\n35#1:113,9\n35#1:122\n35#1:124\n35#1:125\n35#1:123\n*E\n"})
public class DumpInvalidTipsAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void title$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = "Analyzing tips";
        Project project$iv = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, this){
            final /* synthetic */ DumpInvalidTipsAction this$0;
            {
                this.this$0 = dumpInvalidTipsAction;
                super($project, $title, $cancellable);
            }

            /*
             * WARNING - void declaration
             */
            public void run(ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                ProductivityFeaturesRegistry productivityFeaturesRegistry = ProductivityFeaturesRegistry.getInstance();
                if (productivityFeaturesRegistry == null) {
                    throw new IllegalStateException("ProductivityFeaturesRegistry is not created".toString());
                }
                ProductivityFeaturesRegistry registry = productivityFeaturesRegistry;
                Set set = registry.getFeatureIds();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFeatureIds(...)");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    TipAndTrickBean tipAndTrickBean;
                    void id;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String tipId = registry.getFeatureDescriptor((String)id).getTipId();
                    TipAndTrickBean it2 = tipAndTrickBean = new TipAndTrickBean();
                    boolean bl3 = false;
                    it2.fileName = tipId + ".html";
                    collection.add(tipAndTrickBean);
                }
                List productivityGuideTips = (List)destination$iv$iv;
                Iterable $this$distinctBy$iv = CollectionsKt.plus((Collection)TipAndTrickBean.EP_NAME.getExtensionList(), (Iterable)productivityGuideTips);
                boolean $i$f$distinctBy = false;
                HashSet<String> set$iv = new HashSet<String>();
                ArrayList<T> list$iv = new ArrayList<T>();
                for (T e$iv : $this$distinctBy$iv) {
                    TipAndTrickBean receiver = (TipAndTrickBean)e$iv;
                    boolean bl4 = false;
                    String key$iv = receiver.fileName;
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                List allTips = list$iv;
                this.this$0.dumpInvalidTips(allTips);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected final void dumpInvalidTips(@NotNull List<TipAndTrickBean> tips) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(tips, (String)"tips");
        Iterable $this$mapNotNull$iv = tips;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TipAndTrickBean tip = (TipAndTrickBean)element$iv$iv;
            boolean bl2 = false;
            try {
                TipUtils.INSTANCE.loadAndParseTipStrict(tip);
                pair = null;
            }
            catch (Throwable throwable) {
                pair = TuplesKt.to((Object)tip, (Object)throwable);
            }
            if (pair == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List tipToError = (List)destination$iv$iv;
        StringBuilder builder = new StringBuilder();
        if (tipToError.isEmpty()) {
            builder.append("There is no invalid tips among " + tips.size() + " listed");
        } else {
            builder.append("Found following problems during tips loading and parsing:\n");
            int n = ((Collection)tipToError).size();
            for (int ind = 0; ind < n; ++ind) {
                Pair pair = (Pair)tipToError.get(ind);
                TipAndTrickBean tip = (TipAndTrickBean)pair.component1();
                Throwable throwable = (Throwable)pair.component2();
                String string = throwable.getMessage();
                String message = (string != null ? StringsKt.startsWith$default((String)string, (String)"Warning:", (boolean)false, (int)2, null) : false) ? throwable.getMessage() : ExceptionsKt.stackTraceToString((Throwable)throwable);
                String string2 = tip.fileName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileName");
                builder.append(ind + 1 + ". " + StringsKt.substringAfterLast$default((String)string2, (String)"/", null, (int)2, null) + "\n" + message + "\n");
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String issues = string;
        LOG.warn(issues);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(issues));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    static {
        Logger logger = Logger.getInstance(DumpInvalidTipsAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/util/DumpInvalidTipsAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.tips"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

