/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.webTypes.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@JsonDeserialize(using=MyDeserializer.class)
public class Priority {
    private Object value;

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static enum PriorityLevel {
        LOWEST("lowest"),
        LOW("low"),
        NORMAL("normal"),
        HIGH("high"),
        HIGHEST("highest");

        private final String value;
        private static final Map<String, PriorityLevel> CONSTANTS;

        private PriorityLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static PriorityLevel fromValue(String value) {
            PriorityLevel constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, PriorityLevel>();
            for (PriorityLevel c : PriorityLevel.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static class MyDeserializer
    extends JsonDeserializer<Priority> {
        public Priority deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
            Priority result2 = new Priority();
            JsonToken token = parser.currentToken();
            if (token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT) {
                result2.value = parser.readValueAs(Double.class);
            } else if (token == JsonToken.VALUE_STRING) {
                result2.value = parser.readValueAs(PriorityLevel.class);
            } else {
                deserializationContext.handleUnexpectedToken(Object.class, parser);
            }
            return result2;
        }
    }
}

