/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependenciesRootsEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.util.JpsPathUtil;

public final class ProjectPaths {
    private ProjectPaths() {
    }

    @NotNull
    public static Collection<File> getCompilationClasspathFiles(ModuleChunk chunk, boolean includeTests, boolean excludeMainModuleOutput, boolean exportedOnly) {
        return ProjectPaths.getClasspathFiles(chunk, JpsJavaClasspathKind.compile((boolean)includeTests), excludeMainModuleOutput, ClasspathPart.WHOLE, exportedOnly);
    }

    @NotNull
    public static Collection<File> getPlatformCompilationClasspath(ModuleChunk chunk, boolean excludeMainModuleOutput) {
        return ProjectPaths.getClasspathFiles(chunk, JpsJavaClasspathKind.compile((boolean)chunk.containsTests()), excludeMainModuleOutput, ClasspathPart.BEFORE_PLUS_JDK, true);
    }

    @NotNull
    public static Collection<File> getCompilationClasspath(ModuleChunk chunk, boolean excludeMainModuleOutput) {
        return ProjectPaths.getClasspathFiles(chunk, JpsJavaClasspathKind.compile((boolean)chunk.containsTests()), excludeMainModuleOutput, ClasspathPart.AFTER_JDK, true);
    }

    @NotNull
    public static Collection<File> getCompilationModulePath(ModuleChunk chunk, boolean excludeMainModuleOutput) {
        return ProjectPaths.getClasspathFiles(chunk, JpsJavaClasspathKind.compile((boolean)chunk.containsTests()), excludeMainModuleOutput, ClasspathPart.AFTER_JDK, false);
    }

    @NotNull
    private static Collection<File> getClasspathFiles(ModuleChunk chunk, JpsJavaClasspathKind kind, boolean excludeMainModuleOutput, ClasspathPart classpathPart, boolean exportedOnly) {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (JpsModule module : chunk.getModules()) {
            JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)module).includedIn(kind).recursively();
            if (exportedOnly) {
                enumerator = enumerator.exportedOnly();
            }
            if (classpathPart == ClasspathPart.BEFORE_JDK || classpathPart == ClasspathPart.BEFORE_PLUS_JDK) {
                enumerator = enumerator.satisfying((Condition)new BeforeJavaSdkItemFilter(module));
            } else if (classpathPart == ClasspathPart.AFTER_JDK) {
                enumerator = enumerator.satisfying((Condition)new AfterJavaSdkItemFilter(module));
            }
            JpsJavaDependenciesRootsEnumerator rootsEnumerator = enumerator.classes();
            if (excludeMainModuleOutput) {
                rootsEnumerator = rootsEnumerator.withoutSelfModuleOutput();
            }
            files.addAll(rootsEnumerator.getRoots());
        }
        if (classpathPart == ClasspathPart.BEFORE_PLUS_JDK) {
            for (JpsModule module : chunk.getModules()) {
                JpsSdk sdk = module.getSdk((JpsSdkType)JpsJavaSdkType.INSTANCE);
                if (sdk == null) continue;
                files.addAll(sdk.getParent().getFiles(JpsOrderRootType.COMPILED));
            }
        }
        LinkedHashSet<File> linkedHashSet = files;
        if (linkedHashSet == null) {
            ProjectPaths.$$$reportNull$$$0(0);
        }
        return linkedHashSet;
    }

    private static void addFile(Set<? super File> classpath, @Nullable String url) {
        if (url != null) {
            classpath.add(JpsPathUtil.urlToFile((String)url));
        }
    }

    @NotNull
    public static Map<File, String> getSourceRootsWithDependents(ModuleChunk chunk) {
        boolean includeTests = chunk.containsTests();
        LinkedHashMap<File, String> result = new LinkedHashMap<File, String>();
        ProjectPaths.processModulesRecursively(chunk, JpsJavaClasspathKind.compile((boolean)includeTests), (Consumer<? super JpsModule>)((Consumer)module -> {
            for (JpsModuleSourceRoot root : module.getSourceRoots()) {
                if (!root.getRootType().equals((Object)JavaSourceRootType.SOURCE) && (!includeTests || !root.getRootType().equals((Object)JavaSourceRootType.TEST_SOURCE))) continue;
                Object prefix = ((JavaSourceRootProperties)root.getProperties()).getPackagePrefix();
                if (!((String)prefix).isEmpty()) {
                    if (!((String)(prefix = ((String)prefix).replace('.', '/'))).endsWith("/")) {
                        prefix = (String)prefix + "/";
                    }
                } else {
                    prefix = null;
                }
                result.put(JpsPathUtil.urlToFile((String)root.getUrl()), (String)prefix);
            }
        }));
        LinkedHashMap<File, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            ProjectPaths.$$$reportNull$$$0(1);
        }
        return linkedHashMap;
    }

    public static Collection<File> getOutputPathsWithDependents(ModuleChunk chunk) {
        boolean forTests = chunk.containsTests();
        LinkedHashSet<File> sourcePaths = new LinkedHashSet<File>();
        ProjectPaths.processModulesRecursively(chunk, JpsJavaClasspathKind.compile((boolean)forTests), (Consumer<? super JpsModule>)((Consumer)module -> ProjectPaths.addFile(sourcePaths, JpsJavaExtensionService.getInstance().getOutputUrl(module, forTests))));
        return sourcePaths;
    }

    private static void processModulesRecursively(ModuleChunk chunk, JpsJavaClasspathKind kind, Consumer<? super JpsModule> processor) {
        JpsJavaExtensionService.getInstance().enumerateDependencies(chunk.getModules()).includedIn(kind).recursively().processModules(processor);
    }

    @Nullable
    public static File getModuleOutputDir(JpsModule module, boolean forTests) {
        return JpsJavaExtensionService.getInstance().getOutputDirectory(module, forTests);
    }

    @Nullable
    public static File getAnnotationProcessorGeneratedSourcesOutputDir(JpsModule module, boolean forTests, ProcessorConfigProfile profile) {
        String sourceDirName = profile.getGeneratedSourcesDirectoryName(forTests);
        if (profile.isOutputRelativeToContentRoot()) {
            ArrayList roots = module.getContentRootsList().getUrls();
            if (roots.isEmpty()) {
                return null;
            }
            if (roots.size() > 1) {
                roots = new ArrayList(roots);
                roots.sort(Comparator.naturalOrder());
            }
            File parent = JpsPathUtil.urlToFile((String)((String)roots.get(0)));
            return StringUtil.isEmpty((String)sourceDirName) ? parent : new File(parent, sourceDirName);
        }
        File outputDir = ProjectPaths.getModuleOutputDir(module, forTests);
        if (outputDir == null) {
            return null;
        }
        return StringUtil.isEmpty((String)sourceDirName) ? outputDir : new File(outputDir, sourceDirName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/ProjectPaths";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootsWithDependents";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static enum ClasspathPart {
        WHOLE,
        BEFORE_JDK,
        BEFORE_PLUS_JDK,
        AFTER_JDK;

    }

    private static final class BeforeJavaSdkItemFilter
    implements Condition<JpsDependencyElement> {
        private final JpsModule myModule;
        private boolean mySdkFound;

        private BeforeJavaSdkItemFilter(JpsModule module) {
            this.myModule = module;
        }

        public boolean value(JpsDependencyElement dependency) {
            boolean isJavaSdk;
            boolean bl = isJavaSdk = dependency instanceof JpsSdkDependency && ((JpsSdkDependency)dependency).getSdkType().equals(JpsJavaSdkType.INSTANCE);
            if (this.myModule.equals((Object)dependency.getContainingModule()) && isJavaSdk) {
                this.mySdkFound = true;
            }
            return !this.mySdkFound && !isJavaSdk;
        }
    }

    private static final class AfterJavaSdkItemFilter
    implements Condition<JpsDependencyElement> {
        private final JpsModule myModule;
        private boolean mySdkFound;

        private AfterJavaSdkItemFilter(JpsModule module) {
            this.myModule = module;
        }

        public boolean value(JpsDependencyElement dependency) {
            if (this.myModule.equals((Object)dependency.getContainingModule()) && dependency instanceof JpsSdkDependency && ((JpsSdkDependency)dependency).getSdkType().equals(JpsJavaSdkType.INSTANCE)) {
                this.mySdkFound = true;
                return false;
            }
            return this.mySdkFound;
        }
    }
}

