/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.modelSerialization;

import com.intellij.gradle.toolingExtension.impl.modelSerialization.DefaultSerializationService;
import com.intellij.gradle.toolingExtension.impl.modelSerialization.SerializationServiceNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ServiceLoader;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.util.ClassMap;

@ApiStatus.Internal
public final class ToolingSerializer {
    private final DefaultSerializationService myDefaultSerializationService;
    private final ClassMap<SerializationService<?>> mySerializationServices;
    @Nullable
    private final ClassLoader myModelBuildersClassLoader;

    public ToolingSerializer() {
        this(null);
    }

    public ToolingSerializer(@Nullable ClassLoader modelBuildersClassLoader) {
        this.myModelBuildersClassLoader = modelBuildersClassLoader;
        this.myDefaultSerializationService = new DefaultSerializationService();
        this.mySerializationServices = new ClassMap();
        ClassLoader clientOwnedDaemonPayloadLoader = this.getClass().getClassLoader();
        if (modelBuildersClassLoader != null) {
            try {
                Class<?> serializationServiceClass = modelBuildersClassLoader.loadClass(SerializationService.class.getName());
                for (final Object serializationService : ServiceLoader.load(serializationServiceClass, modelBuildersClassLoader)) {
                    SerializationService proxyService = (SerializationService)Proxy.newProxyInstance(SerializationService.class.getClassLoader(), new Class[]{SerializationService.class}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Method m = serializationService.getClass().getMethod(method.getName(), method.getParameterTypes());
                            return m.invoke(serializationService, args);
                        }
                    });
                    try {
                        this.register(proxyService);
                    }
                    catch (Throwable throwable) {}
                }
                ToolingSerializer.addModelBuildersClassLoaderUrlsToTapiClientClassloader(modelBuildersClassLoader, clientOwnedDaemonPayloadLoader);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (SerializationService serializerService : ServiceLoader.load(SerializationService.class, clientOwnedDaemonPayloadLoader)) {
            this.register(serializerService);
        }
    }

    public byte[] write(@NotNull Object object) throws IOException, SerializationServiceNotFoundException {
        Object unpackedObject;
        Class<?> unpackedObjectClass;
        if (object == null) {
            ToolingSerializer.$$$reportNull$$$0(0);
        }
        if (this.myModelBuildersClassLoader != null && this.myModelBuildersClassLoader == (unpackedObjectClass = (unpackedObject = ToolingSerializer.maybeUnpack(object)).getClass()).getClassLoader()) {
            return this.getService(unpackedObjectClass, true).write(unpackedObject, unpackedObjectClass);
        }
        Class<?> modelClazz = object.getClass();
        return this.getService(modelClazz, false).write(object, modelClazz);
    }

    @Nullable
    public <T> T read(byte @NotNull [] object, @NotNull Class<T> modelClazz) throws IOException, SerializationServiceNotFoundException {
        if (modelClazz == null) {
            ToolingSerializer.$$$reportNull$$$0(1);
        }
        if (object == null) {
            ToolingSerializer.$$$reportNull$$$0(2);
        }
        assert (this.myModelBuildersClassLoader == null);
        return (T)this.getService(modelClazz, true).read(object, modelClazz);
    }

    @NotNull
    private <T> SerializationService<T> getService(@NotNull Class<T> modelClazz, boolean useDefaultSerializer) throws SerializationServiceNotFoundException {
        SerializationService service;
        if (modelClazz == null) {
            ToolingSerializer.$$$reportNull$$$0(3);
        }
        if ((service = (SerializationService)this.mySerializationServices.get(modelClazz)) != null) {
            SerializationService serializationService = service;
            if (serializationService == null) {
                ToolingSerializer.$$$reportNull$$$0(4);
            }
            return serializationService;
        }
        if (useDefaultSerializer) {
            DefaultSerializationService defaultSerializationService = this.myDefaultSerializationService;
            if (defaultSerializationService == null) {
                ToolingSerializer.$$$reportNull$$$0(5);
            }
            return defaultSerializationService;
        }
        throw new SerializationServiceNotFoundException(modelClazz);
    }

    @NotNull
    private static Object maybeUnpack(@NotNull Object object) {
        Object object2;
        if (object == null) {
            ToolingSerializer.$$$reportNull$$$0(6);
        }
        try {
            object2 = new ProtocolToModelAdapter().unpack(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object object3 = object;
            if (object3 == null) {
                ToolingSerializer.$$$reportNull$$$0(8);
            }
            return object3;
        }
        if (object2 == null) {
            ToolingSerializer.$$$reportNull$$$0(7);
        }
        return object2;
    }

    private void register(@NotNull SerializationService<?> serializerService) {
        if (serializerService == null) {
            ToolingSerializer.$$$reportNull$$$0(9);
        }
        this.mySerializationServices.put(serializerService.getModelClass(), serializerService);
    }

    private static void addModelBuildersClassLoaderUrlsToTapiClientClassloader(@NotNull ClassLoader modelBuildersClassLoader, @NotNull ClassLoader clientOwnedDaemonPayloadLoader) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method addURLMethod;
        if (modelBuildersClassLoader == null) {
            ToolingSerializer.$$$reportNull$$$0(10);
        }
        if (clientOwnedDaemonPayloadLoader == null) {
            ToolingSerializer.$$$reportNull$$$0(11);
        }
        if ((addURLMethod = ToolingSerializer.findMethodIncludingSuperclasses(clientOwnedDaemonPayloadLoader.getClass(), "addURL", URL.class)) != null) {
            URL[] modelBuildersClassLoaderUrls;
            addURLMethod.setAccessible(true);
            for (URL url : modelBuildersClassLoaderUrls = (URL[])modelBuildersClassLoader.getClass().getMethod("getURLs", new Class[0]).invoke((Object)modelBuildersClassLoader, new Object[0])) {
                addURLMethod.invoke((Object)clientOwnedDaemonPayloadLoader, url);
            }
        }
    }

    @Nullable
    private static Method findMethodIncludingSuperclasses(Class<?> clazz, String name, Class<?> ... parameterType) {
        try {
            return clazz.getDeclaredMethod(name, parameterType);
        }
        catch (NoSuchMethodException var5) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                return ToolingSerializer.findMethodIncludingSuperclasses(superclass, name, parameterType);
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClazz";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/modelSerialization/ToolingSerializer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializerService";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBuildersClassLoader";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientOwnedDaemonPayloadLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/modelSerialization/ToolingSerializer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "maybeUnpack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "maybeUnpack";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addModelBuildersClassLoaderUrlsToTapiClientClassloader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

