/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.templateLanguages.TemplateLanguage;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.StubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

@ApiStatus.Internal
public class StubBuilderType {
    private static final Logger LOG = Logger.getInstance(StubBuilderType.class);
    private final IStubFileElementType myElementType;
    private final List<String> myProperties;
    private final BinaryFileStubBuilder myBinaryFileStubBuilder;
    private final Object myBinarySubBuilder;

    StubBuilderType(@NotNull IStubFileElementType elementType, @NotNull List<String> properties2) {
        if (elementType == null) {
            StubBuilderType.$$$reportNull$$$0(0);
        }
        if (properties2 == null) {
            StubBuilderType.$$$reportNull$$$0(1);
        }
        this.myElementType = elementType;
        this.myProperties = properties2;
        this.myBinaryFileStubBuilder = null;
        this.myBinarySubBuilder = null;
    }

    StubBuilderType(@NotNull BinaryFileStubBuilder binaryFileStubBuilder) {
        if (binaryFileStubBuilder == null) {
            StubBuilderType.$$$reportNull$$$0(2);
        }
        this.myElementType = null;
        this.myBinaryFileStubBuilder = binaryFileStubBuilder;
        this.myBinarySubBuilder = null;
        this.myProperties = Collections.emptyList();
    }

    StubBuilderType(@NotNull BinaryFileStubBuilder.CompositeBinaryFileStubBuilder binaryFileStubBuilder, @Nullable Object binarySubBuilder) {
        if (binaryFileStubBuilder == null) {
            StubBuilderType.$$$reportNull$$$0(3);
        }
        this.myElementType = null;
        this.myBinaryFileStubBuilder = binaryFileStubBuilder;
        this.myBinarySubBuilder = binarySubBuilder;
        this.myProperties = Collections.emptyList();
    }

    @NotNull
    Class<?> getClassToBlameInCaseOfException() {
        if (this.myElementType != null) {
            Class<?> clazz = this.myElementType.getClass();
            if (clazz == null) {
                StubBuilderType.$$$reportNull$$$0(4);
            }
            return clazz;
        }
        if (this.myBinarySubBuilder == null) {
            Class<?> clazz = this.myBinaryFileStubBuilder.getClass();
            if (clazz == null) {
                StubBuilderType.$$$reportNull$$$0(5);
            }
            return clazz;
        }
        Class<?> clazz = this.myBinarySubBuilder.getClass();
        if (clazz == null) {
            StubBuilderType.$$$reportNull$$$0(6);
        }
        return clazz;
    }

    BinaryFileStubBuilder getBinaryFileStubBuilder() {
        return this.myBinaryFileStubBuilder;
    }

    public IStubFileElementType getStubFileElementType() {
        return this.myElementType;
    }

    public String getVersion() {
        if (this.myElementType != null) {
            int templateStubBaseVersion;
            int elementTypeStubVersion = this.myElementType.getStubVersion();
            if (this.myElementType.getLanguage() instanceof TemplateLanguage && elementTypeStubVersion < (templateStubBaseVersion = IStubFileElementType.getTemplateStubBaseVersion())) {
                PluginException.logPluginError(LOG, this.myElementType.getClass() + " " + this.myElementType.getLanguage() + " version=" + elementTypeStubVersion + "  stub version should call super.getStubVersion()  template stub version=" + templateStubBaseVersion, null, this.myElementType.getClass());
            }
            String baseVersion = this.myElementType.getExternalId() + ":" + elementTypeStubVersion + ":" + this.myElementType.getDebugName();
            return this.myProperties.isEmpty() ? baseVersion : baseVersion + ":" + StringUtil.join(this.myProperties, ",");
        }
        assert (this.myBinaryFileStubBuilder != null);
        String baseVersion = this.myBinaryFileStubBuilder.getClass().getName() + ":" + this.myBinaryFileStubBuilder.getStubVersion();
        if (this.myBinaryFileStubBuilder instanceof BinaryFileStubBuilder.CompositeBinaryFileStubBuilder) {
            return baseVersion + ":" + ((BinaryFileStubBuilder.CompositeBinaryFileStubBuilder)this.myBinaryFileStubBuilder).getSubBuilderVersion(this.myBinarySubBuilder);
        }
        return baseVersion;
    }

    @NotNull
    public static List<StubFileElementType<?>> getStubFileElementTypeFromVersion(@NotNull String version2) {
        String externalId;
        List<StubFileElementType<?>> matches;
        int externalIdDelimPos;
        if (version2 == null) {
            StubBuilderType.$$$reportNull$$$0(7);
        }
        if ((externalIdDelimPos = version2.indexOf(58)) == -1) {
            LOG.error("Version info is incomplete: " + version2);
            externalIdDelimPos = version2.length();
        }
        if ((matches = ContainerUtil.map(IElementType.enumerate(arg_0 -> StubBuilderType.lambda$getStubFileElementTypeFromVersion$0(externalId = version2.substring(0, externalIdDelimPos), arg_0)), p2 -> (StubFileElementType)p2)).size() > 1) {
            int stubVersionDelimPos = version2.indexOf(58, externalIdDelimPos + 1);
            if (stubVersionDelimPos == -1) {
                LOG.error("Version info is incomplete: " + version2);
                List<StubFileElementType<?>> list = matches;
                if (list == null) {
                    StubBuilderType.$$$reportNull$$$0(8);
                }
                return list;
            }
            int debugNameDelimPos = version2.indexOf(58, stubVersionDelimPos + 1);
            if (debugNameDelimPos == -1) {
                debugNameDelimPos = version2.length();
            }
            String debugName = version2.substring(stubVersionDelimPos + 1, debugNameDelimPos);
            matches = ContainerUtil.filter(matches, p2 -> p2.getDebugName().equals(debugName));
        }
        List<StubFileElementType<?>> list = matches;
        if (list == null) {
            StubBuilderType.$$$reportNull$$$0(9);
        }
        return list;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        StubBuilderType type = (StubBuilderType)o2;
        return Objects.equals(this.myElementType, type.myElementType) && Objects.equals(this.myBinaryFileStubBuilder, type.myBinaryFileStubBuilder) && Objects.equals(this.myProperties, type.myProperties) && Objects.equals(this.myBinarySubBuilder, type.myBinarySubBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.myElementType, this.myBinaryFileStubBuilder, this.myBinarySubBuilder, this.myProperties);
    }

    private static /* synthetic */ boolean lambda$getStubFileElementTypeFromVersion$0(String externalId, IElementType p2) {
        return p2 instanceof StubFileElementType && ((StubFileElementType)p2).getExternalId().equals(externalId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFileStubBuilder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBuilderType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/StubBuilderType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassToBlameInCaseOfException";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubFileElementTypeFromVersion";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStubFileElementTypeFromVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

