/* Generated by wayland-scanner 1.23.1 */

#ifndef EXT_TRANSIENT_SEAT_V1_CLIENT_PROTOCOL_H
#define EXT_TRANSIENT_SEAT_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ext_transient_seat_v1 The ext_transient_seat_v1 protocol
 * protocol for creating temporary seats
 *
 * @section page_desc_ext_transient_seat_v1 Description
 *
 * The transient seat protocol can be used by privileged clients to create
 * independent seats that will be removed from the compositor when the client
 * destroys its transient seat.
 *
 * This protocol is intended for use with virtual input protocols such as
 * "virtual_keyboard_unstable_v1" or "wlr_virtual_pointer_unstable_v1", both
 * of which allow the user to select a seat.
 *
 * The "wl_seat" global created by this protocol does not generate input events
 * on its own, or have any capabilities except those assigned to it by other
 * protocol extensions, such as the ones mentioned above.
 *
 * For example, a remote desktop server can create a seat with virtual inputs
 * for each remote user by following these steps for each new connection:
 * * Create a transient seat
 * * Wait for the transient seat to be created
 * * Locate a "wl_seat" global with a matching name
 * * Create virtual inputs using the resulting "wl_seat" global
 *
 * @section page_ifaces_ext_transient_seat_v1 Interfaces
 * - @subpage page_iface_ext_transient_seat_manager_v1 - transient seat manager
 * - @subpage page_iface_ext_transient_seat_v1 - transient seat handle
 * @section page_copyright_ext_transient_seat_v1 Copyright
 * <pre>
 *
 * Copyright © 2020 - 2023 Andri Yngvason
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct ext_transient_seat_manager_v1;
struct ext_transient_seat_v1;

#ifndef EXT_TRANSIENT_SEAT_MANAGER_V1_INTERFACE
#define EXT_TRANSIENT_SEAT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ext_transient_seat_manager_v1 ext_transient_seat_manager_v1
 * @section page_iface_ext_transient_seat_manager_v1_desc Description
 *
 * The transient seat manager creates short-lived seats.
 * @section page_iface_ext_transient_seat_manager_v1_api API
 * See @ref iface_ext_transient_seat_manager_v1.
 */
/**
 * @defgroup iface_ext_transient_seat_manager_v1 The ext_transient_seat_manager_v1 interface
 *
 * The transient seat manager creates short-lived seats.
 */
extern const struct wl_interface ext_transient_seat_manager_v1_interface;
#endif
#ifndef EXT_TRANSIENT_SEAT_V1_INTERFACE
#define EXT_TRANSIENT_SEAT_V1_INTERFACE
/**
 * @page page_iface_ext_transient_seat_v1 ext_transient_seat_v1
 * @section page_iface_ext_transient_seat_v1_desc Description
 *
 * When the transient seat handle is destroyed, the seat itself will also be
 * destroyed.
 * @section page_iface_ext_transient_seat_v1_api API
 * See @ref iface_ext_transient_seat_v1.
 */
/**
 * @defgroup iface_ext_transient_seat_v1 The ext_transient_seat_v1 interface
 *
 * When the transient seat handle is destroyed, the seat itself will also be
 * destroyed.
 */
extern const struct wl_interface ext_transient_seat_v1_interface;
#endif

#define EXT_TRANSIENT_SEAT_MANAGER_V1_CREATE 0
#define EXT_TRANSIENT_SEAT_MANAGER_V1_DESTROY 1


/**
 * @ingroup iface_ext_transient_seat_manager_v1
 */
#define EXT_TRANSIENT_SEAT_MANAGER_V1_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_transient_seat_manager_v1
 */
#define EXT_TRANSIENT_SEAT_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ext_transient_seat_manager_v1 */
static inline void
ext_transient_seat_manager_v1_set_user_data(struct ext_transient_seat_manager_v1 *ext_transient_seat_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_transient_seat_manager_v1, user_data);
}

/** @ingroup iface_ext_transient_seat_manager_v1 */
static inline void *
ext_transient_seat_manager_v1_get_user_data(struct ext_transient_seat_manager_v1 *ext_transient_seat_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_transient_seat_manager_v1);
}

static inline uint32_t
ext_transient_seat_manager_v1_get_version(struct ext_transient_seat_manager_v1 *ext_transient_seat_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_transient_seat_manager_v1);
}

/**
 * @ingroup iface_ext_transient_seat_manager_v1
 *
 * Create a new seat that is removed when the client side transient seat
 * object is destroyed.
 *
 * The actual seat may be removed sooner, in which case the transient seat
 * object shall become inert.
 */
static inline struct ext_transient_seat_v1 *
ext_transient_seat_manager_v1_create(struct ext_transient_seat_manager_v1 *ext_transient_seat_manager_v1)
{
	struct wl_proxy *seat;

	seat = wl_proxy_marshal_flags((struct wl_proxy *) ext_transient_seat_manager_v1,
			 EXT_TRANSIENT_SEAT_MANAGER_V1_CREATE, &ext_transient_seat_v1_interface, wl_proxy_get_version((struct wl_proxy *) ext_transient_seat_manager_v1), 0, NULL);

	return (struct ext_transient_seat_v1 *) seat;
}

/**
 * @ingroup iface_ext_transient_seat_manager_v1
 *
 * Destroy the manager.
 *
 * All objects created by the manager will remain valid until they are
 * destroyed themselves.
 */
static inline void
ext_transient_seat_manager_v1_destroy(struct ext_transient_seat_manager_v1 *ext_transient_seat_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_transient_seat_manager_v1,
			 EXT_TRANSIENT_SEAT_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_transient_seat_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ext_transient_seat_v1
 * @struct ext_transient_seat_v1_listener
 */
struct ext_transient_seat_v1_listener {
	/**
	 * transient seat is ready
	 *
	 * This event advertises the global name for the wl_seat to be
	 * used with wl_registry_bind.
	 *
	 * It is sent exactly once, immediately after the transient seat is
	 * created and the new "wl_seat" global is advertised, if and only
	 * if the creation of the transient seat was allowed.
	 */
	void (*ready)(void *data,
		      struct ext_transient_seat_v1 *ext_transient_seat_v1,
		      uint32_t global_name);
	/**
	 * transient seat creation denied
	 *
	 * The event informs the client that the compositor denied its
	 * request to create a transient seat.
	 *
	 * It is sent exactly once, immediately after the transient seat
	 * object is created, if and only if the creation of the transient
	 * seat was denied.
	 *
	 * After receiving this event, the client should destroy the
	 * object.
	 */
	void (*denied)(void *data,
		       struct ext_transient_seat_v1 *ext_transient_seat_v1);
};

/**
 * @ingroup iface_ext_transient_seat_v1
 */
static inline int
ext_transient_seat_v1_add_listener(struct ext_transient_seat_v1 *ext_transient_seat_v1,
				   const struct ext_transient_seat_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ext_transient_seat_v1,
				     (void (**)(void)) listener, data);
}

#define EXT_TRANSIENT_SEAT_V1_DESTROY 0

/**
 * @ingroup iface_ext_transient_seat_v1
 */
#define EXT_TRANSIENT_SEAT_V1_READY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_transient_seat_v1
 */
#define EXT_TRANSIENT_SEAT_V1_DENIED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_transient_seat_v1
 */
#define EXT_TRANSIENT_SEAT_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ext_transient_seat_v1 */
static inline void
ext_transient_seat_v1_set_user_data(struct ext_transient_seat_v1 *ext_transient_seat_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_transient_seat_v1, user_data);
}

/** @ingroup iface_ext_transient_seat_v1 */
static inline void *
ext_transient_seat_v1_get_user_data(struct ext_transient_seat_v1 *ext_transient_seat_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_transient_seat_v1);
}

static inline uint32_t
ext_transient_seat_v1_get_version(struct ext_transient_seat_v1 *ext_transient_seat_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_transient_seat_v1);
}

/**
 * @ingroup iface_ext_transient_seat_v1
 *
 * When the transient seat object is destroyed by the client, the
 * associated seat created by the compositor is also destroyed.
 */
static inline void
ext_transient_seat_v1_destroy(struct ext_transient_seat_v1 *ext_transient_seat_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_transient_seat_v1,
			 EXT_TRANSIENT_SEAT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_transient_seat_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
