/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */


#define SWIG_VERSION 0x040400
#define SWIGJAVA
#define SWIG_DIRECTORS

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if defined(__GNUC__)
#  if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#    ifndef GCC_HASCLASSVISIBILITY
#      define GCC_HASCLASSVISIBILITY
#    endif
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif

#if defined(__cplusplus) && __cplusplus >=201103L
# define SWIG_NOEXCEPT noexcept
#else
# define SWIG_NOEXCEPT throw()
#endif 

/* -----------------------------------------------------------------------------
 * swigcompat.swg
 *
 * Macros to provide support compatibility with older C and C++ standards.
 *
 * Note that SWIG expects __cplusplus to be defined to the appropriate C++ standard.
 * MSVC users are urged to check and examine the /Zc:__cplusplus compiler option.
 * See https://learn.microsoft.com/en-us/cpp/build/reference/zc-cplusplus.
 * ----------------------------------------------------------------------------- */

/* C99 and C++11 should provide snprintf, but define SWIG_NO_SNPRINTF
 * if you're missing it.
 */
#if ((defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L) || \
     (defined __cplusplus && __cplusplus >= 201103L) || \
     defined SWIG_HAVE_SNPRINTF) && \
    !defined SWIG_NO_SNPRINTF
# define SWIG_snprintf(O,S,F,A) snprintf(O,S,F,A)
# define SWIG_snprintf2(O,S,F,A,B) snprintf(O,S,F,A,B)
#else
/* Fallback versions ignore the buffer size, but most of our uses either have a
 * fixed maximum possible size or dynamically allocate a buffer that's large
 * enough.
 */
# define SWIG_snprintf(O,S,F,A) sprintf(O,F,A)
# define SWIG_snprintf2(O,S,F,A,B) sprintf(O,F,A,B)
#endif


#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1,
  SWIG_JavaIOException,
  SWIG_JavaRuntimeException,
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError,
  SWIG_JavaIllegalStateException,
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { SWIG_JavaIllegalStateException, "java/lang/IllegalStateException" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) do { if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } } while (0)

/* SWIG Errors applicable to all language modules, values are reserved from -1 to -99 */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13


/* -----------------------------------------------------------------------------
 * director_common.swg
 *
 * This file contains support for director classes which is common between
 * languages.
 * ----------------------------------------------------------------------------- */

/*
  Use -DSWIG_DIRECTOR_STATIC if you prefer to avoid the use of the
  'Swig' namespace. This could be useful for multi-modules projects.
*/
#ifdef SWIG_DIRECTOR_STATIC
/* Force anonymous (static) namespace */
#define Swig
#endif
/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes so that Java proxy
 * methods can be called from C++.
 * ----------------------------------------------------------------------------- */

#if defined(DEBUG_DIRECTOR_OWNED) || defined(DEBUG_DIRECTOR_EXCEPTION) || defined(DEBUG_DIRECTOR_THREAD_NAME)
#include <iostream>
#endif

#include <exception>

#if defined(SWIG_JAVA_USE_THREAD_NAME)

#if !defined(SWIG_JAVA_GET_THREAD_NAME)
namespace Swig {
  SWIGINTERN int GetThreadName(char *name, size_t len);
}

#if defined(__linux__)

#include <sys/prctl.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
#if defined(PR_GET_NAME)
  return prctl(PR_GET_NAME, (unsigned long)name, 0, 0, 0);
#else
  (void)name;
  return 1;
#endif
}

#elif defined(__unix__) || defined(__APPLE__)

#include <pthread.h>
SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  return pthread_getname_np(pthread_self(), name, len);
}

#else

SWIGINTERN int Swig::GetThreadName(char *name, size_t len) {
  (void)len;
  (void)name;
  return 1;
}
#endif

#endif

#endif

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
#include <pthread.h>
#endif

namespace Swig {

  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else {
	/* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
    static void detach(void *jvm) {
      static_cast<JavaVM *>(jvm)->DetachCurrentThread();
    }

    static void make_detach_key() {
      pthread_key_create(&detach_key_, detach);
    }

    /* thread-local key to register a destructor */
    static pthread_key_t detach_key_;
#endif

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
  pthread_key_t JObjectWrapper::detach_key_;
#endif

  /* Local JNI reference deleter */
  class LocalRefGuard {
    JNIEnv *jenv_;
    jobject jobj_;

    // non-copyable
    LocalRefGuard(const LocalRefGuard &);
    LocalRefGuard &operator=(const LocalRefGuard &);
  public:
    LocalRefGuard(JNIEnv *jenv, jobject jobj): jenv_(jenv), jobj_(jobj) {}
    ~LocalRefGuard() {
      if (jobj_)
        jenv_->DeleteLocalRef(jobj_);
    }
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(NULL), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
        JavaVMAttachArgs args;
        args.version = JNI_VERSION_1_2;
        args.group = NULL;
        args.name = NULL;
#if defined(SWIG_JAVA_USE_THREAD_NAME)
        char thread_name[64];  // MAX_TASK_COMM_LEN=16 is hard-coded in the Linux kernel and MacOS has MAXTHREADNAMESIZE=64.
        if (Swig::GetThreadName(thread_name, sizeof(thread_name)) == 0) {
          args.name = thread_name;
#if defined(DEBUG_DIRECTOR_THREAD_NAME)
          std::cout << "JNIEnvWrapper: thread name: " << thread_name << std::endl;
        } else {
          std::cout << "JNIEnvWrapper: Couldn't set Java thread name" << std::endl;
#endif
        }
#endif
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, &args);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, &args);
#endif

#if defined(SWIG_JAVA_DETACH_ON_THREAD_END)
        // At least on Android 6, detaching after every call causes a memory leak.
        // Instead, register a thread desructor and detach only when the thread ends.
        // See https://developer.android.com/training/articles/perf-jni#threads
        static pthread_once_t once = PTHREAD_ONCE_INIT;

        pthread_once(&once, JObjectWrapper::make_detach_key);
        pthread_setspecific(JObjectWrapper::detach_key_, director->swig_jvm_);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_DETACH_ON_THREAD_END) && !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    struct SwigDirectorMethod {
      const char *name;
      const char *desc;
      jmethodID methid;
      SwigDirectorMethod(JNIEnv *jenv, jclass baseclass, const char *name, const char *desc) : name(name), desc(desc) {
        methid = jenv->GetMethodID(baseclass, name, desc);
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
      LocalRefGuard ref_deleter(jenv, jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
    }

    jclass swig_new_global_ref(JNIEnv *jenv, const char *classname) {
      jclass clz = jenv->FindClass(classname);
      return clz ? (jclass)jenv->NewGlobalRef(clz) : NULL;
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };

  // Zero initialized bool array
  template<size_t N> class BoolArray {
    bool array_[N];
  public:
    BoolArray() {
      memset(array_, 0, sizeof(array_));
    }
    bool& operator[](size_t n) {
      return array_[n];
    }
    bool operator[](size_t n) const {
      return array_[n];
    }
  };

  // Utility classes and functions for exception handling.

  // Simple holder for a Java string during exception handling, providing access to a c-style string
  class JavaString {
  public:
    JavaString(JNIEnv *jenv, jstring jstr) : jenv_(jenv), jstr_(jstr), cstr_(NULL) {
      if (jenv_ && jstr_)
	cstr_ = (const char *) jenv_->GetStringUTFChars(jstr_, NULL);
    }

    ~JavaString() {
      if (jenv_ && jstr_ && cstr_)
	jenv_->ReleaseStringUTFChars(jstr_, cstr_);
    }

    const char *c_str(const char *null_string = "null JavaString") const {
      return cstr_ ? cstr_ : null_string;
    }

  private:
    // non-copyable
    JavaString(const JavaString &);
    JavaString &operator=(const JavaString &);

    JNIEnv *jenv_;
    jstring jstr_;
    const char *cstr_;
  };

  // Helper class to extract the exception message from a Java throwable
  class JavaExceptionMessage {
  public:
    JavaExceptionMessage(JNIEnv *jenv, jthrowable throwable) : message_(jenv, exceptionMessageFromThrowable(jenv, throwable)) {
    }

    // Return a C string of the exception message in the jthrowable passed in the constructor
    // If no message is available, null_string is return instead
    const char *message(const char *null_string = "Could not get exception message in JavaExceptionMessage") const {
      return message_.c_str(null_string);
    }

  private:
    // non-copyable
    JavaExceptionMessage(const JavaExceptionMessage &);
    JavaExceptionMessage &operator=(const JavaExceptionMessage &);

    // Get exception message by calling Java method Throwable.getMessage()
    static jstring exceptionMessageFromThrowable(JNIEnv *jenv, jthrowable throwable) {
      jstring jmsg = NULL;
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  // All Throwable classes have a getMessage() method, so call it to extract the exception message
	  jmethodID getMessageMethodID = jenv->GetMethodID(throwclz, "getMessage", "()Ljava/lang/String;");
	  if (getMessageMethodID)
	    jmsg = (jstring)jenv->CallObjectMethod(throwable, getMessageMethodID);
	}
	if (jmsg == NULL && jenv->ExceptionCheck())
	  jenv->ExceptionClear();
      }
      return jmsg;
    }

    JavaString message_;
  };

  // C++ Exception class for handling Java exceptions thrown during a director method Java upcall
  class DirectorException : public std::exception {
  public:

    // Construct exception from a Java throwable
    DirectorException(JNIEnv *jenv, jthrowable throwable) : jenv_(jenv), throwable_(throwable), classname_(NULL), msg_(NULL) {

      // Call Java method Object.getClass().getName() to obtain the throwable's class name (delimited by '/')
      if (jenv && throwable) {
	jenv->ExceptionClear(); // Cannot invoke methods with any pending exceptions
	jclass throwclz = jenv->GetObjectClass(throwable);
	if (throwclz) {
	  jclass clzclz = jenv->GetObjectClass(throwclz);
	  if (clzclz) {
	    jmethodID getNameMethodID = jenv->GetMethodID(clzclz, "getName", "()Ljava/lang/String;");
	    if (getNameMethodID) {
	      jstring jstr_classname = (jstring)(jenv->CallObjectMethod(throwclz, getNameMethodID));
              // Copy strings, since there is no guarantee that jenv will be active when handled
              if (jstr_classname) {
                JavaString jsclassname(jenv, jstr_classname);
                const char *classname = jsclassname.c_str(NULL);
                if (classname)
                  classname_ = copypath(classname);
              }
	    }
	  }
	}
      }

      JavaExceptionMessage exceptionmsg(jenv, throwable);
      msg_ = copystr(exceptionmsg.message(NULL));
    }

    // More general constructor for handling as a java.lang.RuntimeException
    DirectorException(const char *msg) : jenv_(NULL), throwable_(NULL), classname_(NULL), msg_(msg ? copystr(msg) : NULL) {
    }

    ~DirectorException() SWIG_NOEXCEPT {
      delete[] classname_;
      delete[] msg_;
    }

    const char *what() const SWIG_NOEXCEPT {
      return msg_ ? msg_ : "Unspecified DirectorException message";
    }

    // Reconstruct and raise/throw the Java Exception that caused the DirectorException
    // Note that any error in the JNI exception handling results in a Java RuntimeException
    void throwException(JNIEnv *jenv) const {
      if (jenv) {
        if (jenv == jenv_ && throwable_) {
          // Throw original exception if not already pending
          jthrowable throwable = jenv->ExceptionOccurred();
          if (throwable && jenv->IsSameObject(throwable, throwable_) == JNI_FALSE) {
            jenv->ExceptionClear();
            throwable = NULL;
          }
          if (!throwable)
            jenv->Throw(throwable_);
        } else {
          // Try and reconstruct original exception, but original stacktrace is not reconstructed
          jenv->ExceptionClear();

          jmethodID ctorMethodID = NULL;
          jclass throwableclass = NULL;
          if (classname_) {
            throwableclass = jenv->FindClass(classname_);
            if (throwableclass)
              ctorMethodID = jenv->GetMethodID(throwableclass, "<init>", "(Ljava/lang/String;)V");
          }

          if (ctorMethodID) {
            jenv->ThrowNew(throwableclass, what());
          } else {
            SWIG_JavaThrowException(jenv, SWIG_JavaRuntimeException, what());
          }
        }
      }
    }

    // Deprecated - use throwException
    void raiseJavaException(JNIEnv *jenv) const {
      throwException(jenv);
    }

    // Create and throw the DirectorException
    static void raise(JNIEnv *jenv, jthrowable throwable) {
      throw DirectorException(jenv, throwable);
    }

  private:
    static char *copypath(const char *srcmsg) {
      char *target = copystr(srcmsg);
      for (char *c=target; *c; ++c) {
        if ('.' == *c)
          *c = '/';
      }
      return target;
    }

    static char *copystr(const char *srcmsg) {
      char *target = NULL;
      if (srcmsg) {
	size_t msglen = strlen(srcmsg) + 1;
	target = new char[msglen];
	strncpy(target, srcmsg, msglen);
      }
      return target;
    }

    JNIEnv *jenv_;
    jthrowable throwable_;
    const char *classname_;
    const char *msg_;
  };

  // Helper method to determine if a Java throwable matches a particular Java class type
  // Note side effect of clearing any pending exceptions
  SWIGINTERN bool ExceptionMatches(JNIEnv *jenv, jthrowable throwable, const char *classname) {
    bool matches = false;

    if (throwable && jenv && classname) {
      // Exceptions need to be cleared for correct behavior.
      // The caller of ExceptionMatches should restore pending exceptions if desired -
      // the caller already has the throwable.
      jenv->ExceptionClear();

      jclass clz = jenv->FindClass(classname);
      if (clz) {
	jclass classclz = jenv->GetObjectClass(clz);
	jmethodID isInstanceMethodID = jenv->GetMethodID(classclz, "isInstance", "(Ljava/lang/Object;)Z");
	if (isInstanceMethodID) {
	  matches = jenv->CallBooleanMethod(clz, isInstanceMethodID, throwable) != 0;
	}
      }

#if defined(DEBUG_DIRECTOR_EXCEPTION)
      if (jenv->ExceptionCheck()) {
        // Typically occurs when an invalid classname argument is passed resulting in a ClassNotFoundException
        JavaExceptionMessage exc(jenv, jenv->ExceptionOccurred());
        std::cout << "Error: ExceptionMatches: class '" << classname << "' : " << exc.message() << std::endl;
      }
#endif
    }
    return matches;
  }
}

namespace Swig {
  namespace {
    jclass jclass_SimpleITKJNI = NULL;
    jmethodID director_method_ids[3];
  }
}

#ifdef __cplusplus
#include <utility>
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigSmartPointer {
    T *ptr;
    SwigSmartPointer(T *p) : ptr(p) { }
    ~SwigSmartPointer() { delete ptr; }
    SwigSmartPointer& operator=(SwigSmartPointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
    void reset(T *p) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = p; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigSmartPointer tmp(new T(t)); pointer = tmp; return *this; }
#if __cplusplus >=201103L
  SwigValueWrapper& operator=(T&& t) { SwigSmartPointer tmp(new T(std::move(t))); pointer = tmp; return *this; }
  operator T&&() const { return std::move(*pointer.ptr); }
#else
  operator T&() const { return *pointer.ptr; }
#endif
  T *operator&() const { return pointer.ptr; }
  static void reset(SwigValueWrapper& t, T *p) { t.pointer.reset(p); }
};

/*
 * SwigValueInit() is a generic initialisation solution as the following approach:
 * 
 *       T c_result = T();
 * 
 * doesn't compile for all types for example:
 * 
 *       unsigned int c_result = unsigned int();
 */
template <typename T> T SwigValueInit() {
  return T();
}

#if __cplusplus >=201103L
# define SWIG_STD_MOVE(OBJ) std::move(OBJ)
#else
# define SWIG_STD_MOVE(OBJ) OBJ
#endif

#endif


#include <typeinfo>
#include <stdexcept>


#include <vector>
#include <stdexcept>


#include <string>


#include <map>
#include <stdexcept>


#include <stdint.h>		// Use the C99 official header


#include <limits.h>
#if !defined(SWIG_NO_LLONG_MAX)
# if !defined(LLONG_MAX) && defined(__GNUC__) && defined (__LONG_LONG_MAX__)
#   define LLONG_MAX __LONG_LONG_MAX__
#   define LLONG_MIN (-LLONG_MAX - 1LL)
#   define ULLONG_MAX (LLONG_MAX * 2ULL + 1ULL)
# endif
#endif


#if !defined(SWIG_NO_WORDSIZE64_CHECK)
#if (__WORDSIZE == 32) || (LONG_MAX == INT_MAX)
# error "SWIG generated code is invalid on this 32-bit architecture, please regenerate without defining SWIGWORDSIZE64 or define SWIGWORDSIZE32"
#endif
#endif


SWIGINTERN void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_NullReferenceError:
    exception_code = SWIG_JavaNullPointerException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}


#include <typeinfo>
#include <stdexcept>


#include <SimpleITK.h>
#include <sitkImageOperators.h>



/* Check for overflow converting to Java int (always signed 32-bit) from (unsigned variable-bit) size_t */
SWIGINTERN jint SWIG_JavaIntFromSize_t(size_t size) {
  static const jint JINT_MAX = 0x7FFFFFFF;
  return (size > (size_t)JINT_MAX) ? -1 : (jint)size;
}


SWIGINTERN jint SWIG_VectorSize(size_t size) {
  jint sz = SWIG_JavaIntFromSize_t(size);
  if (sz == -1)
    throw std::out_of_range("vector size is too large to fit into a Java int");
  return sz;
}

SWIGINTERN std::vector< bool > *new_std_vector_Sl_bool_Sg___SWIG_2(jint count,bool const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< bool >(static_cast<std::vector< bool >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_bool_Sg__doCapacity(std::vector< bool > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_bool_Sg__doReserve(std::vector< bool > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_bool_Sg__doSize(std::vector< bool > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_bool_Sg__doAdd__SWIG_0(std::vector< bool > *self,std::vector< bool >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_bool_Sg__doAdd__SWIG_1(std::vector< bool > *self,jint index,std::vector< bool >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< bool >::value_type std_vector_Sl_bool_Sg__doRemove(std::vector< bool > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          bool const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN bool std_vector_Sl_bool_Sg__doGet(std::vector< bool > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< bool >::value_type std_vector_Sl_bool_Sg__doSet(std::vector< bool > *self,jint index,std::vector< bool >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          bool const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_bool_Sg__doRemoveRange(std::vector< bool > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< uint8_t > *new_std_vector_Sl_uint8_t_Sg___SWIG_2(jint count,unsigned char const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< unsigned char >(static_cast<std::vector< unsigned char >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_uint8_t_Sg__doCapacity(std::vector< uint8_t > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_uint8_t_Sg__doReserve(std::vector< uint8_t > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_uint8_t_Sg__doSize(std::vector< uint8_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_uint8_t_Sg__doAdd__SWIG_0(std::vector< uint8_t > *self,std::vector< unsigned char >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_uint8_t_Sg__doAdd__SWIG_1(std::vector< uint8_t > *self,jint index,std::vector< unsigned char >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned char >::value_type std_vector_Sl_uint8_t_Sg__doRemove(std::vector< uint8_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          unsigned char const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned char >::value_type const &std_vector_Sl_uint8_t_Sg__doGet(std::vector< uint8_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< unsigned char >::value_type std_vector_Sl_uint8_t_Sg__doSet(std::vector< uint8_t > *self,jint index,std::vector< unsigned char >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          unsigned char const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_uint8_t_Sg__doRemoveRange(std::vector< uint8_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int8_t > *new_std_vector_Sl_int8_t_Sg___SWIG_2(jint count,signed char const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< signed char >(static_cast<std::vector< signed char >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_int8_t_Sg__doCapacity(std::vector< int8_t > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_int8_t_Sg__doReserve(std::vector< int8_t > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_int8_t_Sg__doSize(std::vector< int8_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_int8_t_Sg__doAdd__SWIG_0(std::vector< int8_t > *self,std::vector< signed char >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_int8_t_Sg__doAdd__SWIG_1(std::vector< int8_t > *self,jint index,std::vector< signed char >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< signed char >::value_type std_vector_Sl_int8_t_Sg__doRemove(std::vector< int8_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          signed char const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< signed char >::value_type const &std_vector_Sl_int8_t_Sg__doGet(std::vector< int8_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< signed char >::value_type std_vector_Sl_int8_t_Sg__doSet(std::vector< int8_t > *self,jint index,std::vector< signed char >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          signed char const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_int8_t_Sg__doRemoveRange(std::vector< int8_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< uint16_t > *new_std_vector_Sl_uint16_t_Sg___SWIG_2(jint count,unsigned short const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< unsigned short >(static_cast<std::vector< unsigned short >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_uint16_t_Sg__doCapacity(std::vector< uint16_t > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_uint16_t_Sg__doReserve(std::vector< uint16_t > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_uint16_t_Sg__doSize(std::vector< uint16_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_uint16_t_Sg__doAdd__SWIG_0(std::vector< uint16_t > *self,std::vector< unsigned short >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_uint16_t_Sg__doAdd__SWIG_1(std::vector< uint16_t > *self,jint index,std::vector< unsigned short >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned short >::value_type std_vector_Sl_uint16_t_Sg__doRemove(std::vector< uint16_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          unsigned short const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned short >::value_type const &std_vector_Sl_uint16_t_Sg__doGet(std::vector< uint16_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< unsigned short >::value_type std_vector_Sl_uint16_t_Sg__doSet(std::vector< uint16_t > *self,jint index,std::vector< unsigned short >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          unsigned short const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_uint16_t_Sg__doRemoveRange(std::vector< uint16_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int16_t > *new_std_vector_Sl_int16_t_Sg___SWIG_2(jint count,short const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< short >(static_cast<std::vector< short >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_int16_t_Sg__doCapacity(std::vector< int16_t > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_int16_t_Sg__doReserve(std::vector< int16_t > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_int16_t_Sg__doSize(std::vector< int16_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_int16_t_Sg__doAdd__SWIG_0(std::vector< int16_t > *self,std::vector< short >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_int16_t_Sg__doAdd__SWIG_1(std::vector< int16_t > *self,jint index,std::vector< short >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< short >::value_type std_vector_Sl_int16_t_Sg__doRemove(std::vector< int16_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          short const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< short >::value_type const &std_vector_Sl_int16_t_Sg__doGet(std::vector< int16_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< short >::value_type std_vector_Sl_int16_t_Sg__doSet(std::vector< int16_t > *self,jint index,std::vector< short >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          short const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_int16_t_Sg__doRemoveRange(std::vector< int16_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< uint32_t > *new_std_vector_Sl_uint32_t_Sg___SWIG_2(jint count,unsigned int const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< unsigned int >(static_cast<std::vector< unsigned int >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_uint32_t_Sg__doCapacity(std::vector< uint32_t > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_uint32_t_Sg__doReserve(std::vector< uint32_t > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_uint32_t_Sg__doSize(std::vector< uint32_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_uint32_t_Sg__doAdd__SWIG_0(std::vector< uint32_t > *self,std::vector< unsigned int >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_uint32_t_Sg__doAdd__SWIG_1(std::vector< uint32_t > *self,jint index,std::vector< unsigned int >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned int >::value_type std_vector_Sl_uint32_t_Sg__doRemove(std::vector< uint32_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          unsigned int const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned int >::value_type const &std_vector_Sl_uint32_t_Sg__doGet(std::vector< uint32_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< unsigned int >::value_type std_vector_Sl_uint32_t_Sg__doSet(std::vector< uint32_t > *self,jint index,std::vector< unsigned int >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          unsigned int const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_uint32_t_Sg__doRemoveRange(std::vector< uint32_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int32_t > *new_std_vector_Sl_int32_t_Sg___SWIG_2(jint count,int const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< int >(static_cast<std::vector< int >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_int32_t_Sg__doCapacity(std::vector< int32_t > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_int32_t_Sg__doReserve(std::vector< int32_t > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_int32_t_Sg__doSize(std::vector< int32_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_int32_t_Sg__doAdd__SWIG_0(std::vector< int32_t > *self,std::vector< int >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_int32_t_Sg__doAdd__SWIG_1(std::vector< int32_t > *self,jint index,std::vector< int >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int >::value_type std_vector_Sl_int32_t_Sg__doRemove(std::vector< int32_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          int const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int >::value_type const &std_vector_Sl_int32_t_Sg__doGet(std::vector< int32_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< int >::value_type std_vector_Sl_int32_t_Sg__doSet(std::vector< int32_t > *self,jint index,std::vector< int >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          int const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_int32_t_Sg__doRemoveRange(std::vector< int32_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< uint64_t > *new_std_vector_Sl_uint64_t_Sg___SWIG_2(jint count,unsigned long const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< unsigned long >(static_cast<std::vector< unsigned long >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_uint64_t_Sg__doCapacity(std::vector< uint64_t > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_uint64_t_Sg__doReserve(std::vector< uint64_t > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_uint64_t_Sg__doSize(std::vector< uint64_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_uint64_t_Sg__doAdd__SWIG_0(std::vector< uint64_t > *self,std::vector< unsigned long >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_uint64_t_Sg__doAdd__SWIG_1(std::vector< uint64_t > *self,jint index,std::vector< unsigned long >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned long >::value_type std_vector_Sl_uint64_t_Sg__doRemove(std::vector< uint64_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          unsigned long const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< unsigned long >::value_type const &std_vector_Sl_uint64_t_Sg__doGet(std::vector< uint64_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< unsigned long >::value_type std_vector_Sl_uint64_t_Sg__doSet(std::vector< uint64_t > *self,jint index,std::vector< unsigned long >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          unsigned long const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_uint64_t_Sg__doRemoveRange(std::vector< uint64_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< int64_t > *new_std_vector_Sl_int64_t_Sg___SWIG_2(jint count,long const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< long >(static_cast<std::vector< long >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_int64_t_Sg__doCapacity(std::vector< int64_t > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_int64_t_Sg__doReserve(std::vector< int64_t > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_int64_t_Sg__doSize(std::vector< int64_t > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_int64_t_Sg__doAdd__SWIG_0(std::vector< int64_t > *self,std::vector< long >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_int64_t_Sg__doAdd__SWIG_1(std::vector< int64_t > *self,jint index,std::vector< long >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< long >::value_type std_vector_Sl_int64_t_Sg__doRemove(std::vector< int64_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          long const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< long >::value_type const &std_vector_Sl_int64_t_Sg__doGet(std::vector< int64_t > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< long >::value_type std_vector_Sl_int64_t_Sg__doSet(std::vector< int64_t > *self,jint index,std::vector< long >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          long const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_int64_t_Sg__doRemoveRange(std::vector< int64_t > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< float > *new_std_vector_Sl_float_Sg___SWIG_2(jint count,float const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< float >(static_cast<std::vector< float >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_float_Sg__doCapacity(std::vector< float > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_float_Sg__doReserve(std::vector< float > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_float_Sg__doSize(std::vector< float > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_float_Sg__doAdd__SWIG_0(std::vector< float > *self,std::vector< float >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_float_Sg__doAdd__SWIG_1(std::vector< float > *self,jint index,std::vector< float >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< float >::value_type std_vector_Sl_float_Sg__doRemove(std::vector< float > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          float const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< float >::value_type const &std_vector_Sl_float_Sg__doGet(std::vector< float > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< float >::value_type std_vector_Sl_float_Sg__doSet(std::vector< float > *self,jint index,std::vector< float >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          float const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_float_Sg__doRemoveRange(std::vector< float > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< double > *new_std_vector_Sl_double_Sg___SWIG_2(jint count,double const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< double >(static_cast<std::vector< double >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_double_Sg__doCapacity(std::vector< double > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_double_Sg__doReserve(std::vector< double > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_double_Sg__doSize(std::vector< double > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_double_Sg__doAdd__SWIG_0(std::vector< double > *self,std::vector< double >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_double_Sg__doAdd__SWIG_1(std::vector< double > *self,jint index,std::vector< double >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< double >::value_type std_vector_Sl_double_Sg__doRemove(std::vector< double > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          double const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< double >::value_type const &std_vector_Sl_double_Sg__doGet(std::vector< double > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< double >::value_type std_vector_Sl_double_Sg__doSet(std::vector< double > *self,jint index,std::vector< double >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          double const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_double_Sg__doRemoveRange(std::vector< double > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< itk::simple::Image > *new_std_vector_Sl_itk_simple_Image_Sg___SWIG_2(jint count,itk::simple::Image const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< itk::simple::Image >(static_cast<std::vector< itk::simple::Image >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_itk_simple_Image_Sg__doCapacity(std::vector< itk::simple::Image > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_itk_simple_Image_Sg__doReserve(std::vector< itk::simple::Image > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_itk_simple_Image_Sg__doSize(std::vector< itk::simple::Image > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_itk_simple_Image_Sg__doAdd__SWIG_0(std::vector< itk::simple::Image > *self,std::vector< itk::simple::Image >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_itk_simple_Image_Sg__doAdd__SWIG_1(std::vector< itk::simple::Image > *self,jint index,std::vector< itk::simple::Image >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< itk::simple::Image >::value_type std_vector_Sl_itk_simple_Image_Sg__doRemove(std::vector< itk::simple::Image > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          itk::simple::Image const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< itk::simple::Image >::value_type const &std_vector_Sl_itk_simple_Image_Sg__doGet(std::vector< itk::simple::Image > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< itk::simple::Image >::value_type std_vector_Sl_itk_simple_Image_Sg__doSet(std::vector< itk::simple::Image > *self,jint index,std::vector< itk::simple::Image >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          itk::simple::Image const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_itk_simple_Image_Sg__doRemoveRange(std::vector< itk::simple::Image > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< itk::simple::Transform > *new_std_vector_Sl_itk_simple_Transform_Sg___SWIG_2(jint count,itk::simple::Transform const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< itk::simple::Transform >(static_cast<std::vector< itk::simple::Transform >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_itk_simple_Transform_Sg__doCapacity(std::vector< itk::simple::Transform > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_itk_simple_Transform_Sg__doReserve(std::vector< itk::simple::Transform > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_itk_simple_Transform_Sg__doSize(std::vector< itk::simple::Transform > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_itk_simple_Transform_Sg__doAdd__SWIG_0(std::vector< itk::simple::Transform > *self,std::vector< itk::simple::Transform >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_itk_simple_Transform_Sg__doAdd__SWIG_1(std::vector< itk::simple::Transform > *self,jint index,std::vector< itk::simple::Transform >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< itk::simple::Transform >::value_type std_vector_Sl_itk_simple_Transform_Sg__doRemove(std::vector< itk::simple::Transform > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          itk::simple::Transform const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< itk::simple::Transform >::value_type const &std_vector_Sl_itk_simple_Transform_Sg__doGet(std::vector< itk::simple::Transform > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< itk::simple::Transform >::value_type std_vector_Sl_itk_simple_Transform_Sg__doSet(std::vector< itk::simple::Transform > *self,jint index,std::vector< itk::simple::Transform >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          itk::simple::Transform const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_itk_simple_Transform_Sg__doRemoveRange(std::vector< itk::simple::Transform > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< unsigned int > > *new_std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg___SWIG_2(jint count,std::vector< unsigned int > const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::vector< unsigned int > >(static_cast<std::vector< std::vector< unsigned int > >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doCapacity(std::vector< std::vector< unsigned int > > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doReserve(std::vector< std::vector< unsigned int > > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doSize(std::vector< std::vector< unsigned int > > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doAdd__SWIG_0(std::vector< std::vector< unsigned int > > *self,std::vector< std::vector< unsigned int > >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doAdd__SWIG_1(std::vector< std::vector< unsigned int > > *self,jint index,std::vector< std::vector< unsigned int > >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< unsigned int > >::value_type std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doRemove(std::vector< std::vector< unsigned int > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::vector< unsigned int > const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::vector< unsigned int > >::value_type const &std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doGet(std::vector< std::vector< unsigned int > > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::vector< unsigned int > >::value_type std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doSet(std::vector< std::vector< unsigned int > > *self,jint index,std::vector< std::vector< unsigned int > >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::vector< unsigned int > const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doRemoveRange(std::vector< std::vector< unsigned int > > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string > *new_std_vector_Sl_std_string_Sg___SWIG_2(jint count,std::string const &value){
        if (count < 0)
          throw std::out_of_range("vector count must be positive");
        return new std::vector< std::string >(static_cast<std::vector< std::string >::size_type>(count), value);
      }
SWIGINTERN jint std_vector_Sl_std_string_Sg__doCapacity(std::vector< std::string > *self){
        return SWIG_VectorSize(self->capacity());
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doReserve(std::vector< std::string > *self,jint n){
        if (n < 0)
          throw std::out_of_range("vector reserve size must be positive");
        self->reserve(n);
      }
SWIGINTERN jint std_vector_Sl_std_string_Sg__doSize(std::vector< std::string > const *self){
        return SWIG_VectorSize(self->size());
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doAdd__SWIG_0(std::vector< std::string > *self,std::vector< std::string >::value_type const &x){
        self->push_back(x);
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doAdd__SWIG_1(std::vector< std::string > *self,jint index,std::vector< std::string >::value_type const &x){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index <= size) {
          self->insert(self->begin() + index, x);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string >::value_type std_vector_Sl_std_string_Sg__doRemove(std::vector< std::string > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (0 <= index && index < size) {
          std::string const old_value = (*self)[index];
          self->erase(self->begin() + index);
          return old_value;
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::vector< std::string >::value_type const &std_vector_Sl_std_string_Sg__doGet(std::vector< std::string > *self,jint index){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size)
          return (*self)[index];
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN std::vector< std::string >::value_type std_vector_Sl_std_string_Sg__doSet(std::vector< std::string > *self,jint index,std::vector< std::string >::value_type const &val){
        jint size = static_cast<jint>(self->size());
        if (index >= 0 && index < size) {
          std::string const old_value = (*self)[index];
          (*self)[index] = val;
          return old_value;
        }
        else
          throw std::out_of_range("vector index out of range");
      }
SWIGINTERN void std_vector_Sl_std_string_Sg__doRemoveRange(std::vector< std::string > *self,jint fromIndex,jint toIndex){
        jint size = static_cast<jint>(self->size());
        if (0 <= fromIndex && fromIndex <= toIndex && toIndex <= size) {
          self->erase(self->begin() + fromIndex, self->begin() + toIndex);
        } else {
          throw std::out_of_range("vector index out of range");
        }
      }
SWIGINTERN std::map< double,double,std::less< double > >::iterator std_map_Sl_double_Sc_double_Sg__iterator_getNextUnchecked(std::map< double,double >::iterator *self){
          std::map< double, double, std::less< double > >::iterator copy = (*self);
          return ++copy;
        }
SWIGINTERN bool std_map_Sl_double_Sc_double_Sg__iterator_isNot(std::map< double,double >::iterator const *self,std::map< double,double >::iterator other){
          return (*self != other);
        }
SWIGINTERN double std_map_Sl_double_Sc_double_Sg__iterator_getKey(std::map< double,double >::iterator const *self){
          return (*self)->first;
        }
SWIGINTERN double std_map_Sl_double_Sc_double_Sg__iterator_getValue(std::map< double,double >::iterator const *self){
          return (*self)->second;
        }
SWIGINTERN void std_map_Sl_double_Sc_double_Sg__iterator_setValue(std::map< double,double >::iterator *self,double const &newValue){
          (*self)->second = newValue;
        }

  SWIGINTERN jint SWIG_MapSize(size_t size) {
    jint sz = SWIG_JavaIntFromSize_t(size);
    if (sz == -1) {
      throw std::out_of_range("map size is too large to fit into a Java int");
    }

    return sz;
  }

SWIGINTERN jint std_map_Sl_double_Sc_double_Sg__sizeImpl(std::map< double,double > const *self){
        return SWIG_MapSize(self->size());
      }
SWIGINTERN bool std_map_Sl_double_Sc_double_Sg__containsImpl(std::map< double,double > *self,double const &key){
        return (self->count(key) > 0);
      }
SWIGINTERN void std_map_Sl_double_Sc_double_Sg__putUnchecked(std::map< double,double > *self,double const &key,double const &value){
#ifdef __cpp_lib_map_try_emplace
        (*self).insert_or_assign(key, value);
#else
        (*self)[key] = value;
#endif
      }
SWIGINTERN void std_map_Sl_double_Sc_double_Sg__removeUnchecked(std::map< double,double > *self,std::map< double,double,std::less< double > >::iterator const itr){
        self->erase(itr);
      }
SWIGINTERN long long itk_simple_Image_GetBufferAsNativePointer(itk::simple::Image *self){ return reinterpret_cast<long long>(self->GetBufferAsVoid()); }


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "SimpleITKJAVA_wrap.h"

SwigDirector_Command::SwigDirector_Command(JNIEnv *jenv) : itk::simple::Command(), Swig::Director(jenv) {
}

SwigDirector_Command::~SwigDirector_Command() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


std::string SwigDirector_Command::GetName() const {
  std::string c_result ;
  jstring jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return itk::simple::Command::GetName();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jstring) jenv->CallStaticObjectMethod(Swig::jclass_SimpleITKJNI, Swig::director_method_ids[0], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
    if(!jresult) {
      if (!jenv->ExceptionCheck()) {
        SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
      }
      return c_result;
    } 
    const char *c_result_pstr = jenv->GetStringUTFChars(jresult, 0); 
    if (!c_result_pstr) return c_result;
    c_result.assign(c_result_pstr);
    jenv->ReleaseStringUTFChars(jresult, c_result_pstr); 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in itk::simple::Command::GetName ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_Command::SetName(std::string const &n) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jn = 0 ;
  
  if (!swig_override[1]) {
    itk::simple::Command::SetName(n);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jn = jenv->NewStringUTF((&n)->c_str());
    Swig::LocalRefGuard n_refguard(jenv, jn); 
    jenv->CallStaticVoidMethod(Swig::jclass_SimpleITKJNI, Swig::director_method_ids[1], swigjobj, jn);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in itk::simple::Command::SetName ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Command::Execute() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[2]) {
    itk::simple::Command::Execute();
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_SimpleITKJNI, Swig::director_method_ids[2], swigjobj);
    jthrowable swigerror = jenv->ExceptionOccurred();
    if (swigerror) {
      Swig::DirectorException::raise(jenv, swigerror);
    }
    
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object in itk::simple::Command::Execute ");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Command::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static jclass baseclass = swig_new_global_ref(jenv, "org/itk/simple/Command");
  if (!baseclass) return;
  static SwigDirectorMethod methods[] = {
    SwigDirectorMethod(jenv, baseclass, "getName", "()Ljava/lang/String;"),
    SwigDirectorMethod(jenv, baseclass, "setName", "(Ljava/lang/String;)V"),
    SwigDirectorMethod(jenv, baseclass, "execute", "()V")
  };
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].name, methods[i].desc);
        swig_override[i] = methods[i].methid && (methid != methods[i].methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorBool_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< bool > *)new std::vector< bool >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorBool: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorBool: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorBool"); return 0; 
      };
    }
  }
  *(std::vector< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorBool_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< bool > *arg1 = 0 ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< bool > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< bool > *)new std::vector< bool >((std::vector< bool > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorBool: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorBool: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorBool"); return 0; 
      };
    }
  }
  *(std::vector< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< bool > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< bool > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorBool_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jboolean jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  bool *arg2 = 0 ;
  bool temp2 ;
  std::vector< bool > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< bool > *)new_std_vector_Sl_bool_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(bool const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorBool: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorBool: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorBool"); return 0; 
      };
    }
  }
  *(std::vector< bool > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< bool > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_bool_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< bool > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< bool > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_bool_Sg__doSize((std::vector< bool > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  std::vector< bool > *arg1 = 0 ;
  std::vector< bool >::value_type *arg2 = 0 ;
  std::vector< bool >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  temp2 = jarg2 ? true : false; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_bool_Sg__doAdd__SWIG_0(arg1,(bool const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  std::vector< bool > *arg1 = 0 ;
  jint arg2 ;
  std::vector< bool >::value_type *arg3 = 0 ;
  std::vector< bool >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = jarg3 ? true : false; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(bool const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = 0 ;
  jint arg2 ;
  std::vector< bool >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< bool >::value_type)std_vector_Sl_bool_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_doRemove"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = 0 ;
  jint arg2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (bool)std_vector_Sl_bool_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_doGet"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jboolean jarg3) {
  jboolean jresult = 0 ;
  std::vector< bool > *arg1 = 0 ;
  jint arg2 ;
  std::vector< bool >::value_type *arg3 = 0 ;
  std::vector< bool >::value_type temp3 ;
  std::vector< bool >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = jarg3 ? true : false; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< bool >::value_type)std_vector_Sl_bool_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(bool const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_doSet"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorBool_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< bool > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< bool > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_bool_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorBool_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorBool_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorBool_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorBool(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< bool > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< bool > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorBool: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorBool: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorBool"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt8_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< uint8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< uint8_t > *)new std::vector< uint8_t >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt8"); return 0; 
      };
    }
  }
  *(std::vector< uint8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt8_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint8_t > *arg1 = 0 ;
  std::vector< uint8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint8_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< uint8_t > *)new std::vector< uint8_t >((std::vector< uint8_t > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt8"); return 0; 
      };
    }
  }
  *(std::vector< uint8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< uint8_t > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< uint8_t > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< uint8_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt8_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jshort jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  unsigned char *arg2 = 0 ;
  unsigned char temp2 ;
  std::vector< uint8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (unsigned char)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< uint8_t > *)new_std_vector_Sl_uint8_t_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(unsigned char const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt8"); return 0; 
      };
    }
  }
  *(std::vector< uint8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint8_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_uint8_t_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< uint8_t > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_uint8_t_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint8_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_uint8_t_Sg__doSize((std::vector< unsigned char > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  std::vector< uint8_t > *arg1 = 0 ;
  std::vector< unsigned char >::value_type *arg2 = 0 ;
  std::vector< unsigned char >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  temp2 = (std::vector< unsigned char >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_uint8_t_Sg__doAdd__SWIG_0(arg1,(unsigned char const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jshort jarg3) {
  std::vector< uint8_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned char >::value_type *arg3 = 0 ;
  std::vector< unsigned char >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned char >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_uint8_t_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(unsigned char const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jshort JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jshort jresult = 0 ;
  std::vector< uint8_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned char >::value_type)std_vector_Sl_uint8_t_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_doRemove"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jshort jresult = 0 ;
  std::vector< uint8_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned char >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned char >::value_type *) &std_vector_Sl_uint8_t_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_doGet"); return 0; 
      };
    }
  }
  jresult = (jshort)*result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jshort jarg3) {
  jshort jresult = 0 ;
  std::vector< uint8_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned char >::value_type *arg3 = 0 ;
  std::vector< unsigned char >::value_type temp3 ;
  std::vector< unsigned char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned char >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< unsigned char >::value_type)std_vector_Sl_uint8_t_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(unsigned char const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_doSet"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt8_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< uint8_t > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_uint8_t_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt8_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt8_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt8_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorUInt8(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< uint8_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< uint8_t > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorUInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorUInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorUInt8"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt8_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< int8_t > *)new std::vector< int8_t >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt8"); return 0; 
      };
    }
  }
  *(std::vector< int8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt8_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int8_t > *arg1 = 0 ;
  std::vector< int8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int8_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< int8_t > *)new std::vector< int8_t >((std::vector< int8_t > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt8"); return 0; 
      };
    }
  }
  *(std::vector< int8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int8_t > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< int8_t > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int8_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt8_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jbyte jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  signed char *arg2 = 0 ;
  signed char temp2 ;
  std::vector< int8_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (signed char)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< int8_t > *)new_std_vector_Sl_int8_t_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(signed char const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt8"); return 0; 
      };
    }
  }
  *(std::vector< int8_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int8_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_int8_t_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int8_t > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_int8_t_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int8_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_int8_t_Sg__doSize((std::vector< signed char > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jbyte jarg2) {
  std::vector< int8_t > *arg1 = 0 ;
  std::vector< signed char >::value_type *arg2 = 0 ;
  std::vector< signed char >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  temp2 = (std::vector< signed char >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_int8_t_Sg__doAdd__SWIG_0(arg1,(signed char const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jbyte jarg3) {
  std::vector< int8_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< signed char >::value_type *arg3 = 0 ;
  std::vector< signed char >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< signed char >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int8_t_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(signed char const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jbyte JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jbyte jresult = 0 ;
  std::vector< int8_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< signed char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< signed char >::value_type)std_vector_Sl_int8_t_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_doRemove"); return 0; 
      };
    }
  }
  jresult = (jbyte)result; 
  return jresult;
}


SWIGEXPORT jbyte JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jbyte jresult = 0 ;
  std::vector< int8_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< signed char >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< signed char >::value_type *) &std_vector_Sl_int8_t_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_doGet"); return 0; 
      };
    }
  }
  jresult = (jbyte)*result; 
  return jresult;
}


SWIGEXPORT jbyte JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jbyte jarg3) {
  jbyte jresult = 0 ;
  std::vector< int8_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< signed char >::value_type *arg3 = 0 ;
  std::vector< signed char >::value_type temp3 ;
  std::vector< signed char >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< signed char >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< signed char >::value_type)std_vector_Sl_int8_t_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(signed char const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_doSet"); return 0; 
      };
    }
  }
  jresult = (jbyte)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt8_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int8_t > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_int8_t_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt8_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt8_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt8_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorInt8(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int8_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< int8_t > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorInt8"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt16_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< uint16_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< uint16_t > *)new std::vector< uint16_t >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt16"); return 0; 
      };
    }
  }
  *(std::vector< uint16_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt16_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint16_t > *arg1 = 0 ;
  std::vector< uint16_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint16_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< uint16_t > *)new std::vector< uint16_t >((std::vector< uint16_t > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt16"); return 0; 
      };
    }
  }
  *(std::vector< uint16_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< uint16_t > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< uint16_t > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< uint16_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt16_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  unsigned short *arg2 = 0 ;
  unsigned short temp2 ;
  std::vector< uint16_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (unsigned short)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< uint16_t > *)new_std_vector_Sl_uint16_t_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(unsigned short const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt16"); return 0; 
      };
    }
  }
  *(std::vector< uint16_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint16_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_uint16_t_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< uint16_t > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_uint16_t_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint16_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_uint16_t_Sg__doSize((std::vector< unsigned short > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< uint16_t > *arg1 = 0 ;
  std::vector< unsigned short >::value_type *arg2 = 0 ;
  std::vector< unsigned short >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  temp2 = (std::vector< unsigned short >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_uint16_t_Sg__doAdd__SWIG_0(arg1,(unsigned short const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< uint16_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned short >::value_type *arg3 = 0 ;
  std::vector< unsigned short >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned short >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_uint16_t_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(unsigned short const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< uint16_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned short >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned short >::value_type)std_vector_Sl_uint16_t_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_doRemove"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< uint16_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned short >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned short >::value_type *) &std_vector_Sl_uint16_t_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_doGet"); return 0; 
      };
    }
  }
  jresult = (jint)*result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  std::vector< uint16_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned short >::value_type *arg3 = 0 ;
  std::vector< unsigned short >::value_type temp3 ;
  std::vector< unsigned short >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned short >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< unsigned short >::value_type)std_vector_Sl_uint16_t_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(unsigned short const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_doSet"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt16_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< uint16_t > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_uint16_t_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt16_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt16_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt16_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorUInt16(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< uint16_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< uint16_t > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorUInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorUInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorUInt16"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt16_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int16_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< int16_t > *)new std::vector< int16_t >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt16"); return 0; 
      };
    }
  }
  *(std::vector< int16_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt16_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int16_t > *arg1 = 0 ;
  std::vector< int16_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int16_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< int16_t > *)new std::vector< int16_t >((std::vector< int16_t > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt16"); return 0; 
      };
    }
  }
  *(std::vector< int16_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int16_t > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< int16_t > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int16_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt16_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jshort jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  short *arg2 = 0 ;
  short temp2 ;
  std::vector< int16_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (short)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< int16_t > *)new_std_vector_Sl_int16_t_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(short const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt16"); return 0; 
      };
    }
  }
  *(std::vector< int16_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int16_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_int16_t_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int16_t > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_int16_t_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int16_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_int16_t_Sg__doSize((std::vector< short > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jshort jarg2) {
  std::vector< int16_t > *arg1 = 0 ;
  std::vector< short >::value_type *arg2 = 0 ;
  std::vector< short >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  temp2 = (std::vector< short >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_int16_t_Sg__doAdd__SWIG_0(arg1,(short const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jshort jarg3) {
  std::vector< int16_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< short >::value_type *arg3 = 0 ;
  std::vector< short >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< short >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int16_t_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(short const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jshort JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jshort jresult = 0 ;
  std::vector< int16_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< short >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< short >::value_type)std_vector_Sl_int16_t_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_doRemove"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jshort jresult = 0 ;
  std::vector< int16_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< short >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< short >::value_type *) &std_vector_Sl_int16_t_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_doGet"); return 0; 
      };
    }
  }
  jresult = (jshort)*result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jshort jarg3) {
  jshort jresult = 0 ;
  std::vector< int16_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< short >::value_type *arg3 = 0 ;
  std::vector< short >::value_type temp3 ;
  std::vector< short >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< short >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< short >::value_type)std_vector_Sl_int16_t_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(short const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_doSet"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt16_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int16_t > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_int16_t_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt16_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt16_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt16_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorInt16(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int16_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< int16_t > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorInt16"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt32_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< uint32_t > *)new std::vector< uint32_t >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt32"); return 0; 
      };
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt32_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = 0 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< uint32_t > *)new std::vector< uint32_t >((std::vector< uint32_t > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt32"); return 0; 
      };
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< uint32_t > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< uint32_t > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< uint32_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt32_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  unsigned int *arg2 = 0 ;
  unsigned int temp2 ;
  std::vector< uint32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (unsigned int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< uint32_t > *)new_std_vector_Sl_uint32_t_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(unsigned int const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt32"); return 0; 
      };
    }
  }
  *(std::vector< uint32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint32_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_uint32_t_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< uint32_t > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_uint32_t_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint32_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_uint32_t_Sg__doSize((std::vector< unsigned int > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< uint32_t > *arg1 = 0 ;
  std::vector< unsigned int >::value_type *arg2 = 0 ;
  std::vector< unsigned int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  temp2 = (std::vector< unsigned int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_uint32_t_Sg__doAdd__SWIG_0(arg1,(unsigned int const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  std::vector< uint32_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type *arg3 = 0 ;
  std::vector< unsigned int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_uint32_t_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(unsigned int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned int >::value_type)std_vector_Sl_uint32_t_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_doRemove"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned int >::value_type *) &std_vector_Sl_uint32_t_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_doGet"); return 0; 
      };
    }
  }
  jresult = (jlong)*result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::vector< uint32_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned int >::value_type *arg3 = 0 ;
  std::vector< unsigned int >::value_type temp3 ;
  std::vector< unsigned int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< unsigned int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< unsigned int >::value_type)std_vector_Sl_uint32_t_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(unsigned int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_doSet"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt32_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< uint32_t > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_uint32_t_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt32_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt32_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt32_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorUInt32(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< uint32_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< uint32_t > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorUInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorUInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorUInt32"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt32_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< int32_t > *)new std::vector< int32_t >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt32"); return 0; 
      };
    }
  }
  *(std::vector< int32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt32_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int32_t > *arg1 = 0 ;
  std::vector< int32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< int32_t > *)new std::vector< int32_t >((std::vector< int32_t > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt32"); return 0; 
      };
    }
  }
  *(std::vector< int32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int32_t > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< int32_t > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int32_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt32_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  int *arg2 = 0 ;
  int temp2 ;
  std::vector< int32_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (int)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< int32_t > *)new_std_vector_Sl_int32_t_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(int const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt32"); return 0; 
      };
    }
  }
  *(std::vector< int32_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int32_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_int32_t_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int32_t > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_int32_t_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int32_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_int32_t_Sg__doSize((std::vector< int > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int32_t > *arg1 = 0 ;
  std::vector< int >::value_type *arg2 = 0 ;
  std::vector< int >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  temp2 = (std::vector< int >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_int32_t_Sg__doAdd__SWIG_0(arg1,(int const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int32_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int32_t_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int32_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< int >::value_type)std_vector_Sl_int32_t_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_doRemove"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jint jresult = 0 ;
  std::vector< int32_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< int >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< int >::value_type *) &std_vector_Sl_int32_t_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_doGet"); return 0; 
      };
    }
  }
  jresult = (jint)*result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  jint jresult = 0 ;
  std::vector< int32_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< int >::value_type *arg3 = 0 ;
  std::vector< int >::value_type temp3 ;
  std::vector< int >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< int >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< int >::value_type)std_vector_Sl_int32_t_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(int const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_doSet"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt32_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int32_t > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_int32_t_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt32_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt32_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt32_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorInt32(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int32_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< int32_t > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorInt32"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt64_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< uint64_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< uint64_t > *)new std::vector< uint64_t >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt64"); return 0; 
      };
    }
  }
  *(std::vector< uint64_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt64_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< uint64_t > *arg1 = 0 ;
  std::vector< uint64_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint64_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< uint64_t > *)new std::vector< uint64_t >((std::vector< uint64_t > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt64"); return 0; 
      };
    }
  }
  *(std::vector< uint64_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< uint64_t > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< uint64_t > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< uint64_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUInt64_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jobject jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  unsigned long *arg2 = 0 ;
  unsigned long temp2 ;
  std::vector< uint64_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = &temp2;
    temp2 = 0;
    if (sz > 0) {
      temp2 = (unsigned long)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        temp2 = (temp2 << 8) | (unsigned long)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  {
    try {
      try {
        result = (std::vector< uint64_t > *)new_std_vector_Sl_uint64_t_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(unsigned long const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUInt64"); return 0; 
      };
    }
  }
  *(std::vector< uint64_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint64_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_uint64_t_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< uint64_t > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_uint64_t_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< uint64_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_uint64_t_Sg__doSize((std::vector< unsigned long > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jobject jarg2) {
  std::vector< uint64_t > *arg1 = 0 ;
  std::vector< unsigned long >::value_type *arg2 = 0 ;
  std::vector< unsigned long >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg2) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg2);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg2, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg2 = &temp2;
    temp2 = 0;
    if (sz > 0) {
      temp2 = (std::vector< unsigned long >::value_type)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        temp2 = (temp2 << 8) | (std::vector< unsigned long >::value_type)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  {
    try {
      std_vector_Sl_uint64_t_Sg__doAdd__SWIG_0(arg1,(unsigned long const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  std::vector< uint64_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned long >::value_type *arg3 = 0 ;
  std::vector< unsigned long >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = &temp3;
    temp3 = 0;
    if (sz > 0) {
      temp3 = (std::vector< unsigned long >::value_type)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        temp3 = (temp3 << 8) | (std::vector< unsigned long >::value_type)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  {
    try {
      try {
        std_vector_Sl_uint64_t_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(unsigned long const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jobject JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  std::vector< uint64_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned long >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned long >::value_type)std_vector_Sl_uint64_t_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_doRemove"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jobject jresult = 0 ;
  std::vector< uint64_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned long >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< unsigned long >::value_type *) &std_vector_Sl_uint64_t_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_doGet"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(*result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jobject jarg3) {
  jobject jresult = 0 ;
  std::vector< uint64_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< unsigned long >::value_type *arg3 = 0 ;
  std::vector< unsigned long >::value_type temp3 ;
  std::vector< unsigned long >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return 0;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = &temp3;
    temp3 = 0;
    if (sz > 0) {
      temp3 = (std::vector< unsigned long >::value_type)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        temp3 = (temp3 << 8) | (std::vector< unsigned long >::value_type)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  {
    try {
      try {
        result = (std::vector< unsigned long >::value_type)std_vector_Sl_uint64_t_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(unsigned long const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_doSet"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUInt64_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< uint64_t > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_uint64_t_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUInt64_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUInt64_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUInt64_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorUInt64(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< uint64_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< uint64_t > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorUInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorUInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorUInt64"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt64_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< int64_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< int64_t > *)new std::vector< int64_t >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt64"); return 0; 
      };
    }
  }
  *(std::vector< int64_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt64_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< int64_t > *arg1 = 0 ;
  std::vector< int64_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int64_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< int64_t > *)new std::vector< int64_t >((std::vector< int64_t > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt64"); return 0; 
      };
    }
  }
  *(std::vector< int64_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< int64_t > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< int64_t > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< int64_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorInt64_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  long *arg2 = 0 ;
  long temp2 ;
  std::vector< int64_t > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (long)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< int64_t > *)new_std_vector_Sl_int64_t_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(long const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorInt64"); return 0; 
      };
    }
  }
  *(std::vector< int64_t > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int64_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_int64_t_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< int64_t > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_int64_t_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< int64_t > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_int64_t_Sg__doSize((std::vector< long > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  std::vector< int64_t > *arg1 = 0 ;
  std::vector< long >::value_type *arg2 = 0 ;
  std::vector< long >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  temp2 = (std::vector< long >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_int64_t_Sg__doAdd__SWIG_0(arg1,(long const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  std::vector< int64_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< long >::value_type *arg3 = 0 ;
  std::vector< long >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< long >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_int64_t_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(long const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< int64_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< long >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< long >::value_type)std_vector_Sl_int64_t_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_doRemove"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< int64_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< long >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< long >::value_type *) &std_vector_Sl_int64_t_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_doGet"); return 0; 
      };
    }
  }
  jresult = (jlong)*result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::vector< int64_t > *arg1 = 0 ;
  jint arg2 ;
  std::vector< long >::value_type *arg3 = 0 ;
  std::vector< long >::value_type temp3 ;
  std::vector< long >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< long >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< long >::value_type)std_vector_Sl_int64_t_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(long const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_doSet"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorInt64_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< int64_t > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_int64_t_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorInt64_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorInt64_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorInt64_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorInt64(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< int64_t > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< int64_t > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorInt64"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorFloat_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< float > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< float > *)new std::vector< float >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorFloat: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorFloat: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorFloat"); return 0; 
      };
    }
  }
  *(std::vector< float > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorFloat_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< float > *arg1 = 0 ;
  std::vector< float > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< float > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< float > *)new std::vector< float >((std::vector< float > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorFloat: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorFloat: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorFloat"); return 0; 
      };
    }
  }
  *(std::vector< float > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< float > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< float > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< float > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorFloat_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jfloat jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  float *arg2 = 0 ;
  float temp2 ;
  std::vector< float > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (float)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< float > *)new_std_vector_Sl_float_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(float const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorFloat: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorFloat: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorFloat"); return 0; 
      };
    }
  }
  *(std::vector< float > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< float > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_float_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< float > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_float_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< float > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_float_Sg__doSize((std::vector< float > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jfloat jarg2) {
  std::vector< float > *arg1 = 0 ;
  std::vector< float >::value_type *arg2 = 0 ;
  std::vector< float >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  temp2 = (std::vector< float >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_float_Sg__doAdd__SWIG_0(arg1,(float const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  std::vector< float > *arg1 = 0 ;
  jint arg2 ;
  std::vector< float >::value_type *arg3 = 0 ;
  std::vector< float >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< float >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_float_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(float const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jfloat JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  std::vector< float > *arg1 = 0 ;
  jint arg2 ;
  std::vector< float >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< float >::value_type)std_vector_Sl_float_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_doRemove"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jfloat jresult = 0 ;
  std::vector< float > *arg1 = 0 ;
  jint arg2 ;
  std::vector< float >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< float >::value_type *) &std_vector_Sl_float_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_doGet"); return 0; 
      };
    }
  }
  jresult = (jfloat)*result; 
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jfloat jarg3) {
  jfloat jresult = 0 ;
  std::vector< float > *arg1 = 0 ;
  jint arg2 ;
  std::vector< float >::value_type *arg3 = 0 ;
  std::vector< float >::value_type temp3 ;
  std::vector< float >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< float >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< float >::value_type)std_vector_Sl_float_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(float const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_doSet"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorFloat_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< float > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< float > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_float_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorFloat_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorFloat_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorFloat_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorFloat(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< float > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< float > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorFloat: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorFloat: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorFloat"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorDouble_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< double > *)new std::vector< double >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorDouble: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorDouble: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorDouble"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorDouble_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< double > *)new std::vector< double >((std::vector< double > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorDouble: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorDouble: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorDouble"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< double > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< double > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorDouble_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  double *arg2 = 0 ;
  double temp2 ;
  std::vector< double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      try {
        result = (std::vector< double > *)new_std_vector_Sl_double_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(double const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorDouble: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorDouble: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorDouble"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_double_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_double_Sg__doSize((std::vector< double > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::vector< double > *arg1 = 0 ;
  std::vector< double >::value_type *arg2 = 0 ;
  std::vector< double >::value_type temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  temp2 = (std::vector< double >::value_type)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_vector_Sl_double_Sg__doAdd__SWIG_0(arg1,(double const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  std::vector< double >::value_type *arg3 = 0 ;
  std::vector< double >::value_type temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< double >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(double const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  std::vector< double >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< double >::value_type)std_vector_Sl_double_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_doRemove"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  std::vector< double >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< double >::value_type *) &std_vector_Sl_double_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_doGet"); return 0; 
      };
    }
  }
  jresult = (jdouble)*result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jdouble jarg3) {
  jdouble jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  std::vector< double >::value_type *arg3 = 0 ;
  std::vector< double >::value_type temp3 ;
  std::vector< double >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  temp3 = (std::vector< double >::value_type)jarg3; 
  arg3 = &temp3; 
  {
    try {
      try {
        result = (std::vector< double >::value_type)std_vector_Sl_double_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(double const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_doSet"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorDouble_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< double > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_double_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorDouble_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorDouble_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorDouble_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorDouble(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< double > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< double > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorDouble: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorDouble: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorDouble"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorOfImage_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Image > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< itk::simple::Image > *)new std::vector< itk::simple::Image >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorOfImage: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorOfImage: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorOfImage"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Image > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorOfImage_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Image > *arg1 = 0 ;
  std::vector< itk::simple::Image > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Image > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< itk::simple::Image > *)new std::vector< itk::simple::Image >((std::vector< itk::simple::Image > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorOfImage: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorOfImage: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorOfImage"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Image > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< itk::simple::Image > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< itk::simple::Image > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< itk::simple::Image > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorOfImage_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  itk::simple::Image *arg2 = 0 ;
  std::vector< itk::simple::Image > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(itk::simple::Image **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image const & is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< itk::simple::Image > *)new_std_vector_Sl_itk_simple_Image_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(itk::simple::Image const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorOfImage: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorOfImage: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorOfImage"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Image > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< itk::simple::Image > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_itk_simple_Image_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< itk::simple::Image > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_itk_simple_Image_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< itk::simple::Image > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_itk_simple_Image_Sg__doSize((std::vector< itk::simple::Image > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< itk::simple::Image > *arg1 = 0 ;
  std::vector< itk::simple::Image >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  arg2 = *(std::vector< itk::simple::Image >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Image >::value_type const & is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_itk_simple_Image_Sg__doAdd__SWIG_0(arg1,(itk::simple::Image const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< itk::simple::Image > *arg1 = 0 ;
  jint arg2 ;
  std::vector< itk::simple::Image >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< itk::simple::Image >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Image >::value_type const & is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_itk_simple_Image_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(itk::simple::Image const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Image > *arg1 = 0 ;
  jint arg2 ;
  std::vector< itk::simple::Image >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_itk_simple_Image_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_doRemove"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Image >::value_type **)&jresult = new std::vector< itk::simple::Image >::value_type(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Image > *arg1 = 0 ;
  jint arg2 ;
  std::vector< itk::simple::Image >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< itk::simple::Image >::value_type *) &std_vector_Sl_itk_simple_Image_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_doGet"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Image >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Image > *arg1 = 0 ;
  jint arg2 ;
  std::vector< itk::simple::Image >::value_type *arg3 = 0 ;
  std::vector< itk::simple::Image >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< itk::simple::Image >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Image >::value_type const & is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_itk_simple_Image_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(itk::simple::Image const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_doSet"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Image >::value_type **)&jresult = new std::vector< itk::simple::Image >::value_type(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfImage_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< itk::simple::Image > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_itk_simple_Image_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfImage_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfImage_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfImage_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorOfImage(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< itk::simple::Image > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorOfImage: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorOfImage: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorOfImage"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorOfTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Transform > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< itk::simple::Transform > *)new std::vector< itk::simple::Transform >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorOfTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorOfTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorOfTransform"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Transform > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorOfTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  std::vector< itk::simple::Transform > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Transform > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< itk::simple::Transform > *)new std::vector< itk::simple::Transform >((std::vector< itk::simple::Transform > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorOfTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorOfTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorOfTransform"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Transform > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< itk::simple::Transform > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorOfTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  itk::simple::Transform *arg2 = 0 ;
  std::vector< itk::simple::Transform > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(itk::simple::Transform **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< itk::simple::Transform > *)new_std_vector_Sl_itk_simple_Transform_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(itk::simple::Transform const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorOfTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorOfTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorOfTransform"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Transform > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_itk_simple_Transform_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_itk_simple_Transform_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_itk_simple_Transform_Sg__doSize((std::vector< itk::simple::Transform > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  std::vector< itk::simple::Transform >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  arg2 = *(std::vector< itk::simple::Transform >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Transform >::value_type const & is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_itk_simple_Transform_Sg__doAdd__SWIG_0(arg1,(itk::simple::Transform const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  jint arg2 ;
  std::vector< itk::simple::Transform >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< itk::simple::Transform >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Transform >::value_type const & is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_itk_simple_Transform_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(itk::simple::Transform const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  jint arg2 ;
  std::vector< itk::simple::Transform >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_itk_simple_Transform_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_doRemove"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Transform >::value_type **)&jresult = new std::vector< itk::simple::Transform >::value_type(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  jint arg2 ;
  std::vector< itk::simple::Transform >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< itk::simple::Transform >::value_type *) &std_vector_Sl_itk_simple_Transform_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_doGet"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Transform >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  jint arg2 ;
  std::vector< itk::simple::Transform >::value_type *arg3 = 0 ;
  std::vector< itk::simple::Transform >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< itk::simple::Transform >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Transform >::value_type const & is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_itk_simple_Transform_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(itk::simple::Transform const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_doSet"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Transform >::value_type **)&jresult = new std::vector< itk::simple::Transform >::value_type(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorOfTransform_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_itk_simple_Transform_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorOfTransform_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorOfTransform_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorOfTransform_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorOfTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< itk::simple::Transform > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< itk::simple::Transform > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorOfTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorOfTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorOfTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUIntList_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::vector< unsigned int > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::vector< unsigned int > > *)new std::vector< std::vector< unsigned int > >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUIntList: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUIntList: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUIntList"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< unsigned int > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUIntList_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  std::vector< std::vector< unsigned int > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< unsigned int > > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< std::vector< unsigned int > > *)new std::vector< std::vector< unsigned int > >((std::vector< std::vector< unsigned int > > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUIntList: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUIntList: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUIntList"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< unsigned int > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::vector< unsigned int > > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorUIntList_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::vector< unsigned int > *arg2 = 0 ;
  std::vector< std::vector< unsigned int > > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = jarg1; 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return 0;
  } 
  {
    try {
      try {
        result = (std::vector< std::vector< unsigned int > > *)new_std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg___SWIG_2(SWIG_STD_MOVE(arg1),(std::vector< unsigned int > const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorUIntList: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorUIntList: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorUIntList"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< unsigned int > > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doSize((std::vector< std::vector< unsigned int > > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  std::vector< std::vector< unsigned int > >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  arg2 = *(std::vector< std::vector< unsigned int > >::value_type **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< unsigned int > >::value_type const & is null");
    return ;
  } 
  {
    try {
      std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doAdd__SWIG_0(arg1,(std::vector< unsigned int > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  jint arg2 ;
  std::vector< std::vector< unsigned int > >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< unsigned int > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< unsigned int > >::value_type const & is null");
    return ;
  } 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(std::vector< unsigned int > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  jint arg2 ;
  std::vector< std::vector< unsigned int > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_doRemove"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< unsigned int > >::value_type **)&jresult = new std::vector< std::vector< unsigned int > >::value_type(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  jint arg2 ;
  std::vector< std::vector< unsigned int > >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< std::vector< unsigned int > >::value_type *) &std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_doGet"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< unsigned int > >::value_type **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  jint arg2 ;
  std::vector< std::vector< unsigned int > >::value_type *arg3 = 0 ;
  std::vector< std::vector< unsigned int > >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = *(std::vector< std::vector< unsigned int > >::value_type **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::vector< unsigned int > >::value_type const & is null");
    return 0;
  } 
  {
    try {
      try {
        result = std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(std::vector< unsigned int > const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_doSet"); return 0; 
      };
    }
  }
  *(std::vector< std::vector< unsigned int > >::value_type **)&jresult = new std::vector< std::vector< unsigned int > >::value_type(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorUIntList_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_vector_Sl_unsigned_SS_int_Sg__Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorUIntList_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorUIntList_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorUIntList_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorUIntList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::vector< unsigned int > > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::vector< unsigned int > > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorUIntList: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorUIntList: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorUIntList"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorString_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorString"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorString_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< std::string > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::vector< std::string > *)new std::vector< std::string >((std::vector< std::string > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorString"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      result = (bool)((std::vector< std::string > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::vector< std::string > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1VectorString_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jint jarg1, jstring jarg2) {
  jlong jresult = 0 ;
  jint arg1 ;
  std::string *arg2 = 0 ;
  std::vector< std::string > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      try {
        result = (std::vector< std::string > *)new_std_vector_Sl_std_string_Sg___SWIG_2(SWIG_STD_MOVE(arg1),(std::string const &)*arg2);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_VectorString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_VectorString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_VectorString"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1doCapacity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_string_Sg__doCapacity(arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_doCapacity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_doCapacity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_doCapacity"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1doReserve(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  std::vector< std::string > *arg1 = 0 ;
  jint arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__doReserve(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::length_error &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_doReserve: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_doReserve: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_doReserve"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1doSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      try {
        result = std_vector_Sl_std_string_Sg__doSize((std::vector< std::string > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_doSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_doSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_doSize"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1doAdd_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  std::vector< std::string > *arg1 = 0 ;
  std::vector< std::string >::value_type *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::vector< std::string >::value_type arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      std_vector_Sl_std_string_Sg__doAdd__SWIG_0(arg1,(std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1doAdd_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  std::vector< std::string > *arg1 = 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__doAdd__SWIG_1(arg1,SWIG_STD_MOVE(arg2),(std::string const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_doAdd: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_doAdd: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_doAdd"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1doRemove(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = std_vector_Sl_std_string_Sg__doRemove(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_doRemove: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_doRemove: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_doRemove"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1doGet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  {
    try {
      try {
        result = (std::vector< std::string >::value_type *) &std_vector_Sl_std_string_Sg__doGet(arg1,SWIG_STD_MOVE(arg2));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_doGet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_doGet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_doGet"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1doSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jstring jarg3) {
  jstring jresult = 0 ;
  std::vector< std::string > *arg1 = 0 ;
  jint arg2 ;
  std::vector< std::string >::value_type *arg3 = 0 ;
  std::vector< std::string >::value_type result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg3_pstr = jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return 0;
  std::vector< std::string >::value_type arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      try {
        result = std_vector_Sl_std_string_Sg__doSet(arg1,SWIG_STD_MOVE(arg2),(std::string const &)*arg3);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_doSet: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_doSet: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_doSet"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_VectorString_1doRemoveRange(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3) {
  std::vector< std::string > *arg1 = 0 ;
  jint arg2 ;
  jint arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  arg2 = jarg2; 
  arg3 = jarg3; 
  {
    try {
      try {
        std_vector_Sl_std_string_Sg__doRemoveRange(arg1,SWIG_STD_MOVE(arg2),SWIG_STD_MOVE(arg3));
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return ;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK VectorString_doRemoveRange: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK VectorString_doRemoveRange: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK VectorString_doRemoveRange"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1VectorString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::vector< std::string > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::vector< std::string > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_VectorString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_VectorString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_VectorString"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1DoubleDoubleMap_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::map< double,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::map< double,double > *)new std::map< double,double >();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_DoubleDoubleMap: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_DoubleDoubleMap: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_DoubleDoubleMap"); return 0; 
      };
    }
  }
  *(std::map< double,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1DoubleDoubleMap_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< double,double > *arg1 = 0 ;
  std::map< double,double > *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::map< double,double > const & is null");
    return 0;
  } 
  {
    try {
      result = (std::map< double,double > *)new std::map< double,double >((std::map< double,double > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_DoubleDoubleMap: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_DoubleDoubleMap: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_DoubleDoubleMap"); return 0; 
      };
    }
  }
  *(std::map< double,double > **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1Iterator_1getNextUnchecked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< double,double >::iterator *arg1 = 0 ;
  std::map< double,double,std::less< double > >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double >::iterator **)&jarg1; 
  {
    try {
      result = std_map_Sl_double_Sc_double_Sg__iterator_getNextUnchecked(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_getNextUnchecked: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_getNextUnchecked: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_Iterator_getNextUnchecked"); return 0; 
      };
    }
  }
  *(std::map< double,double,std::less< double > >::iterator **)&jresult = new std::map< double,double,std::less< double > >::iterator(result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1Iterator_1isNot(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  std::map< double,double >::iterator *arg1 = 0 ;
  std::map< double,double >::iterator arg2 ;
  std::map< double,double >::iterator *argp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::map< double,double >::iterator **)&jarg1; 
  argp2 = *(std::map< double,double >::iterator **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::map< double,double >::iterator");
    return 0;
  }
  arg2 = *argp2; 
  {
    try {
      result = (bool)std_map_Sl_double_Sc_double_Sg__iterator_isNot((std::map< double,double >::iterator const *)arg1,SWIG_STD_MOVE(arg2));
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_isNot: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_isNot: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_Iterator_isNot"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1Iterator_1getKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  std::map< double,double >::iterator *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double >::iterator **)&jarg1; 
  {
    try {
      result = (double)std_map_Sl_double_Sc_double_Sg__iterator_getKey((std::map< double,double >::iterator const *)arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_getKey: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_getKey: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_Iterator_getKey"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1Iterator_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  std::map< double,double >::iterator *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double >::iterator **)&jarg1; 
  {
    try {
      result = (double)std_map_Sl_double_Sc_double_Sg__iterator_getValue((std::map< double,double >::iterator const *)arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_getValue: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_getValue: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_Iterator_getValue"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1Iterator_1setValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  std::map< double,double >::iterator *arg1 = 0 ;
  double *arg2 = 0 ;
  double temp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double >::iterator **)&jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      std_map_Sl_double_Sc_double_Sg__iterator_setValue(arg1,(double const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_setValue: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_Iterator_setValue: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_Iterator_setValue"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1DoubleDoubleMap_1Iterator(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::map< double,double >::iterator *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::map< double,double >::iterator **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_DoubleDoubleMap_Iterator: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_DoubleDoubleMap_Iterator: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_DoubleDoubleMap_Iterator"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1isEmpty(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  std::map< double,double > *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double > **)&jarg1; 
  {
    try {
      result = (bool)((std::map< double,double > const *)arg1)->empty();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_isEmpty: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_isEmpty: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_isEmpty"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1clear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  std::map< double,double > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double > **)&jarg1; 
  {
    try {
      (arg1)->clear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_clear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_clear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_clear"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1find(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jlong jresult = 0 ;
  std::map< double,double > *arg1 = 0 ;
  double *arg2 = 0 ;
  double temp2 ;
  std::map< double,double >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double > **)&jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (arg1)->find((double const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_find: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_find: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_find"); return 0; 
      };
    }
  }
  *(std::map< double,double >::iterator **)&jresult = new std::map< double,double >::iterator(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1begin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< double,double > *arg1 = 0 ;
  std::map< double,double >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double > **)&jarg1; 
  {
    try {
      result = (arg1)->begin();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_begin: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_begin: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_begin"); return 0; 
      };
    }
  }
  *(std::map< double,double >::iterator **)&jresult = new std::map< double,double >::iterator(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1end(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::map< double,double > *arg1 = 0 ;
  std::map< double,double >::iterator result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double > **)&jarg1; 
  {
    try {
      result = (arg1)->end();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_end: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_end: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_end"); return 0; 
      };
    }
  }
  *(std::map< double,double >::iterator **)&jresult = new std::map< double,double >::iterator(result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1sizeImpl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  std::map< double,double > *arg1 = 0 ;
  jint result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double > **)&jarg1; 
  {
    try {
      try {
        result = std_map_Sl_double_Sc_double_Sg__sizeImpl((std::map< double,double > const *)arg1);
      } catch(std::out_of_range &_e) {
        SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, (&_e)->what());
        return 0;
      }
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_sizeImpl: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_sizeImpl: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_sizeImpl"); return 0; 
      };
    }
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1containsImpl(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jboolean jresult = 0 ;
  std::map< double,double > *arg1 = 0 ;
  double *arg2 = 0 ;
  double temp2 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double > **)&jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  {
    try {
      result = (bool)std_map_Sl_double_Sc_double_Sg__containsImpl(arg1,(double const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_containsImpl: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_containsImpl: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_containsImpl"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1putUnchecked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  std::map< double,double > *arg1 = 0 ;
  double *arg2 = 0 ;
  double *arg3 = 0 ;
  double temp2 ;
  double temp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::map< double,double > **)&jarg1; 
  temp2 = (double)jarg2; 
  arg2 = &temp2; 
  temp3 = (double)jarg3; 
  arg3 = &temp3; 
  {
    try {
      std_map_Sl_double_Sc_double_Sg__putUnchecked(arg1,(double const &)*arg2,(double const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_putUnchecked: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_putUnchecked: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_putUnchecked"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DoubleDoubleMap_1removeUnchecked(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  std::map< double,double > *arg1 = 0 ;
  std::map< double,double,std::less< double > >::iterator arg2 ;
  std::map< double,double,std::less< double > >::iterator const *argp2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::map< double,double > **)&jarg1; 
  argp2 = *(std::map< double,double,std::less< double > >::iterator **)&jarg2; 
  if (!argp2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::map< double,double,std::less< double > >::iterator const");
    return ;
  }
  arg2 = *argp2; 
  {
    try {
      std_map_Sl_double_Sc_double_Sg__removeUnchecked(arg1,SWIG_STD_MOVE(arg2));
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_removeUnchecked: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DoubleDoubleMap_removeUnchecked: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DoubleDoubleMap_removeUnchecked"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1DoubleDoubleMap(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  std::map< double,double > *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(std::map< double,double > **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_DoubleDoubleMap: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_DoubleDoubleMap: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_DoubleDoubleMap"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_SITK_1MAX_1DIMENSION_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_SITK_1ITK_1VERSION_1MAJOR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_SITK_1ITK_1VERSION_1MINOR_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(4);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_SITK_1ITK_1VERSION_1PATCH_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  result = (int)(5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1majorVersion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (unsigned int)itk::simple::Version::MajorVersion();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_majorVersion: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_majorVersion: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_majorVersion"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1minorVersion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (unsigned int)itk::simple::Version::MinorVersion();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_minorVersion: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_minorVersion: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_minorVersion"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1patchVersion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (unsigned int)itk::simple::Version::PatchVersion();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_patchVersion: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_patchVersion: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_patchVersion"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1tweakVersion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (unsigned int)itk::simple::Version::TweakVersion();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_tweakVersion: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_tweakVersion: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_tweakVersion"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1versionString(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::string *) &itk::simple::Version::VersionString();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_versionString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_versionString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_versionString"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1buildDate(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::string *) &itk::simple::Version::BuildDate();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_buildDate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_buildDate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_buildDate"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1iTKMajorVersion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (unsigned int)itk::simple::Version::ITKMajorVersion();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_iTKMajorVersion: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_iTKMajorVersion: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_iTKMajorVersion"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1iTKMinorVersion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (unsigned int)itk::simple::Version::ITKMinorVersion();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_iTKMinorVersion: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_iTKMinorVersion: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_iTKMinorVersion"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1iTKPatchVersion(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (unsigned int)itk::simple::Version::ITKPatchVersion();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_iTKPatchVersion: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_iTKPatchVersion: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_iTKPatchVersion"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1iTKVersionString(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::string *) &itk::simple::Version::ITKVersionString();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_iTKVersionString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_iTKVersionString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_iTKVersionString"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1iTKModulesEnabled(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  std::vector< std::string > result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = itk::simple::Version::ITKModulesEnabled();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_iTKModulesEnabled: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_iTKModulesEnabled: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_iTKModulesEnabled"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = new std::vector< std::string >(result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1extendedVersionString(JNIEnv *jenv, jclass jcls) {
  jstring jresult = 0 ;
  std::string *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (std::string *) &itk::simple::Version::ExtendedVersionString();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_extendedVersionString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_extendedVersionString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_extendedVersionString"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF(result->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Version_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Version *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Version **)&jarg1; 
  {
    try {
      result = (arg1)->ToString();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Version_toString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Version_toString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Version_toString"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Version(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::Version *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::Version *)new itk::simple::Version();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Version: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Version: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Version"); return 0; 
      };
    }
  }
  *(itk::simple::Version **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1Version(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::Version *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::Version **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_Version: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_Version: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_Version"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkUnknown_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkUnknown;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkUnknown_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkUnknown_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkUnknown_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkUInt8_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkUInt8;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkUInt8_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkUInt8_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkUInt8_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkInt8_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkInt8;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkInt8_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkInt8_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkInt8_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkUInt16_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkUInt16;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkUInt16_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkUInt16_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkUInt16_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkInt16_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkInt16;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkInt16_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkInt16_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkInt16_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkUInt32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkUInt32;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkUInt32_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkUInt32_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkUInt32_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkInt32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkInt32;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkInt32_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkInt32_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkInt32_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkUInt64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkUInt64;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkUInt64_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkUInt64_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkUInt64_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkInt64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkInt64;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkInt64_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkInt64_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkInt64_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkFloat32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkFloat32;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkFloat32_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkFloat32_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkFloat32_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkFloat64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkFloat64;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkFloat64_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkFloat64_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkFloat64_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkComplexFloat32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkComplexFloat32;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkComplexFloat32_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkComplexFloat32_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkComplexFloat32_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkComplexFloat64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkComplexFloat64;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkComplexFloat64_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkComplexFloat64_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkComplexFloat64_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorUInt8_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorUInt8;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorUInt8_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorUInt8_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorUInt8_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorInt8_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorInt8;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorInt8_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorInt8_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorInt8_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorUInt16_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorUInt16;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorUInt16_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorUInt16_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorUInt16_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorInt16_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorInt16;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorInt16_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorInt16_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorInt16_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorUInt32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorUInt32;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorUInt32_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorUInt32_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorUInt32_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorInt32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorInt32;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorInt32_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorInt32_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorInt32_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorUInt64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorUInt64;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorUInt64_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorUInt64_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorUInt64_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorInt64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorInt64;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorInt64_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorInt64_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorInt64_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorFloat32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorFloat32;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorFloat32_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorFloat32_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorFloat32_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkVectorFloat64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkVectorFloat64;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkVectorFloat64_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkVectorFloat64_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkVectorFloat64_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkLabelUInt8_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkLabelUInt8;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkLabelUInt8_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkLabelUInt8_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkLabelUInt8_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkLabelUInt16_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkLabelUInt16;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkLabelUInt16_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkLabelUInt16_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkLabelUInt16_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkLabelUInt32_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkLabelUInt32;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkLabelUInt32_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkLabelUInt32_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkLabelUInt32_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkLabelUInt64_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::PixelIDValueEnum)itk::simple::sitkLabelUInt64;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkLabelUInt64_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkLabelUInt64_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkLabelUInt64_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_getPixelIDValueAsString_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  itk::simple::PixelIDValueType arg1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (itk::simple::PixelIDValueType)jarg1; 
  {
    try {
      result = itk::simple::GetPixelIDValueAsString(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK getPixelIDValueAsString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK getPixelIDValueAsString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK getPixelIDValueAsString"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_getPixelIDValueAsString_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jstring jresult = 0 ;
  itk::simple::PixelIDValueEnum arg1 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (itk::simple::PixelIDValueEnum)jarg1; 
  {
    try {
      result = itk::simple::GetPixelIDValueAsString(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK getPixelIDValueAsString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK getPixelIDValueAsString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK getPixelIDValueAsString"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_getPixelIDValueFromString(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jint jresult = 0 ;
  std::string *arg1 = 0 ;
  itk::simple::PixelIDValueType result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  std::string arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = (itk::simple::PixelIDValueType)itk::simple::GetPixelIDValueFromString((std::string const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK getPixelIDValueFromString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK getPixelIDValueFromString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK getPixelIDValueFromString"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkNearestNeighbor_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkNearestNeighbor;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkNearestNeighbor_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkNearestNeighbor_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkNearestNeighbor_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkLinear_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkLinear;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkLinear_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkLinear_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkLinear_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSpline1_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSpline1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSpline1_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSpline1_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSpline1_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSpline2_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSpline2;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSpline2_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSpline2_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSpline2_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSpline_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSpline;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSpline_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSpline_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSpline_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSpline3_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSpline3;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSpline3_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSpline3_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSpline3_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSpline4_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSpline4;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSpline4_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSpline4_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSpline4_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSpline5_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSpline5;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSpline5_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSpline5_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSpline5_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkGaussian_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkGaussian;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkGaussian_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkGaussian_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkGaussian_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkLabelGaussian_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkLabelGaussian;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkLabelGaussian_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkLabelGaussian_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkLabelGaussian_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkLabelLinear_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkLabelLinear;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkLabelLinear_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkLabelLinear_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkLabelLinear_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkHammingWindowedSinc_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkHammingWindowedSinc;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkHammingWindowedSinc_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkHammingWindowedSinc_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkHammingWindowedSinc_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkCosineWindowedSinc_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkCosineWindowedSinc;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkCosineWindowedSinc_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkCosineWindowedSinc_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkCosineWindowedSinc_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkWelchWindowedSinc_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkWelchWindowedSinc;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkWelchWindowedSinc_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkWelchWindowedSinc_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkWelchWindowedSinc_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkLanczosWindowedSinc_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkLanczosWindowedSinc;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkLanczosWindowedSinc_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkLanczosWindowedSinc_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkLanczosWindowedSinc_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBlackmanWindowedSinc_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBlackmanWindowedSinc;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBlackmanWindowedSinc_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBlackmanWindowedSinc_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBlackmanWindowedSinc_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSplineResampler_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSplineResampler;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSplineResampler_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSplineResampler_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSplineResampler_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSplineResamplerOrder3_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSplineResamplerOrder3;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder3_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder3_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSplineResamplerOrder3_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSplineResamplerOrder1_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSplineResamplerOrder1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder1_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder1_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSplineResamplerOrder1_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSplineResamplerOrder2_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSplineResamplerOrder2;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder2_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder2_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSplineResamplerOrder2_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSplineResamplerOrder4_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSplineResamplerOrder4;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder4_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder4_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSplineResamplerOrder4_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkBSplineResamplerOrder5_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::InterpolatorEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::InterpolatorEnum)itk::simple::sitkBSplineResamplerOrder5;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder5_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkBSplineResamplerOrder5_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkBSplineResamplerOrder5_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1Image(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::Image *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_Image: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_Image: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_Image"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Image_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::Image *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::Image *)new itk::simple::Image();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Image"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Image_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::Image *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Image *)new itk::simple::Image((itk::simple::Image const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Image"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Image_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jint jarg3) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  unsigned int arg2 ;
  itk::simple::PixelIDValueEnum arg3 ;
  itk::simple::Image *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (itk::simple::PixelIDValueEnum)jarg3; 
  {
    try {
      result = (itk::simple::Image *)new itk::simple::Image(arg1,arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Image"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Image_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jlong jarg3, jint jarg4) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  unsigned int arg2 ;
  unsigned int arg3 ;
  itk::simple::PixelIDValueEnum arg4 ;
  itk::simple::Image *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (unsigned int)jarg3; 
  arg4 = (itk::simple::PixelIDValueEnum)jarg4; 
  {
    try {
      result = (itk::simple::Image *)new itk::simple::Image(arg1,arg2,arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Image"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Image_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jlong jarg3) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = 0 ;
  itk::simple::PixelIDValueEnum arg2 ;
  unsigned int arg3 ;
  itk::simple::Image *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return 0;
  } 
  arg2 = (itk::simple::PixelIDValueEnum)jarg2; 
  arg3 = (unsigned int)jarg3; 
  {
    try {
      result = (itk::simple::Image *)new itk::simple::Image((std::vector< unsigned int > const &)*arg1,arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Image"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Image_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  std::vector< unsigned int > *arg1 = 0 ;
  itk::simple::PixelIDValueEnum arg2 ;
  itk::simple::Image *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< unsigned int > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return 0;
  } 
  arg2 = (itk::simple::PixelIDValueEnum)jarg2; 
  {
    try {
      result = (itk::simple::Image *)new itk::simple::Image((std::vector< unsigned int > const &)*arg1,arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Image: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Image"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getITKBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::DataObject *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (itk::DataObject *)(arg1)->GetITKBase();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getITKBase: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getITKBase: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getITKBase"); return 0; 
      };
    }
  }
  *(itk::DataObject **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelID(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::PixelIDValueEnum result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (itk::simple::PixelIDValueEnum)((itk::simple::Image const *)arg1)->GetPixelID();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelID: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelID: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelID"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelIDValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::PixelIDValueType result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (itk::simple::PixelIDValueType)((itk::simple::Image const *)arg1)->GetPixelIDValue();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelIDValue: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelIDValue: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelIDValue"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelIDTypeAsString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelIDTypeAsString();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelIDTypeAsString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelIDTypeAsString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelIDTypeAsString"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getDimension(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::Image const *)arg1)->GetDimension();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getDimension: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getDimension: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getDimension"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getNumberOfComponentsPerPixel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::Image const *)arg1)->GetNumberOfComponentsPerPixel();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getNumberOfComponentsPerPixel: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getNumberOfComponentsPerPixel: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getNumberOfComponentsPerPixel"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getNumberOfPixels(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (uint64_t)((itk::simple::Image const *)arg1)->GetNumberOfPixels();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getNumberOfPixels: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getNumberOfPixels: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getNumberOfPixels"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getSizeOfPixelComponent(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::Image const *)arg1)->GetSizeOfPixelComponent();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getSizeOfPixelComponent: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getSizeOfPixelComponent: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getSizeOfPixelComponent"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetOrigin();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getOrigin: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getOrigin: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getOrigin"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetOrigin((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setOrigin: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setOrigin: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setOrigin"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getSpacing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetSpacing();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getSpacing: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getSpacing: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getSpacing"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setSpacing(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetSpacing((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setSpacing: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setSpacing: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setSpacing"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetDirection();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getDirection: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getDirection: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getDirection"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetDirection((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setDirection: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setDirection: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setDirection"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1transformIndexToPhysicalPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< int64_t > *arg2 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< int64_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int64_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->TransformIndexToPhysicalPoint((std::vector< int64_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_transformIndexToPhysicalPoint: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_transformIndexToPhysicalPoint: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_transformIndexToPhysicalPoint"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1transformPhysicalPointToIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< int64_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->TransformPhysicalPointToIndex((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_transformPhysicalPointToIndex: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_transformPhysicalPointToIndex: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_transformPhysicalPointToIndex"); return 0; 
      };
    }
  }
  *(std::vector< int64_t > **)&jresult = new std::vector< int64_t >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1transformPhysicalPointToContinuousIndex(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->TransformPhysicalPointToContinuousIndex((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_transformPhysicalPointToContinuousIndex: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_transformPhysicalPointToContinuousIndex: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_transformPhysicalPointToContinuousIndex"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1transformContinuousIndexToPhysicalPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->TransformContinuousIndexToPhysicalPoint((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_transformContinuousIndexToPhysicalPoint: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_transformContinuousIndexToPhysicalPoint: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_transformContinuousIndexToPhysicalPoint"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1evaluateAtContinuousIndex_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  itk::simple::InterpolatorEnum arg3 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = (itk::simple::InterpolatorEnum)jarg3; 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->EvaluateAtContinuousIndex((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_evaluateAtContinuousIndex: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_evaluateAtContinuousIndex: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_evaluateAtContinuousIndex"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1evaluateAtContinuousIndex_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->EvaluateAtContinuousIndex((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_evaluateAtContinuousIndex: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_evaluateAtContinuousIndex: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_evaluateAtContinuousIndex"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1evaluateAtPhysicalPoint_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  itk::simple::InterpolatorEnum arg3 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = (itk::simple::InterpolatorEnum)jarg3; 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->EvaluateAtPhysicalPoint((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_evaluateAtPhysicalPoint: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_evaluateAtPhysicalPoint: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_evaluateAtPhysicalPoint"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1evaluateAtPhysicalPoint_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->EvaluateAtPhysicalPoint((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_evaluateAtPhysicalPoint: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_evaluateAtPhysicalPoint: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_evaluateAtPhysicalPoint"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1isCongruentImageGeometry(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jdouble jarg4) {
  jboolean jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::Image *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(itk::simple::Image **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image const & is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      result = (bool)((itk::simple::Image const *)arg1)->IsCongruentImageGeometry((itk::simple::Image const &)*arg2,arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_isCongruentImageGeometry: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_isCongruentImageGeometry: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_isCongruentImageGeometry"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1isSameImageGeometryAs_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jdouble jarg4) {
  jboolean jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::Image *arg2 = 0 ;
  double arg3 ;
  double arg4 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(itk::simple::Image **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image const & is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      result = (bool)((itk::simple::Image const *)arg1)->IsSameImageGeometryAs((itk::simple::Image const &)*arg2,arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_isSameImageGeometryAs: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_isSameImageGeometryAs: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_isSameImageGeometryAs"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1isSameImageGeometryAs_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jboolean jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::Image *arg2 = 0 ;
  double arg3 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(itk::simple::Image **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image const & is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      result = (bool)((itk::simple::Image const *)arg1)->IsSameImageGeometryAs((itk::simple::Image const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_isSameImageGeometryAs: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_isSameImageGeometryAs: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_isSameImageGeometryAs"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1isSameImageGeometryAs_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jboolean jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::Image *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(itk::simple::Image **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image const & is null");
    return 0;
  } 
  {
    try {
      result = (bool)((itk::simple::Image const *)arg1)->IsSameImageGeometryAs((itk::simple::Image const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_isSameImageGeometryAs: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_isSameImageGeometryAs: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_isSameImageGeometryAs"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< unsigned int > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetSize();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getSize"); return 0; 
      };
    }
  }
  *(std::vector< unsigned int > **)&jresult = new std::vector< unsigned int >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getWidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::Image const *)arg1)->GetWidth();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getWidth: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getWidth: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getWidth"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getHeight(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::Image const *)arg1)->GetHeight();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getHeight: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getHeight: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getHeight"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getDepth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::Image const *)arg1)->GetDepth();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getDepth: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getDepth: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getDepth"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1copyInformation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Image *arg1 = 0 ;
  itk::simple::Image *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(itk::simple::Image **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image const & is null");
    return ;
  } 
  {
    try {
      (arg1)->CopyInformation((itk::simple::Image const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_copyInformation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_copyInformation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_copyInformation"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getMetaDataKeys(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< std::string > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetMetaDataKeys();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getMetaDataKeys: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getMetaDataKeys: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getMetaDataKeys"); return 0; 
      };
    }
  }
  *(std::vector< std::string > **)&jresult = new std::vector< std::string >(result); 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1hasMetaDataKey(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)((itk::simple::Image const *)arg1)->HasMetaDataKey((std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_hasMetaDataKey: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_hasMetaDataKey: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_hasMetaDataKey"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetMetaData((std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getMetaData: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getMetaData: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getMetaData"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jstring jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::string *arg2 = 0 ;
  std::string *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  if(!jarg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg3_pstr = jenv->GetStringUTFChars(jarg3, 0); 
  if (!arg3_pstr) return ;
  std::string arg3_str(arg3_pstr);
  arg3 = &arg3_str;
  jenv->ReleaseStringUTFChars(jarg3, arg3_pstr); 
  {
    try {
      (arg1)->SetMetaData((std::string const &)*arg2,(std::string const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setMetaData: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setMetaData: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setMetaData"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1eraseMetaData(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jboolean jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::string *arg2 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return 0;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      result = (bool)(arg1)->EraseMetaData((std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_eraseMetaData: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_eraseMetaData: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_eraseMetaData"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->ToString();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_toString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_toString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_toString"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1toVectorImage_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  bool arg2 ;
  itk::simple::Image result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (arg1)->ToVectorImage(arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_toVectorImage: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_toVectorImage: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_toVectorImage"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = new itk::simple::Image(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1toVectorImage_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::Image result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (arg1)->ToVectorImage();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_toVectorImage: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_toVectorImage: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_toVectorImage"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = new itk::simple::Image(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1toScalarImage_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  bool arg2 ;
  itk::simple::Image result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      result = (arg1)->ToScalarImage(arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_toScalarImage: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_toScalarImage: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_toScalarImage"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = new itk::simple::Image(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1toScalarImage_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::Image result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (arg1)->ToScalarImage();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_toScalarImage: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_toScalarImage: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_toScalarImage"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = new itk::simple::Image(result); 
  return jresult;
}


SWIGEXPORT jbyte JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jbyte jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  int8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (int8_t)((itk::simple::Image const *)arg1)->GetPixelAsInt8((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsInt8"); return 0; 
      };
    }
  }
  jresult = (jbyte)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsUInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jshort jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  uint8_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (uint8_t)((itk::simple::Image const *)arg1)->GetPixelAsUInt8((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsUInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsUInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsUInt8"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jshort JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jshort jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  int16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (int16_t)((itk::simple::Image const *)arg1)->GetPixelAsInt16((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsInt16"); return 0; 
      };
    }
  }
  jresult = (jshort)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsUInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  uint16_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (uint16_t)((itk::simple::Image const *)arg1)->GetPixelAsUInt16((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsUInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsUInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsUInt16"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jint jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  int32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (int32_t)((itk::simple::Image const *)arg1)->GetPixelAsInt32((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsInt32"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsUInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  uint32_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (uint32_t)((itk::simple::Image const *)arg1)->GetPixelAsUInt32((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsUInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsUInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsUInt32"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  int64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (int64_t)((itk::simple::Image const *)arg1)->GetPixelAsInt64((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsInt64"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsUInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jobject jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  uint64_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (uint64_t)((itk::simple::Image const *)arg1)->GetPixelAsUInt64((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsUInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsUInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsUInt64"); return 0; 
      };
    }
  }
  {
    jbyteArray ba = jenv->NewByteArray(9);
    jbyte* bae = jenv->GetByteArrayElements(ba, 0);
    jclass clazz = jenv->FindClass("java/math/BigInteger");
    jmethodID mid = jenv->GetMethodID(clazz, "<init>", "([B)V");
    jobject bigint;
    int i;
    
    bae[0] = 0;
    for(i=1; i<9; i++ ) {
      bae[i] = (jbyte)(result>>8*(8-i));
    }
    
    jenv->ReleaseByteArrayElements(ba, bae, 0);
    bigint = jenv->NewObject(clazz, mid, ba);
    jenv->DeleteLocalRef(ba);
    jresult = bigint;
  }
  return jresult;
}


SWIGEXPORT jfloat JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jfloat jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  float result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (float)((itk::simple::Image const *)arg1)->GetPixelAsFloat((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsFloat: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsFloat: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsFloat"); return 0; 
      };
    }
  }
  jresult = (jfloat)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jdouble jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = (double)((itk::simple::Image const *)arg1)->GetPixelAsDouble((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsDouble: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsDouble: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsDouble"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< int8_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorInt8((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorInt8"); return 0; 
      };
    }
  }
  *(std::vector< int8_t > **)&jresult = new std::vector< int8_t >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorUInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< uint8_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorUInt8((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorUInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorUInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorUInt8"); return 0; 
      };
    }
  }
  *(std::vector< uint8_t > **)&jresult = new std::vector< uint8_t >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< int16_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorInt16((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorInt16"); return 0; 
      };
    }
  }
  *(std::vector< int16_t > **)&jresult = new std::vector< int16_t >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorUInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< uint16_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorUInt16((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorUInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorUInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorUInt16"); return 0; 
      };
    }
  }
  *(std::vector< uint16_t > **)&jresult = new std::vector< uint16_t >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< int32_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorInt32((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorInt32"); return 0; 
      };
    }
  }
  *(std::vector< int32_t > **)&jresult = new std::vector< int32_t >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorUInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< uint32_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorUInt32((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorUInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorUInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorUInt32"); return 0; 
      };
    }
  }
  *(std::vector< uint32_t > **)&jresult = new std::vector< uint32_t >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< int64_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorInt64((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorInt64"); return 0; 
      };
    }
  }
  *(std::vector< int64_t > **)&jresult = new std::vector< int64_t >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorUInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< uint64_t > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorUInt64((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorUInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorUInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorUInt64"); return 0; 
      };
    }
  }
  *(std::vector< uint64_t > **)&jresult = new std::vector< uint64_t >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorFloat32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< float > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorFloat32((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorFloat32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorFloat32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorFloat32"); return 0; 
      };
    }
  }
  *(std::vector< float > **)&jresult = new std::vector< float >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsVectorFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsVectorFloat64((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorFloat64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsVectorFloat64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsVectorFloat64"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsComplexFloat32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::complex< float > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsComplexFloat32((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsComplexFloat32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsComplexFloat32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsComplexFloat32"); return 0; 
      };
    }
  }
  *(std::complex< float > **)&jresult = new std::complex< float >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getPixelAsComplexFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::complex< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Image const *)arg1)->GetPixelAsComplexFloat64((std::vector< uint32_t > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getPixelAsComplexFloat64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getPixelAsComplexFloat64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getPixelAsComplexFloat64"); return 0; 
      };
    }
  }
  *(std::complex< double > **)&jresult = new std::complex< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jbyte jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  int8_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = (int8_t)jarg3; 
  {
    try {
      (arg1)->SetPixelAsInt8((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsInt8"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsUInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jshort jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  uint8_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = (uint8_t)jarg3; 
  {
    try {
      (arg1)->SetPixelAsUInt8((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsUInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsUInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsUInt8"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jshort jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  int16_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = (int16_t)jarg3; 
  {
    try {
      (arg1)->SetPixelAsInt16((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsInt16"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsUInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  uint16_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = (uint16_t)jarg3; 
  {
    try {
      (arg1)->SetPixelAsUInt16((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsUInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsUInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsUInt16"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  int32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = (int32_t)jarg3; 
  {
    try {
      (arg1)->SetPixelAsInt32((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsInt32"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsUInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  uint32_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = (uint32_t)jarg3; 
  {
    try {
      (arg1)->SetPixelAsUInt32((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsUInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsUInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsUInt32"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  int64_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = (int64_t)jarg3; 
  {
    try {
      (arg1)->SetPixelAsInt64((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsInt64"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsUInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jobject jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  uint64_t arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  {
    jclass clazz;
    jmethodID mid;
    jbyteArray ba;
    jbyte* bae;
    jsize sz;
    int i;
    
    if (!jarg3) {
      SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "BigInteger null");
      return ;
    }
    clazz = jenv->GetObjectClass(jarg3);
    mid = jenv->GetMethodID(clazz, "toByteArray", "()[B");
    ba = (jbyteArray)jenv->CallObjectMethod(jarg3, mid);
    bae = jenv->GetByteArrayElements(ba, 0);
    sz = jenv->GetArrayLength(ba);
    arg3 = 0;
    if (sz > 0) {
      arg3 = (uint64_t)(signed char)bae[0];
      for(i=1; i<sz; i++) {
        arg3 = (arg3 << 8) | (uint64_t)(unsigned char)bae[i];
      }
    }
    jenv->ReleaseByteArrayElements(ba, bae, 0);
  }
  {
    try {
      (arg1)->SetPixelAsUInt64((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsUInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsUInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsUInt64"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsFloat(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jfloat jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  float arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = (float)jarg3; 
  {
    try {
      (arg1)->SetPixelAsFloat((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsFloat: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsFloat: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsFloat"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsDouble(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->SetPixelAsDouble((std::vector< uint32_t > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsDouble: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsDouble: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsDouble"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< int8_t > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< int8_t > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int8_t > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorInt8((std::vector< uint32_t > const &)*arg2,(std::vector< int8_t > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorInt8"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorUInt8(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< uint8_t > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< uint8_t > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint8_t > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorUInt8((std::vector< uint32_t > const &)*arg2,(std::vector< uint8_t > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorUInt8: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorUInt8: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorUInt8"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< int16_t > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< int16_t > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int16_t > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorInt16((std::vector< uint32_t > const &)*arg2,(std::vector< int16_t > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorInt16"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorUInt16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< uint16_t > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< uint16_t > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint16_t > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorUInt16((std::vector< uint32_t > const &)*arg2,(std::vector< uint16_t > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorUInt16: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorUInt16: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorUInt16"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< int32_t > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< int32_t > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int32_t > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorInt32((std::vector< uint32_t > const &)*arg2,(std::vector< int32_t > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorInt32"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorUInt32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< uint32_t > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< uint32_t > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorUInt32((std::vector< uint32_t > const &)*arg2,(std::vector< uint32_t > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorUInt32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorUInt32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorUInt32"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< int64_t > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< int64_t > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< int64_t > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorInt64((std::vector< uint32_t > const &)*arg2,(std::vector< int64_t > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorInt64"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorUInt64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< uint64_t > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< uint64_t > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint64_t > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorUInt64((std::vector< uint32_t > const &)*arg2,(std::vector< uint64_t > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorUInt64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorUInt64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorUInt64"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorFloat32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< float > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< float > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< float > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorFloat32((std::vector< uint32_t > const &)*arg2,(std::vector< float > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorFloat32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorFloat32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorFloat32"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsVectorFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetPixelAsVectorFloat64((std::vector< uint32_t > const &)*arg2,(std::vector< double > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorFloat64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsVectorFloat64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsVectorFloat64"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsComplexFloat32(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::complex< float > arg3 ;
  std::complex< float > const *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  argp3 = *(std::complex< float > **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::complex< float > const");
    return ;
  }
  arg3 = *argp3; 
  {
    try {
      (arg1)->SetPixelAsComplexFloat32((std::vector< uint32_t > const &)*arg2,SWIG_STD_MOVE(arg3));
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsComplexFloat32: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsComplexFloat32: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsComplexFloat32"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1setPixelAsComplexFloat64(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3) {
  itk::simple::Image *arg1 = 0 ;
  std::vector< uint32_t > *arg2 = 0 ;
  std::complex< double > arg3 ;
  std::complex< double > const *argp3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  arg2 = *(std::vector< uint32_t > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< uint32_t > const & is null");
    return ;
  } 
  argp3 = *(std::complex< double > **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null std::complex< double > const");
    return ;
  }
  arg3 = *argp3; 
  {
    try {
      (arg1)->SetPixelAsComplexFloat64((std::vector< uint32_t > const &)*arg2,SWIG_STD_MOVE(arg3));
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_setPixelAsComplexFloat64: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_setPixelAsComplexFloat64: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_setPixelAsComplexFloat64"); return ; 
      };
    }
  }
}


SWIGEXPORT jobject JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getBufferAsByteBuffer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jobject jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  void *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (void *)(arg1)->GetBufferAsVoid();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getBufferAsByteBuffer: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getBufferAsByteBuffer: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getBufferAsByteBuffer"); return 0; 
      };
    }
  }
  {
    const size_t size = arg1->GetNumberOfPixels()*arg1->GetNumberOfComponentsPerPixel()*arg1->GetSizeOfPixelComponent();
    jresult = jenv->NewDirectByteBuffer(result, size);
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1makeUnique(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::Image *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      (arg1)->MakeUnique();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_makeUnique: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_makeUnique: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_makeUnique"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1isUnique(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (bool)((itk::simple::Image const *)arg1)->IsUnique();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_isUnique: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_isUnique: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_isUnique"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1DefaultImageCoordinateTolerance_1get(JNIEnv *jenv, jclass jcls) {
  jdouble jresult = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  result = (double)itk::simple::Image::DefaultImageCoordinateTolerance;
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1DefaultImageDirectionTolerance_1get(JNIEnv *jenv, jclass jcls) {
  jdouble jresult = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  result = (double)itk::simple::Image::DefaultImageDirectionTolerance;
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Image_1getBufferAsNativePointer(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  long long result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1; 
  {
    try {
      result = (long long)itk_simple_Image_GetBufferAsNativePointer(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Image_getBufferAsNativePointer: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Image_getBufferAsNativePointer: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Image_getBufferAsNativePointer"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1ObjectOwnedBase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::ObjectOwnedBase *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::ObjectOwnedBase **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_ObjectOwnedBase: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_ObjectOwnedBase: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_ObjectOwnedBase"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_ObjectOwnedBase_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::ObjectOwnedBase *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ObjectOwnedBase **)&jarg1; 
  {
    try {
      result = ((itk::simple::ObjectOwnedBase const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ObjectOwnedBase_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ObjectOwnedBase_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ObjectOwnedBase_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ObjectOwnedBase_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::ObjectOwnedBase *arg1 = 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ObjectOwnedBase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->SetName((std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ObjectOwnedBase_setName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ObjectOwnedBase_setName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ObjectOwnedBase_setName"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Command(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::Command *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::Command *)new SwigDirector_Command(jenv);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Command: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Command: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Command"); return 0; 
      };
    }
  }
  *(itk::simple::Command **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1Command(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::Command *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::Command **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_Command: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_Command: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_Command"); return ; 
      };
    }
  }
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Command_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Command *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Command **)&jarg1; 
  {
    try {
      result = ((itk::simple::Command const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Command_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Command_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Command_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Command_1getNameSwigExplicitCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Command *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Command **)&jarg1; 
  {
    try {
      result = ((itk::simple::Command const *)arg1)->itk::simple::Command::GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Command_getNameSwigExplicitCommand: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Command_getNameSwigExplicitCommand: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Command_getNameSwigExplicitCommand"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Command_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::Command *arg1 = 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Command **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->SetName((std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Command_setName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Command_setName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Command_setName"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Command_1setNameSwigExplicitCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::Command *arg1 = 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Command **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->itk::simple::Command::SetName((std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Command_setNameSwigExplicitCommand: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Command_setNameSwigExplicitCommand: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Command_setNameSwigExplicitCommand"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Command_1execute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::Command *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Command **)&jarg1; 
  {
    try {
      (arg1)->Execute();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Command_execute: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Command_execute: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Command_execute"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Command_1executeSwigExplicitCommand(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::Command *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Command **)&jarg1; 
  {
    try {
      (arg1)->itk::simple::Command::Execute();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Command_executeSwigExplicitCommand: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Command_executeSwigExplicitCommand: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Command_executeSwigExplicitCommand"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Command_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  itk::simple::Command *obj = *((itk::simple::Command **)&objarg);
  (void)jcls;
  SwigDirector_Command *director = static_cast<SwigDirector_Command *>(obj);
  director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Command_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  itk::simple::Command *obj = *((itk::simple::Command **)&objarg);
  SwigDirector_Command *director = dynamic_cast<SwigDirector_Command *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1LoggerBase(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::LoggerBase *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::LoggerBase **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_LoggerBase: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_LoggerBase: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_LoggerBase"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_LoggerBase_1displayText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::LoggerBase *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::LoggerBase **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK LoggerBase_displayText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK LoggerBase_displayText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK LoggerBase_displayText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_LoggerBase_1displayErrorText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::LoggerBase *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::LoggerBase **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayErrorText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK LoggerBase_displayErrorText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK LoggerBase_displayErrorText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK LoggerBase_displayErrorText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_LoggerBase_1displayWarningText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::LoggerBase *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::LoggerBase **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayWarningText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK LoggerBase_displayWarningText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK LoggerBase_displayWarningText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK LoggerBase_displayWarningText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_LoggerBase_1displayGenericOutputText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::LoggerBase *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::LoggerBase **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayGenericOutputText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK LoggerBase_displayGenericOutputText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK LoggerBase_displayGenericOutputText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK LoggerBase_displayGenericOutputText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_LoggerBase_1displayDebugText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::LoggerBase *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::LoggerBase **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayDebugText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK LoggerBase_displayDebugText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK LoggerBase_displayDebugText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK LoggerBase_displayDebugText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_LoggerBase_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::LoggerBase *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::LoggerBase **)&jarg1; 
  {
    try {
      result = ((itk::simple::LoggerBase const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK LoggerBase_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK LoggerBase_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK LoggerBase_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_LoggerBase_1setName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::LoggerBase *arg1 = 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::LoggerBase **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      (arg1)->SetName((std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK LoggerBase_setName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK LoggerBase_setName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK LoggerBase_setName"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_LoggerBase_1setAsGlobalITKLogger(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::LoggerBase *arg1 = 0 ;
  itk::simple::ITKLogger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::LoggerBase **)&jarg1; 
  {
    try {
      result = (arg1)->SetAsGlobalITKLogger();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK LoggerBase_setAsGlobalITKLogger: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK LoggerBase_setAsGlobalITKLogger: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK LoggerBase_setAsGlobalITKLogger"); return 0; 
      };
    }
  }
  *(itk::simple::ITKLogger **)&jresult = new itk::simple::ITKLogger(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_LoggerBase_1getGlobalITKLogger(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::ITKLogger result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = itk::simple::LoggerBase::GetGlobalITKLogger();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK LoggerBase_getGlobalITKLogger: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK LoggerBase_getGlobalITKLogger: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK LoggerBase_getGlobalITKLogger"); return 0; 
      };
    }
  }
  *(itk::simple::ITKLogger **)&jresult = new itk::simple::ITKLogger(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ITKLogger_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  itk::OutputWindow *arg1 = 0 ;
  itk::simple::ITKLogger *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::OutputWindow **)&jarg1; 
  {
    try {
      result = (itk::simple::ITKLogger *)new itk::simple::ITKLogger(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ITKLogger: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ITKLogger: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ITKLogger"); return 0; 
      };
    }
  }
  *(itk::simple::ITKLogger **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1ITKLogger(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::ITKLogger *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::ITKLogger **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_ITKLogger: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_ITKLogger: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_ITKLogger"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ITKLogger_1_1SWIG_11(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::ITKLogger *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::ITKLogger *)new itk::simple::ITKLogger();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ITKLogger: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ITKLogger: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ITKLogger"); return 0; 
      };
    }
  }
  *(itk::simple::ITKLogger **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ITKLogger_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ITKLogger *arg1 = 0 ;
  itk::simple::ITKLogger *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ITKLogger **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::ITKLogger const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ITKLogger *)new itk::simple::ITKLogger((itk::simple::ITKLogger const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ITKLogger: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ITKLogger: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ITKLogger"); return 0; 
      };
    }
  }
  *(itk::simple::ITKLogger **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ITKLogger_1displayText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::ITKLogger *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ITKLogger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ITKLogger_displayText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ITKLogger_displayText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ITKLogger_displayText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ITKLogger_1displayErrorText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::ITKLogger *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ITKLogger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayErrorText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ITKLogger_displayErrorText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ITKLogger_displayErrorText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ITKLogger_displayErrorText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ITKLogger_1displayWarningText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::ITKLogger *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ITKLogger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayWarningText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ITKLogger_displayWarningText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ITKLogger_displayWarningText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ITKLogger_displayWarningText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ITKLogger_1displayGenericOutputText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::ITKLogger *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ITKLogger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayGenericOutputText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ITKLogger_displayGenericOutputText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ITKLogger_displayGenericOutputText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ITKLogger_displayGenericOutputText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ITKLogger_1displayDebugText(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::ITKLogger *arg1 = 0 ;
  char *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ITKLogger **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return ;
  }
  {
    try {
      (arg1)->DisplayDebugText((char const *)arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ITKLogger_displayDebugText: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ITKLogger_displayDebugText: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ITKLogger_displayDebugText"); return ; 
      };
    }
  }
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ITKLogger_1setAsGlobalITKLogger(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ITKLogger *arg1 = 0 ;
  itk::simple::ITKLogger result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ITKLogger **)&jarg1; 
  {
    try {
      result = (arg1)->SetAsGlobalITKLogger();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ITKLogger_setAsGlobalITKLogger: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ITKLogger_setAsGlobalITKLogger: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ITKLogger_setAsGlobalITKLogger"); return 0; 
      };
    }
  }
  *(itk::simple::ITKLogger **)&jresult = new itk::simple::ITKLogger(result); 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkAnyEvent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::EventEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::EventEnum)itk::simple::sitkAnyEvent;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkAnyEvent_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkAnyEvent_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkAnyEvent_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkAbortEvent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::EventEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::EventEnum)itk::simple::sitkAbortEvent;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkAbortEvent_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkAbortEvent_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkAbortEvent_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkDeleteEvent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::EventEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::EventEnum)itk::simple::sitkDeleteEvent;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkDeleteEvent_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkDeleteEvent_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkDeleteEvent_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkEndEvent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::EventEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::EventEnum)itk::simple::sitkEndEvent;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkEndEvent_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkEndEvent_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkEndEvent_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkIterationEvent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::EventEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::EventEnum)itk::simple::sitkIterationEvent;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkIterationEvent_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkIterationEvent_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkIterationEvent_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkProgressEvent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::EventEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::EventEnum)itk::simple::sitkProgressEvent;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkProgressEvent_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkProgressEvent_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkProgressEvent_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkStartEvent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::EventEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::EventEnum)itk::simple::sitkStartEvent;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkStartEvent_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkStartEvent_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkStartEvent_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkMultiResolutionIterationEvent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::EventEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::EventEnum)itk::simple::sitkMultiResolutionIterationEvent;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkMultiResolutionIterationEvent_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkMultiResolutionIterationEvent_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkMultiResolutionIterationEvent_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkUserEvent_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::EventEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::EventEnum)itk::simple::sitkUserEvent;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkUserEvent_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkUserEvent_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkUserEvent_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkWallClock_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::SeedEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::SeedEnum)itk::simple::sitkWallClock;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkWallClock_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkWallClock_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkWallClock_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_sitkUnknownTransform_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  itk::simple::TransformEnum result;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::TransformEnum)itk::simple::sitkUnknownTransform;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK sitkUnknownTransform_get: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK sitkUnknownTransform_get: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK sitkUnknownTransform_get"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Transform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::Transform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::Transform *)new itk::simple::Transform();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Transform"); return 0; 
      };
    }
  }
  *(itk::simple::Transform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Transform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  itk::TransformBase *arg1 = 0 ;
  itk::simple::Transform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::TransformBase **)&jarg1; 
  {
    try {
      result = (itk::simple::Transform *)new itk::simple::Transform(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Transform"); return 0; 
      };
    }
  }
  *(itk::simple::Transform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Transform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jint jarg2) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  itk::simple::TransformEnum arg2 ;
  itk::simple::Transform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (itk::simple::TransformEnum)jarg2; 
  {
    try {
      result = (itk::simple::Transform *)new itk::simple::Transform(arg1,arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Transform"); return 0; 
      };
    }
  }
  *(itk::simple::Transform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Transform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::TransformEnum arg2 ;
  itk::simple::Transform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image & is null");
    return 0;
  } 
  arg2 = (itk::simple::TransformEnum)jarg2; 
  {
    try {
      result = (itk::simple::Transform *)new itk::simple::Transform(*arg1,arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Transform"); return 0; 
      };
    }
  }
  *(itk::simple::Transform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Transform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::Transform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Transform *)new itk::simple::Transform(*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Transform"); return 0; 
      };
    }
  }
  *(itk::simple::Transform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1Transform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::Transform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_Transform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_Transform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_Transform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Transform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::Transform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Transform *)new itk::simple::Transform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Transform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Transform"); return 0; 
      };
    }
  }
  *(itk::simple::Transform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1getITKBase_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::TransformBase *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = (itk::TransformBase *)(arg1)->GetITKBase();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_getITKBase: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_getITKBase: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_getITKBase"); return 0; 
      };
    }
  }
  *(itk::TransformBase **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1getDimension(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::Transform const *)arg1)->GetDimension();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_getDimension: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_getDimension: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_getDimension"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1setParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Transform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetParameters((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_setParameters: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_setParameters: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_setParameters"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1getParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Transform const *)arg1)->GetParameters();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_getParameters: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_getParameters: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_getParameters"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1getNumberOfParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::Transform const *)arg1)->GetNumberOfParameters();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_getNumberOfParameters: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_getNumberOfParameters: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_getNumberOfParameters"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1setFixedParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Transform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetFixedParameters((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_setFixedParameters: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_setFixedParameters: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_setFixedParameters"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1getFixedParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Transform const *)arg1)->GetFixedParameters();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_getFixedParameters: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_getFixedParameters: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_getFixedParameters"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1getNumberOfFixedParameters(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::Transform const *)arg1)->GetNumberOfFixedParameters();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_getNumberOfFixedParameters: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_getNumberOfFixedParameters: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_getNumberOfFixedParameters"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1transformPoint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Transform const *)arg1)->TransformPoint((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_transformPoint: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_transformPoint: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_transformPoint"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1transformVector(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = ((itk::simple::Transform const *)arg1)->TransformVector((std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_transformVector: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_transformVector: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_transformVector"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1writeTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::Transform *arg1 = 0 ;
  std::string *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  std::string arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      ((itk::simple::Transform const *)arg1)->WriteTransform((std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_writeTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_writeTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_writeTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1isLinear(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = (bool)((itk::simple::Transform const *)arg1)->IsLinear();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_isLinear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_isLinear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_isLinear"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1setIdentity(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::Transform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      (arg1)->SetIdentity();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_setIdentity: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_setIdentity: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_setIdentity"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1setInverse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = (bool)(arg1)->SetInverse();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_setInverse: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_setInverse: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_setInverse"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1getInverse(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::Transform result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Transform const *)arg1)->GetInverse();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_getInverse: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_getInverse: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_getInverse"); return 0; 
      };
    }
  }
  *(itk::simple::Transform **)&jresult = new itk::simple::Transform(result); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Transform const *)arg1)->ToString();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_toString: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_toString: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_toString"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Transform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1makeUnique(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::Transform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      (arg1)->MakeUnique();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_makeUnique: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_makeUnique: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_makeUnique"); return ; 
      };
    }
  }
}


SWIGEXPORT jint JNICALL Java_org_itk_simple_SimpleITKJNI_Transform_1getTransformEnum(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::TransformEnum result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1; 
  {
    try {
      result = (itk::simple::TransformEnum)((itk::simple::Transform const *)arg1)->GetTransformEnum();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Transform_getTransformEnum: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Transform_getTransformEnum: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Transform_getTransformEnum"); return 0; 
      };
    }
  }
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_readTransform(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  itk::simple::PathType *arg1 = 0 ;
  itk::simple::Transform result;
  
  (void)jenv;
  (void)jcls;
  if(!jarg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return 0;
  }
  const char *arg1_pstr = jenv->GetStringUTFChars(jarg1, 0); 
  if (!arg1_pstr) return 0;
  itk::simple::PathType arg1_str(arg1_pstr);
  arg1 = &arg1_str;
  jenv->ReleaseStringUTFChars(jarg1, arg1_pstr); 
  {
    try {
      result = itk::simple::ReadTransform((std::string const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK readTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK readTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK readTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Transform **)&jresult = new itk::simple::Transform(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_writeTransform(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::PathType *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return ;
  } 
  if(!jarg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null string");
    return ;
  }
  const char *arg2_pstr = jenv->GetStringUTFChars(jarg2, 0); 
  if (!arg2_pstr) return ;
  itk::simple::PathType arg2_str(arg2_pstr);
  arg2 = &arg2_str;
  jenv->ReleaseStringUTFChars(jarg2, arg2_pstr); 
  {
    try {
      itk::simple::WriteTransform((itk::simple::Transform const &)*arg1,(std::string const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK writeTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK writeTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK writeTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1BSplineTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::BSplineTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_BSplineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_BSplineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_BSplineTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1BSplineTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  unsigned int arg2 ;
  itk::simple::BSplineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      result = (itk::simple::BSplineTransform *)new itk::simple::BSplineTransform(arg1,arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_BSplineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::BSplineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1BSplineTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  itk::simple::BSplineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  {
    try {
      result = (itk::simple::BSplineTransform *)new itk::simple::BSplineTransform(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_BSplineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::BSplineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1BSplineTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Image > *arg1 = 0 ;
  unsigned int arg2 ;
  itk::simple::BSplineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Image > const & is null");
    return 0;
  } 
  arg2 = (unsigned int)jarg2; 
  {
    try {
      result = (itk::simple::BSplineTransform *)new itk::simple::BSplineTransform((std::vector< itk::simple::Image > const &)*arg1,arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_BSplineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::BSplineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1BSplineTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< itk::simple::Image > *arg1 = 0 ;
  itk::simple::BSplineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< itk::simple::Image > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< itk::simple::Image > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::BSplineTransform *)new itk::simple::BSplineTransform((std::vector< itk::simple::Image > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_BSplineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::BSplineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1BSplineTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::BSplineTransform *arg1 = 0 ;
  itk::simple::BSplineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::BSplineTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::BSplineTransform *)new itk::simple::BSplineTransform((itk::simple::BSplineTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_BSplineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::BSplineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1BSplineTransform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::BSplineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::BSplineTransform *)new itk::simple::BSplineTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_BSplineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_BSplineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::BSplineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::BSplineTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1setTransformDomainDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTransformDomainDirection((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_setTransformDomainDirection: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_setTransformDomainDirection: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_setTransformDomainDirection"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1getTransformDomainDirection(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::BSplineTransform const *)arg1)->GetTransformDomainDirection();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_getTransformDomainDirection: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_getTransformDomainDirection: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_getTransformDomainDirection"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1setTransformDomainMeshSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTransformDomainMeshSize((std::vector< unsigned int > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_setTransformDomainMeshSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_setTransformDomainMeshSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_setTransformDomainMeshSize"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1getTransformDomainMeshSize(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::vector< unsigned int > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::BSplineTransform const *)arg1)->GetTransformDomainMeshSize();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_getTransformDomainMeshSize: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_getTransformDomainMeshSize: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_getTransformDomainMeshSize"); return 0; 
      };
    }
  }
  *(std::vector< unsigned int > **)&jresult = new std::vector< unsigned int >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1setTransformDomainOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTransformDomainOrigin((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_setTransformDomainOrigin: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_setTransformDomainOrigin: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_setTransformDomainOrigin"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1getTransformDomainOrigin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::BSplineTransform const *)arg1)->GetTransformDomainOrigin();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_getTransformDomainOrigin: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_getTransformDomainOrigin: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_getTransformDomainOrigin"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1setTransformDomainPhysicalDimensions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTransformDomainPhysicalDimensions((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_setTransformDomainPhysicalDimensions: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_setTransformDomainPhysicalDimensions: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_setTransformDomainPhysicalDimensions"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1getTransformDomainPhysicalDimensions(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::BSplineTransform const *)arg1)->GetTransformDomainPhysicalDimensions();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_getTransformDomainPhysicalDimensions: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_getTransformDomainPhysicalDimensions: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_getTransformDomainPhysicalDimensions"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1getCoefficientImages(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::BSplineTransform *arg1 = 0 ;
  std::vector< itk::simple::Image > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::BSplineTransform const *)arg1)->GetCoefficientImages();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_getCoefficientImages: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_getCoefficientImages: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_getCoefficientImages"); return 0; 
      };
    }
  }
  *(std::vector< itk::simple::Image > **)&jresult = new std::vector< itk::simple::Image >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_BSplineTransform_1getOrder(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::BSplineTransform *arg1 = 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::BSplineTransform **)&jarg1; 
  {
    try {
      result = (unsigned int)((itk::simple::BSplineTransform const *)arg1)->GetOrder();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK BSplineTransform_getOrder: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK BSplineTransform_getOrder: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK BSplineTransform_getOrder"); return 0; 
      };
    }
  }
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1DisplacementFieldTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_DisplacementFieldTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_DisplacementFieldTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_DisplacementFieldTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1DisplacementFieldTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  itk::simple::DisplacementFieldTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  {
    try {
      result = (itk::simple::DisplacementFieldTransform *)new itk::simple::DisplacementFieldTransform(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_DisplacementFieldTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_DisplacementFieldTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_DisplacementFieldTransform"); return 0; 
      };
    }
  }
  *(itk::simple::DisplacementFieldTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1DisplacementFieldTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Image *arg1 = 0 ;
  itk::simple::DisplacementFieldTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Image **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::DisplacementFieldTransform *)new itk::simple::DisplacementFieldTransform(*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_DisplacementFieldTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_DisplacementFieldTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_DisplacementFieldTransform"); return 0; 
      };
    }
  }
  *(itk::simple::DisplacementFieldTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1DisplacementFieldTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  itk::simple::DisplacementFieldTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::DisplacementFieldTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::DisplacementFieldTransform *)new itk::simple::DisplacementFieldTransform((itk::simple::DisplacementFieldTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_DisplacementFieldTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_DisplacementFieldTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_DisplacementFieldTransform"); return 0; 
      };
    }
  }
  *(itk::simple::DisplacementFieldTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1DisplacementFieldTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::DisplacementFieldTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::DisplacementFieldTransform *)new itk::simple::DisplacementFieldTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_DisplacementFieldTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_DisplacementFieldTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_DisplacementFieldTransform"); return 0; 
      };
    }
  }
  *(itk::simple::DisplacementFieldTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::DisplacementFieldTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setDisplacementField(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  itk::simple::Image *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  arg2 = *(itk::simple::Image **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetDisplacementField(*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setDisplacementField: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setDisplacementField: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setDisplacementField"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1getDisplacementField(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  itk::simple::Image result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::DisplacementFieldTransform const *)arg1)->GetDisplacementField();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_getDisplacementField: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_getDisplacementField: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_getDisplacementField"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = new itk::simple::Image(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setInverseDisplacementField(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  itk::simple::Image *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  arg2 = *(itk::simple::Image **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Image & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetInverseDisplacementField(*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setInverseDisplacementField: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setInverseDisplacementField: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setInverseDisplacementField"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1getInverseDisplacementField(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  itk::simple::Image result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::DisplacementFieldTransform const *)arg1)->GetInverseDisplacementField();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_getInverseDisplacementField: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_getInverseDisplacementField: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_getInverseDisplacementField"); return 0; 
      };
    }
  }
  *(itk::simple::Image **)&jresult = new itk::simple::Image(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setInterpolator(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  itk::simple::InterpolatorEnum arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  arg2 = (itk::simple::InterpolatorEnum)jarg2; 
  {
    try {
      (arg1)->SetInterpolator(arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setInterpolator: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setInterpolator: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setInterpolator"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setSmoothingOff(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  {
    try {
      (arg1)->SetSmoothingOff();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingOff: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingOff: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingOff"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setSmoothingGaussianOnUpdate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->SetSmoothingGaussianOnUpdate(arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingGaussianOnUpdate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingGaussianOnUpdate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingGaussianOnUpdate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setSmoothingGaussianOnUpdate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetSmoothingGaussianOnUpdate(arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingGaussianOnUpdate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingGaussianOnUpdate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingGaussianOnUpdate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setSmoothingGaussianOnUpdate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  {
    try {
      (arg1)->SetSmoothingGaussianOnUpdate();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingGaussianOnUpdate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingGaussianOnUpdate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingGaussianOnUpdate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setSmoothingBSplineOnUpdate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4, jlong jarg5) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  std::vector< unsigned int > *arg3 = 0 ;
  bool arg4 ;
  unsigned int arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return ;
  } 
  arg3 = *(std::vector< unsigned int > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return ;
  } 
  arg4 = jarg4 ? true : false; 
  arg5 = (unsigned int)jarg5; 
  {
    try {
      (arg1)->SetSmoothingBSplineOnUpdate((std::vector< unsigned int > const &)*arg2,(std::vector< unsigned int > const &)*arg3,arg4,arg5);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setSmoothingBSplineOnUpdate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jboolean jarg4) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  std::vector< unsigned int > *arg3 = 0 ;
  bool arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return ;
  } 
  arg3 = *(std::vector< unsigned int > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return ;
  } 
  arg4 = jarg4 ? true : false; 
  {
    try {
      (arg1)->SetSmoothingBSplineOnUpdate((std::vector< unsigned int > const &)*arg2,(std::vector< unsigned int > const &)*arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setSmoothingBSplineOnUpdate_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  std::vector< unsigned int > *arg3 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return ;
  } 
  arg3 = *(std::vector< unsigned int > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetSmoothingBSplineOnUpdate((std::vector< unsigned int > const &)*arg2,(std::vector< unsigned int > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setSmoothingBSplineOnUpdate_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  std::vector< unsigned int > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  arg2 = *(std::vector< unsigned int > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< unsigned int > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetSmoothingBSplineOnUpdate((std::vector< unsigned int > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_DisplacementFieldTransform_1setSmoothingBSplineOnUpdate_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::DisplacementFieldTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::DisplacementFieldTransform **)&jarg1; 
  {
    try {
      (arg1)->SetSmoothingBSplineOnUpdate();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK DisplacementFieldTransform_setSmoothingBSplineOnUpdate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1AffineTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::AffineTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_AffineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_AffineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_AffineTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1AffineTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  itk::simple::AffineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  {
    try {
      result = (itk::simple::AffineTransform *)new itk::simple::AffineTransform(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_AffineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::AffineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1AffineTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::AffineTransform *arg1 = 0 ;
  itk::simple::AffineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::AffineTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::AffineTransform *)new itk::simple::AffineTransform((itk::simple::AffineTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_AffineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::AffineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1AffineTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::AffineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::AffineTransform *)new itk::simple::AffineTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_AffineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::AffineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1AffineTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  itk::simple::AffineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::AffineTransform *)new itk::simple::AffineTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_AffineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::AffineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1AffineTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  itk::simple::AffineTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::AffineTransform *)new itk::simple::AffineTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_AffineTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_AffineTransform"); return 0; 
      };
    }
  }
  *(itk::simple::AffineTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::AffineTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::AffineTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1getTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::AffineTransform const *)arg1)->GetTranslation();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_getTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_getTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_getTranslation"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1setTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTranslation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_setTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_setTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_setTranslation"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1setMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetMatrix((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_setMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_setMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_setMatrix"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1getMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::AffineTransform const *)arg1)->GetMatrix();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_getMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_getMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_getMatrix"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1setCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetCenter((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_setCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_setCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_setCenter"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1getCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::AffineTransform const *)arg1)->GetCenter();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_getCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_getCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_getCenter"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1scale_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->Scale((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_scale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_scale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_scale"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1scale_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->Scale((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_scale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_scale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_scale"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1scale_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  itk::simple::AffineTransform *arg1 = 0 ;
  double arg2 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->Scale(arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_scale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_scale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_scale"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1scale_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  itk::simple::AffineTransform *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->Scale(arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_scale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_scale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_scale"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1shear_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4, jboolean jarg5) {
  itk::simple::AffineTransform *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      (arg1)->Shear(arg2,arg3,arg4,arg5);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_shear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_shear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_shear"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1shear_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4) {
  itk::simple::AffineTransform *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      (arg1)->Shear(arg2,arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_shear: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_shear: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_shear"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1translate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jboolean jarg3) {
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  bool arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  arg3 = jarg3 ? true : false; 
  {
    try {
      (arg1)->Translate((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_translate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_translate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_translate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1translate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::AffineTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->Translate((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_translate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_translate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_translate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1rotate_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4, jboolean jarg5) {
  itk::simple::AffineTransform *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  bool arg5 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = jarg5 ? true : false; 
  {
    try {
      (arg1)->Rotate(arg2,arg3,arg4,arg5);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_rotate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_rotate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_rotate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_AffineTransform_1rotate_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2, jint jarg3, jdouble jarg4) {
  itk::simple::AffineTransform *arg1 = 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::AffineTransform **)&jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      (arg1)->Rotate(arg2,arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK AffineTransform_rotate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK AffineTransform_rotate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK AffineTransform_rotate"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1Euler3DTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::Euler3DTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_Euler3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_Euler3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_Euler3DTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler3DTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::Euler3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::Euler3DTransform *)new itk::simple::Euler3DTransform();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler3DTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  std::vector< double > *arg5 = 0 ;
  itk::simple::Euler3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg5_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Euler3DTransform *)new itk::simple::Euler3DTransform((std::vector< double > const &)*arg1,arg2,arg3,arg4,(std::vector< double > const &)*arg5);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler3DTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  itk::simple::Euler3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      result = (itk::simple::Euler3DTransform *)new itk::simple::Euler3DTransform((std::vector< double > const &)*arg1,arg2,arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler3DTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  itk::simple::Euler3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  {
    try {
      result = (itk::simple::Euler3DTransform *)new itk::simple::Euler3DTransform((std::vector< double > const &)*arg1,arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler3DTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  double arg2 ;
  itk::simple::Euler3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = (double)jarg2; 
  {
    try {
      result = (itk::simple::Euler3DTransform *)new itk::simple::Euler3DTransform((std::vector< double > const &)*arg1,arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler3DTransform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  itk::simple::Euler3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Euler3DTransform *)new itk::simple::Euler3DTransform((std::vector< double > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler3DTransform_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Euler3DTransform *arg1 = 0 ;
  itk::simple::Euler3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Euler3DTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Euler3DTransform *)new itk::simple::Euler3DTransform((itk::simple::Euler3DTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler3DTransform_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::Euler3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Euler3DTransform *)new itk::simple::Euler3DTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Euler3DTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Euler3DTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1setCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Euler3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetCenter((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_setCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_setCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_setCenter"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1getCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Euler3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Euler3DTransform const *)arg1)->GetCenter();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_getCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_getCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_getCenter"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1getAngleX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  itk::simple::Euler3DTransform *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      result = (double)((itk::simple::Euler3DTransform const *)arg1)->GetAngleX();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_getAngleX: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_getAngleX: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_getAngleX"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1getAngleY(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  itk::simple::Euler3DTransform *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      result = (double)((itk::simple::Euler3DTransform const *)arg1)->GetAngleY();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_getAngleY: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_getAngleY: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_getAngleY"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1getAngleZ(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  itk::simple::Euler3DTransform *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      result = (double)((itk::simple::Euler3DTransform const *)arg1)->GetAngleZ();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_getAngleZ: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_getAngleZ: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_getAngleZ"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1setRotation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3, jdouble jarg4) {
  itk::simple::Euler3DTransform *arg1 = 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  {
    try {
      (arg1)->SetRotation(arg2,arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_setRotation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_setRotation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_setRotation"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1getTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Euler3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Euler3DTransform const *)arg1)->GetTranslation();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_getTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_getTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_getTranslation"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1setTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Euler3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTranslation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_setTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_setTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_setTranslation"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1setComputeZYX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jboolean jarg2) {
  itk::simple::Euler3DTransform *arg1 = 0 ;
  bool arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    try {
      (arg1)->SetComputeZYX(arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_setComputeZYX: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_setComputeZYX: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_setComputeZYX"); return ; 
      };
    }
  }
}


SWIGEXPORT jboolean JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1getComputeZYX(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  itk::simple::Euler3DTransform *arg1 = 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      result = (bool)((itk::simple::Euler3DTransform const *)arg1)->GetComputeZYX();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_getComputeZYX: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_getComputeZYX: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_getComputeZYX"); return 0; 
      };
    }
  }
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1computeZYXOn(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::Euler3DTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      (arg1)->ComputeZYXOn();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_computeZYXOn: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_computeZYXOn: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_computeZYXOn"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1computeZYXOff(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  itk::simple::Euler3DTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      (arg1)->ComputeZYXOff();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_computeZYXOff: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_computeZYXOff: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_computeZYXOff"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1getMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Euler3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Euler3DTransform const *)arg1)->GetMatrix();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_getMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_getMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_getMatrix"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1setMatrix_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  itk::simple::Euler3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->SetMatrix((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_setMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_setMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_setMatrix"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler3DTransform_1setMatrix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Euler3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Euler3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetMatrix((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler3DTransform_setMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler3DTransform_setMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler3DTransform_setMatrix"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1Euler2DTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::Euler2DTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_Euler2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_Euler2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_Euler2DTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler2DTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::Euler2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::Euler2DTransform *)new itk::simple::Euler2DTransform();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler2DTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  double arg2 ;
  std::vector< double > *arg3 = 0 ;
  itk::simple::Euler2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = (double)jarg2; 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Euler2DTransform *)new itk::simple::Euler2DTransform((std::vector< double > const &)*arg1,arg2,(std::vector< double > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler2DTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  double arg2 ;
  itk::simple::Euler2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = (double)jarg2; 
  {
    try {
      result = (itk::simple::Euler2DTransform *)new itk::simple::Euler2DTransform((std::vector< double > const &)*arg1,arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler2DTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  itk::simple::Euler2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Euler2DTransform *)new itk::simple::Euler2DTransform((std::vector< double > const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler2DTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Euler2DTransform *arg1 = 0 ;
  itk::simple::Euler2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Euler2DTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Euler2DTransform *)new itk::simple::Euler2DTransform((itk::simple::Euler2DTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Euler2DTransform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::Euler2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Euler2DTransform *)new itk::simple::Euler2DTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Euler2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Euler2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Euler2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Euler2DTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Euler2DTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1setCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Euler2DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetCenter((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_setCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_setCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_setCenter"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1getCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Euler2DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Euler2DTransform const *)arg1)->GetCenter();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_getCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_getCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_getCenter"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1setAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  itk::simple::Euler2DTransform *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetAngle(arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_setAngle: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_setAngle: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_setAngle"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1getAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  itk::simple::Euler2DTransform *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  {
    try {
      result = (double)((itk::simple::Euler2DTransform const *)arg1)->GetAngle();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_getAngle: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_getAngle: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_getAngle"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1getTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Euler2DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Euler2DTransform const *)arg1)->GetTranslation();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_getTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_getTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_getTranslation"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1setTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Euler2DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTranslation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_setTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_setTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_setTranslation"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1getMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Euler2DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Euler2DTransform const *)arg1)->GetMatrix();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_getMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_getMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_getMatrix"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1setMatrix_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  itk::simple::Euler2DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->SetMatrix((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_setMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_setMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_setMatrix"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Euler2DTransform_1setMatrix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Euler2DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Euler2DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetMatrix((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Euler2DTransform_setMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Euler2DTransform_setMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Euler2DTransform_setMatrix"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1ScaleTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::ScaleTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::ScaleTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_ScaleTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_ScaleTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_ScaleTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  std::vector< double > *arg2 = 0 ;
  itk::simple::ScaleTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = (unsigned int)jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleTransform *)new itk::simple::ScaleTransform(arg1,(std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  jlong jresult = 0 ;
  unsigned int arg1 ;
  itk::simple::ScaleTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (unsigned int)jarg1; 
  {
    try {
      result = (itk::simple::ScaleTransform *)new itk::simple::ScaleTransform(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleTransform *arg1 = 0 ;
  itk::simple::ScaleTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::ScaleTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleTransform *)new itk::simple::ScaleTransform((itk::simple::ScaleTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::ScaleTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleTransform *)new itk::simple::ScaleTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::ScaleTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleTransform_1setScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetScale((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleTransform_setScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleTransform_setScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleTransform_setScale"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleTransform_1getScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleTransform const *)arg1)->GetScale();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleTransform_getScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleTransform_getScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleTransform_getScale"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleTransform_1setCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetCenter((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleTransform_setCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleTransform_setCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleTransform_setCenter"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleTransform_1getCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleTransform const *)arg1)->GetCenter();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleTransform_getCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleTransform_getCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleTransform_getCenter"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleTransform_1getMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleTransform const *)arg1)->GetMatrix();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleTransform_getMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleTransform_getMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleTransform_getMatrix"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1ScaleSkewVersor3DTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_ScaleSkewVersor3DTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleSkewVersor3DTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::ScaleSkewVersor3DTransform *)new itk::simple::ScaleSkewVersor3DTransform();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleSkewVersor3DTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::ScaleSkewVersor3DTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleSkewVersor3DTransform *)new itk::simple::ScaleSkewVersor3DTransform((itk::simple::ScaleSkewVersor3DTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleSkewVersor3DTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleSkewVersor3DTransform *)new itk::simple::ScaleSkewVersor3DTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleSkewVersor3DTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  std::vector< double > *arg4 = 0 ;
  std::vector< double > *arg5 = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = *(std::vector< double > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleSkewVersor3DTransform *)new itk::simple::ScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,(std::vector< double > const &)*arg4,(std::vector< double > const &)*arg5);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleSkewVersor3DTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  std::vector< double > *arg4 = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = *(std::vector< double > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleSkewVersor3DTransform *)new itk::simple::ScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,(std::vector< double > const &)*arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleSkewVersor3DTransform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleSkewVersor3DTransform *)new itk::simple::ScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleSkewVersor3DTransform_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  double arg4 ;
  std::vector< double > *arg5 = 0 ;
  std::vector< double > *arg6 = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg6 = *(std::vector< double > **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleSkewVersor3DTransform *)new itk::simple::ScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,arg4,(std::vector< double > const &)*arg5,(std::vector< double > const &)*arg6);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleSkewVersor3DTransform_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  double arg4 ;
  std::vector< double > *arg5 = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleSkewVersor3DTransform *)new itk::simple::ScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,arg4,(std::vector< double > const &)*arg5);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleSkewVersor3DTransform_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  double arg4 ;
  itk::simple::ScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  {
    try {
      result = (itk::simple::ScaleSkewVersor3DTransform *)new itk::simple::ScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleSkewVersor3DTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1setCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetCenter((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_setCenter"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1getCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleSkewVersor3DTransform const *)arg1)->GetCenter();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_getCenter"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1setRotation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetRotation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setRotation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setRotation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_setRotation"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1setRotation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->SetRotation((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setRotation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setRotation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_setRotation"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1getVersor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleSkewVersor3DTransform const *)arg1)->GetVersor();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getVersor: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getVersor: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_getVersor"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1getTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleSkewVersor3DTransform const *)arg1)->GetTranslation();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_getTranslation"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1setTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTranslation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_setTranslation"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1getScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleSkewVersor3DTransform const *)arg1)->GetScale();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_getScale"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1setScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetScale((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_setScale"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1getSkew(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleSkewVersor3DTransform const *)arg1)->GetSkew();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getSkew: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getSkew: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_getSkew"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1setSkew(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetSkew((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setSkew: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_setSkew: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_setSkew"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1translate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->Translate((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_translate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_translate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_translate"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleSkewVersor3DTransform_1getMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleSkewVersor3DTransform const *)arg1)->GetMatrix();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleSkewVersor3DTransform_getMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleSkewVersor3DTransform_getMatrix"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1ComposeScaleSkewVersor3DTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_ComposeScaleSkewVersor3DTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ComposeScaleSkewVersor3DTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::ComposeScaleSkewVersor3DTransform *)new itk::simple::ComposeScaleSkewVersor3DTransform();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ComposeScaleSkewVersor3DTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::ComposeScaleSkewVersor3DTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ComposeScaleSkewVersor3DTransform *)new itk::simple::ComposeScaleSkewVersor3DTransform((itk::simple::ComposeScaleSkewVersor3DTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ComposeScaleSkewVersor3DTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ComposeScaleSkewVersor3DTransform *)new itk::simple::ComposeScaleSkewVersor3DTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ComposeScaleSkewVersor3DTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  std::vector< double > *arg4 = 0 ;
  std::vector< double > *arg5 = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = *(std::vector< double > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ComposeScaleSkewVersor3DTransform *)new itk::simple::ComposeScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,(std::vector< double > const &)*arg4,(std::vector< double > const &)*arg5);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ComposeScaleSkewVersor3DTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  std::vector< double > *arg4 = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = *(std::vector< double > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ComposeScaleSkewVersor3DTransform *)new itk::simple::ComposeScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,(std::vector< double > const &)*arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ComposeScaleSkewVersor3DTransform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ComposeScaleSkewVersor3DTransform *)new itk::simple::ComposeScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ComposeScaleSkewVersor3DTransform_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jlong jarg5, jobject jarg5_, jlong jarg6, jobject jarg6_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  double arg4 ;
  std::vector< double > *arg5 = 0 ;
  std::vector< double > *arg6 = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg5_;
  (void)jarg6_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg6 = *(std::vector< double > **)&jarg6;
  if (!arg6) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ComposeScaleSkewVersor3DTransform *)new itk::simple::ComposeScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,arg4,(std::vector< double > const &)*arg5,(std::vector< double > const &)*arg6);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ComposeScaleSkewVersor3DTransform_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  double arg4 ;
  std::vector< double > *arg5 = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg5_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ComposeScaleSkewVersor3DTransform *)new itk::simple::ComposeScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,arg4,(std::vector< double > const &)*arg5);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ComposeScaleSkewVersor3DTransform_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jdouble jarg4) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  double arg4 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = (double)jarg4; 
  {
    try {
      result = (itk::simple::ComposeScaleSkewVersor3DTransform *)new itk::simple::ComposeScaleSkewVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ComposeScaleSkewVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ComposeScaleSkewVersor3DTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1setCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetCenter((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setCenter"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1getCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ComposeScaleSkewVersor3DTransform const *)arg1)->GetCenter();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getCenter"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1setRotation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetRotation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setRotation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setRotation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setRotation"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1setRotation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->SetRotation((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setRotation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setRotation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setRotation"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1getVersor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ComposeScaleSkewVersor3DTransform const *)arg1)->GetVersor();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getVersor: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getVersor: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getVersor"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1getTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ComposeScaleSkewVersor3DTransform const *)arg1)->GetTranslation();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getTranslation"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1setTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTranslation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setTranslation"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1getScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ComposeScaleSkewVersor3DTransform const *)arg1)->GetScale();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getScale"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1setScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetScale((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setScale"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1getSkew(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ComposeScaleSkewVersor3DTransform const *)arg1)->GetSkew();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getSkew: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getSkew: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getSkew"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1setSkew(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetSkew((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setSkew: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setSkew: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_setSkew"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1translate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->Translate((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_translate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_translate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_translate"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ComposeScaleSkewVersor3DTransform_1getMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ComposeScaleSkewVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ComposeScaleSkewVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ComposeScaleSkewVersor3DTransform const *)arg1)->GetMatrix();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ComposeScaleSkewVersor3DTransform_getMatrix"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1ScaleVersor3DTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_ScaleVersor3DTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleVersor3DTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::ScaleVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::ScaleVersor3DTransform *)new itk::simple::ScaleVersor3DTransform();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleVersor3DTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  itk::simple::ScaleVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::ScaleVersor3DTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleVersor3DTransform *)new itk::simple::ScaleVersor3DTransform((itk::simple::ScaleVersor3DTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleVersor3DTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::ScaleVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleVersor3DTransform *)new itk::simple::ScaleVersor3DTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleVersor3DTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  std::vector< double > *arg4 = 0 ;
  itk::simple::ScaleVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = *(std::vector< double > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleVersor3DTransform *)new itk::simple::ScaleVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3,(std::vector< double > const &)*arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleVersor3DTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  itk::simple::ScaleVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleVersor3DTransform *)new itk::simple::ScaleVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,(std::vector< double > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleVersor3DTransform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  itk::simple::ScaleVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleVersor3DTransform *)new itk::simple::ScaleVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleVersor3DTransform_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jlong jarg4, jobject jarg4_, jlong jarg5, jobject jarg5_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  double arg3 ;
  std::vector< double > *arg4 = 0 ;
  std::vector< double > *arg5 = 0 ;
  itk::simple::ScaleVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  (void)jarg5_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  arg4 = *(std::vector< double > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg5 = *(std::vector< double > **)&jarg5;
  if (!arg5) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleVersor3DTransform *)new itk::simple::ScaleVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,arg3,(std::vector< double > const &)*arg4,(std::vector< double > const &)*arg5);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleVersor3DTransform_1_1SWIG_17(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  double arg3 ;
  std::vector< double > *arg4 = 0 ;
  itk::simple::ScaleVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg4_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  arg4 = *(std::vector< double > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::ScaleVersor3DTransform *)new itk::simple::ScaleVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,arg3,(std::vector< double > const &)*arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1ScaleVersor3DTransform_1_1SWIG_18(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  jlong jresult = 0 ;
  std::vector< double > *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  double arg3 ;
  itk::simple::ScaleVersor3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(std::vector< double > **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      result = (itk::simple::ScaleVersor3DTransform *)new itk::simple::ScaleVersor3DTransform((std::vector< double > const &)*arg1,(std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_ScaleVersor3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_ScaleVersor3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::ScaleVersor3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleVersor3DTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1setCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetCenter((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_setCenter"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1getCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleVersor3DTransform const *)arg1)->GetCenter();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_getCenter"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1setRotation_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetRotation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setRotation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setRotation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_setRotation"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1setRotation_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->SetRotation((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setRotation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setRotation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_setRotation"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1getVersor(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleVersor3DTransform const *)arg1)->GetVersor();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getVersor: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getVersor: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_getVersor"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1getTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleVersor3DTransform const *)arg1)->GetTranslation();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_getTranslation"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1setTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTranslation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_setTranslation"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1getScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleVersor3DTransform const *)arg1)->GetScale();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_getScale"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1setScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetScale((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_setScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_setScale"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1translate(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->Translate((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_translate: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_translate: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_translate"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_ScaleVersor3DTransform_1getMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::ScaleVersor3DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::ScaleVersor3DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::ScaleVersor3DTransform const *)arg1)->GetMatrix();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK ScaleVersor3DTransform_getMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK ScaleVersor3DTransform_getMatrix"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1Similarity2DTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_Similarity2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_Similarity2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_Similarity2DTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity2DTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::Similarity2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::Similarity2DTransform *)new itk::simple::Similarity2DTransform();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity2DTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  double arg1 ;
  double arg2 ;
  std::vector< double > *arg3 = 0 ;
  std::vector< double > *arg4 = 0 ;
  itk::simple::Similarity2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = *(std::vector< double > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Similarity2DTransform *)new itk::simple::Similarity2DTransform(arg1,arg2,(std::vector< double > const &)*arg3,(std::vector< double > const &)*arg4);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity2DTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2, jlong jarg3, jobject jarg3_) {
  jlong jresult = 0 ;
  double arg1 ;
  double arg2 ;
  std::vector< double > *arg3 = 0 ;
  itk::simple::Similarity2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg3_;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Similarity2DTransform *)new itk::simple::Similarity2DTransform(arg1,arg2,(std::vector< double > const &)*arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity2DTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jdouble jarg1, jdouble jarg2) {
  jlong jresult = 0 ;
  double arg1 ;
  double arg2 ;
  itk::simple::Similarity2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      result = (itk::simple::Similarity2DTransform *)new itk::simple::Similarity2DTransform(arg1,arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity2DTransform_1_1SWIG_14(JNIEnv *jenv, jclass jcls, jdouble jarg1) {
  jlong jresult = 0 ;
  double arg1 ;
  itk::simple::Similarity2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (double)jarg1; 
  {
    try {
      result = (itk::simple::Similarity2DTransform *)new itk::simple::Similarity2DTransform(arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity2DTransform_1_1SWIG_15(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  itk::simple::Similarity2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Similarity2DTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Similarity2DTransform *)new itk::simple::Similarity2DTransform((itk::simple::Similarity2DTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity2DTransform_1_1SWIG_16(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::Similarity2DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Similarity2DTransform *)new itk::simple::Similarity2DTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity2DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity2DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity2DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jstring JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  std::string result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Similarity2DTransform const *)arg1)->GetName();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getName: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getName: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_getName"); return 0; 
      };
    }
  }
  jresult = jenv->NewStringUTF((&result)->c_str()); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1setCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetCenter((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_setCenter"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1getCenter(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Similarity2DTransform const *)arg1)->GetCenter();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getCenter: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getCenter: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_getCenter"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1setAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetAngle(arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setAngle: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setAngle: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_setAngle"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1getAngle(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  {
    try {
      result = (double)((itk::simple::Similarity2DTransform const *)arg1)->GetAngle();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getAngle: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getAngle: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_getAngle"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1getTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Similarity2DTransform const *)arg1)->GetTranslation();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_getTranslation"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1setTranslation(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetTranslation((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setTranslation: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setTranslation: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_setTranslation"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1setScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  arg2 = (double)jarg2; 
  {
    try {
      (arg1)->SetScale(arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_setScale"); return ; 
      };
    }
  }
}


SWIGEXPORT jdouble JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1getScale(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  {
    try {
      result = (double)((itk::simple::Similarity2DTransform const *)arg1)->GetScale();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getScale: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getScale: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_getScale"); return 0; 
      };
    }
  }
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1getMatrix(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  std::vector< double > result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  {
    try {
      result = ((itk::simple::Similarity2DTransform const *)arg1)->GetMatrix();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_getMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_getMatrix"); return 0; 
      };
    }
  }
  *(std::vector< double > **)&jresult = new std::vector< double >(result); 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1setMatrix_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3) {
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  arg3 = (double)jarg3; 
  {
    try {
      (arg1)->SetMatrix((std::vector< double > const &)*arg2,arg3);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_setMatrix"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_Similarity2DTransform_1setMatrix_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  itk::simple::Similarity2DTransform *arg1 = 0 ;
  std::vector< double > *arg2 = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(itk::simple::Similarity2DTransform **)&jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return ;
  } 
  {
    try {
      (arg1)->SetMatrix((std::vector< double > const &)*arg2);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setMatrix: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK Similarity2DTransform_setMatrix: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK Similarity2DTransform_setMatrix"); return ; 
      };
    }
  }
}


SWIGEXPORT void JNICALL Java_org_itk_simple_SimpleITKJNI_delete_1Similarity3DTransform(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  itk::simple::Similarity3DTransform *arg1 = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(itk::simple::Similarity3DTransform **)&jarg1; 
  {
    try {
      delete arg1;
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK delete_Similarity3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK delete_Similarity3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return ; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK delete_Similarity3DTransform"); return ; 
      };
    }
  }
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity3DTransform_1_1SWIG_10(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  itk::simple::Similarity3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  {
    try {
      result = (itk::simple::Similarity3DTransform *)new itk::simple::Similarity3DTransform();
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity3DTransform_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Similarity3DTransform *arg1 = 0 ;
  itk::simple::Similarity3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Similarity3DTransform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Similarity3DTransform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Similarity3DTransform *)new itk::simple::Similarity3DTransform((itk::simple::Similarity3DTransform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity3DTransform_1_1SWIG_12(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  itk::simple::Transform *arg1 = 0 ;
  itk::simple::Similarity3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(itk::simple::Transform **)&jarg1;
  if (!arg1) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "itk::simple::Transform const & is null");
    return 0;
  } 
  {
    try {
      result = (itk::simple::Similarity3DTransform *)new itk::simple::Similarity3DTransform((itk::simple::Transform const &)*arg1);
    } catch( std::exception &ex ) {
      const size_t e_size = 10240;
      char error_msg[e_size];
      // TODO this should be replaces with some try compile stuff
      
#ifdef _MSC_VER
      _snprintf_s( error_msg, e_size, e_size, "Exception thrown in SimpleITK new_Similarity3DTransform: %s", ex.what() );
#else
      snprintf( error_msg, e_size, "Exception thrown in SimpleITK new_Similarity3DTransform: %s", ex.what() );
#endif
      
      {
        SWIG_JavaException(jenv, SWIG_RuntimeError, error_msg); return 0; 
      };
    } catch( ... ) {
      {
        SWIG_JavaException(jenv, SWIG_UnknownError, "Unknown exception thrown in SimpleITK new_Similarity3DTransform"); return 0; 
      };
    }
  }
  *(itk::simple::Similarity3DTransform **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_itk_simple_SimpleITKJNI_new_1Similarity3DTransform_1_1SWIG_13(JNIEnv *jenv, jclass jcls, jdouble jarg1, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_) {
  jlong jresult = 0 ;
  double arg1 ;
  std::vector< double > *arg2 = 0 ;
  std::vector< double > *arg3 = 0 ;
  std::vector< double > *arg4 = 0 ;
  itk::simple::Similarity3DTransform *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = (double)jarg1; 
  arg2 = *(std::vector< double > **)&jarg2;
  if (!arg2) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg3 = *(std::vector< double > **)&jarg3;
  if (!arg3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  arg4 = *(std::vector< double > **)&jarg4;
  if (!arg4) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "std::vector< double > const & is null");
    return 0;
  } 
  {
    try {
