/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkWarpImageFilter.h"
#include "itkWarpImageFilter.h"

// Additional include files
#include "sitkCreateInterpolator.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
WarpImageFilter::WarpImageFilter ()
{

  this->m_DualMemberFactory.reset( new detail::DualMemberFunctionFactory<MemberFunctionType>( this ) );
  using PixelIDTypeList2 = RealVectorPixelIDTypeList;
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 3 > ();
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 2 > ();


  using VectorByComponentsPixelIDTypeList = VectorPixelIDTypeList;
  using VectorByComponentsPixelIDTypeList2 = PixelIDTypeList2;
  using VectorAddressorType = detail::DualExecuteInternalVectorAddressor<MemberFunctionType>;
  this->m_DualMemberFactory->RegisterMemberFunctions< VectorByComponentsPixelIDTypeList, VectorByComponentsPixelIDTypeList2, 3, VectorAddressorType> ();
  this->m_DualMemberFactory->RegisterMemberFunctions< VectorByComponentsPixelIDTypeList, VectorByComponentsPixelIDTypeList2, 2, VectorAddressorType> ();


}

//
// Destructor
//
WarpImageFilter::~WarpImageFilter() = default;

//
// ToString
//
std::string WarpImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::WarpImageFilter\n";
  out << "  Interpolator: ";
  this->ToStringHelper(out, this->m_Interpolator);
  out << std::endl;
  out << "  OutputSize: ";
  this->ToStringHelper(out, this->m_OutputSize);
  out << std::endl;
  out << "  OutputOrigin: ";
  this->ToStringHelper(out, this->m_OutputOrigin);
  out << std::endl;
  out << "  OutputSpacing: ";
  this->ToStringHelper(out, this->m_OutputSpacing);
  out << std::endl;
  out << "  OutputDirection: ";
  this->ToStringHelper(out, this->m_OutputDirection);
  out << std::endl;
  out << "  EdgePaddingValue: ";
  this->ToStringHelper(out, this->m_EdgePaddingValue);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}


//
// Custom Methods
//

void WarpImageFilter::SetOutputParameteresFromImage(const Image & refImage )
{
  this->SetOutputSize( refImage.GetSize() ); this->SetOutputOrigin( refImage.GetOrigin() ); this->SetOutputSpacing( refImage.GetSpacing() );this->SetOutputDirection( refImage.GetDirection() );
}


//
// Execute
//
Image WarpImageFilter::Execute ( const Image & image, const Image & displacementField )
{
  const PixelIDValueEnum type1 = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, displacementField, "displacementField" );
  const PixelIDValueType type2 = displacementField.GetPixelIDValue();

  return this->m_DualMemberFactory->GetMemberFunction( type1, type2, dimension )( &image, &displacementField );
}




//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType, class TImageType2>
Image WarpImageFilter::DualExecuteInternal ( const Image * inImage, const Image * inDisplacementField )
{
  // Define the input and output image types
  using InputImageType = TImageType;
  using InputImageType2 = TImageType2;

  using OutputImageType = InputImageType;



  using FilterType = itk::WarpImageFilter<InputImageType,  OutputImageType, InputImageType2 >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  assert( inDisplacementField != nullptr );
  typename FilterType::DisplacementFieldType::ConstPointer image2 = this->CastImageToITK<typename FilterType::DisplacementFieldType>( *inDisplacementField );
  filter->SetDisplacementField( image2 );


  filter->SetInterpolator( CreateInterpolator( image1.GetPointer(), m_Interpolator ) );
  typename FilterType::SizeType itkVecOutputSize = sitkSTLVectorToITK<typename FilterType::SizeType>( this->GetOutputSize() );
  filter->SetOutputSize( itkVecOutputSize );
  typename FilterType::PointType itkVecOutputOrigin = sitkSTLVectorToITK<typename FilterType::PointType>( this->GetOutputOrigin() );
  filter->SetOutputOrigin( itkVecOutputOrigin );
  typename FilterType::SpacingType itkVecOutputSpacing = sitkSTLVectorToITK<typename FilterType::SpacingType>( this->GetOutputSpacing() );
  filter->SetOutputSpacing( itkVecOutputSpacing );
  filter->SetOutputDirection( sitkSTLToITKDirection<typename FilterType::DirectionType>( this->m_OutputDirection ) );
  filter->SetEdgePaddingValue ( static_cast< typename InputImageType::PixelType> ( this->m_EdgePaddingValue ) );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

//
// Dispatched methods to call DualExecuteInternal on each component of the VectorImage
//
template <class TImageType, class TImageType2> Image
WarpImageFilter::DualExecuteInternalVector ( const Image * inImage, const Image * inDisplacementField )
{
  using VectorInputImageType =  TImageType;
  using ComponentType = typename VectorInputImageType::InternalPixelType;
  using ComponentImageType = typename itk::Image<ComponentType, VectorInputImageType::ImageDimension>;
  // we must define the input and output image types
  // they should be the same as the scalar execute internal method
  using InputImageType = ComponentImageType;
  using InputImageType2 = TImageType2;  // Define output image type
  using OutputImageType = InputImageType;
  // Get the pointer to the ITK image contained in image1
  typename VectorInputImageType::ConstPointer image1 =
    this->CastImageToITK<VectorInputImageType>( *inImage );

  using ComponentExtractorType = itk::VectorIndexSelectionCastImageFilter< VectorInputImageType, ComponentImageType >;
  typename ComponentExtractorType::Pointer extractor = ComponentExtractorType::New();
  extractor->SetInput( image1 );

  using ToVectorFilterType = itk::ComposeImageFilter<OutputImageType>;
  typename ToVectorFilterType::Pointer toVector = ToVectorFilterType::New();

  unsigned int numComps = image1->GetNumberOfComponentsPerPixel();
  for ( unsigned int i = 0; i < numComps; ++i )
    {
    extractor->SetIndex( i );
    extractor->UpdateLargestPossibleRegion();
    const Image extractImage( extractor->GetOutput() );
    Image tmp = this->DualExecuteInternal<InputImageType,InputImageType2>( &extractImage, inDisplacementField );
    typename OutputImageType::ConstPointer tempITKImage = this->CastImageToITK<OutputImageType>( tmp );

    toVector->SetInput( i, tempITKImage );
    }

  toVector->Update();

  return Image( toVector->GetOutput() );
}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------

//
// Function to run the Execute method of this filter
//
Image Warp ( const Image & image, const Image & displacementField, InterpolatorEnum interpolator, std::vector<uint32_t> outputSize, std::vector<double> outputOrigin, std::vector<double> outputSpacing, std::vector<double> outputDirection, double edgePaddingValue )
{
  WarpImageFilter filter;
  filter.SetInterpolator( interpolator );  filter.SetOutputSize( outputSize );  filter.SetOutputOrigin( outputOrigin );  filter.SetOutputSpacing( outputSpacing );  filter.SetOutputDirection( outputDirection );  filter.SetEdgePaddingValue( edgePaddingValue );
  return filter.Execute ( image, displacementField );
}


}
