/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkRankImageFilter.h"
#include "itkRankImageFilter.h"

// Additional include files
#include "sitkCreateKernel.h"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
RankImageFilter::RankImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();


  using VectorByComponentsPixelIDTypeList = VectorPixelIDTypeList;
  using VectorAddressorType = detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
  this->m_MemberFactory->RegisterMemberFunctions< VectorByComponentsPixelIDTypeList, 2, 3, VectorAddressorType> ();
}

//
// Destructor
//
RankImageFilter::~RankImageFilter() = default;



//
// ToString
//
std::string RankImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::RankImageFilter\n";
  out << "  Rank: ";
  this->ToStringHelper(out, this->m_Rank);
  out << std::endl;
  out << "  Radius: ";
  this->ToStringHelper(out, this->m_Radius);
  out << std::endl;
  out << "  KernelType: ";
  this->ToStringHelper(out, this->m_KernelType);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image RankImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image RankImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  using OutputImageType = InputImageType;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::RankImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  filter->SetRank ( this->m_Rank );
  
  auto kernel = CreateKernel<InputImageType::ImageDimension>( m_KernelType, m_Radius );
  filter->SetKernel( kernel );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------

//
// Dispatched methods to call ExecuteInternal on each component of the VectorImage
//
template <class TImageType> Image RankImageFilter::ExecuteInternalVectorImage ( const Image& inImage1 )
{
  using VectorInputImageType = TImageType;
  using ComponentType = typename VectorInputImageType::InternalPixelType;
  using ComponentImageType = typename itk::Image<ComponentType, VectorInputImageType::ImageDimension>;

  // we must define the input and output image types should be the
  // same as the scalar execute internal method
  using InputImageType = ComponentImageType;
  // Define output image type
  using OutputImageType = InputImageType;
  // Get the pointer to the ITK image contained in image1
  typename VectorInputImageType::ConstPointer image1 =
    this->CastImageToITK<VectorInputImageType>( inImage1 );

  using ComponentExtractorType = itk::VectorIndexSelectionCastImageFilter< VectorInputImageType, ComponentImageType >;
  typename ComponentExtractorType::Pointer extractor = ComponentExtractorType::New();
  extractor->SetInput( image1 );

  using ToVectorFilterType = itk::ComposeImageFilter<OutputImageType>;
  typename ToVectorFilterType::Pointer toVector = ToVectorFilterType::New();

  unsigned int numComps = image1->GetNumberOfComponentsPerPixel();
  for ( unsigned int i = 0; i < numComps; ++i )
    {
    extractor->SetIndex( i );
    extractor->UpdateLargestPossibleRegion();

    Image tmp = this->ExecuteInternal<InputImageType>( Image( extractor->GetOutput() ) );

    typename OutputImageType::ConstPointer tempITKImage = this->CastImageToITK<OutputImageType>( tmp );

    toVector->SetInput( i, tempITKImage );
    }

  toVector->Update();

  return Image( toVector->GetOutput() );
}

//-----------------------------------------------------------------------------

//
// Function to run the Execute method of this filter
//
Image Rank ( const Image& image1, double rank, std::vector<unsigned int> radius, KernelEnum kernelType )
{
  RankImageFilter filter;
  filter.SetRank( rank );  filter.SetRadius( radius );  filter.SetKernelType( kernelType );
  return filter.Execute ( image1 );
}


}
