/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkNotEqualImageFilter.h"
#include "itkBinaryFunctorImageFilter.h"

// Additional include files
#include "itkLogicOpsFunctors.h"
// Done with additional include files
#include "sitkToPixelType.hxx"

namespace itk::simple {


//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
NotEqualImageFilter::NotEqualImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();




  this->m_MemberFactory1.reset( new detail::MemberFunctionFactory<MemberFunction1Type>( this ) );
  this->m_MemberFactory1->RegisterMemberFunctions< PixelIDTypeList, 3 > ();
  this->m_MemberFactory1->RegisterMemberFunctions< PixelIDTypeList, 2 > ();

  this->m_MemberFactory2.reset( new detail::MemberFunctionFactory<MemberFunction2Type>( this ) );
  this->m_MemberFactory2->RegisterMemberFunctions< PixelIDTypeList, 3 > ();
  this->m_MemberFactory2->RegisterMemberFunctions< PixelIDTypeList, 2 > ();
}


//
// Destructor
//
NotEqualImageFilter::~NotEqualImageFilter() = default;




//
// ToString
//
std::string NotEqualImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::NotEqualImageFilter\n";
  out << "  BackgroundValue: ";
  this->ToStringHelper(out, this->m_BackgroundValue);
  out << std::endl;
  out << "  ForegroundValue: ";
  this->ToStringHelper(out, this->m_ForegroundValue);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//

Image NotEqualImageFilter::Execute ( const Image& image1, double constant, uint8_t backgroundValue, uint8_t foregroundValue )
{
  this->SetBackgroundValue ( backgroundValue );
  this->SetForegroundValue ( foregroundValue );

return this->Execute ( image1, constant );
}


Image NotEqualImageFilter::Execute ( double constant, const Image& image2, uint8_t backgroundValue, uint8_t foregroundValue )
{
  this->SetBackgroundValue ( backgroundValue );
  this->SetForegroundValue ( foregroundValue );

return this->Execute ( constant, image2 );
}




Image NotEqualImageFilter::Execute ( const Image& image1, const Image& image2 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();
  CheckImageMatchingDimension( image1, image2, "image2" );
  CheckImageMatchingPixelType( image1, image2, "image2" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1, image2 );
}
Image NotEqualImageFilter::Execute ( Image&& image1, const Image& image2 )
{
  Image &temp = image1;
  auto autoResetInPlace = make_scope_exit([this, &temp]{this->m_InPlace=false; Image moved(std::move(temp));});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( image1, image2 );
}

Image NotEqualImageFilter::Execute ( double constant, const Image& image2 )
{

  PixelIDValueEnum type = image2.GetPixelID();
  unsigned int dimension = image2.GetDimension();

  return this->m_MemberFactory1->GetMemberFunction( type, dimension )( constant, image2 );
}

Image NotEqualImageFilter::Execute ( const Image& image1, double constant )
{

  PixelIDValueEnum type = image1.GetPixelID();
  unsigned int dimension = image1.GetDimension();


  return this->m_MemberFactory2->GetMemberFunction( type, dimension )( image1, constant );
}


Image NotEqualImageFilter::Execute ( Image&& image1, double constant )
{
  const Image temp(std::move(image1));
  auto autoResetInPlace = make_scope_exit([this]{this->m_InPlace=false;});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( temp, constant );

}


//-----------------------------------------------------------------------------

//
// ExecuteInternal
//
template <class TImageType>
Image NotEqualImageFilter::ExecuteInternal ( const Image& inImage1, const Image& inImage2 )
{
  // Define the input and output image types
  using InputImageType = TImageType;

  using InputImageType2 = TImageType;

  // Define output image type
  using OutputImageType = itk::Image< uint8_t, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );
  // Get the a pointer to the ITK image contained in image2
  typename InputImageType2::ConstPointer image2 = this->CastImageToITK<InputImageType2>( inImage2 );


  using FilterType = itk::BinaryFunctorImageFilter<InputImageType,InputImageType2,OutputImageType, itk::Functor::NotEqual< typename InputImageType::PixelType, typename InputImageType2::PixelType, typename OutputImageType::PixelType> >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );
  filter->SetInput( 1, image2 );



  filter->GetFunctor().SetBackgroundValue( static_cast<typename OutputImageType::PixelType>( this->m_BackgroundValue ) );
  filter->GetFunctor().SetForegroundValue( static_cast<typename OutputImageType::PixelType>( this->m_ForegroundValue ) );
  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}


template <class TImageType>
Image NotEqualImageFilter::ExecuteInternal ( double constant, const Image& inImage2 )
{
  // Define the input and output image types
  using InputImageType = TImageType;

  using InputImageType2 = TImageType;

  // Define output image type
  using OutputImageType = itk::Image< uint8_t, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image2
  typename InputImageType2::ConstPointer image2 = this->CastImageToITK<InputImageType2>( inImage2 );

  using FilterType = itk::BinaryFunctorImageFilter<InputImageType,InputImageType2,OutputImageType, itk::Functor::NotEqual< typename InputImageType::PixelType, typename InputImageType2::PixelType, typename OutputImageType::PixelType> >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  typename InputImageType::PixelType c;
  NumericTraits<typename InputImageType2::PixelType>::SetLength( c, image2->GetNumberOfComponentsPerPixel() );
  ToPixelType( constant, c );
  filter->SetConstant1( c );
  filter->SetInput2( image2 );

  filter->GetFunctor().SetBackgroundValue( static_cast<typename OutputImageType::PixelType>( this->m_BackgroundValue ) );
  filter->GetFunctor().SetForegroundValue( static_cast<typename OutputImageType::PixelType>( this->m_ForegroundValue ) );
  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}


template <class TImageType>
Image NotEqualImageFilter::ExecuteInternal ( const Image& inImage1, double constant )
{
  // Define the input and output image types
  using InputImageType = TImageType;

  using InputImageType2 = TImageType;

  // Define output image type
  using OutputImageType = itk::Image< uint8_t, InputImageType::ImageDimension >;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );

  using FilterType = itk::BinaryFunctorImageFilter<InputImageType,InputImageType2,OutputImageType, itk::Functor::NotEqual< typename InputImageType::PixelType, typename InputImageType2::PixelType, typename OutputImageType::PixelType> >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  typename InputImageType2::PixelType c;
  NumericTraits<typename InputImageType::PixelType>::SetLength( c, image1->GetNumberOfComponentsPerPixel() );
  ToPixelType( constant, c );
  filter->SetInput1( image1 );
  filter->SetConstant2( c );

  filter->GetFunctor().SetBackgroundValue( static_cast<typename OutputImageType::PixelType>( this->m_BackgroundValue ) );
  filter->GetFunctor().SetForegroundValue( static_cast<typename OutputImageType::PixelType>( this->m_ForegroundValue ) );
  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image NotEqual ( const Image& image1, const Image& image2, uint8_t backgroundValue, uint8_t foregroundValue )
{
  NotEqualImageFilter filter;
  filter.SetBackgroundValue( backgroundValue );  filter.SetForegroundValue( foregroundValue );
  return filter.Execute ( image1, image2 );
}
//
// Function to run the Execute method of this filter
//
Image NotEqual ( Image&& image1, const Image& image2, uint8_t backgroundValue, uint8_t foregroundValue )
{
  NotEqualImageFilter filter;
  filter.SetBackgroundValue( backgroundValue );  filter.SetForegroundValue( foregroundValue );
  return filter.Execute ( std::move(image1), image2 );
}

Image NotEqual ( const Image& image1, double constant, uint8_t backgroundValue, uint8_t foregroundValue )
{
  NotEqualImageFilter filter;

  return filter.Execute ( image1, constant, backgroundValue, foregroundValue );
}


Image NotEqual ( Image&& image1, double constant, uint8_t backgroundValue, uint8_t foregroundValue )
{
  NotEqualImageFilter filter;
  return filter.Execute ( std::move(image1), constant, backgroundValue, foregroundValue );
}

Image NotEqual ( double constant, const Image& image2, uint8_t backgroundValue, uint8_t foregroundValue )
{
  NotEqualImageFilter filter;
  return filter.Execute ( constant, image2, backgroundValue, foregroundValue );
}

}
