/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkMaskNegatedImageFilter.h"
#include "itkMaskNegatedImageFilter.h"

// Additional include files
#include "sitkToPixelType.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
MaskNegatedImageFilter::MaskNegatedImageFilter ()
{

  this->m_DualMemberFactory.reset( new detail::DualMemberFunctionFactory<MemberFunctionType>( this ) );
  using PixelIDTypeList2 = MaskedPixelIDTypeList;
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 3 > ();
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 2 > ();





}

//
// Destructor
//
MaskNegatedImageFilter::~MaskNegatedImageFilter() = default;

//
// ToString
//
std::string MaskNegatedImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::MaskNegatedImageFilter\n";
  out << "  OutsideValue: ";
  this->ToStringHelper(out, this->m_OutsideValue);
  out << std::endl;
  out << "  MaskingValue: ";
  this->ToStringHelper(out, this->m_MaskingValue);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}



//
// Execute
//
Image MaskNegatedImageFilter::Execute ( const Image & image, const Image & maskImage )
{
  const PixelIDValueEnum type1 = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, maskImage, "maskImage" );
  CheckImageMatchingSize(  image, maskImage, "maskImage" );
  const PixelIDValueType type2 = maskImage.GetPixelIDValue();

  return this->m_DualMemberFactory->GetMemberFunction( type1, type2, dimension )( &image, &maskImage );
}

Image MaskNegatedImageFilter::Execute ( Image && image, const Image & maskImage )
{
  Image &temp = image;
  auto autoResetInPlace = make_scope_exit([this, &temp]{this->m_InPlace=false; Image moved(std::move(temp));});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( image, maskImage );
}


//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType, class TImageType2>
Image MaskNegatedImageFilter::DualExecuteInternal ( const Image * inImage, const Image * inMaskImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;
  using InputImageType2 = TImageType2;

  using OutputImageType = InputImageType;



  using FilterType =  itk::MaskNegatedImageFilter<InputImageType, InputImageType2,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  assert( inMaskImage != nullptr );
  typename FilterType::MaskImageType::ConstPointer image2 = this->CastImageToITK<typename FilterType::MaskImageType>( *inMaskImage );
  filter->SetMaskImage( image2 );


  typename OutputImageType::PixelType v;  NumericTraits<typename OutputImageType::PixelType>::SetLength( v, image1->GetNumberOfComponentsPerPixel() );  ToPixelType( this->m_OutsideValue, v );  filter->SetOutsideValue( v );
  filter->SetMaskingValue ( this->m_MaskingValue );
  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}




//-----------------------------------------------------------------------------

//
// Function to run the Execute method of this filter
//
Image MaskNegated ( const Image & image, const Image & maskImage, double outsideValue, double maskingValue )
{
  MaskNegatedImageFilter filter;
  filter.SetOutsideValue( outsideValue );  filter.SetMaskingValue( maskingValue );
  return filter.Execute ( image, maskImage );
}
//
// Function to run the Execute method of this filter
//
Image MaskNegated ( Image && image, const Image & maskImage, double outsideValue, double maskingValue )
{
  MaskNegatedImageFilter filter;
  filter.SetOutsideValue( outsideValue );  filter.SetMaskingValue( maskingValue );
  return filter.Execute ( std::move(image), maskImage );
}

}
